import { Emitter } from './monaco-editor';
export class MonacoGraphQLAPI {
    _onDidChange = new Emitter();
    _formattingOptions;
    _modeConfiguration;
    _diagnosticSettings;
    _completionSettings;
    _schemas = null;
    _schemasById = Object.create(null);
    _languageId;
    _externalFragmentDefinitions;
    constructor({ languageId, schemas, modeConfiguration, formattingOptions, diagnosticSettings, completionSettings, }) {
        this._languageId = languageId;
        if (schemas) {
            this.setSchemaConfig(schemas);
        }
        this._modeConfiguration = modeConfiguration;
        this._completionSettings = completionSettings;
        this._diagnosticSettings = diagnosticSettings;
        this._formattingOptions = formattingOptions;
    }
    get onDidChange() {
        return this._onDidChange.event;
    }
    get languageId() {
        return this._languageId;
    }
    get modeConfiguration() {
        return this._modeConfiguration;
    }
    get schemas() {
        return this._schemas;
    }
    schemasById() {
        return this._schemasById;
    }
    get formattingOptions() {
        return this._formattingOptions;
    }
    get diagnosticSettings() {
        return this._diagnosticSettings;
    }
    get completionSettings() {
        return {
            ...this._completionSettings,
            fillLeafsOnComplete: this._completionSettings.__experimental__fillLeafsOnComplete ??
                this._completionSettings.fillLeafsOnComplete,
        };
    }
    get externalFragmentDefinitions() {
        return this._externalFragmentDefinitions;
    }
    setSchemaConfig(schemas) {
        this._schemas = schemas;
        this._schemasById = schemas.reduce((result, schema) => {
            result[schema.uri] = schema;
            return result;
        }, Object.create(null));
        this._onDidChange.fire(this);
    }
    setExternalFragmentDefinitions(externalFragmentDefinitions) {
        this._externalFragmentDefinitions = externalFragmentDefinitions;
    }
    setModeConfiguration(modeConfiguration) {
        this._modeConfiguration = modeConfiguration;
        this._onDidChange.fire(this);
    }
    setFormattingOptions(formattingOptions) {
        this._formattingOptions = formattingOptions;
        this._onDidChange.fire(this);
    }
    setDiagnosticSettings(diagnosticSettings) {
        this._diagnosticSettings = diagnosticSettings;
        this._onDidChange.fire(this);
    }
    setCompletionSettings(completionSettings) {
        this._completionSettings = completionSettings;
        this._onDidChange.fire(this);
    }
}
export function create(languageId, config) {
    if (!config) {
        return new MonacoGraphQLAPI({
            languageId,
            schemas: [],
            formattingOptions: formattingDefaults,
            modeConfiguration: modeConfigurationDefault,
            diagnosticSettings: diagnosticSettingDefault,
            completionSettings: completionSettingDefault,
        });
    }
    const { schemas, formattingOptions, modeConfiguration, diagnosticSettings, completionSettings, } = config;
    return new MonacoGraphQLAPI({
        languageId,
        schemas,
        formattingOptions: {
            ...formattingDefaults,
            ...formattingOptions,
            prettierConfig: {
                ...formattingDefaults.prettierConfig,
                ...formattingOptions?.prettierConfig,
            },
        },
        modeConfiguration: {
            ...modeConfigurationDefault,
            ...modeConfiguration,
        },
        diagnosticSettings: {
            ...diagnosticSettingDefault,
            ...diagnosticSettings,
        },
        completionSettings: {
            ...completionSettingDefault,
            ...completionSettings,
        },
    });
}
export const modeConfigurationDefault = {
    documentFormattingEdits: true,
    documentRangeFormattingEdits: false,
    completionItems: true,
    hovers: true,
    documentSymbols: false,
    tokens: false,
    colors: false,
    foldingRanges: false,
    diagnostics: true,
    selectionRanges: false,
};
export const formattingDefaults = {
    prettierConfig: {
        tabWidth: 2,
    },
};
export const diagnosticSettingDefault = {
    jsonDiagnosticSettings: {
        schemaValidation: 'error',
    },
};
export const completionSettingDefault = {
    __experimental__fillLeafsOnComplete: false,
};
//# sourceMappingURL=api.js.map