import { GraphQLWorker } from './GraphQLWorker';
import type { MonacoGraphQLAPI } from './api';
import type * as monaco from './monaco-editor';
import { Uri, languages } from './monaco-editor';
import { editor } from 'monaco-editor/esm/vs/editor/editor.api';
import { CompletionItemKind as lsCompletionItemKind } from 'graphql-language-service';
import { GraphQLWorkerCompletionItem } from './utils';
export interface WorkerAccessor {
    (...more: Uri[]): monaco.Thenable<GraphQLWorker>;
}
export declare class DiagnosticsAdapter {
    private defaults;
    private _worker;
    private _disposables;
    private _listener;
    constructor(defaults: MonacoGraphQLAPI, _worker: WorkerAccessor);
    dispose(): void;
    private _doValidate;
}
export declare function toCompletionItemKind(kind: lsCompletionItemKind): languages.CompletionItemKind;
export declare function toCompletion(entry: GraphQLWorkerCompletionItem): languages.CompletionItem;
export declare class CompletionAdapter implements languages.CompletionItemProvider {
    private _worker;
    constructor(_worker: WorkerAccessor);
    get triggerCharacters(): string[];
    provideCompletionItems(model: editor.IReadOnlyModel, position: monaco.Position, _context: languages.CompletionContext, _token: monaco.CancellationToken): Promise<languages.CompletionList>;
}
export declare class DocumentFormattingAdapter implements languages.DocumentFormattingEditProvider {
    private _worker;
    constructor(_worker: WorkerAccessor);
    provideDocumentFormattingEdits(document: editor.ITextModel, _options: languages.FormattingOptions, _token: monaco.CancellationToken): Promise<{
        range: monaco.Range;
        text: string;
    }[]>;
}
export declare class HoverAdapter implements languages.HoverProvider {
    private _worker;
    constructor(_worker: WorkerAccessor);
    provideHover(model: editor.IReadOnlyModel, position: monaco.Position, _token: monaco.CancellationToken): Promise<languages.Hover>;
    dispose(): void;
}
//# sourceMappingURL=languageFeatures.d.ts.map