import { buildClientSchema, buildASTSchema } from 'graphql';
export const defaultSchemaLoader = (schemaConfig, parser) => {
    const { schema, documentAST, introspectionJSON, introspectionJSONString, buildSchemaOptions, documentString, } = schemaConfig;
    if (schema) {
        return schema;
    }
    if (introspectionJSONString) {
        const introspectionJSONResult = JSON.parse(introspectionJSONString);
        return buildClientSchema(introspectionJSONResult, buildSchemaOptions);
    }
    if (documentString && parser) {
        const docAST = parser(documentString);
        return buildASTSchema(docAST, buildSchemaOptions);
    }
    if (introspectionJSON) {
        return buildClientSchema(introspectionJSON, buildSchemaOptions);
    }
    if (documentAST) {
        return buildASTSchema(documentAST, buildSchemaOptions);
    }
    throw new Error('No schema supplied');
};
//# sourceMappingURL=schemaLoader.js.map