import { SchemaConfig } from './typings';
import type { IRange as GraphQLRange, IPosition as GraphQLPosition, Diagnostic, CompletionItem as GraphQLCompletionItem } from 'graphql-language-service';
import type * as monaco from './monaco-editor';
export declare const getModelLanguageId: (model: monaco.editor.ITextModel) => any;
export declare function toMonacoRange(range: GraphQLRange): monaco.IRange;
export declare function toGraphQLPosition(position: monaco.Position): GraphQLPosition;
export declare type GraphQLWorkerCompletionItem = Omit<GraphQLCompletionItem, 'documentation'> & {
    range?: monaco.IRange;
    command?: monaco.languages.CompletionItem['command'];
    documentation?: monaco.languages.CompletionItem['documentation'];
};
export declare function toCompletion(entry: GraphQLCompletionItem, range?: GraphQLRange): GraphQLWorkerCompletionItem;
export declare function toMonacoSeverity(severity?: Diagnostic['severity']): monaco.MarkerSeverity;
export declare function toMarkerData(diagnostic: Diagnostic): monaco.editor.IMarkerData;
export declare const getStringSchema: (schemaConfig: SchemaConfig) => {
    documentString: string;
    uri: string;
    fileMatch?: string[] | undefined;
    buildSchemaOptions?: import("graphql").BuildSchemaOptions | undefined;
    customScalarSchemas?: Record<string, import("json-schema").JSONSchema6> | undefined;
} | {
    introspectionJSONString: string;
    uri: string;
    fileMatch?: string[] | undefined;
    buildSchemaOptions?: import("graphql").BuildSchemaOptions | undefined;
    customScalarSchemas?: Record<string, import("json-schema").JSONSchema6> | undefined;
};
//# sourceMappingURL=utils.d.ts.map