# Contributing to Mongojs

  :+1::tada: First off, thanks for taking the time to contribute! :tada::+1:

The following is a set of guidelines for contributing to mongojs.
These are just guidelines, not rules, use your best judgment and feel free to
propose changes to this document in a pull request.

  This project adheres to the [Open Code of Conduct][code-of-conduct]. By participating, you are expected to uphold this code.
  [code-of-conduct]: http://todogroup.org/opencodeofconduct/#mongojs/mathiasbuus@gmail.com

## Submitting Issues

* You can create an issue [here](https://github.com/mafintosh/mongojs/issues/new), but
before doing that please read the notes below on debugging and submitting issues,
  and include as many details as possible with your report.
* Include the version of mongojs you are using.
* Include the version of mongodb you are using and the OS.
* Include some source code snippet to demo the issue
* Include a stack trace and error message if applicable

## Pull Requests

* Follow the [Standard](https://github.com/feross/standard) style.
* Include tests in the `test` directory.
* Update `README.md` if your pull request adds/changes functionality

## Git Commit Messages

* Use the present tense ("Add feature" not "Added feature")
* Use the imperative mood ("Open database when..." not "Opens database when...")
* Limit the first line to 72 characters or less
* Reference issues and pull requests liberally
* Consider starting the commit message with an applicable emoji:
    * :art: `:art:` when improving the format/structure of the code
    * :racehorse: `:racehorse:` when improving performance
    * :non-potable_water: `:non-potable_water:` when plugging memory leaks
    * :memo: `:memo:` when writing docs
    * :bug: `:bug:` when fixing a bug
    * :fire: `:fire:` when removing code or files
    * :green_heart: `:green_heart:` when fixing the CI build
    * :white_check_mark: `:white_check_mark:` when adding tests
    * :lock: `:lock:` when dealing with security
    * :arrow_up: `:arrow_up:` when upgrading dependencies
    * :arrow_down: `:arrow_down:` when downgrading dependencies
    * :shirt: `:shirt:` when removing linter warnings