'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

const isNumber = (value) => typeof value === "number";
const isString = (value) => typeof value === "string";
const isEasingGenerator = (easing) => typeof easing === "object" &&
    Boolean(easing.createAnimation);
const isCubicBezier = (easing) => Array.isArray(easing) && isNumber(easing[0]);
const isEasingList = (easing) => Array.isArray(easing) && !isNumber(easing[0]);

exports.isCubicBezier = isCubicBezier;
exports.isEasingGenerator = isEasingGenerator;
exports.isEasingList = isEasingList;
exports.isNumber = isNumber;
exports.isString = isString;
