/*! mp4box 16-03-2016 */

var Log=console;Log.setLogLevel=function(a){};var MP4BoxStream=function(a){if(!(a instanceof ArrayBuffer))throw"Needs an array buffer";this.buffer=a,this.uint8=new Uint8Array(a),this.position=0};MP4BoxStream.prototype.getPosition=function(){return this.position},MP4BoxStream.prototype.getEndPosition=function(){return this.buffer.byteLength},MP4BoxStream.prototype.getLength=function(){return this.buffer.byteLength},MP4BoxStream.prototype.seek=function(a){var b=Math.max(0,Math.min(this.uint8.length,a));this.position=isNaN(b)||!isFinite(b)?0:b},MP4BoxStream.prototype.isEos=function(){return this.getPosition()>=this.getEndPosition()},MP4BoxStream.prototype.readUint8=function(){var a;if(this.position+1<=this.uint8.length)return a=this.uint8[this.position],this.position++,a;throw"Not enough bytes in buffer"},MP4BoxStream.prototype.readUint16=function(){var a,b,c;if(this.position+2<=this.uint8.length)return a=this.uint8[this.position],this.position++,b=this.uint8[this.position],this.position++,c=a<<8|b;throw"Not enough bytes in buffer"},MP4BoxStream.prototype.readUint24=function(){var a;if(this.position+3<=this.uint8.length)return a=this.uint8[this.position]<<16,this.position++,a|=this.uint8[this.position]<<8,this.position++,a|=this.uint8[this.position],this.position++,a;throw"Not enough bytes in buffer"},MP4BoxStream.prototype.readUint32=function(){var a;if(this.position+4<=this.uint8.length)return a=this.uint8[this.position]<<24,this.position++,a|=this.uint8[this.position]<<16,this.position++,a|=this.uint8[this.position]<<8,this.position++,a|=this.uint8[this.position],this.position++,a;throw"Not enough bytes in buffer"},MP4BoxStream.prototype.readUint64=function(){var a;if(this.position+8<=this.uint8.length)return a=this.readUint32()<<32,a|=this.readUint32();throw"Not enough bytes in buffer"},MP4BoxStream.prototype.readString=function(a){if(this.position+a<=this.uint8.length){for(var b="",c=0;a>c;c++)b+=String.fromCharCode(this.readUint8());return b}throw"Not enough bytes in buffer"},MP4BoxStream.prototype.readCString=function(){for(var a=[];;){var b=this.readUint8();if(0===b)break;a.push(b)}return String.fromCharCode.apply(null,a)},MP4BoxStream.prototype.readInt8=function(){return this.readUint8()},MP4BoxStream.prototype.readInt16=function(){return this.readUint16()},MP4BoxStream.prototype.readInt32=function(){return this.readUint32()},MP4BoxStream.prototype.readUint8Array=function(a){for(var b=[],c=0;a>c;c++)b[c]=this.readUint8();return b},MP4BoxStream.prototype.readInt16Array=function(a){for(var b=[],c=0;a>c;c++)b[c]=this.readUint16();return b},MP4BoxStream.prototype.readUint32Array=function(a){for(var b=[],c=0;a>c;c++)b[c]=this.readUint32();return b},MP4BoxStream.prototype.readInt32Array=function(a){for(var b=[],c=0;a>c;c++)b[c]=this.readInt32();return b};var BoxParser={ERR_NOT_ENOUGH_DATA:0,OK:1,boxCodes:["mdat","idat","free","skip","avcC","hvcC","ftyp","styp","payl","vttC","rtp ","sdp ","btrt","frma","trpy","tpyl","totl","tpay","dmed","dimm","drep","nump","npck","maxr","tmin","tmax","dmax","pmax","payt","vmhd","smhd","hmhd","idat","meco","udta","strk","free","skip"],fullBoxCodes:["mvhd","tkhd","mdhd","hdlr","vmhd","smhd","hmhd","nmhd","url ","urn ","ctts","cslg","stco","co64","stsc","stss","stsz","stz2","stts","stsh","mehd","trex","mfhd","tfhd","trun","tfdt","esds","subs","txtC","sidx","emsg","prft","pssh","elst","dref","url ","urn ","sbgp","sgpd","cprt","iods","ssix","tfra","mfro","pdin","tsel","trep","leva","stri","stsg","schm","stvi","padb","stdp","sdtp","saio","saiz","meta","xml ","bxml","iloc","pitm","ipro","iinf","infe","iref","mere","kind","elng"],containerBoxCodes:[["moov",["trak","sidx"]],["trak"],["edts"],["mdia"],["minf"],["dinf"],["stbl",["sgpd"]],["mvex",["trex"]],["moof",["traf"]],["traf",["trun"]],["vttc"],["tref"],["iref"],["udta"],["mfra"],["meco"],["hnti"],["hinf"],["strk"],["strd"],["sinf"],["rinf"],["schi"],["trgr"],["udta",["kind"]],["iprp"]],sampleEntryCodes:[{prefix:"Visual",types:["mp4v","avc1","avc2","avc3","avc4","avcp","drac","encv","mjp2","mvc1","mvc2","resv","s263","svc1","vc-1","hvc1","hev1"]},{prefix:"Audio",types:["mp4a","ac-3","alac","dra1","dtsc","dtse",,"dtsh","dtsl","ec-3","enca","g719","g726","m4ae","mlpa","raw ","samr","sawb","sawp","sevc","sqcp","ssmv","twos",".mp3"]},{prefix:"Hint",types:["fdp ","m2ts","pm2t","prtp","rm2t","rrtp","rsrp","rtp ","sm2t","srtp"]},{prefix:"Metadata",types:["metx","mett","urim"]},{prefix:"Subtitle",types:["stpp","wvtt","sbtt","tx3g","stxt"]},{prefix:"System",types:["mp4s"]}],sampleGroupEntryCodes:["roll","prol","alst","rap ","tele","avss","avll","sync","tscl","tsas","stsa","scif","mvif","scnm","dtrt","vipr","tele","rash"],trackGroupTypes:["msrc"],initialize:function(){var a,b,c;for(BoxParser.FullBox.prototype=new BoxParser.Box,BoxParser.ContainerBox.prototype=new BoxParser.Box,BoxParser.SampleEntry.prototype=new BoxParser.FullBox,BoxParser.TrackGroupTypeBox.prototype=new BoxParser.FullBox,c=BoxParser.boxCodes.length,a=0;c>a;a++)BoxParser[BoxParser.boxCodes[a]+"Box"]=function(a){return function(b){BoxParser.Box.call(this,BoxParser.boxCodes[a],b)}}(a),BoxParser[BoxParser.boxCodes[a]+"Box"].prototype=new BoxParser.Box;for(c=BoxParser.fullBoxCodes.length,a=0;c>a;a++)BoxParser[BoxParser.fullBoxCodes[a]+"Box"]=function(a){return function(b){BoxParser.FullBox.call(this,BoxParser.fullBoxCodes[a],b)}}(a),BoxParser[BoxParser.fullBoxCodes[a]+"Box"].prototype=new BoxParser.FullBox;for(c=BoxParser.containerBoxCodes.length,a=0;c>a;a++)BoxParser[BoxParser.containerBoxCodes[a][0]+"Box"]=function(a,b){return function(c){if(BoxParser.ContainerBox.call(this,BoxParser.containerBoxCodes[a][0],c),b){this.subBoxNames=b;for(var d=b.length,e=0;d>e;e++)this[b[e]+"s"]=[]}}}(a,BoxParser.containerBoxCodes[a][1]),BoxParser[BoxParser.containerBoxCodes[a][0]+"Box"].prototype=new BoxParser.ContainerBox;for(c=BoxParser.sampleEntryCodes.length,b=0;c>b;b++){var d=BoxParser.sampleEntryCodes[b].prefix,e=BoxParser.sampleEntryCodes[b].types,f=e.length;for(BoxParser[d+"SampleEntry"]=function(a,b){BoxParser.SampleEntry.call(this,a,b)},BoxParser[d+"SampleEntry"].prototype=new BoxParser.SampleEntry,a=0;f>a;a++)BoxParser[e[a]+"SampleEntry"]=function(a,b){return function(c){BoxParser[BoxParser.sampleEntryCodes[a].prefix+"SampleEntry"].call(this,BoxParser.sampleEntryCodes[a].types[b],c)}}(b,a),BoxParser[e[a]+"SampleEntry"].prototype=new BoxParser[d+"SampleEntry"]}for(c=BoxParser.sampleGroupEntryCodes.length,a=0;c>a;a++)BoxParser[BoxParser.sampleGroupEntryCodes[a]+"SampleGroupEntry"]=function(a){return function(b){BoxParser.SampleGroupEntry.call(this,BoxParser.sampleGroupEntryCodes[a],b)}}(a),BoxParser[BoxParser.sampleGroupEntryCodes[a]+"SampleGroupEntry"].prototype=new BoxParser.SampleGroupEntry;for(c=BoxParser.trackGroupTypes.length,a=0;c>a;a++)BoxParser[BoxParser.trackGroupTypes[a]+"Box"]=function(a){return function(b){BoxParser.TrackGroupTypeBox.call(this,BoxParser.trackGroupTypes[a],b)}}(a),BoxParser[BoxParser.trackGroupTypes[a]+"Box"].prototype=new BoxParser.TrackGroupTypeBox},Box:function(a,b){this.type=a,this.size=b},FullBox:function(a,b){BoxParser.Box.call(this,a,b),this.flags=0,this.version=0},ContainerBox:function(a,b){BoxParser.Box.call(this,a,b),this.boxes=[]},SampleEntry:function(a,b,c,d){BoxParser.Box.call(this,a,b),this.hdr_size=c,this.start=d,this.boxes=[]},SampleGroupEntry:function(a){this.grouping_type=a},TrackGroupTypeBox:function(a,b){BoxParser.FullBox.call(this,a,b)}};BoxParser.initialize(),BoxParser.TKHD_FLAG_ENABLED=1,BoxParser.TKHD_FLAG_IN_MOVIE=2,BoxParser.TKHD_FLAG_IN_PREVIEW=4,BoxParser.TFHD_FLAG_BASE_DATA_OFFSET=1,BoxParser.TFHD_FLAG_SAMPLE_DESC=2,BoxParser.TFHD_FLAG_SAMPLE_DUR=8,BoxParser.TFHD_FLAG_SAMPLE_SIZE=16,BoxParser.TFHD_FLAG_SAMPLE_FLAGS=32,BoxParser.TFHD_FLAG_DUR_EMPTY=65536,BoxParser.TFHD_FLAG_DEFAULT_BASE_IS_MOOF=131072,BoxParser.TRUN_FLAGS_DATA_OFFSET=1,BoxParser.TRUN_FLAGS_FIRST_FLAG=4,BoxParser.TRUN_FLAGS_DURATION=256,BoxParser.TRUN_FLAGS_SIZE=512,BoxParser.TRUN_FLAGS_FLAGS=1024,BoxParser.TRUN_FLAGS_CTS_OFFSET=2048,"undefined"!=typeof exports&&(exports.BoxParser=BoxParser),BoxParser.parseOneBox=function(a,b){var c,d,e=a.getPosition(),f=0;if(a.getEndPosition()-e<8)return Log.debug("BoxParser","Not enough data in stream to parse the type and size of the box"),{code:BoxParser.ERR_NOT_ENOUGH_DATA};var g=a.readUint32(),h=a.readString(4);if(Log.debug("BoxParser","Found box of type "+h+" and size "+g+" at position "+e),f=8,"uuid"==h&&(d=a.readUint8Array(16),f+=16),1==g){if(a.getEndPosition()-a.getPosition()<8)return a.seek(e),Log.warn("BoxParser",'Not enough data in stream to parse the extended size of the "'+h+'" box'),{code:BoxParser.ERR_NOT_ENOUGH_DATA};g=a.readUint64(),f+=8}else if(0===g&&"mdat"!==h)throw"Unlimited box size not supported";return e+g>a.getEndPosition()?(a.seek(e),Log.warn("BoxParser",'Not enough data in stream to parse the entire "'+h+'" box'),{code:BoxParser.ERR_NOT_ENOUGH_DATA,type:h,size:g,hdr_size:f,start:e}):b?{code:BoxParser.OK,type:h,size:g,hdr_size:f,start:e}:(BoxParser[h+"Box"]?c=new BoxParser[h+"Box"](g):("uuid"!==h&&Log.warn("BoxParser","Unknown box type: "+h),c=new BoxParser.Box(h,g),d&&(c.uuid=d)),c.hdr_size=f,c.start=e,c.write===BoxParser.Box.prototype.write&&"mdat"!==c.type&&(Log.warn("BoxParser",c.type+" box writing not yet implemented, keeping unparsed data in memory for later write"),c.parseDataAndRewind(a)),c.parse(a),{code:BoxParser.OK,box:c,size:g})},BoxParser.Box.prototype.parse=function(a){"mdat"!=this.type?this.data=a.readUint8Array(this.size-this.hdr_size):0===this.size?a.seek(a.getEndPosition()):a.seek(this.start+this.size)},BoxParser.Box.prototype.parseDataAndRewind=function(a){this.data=a.readUint8Array(this.size-this.hdr_size),a.position-=this.size-this.hdr_size},BoxParser.FullBox.prototype.parseDataAndRewind=function(a){this.parseFullHeader(a),this.data=a.readUint8Array(this.size-this.hdr_size),this.hdr_size-=4,a.position-=this.size-this.hdr_size},BoxParser.FullBox.prototype.parseFullHeader=function(a){this.version=a.readUint8(),this.flags=a.readUint24(),this.hdr_size+=4},BoxParser.FullBox.prototype.parse=function(a){this.parseFullHeader(a),this.data=a.readUint8Array(this.size-this.hdr_size)},BoxParser.ContainerBox.prototype.parse=function(a){for(var b,c;a.getPosition()<this.start+this.size;)b=BoxParser.parseOneBox(a,!1),c=b.box,this.boxes.push(c),this.subBoxNames&&-1!=this.subBoxNames.indexOf(c.type)?this[this.subBoxNames[this.subBoxNames.indexOf(c.type)]+"s"].push(c):this[c.type]=c},BoxParser.Box.prototype.parseLanguage=function(a){this.language=a.readUint16();var b=[];b[0]=this.language>>10&31,b[1]=this.language>>5&31,b[2]=31&this.language,this.languageString=String.fromCharCode(b[0]+96,b[1]+96,b[2]+96)},BoxParser.emsgBox.prototype.parse=function(a){this.parseFullHeader(a),this.scheme_id_uri=a.readCString(),this.value=a.readCString(),this.timescale=a.readUint32(),this.presentation_time_delta=a.readUint32(),this.event_duration=a.readUint32(),this.id=a.readUint32();var b=this.size-this.hdr_size-(16+(this.scheme_id_uri.length+1)+(this.value.length+1));this.message_data=a.readUint8Array(b)},BoxParser.stypBox.prototype.parse=function(a){BoxParser.ftypBox.prototype.parse.call(this,a)},BoxParser.ftypBox.prototype.parse=function(a){var b=this.size-this.hdr_size;this.major_brand=a.readString(4),this.minor_version=a.readUint32(),b-=8,this.compatible_brands=[];for(var c=0;b>=4;)this.compatible_brands[c]=a.readString(4),b-=4,c++},BoxParser.mdhdBox.prototype.parse=function(a){this.parseFullHeader(a),1==this.version?(this.creation_time=a.readUint64(),this.modification_time=a.readUint64(),this.timescale=a.readUint32(),this.duration=a.readUint64()):(this.creation_time=a.readUint32(),this.modification_time=a.readUint32(),this.timescale=a.readUint32(),this.duration=a.readUint32()),this.parseLanguage(a),a.readUint16()},BoxParser.mfhdBox.prototype.parse=function(a){this.parseFullHeader(a),this.sequence_number=a.readUint32()},BoxParser.mvhdBox.prototype.parse=function(a){this.flags=0,this.parseFullHeader(a),1==this.version?(this.creation_time=a.readUint64(),this.modification_time=a.readUint64(),this.timescale=a.readUint32(),this.duration=a.readUint64()):(this.creation_time=a.readUint32(),this.modification_time=a.readUint32(),this.timescale=a.readUint32(),this.duration=a.readUint32()),this.rate=a.readUint32(),this.volume=a.readUint16()>>8,a.readUint16(),a.readUint32Array(2),this.matrix=a.readUint32Array(9),a.readUint32Array(6),this.next_track_id=a.readUint32()},BoxParser.sidxBox.prototype.parse=function(a){this.parseFullHeader(a),this.reference_ID=a.readUint32(),this.timescale=a.readUint32(),0===this.version?(this.earliest_presentation_time=a.readUint32(),this.first_offset=a.readUint32()):(this.earliest_presentation_time=a.readUint64(),this.first_offset=a.readUint64()),a.readUint16(),this.references=[];for(var b=a.readUint16(),c=0;b>c;c++){var d={};this.references.push(d);var e=a.readUint32();d.reference_type=e>>31&1,d.referenced_size=2147483647&e,d.subsegment_duration=a.readUint32(),e=a.readUint32(),d.starts_with_SAP=e>>31&1,d.SAP_type=e>>28&7,d.SAP_delta_time=268435455&e}},BoxParser.ssixBox.prototype.parse=function(a){this.parseFullHeader(a),this.subsegments=[];for(var b=a.readUint32(),c=0;b>c;c++){var d={};this.subsegments.push(d),d.ranges=[];for(var e=a.readUint32(),f=0;e>f;f++){var g={};d.ranges.push(g),g.level=a.readUint8(),g.range_size=a.readUint24()}}},BoxParser.tkhdBox.prototype.parse=function(a){this.parseFullHeader(a),1==this.version?(this.creation_time=a.readUint64(),this.modification_time=a.readUint64(),this.track_id=a.readUint32(),a.readUint32(),this.duration=a.readUint64()):(this.creation_time=a.readUint32(),this.modification_time=a.readUint32(),this.track_id=a.readUint32(),a.readUint32(),this.duration=a.readUint32()),a.readUint32Array(2),this.layer=a.readInt16(),this.alternate_group=a.readInt16(),this.volume=a.readInt16()>>8,a.readUint16(),this.matrix=a.readInt32Array(9),this.width=a.readUint32(),this.height=a.readUint32()},BoxParser.tfhdBox.prototype.parse=function(a){var b=0;this.parseFullHeader(a),this.track_id=a.readUint32(),this.size-this.hdr_size>b&&this.flags&BoxParser.TFHD_FLAG_BASE_DATA_OFFSET?(this.base_data_offset=a.readUint64(),b+=8):this.base_data_offset=0,this.size-this.hdr_size>b&&this.flags&BoxParser.TFHD_FLAG_SAMPLE_DESC?(this.default_sample_description_index=a.readUint32(),b+=4):this.default_sample_description_index=0,this.size-this.hdr_size>b&&this.flags&BoxParser.TFHD_FLAG_SAMPLE_DUR?(this.default_sample_duration=a.readUint32(),b+=4):this.default_sample_duration=0,this.size-this.hdr_size>b&&this.flags&BoxParser.TFHD_FLAG_SAMPLE_SIZE?(this.default_sample_size=a.readUint32(),b+=4):this.default_sample_size=0,this.size-this.hdr_size>b&&this.flags&BoxParser.TFHD_FLAG_SAMPLE_FLAGS?(this.default_sample_flags=a.readUint32(),b+=4):this.default_sample_flags=0},BoxParser.tfdtBox.prototype.parse=function(a){this.parseFullHeader(a),1==this.version?this.baseMediaDecodeTime=a.readUint64():this.baseMediaDecodeTime=a.readUint32()},BoxParser.trunBox.prototype.parse=function(a){var b=0;if(this.parseFullHeader(a),this.sample_count=a.readUint32(),b+=4,this.size-this.hdr_size>b&&this.flags&BoxParser.TRUN_FLAGS_DATA_OFFSET?(this.data_offset=a.readInt32(),b+=4):this.data_offset=0,this.size-this.hdr_size>b&&this.flags&BoxParser.TRUN_FLAGS_FIRST_FLAG?(this.first_sample_flags=a.readUint32(),b+=4):this.first_sample_flags=0,this.sample_duration=[],this.sample_size=[],this.sample_flags=[],this.sample_composition_time_offset=[],this.size-this.hdr_size>b)for(var c=0;c<this.sample_count;c++)this.flags&BoxParser.TRUN_FLAGS_DURATION&&(this.sample_duration[c]=a.readUint32()),this.flags&BoxParser.TRUN_FLAGS_SIZE&&(this.sample_size[c]=a.readUint32()),this.flags&BoxParser.TRUN_FLAGS_FLAGS&&(this.sample_flags[c]=a.readUint32()),this.flags&BoxParser.TRUN_FLAGS_CTS_OFFSET&&(0===this.version?this.sample_composition_time_offset[c]=a.readUint32():this.sample_composition_time_offset[c]=a.readInt32())};var ISOFile=function(a){this.stream=a,this.boxes=[],this.mdats=[],this.moofs=[],this.isProgressive=!1,this.moovStartFound=!1};ISOFile.prototype.parse=function(){var a,b,c=!1;if(!this.restoreParsePosition||this.restoreParsePosition())for(;;){if(this.hasIncompleteMdat&&this.hasIncompleteMdat()){if(this.processIncompleteMdat())continue;return}if(this.saveParsePosition&&this.saveParsePosition(),a=BoxParser.parseOneBox(this.stream,c),a.code===BoxParser.ERR_NOT_ENOUGH_DATA){if(this.processIncompleteBox){if(this.processIncompleteBox(a))continue;return}return}switch(b=a.box,this.boxes.push(b),b.type){case"mdat":this.mdats.push(b);break;case"moof":this.moofs.push(b);break;case"moov":this.moovStartFound=!0,0===this.mdats.length&&(this.isProgressive=!0);default:void 0!==this[b.type]&&Log.warn("ISOFile","Duplicate Box of type: "+b.type+", overriding previous occurrence"),this[b.type]=b}this.updateUsedBytes&&this.updateUsedBytes(b,a)}},ISOFile.prototype.getBox=function(a){var b=this.getBoxes(a,!0);return b.length?b[0]:null},ISOFile.prototype.getBoxes=function(a,b){var c=[];return ISOFile._sweep.call(this,a,c,b),c},ISOFile._sweep=function(a,b,c){this.type&&this.type==a&&b.push(this);for(var d in this.boxes){if(b.length&&c)return;ISOFile._sweep.call(this.boxes[d],a,b,c)}},"undefined"!=typeof exports&&(exports.ISOFile=ISOFile);
//# sourceMappingURL=mp4box.simple.min.js.map