"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
var builder = require("menu-builder");

var MenuBuilder = builder.extend({

  buildDOM: function buildDOM() {
    this.on("new:node", this.buildNode);
    this.on("new:button", this.buildButton);
    this.on("new:menu", this.buildMenu);
    return builder.prototype.buildDOM.call(this);
  },

  buildNode: function buildNode(li) {
    if (this.g != null) {
      return li.style.lineHeight = this.g.menuconfig.get("menuItemLineHeight");
    }
  },

  buildButton: function buildButton(btn) {
    if (this.g != null) {
      btn.style.fontSize = this.g.menuconfig.get("menuFontsize");
      btn.style.marginLeft = this.g.menuconfig.get("menuMarginLeft");
      return btn.style.padding = this.g.menuconfig.get("menuPadding");
    }
  },

  buildMenu: function buildMenu(menu) {
    if (this.g != null) {
      return menu.style.fontSize = this.g.menuconfig.get("menuItemFontsize");
    }
  }
});
exports.default = MenuBuilder;