"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});

var memoize = require("lodash.memoize");

var typestyle_1 = require("typestyle");

exports.iconWeights = {
  Regular: 0,
  Light: 1
};
exports.iconTypes = {
  ASD: '"\\e900"',
  Activity: '"\\e344"',
  AddExpression: '"\\e348"',
  AddParticipant: '"\\e131"',
  AddText: '"\\e427"',
  AgentCertification: '"\\e623"',
  Alert: '"\\e625"',
  AlertOff: '"\\e626"',
  AlertOffStatus: '"\\e627"',
  Announcement: '"\\e62b"',
  Approval: '"\\e949"',
  Archive: '"\\e972"',
  At: '"\\e902"',
  AutoTopup: '"\\e50b"',
  AvatarBotCertified: '"\\f121"',
  AvatarBotCertifiedStroke: '"\\f120"',
  AvatarBotMask: '"\\f11e"',
  AvatarBotMaskInversed: '"\\f11f"',
  AvatarBotMaskWithPresence: '"\\f123"',
  AvatarMask: '"\\e21d"',
  Backspace: '"\\e43f"',
  Badge: '"\\e312"',
  BadgeCenter: '"\\e41d"',
  BadgeM2: '"\\e342"',
  Bing: '"\\e015"',
  Birthday: '"\\e303"',
  BlockNotification: '"\\e20d"',
  BlockNotificationLarge: '"\\e20e"',
  Bluetooth: '"\\e409"',
  BluetoothSpeaker: '"\\e424"',
  Board: '"\\e915"',
  Bold: '"\\e931"',
  Bookmark: '"\\e901"',
  Bot: '"\\e21a"',
  BotAdd: '"\\e21b"',
  BotAddS: '"\\e21c"',
  BottomLeft: '"\\f702"',
  BottomRight: '"\\f701"',
  BrokenBroadcast: '"\\e94a"',
  Bug: '"\\e913"',
  Calendar: '"\\e504"',
  CalendarSubscription: '"\\e501"',
  CallAdd: '"\\e128"',
  CallAnimSmall1: '"\\e705"',
  CallAnimSmall2: '"\\e706"',
  CallAnimSmall3: '"\\e707"',
  CallAnimSmall4: '"\\e708"',
  CallBlocked: '"\\e110"',
  CallDisabled: '"\\e117"',
  CallDisabledStatus: '"\\e12a"',
  CallEnd: '"\\e101"',
  CallError: '"\\e111"',
  CallForward: '"\\e112"',
  CallIn: '"\\e10e"',
  CallMissed: '"\\e10d"',
  CallMissedCentered: '"\\e21f"',
  CallOk: '"\\e129"',
  CallOut: '"\\e10f"',
  CallQualityIndicator: '"\\e12c"',
  CallReverse: '"\\e11c"',
  CallStart: '"\\e100"',
  CallStartBig: '"\\e130"',
  CallTransfer: '"\\e11d"',
  CallerID: '"\\e114"',
  Camera: '"\\e40c"',
  Cancel: '"\\e413"',
  Change: '"\\e919"',
  ChannelFollow: '"\\e990"',
  ChannelUnfollow: '"\\e991"',
  ChatDeleted: '"\\e322"',
  ChatFavourite: '"\\e330"',
  ChatFilter: '"\\e32f"',
  ChatOff: '"\\e31d"',
  ChatOk: '"\\e31c"',
  ChevronDown: '"\\e41e"',
  ChevronLeft: '"\\e420"',
  ChevronMedDown: '"\\e447"',
  ChevronMedLeft: '"\\e448"',
  ChevronMedRight: '"\\e449"',
  ChevronMedUp: '"\\e44a"',
  ChevronRight: '"\\e421"',
  ChevronSmallDown: '"\\e44b"',
  ChevronSmallLeft: '"\\e44c"',
  ChevronSmallRight: '"\\e44d"',
  ChevronSmallUp: '"\\e44e"',
  ChevronUp: '"\\e41f"',
  ChromeClose: '"\\e8bb"',
  ChromeMaximize: '"\\e922"',
  ChromeMinimize: '"\\e921"',
  ChromeRestore: '"\\e923"',
  CircleBig: '"\\f100"',
  CircleSmall: '"\\e310"',
  Click: '"\\e95f"',
  Clipboard: '"\\e920"',
  Clippy: '"\\e124"',
  CloudDownload: '"\\e94c"',
  CodeSnippet: '"\\e93a"',
  Collapse: '"\\e94d"',
  Connectors: '"\\e221"',
  Contact: '"\\e200"',
  ContactAdd: '"\\e201"',
  ContactBlocked: '"\\e205"',
  ContactBot: '"\\f126"',
  ContactCard: '"\\e209"',
  ContactCardGroup: '"\\e217"',
  ContactDelete: '"\\e206"',
  ContactGroup: '"\\e20b"',
  ContactGroupAdd: '"\\e20a"',
  ContactGroupCall: '"\\e212"',
  ContactGroupDelete: '"\\e20c"',
  ContactGroupOk: '"\\e210"',
  ContactGroupPair: '"\\e214"',
  ContactGroupPairSmall: '"\\e216"',
  ContactGroupScreenshare: '"\\e213"',
  ContactGroupVideo: '"\\e211"',
  ContactIn: '"\\e208"',
  ContactOk: '"\\e202"',
  ContactPstn: '"\\e219"',
  ContactSend: '"\\e207"',
  ContactSkype: '"\\f125"',
  ContactSkypeOut: '"\\e218"',
  ConversationNew: '"\\e328"',
  CortanaAddToList: '"\\f208"',
  CortanaCalendar: '"\\f200"',
  CortanaCreateAppointment: '"\\f206"',
  CortanaCreateReminder: '"\\f205"',
  CortanaList: '"\\f209"',
  CortanaReminder: '"\\f201"',
  CortanaReminderPerson: '"\\f202"',
  CortanaReminderPlace: '"\\f204"',
  CortanaReminderTime: '"\\f203"',
  CortanaTime: '"\\f207"',
  CurrencyDollar: '"\\e5a2"',
  CurrencyEuro: '"\\e5a3"',
  CurrencyIndianRupee: '"\\e5a8"',
  CurrencyIsraeliSekel: '"\\e5a6"',
  CurrencySaudiRiyal: '"\\e5a7"',
  CurrencySterling: '"\\e5a0"',
  CurrencyTurkishLira: '"\\e5a5"',
  CurrencyYen: '"\\e5a4"',
  Delete: '"\\e42b"',
  Devices: '"\\e61b"',
  Dialpad: '"\\e104"',
  DialpadOff: '"\\e105"',
  Directions: '"\\e509"',
  Display: '"\\e125"',
  Down: '"\\e416"',
  Download: '"\\e33c"',
  DownloadArrow: '"\\e452"',
  Dropdown: '"\\e435"',
  DropdownIconArrow: '"\\e432"',
  DropdownIconBadge: '"\\e431"',
  DropdownIconBg: '"\\e430"',
  DropdownList: '"\\e434"',
  DropdownMenu: '"\\e43d"',
  E989: '"\\e989"',
  Earpiece: '"\\e423"',
  EmoticonStroke: '"\\e30d"',
  Eraser: '"\\e436"',
  Error: '"\\e600"',
  Expand: '"\\e94e"',
  Extension: '"\\e947"',
  Favourite: '"\\e113"',
  FavouriteOn: '"\\e40a"',
  Feedback: '"\\e442"',
  Feedback20px: '"\\e443"',
  FieldError: '"\\e450"',
  FieldSuccess: '"\\e44f"',
  File: '"\\e306"',
  FileAdd: '"\\e983"',
  FileAe: '"\\e96e"',
  FileAi: '"\\e969"',
  FileAudio: '"\\e334"',
  FileBlocked: '"\\e973"',
  FileCode: '"\\e970"',
  FileDeleted: '"\\e31e"',
  FileError: '"\\e31f"',
  FileFl: '"\\e96b"',
  FileFw: '"\\e96c"',
  FileGif: '"\\e337"',
  FileId: '"\\e96d"',
  FileIn: '"\\e307"',
  FileMultiple: '"\\e31a"',
  FileMultipleIn: '"\\e31b"',
  FileOut: '"\\e308"',
  FilePdf: '"\\e335"',
  FilePs: '"\\e96a"',
  FileSearch: '"\\e309"',
  FileSend: '"\\e971"',
  FileSketch: '"\\e96f"',
  FileText: '"\\e33d"',
  FileVideo: '"\\e333"',
  FileZip: '"\\e336"',
  Filter: '"\\e914"',
  FitToWindow: '"\\e97f"',
  Flag: '"\\e917"',
  Flash: '"\\e43b"',
  FlashOff: '"\\e43c"',
  Folder: '"\\e905"',
  FolderAdd: '"\\e906"',
  FolderDown: '"\\e909"',
  FolderFind: '"\\e907"',
  FolderUp: '"\\e908"',
  FontColor: '"\\e930"',
  FontColorA: '"\\e938"',
  FontColorUnderline: '"\\e939"',
  FontSize: '"\\e932"',
  Fork: '"\\e984"',
  Format: '"\\e936"',
  Forward: '"\\e12e"',
  ForwardArrow: '"\\e428"',
  ForwardFilled: '"\\e429"',
  Fullscreen: '"\\e404"',
  FullscreenOff: '"\\e405"',
  GVCFocus: '"\\e134"',
  GVCGrid: '"\\e136"',
  Gif: '"\\e94b"',
  Globe: '"\\e505"',
  Glossary: '"\\e945"',
  Guest: '"\\e985"',
  GuestAdd: '"\\e986"',
  Happy: '"\\e326"',
  Hash: '"\\e327"',
  Headset: '"\\e407"',
  HeadsetOff: '"\\e408"',
  Heart: '"\\e42e"',
  HeartBroken: '"\\e42f"',
  HeartOutline: '"\\e441"',
  Hide: '"\\e426"',
  Highlight: '"\\e934"',
  Highlights: '"\\e135"',
  Home: '"\\e608"',
  Host: '"\\e604"',
  HostOff: '"\\e614"',
  HostOffStatus: '"\\e615"',
  IconSkype: '"\\e001"',
  IconSkypeBgLarge: '"\\e00c"',
  IconSkypeForBusiness: '"\\e013"',
  IconSkypeForBusinessBgLarge: '"\\e00f"',
  IconSkypeForBusinessGlyphLarge: '"\\e010"',
  IconSkypeForBusinessLarge: '"\\e00e"',
  IconSkypeGlyphLarge: '"\\e00d"',
  IconSkypeLarge: '"\\e012"',
  IllustrationAngry: '"\\e630"',
  IllustrationBigsmile: '"\\e62e"',
  IllustrationCalling: '"\\e628"',
  IllustrationLove: '"\\e632"',
  IllustrationMonkey: '"\\e633"',
  IllustrationSad: '"\\e631"',
  IllustrationSurprised: '"\\e62d"',
  IllustrationTMI: '"\\e62f"',
  Info: '"\\e602"',
  InfoCircle: '"\\e451"',
  Insert: '"\\e948"',
  Italics: '"\\e918"',
  Keyboard: '"\\e32e"',
  Landline: '"\\e11e"',
  LandlineAdd: '"\\e118"',
  Leave: '"\\e220"',
  Left: '"\\e418"',
  Like: '"\\e912"',
  Link: '"\\e612"',
  ListNumbered: '"\\e93b"',
  Location: '"\\e610"',
  LogoMicrosoft: '"\\e002"',
  LogoSkypeCloudMedium: '"\\e005"',
  LogoSkypeLarge: '"\\e003"',
  LogoSkypeMedium: '"\\e004"',
  LogoSkypeSmall: '"\\e011"',
  LogoSkypeTextMedium: '"\\e006"',
  MSExcel: '"\\e316"',
  MSOffice: '"\\e014"',
  MSOneDrive: '"\\e00b"',
  MSOneNote: '"\\e319"',
  MSOutlook: '"\\e009"',
  MSPowerPoint: '"\\e317"',
  MSVisio: '"\\e318"',
  MSWindows: '"\\e008"',
  MSWord: '"\\e315"',
  MSXBox: '"\\e00a"',
  MagicWand: '"\\e61c"',
  Mail: '"\\e411"',
  Mask: '"\\e952"',
  Media: '"\\e321"',
  MeetNow: '"\\e911"',
  Meeting: '"\\e503"',
  MeetingPlus: '"\\e50a"',
  Menu: '"\\e30c"',
  MenuCenter: '"\\e41a"',
  MenuList: '"\\e30a"',
  MenuListWithBadge: '"\\e30b"',
  MenuWithBadge: '"\\e314"',
  MenuWithBadgeCenter: '"\\e41b"',
  MergeCalls: '"\\e108"',
  Message: '"\\e300"',
  MessageM2: '"\\e340"',
  MessageQuestion: '"\\e33f"',
  MessageRTL: '"\\e345"',
  MessageRead: '"\\e32c"',
  MessageUnread: '"\\e32b"',
  MessageWithBadge: '"\\e313"',
  MessageWithBadgeCenter: '"\\e41c"',
  MessageWithBadgeM2: '"\\e341"',
  MessageWithBadgeRTL: '"\\e347"',
  Microphone: '"\\e106"',
  MicrophoneConference: '"\\e61f"',
  MicrophoneOff: '"\\e107"',
  MicrophoneOffStatus: '"\\e11a"',
  MicrophoneUsb: '"\\e61e"',
  MicrosoftTeams: '"\\e016"',
  Minus: '"\\e414"',
  Mobile: '"\\e301"',
  MobileError: '"\\e715"',
  MobileOk: '"\\e712"',
  MobileSettings: '"\\e713"',
  MobileSms: '"\\e714"',
  Moji: '"\\f305"',
  MojiDeleted: '"\\f307"',
  MojiEmoticon: '"\\f303"',
  MojiFullStroke: '"\\f30a"',
  MojiMask: '"\\f127"',
  MojiMaskInverted: '"\\f128"',
  MojiMore: '"\\f300"',
  MojiPrevious: '"\\f309"',
  MojiRecent: '"\\f301"',
  More: '"\\e109"',
  MoreFilled: '"\\e94f"',
  MoreVertical: '"\\e325"',
  Move: '"\\e437"',
  Movie: '"\\e42a"',
  Music: '"\\e904"',
  MyLocation: '"\\e622"',
  NavigationBack: '"\\e425"',
  NavigationBackCentered: '"\\e439"',
  NavigationClose: '"\\e440"',
  NavigationForward: '"\\e433"',
  NavigationForwardCentered: '"\\e43a"',
  Network: '"\\e903"',
  Notepad: '"\\e951"',
  Notification: '"\\e60e"',
  NotificationOff: '"\\e60f"',
  NotificationStroke: '"\\e629"',
  Nudge: '"\\e993"',
  Office: '"\\e60c"',
  Ok: '"\\e412"',
  OpenFolder: '"\\e223"',
  OriginalSize: '"\\e980"',
  Outline: '"\\e941"',
  PSTNCaller: '"\\e988"',
  Pause: '"\\e40f"',
  PcSpeakers: '"\\e61d"',
  PhoneAddressBook: '"\\e204"',
  Picture: '"\\e422"',
  Pin: '"\\e617"',
  PinBlocked: '"\\e709"',
  PinOff: '"\\e618"',
  PinOffStatus: '"\\e619"',
  Pinning: '"\\e132"',
  PinningOff: '"\\e133"',
  Planner: '"\\e018"',
  Play: '"\\e40e"',
  PlayResume: '"\\e43e"',
  Plus: '"\\e415"',
  Poll: '"\\e620"',
  PowerBI: '"\\e017"',
  PresenceAway: '"\\f10a"',
  PresenceAwayXS: '"\\f103"',
  PresenceAwayXXS: '"\\f106"',
  PresenceBlocked: '"\\f10c"',
  PresenceBusyXS: '"\\f104"',
  PresenceBusyXXS: '"\\f107"',
  PresenceCallForward: '"\\f10e"',
  PresenceDnd: '"\\f10b"',
  PresenceGlyphAway: '"\\f110"',
  PresenceGlyphAway12px: '"\\f116"',
  PresenceGlyphCallForward: '"\\f113"',
  PresenceGlyphCallForward12px: '"\\f119"',
  PresenceGlyphDnd: '"\\f111"',
  PresenceGlyphDnd12px: '"\\f117"',
  PresenceGlyphMobile: '"\\f11c"',
  PresenceGlyphMobile12px: '"\\f11d"',
  PresenceGlyphOffline: '"\\f114"',
  PresenceGlyphOffline12px: '"\\f11a"',
  PresenceGlyphOnline: '"\\f10f"',
  PresenceGlyphOnline12px: '"\\f115"',
  PresenceGlyphUnknown: '"\\f112"',
  PresenceGlyphUnknown12px: '"\\f118"',
  PresenceGlyphUnknown12pxRTL: '"\\f124"',
  PresenceMobile: '"\\f11b"',
  PresenceOfflineXS: '"\\f102"',
  PresenceOfflineXXS: '"\\f105"',
  PresenceOnline: '"\\f109"',
  PresenceOnlineStroke: '"\\f122"',
  PresenceStroke: '"\\f108"',
  PresenceUnknown: '"\\f10d"',
  Presentation: '"\\e12b"',
  Print: '"\\e222"',
  Privacy: '"\\e609"',
  PrivacyClassification: '"\\e994"',
  Progress: '"\\e97d"',
  Promote: '"\\e954"',
  QR: '"\\e21e"',
  Question: '"\\e603"',
  QuestionMarkFilled: '"\\e62c"',
  QuestionRTL: '"\\e606"',
  Questionnaire: '"\\e621"',
  QuickLook: '"\\e329"',
  QuoteClose: '"\\e320"',
  QuoteOpen: '"\\e332"',
  Recent: '"\\e115"',
  RecentWithBadge: '"\\e338"',
  Refresh: '"\\e605"',
  Reload: '"\\e61a"',
  Reply: '"\\e30e"',
  Rigel: '"\\e981"',
  RigelAdd: '"\\e982"',
  Right: '"\\e419"',
  Rotate: '"\\e940"',
  Sad: '"\\e32a"',
  Safari: '"\\e624"',
  Save: '"\\e937"',
  ScreenCapture: '"\\e438"',
  Screenshare: '"\\e10a"',
  Search: '"\\e406"',
  SearchXL: '"\\e446"',
  Send: '"\\e323"',
  Settings: '"\\e60a"',
  SettingsAudio: '"\\e616"',
  SettingsSkypeOut: '"\\e127"',
  Share: '"\\e324"',
  ShareAndroid: '"\\e33e"',
  ShareFrom: '"\\e126"',
  ShareIOS: '"\\e122"',
  ShareStop: '"\\e12f"',
  ShareTo: '"\\e120"',
  ShareToTV: '"\\e950"',
  Sharepoint: '"\\e019"',
  Sharing: '"\\e12d"',
  SignOut: '"\\e60d"',
  Signal: '"\\e40b"',
  SkypeAddressBook: '"\\e203"',
  SkypeCredit: '"\\e500"',
  SkypeForBusiness: '"\\f80c"',
  SkypeManager: '"\\e20f"',
  SkypeNumber: '"\\e116"',
  SkypeToGo: '"\\e502"',
  SkypeTranslator: '"\\e331"',
  StarInCircle: '"\\e343"',
  Stickers: '"\\e987"',
  Stop: '"\\e410"',
  SubscriptionCountry: '"\\e506"',
  SubscriptionRegion: '"\\e507"',
  SubscriptionWorld: '"\\e508"',
  SwipeAll: '"\\e95a"',
  SwipeDown: '"\\e95c"',
  SwipeLeft: '"\\e958"',
  SwipeLeftRight: '"\\e95d"',
  SwipeRight: '"\\e959"',
  SwipeUp: '"\\e95b"',
  SwipeUpDown: '"\\e95e"',
  SwitchCamera: '"\\e311"',
  TV: '"\\e11f"',
  TVOff: '"\\e121"',
  Tab: '"\\e137"',
  Table: '"\\e992"',
  Tap: '"\\e957"',
  TestGlyph: '"\\f101"',
  ToDo: '"\\e97e"',
  ToDoList: '"\\e953"',
  TopLeft: '"\\f703"',
  TopRight: '"\\f700"',
  Topic: '"\\e40d"',
  TopupHistory: '"\\e50d"',
  TopupHistoryBackground: '"\\e50c"',
  Type: '"\\e933"',
  Underline: '"\\e935"',
  Undo: '"\\e32d"',
  Up: '"\\e417"',
  UserVideoOffStatus: '"\\e11b"',
  ViM: '"\\e339"',
  Video: '"\\e102"',
  VideoFront: '"\\e10b"',
  VideoHD: '"\\e607"',
  VideoOff: '"\\e103"',
  VideoOffStatus: '"\\e119"',
  VideoRear: '"\\e10c"',
  Videomail: '"\\e305"',
  VideomailOffStatus: '"\\e30f"',
  Voicemail: '"\\e304"',
  VolumeMax: '"\\e400"',
  VolumeMid: '"\\e401"',
  VolumeMin: '"\\e402"',
  VolumeOff: '"\\e403"',
  WFH: '"\\e916"',
  Warning: '"\\e601"',
  WhoBot: '"\\e50f"',
  Wifi: '"\\e123"',
  Wiki: '"\\e910"',
  Yo: '"\\e946"',
  YouTube: '"\\e020"',
  ZoomIn: '"\\e97b"',
  ZoonOut: '"\\e97c"',
  _215: '"\\e215"',
  _485: '"\\e346"',
  uniE60B: '"\\e60b"',
  uniF800: '"\\f800"',
  uniF801: '"\\f801"'
};
var regularFontFaceTS = new typestyle_1.TypeStyle({
  autoGenerateTag: true
});
var lightFontFaceTS = new typestyle_1.TypeStyle({
  autoGenerateTag: true
});
var iconTS = new typestyle_1.TypeStyle({
  autoGenerateTag: true
});
var baseStyle = memoize(function (iconWeight) {
  var fontName;
  var eotFile;
  var woffFile;
  var woff2File;
  var ttfFile;
  var svgFile;

  if (iconWeight === exports.iconWeights.Light) {
    fontName = 'MSTeamsIcons-Light';
    eotFile = require('../fonts/TeamsAssets-Light.eot');
    woffFile = require('../fonts/TeamsAssets-Light.woff');
    woff2File = require('../fonts/TeamsAssets-Light.woff2');
    ttfFile = require('../fonts/TeamsAssets-Light.ttf');
    svgFile = require('../fonts/TeamsAssets-Light.svg');
    lightFontFaceTS.fontFace({
      fontFamily: fontName,
      src: "\nurl('".concat(eotFile, "?#iefix') format('embedded-opentype'),\nurl('").concat(ttfFile, "') format('truetype'),\nurl('").concat(woff2File, "') format('woff2'),\nurl('").concat(woffFile, "') format('woff'),\nurl('").concat(svgFile, "#").concat(fontName, "') format('svg')"),
      fontWeight: 'normal',
      fontStyle: 'normal'
    });
  } else {
    fontName = 'MSTeamsIcons-Regular';
    eotFile = require('../fonts/TeamsAssets-Regular.eot');
    woffFile = require('../fonts/TeamsAssets-Regular.woff');
    woff2File = require('../fonts/TeamsAssets-Regular.woff2');
    ttfFile = require('../fonts/TeamsAssets-Regular.ttf');
    svgFile = require('../fonts/TeamsAssets-Regular.svg');
    regularFontFaceTS.fontFace({
      fontFamily: fontName,
      src: "\nurl('".concat(eotFile, "?#iefix') format('embedded-opentype'),\nurl('").concat(ttfFile, "') format('truetype'),\nurl('").concat(woff2File, "') format('woff2'),\nurl('").concat(woffFile, "') format('woff'),\nurl('").concat(svgFile, "#").concat(fontName, "') format('svg')"),
      fontWeight: 'normal',
      fontStyle: 'normal'
    });
  }

  return iconTS.style({
    fontFamily: fontName + ' !important',
    display: 'block',
    fontStyle: 'normal',
    fontWeight: 'normal',
    fontVariant: 'normal',
    fontSize: '16px',
    lineHeight: 1,
    textRendering: 'optimizeLegibility'
  });
});
exports.baseStyle = baseStyle;
var iconStyle = memoize(function (iconType) {
  if (!iconType) {
    return null;
  }

  return iconTS.style({
    $nest: {
      '&::before': {
        content: iconType,
        bottom: '1px',
        position: 'relative'
      }
    }
  });
});
exports.iconStyle = iconStyle;