"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});

var context_1 = require("../context");

function base(context, colors) {
  var names = {
    container: 'btn-compound',
    icon: 'btn-compound-icon',
    primaryText: 'btn-compound-txt1',
    secondaryText: 'btn-compound-txt2'
  };
  var css = context.css,
      font = context.font,
      rem = context.rem;
  var sizes = font.sizes,
      weights = font.weights;
  return {
    container: css(names.container, {
      minWidth: rem(4.8),
      minHeight: rem(4.8),
      display: 'inline-flex',
      alignItems: 'center',
      padding: 0,
      font: 'inherit',
      verticalAlign: 'middle',
      border: "".concat(rem(0.2), " solid"),
      borderColor: colors.rest.border,
      borderRadius: rem(0.3),
      background: colors.rest.background,
      color: colors.rest.text,
      cursor: 'pointer'
    }, {
      $nest: {
        '&:hover:enabled': {
          background: colors.hover.background,
          color: colors.hover.text
        },
        '&:focus': {
          color: colors.focus.text,
          borderColor: colors.focus.border,
          background: colors.focus.background,
          outline: "".concat(rem(0.2), " solid ").concat(colors.focus.outline),
          outlineOffset: "-".concat(rem(0.4))
        },
        '&:active': {
          background: colors.down.background,
          color: colors.down.text,
          borderColor: colors.down.border
        },
        '&:disabled': {
          background: colors.disabled.background,
          color: colors.disabled.text,
          borderColor: colors.disabled.border
        }
      }
    }),
    icon: css(names.icon, {
      width: rem(4.4),
      height: rem(4.4),
      display: 'flex',
      alignItems: 'center',
      overflow: 'hidden'
    }),
    primaryText: css(names.primaryText, sizes.base, weights.semibold, {
      textAlign: 'left',
      paddingLeft: rem(1.2),
      paddingRight: rem(1.2)
    }),
    secondaryText: css(names.secondaryText, sizes.caption, weights.regular, {
      textAlign: 'left',
      paddingLeft: rem(1.2),
      paddingRight: rem(1.2)
    })
  };
}

function light(context) {
  var colors = context.colors;
  return base(context, {
    rest: {
      background: colors.transparent,
      text: colors.light.black,
      border: colors.light.gray06
    },
    hover: {
      background: colors.light.gray06,
      border: colors.transparent,
      text: colors.light.black
    },
    down: {
      background: colors.light.gray04,
      text: colors.light.black,
      border: colors.light.gray04
    },
    focus: {
      text: colors.light.black,
      border: colors.transparent,
      background: colors.light.gray06,
      outline: colors.light.black
    },
    disabled: {
      background: colors.transparent,
      text: colors.light.gray04,
      border: colors.light.gray12
    }
  });
}

function dark(context) {
  var colors = context.colors;
  return base(context, {
    rest: {
      background: colors.transparent,
      text: colors.dark.white,
      border: colors.dark.gray06
    },
    hover: {
      background: colors.dark.gray06,
      border: colors.transparent,
      text: colors.dark.white
    },
    down: {
      background: colors.dark.gray04,
      text: colors.dark.white,
      border: colors.dark.gray04
    },
    focus: {
      text: colors.dark.white,
      border: colors.transparent,
      background: colors.dark.gray06,
      outline: colors.dark.white
    },
    disabled: {
      background: colors.transparent,
      text: colors.dark.gray04,
      border: colors.dark.gray12
    }
  });
}

function highContrast(context) {
  var colors = context.colors;
  return base(context, {
    rest: {
      background: colors.transparent,
      text: colors.highContrast.white,
      border: colors.highContrast.white
    },
    hover: {
      background: colors.highContrast.yellow,
      border: colors.highContrast.white,
      text: colors.highContrast.black
    },
    down: {
      background: colors.highContrast.yellow,
      text: colors.highContrast.black,
      border: colors.highContrast.white
    },
    focus: {
      text: colors.highContrast.black,
      border: colors.highContrast.white,
      background: colors.highContrast.yellow,
      outline: colors.transparent
    },
    disabled: {
      background: colors.highContrast.green,
      text: colors.highContrast.black,
      border: colors.highContrast.white
    }
  });
}

function compoundButton(context) {
  return context_1.chooseStyle(context, light, dark, highContrast);
}

exports.compoundButton = compoundButton;