"use strict";

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

Object.defineProperty(exports, "__esModule", {
  value: true
});

var context_1 = require("../context");

function base(context, colors) {
  var names = {
    container: '',
    label: '',
    button: {
      container: '',
      text: '',
      icon: ''
    },
    item: {
      container: '',
      caret: '',
      showItems: '',
      content: ''
    }
  };
  var css = context.css,
      font = context.font,
      rem = context.rem;
  var sizes = font.sizes;
  var itemContainerClass = css(names.item.container, {
    backgroundColor: colors.itemContainerBg,
    position: 'absolute',
    left: 0,
    top: '100%',
    zIndex: 1000,
    transform: 'scaleY(0)',
    transformOrigin: 'top',
    borderRadius: rem(0.3),
    display: 'inline-block',
    overflow: 'hidden',
    marginTop: rem(0.3),
    boxShadow: "0px ".concat(rem(0.2), " ").concat(rem(1.2), " 0px ").concat(colors.bgShadow),
    border: colors.border
  });
  return {
    container: css(names.container, {
      position: 'relative',
      display: 'inline-block',
      minWidth: rem(2.2)
    }),
    label: css(names.label, sizes.caption, {
      display: 'inline-block',
      padding: 0,
      border: 0,
      marginBottom: rem(0.8),
      marginLeft: 0,
      marginRight: 0,
      marginTop: 0,
      color: colors.label
    }),
    mainButton: {
      container: css(names.button.container, {
        height: rem(3.2),
        display: 'inline-flex',
        alignItems: 'center',
        color: colors.mainButton.text,
        backgroundColor: colors.mainButton.background,
        border: "".concat(rem(0.2), " solid"),
        borderColor: colors.mainButton.border,
        paddingLeft: rem(0.6),
        paddingRight: rem(0.6),
        paddingBottom: 0,
        paddingTop: 0,
        fontFamily: 'inherit',
        whiteSpace: 'nowrap',
        fontSize: rem(1.4),
        cursor: 'pointer',
        borderRadius: rem(0.3),
        width: '100%',
        textAlign: 'left',
        outline: 'none',
        $nest: {
          '&:focus:enabled': {
            borderBottomWidth: rem(0.2),
            borderBottomColor: colors.underline
          },
          '&:disabled': {
            borderColor: colors.mainButton.disabled.border,
            background: colors.mainButton.disabled.background,
            borderBottomColor: colors.mainButton.disabled.underline,
            color: colors.mainButton.disabled.text,
            cursor: 'default'
          }
        }
      }),
      text: css(names.button.text, {
        flex: '1 1 auto',
        paddingLeft: rem(0.4),
        paddingRight: rem(0.8)
      }),
      icon: css(names.button.icon, {
        flex: '0 0 auto',
        $nest: {
          '&:enabled': {
            color: colors.mainButton.icon
          }
        }
      })
    },
    itemContainer: itemContainerClass,
    itemContainerRight: css(names.item.caret, {
      $nest: _defineProperty({}, "&.".concat(itemContainerClass), {
        right: 0,
        left: 'auto'
      })
    }),
    showItems: css(names.item.showItems, {
      $nest: _defineProperty({}, "&.".concat(itemContainerClass), {
        minWidth: "100%",
        transform: 'scaleY(1)'
      })
    }),
    item: css(names.item.content, {
      width: '100%',
      position: 'relative',
      height: rem(3.2),
      border: 0,
      padding: "".concat(rem(0.4), " ").concat(rem(1)),
      textAlign: 'left',
      whiteSpace: 'nowrap',
      display: 'block',
      backgroundColor: colors.itemBg,
      color: colors.item,
      cursor: 'pointer',
      outline: 'none',
      $nest: {
        '&:focus': {
          backgroundColor: colors.itemHoverBg,
          color: colors.itemHover
        },
        '&:hover': {
          backgroundColor: colors.itemHoverBg,
          color: colors.itemHover
        }
      }
    })
  };
}

function light(context) {
  var colors = context.colors;
  return base(context, {
    mainButton: {
      text: colors.light.black,
      icon: colors.light.gray02,
      background: colors.light.gray10,
      border: colors.transparent,
      disabled: {
        border: colors.transparent,
        background: colors.light.gray12,
        underline: colors.transparent,
        text: colors.light.gray08,
        placeholder: colors.light.gray06
      }
    },
    item: colors.light.black,
    itemBg: colors.light.white,
    itemContainerBg: colors.light.gray12,
    itemHover: colors.light.white,
    itemHoverBg: colors.light.brand00,
    label: colors.light.gray02,
    underline: colors.light.brand00,
    bgShadow: 'rgba(22, 35, 58, 0.36)',
    border: 'none'
  });
}

function dark(context) {
  var colors = context.colors;
  return base(context, {
    mainButton: {
      text: colors.dark.white,
      icon: colors.dark.gray02,
      background: colors.dark.black,
      border: colors.transparent,
      disabled: {
        border: colors.transparent,
        background: colors.dark.gray12,
        underline: colors.transparent,
        text: colors.dark.gray08,
        placeholder: colors.dark.gray06
      }
    },
    itemBg: colors.dark.gray10,
    item: colors.dark.white,
    itemContainerBg: colors.dark.black,
    itemHover: colors.dark.white,
    itemHoverBg: colors.dark.brand00,
    label: colors.dark.gray02,
    underline: colors.dark.brand00,
    bgShadow: 'rgba(0, 0, 0, 0.4)',
    border: 'none'
  });
}

function highContrast(context) {
  var colors = context.colors,
      rem = context.rem;
  return base(context, {
    mainButton: {
      text: colors.highContrast.white,
      icon: colors.highContrast.white,
      background: colors.highContrast.black,
      border: colors.highContrast.white,
      disabled: {
        border: colors.highContrast.green,
        background: colors.highContrast.black,
        underline: colors.highContrast.white,
        text: colors.highContrast.green,
        placeholder: colors.highContrast.green
      }
    },
    item: colors.highContrast.white,
    itemBg: colors.highContrast.black,
    itemContainerBg: colors.highContrast.black,
    itemHover: colors.highContrast.black,
    itemHoverBg: colors.highContrast.yellow,
    label: colors.highContrast.white,
    underline: colors.highContrast.yellow,
    bgShadow: colors.transparent,
    border: "".concat(rem(0.1), " solid ").concat(colors.highContrast.white)
  });
}

function dropdown(context) {
  return context_1.chooseStyle(context, light, dark, highContrast);
}

exports.dropdown = dropdown;