"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});

var context_1 = require("../context");

function base(context, colors) {
  var name = 'error-label';
  var css = context.css,
      font = context.font,
      rem = context.rem;
  var sizes = font.sizes,
      weights = font.weights;
  return css(name, sizes.caption, weights.regular, {
    display: 'inline-block',
    color: colors.text,
    padding: 0,
    border: 0,
    marginBottom: rem(0.8),
    marginLeft: 0,
    marginRight: 0,
    marginTop: 0,
    "float": 'right'
  });
}

function light(context) {
  var colors = context.colors;
  return base(context, {
    text: colors.light.red
  });
}

function dark(context) {
  var colors = context.colors;
  return base(context, {
    text: colors.dark.red
  });
}

function highContrast(context) {
  var colors = context.colors;
  return base(context, {
    text: colors.highContrast.yellow
  });
}

function errorLabel(context) {
  return context_1.chooseStyle(context, light, dark, highContrast);
}

exports.errorLabel = errorLabel;