"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});

function fontWeights(context) {
  var names = {
    semilight: 'font-semilight',
    regular: 'font-regular',
    semibold: 'font-semibold',
    bold: 'font-bold'
  };
  var css = context.css,
      font = context.font;
  var weights = font.weights;
  return {
    semilight: css(names.semilight, weights.semilight),
    regular: css(names.regular, weights.regular),
    semibold: css(names.semibold, weights.semibold),
    bold: css(names.bold, weights.bold)
  };
}

exports.fontWeights = fontWeights;