"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});

var context_1 = require("../context");

function base(context, colors) {
  var name = 'label';
  var css = context.css,
      font = context.font,
      rem = context.rem;
  var sizes = font.sizes,
      weights = font.weights;
  return css(name, sizes.caption, weights.regular, {
    display: 'inline-block',
    color: colors.text,
    padding: 0,
    border: 0,
    marginBottom: rem(0.8),
    marginLeft: 0,
    marginRight: 0,
    marginTop: 0,
    "float": 'left'
  });
}

function light(context) {
  var colors = context.colors;
  return base(context, {
    text: colors.light.gray01
  });
}

function dark(context) {
  var colors = context.colors;
  return base(context, {
    text: colors.dark.white
  });
}

function highContrast(context) {
  var colors = context.colors;
  return base(context, {
    text: colors.highContrast.white
  });
}

function label(context) {
  return context_1.chooseStyle(context, light, dark, highContrast);
}

exports.label = label;