"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});

var context_1 = require("../context");

function base(context, colors) {
  var names = {
    container: 'panel',
    header: 'panel-header',
    body: 'panel-body',
    footer: 'panel-footer'
  };
  var css = context.css,
      rem = context.rem,
      spacing = context.spacing;
  return {
    container: css(names.container, {
      backgroundColor: colors.background,
      borderStyle: 'solid',
      borderWidth: rem(0.2),
      borderColor: colors.border,
      display: 'flex',
      overflow: 'hidden',
      flexDirection: 'column'
    }),
    header: css(names.header, {
      flex: '0 0 auto',
      paddingTop: spacing.xxxLarge,
      paddingLeft: spacing.xxxLarge,
      paddingRight: spacing.xxxLarge
    }),
    body: css(names.body, {
      paddingLeft: spacing.xxxLarge,
      paddingRight: spacing.xxxLarge,
      flex: '1 1 auto',
      overflow: 'auto'
    }),
    footer: css(names.footer, {
      paddingBottom: spacing.xxxLarge,
      paddingLeft: spacing.xxxLarge,
      paddingRight: spacing.xxxLarge,
      flex: '0 0 auto'
    })
  };
}

function light(context) {
  var colors = context.colors;
  return base(context, {
    background: colors.light.white,
    border: colors.transparent
  });
}

function dark(context) {
  var colors = context.colors;
  return base(context, {
    background: context.colors.dark.gray10,
    border: colors.transparent
  });
}

function highContrast(context) {
  var colors = context.colors;
  return base(context, {
    background: context.colors.highContrast.black,
    border: colors.highContrast.white
  });
}

function panel(context) {
  return context_1.chooseStyle(context, light, dark, highContrast);
}

exports.panel = panel;