"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});

var context_1 = require("../context");

var error_label_1 = require("./error-label");

var label_1 = require("./label");

function base(context, colors) {
  var names = {
    container: 'radio-group'
  };
  var css = context.css;
  var labelClass = label_1.label(context);
  var errorLabelClass = error_label_1.errorLabel(context);
  return {
    container: css(names.container, {
      clear: 'both'
    }),
    label: labelClass,
    errorLabel: errorLabelClass
  };
}

function light(context) {
  var colors = context.colors;
  return base(context, {
    label: colors.light.gray01,
    errorLabel: colors.light.red
  });
}

function dark(context) {
  var colors = context.colors;
  return base(context, {
    label: colors.dark.white,
    errorLabel: colors.dark.red
  });
}

function highContrast(context) {
  var colors = context.colors;
  return base(context, {
    label: colors.highContrast.white,
    errorLabel: colors.highContrast.yellow
  });
}

function radioButtonGroup(context) {
  return context_1.chooseStyle(context, light, dark, highContrast);
}

exports.radioButtonGroup = radioButtonGroup;