"use strict";

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

Object.defineProperty(exports, "__esModule", {
  value: true
});

var context_1 = require("../context");

function base(context, colors) {
  var _$nest, _css;

  var names = {
    container: 'radio-container',
    button: 'radio-button',
    label: 'radio-label'
  };
  var css = context.css,
      rem = context.rem,
      font = context.font;
  var sizes = font.sizes;
  var labelClass = css(names.label);
  var radioClass = css(names.button, {
    position: 'absolute',
    top: rem(0.4),
    left: rem(0.2),
    width: rem(1.2),
    height: rem(1.2),
    border: "".concat(rem(0.1), " solid"),
    borderColor: colors.rest.border,
    background: colors.rest.background,
    borderRadius: '50%'
  });
  return {
    container: css(names.container, sizes.caption, (_css = {
      display: 'block',
      position: 'relative'
    }, _defineProperty(_css, '-webkit-user-select', 'none'), _defineProperty(_css, '-moz-user-select', 'none'), _defineProperty(_css, '-ms-user-select', 'none'), _defineProperty(_css, "userSelect", 'none'), _defineProperty(_css, "marginLeft", rem(0)), _defineProperty(_css, "padding", rem(0.2)), _defineProperty(_css, "paddingLeft", rem(2.6)), _defineProperty(_css, "$nest", (_$nest = {
      '& + &': {
        marginTop: rem(0.4)
      },
      '& input': {
        position: 'absolute',
        width: 0,
        height: 0,
        opacity: 0
      }
    }, _defineProperty(_$nest, "& input ~ .".concat(labelClass), {
      cursor: 'pointer',
      color: colors.rest.text
    }), _defineProperty(_$nest, "& input:disabled ~ .".concat(labelClass), {
      cursor: 'default',
      color: colors.disabled.text
    }), _defineProperty(_$nest, "& input:checked ~ .".concat(labelClass), {
      color: colors.selected.text
    }), _defineProperty(_$nest, "& input ~ .".concat(radioClass), {
      cursor: 'pointer',
      color: colors.rest.text
    }), _defineProperty(_$nest, "& input:disabled ~ .".concat(radioClass), {
      cursor: 'default',
      color: colors.disabled.text,
      background: colors.disabled.background,
      borderColor: colors.disabled.border
    }), _defineProperty(_$nest, "& input:enabled:hover ~ .".concat(radioClass), {
      background: colors.hover.background,
      borderColor: colors.hover.border
    }), _defineProperty(_$nest, "& input:checked:hover ~ .".concat(radioClass), {
      borderColor: colors.selected.border,
      background: colors.selected.background
    }), _defineProperty(_$nest, "& input:enabled:focus ~ .".concat(radioClass), {
      boxShadow: "0 0 0 ".concat(rem(0.2), " ").concat(colors.focus.outline),
      outline: 'none'
    }), _defineProperty(_$nest, "& input:checked ~ .".concat(radioClass), {
      borderColor: colors.selected.border,
      background: colors.selected.background
    }), _$nest)), _css)),
    radio: radioClass,
    label: labelClass
  };
}

function light(context) {
  var colors = context.colors;
  return base(context, {
    rest: {
      border: colors.light.gray02,
      background: colors.transparent,
      text: colors.light.gray02
    },
    hover: {
      border: colors.light.gray02,
      background: colors.transparent
    },
    disabled: {
      border: colors.light.gray06,
      background: colors.light.gray10,
      text: colors.light.gray06
    },
    focus: {
      outline: colors.light.brand00Dark
    },
    selected: {
      background: colors.light.brand00,
      border: colors.light.brand00,
      text: colors.light.black
    },
    container: colors.transparent
  });
}

function dark(context) {
  var colors = context.colors;
  return base(context, {
    rest: {
      border: colors.dark.gray02,
      background: colors.transparent,
      text: colors.dark.gray02
    },
    hover: {
      border: colors.dark.gray02,
      background: colors.transparent
    },
    disabled: {
      border: colors.dark.gray06,
      background: colors.dark.gray10,
      text: colors.dark.gray06
    },
    focus: {
      outline: colors.dark.brand00Light
    },
    selected: {
      background: colors.dark.brand00,
      border: colors.dark.brand00,
      text: colors.dark.white
    },
    container: colors.transparent
  });
}

function highContrast(context) {
  var colors = context.colors;
  return base(context, {
    rest: {
      border: colors.highContrast.white,
      background: colors.transparent,
      text: colors.highContrast.white
    },
    hover: {
      border: colors.highContrast.white,
      background: colors.transparent
    },
    disabled: {
      background: colors.transparent,
      border: colors.highContrast.green,
      text: colors.highContrast.green
    },
    focus: {
      outline: colors.highContrast.yellow
    },
    selected: {
      background: colors.highContrast.blue,
      border: colors.highContrast.blue,
      text: colors.highContrast.white
    },
    container: colors.transparent
  });
}

function radioButton(context) {
  return context_1.chooseStyle(context, light, dark, highContrast);
}

exports.radioButton = radioButton;