"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});

var context_1 = require("../context");

function base(context, colors) {
  var names = {
    button: 'button-secondary'
  };
  var css = context.css,
      rem = context.rem;
  return css(names.button, {
    height: rem(3.2),
    minWidth: rem(9.6),
    border: rem(0.2) + ' solid',
    borderRadius: rem(0.3),
    padding: rem(0.4),
    whiteSpace: 'nowrap',
    cursor: 'pointer',
    font: 'inherit',
    background: colors.rest.background,
    color: colors.rest.text,
    borderColor: colors.rest.border
  }, {
    $nest: {
      '&:hover:enabled': {
        background: colors.hover.background,
        color: colors.hover.text,
        borderColor: colors.hover.border
      },
      '&:active:hover:enabled': {
        background: colors.down.background,
        color: colors.down.text,
        borderColor: colors.down.border
      },
      '&:active:enabled': {
        background: colors.down.background,
        color: colors.down.text,
        borderColor: colors.down.border
      },
      '&:focus:enabled': {
        outline: "".concat(rem(0.2), " solid ").concat(colors.focus.outline),
        outlineOffset: "-".concat(rem(0.4)),
        color: colors.focus.text,
        borderColor: colors.focus.border,
        background: colors.focus.background
      },
      '&:disabled': {
        background: colors.disabled.background,
        color: colors.disabled.text,
        borderColor: colors.disabled.border,
        cursor: 'default'
      }
    }
  });
}

function light(context) {
  var colors = context.colors;
  return base(context, {
    rest: {
      background: colors.light.white,
      text: colors.light.gray02,
      border: colors.light.gray06
    },
    hover: {
      background: colors.light.gray06,
      text: colors.light.black,
      border: colors.transparent
    },
    down: {
      background: colors.light.gray04,
      text: colors.light.black,
      border: colors.transparent
    },
    disabled: {
      background: colors.light.white,
      text: colors.light.gray06,
      border: colors.light.gray12
    },
    focus: {
      background: colors.light.gray06,
      text: colors.light.black,
      border: colors.transparent,
      outline: colors.light.black
    }
  });
}

function dark(context) {
  var colors = context.colors;
  return base(context, {
    rest: {
      background: colors.dark.gray10,
      text: colors.dark.gray02,
      border: colors.dark.gray06
    },
    hover: {
      background: colors.dark.gray06,
      text: colors.dark.white,
      border: colors.transparent
    },
    down: {
      background: colors.dark.gray08,
      text: colors.dark.white,
      border: colors.transparent
    },
    disabled: {
      background: colors.dark.gray10,
      text: colors.dark.gray06,
      border: colors.dark.gray12
    },
    focus: {
      background: colors.dark.gray06,
      text: colors.dark.white,
      border: colors.transparent,
      outline: colors.dark.white
    }
  });
}

function highContrast(context) {
  var colors = context.colors;
  return base(context, {
    rest: {
      background: colors.highContrast.black,
      text: colors.highContrast.white,
      border: colors.highContrast.white
    },
    hover: {
      background: colors.highContrast.yellow,
      text: colors.highContrast.black,
      border: colors.transparent
    },
    down: {
      background: colors.highContrast.yellow,
      text: colors.highContrast.black,
      border: colors.transparent
    },
    disabled: {
      background: colors.highContrast.black,
      text: colors.highContrast.green,
      border: colors.highContrast.green
    },
    focus: {
      background: colors.highContrast.yellow,
      text: colors.highContrast.black,
      outline: colors.transparent,
      border: colors.transparent
    }
  });
}

function secondaryButton(context) {
  return context_1.chooseStyle(context, light, dark, highContrast);
}

exports.secondaryButton = secondaryButton;
exports["default"] = secondaryButton;