"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});

var context_1 = require("../context");

function base(context, colors) {
  var name = 'surface';
  var css = context.css,
      font = context.font;
  var sizes = font.sizes,
      weights = font.weights;
  return css(name, weights.regular, sizes.base, {
    color: colors.font,
    backgroundColor: colors.background
  });
}

function light(context) {
  var colors = context.colors;
  return base(context, {
    background: colors.light.gray10,
    font: colors.light.black
  });
}

function dark(context) {
  var colors = context.colors;
  return base(context, {
    background: colors.dark.black,
    font: colors.dark.white
  });
}

function highContrast(context) {
  var colors = context.colors;
  return base(context, {
    background: colors.highContrast.black,
    font: colors.highContrast.white
  });
}

function surface(context) {
  return context_1.chooseStyle(context, light, dark, highContrast);
}

exports.surface = surface;