"use strict";

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

Object.defineProperty(exports, "__esModule", {
  value: true
});

var context_1 = require("../context");

var get_return_type_1 = require("../get-return-type"); // tslint:disable-next-line:variable-name


exports._extractingTabStyles = get_return_type_1.getReturnType(base);

function base(context, colors) {
  var _$nest2;

  var names = {
    container: 'tab-group',
    normal: 'tab',
    active: 'tab-active'
  };
  var css = context.css,
      rem = context.rem,
      spacing = context.spacing;
  var containerClass = css(names.container, {
    width: '100%',
    borderBottom: "".concat(rem(0.1), " solid ").concat(colors.containerUnderline),
    padding: 0,
    margin: 0
  });
  var normalClass = css(names.normal, {
    $nest: _defineProperty({}, ".".concat(containerClass, " &"), {
      display: 'inline-block',
      marginRight: rem(2),
      padding: spacing.xxSmall,
      outline: 'none',
      background: 0,
      border: 0,
      font: 'inherit',
      margin: 0,
      cursor: 'pointer',
      borderBottom: "transparent ".concat(rem(0.4), " solid"),
      color: colors.text,
      $nest: {
        '&:hover': {
          borderBottomColor: colors.hoverUnderline
        },
        '&:focus': {
          color: colors.focus,
          backgroundColor: colors.focusBg
        }
      }
    })
  });
  return {
    container: containerClass,
    normal: normalClass,
    active: css(names.active, {
      $nest: (_$nest2 = {}, _defineProperty(_$nest2, ".".concat(containerClass, " &"), {
        borderBottomColor: colors.underline,
        color: colors.textActive
      }), _defineProperty(_$nest2, '&:focus', {
        borderBottomColor: colors.focus
      }), _$nest2)
    })
  };
}

function light(context) {
  var colors = context.colors;
  return base(context, {
    text: colors.light.gray02,
    textActive: colors.light.brand00,
    underline: colors.light.brand00,
    containerUnderline: colors.light.gray12,
    hoverUnderline: colors.light.brand06,
    focus: colors.light.white,
    focusBg: colors.light.brand00Dark
  });
}

function dark(context) {
  var colors = context.colors;
  return base(context, {
    text: colors.dark.gray02,
    textActive: colors.dark.brand00,
    underline: colors.dark.brand00,
    containerUnderline: colors.highContrast.black,
    hoverUnderline: colors.dark.brand06,
    focus: colors.dark.white,
    focusBg: colors.dark.brand00Light
  });
}

function highContrast(context) {
  var colors = context.colors;
  return base(context, {
    text: colors.highContrast.white,
    textActive: colors.highContrast.white,
    underline: colors.highContrast.blue,
    containerUnderline: colors.highContrast.green,
    hoverUnderline: colors.highContrast.yellow,
    focus: colors.highContrast.black,
    focusBg: colors.highContrast.yellow
  });
}

function tab(context) {
  return context_1.chooseStyle(context, light, dark, highContrast);
}

exports.tab = tab;