"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});

var context_1 = require("../context");

function base(c, colors) {
  var names = {
    table: 'table',
    thead: 'thead',
    tbody: 'tbody',
    td: 'td',
    tr: 'tr',
    th: 'th'
  };
  var css = c.css,
      rem = c.rem,
      font = c.font;
  var sizes = font.sizes,
      weights = font.weights;
  return {
    table: css(names.table, {
      display: 'flex',
      flexFlow: 'column nowrap',
      justifyContent: 'space-between',
      backgroundColor: colors.table.background,
      color: colors.table.text,
      borderCollapse: 'collapse',
      padding: 0
    }),
    thead: css(names.thead, {
      display: 'flex',
      flexFlow: 'column nowrap',
      flex: '1 1 auto'
    }),
    tbody: css(names.tbody, {
      display: 'flex',
      flexFlow: 'column nowrap',
      flex: '1 1 auto'
    }),
    tr: css(names.tr, {
      flex: '1 1 auto',
      overflow: 'hidden',
      display: 'flex',
      flexFlow: 'row nowrap',
      borderBottom: "".concat(colors.row.border, " ").concat(rem(0.2), " solid"),
      $nest: {
        '&:last-child': {
          borderBottom: 0
        }
      }
    }),
    th: css(names.th, sizes.caption, weights.regular, {
      textAlign: 'left',
      display: 'flex',
      flexFlow: 'row nowrap',
      flex: '1 1 auto',
      overflow: 'hidden',
      paddingLeft: rem(1.6),
      paddingRight: rem(1.6),
      paddingTop: rem(1.4),
      paddingBottom: rem(0.6),
      backgroundColor: colors.head.background,
      $nest: {
        '&:last-child:not(:only-child)': {
          paddingLeft: 0
        }
      }
    }),
    td: css(names.td, {
      display: 'flex',
      flexFlow: 'row nowrap',
      flex: '1 1 auto',
      overflow: 'hidden',
      paddingLeft: rem(1.6),
      paddingRight: rem(1.6),
      paddingTop: rem(1.4),
      paddingBottom: rem(1.4),
      backgroundColor: colors.body.background,
      $nest: {
        '&:last-child:not(:only-child)': {
          paddingLeft: 0
        }
      }
    })
  };
}

function light(context) {
  var colors = context.colors;
  return base(context, {
    table: {
      background: colors.transparent,
      text: colors.light.gray02
    },
    head: {
      background: colors.transparent
    },
    body: {
      background: colors.light.gray14
    },
    row: {
      border: colors.light.white
    }
  });
}

function dark(context) {
  var colors = context.colors;
  return base(context, {
    table: {
      background: colors.transparent,
      text: colors.dark.gray02
    },
    head: {
      background: colors.transparent
    },
    body: {
      background: colors.dark.gray14
    },
    row: {
      border: colors.dark.black
    }
  });
}

function highContrast(context) {
  var colors = context.colors;
  return base(context, {
    table: {
      background: colors.transparent,
      text: colors.highContrast.white
    },
    head: {
      background: colors.transparent
    },
    body: {
      background: colors.transparent
    },
    row: {
      border: colors.highContrast.white
    }
  });
}

function table(context) {
  return context_1.chooseStyle(context, light, dark, highContrast);
}

exports.table = table;