"use strict";

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

Object.defineProperty(exports, "__esModule", {
  value: true
});

var context_1 = require("../context");

var error_label_1 = require("./error-label");

var label_1 = require("./label");

function base(context, colors) {
  var _css;

  var names = {
    container: 'textarea-container',
    textarea: 'textarea-field',
    labelContainer: 'textarea-label-container',
    errorIcon: 'textarea-error-icon'
  };
  var css = context.css,
      rem = context.rem;
  var labelClass = label_1.label(context);
  var errorLabelClass = error_label_1.errorLabel(context);
  return {
    container: css(names.container, {
      overflow: 'hidden',
      position: 'relative',
      display: 'flex',
      flexDirection: 'column'
    }),
    textArea: css(names.textarea, (_css = {
      flex: "1 1 auto",
      width: '100%',
      borderRadius: rem(0.3),
      border: "".concat(rem(0.2), " solid ").concat(colors.rest.border),
      background: colors.rest.background,
      padding: "".concat(rem(0.8), " ").concat(rem(1.2)),
      margin: 0,
      color: colors.rest.text,
      font: 'inherit',
      outline: 'none'
    }, _defineProperty(_css, '-webkit-box-sizing', 'border-box'), _defineProperty(_css, '-moz-box-sizing', 'border-box'), _defineProperty(_css, "boxSizing", 'border-box'), _defineProperty(_css, "resize", 'none'), _css), {
      $nest: {
        '&:active:enabled': {
          background: colors.active.background,
          borderBottomColor: colors.active.underline
        },
        '&:hover:inactive:enabled': {
          background: colors.hover.background,
          borderBottomColor: colors.hover.underline
        },
        '&:disabled': {
          borderColor: colors.disabled.border,
          background: colors.disabled.background,
          borderBottomColor: colors.disabled.underline,
          color: colors.disabled.text,
          $nest: {
            '&::placeholder': {
              color: colors.disabled.placeholder,
              opacity: 1
            },
            '&::-webkit-input-placeholder': {
              color: colors.disabled.placeholder
            },
            '&::-moz-placeholder': {
              color: colors.disabled.placeholder
            },
            '&:-ms-input-placeholder': {
              color: colors.disabled.placeholder
            },
            '&::-ms-input-placeholder': {
              color: colors.disabled.placeholder
            },
            '&:-moz-placeholder': {
              color: colors.disabled.placeholder
            }
          }
        },
        '&:focus': {
          borderBottomColor: colors.active.underline,
          background: colors.focus.background
        },
        '&::placeholder': {
          color: colors.rest.placeholder,
          opacity: 1
        },
        '&::-webkit-input-placeholder': {
          color: colors.rest.placeholder
        },
        '&::-moz-placeholder': {
          color: colors.rest.placeholder
        },
        '&:-ms-input-placeholder': {
          color: colors.rest.placeholder
        },
        '&::-ms-input-placeholder': {
          color: colors.rest.placeholder
        },
        '&:-moz-placeholder': {
          color: colors.rest.placeholder
        }
      }
    }),
    labelContainer: css(names.labelContainer, {
      flex: '0 0 auto'
    }),
    label: labelClass,
    errorLabel: errorLabelClass,
    errorIcon: css(names.errorIcon, {
      position: 'absolute',
      color: colors.errorIcon,
      right: rem(1.2),
      bottom: rem(2.5)
    })
  };
}

function light(context) {
  var colors = context.colors;
  return base(context, {
    rest: {
      background: colors.light.gray10,
      border: colors.transparent,
      underline: colors.transparent,
      text: colors.light.black,
      placeholder: colors.light.gray02
    },
    active: {
      background: colors.light.gray10,
      underline: colors.light.brand00
    },
    disabled: {
      border: colors.transparent,
      background: colors.light.gray12,
      underline: colors.transparent,
      text: colors.light.gray08,
      placeholder: colors.light.gray06
    },
    hover: {
      background: colors.light.gray10,
      underline: colors.transparent
    },
    focus: {
      background: colors.light.gray10,
      underline: colors.light.brand00
    },
    label: colors.light.gray01,
    errorIcon: colors.light.red
  });
}

function dark(context) {
  var colors = context.colors;
  return base(context, {
    rest: {
      background: colors.dark.black,
      border: colors.transparent,
      underline: colors.transparent,
      text: colors.dark.white,
      placeholder: colors.dark.gray02
    },
    active: {
      background: colors.dark.black,
      underline: colors.dark.brand00
    },
    disabled: {
      border: colors.transparent,
      background: colors.dark.gray12,
      underline: colors.transparent,
      text: colors.dark.gray08,
      placeholder: colors.dark.gray06
    },
    hover: {
      background: colors.dark.black,
      underline: colors.transparent
    },
    focus: {
      background: colors.dark.black,
      underline: colors.dark.brand00
    },
    label: colors.dark.white,
    errorIcon: colors.dark.red
  });
}

function highContrast(context) {
  var colors = context.colors;
  return base(context, {
    rest: {
      background: colors.highContrast.black,
      border: colors.highContrast.white,
      underline: colors.transparent,
      text: colors.highContrast.white,
      placeholder: colors.highContrast.white
    },
    active: {
      background: colors.highContrast.black,
      underline: colors.highContrast.yellow
    },
    disabled: {
      border: colors.highContrast.green,
      background: colors.highContrast.black,
      underline: colors.highContrast.white,
      text: colors.highContrast.white,
      placeholder: colors.highContrast.green
    },
    hover: {
      background: colors.highContrast.black,
      underline: colors.transparent
    },
    focus: {
      background: colors.highContrast.black,
      underline: colors.highContrast.yellow
    },
    label: colors.highContrast.white,
    errorIcon: colors.highContrast.yellow
  });
}

function textArea(context) {
  return context_1.chooseStyle(context, light, dark, highContrast);
}

exports.textArea = textArea;