"use strict";

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

Object.defineProperty(exports, "__esModule", {
  value: true
});

var context_1 = require("../context");

var hidden_input_1 = require("./hidden-input");

var width = 4;
var height = 2;
var ballSize = 1.4;
var ballDeltaX = 0.3;

function base(context, colors) {
  var _$nest;

  var names = {
    container: 'toggle',
    input: 'toggle-input',
    slider: 'toggle-ball'
  };
  var css = context.css,
      rem = context.rem;
  var delta = width - ballDeltaX * 2 - ballSize;
  var inputClass = hidden_input_1.hiddenInput(context);
  return {
    container: css(names.container, {
      display: 'inline-block',
      lineHeight: 1
    }),
    input: inputClass,
    slider: css(names.slider, {
      position: 'relative',
      cursor: 'pointer',
      border: 0,
      margin: rem(0.2),
      padding: 0,
      width: rem(width),
      height: rem(height),
      backgroundColor: colors.rest.background,
      borderRadius: rem(height),
      outline: 'none',
      boxShadow: "0 0 0 ".concat(rem(0.1), " ").concat(colors.rest.border),
      $nest: _defineProperty({
        '&:enabled:before': {
          position: 'absolute',
          content: '""',
          height: rem(ballSize),
          width: rem(ballSize),
          left: rem(ballDeltaX),
          top: rem((height - ballSize) / 2),
          backgroundColor: colors.rest.ball,
          transition: '0.2s',
          borderRadius: '50%',
          $nest: (_$nest = {}, _defineProperty(_$nest, ".".concat(inputClass, ":checked + &"), {
            backgroundColor: colors.checked.ball,
            transform: "translateX(".concat(rem(delta), ")")
          }), _defineProperty(_$nest, '&:disabled', {
            backgroundColor: colors.disabled.ball
          }), _$nest)
        },
        '&:disabled:before': {
          position: 'absolute',
          content: '""',
          height: rem(ballSize),
          width: rem(ballSize),
          left: rem(ballDeltaX),
          top: rem((height - ballSize) / 2),
          backgroundColor: colors.disabled.ball,
          transition: '0.2s',
          borderRadius: '50%',
          $nest: _defineProperty({}, ".".concat(inputClass, ":checked + &"), {
            transform: "translateX(".concat(rem(delta), ")")
          })
        },
        '&:focus:enabled': {
          boxShadow: "0 0 0 ".concat(rem(0.2), " ").concat(colors.focus.border),
          outline: 'none'
        },
        '&:disabled': {
          cursor: 'default',
          backgroundColor: colors.disabled.background,
          boxShadow: "0 0 0 ".concat(rem(0.2), " ").concat(colors.disabled.border)
        }
      }, ".".concat(inputClass, ":checked + &:enabled"), {
        backgroundColor: colors.checked.background
      })
    })
  };
}

function light(context) {
  var colors = context.colors;
  return base(context, {
    rest: {
      background: colors.light.gray10,
      ball: colors.light.gray02,
      border: colors.transparent
    },
    focus: {
      border: colors.light.brand00
    },
    disabled: {
      background: colors.light.gray12,
      ball: colors.light.gray06,
      border: colors.transparent
    },
    checked: {
      background: colors.light.green,
      ball: colors.light.white
    }
  });
}

function dark(context) {
  var colors = context.colors;
  return base(context, {
    rest: {
      background: colors.dark.black,
      ball: colors.dark.gray02,
      border: colors.transparent
    },
    focus: {
      border: colors.dark.brand00
    },
    disabled: {
      background: colors.dark.gray12,
      ball: colors.dark.gray06,
      border: colors.transparent
    },
    checked: {
      background: colors.dark.green,
      ball: colors.dark.white
    }
  });
}

function highContrast(context) {
  var colors = context.colors;
  return base(context, {
    rest: {
      background: colors.highContrast.black,
      ball: colors.highContrast.white,
      border: colors.highContrast.white
    },
    focus: {
      border: colors.highContrast.yellow
    },
    disabled: {
      background: colors.highContrast.black,
      ball: colors.highContrast.green,
      border: colors.highContrast.green
    },
    checked: {
      background: colors.highContrast.blue,
      ball: colors.highContrast.black
    }
  });
}

function toggle(context) {
  return context_1.chooseStyle(context, light, dark, highContrast);
}

exports.toggle = toggle;