import { NestedCSSProperties } from 'typestyle/lib/types';
import { ColorPalette } from './colors';
import { IFontSizePalette } from './font-size-palette';
import { IFontWeightPalette } from './font-weight-palette';
import { ISpacingPalette } from './spacing-palette';
import { IThemeConfig } from './theme-config';
import { ThemeStyle } from './theme-style';
export interface IRemFunction {
    (n: number): string;
}
export interface ICSSFunction {
    (name: string, ...objects: Array<false | NestedCSSProperties | null | undefined>): string;
}
export interface IStyleFunction<T> {
    (context: IContext): T;
}
export interface IContext {
    rem: IRemFunction;
    css: ICSSFunction;
    style: ThemeStyle;
    colors: ColorPalette;
    spacing: ISpacingPalette;
    font: {
        weights: IFontWeightPalette;
        sizes: IFontSizePalette;
    };
}
export declare function chooseStyle<T>(context: IContext, light: IStyleFunction<T>, dark: IStyleFunction<T>, highContrast: IStyleFunction<T>): T;
export declare function getContext(config: IThemeConfig): IContext;
