"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});

var lib_1 = require("typestyle/lib");

var colors_1 = require("./colors");

var font_sizes_1 = require("./font-sizes");

var font_weights_1 = require("./font-weights");

var spacing_1 = require("./spacing");

var theme_style_1 = require("./theme-style"); // This function accepts three style functions and based on context,
// calls the right one for the right theme.


function chooseStyle(context, light, dark, highContrast) {
  if (context.style === theme_style_1.ThemeStyle.HighContrast) {
    return highContrast(context);
  } else if (context.style === theme_style_1.ThemeStyle.Dark) {
    return dark(context);
  } else {
    return light(context);
  }
}

exports.chooseStyle = chooseStyle; // Adds the base styles that all components require.

function baseStyleWrapper(styleFunction) {
  return function (name) {
    var baseStyles = {
      boxSizing: 'border-box'
    };

    for (var _len = arguments.length, objects = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
      objects[_key - 1] = arguments[_key];
    }

    return styleFunction.apply(void 0, [name, baseStyles].concat(objects));
  };
} // Wrapper for the typestyle style function that ignores the name parameter.


function typestyleStyle(name) {
  for (var _len2 = arguments.length, objects = new Array(_len2 > 1 ? _len2 - 1 : 0), _key2 = 1; _key2 < _len2; _key2++) {
    objects[_key2 - 1] = arguments[_key2];
  }

  return lib_1.style.apply(lib_1, objects);
} // Returns the context object based on a config.


function getContext(config) {
  // rem is a function that ensures we size the teams components properly
  // based on all possible page font sizes. Users configure the baseFontSize
  // and we normalize it to a base of 10 so that our components are drawn
  // at a consistent size.
  var rem = function rem(n) {
    return "".concat(n * 10.0 / config.baseFontSize, "rem");
  }; // css is the function used to inject the styles into whatever form we
  // want to distribute (directly into webpage, or into a CSS file, etc).
  // We use baseStyleWrapper to add the base styles to all of our
  // components.


  var css = baseStyleWrapper(config.css || typestyleStyle); // Create and return the context object.

  return {
    rem: rem,
    css: css,
    style: config.style,
    colors: config.colors || colors_1.Colors,
    spacing: spacing_1.Spacing(rem),
    font: {
      weights: font_weights_1.FontWeights(rem),
      sizes: font_sizes_1.FontSizes(rem)
    }
  };
}

exports.getContext = getContext;