import * as React from 'react';
export interface UseInputParameters {
    /**
     * The default value. Use when the component is not controlled.
     */
    defaultValue?: unknown;
    /**
     * If `true`, the component is disabled.
     * The prop defaults to the value (`false`) inherited from the parent FormControl component.
     */
    disabled?: boolean;
    /**
     * If `true`, the `input` will indicate an error.
     * The prop defaults to the value (`false`) inherited from the parent FormControl component.
     */
    error?: boolean;
    onBlur?: React.FocusEventHandler;
    onClick?: React.MouseEventHandler;
    onChange?: React.ChangeEventHandler<HTMLInputElement>;
    onFocus?: React.FocusEventHandler;
    inputRef?: React.Ref<HTMLInputElement>;
    /**
     * If `true`, the `input` element is required.
     * The prop defaults to the value (`false`) inherited from the parent FormControl component.
     */
    required?: boolean;
    value?: unknown;
}
export interface UseInputRootSlotOwnProps {
    onClick: React.MouseEventHandler | undefined;
}
export declare type UseInputRootSlotProps<TOther = {}> = Omit<TOther, keyof UseInputRootSlotOwnProps | 'onBlur' | 'onChange' | 'onFocus'> & UseInputRootSlotOwnProps;
export interface UseInputInputSlotOwnProps {
    'aria-invalid': React.AriaAttributes['aria-invalid'];
    defaultValue: string | number | readonly string[] | undefined;
    ref: React.Ref<HTMLInputElement>;
    value: string | number | readonly string[] | undefined;
    onBlur: React.FocusEventHandler;
    onChange: React.ChangeEventHandler<HTMLInputElement>;
    onFocus: React.FocusEventHandler;
    required: boolean;
    disabled: boolean;
}
export declare type UseInputInputSlotProps<TOther = {}> = Omit<TOther, keyof UseInputInputSlotOwnProps> & UseInputInputSlotOwnProps;
