"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _objectWithoutPropertiesLoose2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutPropertiesLoose"));
var _utils = require("@mui/utils");
var _cssVarsParser = _interopRequireDefault(require("./cssVarsParser"));
const _excluded = ["colorSchemes", "components"],
  _excluded2 = ["light"];
function prepareCssVars(theme, parserConfig) {
  // @ts-ignore - ignore components do not exist
  const {
      colorSchemes = {}
    } = theme,
    otherTheme = (0, _objectWithoutPropertiesLoose2.default)(theme, _excluded);
  const {
    vars: rootVars,
    css: rootCss,
    varsWithDefaults: rootVarsWithDefaults
  } = (0, _cssVarsParser.default)(otherTheme, parserConfig);
  let themeVars = rootVarsWithDefaults;
  const colorSchemesMap = {};
  const {
      light
    } = colorSchemes,
    otherColorSchemes = (0, _objectWithoutPropertiesLoose2.default)(colorSchemes, _excluded2);
  Object.entries(otherColorSchemes || {}).forEach(([key, scheme]) => {
    const {
      vars,
      css,
      varsWithDefaults
    } = (0, _cssVarsParser.default)(scheme, parserConfig);
    themeVars = (0, _utils.deepmerge)(themeVars, varsWithDefaults);
    colorSchemesMap[key] = {
      css,
      vars
    };
  });
  if (light) {
    // light color scheme vars should be merged last to set as default
    const {
      css,
      vars,
      varsWithDefaults
    } = (0, _cssVarsParser.default)(light, parserConfig);
    themeVars = (0, _utils.deepmerge)(themeVars, varsWithDefaults);
    colorSchemesMap.light = {
      css,
      vars
    };
  }
  const generateCssVars = colorScheme => {
    if (!colorScheme) {
      return {
        css: (0, _extends2.default)({}, rootCss),
        vars: rootVars
      };
    }
    return {
      css: (0, _extends2.default)({}, colorSchemesMap[colorScheme].css),
      vars: colorSchemesMap[colorScheme].vars
    };
  };
  return {
    vars: themeVars,
    generateCssVars
  };
}
var _default = exports.default = prepareCssVars;