var babelHelpers = require('./babel-helpers.js');
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _angular = babelHelpers.interopRequireDefault(require("angular"));

/**
 * MUI Angular Appbar Component
 * @module angular/appbar
 */
var moduleName = 'mui.appbar';

_angular.default.module(moduleName, []).directive('muiAppbar', function () {
  return {
    restrict: 'AE',
    transclude: true,
    replace: true,
    template: '<div class="mui-appbar"></div>',
    link: function link(scope, element, attrs, controller, transcludeFn) {
      // use transcludeFn to pass ng-controller on parent element
      transcludeFn(scope, function (clone) {
        element.append(clone);
      });
    }
  };
});
/** Define module API */


var _default = moduleName;
exports.default = _default;
module.exports = exports.default;