var babelHelpers = require('./babel-helpers.js');
/**
 * MUI React checkbox module
 * @module react/checkbox
 */

'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _react = require('react');

var _react2 = babelHelpers.interopRequireDefault(_react);

var _util = require('../js/lib/util');

var util = babelHelpers.interopRequireWildcard(_util);

var _helpers = require('./_helpers');

var PropTypes = _react2.default.PropTypes;

/**
 * Checkbox constructor
 * @class
 */

var Checkbox = function (_React$Component) {
  babelHelpers.inherits(Checkbox, _React$Component);

  function Checkbox() {
    babelHelpers.classCallCheck(this, Checkbox);
    return babelHelpers.possibleConstructorReturn(this, (Checkbox.__proto__ || Object.getPrototypeOf(Checkbox)).apply(this, arguments));
  }

  babelHelpers.createClass(Checkbox, [{
    key: 'render',
    value: function render() {
      var _props = this.props;
      var children = _props.children;
      var className = _props.className;
      var label = _props.label;
      var autoFocus = _props.autoFocus;
      var checked = _props.checked;
      var defaultChecked = _props.defaultChecked;
      var defaultValue = _props.defaultValue;
      var disabled = _props.disabled;
      var form = _props.form;
      var name = _props.name;
      var required = _props.required;
      var value = _props.value;
      var onChange = _props.onChange;
      var reactProps = babelHelpers.objectWithoutProperties(_props, ['children', 'className', 'label', 'autoFocus', 'checked', 'defaultChecked', 'defaultValue', 'disabled', 'form', 'name', 'required', 'value', 'onChange']);


      return _react2.default.createElement(
        'div',
        babelHelpers.extends({}, reactProps, {
          className: 'mui-checkbox ' + className
        }),
        _react2.default.createElement(
          'label',
          null,
          _react2.default.createElement('input', {
            ref: 'inputEl',
            type: 'checkbox',
            autoFocus: autoFocus,
            checked: checked,
            defaultChecked: defaultChecked,
            defaultValue: defaultValue,
            disabled: disabled,
            form: form,
            name: name,
            required: required,
            value: value,
            onChange: onChange
          }),
          label
        )
      );
    }
  }]);
  return Checkbox;
}(_react2.default.Component);

/** Define module API */


Checkbox.propTypes = {
  label: PropTypes.string
};
Checkbox.defaultProps = {
  className: '',
  label: null
};
exports.default = Checkbox;
module.exports = exports['default'];