var babelHelpers = require('./babel-helpers.js');
/**
 * MUI React radio module
 * @module react/radio
 */

'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _react = require('react');

var _react2 = babelHelpers.interopRequireDefault(_react);

var PropTypes = _react2.default.PropTypes;

/**
 * Radio constructor
 * @class
 */

var Radio = function (_React$Component) {
  babelHelpers.inherits(Radio, _React$Component);

  function Radio() {
    babelHelpers.classCallCheck(this, Radio);
    return babelHelpers.possibleConstructorReturn(this, (Radio.__proto__ || Object.getPrototypeOf(Radio)).apply(this, arguments));
  }

  babelHelpers.createClass(Radio, [{
    key: 'render',
    value: function render() {
      var _props = this.props;
      var children = _props.children;
      var className = _props.className;
      var label = _props.label;
      var autoFocus = _props.autoFocus;
      var checked = _props.checked;
      var defaultChecked = _props.defaultChecked;
      var defaultValue = _props.defaultValue;
      var disabled = _props.disabled;
      var form = _props.form;
      var name = _props.name;
      var required = _props.required;
      var value = _props.value;
      var onChange = _props.onChange;
      var reactProps = babelHelpers.objectWithoutProperties(_props, ['children', 'className', 'label', 'autoFocus', 'checked', 'defaultChecked', 'defaultValue', 'disabled', 'form', 'name', 'required', 'value', 'onChange']);


      return _react2.default.createElement(
        'div',
        babelHelpers.extends({}, reactProps, {
          className: 'mui-radio ' + className
        }),
        _react2.default.createElement(
          'label',
          null,
          _react2.default.createElement('input', {
            ref: 'inputEl',
            type: 'radio',
            autoFocus: autoFocus,
            checked: checked,
            defaultChecked: defaultChecked,
            defaultValue: defaultValue,
            disabled: disabled,
            form: form,
            name: name,
            required: required,
            value: value,
            onChange: onChange
          }),
          label
        )
      );
    }
  }]);
  return Radio;
}(_react2.default.Component);

/** Define module API */


Radio.propTypes = {
  label: PropTypes.string
};
Radio.defaultProps = {
  className: '',
  label: null
};
exports.default = Radio;
module.exports = exports['default'];