var babelHelpers = require('./babel-helpers.js');
/**
 * MUI React Textfield Helpers
 * @module react/_textfieldHelpers
 */

'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.textfieldWrapper = undefined;

var _react = require('react');

var _react2 = babelHelpers.interopRequireDefault(_react);

var _reactAddonsShallowCompare = require('react-addons-shallow-compare');

var _reactAddonsShallowCompare2 = babelHelpers.interopRequireDefault(_reactAddonsShallowCompare);

var _jqLite = require('../js/lib/jqLite');

var jqLite = babelHelpers.interopRequireWildcard(_jqLite);

var _util = require('../js/lib/util');

var util = babelHelpers.interopRequireWildcard(_util);

var _helpers = require('./_helpers');

/**
 * Textfield Wrapper
 * @function
 */
var textfieldWrapper = function textfieldWrapper(TextfieldComponent) {
  var _class, _temp;

  return _temp = _class = function (_React$Component) {
    babelHelpers.inherits(_class, _React$Component);

    function _class(props) {
      babelHelpers.classCallCheck(this, _class);

      // set initial state
      var _this = babelHelpers.possibleConstructorReturn(this, (_class.__proto__ || Object.getPrototypeOf(_class)).call(this, props));

      _this.state = {
        isEmpty: isEmpty('value' in props ? props.value : props.defaultValue),
        isTouched: false,
        isPristine: true
      };

      // warn if value defined but onChange is not
      if ('value' in props && !props.onChange) {
        util.raiseError(_helpers.controlledMessage, true);
      }

      // callbacks
      var cb = util.callback;
      _this.onBlurCB = cb(_this, 'onBlur');
      _this.onChangeCB = cb(_this, 'onChange');
      _this.onLabelClickCB = cb(_this, 'onLabelClick');
      return _this;
    }

    babelHelpers.createClass(_class, [{
      key: 'onBlur',
      value: function onBlur(ev) {
        // ignore if event is a window blur
        if (document.activeElement !== this.controlEl) {
          this.setState({ isTouched: true });
        }

        // execute callback
        var fn = this.props.onBlur;
        fn && fn(ev);
      }
    }, {
      key: 'onChange',
      value: function onChange(ev) {
        this.setState({
          isEmpty: isEmpty(ev.target.value),
          isPristine: false
        });

        // execute callback
        var fn = this.props.onChange;
        fn && fn(ev);
      }
    }, {
      key: 'onLabelClick',
      value: function onLabelClick(ev) {
        // pointer-events shim
        if (util.supportsPointerEvents() === false) {
          ev.target.style.cursor = 'text';
          this.controlEl.focus();
        }
      }
    }, {
      key: 'componentWillReceiveProps',
      value: function componentWillReceiveProps(nextProps) {
        if ('value' in nextProps) {
          this.setState({ isEmpty: isEmpty(nextProps.value) });
        }
      }
    }, {
      key: 'shouldComponentUpdate',
      value: function shouldComponentUpdate(nextProps, nextState) {
        return (0, _reactAddonsShallowCompare2.default)(this, nextProps, nextState);
      }
    }, {
      key: 'componentDidMount',
      value: function componentDidMount() {
        // disable MUI js
        this.controlEl._muiTextfield = true;
      }
    }, {
      key: 'render',
      value: function render() {
        var _this2 = this;

        var wrapperCls = {},
            inputCls = {},
            labelEl = void 0;

        var _props = this.props,
            children = _props.children,
            className = _props.className,
            style = _props.style,
            hint = _props.hint,
            invalid = _props.invalid,
            label = _props.label,
            floatingLabel = _props.floatingLabel,
            other = babelHelpers.objectWithoutProperties(_props, ['children', 'className', 'style', 'hint', 'invalid', 'label', 'floatingLabel']);


        var labelType = jqLite.type(label);

        if (labelType == 'string' && label.length || labelType == 'object') {
          labelEl = _react2.default.createElement(Label, {
            text: label,
            onClick: this.onClickCB,
            htmlFor: this.props.id
          });
        }

        wrapperCls['mui-textfield'] = true;
        wrapperCls['mui-textfield--float-label'] = floatingLabel;
        wrapperCls = util.classNames(wrapperCls);

        inputCls['mui--is-touched'] = this.state.isTouched;
        inputCls['mui--is-untouched'] = !this.state.isTouched;
        inputCls['mui--is-pristine'] = this.state.isPristine;
        inputCls['mui--is-dirty'] = !this.state.isPristine;
        inputCls['mui--is-empty'] = this.state.isEmpty;
        inputCls['mui--is-not-empty'] = !this.state.isEmpty;
        inputCls['mui--is-invalid'] = invalid;
        inputCls = util.classNames(inputCls);

        return _react2.default.createElement(
          'div',
          {
            className: wrapperCls + ' ' + className,
            style: style
          },
          _react2.default.createElement(TextfieldComponent, babelHelpers.extends({
            className: inputCls,
            inputRef: function inputRef(el) {
              _this2.controlEl = el;
            },
            placeholder: hint
          }, other, {
            onBlur: this.onBlurCB,
            onChange: this.onChangeCB
          })),
          labelEl
        );
      }
    }]);
    return _class;
  }(_react2.default.Component), _class.defaultProps = {
    className: '',
    hint: null,
    invalid: false,
    label: null,
    floatingLabel: false
  }, _temp;
};

/**
 * Label constructor
 * @class
 */

var Label = function (_React$Component2) {
  babelHelpers.inherits(Label, _React$Component2);

  function Label() {
    var _ref;

    var _temp2, _this3, _ret;

    babelHelpers.classCallCheck(this, Label);

    for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    return _ret = (_temp2 = (_this3 = babelHelpers.possibleConstructorReturn(this, (_ref = Label.__proto__ || Object.getPrototypeOf(Label)).call.apply(_ref, [this].concat(args))), _this3), _this3.state = {
      style: {}
    }, _temp2), babelHelpers.possibleConstructorReturn(_this3, _ret);
  }

  babelHelpers.createClass(Label, [{
    key: 'componentDidMount',
    value: function componentDidMount() {
      var _this4 = this;

      this.styleTimer = setTimeout(function () {
        var s = '.15s ease-out';
        var style = void 0;

        style = {
          transition: s,
          WebkitTransition: s,
          MozTransition: s,
          OTransition: s,
          msTransform: s
        };

        _this4.setState({ style: style });
      }, 150);
    }
  }, {
    key: 'componentWillUnmount',
    value: function componentWillUnmount() {
      // clear timer
      clearTimeout(this.styleTimer);
    }
  }, {
    key: 'render',
    value: function render() {
      return _react2.default.createElement(
        'label',
        {
          style: this.state.style,
          onClick: this.props.onClick,
          htmlFor: this.props.htmlFor,
          tabIndex: '-1' // firefox bugfix (see #252)
        },
        this.props.text
      );
    }
  }]);
  return Label;
}(_react2.default.Component);

/**
 * isEmpty helper
 * @function
 */


Label.defaultProps = {
  text: '',
  onClick: null
};
function isEmpty(value) {
  return value === undefined || value === null || value === '';
}

/** Define module API */
exports.textfieldWrapper = textfieldWrapper;