var babelHelpers = require('./babel-helpers.js');
/**
 * MUI React checkbox module
 * @module react/checkbox
 */

'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _react = require('react');

var _react2 = babelHelpers.interopRequireDefault(_react);

var _util = require('../js/lib/util');

var util = babelHelpers.interopRequireWildcard(_util);

var _helpers = require('./_helpers');

/**
 * Checkbox constructor
 * @class
 */
var Checkbox = function (_React$Component) {
  babelHelpers.inherits(Checkbox, _React$Component);

  function Checkbox() {
    babelHelpers.classCallCheck(this, Checkbox);
    return babelHelpers.possibleConstructorReturn(this, (Checkbox.__proto__ || Object.getPrototypeOf(Checkbox)).apply(this, arguments));
  }

  babelHelpers.createClass(Checkbox, [{
    key: 'render',
    value: function render() {
      var _this2 = this;

      var _props = this.props,
          children = _props.children,
          className = _props.className,
          label = _props.label,
          autoFocus = _props.autoFocus,
          checked = _props.checked,
          defaultChecked = _props.defaultChecked,
          defaultValue = _props.defaultValue,
          disabled = _props.disabled,
          form = _props.form,
          name = _props.name,
          required = _props.required,
          value = _props.value,
          onChange = _props.onChange,
          reactProps = babelHelpers.objectWithoutProperties(_props, ['children', 'className', 'label', 'autoFocus', 'checked', 'defaultChecked', 'defaultValue', 'disabled', 'form', 'name', 'required', 'value', 'onChange']);


      return _react2.default.createElement(
        'div',
        babelHelpers.extends({}, reactProps, {
          className: 'mui-checkbox ' + className
        }),
        _react2.default.createElement(
          'label',
          null,
          _react2.default.createElement('input', {
            ref: function ref(el) {
              _this2.controlEl = el;
            },
            type: 'checkbox',
            autoFocus: autoFocus,
            checked: checked,
            defaultChecked: defaultChecked,
            defaultValue: defaultValue,
            disabled: disabled,
            form: form,
            name: name,
            required: required,
            value: value,
            onChange: onChange
          }),
          label
        )
      );
    }
  }]);
  return Checkbox;
}(_react2.default.Component);

/** Define module API */


Checkbox.defaultProps = {
  className: '',
  label: null
};
exports.default = Checkbox;
module.exports = exports['default'];