"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
var Subject_1 = require("rxjs/internal/Subject");
var rxjs_1 = require("rxjs");
var operators_1 = require("rxjs/operators");
var mqtt_1 = require("mqtt");
var mqtt_wildcard_1 = require("./mqtt-wildcard");
var DEFAULT_MQTT_CONFIG = {
    url: '',
    deserializer: function (message) { return JSON.parse(message.toString()); },
    serializer: function (value) { return Buffer.from(JSON.stringify(value)); }
};
var MQTTSubject = /** @class */ (function (_super) {
    __extends(MQTTSubject, _super);
    function MQTTSubject(urlOrConfig, destination) {
        var _this = _super.call(this) || this;
        _this._config = __assign({}, DEFAULT_MQTT_CONFIG);
        /** @deprecated This is an internal implementation detail, do not use. */
        _this._output = new Subject_1.Subject();
        if (typeof urlOrConfig === 'string') {
            _this._config.url = urlOrConfig;
        }
        else {
            for (var key in urlOrConfig) {
                if (urlOrConfig.hasOwnProperty(key)) {
                    _this._config[key] = urlOrConfig[key];
                }
            }
        }
        _this.destination = destination || new rxjs_1.ReplaySubject();
        _this._connectBroker();
        return _this;
    }
    MQTTSubject.prototype.lift = function (operator) {
        var connection = new MQTTSubject(this._config, this.destination);
        // @ts-ignore
        connection.operator = operator;
        connection.source = this;
        // @ts-ignore
        return connection;
    };
    MQTTSubject.prototype._resetState = function () {
        if (this._connection) {
            this._connection.end();
        }
        if (!this.source) {
            this.destination = new rxjs_1.ReplaySubject();
        }
        this._output = new Subject_1.Subject();
    };
    MQTTSubject.prototype.topic = function (topic) {
        if (topic[0] === '/') {
            console.warn("Topic " + topic + " starts with a slash which creates an empty root topic. This is handled differently between different broker implementations. (This is not OSC!)");
        }
        if (this._connection) {
            this._connection.subscribe(topic);
        }
        return new MQTTTopicSubject(this, topic);
    };
    MQTTSubject.prototype._connectBroker = function () {
        var _this = this;
        var _a = this._config, url = _a.url, options = _a.options;
        var observer = this._output;
        var connection = (this._connection = options ? mqtt_1.connect(url, options) : mqtt_1.connect(url));
        connection.on('connect', function (e) {
            var connectObserver = _this._config.connectObserver;
            if (connectObserver) {
                connectObserver.next(e);
            }
            var queue = _this.destination;
            _this.destination = rxjs_1.Subscriber.create(function (command) {
                if (typeof command !== 'object') {
                    observer.error(new Error('ERR_INVALID_ARG_TYPE: Expected MQTTMessage with at least properties topic and message'));
                    return;
                }
                var topic = command.topic, message = command.message, _a = command.qos, qos = _a === void 0 ? 0 : _a, retain = command.retain;
                if (connection && connection.connected) {
                    var serializer = _this._config.serializer;
                    if (!serializer)
                        throw new Error('Serializer is undefined');
                    if (connection) {
                        connection.publish(topic, serializer(message), { qos: qos, retain: retain }, function (error) {
                            if (error && _this.destination)
                                _this.destination.error(e);
                        });
                    }
                }
            }, function (e) {
                var disconnectingObserver = _this._config.disconnectingObserver;
                if (disconnectingObserver) {
                    disconnectingObserver.next(undefined);
                }
                _this._resetState();
            }, function () {
                var disconnectingObserver = _this._config.disconnectingObserver;
                if (disconnectingObserver) {
                    disconnectingObserver.next(undefined);
                }
                connection.end();
                _this._resetState();
            });
            if (queue && queue instanceof rxjs_1.ReplaySubject) {
                ;
                queue.subscribe(_this.destination);
            }
        });
        connection.on('error', function (e) {
            _this._resetState();
            observer.error(e);
        });
        connection.stream.on('error', function (e) {
            _this._resetState();
            observer.error(e);
        });
        connection.on('end', function (e) {
            _this._resetState();
            var disconnectObserver = _this._config.disconnectObserver;
            if (disconnectObserver) {
                disconnectObserver.next(e);
            }
            observer.complete();
        });
        connection.on('message', function (topic, message) {
            // TODO: Serialize/deserialize per topic
            try {
                var deserializer = _this._config.deserializer;
                if (!deserializer)
                    throw new Error('Deserializer is undefined');
                observer.next({
                    topic: topic,
                    message: deserializer(message)
                });
            }
            catch (err) {
                observer.error(err);
            }
        });
    };
    MQTTSubject.prototype.publish = function (topic, message) {
        if (!this.destination)
            return;
        this.destination.next({
            topic: topic,
            message: message
        });
    };
    /** @deprecated This is an internal implementation detail, do not use. */
    MQTTSubject.prototype._subscribe = function (subscriber) {
        var source = this.source;
        if (source) {
            return source.subscribe(subscriber);
        }
        if (this._output) {
            this._output.subscribe(subscriber);
        }
        return subscriber;
    };
    return MQTTSubject;
}(Subject_1.AnonymousSubject));
exports.MQTTSubject = MQTTSubject;
var isWildcardTopic = function (topic) { return topic.includes('#') || topic.includes('+'); };
var MQTTTopicSubject = /** @class */ (function (_super) {
    __extends(MQTTTopicSubject, _super);
    function MQTTTopicSubject(source, _topic) {
        var _this = _super.call(this, source, source) || this;
        _this._topic = _topic;
        _this.source = source;
        return _this;
    }
    MQTTTopicSubject.prototype.publish = function (message) {
        if (isWildcardTopic(this._topic)) {
            throw new Error('INVALIDTOPIC: Cannot publish on wildcard topic');
        }
        var observer = this.source;
        observer.next({ topic: this._topic, message: message });
    };
    MQTTTopicSubject.prototype._subscribe = function (subscriber) {
        // FIXME: Actual subscribe should be executed here
        var _this = this;
        var source = this.source;
        if (source) {
            return this.source
                .pipe(operators_1.filter(function (packet) { return !!mqtt_wildcard_1.default(packet.topic, _this._topic); }))
                .subscribe(subscriber);
        }
        else {
            return rxjs_1.Subscription.EMPTY;
        }
    };
    return MQTTTopicSubject;
}(Subject_1.AnonymousSubject));
exports.MQTTTopicSubject = MQTTTopicSubject;
exports.connect = function (urlOrConfig) {
    return new MQTTSubject(urlOrConfig);
};
//# sourceMappingURL=musquette.js.map