(function (global, factory) {
    typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports, require('bufferutil'), require('utf-8-validate')) :
    typeof define === 'function' && define.amd ? define(['exports', 'bufferutil', 'utf-8-validate'], factory) :
    (global = global || self, factory(global.musquette = {}, global.bufferutil, global.utf8Validate));
}(this, (function (exports, bufferutil, utf8Validate) { 'use strict';

    bufferutil = bufferutil && Object.prototype.hasOwnProperty.call(bufferutil, 'default') ? bufferutil['default'] : bufferutil;
    utf8Validate = utf8Validate && Object.prototype.hasOwnProperty.call(utf8Validate, 'default') ? utf8Validate['default'] : utf8Validate;

    /*! *****************************************************************************
    Copyright (c) Microsoft Corporation. All rights reserved.
    Licensed under the Apache License, Version 2.0 (the "License"); you may not use
    this file except in compliance with the License. You may obtain a copy of the
    License at http://www.apache.org/licenses/LICENSE-2.0

    THIS CODE IS PROVIDED ON AN *AS IS* BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
    KIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION ANY IMPLIED
    WARRANTIES OR CONDITIONS OF TITLE, FITNESS FOR A PARTICULAR PURPOSE,
    MERCHANTABLITY OR NON-INFRINGEMENT.

    See the Apache Version 2.0 License for specific language governing permissions
    and limitations under the License.
    ***************************************************************************** */
    /* global Reflect, Promise */

    var extendStatics = function(d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };

    function __extends(d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    }

    var __assign = function() {
        __assign = Object.assign || function __assign(t) {
            for (var s, i = 1, n = arguments.length; i < n; i++) {
                s = arguments[i];
                for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p)) t[p] = s[p];
            }
            return t;
        };
        return __assign.apply(this, arguments);
    };

    var commonjsGlobal = typeof globalThis !== 'undefined' ? globalThis : typeof window !== 'undefined' ? window : typeof global !== 'undefined' ? global : typeof self !== 'undefined' ? self : {};

    function commonjsRequire () {
    	throw new Error('Dynamic requires are not currently supported by rollup-plugin-commonjs');
    }

    function unwrapExports (x) {
    	return x && x.__esModule && Object.prototype.hasOwnProperty.call(x, 'default') ? x['default'] : x;
    }

    function createCommonjsModule(fn, module) {
    	return module = { exports: {} }, fn(module, module.exports), module.exports;
    }

    function getCjsExportFromNamespace (n) {
    	return n && n['default'] || n;
    }

    var isFunction_1 = createCommonjsModule(function (module, exports) {
    Object.defineProperty(exports, "__esModule", { value: true });
    function isFunction(x) {
        return typeof x === 'function';
    }
    exports.isFunction = isFunction;

    });

    unwrapExports(isFunction_1);
    var isFunction_2 = isFunction_1.isFunction;

    var config = createCommonjsModule(function (module, exports) {
    Object.defineProperty(exports, "__esModule", { value: true });
    var _enable_super_gross_mode_that_will_cause_bad_things = false;
    exports.config = {
        Promise: undefined,
        set useDeprecatedSynchronousErrorHandling(value) {
            if (value) {
                var error = new Error();
                console.warn('DEPRECATED! RxJS was set to use deprecated synchronous error handling behavior by code at: \n' + error.stack);
            }
            else if (_enable_super_gross_mode_that_will_cause_bad_things) {
                console.log('RxJS: Back to a better error behavior. Thank you. <3');
            }
            _enable_super_gross_mode_that_will_cause_bad_things = value;
        },
        get useDeprecatedSynchronousErrorHandling() {
            return _enable_super_gross_mode_that_will_cause_bad_things;
        },
    };

    });

    unwrapExports(config);
    var config_1 = config.config;

    var hostReportError_1 = createCommonjsModule(function (module, exports) {
    Object.defineProperty(exports, "__esModule", { value: true });
    function hostReportError(err) {
        setTimeout(function () { throw err; }, 0);
    }
    exports.hostReportError = hostReportError;

    });

    unwrapExports(hostReportError_1);
    var hostReportError_2 = hostReportError_1.hostReportError;

    var Observer = createCommonjsModule(function (module, exports) {
    Object.defineProperty(exports, "__esModule", { value: true });


    exports.empty = {
        closed: true,
        next: function (value) { },
        error: function (err) {
            if (config.config.useDeprecatedSynchronousErrorHandling) {
                throw err;
            }
            else {
                hostReportError_1.hostReportError(err);
            }
        },
        complete: function () { }
    };

    });

    unwrapExports(Observer);
    var Observer_1 = Observer.empty;

    var isArray = createCommonjsModule(function (module, exports) {
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.isArray = (function () { return Array.isArray || (function (x) { return x && typeof x.length === 'number'; }); })();

    });

    unwrapExports(isArray);
    var isArray_1 = isArray.isArray;

    var isObject_1 = createCommonjsModule(function (module, exports) {
    Object.defineProperty(exports, "__esModule", { value: true });
    function isObject(x) {
        return x !== null && typeof x === 'object';
    }
    exports.isObject = isObject;

    });

    unwrapExports(isObject_1);
    var isObject_2 = isObject_1.isObject;

    var UnsubscriptionError = createCommonjsModule(function (module, exports) {
    Object.defineProperty(exports, "__esModule", { value: true });
    var UnsubscriptionErrorImpl = (function () {
        function UnsubscriptionErrorImpl(errors) {
            Error.call(this);
            this.message = errors ?
                errors.length + " errors occurred during unsubscription:\n" + errors.map(function (err, i) { return i + 1 + ") " + err.toString(); }).join('\n  ') : '';
            this.name = 'UnsubscriptionError';
            this.errors = errors;
            return this;
        }
        UnsubscriptionErrorImpl.prototype = Object.create(Error.prototype);
        return UnsubscriptionErrorImpl;
    })();
    exports.UnsubscriptionError = UnsubscriptionErrorImpl;

    });

    unwrapExports(UnsubscriptionError);
    var UnsubscriptionError_1 = UnsubscriptionError.UnsubscriptionError;

    var Subscription_1 = createCommonjsModule(function (module, exports) {
    Object.defineProperty(exports, "__esModule", { value: true });




    var Subscription = (function () {
        function Subscription(unsubscribe) {
            this.closed = false;
            this._parentOrParents = null;
            this._subscriptions = null;
            if (unsubscribe) {
                this._unsubscribe = unsubscribe;
            }
        }
        Subscription.prototype.unsubscribe = function () {
            var errors;
            if (this.closed) {
                return;
            }
            var _a = this, _parentOrParents = _a._parentOrParents, _unsubscribe = _a._unsubscribe, _subscriptions = _a._subscriptions;
            this.closed = true;
            this._parentOrParents = null;
            this._subscriptions = null;
            if (_parentOrParents instanceof Subscription) {
                _parentOrParents.remove(this);
            }
            else if (_parentOrParents !== null) {
                for (var index = 0; index < _parentOrParents.length; ++index) {
                    var parent_1 = _parentOrParents[index];
                    parent_1.remove(this);
                }
            }
            if (isFunction_1.isFunction(_unsubscribe)) {
                try {
                    _unsubscribe.call(this);
                }
                catch (e) {
                    errors = e instanceof UnsubscriptionError.UnsubscriptionError ? flattenUnsubscriptionErrors(e.errors) : [e];
                }
            }
            if (isArray.isArray(_subscriptions)) {
                var index = -1;
                var len = _subscriptions.length;
                while (++index < len) {
                    var sub = _subscriptions[index];
                    if (isObject_1.isObject(sub)) {
                        try {
                            sub.unsubscribe();
                        }
                        catch (e) {
                            errors = errors || [];
                            if (e instanceof UnsubscriptionError.UnsubscriptionError) {
                                errors = errors.concat(flattenUnsubscriptionErrors(e.errors));
                            }
                            else {
                                errors.push(e);
                            }
                        }
                    }
                }
            }
            if (errors) {
                throw new UnsubscriptionError.UnsubscriptionError(errors);
            }
        };
        Subscription.prototype.add = function (teardown) {
            var subscription = teardown;
            if (!teardown) {
                return Subscription.EMPTY;
            }
            switch (typeof teardown) {
                case 'function':
                    subscription = new Subscription(teardown);
                case 'object':
                    if (subscription === this || subscription.closed || typeof subscription.unsubscribe !== 'function') {
                        return subscription;
                    }
                    else if (this.closed) {
                        subscription.unsubscribe();
                        return subscription;
                    }
                    else if (!(subscription instanceof Subscription)) {
                        var tmp = subscription;
                        subscription = new Subscription();
                        subscription._subscriptions = [tmp];
                    }
                    break;
                default: {
                    throw new Error('unrecognized teardown ' + teardown + ' added to Subscription.');
                }
            }
            var _parentOrParents = subscription._parentOrParents;
            if (_parentOrParents === null) {
                subscription._parentOrParents = this;
            }
            else if (_parentOrParents instanceof Subscription) {
                if (_parentOrParents === this) {
                    return subscription;
                }
                subscription._parentOrParents = [_parentOrParents, this];
            }
            else if (_parentOrParents.indexOf(this) === -1) {
                _parentOrParents.push(this);
            }
            else {
                return subscription;
            }
            var subscriptions = this._subscriptions;
            if (subscriptions === null) {
                this._subscriptions = [subscription];
            }
            else {
                subscriptions.push(subscription);
            }
            return subscription;
        };
        Subscription.prototype.remove = function (subscription) {
            var subscriptions = this._subscriptions;
            if (subscriptions) {
                var subscriptionIndex = subscriptions.indexOf(subscription);
                if (subscriptionIndex !== -1) {
                    subscriptions.splice(subscriptionIndex, 1);
                }
            }
        };
        Subscription.EMPTY = (function (empty) {
            empty.closed = true;
            return empty;
        }(new Subscription()));
        return Subscription;
    }());
    exports.Subscription = Subscription;
    function flattenUnsubscriptionErrors(errors) {
        return errors.reduce(function (errs, err) { return errs.concat((err instanceof UnsubscriptionError.UnsubscriptionError) ? err.errors : err); }, []);
    }

    });

    unwrapExports(Subscription_1);
    var Subscription_2 = Subscription_1.Subscription;

    var rxSubscriber = createCommonjsModule(function (module, exports) {
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.rxSubscriber = (function () {
        return typeof Symbol === 'function'
            ? Symbol('rxSubscriber')
            : '@@rxSubscriber_' + Math.random();
    })();
    exports.$$rxSubscriber = exports.rxSubscriber;

    });

    unwrapExports(rxSubscriber);
    var rxSubscriber_1 = rxSubscriber.rxSubscriber;
    var rxSubscriber_2 = rxSubscriber.$$rxSubscriber;

    var Subscriber_1 = createCommonjsModule(function (module, exports) {
    var __extends = (commonjsGlobal && commonjsGlobal.__extends) || (function () {
        var extendStatics = function (d, b) {
            extendStatics = Object.setPrototypeOf ||
                ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
                function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
            return extendStatics(d, b);
        };
        return function (d, b) {
            extendStatics(d, b);
            function __() { this.constructor = d; }
            d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
        };
    })();
    Object.defineProperty(exports, "__esModule", { value: true });






    var Subscriber = (function (_super) {
        __extends(Subscriber, _super);
        function Subscriber(destinationOrNext, error, complete) {
            var _this = _super.call(this) || this;
            _this.syncErrorValue = null;
            _this.syncErrorThrown = false;
            _this.syncErrorThrowable = false;
            _this.isStopped = false;
            switch (arguments.length) {
                case 0:
                    _this.destination = Observer.empty;
                    break;
                case 1:
                    if (!destinationOrNext) {
                        _this.destination = Observer.empty;
                        break;
                    }
                    if (typeof destinationOrNext === 'object') {
                        if (destinationOrNext instanceof Subscriber) {
                            _this.syncErrorThrowable = destinationOrNext.syncErrorThrowable;
                            _this.destination = destinationOrNext;
                            destinationOrNext.add(_this);
                        }
                        else {
                            _this.syncErrorThrowable = true;
                            _this.destination = new SafeSubscriber(_this, destinationOrNext);
                        }
                        break;
                    }
                default:
                    _this.syncErrorThrowable = true;
                    _this.destination = new SafeSubscriber(_this, destinationOrNext, error, complete);
                    break;
            }
            return _this;
        }
        Subscriber.prototype[rxSubscriber.rxSubscriber] = function () { return this; };
        Subscriber.create = function (next, error, complete) {
            var subscriber = new Subscriber(next, error, complete);
            subscriber.syncErrorThrowable = false;
            return subscriber;
        };
        Subscriber.prototype.next = function (value) {
            if (!this.isStopped) {
                this._next(value);
            }
        };
        Subscriber.prototype.error = function (err) {
            if (!this.isStopped) {
                this.isStopped = true;
                this._error(err);
            }
        };
        Subscriber.prototype.complete = function () {
            if (!this.isStopped) {
                this.isStopped = true;
                this._complete();
            }
        };
        Subscriber.prototype.unsubscribe = function () {
            if (this.closed) {
                return;
            }
            this.isStopped = true;
            _super.prototype.unsubscribe.call(this);
        };
        Subscriber.prototype._next = function (value) {
            this.destination.next(value);
        };
        Subscriber.prototype._error = function (err) {
            this.destination.error(err);
            this.unsubscribe();
        };
        Subscriber.prototype._complete = function () {
            this.destination.complete();
            this.unsubscribe();
        };
        Subscriber.prototype._unsubscribeAndRecycle = function () {
            var _parentOrParents = this._parentOrParents;
            this._parentOrParents = null;
            this.unsubscribe();
            this.closed = false;
            this.isStopped = false;
            this._parentOrParents = _parentOrParents;
            return this;
        };
        return Subscriber;
    }(Subscription_1.Subscription));
    exports.Subscriber = Subscriber;
    var SafeSubscriber = (function (_super) {
        __extends(SafeSubscriber, _super);
        function SafeSubscriber(_parentSubscriber, observerOrNext, error, complete) {
            var _this = _super.call(this) || this;
            _this._parentSubscriber = _parentSubscriber;
            var next;
            var context = _this;
            if (isFunction_1.isFunction(observerOrNext)) {
                next = observerOrNext;
            }
            else if (observerOrNext) {
                next = observerOrNext.next;
                error = observerOrNext.error;
                complete = observerOrNext.complete;
                if (observerOrNext !== Observer.empty) {
                    context = Object.create(observerOrNext);
                    if (isFunction_1.isFunction(context.unsubscribe)) {
                        _this.add(context.unsubscribe.bind(context));
                    }
                    context.unsubscribe = _this.unsubscribe.bind(_this);
                }
            }
            _this._context = context;
            _this._next = next;
            _this._error = error;
            _this._complete = complete;
            return _this;
        }
        SafeSubscriber.prototype.next = function (value) {
            if (!this.isStopped && this._next) {
                var _parentSubscriber = this._parentSubscriber;
                if (!config.config.useDeprecatedSynchronousErrorHandling || !_parentSubscriber.syncErrorThrowable) {
                    this.__tryOrUnsub(this._next, value);
                }
                else if (this.__tryOrSetError(_parentSubscriber, this._next, value)) {
                    this.unsubscribe();
                }
            }
        };
        SafeSubscriber.prototype.error = function (err) {
            if (!this.isStopped) {
                var _parentSubscriber = this._parentSubscriber;
                var useDeprecatedSynchronousErrorHandling = config.config.useDeprecatedSynchronousErrorHandling;
                if (this._error) {
                    if (!useDeprecatedSynchronousErrorHandling || !_parentSubscriber.syncErrorThrowable) {
                        this.__tryOrUnsub(this._error, err);
                        this.unsubscribe();
                    }
                    else {
                        this.__tryOrSetError(_parentSubscriber, this._error, err);
                        this.unsubscribe();
                    }
                }
                else if (!_parentSubscriber.syncErrorThrowable) {
                    this.unsubscribe();
                    if (useDeprecatedSynchronousErrorHandling) {
                        throw err;
                    }
                    hostReportError_1.hostReportError(err);
                }
                else {
                    if (useDeprecatedSynchronousErrorHandling) {
                        _parentSubscriber.syncErrorValue = err;
                        _parentSubscriber.syncErrorThrown = true;
                    }
                    else {
                        hostReportError_1.hostReportError(err);
                    }
                    this.unsubscribe();
                }
            }
        };
        SafeSubscriber.prototype.complete = function () {
            var _this = this;
            if (!this.isStopped) {
                var _parentSubscriber = this._parentSubscriber;
                if (this._complete) {
                    var wrappedComplete = function () { return _this._complete.call(_this._context); };
                    if (!config.config.useDeprecatedSynchronousErrorHandling || !_parentSubscriber.syncErrorThrowable) {
                        this.__tryOrUnsub(wrappedComplete);
                        this.unsubscribe();
                    }
                    else {
                        this.__tryOrSetError(_parentSubscriber, wrappedComplete);
                        this.unsubscribe();
                    }
                }
                else {
                    this.unsubscribe();
                }
            }
        };
        SafeSubscriber.prototype.__tryOrUnsub = function (fn, value) {
            try {
                fn.call(this._context, value);
            }
            catch (err) {
                this.unsubscribe();
                if (config.config.useDeprecatedSynchronousErrorHandling) {
                    throw err;
                }
                else {
                    hostReportError_1.hostReportError(err);
                }
            }
        };
        SafeSubscriber.prototype.__tryOrSetError = function (parent, fn, value) {
            if (!config.config.useDeprecatedSynchronousErrorHandling) {
                throw new Error('bad call');
            }
            try {
                fn.call(this._context, value);
            }
            catch (err) {
                if (config.config.useDeprecatedSynchronousErrorHandling) {
                    parent.syncErrorValue = err;
                    parent.syncErrorThrown = true;
                    return true;
                }
                else {
                    hostReportError_1.hostReportError(err);
                    return true;
                }
            }
            return false;
        };
        SafeSubscriber.prototype._unsubscribe = function () {
            var _parentSubscriber = this._parentSubscriber;
            this._context = null;
            this._parentSubscriber = null;
            _parentSubscriber.unsubscribe();
        };
        return SafeSubscriber;
    }(Subscriber));
    exports.SafeSubscriber = SafeSubscriber;

    });

    unwrapExports(Subscriber_1);
    var Subscriber_2 = Subscriber_1.Subscriber;
    var Subscriber_3 = Subscriber_1.SafeSubscriber;

    var canReportError_1 = createCommonjsModule(function (module, exports) {
    Object.defineProperty(exports, "__esModule", { value: true });

    function canReportError(observer) {
        while (observer) {
            var _a = observer, closed_1 = _a.closed, destination = _a.destination, isStopped = _a.isStopped;
            if (closed_1 || isStopped) {
                return false;
            }
            else if (destination && destination instanceof Subscriber_1.Subscriber) {
                observer = destination;
            }
            else {
                observer = null;
            }
        }
        return true;
    }
    exports.canReportError = canReportError;

    });

    unwrapExports(canReportError_1);
    var canReportError_2 = canReportError_1.canReportError;

    var toSubscriber_1 = createCommonjsModule(function (module, exports) {
    Object.defineProperty(exports, "__esModule", { value: true });



    function toSubscriber(nextOrObserver, error, complete) {
        if (nextOrObserver) {
            if (nextOrObserver instanceof Subscriber_1.Subscriber) {
                return nextOrObserver;
            }
            if (nextOrObserver[rxSubscriber.rxSubscriber]) {
                return nextOrObserver[rxSubscriber.rxSubscriber]();
            }
        }
        if (!nextOrObserver && !error && !complete) {
            return new Subscriber_1.Subscriber(Observer.empty);
        }
        return new Subscriber_1.Subscriber(nextOrObserver, error, complete);
    }
    exports.toSubscriber = toSubscriber;

    });

    unwrapExports(toSubscriber_1);
    var toSubscriber_2 = toSubscriber_1.toSubscriber;

    var observable = createCommonjsModule(function (module, exports) {
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.observable = (function () { return typeof Symbol === 'function' && Symbol.observable || '@@observable'; })();

    });

    unwrapExports(observable);
    var observable_1 = observable.observable;

    var noop_1 = createCommonjsModule(function (module, exports) {
    Object.defineProperty(exports, "__esModule", { value: true });
    function noop() { }
    exports.noop = noop;

    });

    unwrapExports(noop_1);
    var noop_2 = noop_1.noop;

    var pipe_1 = createCommonjsModule(function (module, exports) {
    Object.defineProperty(exports, "__esModule", { value: true });

    function pipe() {
        var fns = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            fns[_i] = arguments[_i];
        }
        return pipeFromArray(fns);
    }
    exports.pipe = pipe;
    function pipeFromArray(fns) {
        if (!fns) {
            return noop_1.noop;
        }
        if (fns.length === 1) {
            return fns[0];
        }
        return function piped(input) {
            return fns.reduce(function (prev, fn) { return fn(prev); }, input);
        };
    }
    exports.pipeFromArray = pipeFromArray;

    });

    unwrapExports(pipe_1);
    var pipe_2 = pipe_1.pipe;
    var pipe_3 = pipe_1.pipeFromArray;

    var Observable_1 = createCommonjsModule(function (module, exports) {
    Object.defineProperty(exports, "__esModule", { value: true });





    var Observable = (function () {
        function Observable(subscribe) {
            this._isScalar = false;
            if (subscribe) {
                this._subscribe = subscribe;
            }
        }
        Observable.prototype.lift = function (operator) {
            var observable = new Observable();
            observable.source = this;
            observable.operator = operator;
            return observable;
        };
        Observable.prototype.subscribe = function (observerOrNext, error, complete) {
            var operator = this.operator;
            var sink = toSubscriber_1.toSubscriber(observerOrNext, error, complete);
            if (operator) {
                sink.add(operator.call(sink, this.source));
            }
            else {
                sink.add(this.source || (config.config.useDeprecatedSynchronousErrorHandling && !sink.syncErrorThrowable) ?
                    this._subscribe(sink) :
                    this._trySubscribe(sink));
            }
            if (config.config.useDeprecatedSynchronousErrorHandling) {
                if (sink.syncErrorThrowable) {
                    sink.syncErrorThrowable = false;
                    if (sink.syncErrorThrown) {
                        throw sink.syncErrorValue;
                    }
                }
            }
            return sink;
        };
        Observable.prototype._trySubscribe = function (sink) {
            try {
                return this._subscribe(sink);
            }
            catch (err) {
                if (config.config.useDeprecatedSynchronousErrorHandling) {
                    sink.syncErrorThrown = true;
                    sink.syncErrorValue = err;
                }
                if (canReportError_1.canReportError(sink)) {
                    sink.error(err);
                }
                else {
                    console.warn(err);
                }
            }
        };
        Observable.prototype.forEach = function (next, promiseCtor) {
            var _this = this;
            promiseCtor = getPromiseCtor(promiseCtor);
            return new promiseCtor(function (resolve, reject) {
                var subscription;
                subscription = _this.subscribe(function (value) {
                    try {
                        next(value);
                    }
                    catch (err) {
                        reject(err);
                        if (subscription) {
                            subscription.unsubscribe();
                        }
                    }
                }, reject, resolve);
            });
        };
        Observable.prototype._subscribe = function (subscriber) {
            var source = this.source;
            return source && source.subscribe(subscriber);
        };
        Observable.prototype[observable.observable] = function () {
            return this;
        };
        Observable.prototype.pipe = function () {
            var operations = [];
            for (var _i = 0; _i < arguments.length; _i++) {
                operations[_i] = arguments[_i];
            }
            if (operations.length === 0) {
                return this;
            }
            return pipe_1.pipeFromArray(operations)(this);
        };
        Observable.prototype.toPromise = function (promiseCtor) {
            var _this = this;
            promiseCtor = getPromiseCtor(promiseCtor);
            return new promiseCtor(function (resolve, reject) {
                var value;
                _this.subscribe(function (x) { return value = x; }, function (err) { return reject(err); }, function () { return resolve(value); });
            });
        };
        Observable.create = function (subscribe) {
            return new Observable(subscribe);
        };
        return Observable;
    }());
    exports.Observable = Observable;
    function getPromiseCtor(promiseCtor) {
        if (!promiseCtor) {
            promiseCtor = config.config.Promise || Promise;
        }
        if (!promiseCtor) {
            throw new Error('no Promise impl found');
        }
        return promiseCtor;
    }

    });

    unwrapExports(Observable_1);
    var Observable_2 = Observable_1.Observable;

    var ObjectUnsubscribedError = createCommonjsModule(function (module, exports) {
    Object.defineProperty(exports, "__esModule", { value: true });
    var ObjectUnsubscribedErrorImpl = (function () {
        function ObjectUnsubscribedErrorImpl() {
            Error.call(this);
            this.message = 'object unsubscribed';
            this.name = 'ObjectUnsubscribedError';
            return this;
        }
        ObjectUnsubscribedErrorImpl.prototype = Object.create(Error.prototype);
        return ObjectUnsubscribedErrorImpl;
    })();
    exports.ObjectUnsubscribedError = ObjectUnsubscribedErrorImpl;

    });

    unwrapExports(ObjectUnsubscribedError);
    var ObjectUnsubscribedError_1 = ObjectUnsubscribedError.ObjectUnsubscribedError;

    var SubjectSubscription_1 = createCommonjsModule(function (module, exports) {
    var __extends = (commonjsGlobal && commonjsGlobal.__extends) || (function () {
        var extendStatics = function (d, b) {
            extendStatics = Object.setPrototypeOf ||
                ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
                function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
            return extendStatics(d, b);
        };
        return function (d, b) {
            extendStatics(d, b);
            function __() { this.constructor = d; }
            d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
        };
    })();
    Object.defineProperty(exports, "__esModule", { value: true });

    var SubjectSubscription = (function (_super) {
        __extends(SubjectSubscription, _super);
        function SubjectSubscription(subject, subscriber) {
            var _this = _super.call(this) || this;
            _this.subject = subject;
            _this.subscriber = subscriber;
            _this.closed = false;
            return _this;
        }
        SubjectSubscription.prototype.unsubscribe = function () {
            if (this.closed) {
                return;
            }
            this.closed = true;
            var subject = this.subject;
            var observers = subject.observers;
            this.subject = null;
            if (!observers || observers.length === 0 || subject.isStopped || subject.closed) {
                return;
            }
            var subscriberIndex = observers.indexOf(this.subscriber);
            if (subscriberIndex !== -1) {
                observers.splice(subscriberIndex, 1);
            }
        };
        return SubjectSubscription;
    }(Subscription_1.Subscription));
    exports.SubjectSubscription = SubjectSubscription;

    });

    unwrapExports(SubjectSubscription_1);
    var SubjectSubscription_2 = SubjectSubscription_1.SubjectSubscription;

    var Subject_1 = createCommonjsModule(function (module, exports) {
    var __extends = (commonjsGlobal && commonjsGlobal.__extends) || (function () {
        var extendStatics = function (d, b) {
            extendStatics = Object.setPrototypeOf ||
                ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
                function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
            return extendStatics(d, b);
        };
        return function (d, b) {
            extendStatics(d, b);
            function __() { this.constructor = d; }
            d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
        };
    })();
    Object.defineProperty(exports, "__esModule", { value: true });






    var SubjectSubscriber = (function (_super) {
        __extends(SubjectSubscriber, _super);
        function SubjectSubscriber(destination) {
            var _this = _super.call(this, destination) || this;
            _this.destination = destination;
            return _this;
        }
        return SubjectSubscriber;
    }(Subscriber_1.Subscriber));
    exports.SubjectSubscriber = SubjectSubscriber;
    var Subject = (function (_super) {
        __extends(Subject, _super);
        function Subject() {
            var _this = _super.call(this) || this;
            _this.observers = [];
            _this.closed = false;
            _this.isStopped = false;
            _this.hasError = false;
            _this.thrownError = null;
            return _this;
        }
        Subject.prototype[rxSubscriber.rxSubscriber] = function () {
            return new SubjectSubscriber(this);
        };
        Subject.prototype.lift = function (operator) {
            var subject = new AnonymousSubject(this, this);
            subject.operator = operator;
            return subject;
        };
        Subject.prototype.next = function (value) {
            if (this.closed) {
                throw new ObjectUnsubscribedError.ObjectUnsubscribedError();
            }
            if (!this.isStopped) {
                var observers = this.observers;
                var len = observers.length;
                var copy = observers.slice();
                for (var i = 0; i < len; i++) {
                    copy[i].next(value);
                }
            }
        };
        Subject.prototype.error = function (err) {
            if (this.closed) {
                throw new ObjectUnsubscribedError.ObjectUnsubscribedError();
            }
            this.hasError = true;
            this.thrownError = err;
            this.isStopped = true;
            var observers = this.observers;
            var len = observers.length;
            var copy = observers.slice();
            for (var i = 0; i < len; i++) {
                copy[i].error(err);
            }
            this.observers.length = 0;
        };
        Subject.prototype.complete = function () {
            if (this.closed) {
                throw new ObjectUnsubscribedError.ObjectUnsubscribedError();
            }
            this.isStopped = true;
            var observers = this.observers;
            var len = observers.length;
            var copy = observers.slice();
            for (var i = 0; i < len; i++) {
                copy[i].complete();
            }
            this.observers.length = 0;
        };
        Subject.prototype.unsubscribe = function () {
            this.isStopped = true;
            this.closed = true;
            this.observers = null;
        };
        Subject.prototype._trySubscribe = function (subscriber) {
            if (this.closed) {
                throw new ObjectUnsubscribedError.ObjectUnsubscribedError();
            }
            else {
                return _super.prototype._trySubscribe.call(this, subscriber);
            }
        };
        Subject.prototype._subscribe = function (subscriber) {
            if (this.closed) {
                throw new ObjectUnsubscribedError.ObjectUnsubscribedError();
            }
            else if (this.hasError) {
                subscriber.error(this.thrownError);
                return Subscription_1.Subscription.EMPTY;
            }
            else if (this.isStopped) {
                subscriber.complete();
                return Subscription_1.Subscription.EMPTY;
            }
            else {
                this.observers.push(subscriber);
                return new SubjectSubscription_1.SubjectSubscription(this, subscriber);
            }
        };
        Subject.prototype.asObservable = function () {
            var observable = new Observable_1.Observable();
            observable.source = this;
            return observable;
        };
        Subject.create = function (destination, source) {
            return new AnonymousSubject(destination, source);
        };
        return Subject;
    }(Observable_1.Observable));
    exports.Subject = Subject;
    var AnonymousSubject = (function (_super) {
        __extends(AnonymousSubject, _super);
        function AnonymousSubject(destination, source) {
            var _this = _super.call(this) || this;
            _this.destination = destination;
            _this.source = source;
            return _this;
        }
        AnonymousSubject.prototype.next = function (value) {
            var destination = this.destination;
            if (destination && destination.next) {
                destination.next(value);
            }
        };
        AnonymousSubject.prototype.error = function (err) {
            var destination = this.destination;
            if (destination && destination.error) {
                this.destination.error(err);
            }
        };
        AnonymousSubject.prototype.complete = function () {
            var destination = this.destination;
            if (destination && destination.complete) {
                this.destination.complete();
            }
        };
        AnonymousSubject.prototype._subscribe = function (subscriber) {
            var source = this.source;
            if (source) {
                return this.source.subscribe(subscriber);
            }
            else {
                return Subscription_1.Subscription.EMPTY;
            }
        };
        return AnonymousSubject;
    }(Subject));
    exports.AnonymousSubject = AnonymousSubject;

    });

    unwrapExports(Subject_1);
    var Subject_2 = Subject_1.SubjectSubscriber;
    var Subject_3 = Subject_1.Subject;
    var Subject_4 = Subject_1.AnonymousSubject;

    /** PURE_IMPORTS_START  PURE_IMPORTS_END */
    function isFunction(x) {
        return typeof x === 'function';
    }

    /** PURE_IMPORTS_START  PURE_IMPORTS_END */
    var _enable_super_gross_mode_that_will_cause_bad_things = false;
    var config$1 = {
        Promise: undefined,
        set useDeprecatedSynchronousErrorHandling(value) {
            if (value) {
                var error = /*@__PURE__*/ new Error();
                /*@__PURE__*/ console.warn('DEPRECATED! RxJS was set to use deprecated synchronous error handling behavior by code at: \n' + error.stack);
            }
            _enable_super_gross_mode_that_will_cause_bad_things = value;
        },
        get useDeprecatedSynchronousErrorHandling() {
            return _enable_super_gross_mode_that_will_cause_bad_things;
        },
    };

    /** PURE_IMPORTS_START  PURE_IMPORTS_END */
    function hostReportError(err) {
        setTimeout(function () { throw err; }, 0);
    }

    /** PURE_IMPORTS_START _config,_util_hostReportError PURE_IMPORTS_END */
    var empty = {
        closed: true,
        next: function (value) { },
        error: function (err) {
            if (config$1.useDeprecatedSynchronousErrorHandling) {
                throw err;
            }
            else {
                hostReportError(err);
            }
        },
        complete: function () { }
    };

    /** PURE_IMPORTS_START  PURE_IMPORTS_END */
    var isArray$1 = /*@__PURE__*/ (function () { return Array.isArray || (function (x) { return x && typeof x.length === 'number'; }); })();

    /** PURE_IMPORTS_START  PURE_IMPORTS_END */
    function isObject(x) {
        return x !== null && typeof x === 'object';
    }

    /** PURE_IMPORTS_START  PURE_IMPORTS_END */
    var UnsubscriptionErrorImpl = /*@__PURE__*/ (function () {
        function UnsubscriptionErrorImpl(errors) {
            Error.call(this);
            this.message = errors ?
                errors.length + " errors occurred during unsubscription:\n" + errors.map(function (err, i) { return i + 1 + ") " + err.toString(); }).join('\n  ') : '';
            this.name = 'UnsubscriptionError';
            this.errors = errors;
            return this;
        }
        UnsubscriptionErrorImpl.prototype = /*@__PURE__*/ Object.create(Error.prototype);
        return UnsubscriptionErrorImpl;
    })();
    var UnsubscriptionError$1 = UnsubscriptionErrorImpl;

    /** PURE_IMPORTS_START _util_isArray,_util_isObject,_util_isFunction,_util_UnsubscriptionError PURE_IMPORTS_END */
    var Subscription = /*@__PURE__*/ (function () {
        function Subscription(unsubscribe) {
            this.closed = false;
            this._parentOrParents = null;
            this._subscriptions = null;
            if (unsubscribe) {
                this._unsubscribe = unsubscribe;
            }
        }
        Subscription.prototype.unsubscribe = function () {
            var errors;
            if (this.closed) {
                return;
            }
            var _a = this, _parentOrParents = _a._parentOrParents, _unsubscribe = _a._unsubscribe, _subscriptions = _a._subscriptions;
            this.closed = true;
            this._parentOrParents = null;
            this._subscriptions = null;
            if (_parentOrParents instanceof Subscription) {
                _parentOrParents.remove(this);
            }
            else if (_parentOrParents !== null) {
                for (var index = 0; index < _parentOrParents.length; ++index) {
                    var parent_1 = _parentOrParents[index];
                    parent_1.remove(this);
                }
            }
            if (isFunction(_unsubscribe)) {
                try {
                    _unsubscribe.call(this);
                }
                catch (e) {
                    errors = e instanceof UnsubscriptionError$1 ? flattenUnsubscriptionErrors(e.errors) : [e];
                }
            }
            if (isArray$1(_subscriptions)) {
                var index = -1;
                var len = _subscriptions.length;
                while (++index < len) {
                    var sub = _subscriptions[index];
                    if (isObject(sub)) {
                        try {
                            sub.unsubscribe();
                        }
                        catch (e) {
                            errors = errors || [];
                            if (e instanceof UnsubscriptionError$1) {
                                errors = errors.concat(flattenUnsubscriptionErrors(e.errors));
                            }
                            else {
                                errors.push(e);
                            }
                        }
                    }
                }
            }
            if (errors) {
                throw new UnsubscriptionError$1(errors);
            }
        };
        Subscription.prototype.add = function (teardown) {
            var subscription = teardown;
            if (!teardown) {
                return Subscription.EMPTY;
            }
            switch (typeof teardown) {
                case 'function':
                    subscription = new Subscription(teardown);
                case 'object':
                    if (subscription === this || subscription.closed || typeof subscription.unsubscribe !== 'function') {
                        return subscription;
                    }
                    else if (this.closed) {
                        subscription.unsubscribe();
                        return subscription;
                    }
                    else if (!(subscription instanceof Subscription)) {
                        var tmp = subscription;
                        subscription = new Subscription();
                        subscription._subscriptions = [tmp];
                    }
                    break;
                default: {
                    throw new Error('unrecognized teardown ' + teardown + ' added to Subscription.');
                }
            }
            var _parentOrParents = subscription._parentOrParents;
            if (_parentOrParents === null) {
                subscription._parentOrParents = this;
            }
            else if (_parentOrParents instanceof Subscription) {
                if (_parentOrParents === this) {
                    return subscription;
                }
                subscription._parentOrParents = [_parentOrParents, this];
            }
            else if (_parentOrParents.indexOf(this) === -1) {
                _parentOrParents.push(this);
            }
            else {
                return subscription;
            }
            var subscriptions = this._subscriptions;
            if (subscriptions === null) {
                this._subscriptions = [subscription];
            }
            else {
                subscriptions.push(subscription);
            }
            return subscription;
        };
        Subscription.prototype.remove = function (subscription) {
            var subscriptions = this._subscriptions;
            if (subscriptions) {
                var subscriptionIndex = subscriptions.indexOf(subscription);
                if (subscriptionIndex !== -1) {
                    subscriptions.splice(subscriptionIndex, 1);
                }
            }
        };
        Subscription.EMPTY = (function (empty) {
            empty.closed = true;
            return empty;
        }(new Subscription()));
        return Subscription;
    }());
    function flattenUnsubscriptionErrors(errors) {
        return errors.reduce(function (errs, err) { return errs.concat((err instanceof UnsubscriptionError$1) ? err.errors : err); }, []);
    }

    /** PURE_IMPORTS_START  PURE_IMPORTS_END */
    var rxSubscriber$1 = /*@__PURE__*/ (function () {
        return typeof Symbol === 'function'
            ? /*@__PURE__*/ Symbol('rxSubscriber')
            : '@@rxSubscriber_' + /*@__PURE__*/ Math.random();
    })();

    /** PURE_IMPORTS_START tslib,_util_isFunction,_Observer,_Subscription,_internal_symbol_rxSubscriber,_config,_util_hostReportError PURE_IMPORTS_END */
    var Subscriber = /*@__PURE__*/ (function (_super) {
        __extends(Subscriber, _super);
        function Subscriber(destinationOrNext, error, complete) {
            var _this = _super.call(this) || this;
            _this.syncErrorValue = null;
            _this.syncErrorThrown = false;
            _this.syncErrorThrowable = false;
            _this.isStopped = false;
            switch (arguments.length) {
                case 0:
                    _this.destination = empty;
                    break;
                case 1:
                    if (!destinationOrNext) {
                        _this.destination = empty;
                        break;
                    }
                    if (typeof destinationOrNext === 'object') {
                        if (destinationOrNext instanceof Subscriber) {
                            _this.syncErrorThrowable = destinationOrNext.syncErrorThrowable;
                            _this.destination = destinationOrNext;
                            destinationOrNext.add(_this);
                        }
                        else {
                            _this.syncErrorThrowable = true;
                            _this.destination = new SafeSubscriber(_this, destinationOrNext);
                        }
                        break;
                    }
                default:
                    _this.syncErrorThrowable = true;
                    _this.destination = new SafeSubscriber(_this, destinationOrNext, error, complete);
                    break;
            }
            return _this;
        }
        Subscriber.prototype[rxSubscriber$1] = function () { return this; };
        Subscriber.create = function (next, error, complete) {
            var subscriber = new Subscriber(next, error, complete);
            subscriber.syncErrorThrowable = false;
            return subscriber;
        };
        Subscriber.prototype.next = function (value) {
            if (!this.isStopped) {
                this._next(value);
            }
        };
        Subscriber.prototype.error = function (err) {
            if (!this.isStopped) {
                this.isStopped = true;
                this._error(err);
            }
        };
        Subscriber.prototype.complete = function () {
            if (!this.isStopped) {
                this.isStopped = true;
                this._complete();
            }
        };
        Subscriber.prototype.unsubscribe = function () {
            if (this.closed) {
                return;
            }
            this.isStopped = true;
            _super.prototype.unsubscribe.call(this);
        };
        Subscriber.prototype._next = function (value) {
            this.destination.next(value);
        };
        Subscriber.prototype._error = function (err) {
            this.destination.error(err);
            this.unsubscribe();
        };
        Subscriber.prototype._complete = function () {
            this.destination.complete();
            this.unsubscribe();
        };
        Subscriber.prototype._unsubscribeAndRecycle = function () {
            var _parentOrParents = this._parentOrParents;
            this._parentOrParents = null;
            this.unsubscribe();
            this.closed = false;
            this.isStopped = false;
            this._parentOrParents = _parentOrParents;
            return this;
        };
        return Subscriber;
    }(Subscription));
    var SafeSubscriber = /*@__PURE__*/ (function (_super) {
        __extends(SafeSubscriber, _super);
        function SafeSubscriber(_parentSubscriber, observerOrNext, error, complete) {
            var _this = _super.call(this) || this;
            _this._parentSubscriber = _parentSubscriber;
            var next;
            var context = _this;
            if (isFunction(observerOrNext)) {
                next = observerOrNext;
            }
            else if (observerOrNext) {
                next = observerOrNext.next;
                error = observerOrNext.error;
                complete = observerOrNext.complete;
                if (observerOrNext !== empty) {
                    context = Object.create(observerOrNext);
                    if (isFunction(context.unsubscribe)) {
                        _this.add(context.unsubscribe.bind(context));
                    }
                    context.unsubscribe = _this.unsubscribe.bind(_this);
                }
            }
            _this._context = context;
            _this._next = next;
            _this._error = error;
            _this._complete = complete;
            return _this;
        }
        SafeSubscriber.prototype.next = function (value) {
            if (!this.isStopped && this._next) {
                var _parentSubscriber = this._parentSubscriber;
                if (!config$1.useDeprecatedSynchronousErrorHandling || !_parentSubscriber.syncErrorThrowable) {
                    this.__tryOrUnsub(this._next, value);
                }
                else if (this.__tryOrSetError(_parentSubscriber, this._next, value)) {
                    this.unsubscribe();
                }
            }
        };
        SafeSubscriber.prototype.error = function (err) {
            if (!this.isStopped) {
                var _parentSubscriber = this._parentSubscriber;
                var useDeprecatedSynchronousErrorHandling = config$1.useDeprecatedSynchronousErrorHandling;
                if (this._error) {
                    if (!useDeprecatedSynchronousErrorHandling || !_parentSubscriber.syncErrorThrowable) {
                        this.__tryOrUnsub(this._error, err);
                        this.unsubscribe();
                    }
                    else {
                        this.__tryOrSetError(_parentSubscriber, this._error, err);
                        this.unsubscribe();
                    }
                }
                else if (!_parentSubscriber.syncErrorThrowable) {
                    this.unsubscribe();
                    if (useDeprecatedSynchronousErrorHandling) {
                        throw err;
                    }
                    hostReportError(err);
                }
                else {
                    if (useDeprecatedSynchronousErrorHandling) {
                        _parentSubscriber.syncErrorValue = err;
                        _parentSubscriber.syncErrorThrown = true;
                    }
                    else {
                        hostReportError(err);
                    }
                    this.unsubscribe();
                }
            }
        };
        SafeSubscriber.prototype.complete = function () {
            var _this = this;
            if (!this.isStopped) {
                var _parentSubscriber = this._parentSubscriber;
                if (this._complete) {
                    var wrappedComplete = function () { return _this._complete.call(_this._context); };
                    if (!config$1.useDeprecatedSynchronousErrorHandling || !_parentSubscriber.syncErrorThrowable) {
                        this.__tryOrUnsub(wrappedComplete);
                        this.unsubscribe();
                    }
                    else {
                        this.__tryOrSetError(_parentSubscriber, wrappedComplete);
                        this.unsubscribe();
                    }
                }
                else {
                    this.unsubscribe();
                }
            }
        };
        SafeSubscriber.prototype.__tryOrUnsub = function (fn, value) {
            try {
                fn.call(this._context, value);
            }
            catch (err) {
                this.unsubscribe();
                if (config$1.useDeprecatedSynchronousErrorHandling) {
                    throw err;
                }
                else {
                    hostReportError(err);
                }
            }
        };
        SafeSubscriber.prototype.__tryOrSetError = function (parent, fn, value) {
            if (!config$1.useDeprecatedSynchronousErrorHandling) {
                throw new Error('bad call');
            }
            try {
                fn.call(this._context, value);
            }
            catch (err) {
                if (config$1.useDeprecatedSynchronousErrorHandling) {
                    parent.syncErrorValue = err;
                    parent.syncErrorThrown = true;
                    return true;
                }
                else {
                    hostReportError(err);
                    return true;
                }
            }
            return false;
        };
        SafeSubscriber.prototype._unsubscribe = function () {
            var _parentSubscriber = this._parentSubscriber;
            this._context = null;
            this._parentSubscriber = null;
            _parentSubscriber.unsubscribe();
        };
        return SafeSubscriber;
    }(Subscriber));

    /** PURE_IMPORTS_START _Subscriber PURE_IMPORTS_END */
    function canReportError(observer) {
        while (observer) {
            var _a = observer, closed_1 = _a.closed, destination = _a.destination, isStopped = _a.isStopped;
            if (closed_1 || isStopped) {
                return false;
            }
            else if (destination && destination instanceof Subscriber) {
                observer = destination;
            }
            else {
                observer = null;
            }
        }
        return true;
    }

    /** PURE_IMPORTS_START _Subscriber,_symbol_rxSubscriber,_Observer PURE_IMPORTS_END */
    function toSubscriber(nextOrObserver, error, complete) {
        if (nextOrObserver) {
            if (nextOrObserver instanceof Subscriber) {
                return nextOrObserver;
            }
            if (nextOrObserver[rxSubscriber$1]) {
                return nextOrObserver[rxSubscriber$1]();
            }
        }
        if (!nextOrObserver && !error && !complete) {
            return new Subscriber(empty);
        }
        return new Subscriber(nextOrObserver, error, complete);
    }

    /** PURE_IMPORTS_START  PURE_IMPORTS_END */
    var observable$1 = /*@__PURE__*/ (function () { return typeof Symbol === 'function' && Symbol.observable || '@@observable'; })();

    /** PURE_IMPORTS_START  PURE_IMPORTS_END */
    function noop() { }

    /** PURE_IMPORTS_START _noop PURE_IMPORTS_END */
    function pipeFromArray(fns) {
        if (!fns) {
            return noop;
        }
        if (fns.length === 1) {
            return fns[0];
        }
        return function piped(input) {
            return fns.reduce(function (prev, fn) { return fn(prev); }, input);
        };
    }

    /** PURE_IMPORTS_START _util_canReportError,_util_toSubscriber,_symbol_observable,_util_pipe,_config PURE_IMPORTS_END */
    var Observable = /*@__PURE__*/ (function () {
        function Observable(subscribe) {
            this._isScalar = false;
            if (subscribe) {
                this._subscribe = subscribe;
            }
        }
        Observable.prototype.lift = function (operator) {
            var observable = new Observable();
            observable.source = this;
            observable.operator = operator;
            return observable;
        };
        Observable.prototype.subscribe = function (observerOrNext, error, complete) {
            var operator = this.operator;
            var sink = toSubscriber(observerOrNext, error, complete);
            if (operator) {
                sink.add(operator.call(sink, this.source));
            }
            else {
                sink.add(this.source || (config$1.useDeprecatedSynchronousErrorHandling && !sink.syncErrorThrowable) ?
                    this._subscribe(sink) :
                    this._trySubscribe(sink));
            }
            if (config$1.useDeprecatedSynchronousErrorHandling) {
                if (sink.syncErrorThrowable) {
                    sink.syncErrorThrowable = false;
                    if (sink.syncErrorThrown) {
                        throw sink.syncErrorValue;
                    }
                }
            }
            return sink;
        };
        Observable.prototype._trySubscribe = function (sink) {
            try {
                return this._subscribe(sink);
            }
            catch (err) {
                if (config$1.useDeprecatedSynchronousErrorHandling) {
                    sink.syncErrorThrown = true;
                    sink.syncErrorValue = err;
                }
                if (canReportError(sink)) {
                    sink.error(err);
                }
                else {
                    console.warn(err);
                }
            }
        };
        Observable.prototype.forEach = function (next, promiseCtor) {
            var _this = this;
            promiseCtor = getPromiseCtor(promiseCtor);
            return new promiseCtor(function (resolve, reject) {
                var subscription;
                subscription = _this.subscribe(function (value) {
                    try {
                        next(value);
                    }
                    catch (err) {
                        reject(err);
                        if (subscription) {
                            subscription.unsubscribe();
                        }
                    }
                }, reject, resolve);
            });
        };
        Observable.prototype._subscribe = function (subscriber) {
            var source = this.source;
            return source && source.subscribe(subscriber);
        };
        Observable.prototype[observable$1] = function () {
            return this;
        };
        Observable.prototype.pipe = function () {
            var operations = [];
            for (var _i = 0; _i < arguments.length; _i++) {
                operations[_i] = arguments[_i];
            }
            if (operations.length === 0) {
                return this;
            }
            return pipeFromArray(operations)(this);
        };
        Observable.prototype.toPromise = function (promiseCtor) {
            var _this = this;
            promiseCtor = getPromiseCtor(promiseCtor);
            return new promiseCtor(function (resolve, reject) {
                var value;
                _this.subscribe(function (x) { return value = x; }, function (err) { return reject(err); }, function () { return resolve(value); });
            });
        };
        Observable.create = function (subscribe) {
            return new Observable(subscribe);
        };
        return Observable;
    }());
    function getPromiseCtor(promiseCtor) {
        if (!promiseCtor) {
            promiseCtor =  Promise;
        }
        if (!promiseCtor) {
            throw new Error('no Promise impl found');
        }
        return promiseCtor;
    }

    /** PURE_IMPORTS_START  PURE_IMPORTS_END */
    var ObjectUnsubscribedErrorImpl = /*@__PURE__*/ (function () {
        function ObjectUnsubscribedErrorImpl() {
            Error.call(this);
            this.message = 'object unsubscribed';
            this.name = 'ObjectUnsubscribedError';
            return this;
        }
        ObjectUnsubscribedErrorImpl.prototype = /*@__PURE__*/ Object.create(Error.prototype);
        return ObjectUnsubscribedErrorImpl;
    })();
    var ObjectUnsubscribedError$1 = ObjectUnsubscribedErrorImpl;

    /** PURE_IMPORTS_START tslib,_Subscription PURE_IMPORTS_END */
    var SubjectSubscription = /*@__PURE__*/ (function (_super) {
        __extends(SubjectSubscription, _super);
        function SubjectSubscription(subject, subscriber) {
            var _this = _super.call(this) || this;
            _this.subject = subject;
            _this.subscriber = subscriber;
            _this.closed = false;
            return _this;
        }
        SubjectSubscription.prototype.unsubscribe = function () {
            if (this.closed) {
                return;
            }
            this.closed = true;
            var subject = this.subject;
            var observers = subject.observers;
            this.subject = null;
            if (!observers || observers.length === 0 || subject.isStopped || subject.closed) {
                return;
            }
            var subscriberIndex = observers.indexOf(this.subscriber);
            if (subscriberIndex !== -1) {
                observers.splice(subscriberIndex, 1);
            }
        };
        return SubjectSubscription;
    }(Subscription));

    /** PURE_IMPORTS_START tslib,_Observable,_Subscriber,_Subscription,_util_ObjectUnsubscribedError,_SubjectSubscription,_internal_symbol_rxSubscriber PURE_IMPORTS_END */
    var SubjectSubscriber = /*@__PURE__*/ (function (_super) {
        __extends(SubjectSubscriber, _super);
        function SubjectSubscriber(destination) {
            var _this = _super.call(this, destination) || this;
            _this.destination = destination;
            return _this;
        }
        return SubjectSubscriber;
    }(Subscriber));
    var Subject = /*@__PURE__*/ (function (_super) {
        __extends(Subject, _super);
        function Subject() {
            var _this = _super.call(this) || this;
            _this.observers = [];
            _this.closed = false;
            _this.isStopped = false;
            _this.hasError = false;
            _this.thrownError = null;
            return _this;
        }
        Subject.prototype[rxSubscriber$1] = function () {
            return new SubjectSubscriber(this);
        };
        Subject.prototype.lift = function (operator) {
            var subject = new AnonymousSubject(this, this);
            subject.operator = operator;
            return subject;
        };
        Subject.prototype.next = function (value) {
            if (this.closed) {
                throw new ObjectUnsubscribedError$1();
            }
            if (!this.isStopped) {
                var observers = this.observers;
                var len = observers.length;
                var copy = observers.slice();
                for (var i = 0; i < len; i++) {
                    copy[i].next(value);
                }
            }
        };
        Subject.prototype.error = function (err) {
            if (this.closed) {
                throw new ObjectUnsubscribedError$1();
            }
            this.hasError = true;
            this.thrownError = err;
            this.isStopped = true;
            var observers = this.observers;
            var len = observers.length;
            var copy = observers.slice();
            for (var i = 0; i < len; i++) {
                copy[i].error(err);
            }
            this.observers.length = 0;
        };
        Subject.prototype.complete = function () {
            if (this.closed) {
                throw new ObjectUnsubscribedError$1();
            }
            this.isStopped = true;
            var observers = this.observers;
            var len = observers.length;
            var copy = observers.slice();
            for (var i = 0; i < len; i++) {
                copy[i].complete();
            }
            this.observers.length = 0;
        };
        Subject.prototype.unsubscribe = function () {
            this.isStopped = true;
            this.closed = true;
            this.observers = null;
        };
        Subject.prototype._trySubscribe = function (subscriber) {
            if (this.closed) {
                throw new ObjectUnsubscribedError$1();
            }
            else {
                return _super.prototype._trySubscribe.call(this, subscriber);
            }
        };
        Subject.prototype._subscribe = function (subscriber) {
            if (this.closed) {
                throw new ObjectUnsubscribedError$1();
            }
            else if (this.hasError) {
                subscriber.error(this.thrownError);
                return Subscription.EMPTY;
            }
            else if (this.isStopped) {
                subscriber.complete();
                return Subscription.EMPTY;
            }
            else {
                this.observers.push(subscriber);
                return new SubjectSubscription(this, subscriber);
            }
        };
        Subject.prototype.asObservable = function () {
            var observable = new Observable();
            observable.source = this;
            return observable;
        };
        Subject.create = function (destination, source) {
            return new AnonymousSubject(destination, source);
        };
        return Subject;
    }(Observable));
    var AnonymousSubject = /*@__PURE__*/ (function (_super) {
        __extends(AnonymousSubject, _super);
        function AnonymousSubject(destination, source) {
            var _this = _super.call(this) || this;
            _this.destination = destination;
            _this.source = source;
            return _this;
        }
        AnonymousSubject.prototype.next = function (value) {
            var destination = this.destination;
            if (destination && destination.next) {
                destination.next(value);
            }
        };
        AnonymousSubject.prototype.error = function (err) {
            var destination = this.destination;
            if (destination && destination.error) {
                this.destination.error(err);
            }
        };
        AnonymousSubject.prototype.complete = function () {
            var destination = this.destination;
            if (destination && destination.complete) {
                this.destination.complete();
            }
        };
        AnonymousSubject.prototype._subscribe = function (subscriber) {
            var source = this.source;
            if (source) {
                return this.source.subscribe(subscriber);
            }
            else {
                return Subscription.EMPTY;
            }
        };
        return AnonymousSubject;
    }(Subject));

    /** PURE_IMPORTS_START tslib,_Subscription PURE_IMPORTS_END */
    var Action = /*@__PURE__*/ (function (_super) {
        __extends(Action, _super);
        function Action(scheduler, work) {
            return _super.call(this) || this;
        }
        Action.prototype.schedule = function (state, delay) {
            return this;
        };
        return Action;
    }(Subscription));

    /** PURE_IMPORTS_START tslib,_Action PURE_IMPORTS_END */
    var AsyncAction = /*@__PURE__*/ (function (_super) {
        __extends(AsyncAction, _super);
        function AsyncAction(scheduler, work) {
            var _this = _super.call(this, scheduler, work) || this;
            _this.scheduler = scheduler;
            _this.work = work;
            _this.pending = false;
            return _this;
        }
        AsyncAction.prototype.schedule = function (state, delay) {
            if (delay === void 0) {
                delay = 0;
            }
            if (this.closed) {
                return this;
            }
            this.state = state;
            var id = this.id;
            var scheduler = this.scheduler;
            if (id != null) {
                this.id = this.recycleAsyncId(scheduler, id, delay);
            }
            this.pending = true;
            this.delay = delay;
            this.id = this.id || this.requestAsyncId(scheduler, this.id, delay);
            return this;
        };
        AsyncAction.prototype.requestAsyncId = function (scheduler, id, delay) {
            if (delay === void 0) {
                delay = 0;
            }
            return setInterval(scheduler.flush.bind(scheduler, this), delay);
        };
        AsyncAction.prototype.recycleAsyncId = function (scheduler, id, delay) {
            if (delay === void 0) {
                delay = 0;
            }
            if (delay !== null && this.delay === delay && this.pending === false) {
                return id;
            }
            clearInterval(id);
            return undefined;
        };
        AsyncAction.prototype.execute = function (state, delay) {
            if (this.closed) {
                return new Error('executing a cancelled action');
            }
            this.pending = false;
            var error = this._execute(state, delay);
            if (error) {
                return error;
            }
            else if (this.pending === false && this.id != null) {
                this.id = this.recycleAsyncId(this.scheduler, this.id, null);
            }
        };
        AsyncAction.prototype._execute = function (state, delay) {
            var errored = false;
            var errorValue = undefined;
            try {
                this.work(state);
            }
            catch (e) {
                errored = true;
                errorValue = !!e && e || new Error(e);
            }
            if (errored) {
                this.unsubscribe();
                return errorValue;
            }
        };
        AsyncAction.prototype._unsubscribe = function () {
            var id = this.id;
            var scheduler = this.scheduler;
            var actions = scheduler.actions;
            var index = actions.indexOf(this);
            this.work = null;
            this.state = null;
            this.pending = false;
            this.scheduler = null;
            if (index !== -1) {
                actions.splice(index, 1);
            }
            if (id != null) {
                this.id = this.recycleAsyncId(scheduler, id, null);
            }
            this.delay = null;
        };
        return AsyncAction;
    }(Action));

    /** PURE_IMPORTS_START tslib,_AsyncAction PURE_IMPORTS_END */
    var QueueAction = /*@__PURE__*/ (function (_super) {
        __extends(QueueAction, _super);
        function QueueAction(scheduler, work) {
            var _this = _super.call(this, scheduler, work) || this;
            _this.scheduler = scheduler;
            _this.work = work;
            return _this;
        }
        QueueAction.prototype.schedule = function (state, delay) {
            if (delay === void 0) {
                delay = 0;
            }
            if (delay > 0) {
                return _super.prototype.schedule.call(this, state, delay);
            }
            this.delay = delay;
            this.state = state;
            this.scheduler.flush(this);
            return this;
        };
        QueueAction.prototype.execute = function (state, delay) {
            return (delay > 0 || this.closed) ?
                _super.prototype.execute.call(this, state, delay) :
                this._execute(state, delay);
        };
        QueueAction.prototype.requestAsyncId = function (scheduler, id, delay) {
            if (delay === void 0) {
                delay = 0;
            }
            if ((delay !== null && delay > 0) || (delay === null && this.delay > 0)) {
                return _super.prototype.requestAsyncId.call(this, scheduler, id, delay);
            }
            return scheduler.flush(this);
        };
        return QueueAction;
    }(AsyncAction));

    var Scheduler = /*@__PURE__*/ (function () {
        function Scheduler(SchedulerAction, now) {
            if (now === void 0) {
                now = Scheduler.now;
            }
            this.SchedulerAction = SchedulerAction;
            this.now = now;
        }
        Scheduler.prototype.schedule = function (work, delay, state) {
            if (delay === void 0) {
                delay = 0;
            }
            return new this.SchedulerAction(this, work).schedule(state, delay);
        };
        Scheduler.now = function () { return Date.now(); };
        return Scheduler;
    }());

    /** PURE_IMPORTS_START tslib,_Scheduler PURE_IMPORTS_END */
    var AsyncScheduler = /*@__PURE__*/ (function (_super) {
        __extends(AsyncScheduler, _super);
        function AsyncScheduler(SchedulerAction, now) {
            if (now === void 0) {
                now = Scheduler.now;
            }
            var _this = _super.call(this, SchedulerAction, function () {
                if (AsyncScheduler.delegate && AsyncScheduler.delegate !== _this) {
                    return AsyncScheduler.delegate.now();
                }
                else {
                    return now();
                }
            }) || this;
            _this.actions = [];
            _this.active = false;
            _this.scheduled = undefined;
            return _this;
        }
        AsyncScheduler.prototype.schedule = function (work, delay, state) {
            if (delay === void 0) {
                delay = 0;
            }
            if (AsyncScheduler.delegate && AsyncScheduler.delegate !== this) {
                return AsyncScheduler.delegate.schedule(work, delay, state);
            }
            else {
                return _super.prototype.schedule.call(this, work, delay, state);
            }
        };
        AsyncScheduler.prototype.flush = function (action) {
            var actions = this.actions;
            if (this.active) {
                actions.push(action);
                return;
            }
            var error;
            this.active = true;
            do {
                if (error = action.execute(action.state, action.delay)) {
                    break;
                }
            } while (action = actions.shift());
            this.active = false;
            if (error) {
                while (action = actions.shift()) {
                    action.unsubscribe();
                }
                throw error;
            }
        };
        return AsyncScheduler;
    }(Scheduler));

    /** PURE_IMPORTS_START tslib,_AsyncScheduler PURE_IMPORTS_END */
    var QueueScheduler = /*@__PURE__*/ (function (_super) {
        __extends(QueueScheduler, _super);
        function QueueScheduler() {
            return _super !== null && _super.apply(this, arguments) || this;
        }
        return QueueScheduler;
    }(AsyncScheduler));

    /** PURE_IMPORTS_START _QueueAction,_QueueScheduler PURE_IMPORTS_END */
    var queue = /*@__PURE__*/ new QueueScheduler(QueueAction);

    /** PURE_IMPORTS_START _Observable PURE_IMPORTS_END */
    var EMPTY = /*@__PURE__*/ new Observable(function (subscriber) { return subscriber.complete(); });
    function empty$1(scheduler) {
        return scheduler ? emptyScheduled(scheduler) : EMPTY;
    }
    function emptyScheduled(scheduler) {
        return new Observable(function (subscriber) { return scheduler.schedule(function () { return subscriber.complete(); }); });
    }

    /** PURE_IMPORTS_START  PURE_IMPORTS_END */
    function isScheduler(value) {
        return value && typeof value.schedule === 'function';
    }

    /** PURE_IMPORTS_START  PURE_IMPORTS_END */
    var subscribeToArray = function (array) {
        return function (subscriber) {
            for (var i = 0, len = array.length; i < len && !subscriber.closed; i++) {
                subscriber.next(array[i]);
            }
            subscriber.complete();
        };
    };

    /** PURE_IMPORTS_START _Observable,_Subscription PURE_IMPORTS_END */
    function scheduleArray(input, scheduler) {
        return new Observable(function (subscriber) {
            var sub = new Subscription();
            var i = 0;
            sub.add(scheduler.schedule(function () {
                if (i === input.length) {
                    subscriber.complete();
                    return;
                }
                subscriber.next(input[i++]);
                if (!subscriber.closed) {
                    sub.add(this.schedule());
                }
            }));
            return sub;
        });
    }

    /** PURE_IMPORTS_START _Observable,_util_subscribeToArray,_scheduled_scheduleArray PURE_IMPORTS_END */
    function fromArray(input, scheduler) {
        if (!scheduler) {
            return new Observable(subscribeToArray(input));
        }
        else {
            return scheduleArray(input, scheduler);
        }
    }

    /** PURE_IMPORTS_START _util_isScheduler,_fromArray,_scheduled_scheduleArray PURE_IMPORTS_END */
    function of() {
        var args = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            args[_i] = arguments[_i];
        }
        var scheduler = args[args.length - 1];
        if (isScheduler(scheduler)) {
            args.pop();
            return scheduleArray(args, scheduler);
        }
        else {
            return fromArray(args);
        }
    }

    /** PURE_IMPORTS_START _Observable PURE_IMPORTS_END */
    function throwError(error, scheduler) {
        if (!scheduler) {
            return new Observable(function (subscriber) { return subscriber.error(error); });
        }
        else {
            return new Observable(function (subscriber) { return scheduler.schedule(dispatch, 0, { error: error, subscriber: subscriber }); });
        }
    }
    function dispatch(_a) {
        var error = _a.error, subscriber = _a.subscriber;
        subscriber.error(error);
    }

    /** PURE_IMPORTS_START _observable_empty,_observable_of,_observable_throwError PURE_IMPORTS_END */
    var Notification = /*@__PURE__*/ (function () {
        function Notification(kind, value, error) {
            this.kind = kind;
            this.value = value;
            this.error = error;
            this.hasValue = kind === 'N';
        }
        Notification.prototype.observe = function (observer) {
            switch (this.kind) {
                case 'N':
                    return observer.next && observer.next(this.value);
                case 'E':
                    return observer.error && observer.error(this.error);
                case 'C':
                    return observer.complete && observer.complete();
            }
        };
        Notification.prototype.do = function (next, error, complete) {
            var kind = this.kind;
            switch (kind) {
                case 'N':
                    return next && next(this.value);
                case 'E':
                    return error && error(this.error);
                case 'C':
                    return complete && complete();
            }
        };
        Notification.prototype.accept = function (nextOrObserver, error, complete) {
            if (nextOrObserver && typeof nextOrObserver.next === 'function') {
                return this.observe(nextOrObserver);
            }
            else {
                return this.do(nextOrObserver, error, complete);
            }
        };
        Notification.prototype.toObservable = function () {
            var kind = this.kind;
            switch (kind) {
                case 'N':
                    return of(this.value);
                case 'E':
                    return throwError(this.error);
                case 'C':
                    return empty$1();
            }
            throw new Error('unexpected notification kind value');
        };
        Notification.createNext = function (value) {
            if (typeof value !== 'undefined') {
                return new Notification('N', value);
            }
            return Notification.undefinedValueNotification;
        };
        Notification.createError = function (err) {
            return new Notification('E', undefined, err);
        };
        Notification.createComplete = function () {
            return Notification.completeNotification;
        };
        Notification.completeNotification = new Notification('C');
        Notification.undefinedValueNotification = new Notification('N', undefined);
        return Notification;
    }());

    /** PURE_IMPORTS_START tslib,_Subscriber,_Notification PURE_IMPORTS_END */
    var ObserveOnSubscriber = /*@__PURE__*/ (function (_super) {
        __extends(ObserveOnSubscriber, _super);
        function ObserveOnSubscriber(destination, scheduler, delay) {
            if (delay === void 0) {
                delay = 0;
            }
            var _this = _super.call(this, destination) || this;
            _this.scheduler = scheduler;
            _this.delay = delay;
            return _this;
        }
        ObserveOnSubscriber.dispatch = function (arg) {
            var notification = arg.notification, destination = arg.destination;
            notification.observe(destination);
            this.unsubscribe();
        };
        ObserveOnSubscriber.prototype.scheduleMessage = function (notification) {
            var destination = this.destination;
            destination.add(this.scheduler.schedule(ObserveOnSubscriber.dispatch, this.delay, new ObserveOnMessage(notification, this.destination)));
        };
        ObserveOnSubscriber.prototype._next = function (value) {
            this.scheduleMessage(Notification.createNext(value));
        };
        ObserveOnSubscriber.prototype._error = function (err) {
            this.scheduleMessage(Notification.createError(err));
            this.unsubscribe();
        };
        ObserveOnSubscriber.prototype._complete = function () {
            this.scheduleMessage(Notification.createComplete());
            this.unsubscribe();
        };
        return ObserveOnSubscriber;
    }(Subscriber));
    var ObserveOnMessage = /*@__PURE__*/ (function () {
        function ObserveOnMessage(notification, destination) {
            this.notification = notification;
            this.destination = destination;
        }
        return ObserveOnMessage;
    }());

    /** PURE_IMPORTS_START tslib,_Subject,_scheduler_queue,_Subscription,_operators_observeOn,_util_ObjectUnsubscribedError,_SubjectSubscription PURE_IMPORTS_END */
    var ReplaySubject = /*@__PURE__*/ (function (_super) {
        __extends(ReplaySubject, _super);
        function ReplaySubject(bufferSize, windowTime, scheduler) {
            if (bufferSize === void 0) {
                bufferSize = Number.POSITIVE_INFINITY;
            }
            if (windowTime === void 0) {
                windowTime = Number.POSITIVE_INFINITY;
            }
            var _this = _super.call(this) || this;
            _this.scheduler = scheduler;
            _this._events = [];
            _this._infiniteTimeWindow = false;
            _this._bufferSize = bufferSize < 1 ? 1 : bufferSize;
            _this._windowTime = windowTime < 1 ? 1 : windowTime;
            if (windowTime === Number.POSITIVE_INFINITY) {
                _this._infiniteTimeWindow = true;
                _this.next = _this.nextInfiniteTimeWindow;
            }
            else {
                _this.next = _this.nextTimeWindow;
            }
            return _this;
        }
        ReplaySubject.prototype.nextInfiniteTimeWindow = function (value) {
            var _events = this._events;
            _events.push(value);
            if (_events.length > this._bufferSize) {
                _events.shift();
            }
            _super.prototype.next.call(this, value);
        };
        ReplaySubject.prototype.nextTimeWindow = function (value) {
            this._events.push(new ReplayEvent(this._getNow(), value));
            this._trimBufferThenGetEvents();
            _super.prototype.next.call(this, value);
        };
        ReplaySubject.prototype._subscribe = function (subscriber) {
            var _infiniteTimeWindow = this._infiniteTimeWindow;
            var _events = _infiniteTimeWindow ? this._events : this._trimBufferThenGetEvents();
            var scheduler = this.scheduler;
            var len = _events.length;
            var subscription;
            if (this.closed) {
                throw new ObjectUnsubscribedError$1();
            }
            else if (this.isStopped || this.hasError) {
                subscription = Subscription.EMPTY;
            }
            else {
                this.observers.push(subscriber);
                subscription = new SubjectSubscription(this, subscriber);
            }
            if (scheduler) {
                subscriber.add(subscriber = new ObserveOnSubscriber(subscriber, scheduler));
            }
            if (_infiniteTimeWindow) {
                for (var i = 0; i < len && !subscriber.closed; i++) {
                    subscriber.next(_events[i]);
                }
            }
            else {
                for (var i = 0; i < len && !subscriber.closed; i++) {
                    subscriber.next(_events[i].value);
                }
            }
            if (this.hasError) {
                subscriber.error(this.thrownError);
            }
            else if (this.isStopped) {
                subscriber.complete();
            }
            return subscription;
        };
        ReplaySubject.prototype._getNow = function () {
            return (this.scheduler || queue).now();
        };
        ReplaySubject.prototype._trimBufferThenGetEvents = function () {
            var now = this._getNow();
            var _bufferSize = this._bufferSize;
            var _windowTime = this._windowTime;
            var _events = this._events;
            var eventsCount = _events.length;
            var spliceCount = 0;
            while (spliceCount < eventsCount) {
                if ((now - _events[spliceCount].time) < _windowTime) {
                    break;
                }
                spliceCount++;
            }
            if (eventsCount > _bufferSize) {
                spliceCount = Math.max(spliceCount, eventsCount - _bufferSize);
            }
            if (spliceCount > 0) {
                _events.splice(0, spliceCount);
            }
            return _events;
        };
        return ReplaySubject;
    }(Subject));
    var ReplayEvent = /*@__PURE__*/ (function () {
        function ReplayEvent(time, value) {
            this.time = time;
            this.value = value;
        }
        return ReplayEvent;
    }());

    /** PURE_IMPORTS_START tslib,_Subscriber PURE_IMPORTS_END */
    function filter(predicate, thisArg) {
        return function filterOperatorFunction(source) {
            return source.lift(new FilterOperator(predicate, thisArg));
        };
    }
    var FilterOperator = /*@__PURE__*/ (function () {
        function FilterOperator(predicate, thisArg) {
            this.predicate = predicate;
            this.thisArg = thisArg;
        }
        FilterOperator.prototype.call = function (subscriber, source) {
            return source.subscribe(new FilterSubscriber(subscriber, this.predicate, this.thisArg));
        };
        return FilterOperator;
    }());
    var FilterSubscriber = /*@__PURE__*/ (function (_super) {
        __extends(FilterSubscriber, _super);
        function FilterSubscriber(destination, predicate, thisArg) {
            var _this = _super.call(this, destination) || this;
            _this.predicate = predicate;
            _this.thisArg = thisArg;
            _this.count = 0;
            return _this;
        }
        FilterSubscriber.prototype._next = function (value) {
            var result;
            try {
                result = this.predicate.call(this.thisArg, value, this.count++);
            }
            catch (err) {
                this.destination.error(err);
                return;
            }
            if (result) {
                this.destination.next(value);
            }
        };
        return FilterSubscriber;
    }(Subscriber));

    var domain;

    // This constructor is used to store event handlers. Instantiating this is
    // faster than explicitly calling `Object.create(null)` to get a "clean" empty
    // object (tested with v8 v4.9).
    function EventHandlers() {}
    EventHandlers.prototype = Object.create(null);

    function EventEmitter() {
      EventEmitter.init.call(this);
    }

    // nodejs oddity
    // require('events') === require('events').EventEmitter
    EventEmitter.EventEmitter = EventEmitter;

    EventEmitter.usingDomains = false;

    EventEmitter.prototype.domain = undefined;
    EventEmitter.prototype._events = undefined;
    EventEmitter.prototype._maxListeners = undefined;

    // By default EventEmitters will print a warning if more than 10 listeners are
    // added to it. This is a useful default which helps finding memory leaks.
    EventEmitter.defaultMaxListeners = 10;

    EventEmitter.init = function() {
      this.domain = null;
      if (EventEmitter.usingDomains) {
        // if there is an active domain, then attach to it.
        if (domain.active ) ;
      }

      if (!this._events || this._events === Object.getPrototypeOf(this)._events) {
        this._events = new EventHandlers();
        this._eventsCount = 0;
      }

      this._maxListeners = this._maxListeners || undefined;
    };

    // Obviously not all Emitters should be limited to 10. This function allows
    // that to be increased. Set to zero for unlimited.
    EventEmitter.prototype.setMaxListeners = function setMaxListeners(n) {
      if (typeof n !== 'number' || n < 0 || isNaN(n))
        throw new TypeError('"n" argument must be a positive number');
      this._maxListeners = n;
      return this;
    };

    function $getMaxListeners(that) {
      if (that._maxListeners === undefined)
        return EventEmitter.defaultMaxListeners;
      return that._maxListeners;
    }

    EventEmitter.prototype.getMaxListeners = function getMaxListeners() {
      return $getMaxListeners(this);
    };

    // These standalone emit* functions are used to optimize calling of event
    // handlers for fast cases because emit() itself often has a variable number of
    // arguments and can be deoptimized because of that. These functions always have
    // the same number of arguments and thus do not get deoptimized, so the code
    // inside them can execute faster.
    function emitNone(handler, isFn, self) {
      if (isFn)
        handler.call(self);
      else {
        var len = handler.length;
        var listeners = arrayClone(handler, len);
        for (var i = 0; i < len; ++i)
          listeners[i].call(self);
      }
    }
    function emitOne(handler, isFn, self, arg1) {
      if (isFn)
        handler.call(self, arg1);
      else {
        var len = handler.length;
        var listeners = arrayClone(handler, len);
        for (var i = 0; i < len; ++i)
          listeners[i].call(self, arg1);
      }
    }
    function emitTwo(handler, isFn, self, arg1, arg2) {
      if (isFn)
        handler.call(self, arg1, arg2);
      else {
        var len = handler.length;
        var listeners = arrayClone(handler, len);
        for (var i = 0; i < len; ++i)
          listeners[i].call(self, arg1, arg2);
      }
    }
    function emitThree(handler, isFn, self, arg1, arg2, arg3) {
      if (isFn)
        handler.call(self, arg1, arg2, arg3);
      else {
        var len = handler.length;
        var listeners = arrayClone(handler, len);
        for (var i = 0; i < len; ++i)
          listeners[i].call(self, arg1, arg2, arg3);
      }
    }

    function emitMany(handler, isFn, self, args) {
      if (isFn)
        handler.apply(self, args);
      else {
        var len = handler.length;
        var listeners = arrayClone(handler, len);
        for (var i = 0; i < len; ++i)
          listeners[i].apply(self, args);
      }
    }

    EventEmitter.prototype.emit = function emit(type) {
      var er, handler, len, args, i, events, domain;
      var doError = (type === 'error');

      events = this._events;
      if (events)
        doError = (doError && events.error == null);
      else if (!doError)
        return false;

      domain = this.domain;

      // If there is no 'error' event listener then throw.
      if (doError) {
        er = arguments[1];
        if (domain) {
          if (!er)
            er = new Error('Uncaught, unspecified "error" event');
          er.domainEmitter = this;
          er.domain = domain;
          er.domainThrown = false;
          domain.emit('error', er);
        } else if (er instanceof Error) {
          throw er; // Unhandled 'error' event
        } else {
          // At least give some kind of context to the user
          var err = new Error('Uncaught, unspecified "error" event. (' + er + ')');
          err.context = er;
          throw err;
        }
        return false;
      }

      handler = events[type];

      if (!handler)
        return false;

      var isFn = typeof handler === 'function';
      len = arguments.length;
      switch (len) {
        // fast cases
        case 1:
          emitNone(handler, isFn, this);
          break;
        case 2:
          emitOne(handler, isFn, this, arguments[1]);
          break;
        case 3:
          emitTwo(handler, isFn, this, arguments[1], arguments[2]);
          break;
        case 4:
          emitThree(handler, isFn, this, arguments[1], arguments[2], arguments[3]);
          break;
        // slower
        default:
          args = new Array(len - 1);
          for (i = 1; i < len; i++)
            args[i - 1] = arguments[i];
          emitMany(handler, isFn, this, args);
      }

      return true;
    };

    function _addListener(target, type, listener, prepend) {
      var m;
      var events;
      var existing;

      if (typeof listener !== 'function')
        throw new TypeError('"listener" argument must be a function');

      events = target._events;
      if (!events) {
        events = target._events = new EventHandlers();
        target._eventsCount = 0;
      } else {
        // To avoid recursion in the case that type === "newListener"! Before
        // adding it to the listeners, first emit "newListener".
        if (events.newListener) {
          target.emit('newListener', type,
                      listener.listener ? listener.listener : listener);

          // Re-assign `events` because a newListener handler could have caused the
          // this._events to be assigned to a new object
          events = target._events;
        }
        existing = events[type];
      }

      if (!existing) {
        // Optimize the case of one listener. Don't need the extra array object.
        existing = events[type] = listener;
        ++target._eventsCount;
      } else {
        if (typeof existing === 'function') {
          // Adding the second element, need to change to array.
          existing = events[type] = prepend ? [listener, existing] :
                                              [existing, listener];
        } else {
          // If we've already got an array, just append.
          if (prepend) {
            existing.unshift(listener);
          } else {
            existing.push(listener);
          }
        }

        // Check for listener leak
        if (!existing.warned) {
          m = $getMaxListeners(target);
          if (m && m > 0 && existing.length > m) {
            existing.warned = true;
            var w = new Error('Possible EventEmitter memory leak detected. ' +
                                existing.length + ' ' + type + ' listeners added. ' +
                                'Use emitter.setMaxListeners() to increase limit');
            w.name = 'MaxListenersExceededWarning';
            w.emitter = target;
            w.type = type;
            w.count = existing.length;
            emitWarning(w);
          }
        }
      }

      return target;
    }
    function emitWarning(e) {
      typeof console.warn === 'function' ? console.warn(e) : console.log(e);
    }
    EventEmitter.prototype.addListener = function addListener(type, listener) {
      return _addListener(this, type, listener, false);
    };

    EventEmitter.prototype.on = EventEmitter.prototype.addListener;

    EventEmitter.prototype.prependListener =
        function prependListener(type, listener) {
          return _addListener(this, type, listener, true);
        };

    function _onceWrap(target, type, listener) {
      var fired = false;
      function g() {
        target.removeListener(type, g);
        if (!fired) {
          fired = true;
          listener.apply(target, arguments);
        }
      }
      g.listener = listener;
      return g;
    }

    EventEmitter.prototype.once = function once(type, listener) {
      if (typeof listener !== 'function')
        throw new TypeError('"listener" argument must be a function');
      this.on(type, _onceWrap(this, type, listener));
      return this;
    };

    EventEmitter.prototype.prependOnceListener =
        function prependOnceListener(type, listener) {
          if (typeof listener !== 'function')
            throw new TypeError('"listener" argument must be a function');
          this.prependListener(type, _onceWrap(this, type, listener));
          return this;
        };

    // emits a 'removeListener' event iff the listener was removed
    EventEmitter.prototype.removeListener =
        function removeListener(type, listener) {
          var list, events, position, i, originalListener;

          if (typeof listener !== 'function')
            throw new TypeError('"listener" argument must be a function');

          events = this._events;
          if (!events)
            return this;

          list = events[type];
          if (!list)
            return this;

          if (list === listener || (list.listener && list.listener === listener)) {
            if (--this._eventsCount === 0)
              this._events = new EventHandlers();
            else {
              delete events[type];
              if (events.removeListener)
                this.emit('removeListener', type, list.listener || listener);
            }
          } else if (typeof list !== 'function') {
            position = -1;

            for (i = list.length; i-- > 0;) {
              if (list[i] === listener ||
                  (list[i].listener && list[i].listener === listener)) {
                originalListener = list[i].listener;
                position = i;
                break;
              }
            }

            if (position < 0)
              return this;

            if (list.length === 1) {
              list[0] = undefined;
              if (--this._eventsCount === 0) {
                this._events = new EventHandlers();
                return this;
              } else {
                delete events[type];
              }
            } else {
              spliceOne(list, position);
            }

            if (events.removeListener)
              this.emit('removeListener', type, originalListener || listener);
          }

          return this;
        };

    EventEmitter.prototype.removeAllListeners =
        function removeAllListeners(type) {
          var listeners, events;

          events = this._events;
          if (!events)
            return this;

          // not listening for removeListener, no need to emit
          if (!events.removeListener) {
            if (arguments.length === 0) {
              this._events = new EventHandlers();
              this._eventsCount = 0;
            } else if (events[type]) {
              if (--this._eventsCount === 0)
                this._events = new EventHandlers();
              else
                delete events[type];
            }
            return this;
          }

          // emit removeListener for all listeners on all events
          if (arguments.length === 0) {
            var keys = Object.keys(events);
            for (var i = 0, key; i < keys.length; ++i) {
              key = keys[i];
              if (key === 'removeListener') continue;
              this.removeAllListeners(key);
            }
            this.removeAllListeners('removeListener');
            this._events = new EventHandlers();
            this._eventsCount = 0;
            return this;
          }

          listeners = events[type];

          if (typeof listeners === 'function') {
            this.removeListener(type, listeners);
          } else if (listeners) {
            // LIFO order
            do {
              this.removeListener(type, listeners[listeners.length - 1]);
            } while (listeners[0]);
          }

          return this;
        };

    EventEmitter.prototype.listeners = function listeners(type) {
      var evlistener;
      var ret;
      var events = this._events;

      if (!events)
        ret = [];
      else {
        evlistener = events[type];
        if (!evlistener)
          ret = [];
        else if (typeof evlistener === 'function')
          ret = [evlistener.listener || evlistener];
        else
          ret = unwrapListeners(evlistener);
      }

      return ret;
    };

    EventEmitter.listenerCount = function(emitter, type) {
      if (typeof emitter.listenerCount === 'function') {
        return emitter.listenerCount(type);
      } else {
        return listenerCount.call(emitter, type);
      }
    };

    EventEmitter.prototype.listenerCount = listenerCount;
    function listenerCount(type) {
      var events = this._events;

      if (events) {
        var evlistener = events[type];

        if (typeof evlistener === 'function') {
          return 1;
        } else if (evlistener) {
          return evlistener.length;
        }
      }

      return 0;
    }

    EventEmitter.prototype.eventNames = function eventNames() {
      return this._eventsCount > 0 ? Reflect.ownKeys(this._events) : [];
    };

    // About 1.5x faster than the two-arg version of Array#splice().
    function spliceOne(list, index) {
      for (var i = index, k = i + 1, n = list.length; k < n; i += 1, k += 1)
        list[i] = list[k];
      list.pop();
    }

    function arrayClone(arr, i) {
      var copy = new Array(i);
      while (i--)
        copy[i] = arr[i];
      return copy;
    }

    function unwrapListeners(arr) {
      var ret = new Array(arr.length);
      for (var i = 0; i < ret.length; ++i) {
        ret[i] = arr[i].listener || arr[i];
      }
      return ret;
    }

    var immutable = extend;

    var hasOwnProperty$1 = Object.prototype.hasOwnProperty;

    function extend() {
        var target = {};

        for (var i = 0; i < arguments.length; i++) {
            var source = arguments[i];

            for (var key in source) {
                if (hasOwnProperty$1.call(source, key)) {
                    target[key] = source[key];
                }
            }
        }

        return target
    }

    // shim for using process in browser
    // based off https://github.com/defunctzombie/node-process/blob/master/browser.js

    function defaultSetTimout() {
        throw new Error('setTimeout has not been defined');
    }
    function defaultClearTimeout () {
        throw new Error('clearTimeout has not been defined');
    }
    var cachedSetTimeout = defaultSetTimout;
    var cachedClearTimeout = defaultClearTimeout;
    if (typeof global.setTimeout === 'function') {
        cachedSetTimeout = setTimeout;
    }
    if (typeof global.clearTimeout === 'function') {
        cachedClearTimeout = clearTimeout;
    }

    function runTimeout(fun) {
        if (cachedSetTimeout === setTimeout) {
            //normal enviroments in sane situations
            return setTimeout(fun, 0);
        }
        // if setTimeout wasn't available but was latter defined
        if ((cachedSetTimeout === defaultSetTimout || !cachedSetTimeout) && setTimeout) {
            cachedSetTimeout = setTimeout;
            return setTimeout(fun, 0);
        }
        try {
            // when when somebody has screwed with setTimeout but no I.E. maddness
            return cachedSetTimeout(fun, 0);
        } catch(e){
            try {
                // When we are in I.E. but the script has been evaled so I.E. doesn't trust the global object when called normally
                return cachedSetTimeout.call(null, fun, 0);
            } catch(e){
                // same as above but when it's a version of I.E. that must have the global object for 'this', hopfully our context correct otherwise it will throw a global error
                return cachedSetTimeout.call(this, fun, 0);
            }
        }


    }
    function runClearTimeout(marker) {
        if (cachedClearTimeout === clearTimeout) {
            //normal enviroments in sane situations
            return clearTimeout(marker);
        }
        // if clearTimeout wasn't available but was latter defined
        if ((cachedClearTimeout === defaultClearTimeout || !cachedClearTimeout) && clearTimeout) {
            cachedClearTimeout = clearTimeout;
            return clearTimeout(marker);
        }
        try {
            // when when somebody has screwed with setTimeout but no I.E. maddness
            return cachedClearTimeout(marker);
        } catch (e){
            try {
                // When we are in I.E. but the script has been evaled so I.E. doesn't  trust the global object when called normally
                return cachedClearTimeout.call(null, marker);
            } catch (e){
                // same as above but when it's a version of I.E. that must have the global object for 'this', hopfully our context correct otherwise it will throw a global error.
                // Some versions of I.E. have different rules for clearTimeout vs setTimeout
                return cachedClearTimeout.call(this, marker);
            }
        }



    }
    var queue$1 = [];
    var draining = false;
    var currentQueue;
    var queueIndex = -1;

    function cleanUpNextTick() {
        if (!draining || !currentQueue) {
            return;
        }
        draining = false;
        if (currentQueue.length) {
            queue$1 = currentQueue.concat(queue$1);
        } else {
            queueIndex = -1;
        }
        if (queue$1.length) {
            drainQueue();
        }
    }

    function drainQueue() {
        if (draining) {
            return;
        }
        var timeout = runTimeout(cleanUpNextTick);
        draining = true;

        var len = queue$1.length;
        while(len) {
            currentQueue = queue$1;
            queue$1 = [];
            while (++queueIndex < len) {
                if (currentQueue) {
                    currentQueue[queueIndex].run();
                }
            }
            queueIndex = -1;
            len = queue$1.length;
        }
        currentQueue = null;
        draining = false;
        runClearTimeout(timeout);
    }
    function nextTick(fun) {
        var args = new Array(arguments.length - 1);
        if (arguments.length > 1) {
            for (var i = 1; i < arguments.length; i++) {
                args[i - 1] = arguments[i];
            }
        }
        queue$1.push(new Item(fun, args));
        if (queue$1.length === 1 && !draining) {
            runTimeout(drainQueue);
        }
    }
    // v8 likes predictible objects
    function Item(fun, array) {
        this.fun = fun;
        this.array = array;
    }
    Item.prototype.run = function () {
        this.fun.apply(null, this.array);
    };

    var inherits;
    if (typeof Object.create === 'function'){
      inherits = function inherits(ctor, superCtor) {
        // implementation from standard node.js 'util' module
        ctor.super_ = superCtor;
        ctor.prototype = Object.create(superCtor.prototype, {
          constructor: {
            value: ctor,
            enumerable: false,
            writable: true,
            configurable: true
          }
        });
      };
    } else {
      inherits = function inherits(ctor, superCtor) {
        ctor.super_ = superCtor;
        var TempCtor = function () {};
        TempCtor.prototype = superCtor.prototype;
        ctor.prototype = new TempCtor();
        ctor.prototype.constructor = ctor;
      };
    }
    var inherits$1 = inherits;

    // Copyright Joyent, Inc. and other Node contributors.
    var formatRegExp = /%[sdj%]/g;
    function format(f) {
      if (!isString(f)) {
        var objects = [];
        for (var i = 0; i < arguments.length; i++) {
          objects.push(inspect(arguments[i]));
        }
        return objects.join(' ');
      }

      var i = 1;
      var args = arguments;
      var len = args.length;
      var str = String(f).replace(formatRegExp, function(x) {
        if (x === '%%') return '%';
        if (i >= len) return x;
        switch (x) {
          case '%s': return String(args[i++]);
          case '%d': return Number(args[i++]);
          case '%j':
            try {
              return JSON.stringify(args[i++]);
            } catch (_) {
              return '[Circular]';
            }
          default:
            return x;
        }
      });
      for (var x = args[i]; i < len; x = args[++i]) {
        if (isNull(x) || !isObject$1(x)) {
          str += ' ' + x;
        } else {
          str += ' ' + inspect(x);
        }
      }
      return str;
    }

    // Mark that a method should not be used.
    // Returns a modified function which warns once by default.
    // If --no-deprecation is set, then it is a no-op.
    function deprecate(fn, msg) {
      // Allow for deprecating things in the process of starting up.
      if (isUndefined(global.process)) {
        return function() {
          return deprecate(fn, msg).apply(this, arguments);
        };
      }

      var warned = false;
      function deprecated() {
        if (!warned) {
          {
            console.error(msg);
          }
          warned = true;
        }
        return fn.apply(this, arguments);
      }

      return deprecated;
    }

    var debugs = {};
    var debugEnviron;
    function debuglog(set) {
      if (isUndefined(debugEnviron))
        debugEnviron =  '';
      set = set.toUpperCase();
      if (!debugs[set]) {
        if (new RegExp('\\b' + set + '\\b', 'i').test(debugEnviron)) {
          var pid = 0;
          debugs[set] = function() {
            var msg = format.apply(null, arguments);
            console.error('%s %d: %s', set, pid, msg);
          };
        } else {
          debugs[set] = function() {};
        }
      }
      return debugs[set];
    }

    /**
     * Echos the value of a value. Trys to print the value out
     * in the best way possible given the different types.
     *
     * @param {Object} obj The object to print out.
     * @param {Object} opts Optional options object that alters the output.
     */
    /* legacy: obj, showHidden, depth, colors*/
    function inspect(obj, opts) {
      // default options
      var ctx = {
        seen: [],
        stylize: stylizeNoColor
      };
      // legacy...
      if (arguments.length >= 3) ctx.depth = arguments[2];
      if (arguments.length >= 4) ctx.colors = arguments[3];
      if (isBoolean(opts)) {
        // legacy...
        ctx.showHidden = opts;
      } else if (opts) {
        // got an "options" object
        _extend(ctx, opts);
      }
      // set default options
      if (isUndefined(ctx.showHidden)) ctx.showHidden = false;
      if (isUndefined(ctx.depth)) ctx.depth = 2;
      if (isUndefined(ctx.colors)) ctx.colors = false;
      if (isUndefined(ctx.customInspect)) ctx.customInspect = true;
      if (ctx.colors) ctx.stylize = stylizeWithColor;
      return formatValue(ctx, obj, ctx.depth);
    }

    // http://en.wikipedia.org/wiki/ANSI_escape_code#graphics
    inspect.colors = {
      'bold' : [1, 22],
      'italic' : [3, 23],
      'underline' : [4, 24],
      'inverse' : [7, 27],
      'white' : [37, 39],
      'grey' : [90, 39],
      'black' : [30, 39],
      'blue' : [34, 39],
      'cyan' : [36, 39],
      'green' : [32, 39],
      'magenta' : [35, 39],
      'red' : [31, 39],
      'yellow' : [33, 39]
    };

    // Don't use 'blue' not visible on cmd.exe
    inspect.styles = {
      'special': 'cyan',
      'number': 'yellow',
      'boolean': 'yellow',
      'undefined': 'grey',
      'null': 'bold',
      'string': 'green',
      'date': 'magenta',
      // "name": intentionally not styling
      'regexp': 'red'
    };


    function stylizeWithColor(str, styleType) {
      var style = inspect.styles[styleType];

      if (style) {
        return '\u001b[' + inspect.colors[style][0] + 'm' + str +
               '\u001b[' + inspect.colors[style][1] + 'm';
      } else {
        return str;
      }
    }


    function stylizeNoColor(str, styleType) {
      return str;
    }


    function arrayToHash(array) {
      var hash = {};

      array.forEach(function(val, idx) {
        hash[val] = true;
      });

      return hash;
    }


    function formatValue(ctx, value, recurseTimes) {
      // Provide a hook for user-specified inspect functions.
      // Check that value is an object with an inspect function on it
      if (ctx.customInspect &&
          value &&
          isFunction$1(value.inspect) &&
          // Filter out the util module, it's inspect function is special
          value.inspect !== inspect &&
          // Also filter out any prototype objects using the circular check.
          !(value.constructor && value.constructor.prototype === value)) {
        var ret = value.inspect(recurseTimes, ctx);
        if (!isString(ret)) {
          ret = formatValue(ctx, ret, recurseTimes);
        }
        return ret;
      }

      // Primitive types cannot have properties
      var primitive = formatPrimitive(ctx, value);
      if (primitive) {
        return primitive;
      }

      // Look up the keys of the object.
      var keys = Object.keys(value);
      var visibleKeys = arrayToHash(keys);

      if (ctx.showHidden) {
        keys = Object.getOwnPropertyNames(value);
      }

      // IE doesn't make error fields non-enumerable
      // http://msdn.microsoft.com/en-us/library/ie/dww52sbt(v=vs.94).aspx
      if (isError(value)
          && (keys.indexOf('message') >= 0 || keys.indexOf('description') >= 0)) {
        return formatError(value);
      }

      // Some type of object without properties can be shortcutted.
      if (keys.length === 0) {
        if (isFunction$1(value)) {
          var name = value.name ? ': ' + value.name : '';
          return ctx.stylize('[Function' + name + ']', 'special');
        }
        if (isRegExp(value)) {
          return ctx.stylize(RegExp.prototype.toString.call(value), 'regexp');
        }
        if (isDate(value)) {
          return ctx.stylize(Date.prototype.toString.call(value), 'date');
        }
        if (isError(value)) {
          return formatError(value);
        }
      }

      var base = '', array = false, braces = ['{', '}'];

      // Make Array say that they are Array
      if (isArray$2(value)) {
        array = true;
        braces = ['[', ']'];
      }

      // Make functions say that they are functions
      if (isFunction$1(value)) {
        var n = value.name ? ': ' + value.name : '';
        base = ' [Function' + n + ']';
      }

      // Make RegExps say that they are RegExps
      if (isRegExp(value)) {
        base = ' ' + RegExp.prototype.toString.call(value);
      }

      // Make dates with properties first say the date
      if (isDate(value)) {
        base = ' ' + Date.prototype.toUTCString.call(value);
      }

      // Make error with message first say the error
      if (isError(value)) {
        base = ' ' + formatError(value);
      }

      if (keys.length === 0 && (!array || value.length == 0)) {
        return braces[0] + base + braces[1];
      }

      if (recurseTimes < 0) {
        if (isRegExp(value)) {
          return ctx.stylize(RegExp.prototype.toString.call(value), 'regexp');
        } else {
          return ctx.stylize('[Object]', 'special');
        }
      }

      ctx.seen.push(value);

      var output;
      if (array) {
        output = formatArray(ctx, value, recurseTimes, visibleKeys, keys);
      } else {
        output = keys.map(function(key) {
          return formatProperty(ctx, value, recurseTimes, visibleKeys, key, array);
        });
      }

      ctx.seen.pop();

      return reduceToSingleString(output, base, braces);
    }


    function formatPrimitive(ctx, value) {
      if (isUndefined(value))
        return ctx.stylize('undefined', 'undefined');
      if (isString(value)) {
        var simple = '\'' + JSON.stringify(value).replace(/^"|"$/g, '')
                                                 .replace(/'/g, "\\'")
                                                 .replace(/\\"/g, '"') + '\'';
        return ctx.stylize(simple, 'string');
      }
      if (isNumber(value))
        return ctx.stylize('' + value, 'number');
      if (isBoolean(value))
        return ctx.stylize('' + value, 'boolean');
      // For some reason typeof null is "object", so special case here.
      if (isNull(value))
        return ctx.stylize('null', 'null');
    }


    function formatError(value) {
      return '[' + Error.prototype.toString.call(value) + ']';
    }


    function formatArray(ctx, value, recurseTimes, visibleKeys, keys) {
      var output = [];
      for (var i = 0, l = value.length; i < l; ++i) {
        if (hasOwnProperty$2(value, String(i))) {
          output.push(formatProperty(ctx, value, recurseTimes, visibleKeys,
              String(i), true));
        } else {
          output.push('');
        }
      }
      keys.forEach(function(key) {
        if (!key.match(/^\d+$/)) {
          output.push(formatProperty(ctx, value, recurseTimes, visibleKeys,
              key, true));
        }
      });
      return output;
    }


    function formatProperty(ctx, value, recurseTimes, visibleKeys, key, array) {
      var name, str, desc;
      desc = Object.getOwnPropertyDescriptor(value, key) || { value: value[key] };
      if (desc.get) {
        if (desc.set) {
          str = ctx.stylize('[Getter/Setter]', 'special');
        } else {
          str = ctx.stylize('[Getter]', 'special');
        }
      } else {
        if (desc.set) {
          str = ctx.stylize('[Setter]', 'special');
        }
      }
      if (!hasOwnProperty$2(visibleKeys, key)) {
        name = '[' + key + ']';
      }
      if (!str) {
        if (ctx.seen.indexOf(desc.value) < 0) {
          if (isNull(recurseTimes)) {
            str = formatValue(ctx, desc.value, null);
          } else {
            str = formatValue(ctx, desc.value, recurseTimes - 1);
          }
          if (str.indexOf('\n') > -1) {
            if (array) {
              str = str.split('\n').map(function(line) {
                return '  ' + line;
              }).join('\n').substr(2);
            } else {
              str = '\n' + str.split('\n').map(function(line) {
                return '   ' + line;
              }).join('\n');
            }
          }
        } else {
          str = ctx.stylize('[Circular]', 'special');
        }
      }
      if (isUndefined(name)) {
        if (array && key.match(/^\d+$/)) {
          return str;
        }
        name = JSON.stringify('' + key);
        if (name.match(/^"([a-zA-Z_][a-zA-Z_0-9]*)"$/)) {
          name = name.substr(1, name.length - 2);
          name = ctx.stylize(name, 'name');
        } else {
          name = name.replace(/'/g, "\\'")
                     .replace(/\\"/g, '"')
                     .replace(/(^"|"$)/g, "'");
          name = ctx.stylize(name, 'string');
        }
      }

      return name + ': ' + str;
    }


    function reduceToSingleString(output, base, braces) {
      var length = output.reduce(function(prev, cur) {
        if (cur.indexOf('\n') >= 0) ;
        return prev + cur.replace(/\u001b\[\d\d?m/g, '').length + 1;
      }, 0);

      if (length > 60) {
        return braces[0] +
               (base === '' ? '' : base + '\n ') +
               ' ' +
               output.join(',\n  ') +
               ' ' +
               braces[1];
      }

      return braces[0] + base + ' ' + output.join(', ') + ' ' + braces[1];
    }


    // NOTE: These type checking functions intentionally don't use `instanceof`
    // because it is fragile and can be easily faked with `Object.create()`.
    function isArray$2(ar) {
      return Array.isArray(ar);
    }

    function isBoolean(arg) {
      return typeof arg === 'boolean';
    }

    function isNull(arg) {
      return arg === null;
    }

    function isNullOrUndefined(arg) {
      return arg == null;
    }

    function isNumber(arg) {
      return typeof arg === 'number';
    }

    function isString(arg) {
      return typeof arg === 'string';
    }

    function isSymbol(arg) {
      return typeof arg === 'symbol';
    }

    function isUndefined(arg) {
      return arg === void 0;
    }

    function isRegExp(re) {
      return isObject$1(re) && objectToString(re) === '[object RegExp]';
    }

    function isObject$1(arg) {
      return typeof arg === 'object' && arg !== null;
    }

    function isDate(d) {
      return isObject$1(d) && objectToString(d) === '[object Date]';
    }

    function isError(e) {
      return isObject$1(e) &&
          (objectToString(e) === '[object Error]' || e instanceof Error);
    }

    function isFunction$1(arg) {
      return typeof arg === 'function';
    }

    function isPrimitive(arg) {
      return arg === null ||
             typeof arg === 'boolean' ||
             typeof arg === 'number' ||
             typeof arg === 'string' ||
             typeof arg === 'symbol' ||  // ES6 symbol
             typeof arg === 'undefined';
    }

    function isBuffer(maybeBuf) {
      return Buffer.isBuffer(maybeBuf);
    }

    function objectToString(o) {
      return Object.prototype.toString.call(o);
    }


    function pad(n) {
      return n < 10 ? '0' + n.toString(10) : n.toString(10);
    }


    var months = ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep',
                  'Oct', 'Nov', 'Dec'];

    // 26 Feb 16:19:34
    function timestamp() {
      var d = new Date();
      var time = [pad(d.getHours()),
                  pad(d.getMinutes()),
                  pad(d.getSeconds())].join(':');
      return [d.getDate(), months[d.getMonth()], time].join(' ');
    }


    // log is just a thin wrapper to console.log that prepends a timestamp
    function log() {
      console.log('%s - %s', timestamp(), format.apply(null, arguments));
    }

    function _extend(origin, add) {
      // Don't do anything if add isn't an object
      if (!add || !isObject$1(add)) return origin;

      var keys = Object.keys(add);
      var i = keys.length;
      while (i--) {
        origin[keys[i]] = add[keys[i]];
      }
      return origin;
    }
    function hasOwnProperty$2(obj, prop) {
      return Object.prototype.hasOwnProperty.call(obj, prop);
    }

    var debugUtil = {
      inherits: inherits$1,
      _extend: _extend,
      log: log,
      isBuffer: isBuffer,
      isPrimitive: isPrimitive,
      isFunction: isFunction$1,
      isError: isError,
      isDate: isDate,
      isObject: isObject$1,
      isRegExp: isRegExp,
      isUndefined: isUndefined,
      isSymbol: isSymbol,
      isString: isString,
      isNumber: isNumber,
      isNullOrUndefined: isNullOrUndefined,
      isNull: isNull,
      isBoolean: isBoolean,
      isArray: isArray$2,
      inspect: inspect,
      deprecate: deprecate,
      format: format,
      debuglog: debuglog
    };

    var lookup = [];
    var revLookup = [];
    var Arr = typeof Uint8Array !== 'undefined' ? Uint8Array : Array;
    var inited = false;
    function init () {
      inited = true;
      var code = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/';
      for (var i = 0, len = code.length; i < len; ++i) {
        lookup[i] = code[i];
        revLookup[code.charCodeAt(i)] = i;
      }

      revLookup['-'.charCodeAt(0)] = 62;
      revLookup['_'.charCodeAt(0)] = 63;
    }

    function toByteArray (b64) {
      if (!inited) {
        init();
      }
      var i, j, l, tmp, placeHolders, arr;
      var len = b64.length;

      if (len % 4 > 0) {
        throw new Error('Invalid string. Length must be a multiple of 4')
      }

      // the number of equal signs (place holders)
      // if there are two placeholders, than the two characters before it
      // represent one byte
      // if there is only one, then the three characters before it represent 2 bytes
      // this is just a cheap hack to not do indexOf twice
      placeHolders = b64[len - 2] === '=' ? 2 : b64[len - 1] === '=' ? 1 : 0;

      // base64 is 4/3 + up to two characters of the original data
      arr = new Arr(len * 3 / 4 - placeHolders);

      // if there are placeholders, only get up to the last complete 4 chars
      l = placeHolders > 0 ? len - 4 : len;

      var L = 0;

      for (i = 0, j = 0; i < l; i += 4, j += 3) {
        tmp = (revLookup[b64.charCodeAt(i)] << 18) | (revLookup[b64.charCodeAt(i + 1)] << 12) | (revLookup[b64.charCodeAt(i + 2)] << 6) | revLookup[b64.charCodeAt(i + 3)];
        arr[L++] = (tmp >> 16) & 0xFF;
        arr[L++] = (tmp >> 8) & 0xFF;
        arr[L++] = tmp & 0xFF;
      }

      if (placeHolders === 2) {
        tmp = (revLookup[b64.charCodeAt(i)] << 2) | (revLookup[b64.charCodeAt(i + 1)] >> 4);
        arr[L++] = tmp & 0xFF;
      } else if (placeHolders === 1) {
        tmp = (revLookup[b64.charCodeAt(i)] << 10) | (revLookup[b64.charCodeAt(i + 1)] << 4) | (revLookup[b64.charCodeAt(i + 2)] >> 2);
        arr[L++] = (tmp >> 8) & 0xFF;
        arr[L++] = tmp & 0xFF;
      }

      return arr
    }

    function tripletToBase64 (num) {
      return lookup[num >> 18 & 0x3F] + lookup[num >> 12 & 0x3F] + lookup[num >> 6 & 0x3F] + lookup[num & 0x3F]
    }

    function encodeChunk (uint8, start, end) {
      var tmp;
      var output = [];
      for (var i = start; i < end; i += 3) {
        tmp = (uint8[i] << 16) + (uint8[i + 1] << 8) + (uint8[i + 2]);
        output.push(tripletToBase64(tmp));
      }
      return output.join('')
    }

    function fromByteArray (uint8) {
      if (!inited) {
        init();
      }
      var tmp;
      var len = uint8.length;
      var extraBytes = len % 3; // if we have 1 byte left, pad 2 bytes
      var output = '';
      var parts = [];
      var maxChunkLength = 16383; // must be multiple of 3

      // go through the array every three bytes, we'll deal with trailing stuff later
      for (var i = 0, len2 = len - extraBytes; i < len2; i += maxChunkLength) {
        parts.push(encodeChunk(uint8, i, (i + maxChunkLength) > len2 ? len2 : (i + maxChunkLength)));
      }

      // pad the end with zeros, but make sure to not forget the extra bytes
      if (extraBytes === 1) {
        tmp = uint8[len - 1];
        output += lookup[tmp >> 2];
        output += lookup[(tmp << 4) & 0x3F];
        output += '==';
      } else if (extraBytes === 2) {
        tmp = (uint8[len - 2] << 8) + (uint8[len - 1]);
        output += lookup[tmp >> 10];
        output += lookup[(tmp >> 4) & 0x3F];
        output += lookup[(tmp << 2) & 0x3F];
        output += '=';
      }

      parts.push(output);

      return parts.join('')
    }

    function read (buffer, offset, isLE, mLen, nBytes) {
      var e, m;
      var eLen = nBytes * 8 - mLen - 1;
      var eMax = (1 << eLen) - 1;
      var eBias = eMax >> 1;
      var nBits = -7;
      var i = isLE ? (nBytes - 1) : 0;
      var d = isLE ? -1 : 1;
      var s = buffer[offset + i];

      i += d;

      e = s & ((1 << (-nBits)) - 1);
      s >>= (-nBits);
      nBits += eLen;
      for (; nBits > 0; e = e * 256 + buffer[offset + i], i += d, nBits -= 8) {}

      m = e & ((1 << (-nBits)) - 1);
      e >>= (-nBits);
      nBits += mLen;
      for (; nBits > 0; m = m * 256 + buffer[offset + i], i += d, nBits -= 8) {}

      if (e === 0) {
        e = 1 - eBias;
      } else if (e === eMax) {
        return m ? NaN : ((s ? -1 : 1) * Infinity)
      } else {
        m = m + Math.pow(2, mLen);
        e = e - eBias;
      }
      return (s ? -1 : 1) * m * Math.pow(2, e - mLen)
    }

    function write (buffer, value, offset, isLE, mLen, nBytes) {
      var e, m, c;
      var eLen = nBytes * 8 - mLen - 1;
      var eMax = (1 << eLen) - 1;
      var eBias = eMax >> 1;
      var rt = (mLen === 23 ? Math.pow(2, -24) - Math.pow(2, -77) : 0);
      var i = isLE ? 0 : (nBytes - 1);
      var d = isLE ? 1 : -1;
      var s = value < 0 || (value === 0 && 1 / value < 0) ? 1 : 0;

      value = Math.abs(value);

      if (isNaN(value) || value === Infinity) {
        m = isNaN(value) ? 1 : 0;
        e = eMax;
      } else {
        e = Math.floor(Math.log(value) / Math.LN2);
        if (value * (c = Math.pow(2, -e)) < 1) {
          e--;
          c *= 2;
        }
        if (e + eBias >= 1) {
          value += rt / c;
        } else {
          value += rt * Math.pow(2, 1 - eBias);
        }
        if (value * c >= 2) {
          e++;
          c /= 2;
        }

        if (e + eBias >= eMax) {
          m = 0;
          e = eMax;
        } else if (e + eBias >= 1) {
          m = (value * c - 1) * Math.pow(2, mLen);
          e = e + eBias;
        } else {
          m = value * Math.pow(2, eBias - 1) * Math.pow(2, mLen);
          e = 0;
        }
      }

      for (; mLen >= 8; buffer[offset + i] = m & 0xff, i += d, m /= 256, mLen -= 8) {}

      e = (e << mLen) | m;
      eLen += mLen;
      for (; eLen > 0; buffer[offset + i] = e & 0xff, i += d, e /= 256, eLen -= 8) {}

      buffer[offset + i - d] |= s * 128;
    }

    var toString = {}.toString;

    var isArray$3 = Array.isArray || function (arr) {
      return toString.call(arr) == '[object Array]';
    };

    /*!
     * The buffer module from node.js, for the browser.
     *
     * @author   Feross Aboukhadijeh <feross@feross.org> <http://feross.org>
     * @license  MIT
     */

    var INSPECT_MAX_BYTES = 50;

    /**
     * If `Buffer.TYPED_ARRAY_SUPPORT`:
     *   === true    Use Uint8Array implementation (fastest)
     *   === false   Use Object implementation (most compatible, even IE6)
     *
     * Browsers that support typed arrays are IE 10+, Firefox 4+, Chrome 7+, Safari 5.1+,
     * Opera 11.6+, iOS 4.2+.
     *
     * Due to various browser bugs, sometimes the Object implementation will be used even
     * when the browser supports typed arrays.
     *
     * Note:
     *
     *   - Firefox 4-29 lacks support for adding new properties to `Uint8Array` instances,
     *     See: https://bugzilla.mozilla.org/show_bug.cgi?id=695438.
     *
     *   - Chrome 9-10 is missing the `TypedArray.prototype.subarray` function.
     *
     *   - IE10 has a broken `TypedArray.prototype.subarray` function which returns arrays of
     *     incorrect length in some situations.

     * We detect these buggy browsers and set `Buffer.TYPED_ARRAY_SUPPORT` to `false` so they
     * get the Object implementation, which is slower but behaves correctly.
     */
    Buffer$1.TYPED_ARRAY_SUPPORT = global.TYPED_ARRAY_SUPPORT !== undefined
      ? global.TYPED_ARRAY_SUPPORT
      : true;

    /*
     * Export kMaxLength after typed array support is determined.
     */
    var _kMaxLength = kMaxLength();

    function kMaxLength () {
      return Buffer$1.TYPED_ARRAY_SUPPORT
        ? 0x7fffffff
        : 0x3fffffff
    }

    function createBuffer (that, length) {
      if (kMaxLength() < length) {
        throw new RangeError('Invalid typed array length')
      }
      if (Buffer$1.TYPED_ARRAY_SUPPORT) {
        // Return an augmented `Uint8Array` instance, for best performance
        that = new Uint8Array(length);
        that.__proto__ = Buffer$1.prototype;
      } else {
        // Fallback: Return an object instance of the Buffer class
        if (that === null) {
          that = new Buffer$1(length);
        }
        that.length = length;
      }

      return that
    }

    /**
     * The Buffer constructor returns instances of `Uint8Array` that have their
     * prototype changed to `Buffer.prototype`. Furthermore, `Buffer` is a subclass of
     * `Uint8Array`, so the returned instances will have all the node `Buffer` methods
     * and the `Uint8Array` methods. Square bracket notation works as expected -- it
     * returns a single octet.
     *
     * The `Uint8Array` prototype remains unmodified.
     */

    function Buffer$1 (arg, encodingOrOffset, length) {
      if (!Buffer$1.TYPED_ARRAY_SUPPORT && !(this instanceof Buffer$1)) {
        return new Buffer$1(arg, encodingOrOffset, length)
      }

      // Common case.
      if (typeof arg === 'number') {
        if (typeof encodingOrOffset === 'string') {
          throw new Error(
            'If encoding is specified then the first argument must be a string'
          )
        }
        return allocUnsafe(this, arg)
      }
      return from(this, arg, encodingOrOffset, length)
    }

    Buffer$1.poolSize = 8192; // not used by this implementation

    // TODO: Legacy, not needed anymore. Remove in next major version.
    Buffer$1._augment = function (arr) {
      arr.__proto__ = Buffer$1.prototype;
      return arr
    };

    function from (that, value, encodingOrOffset, length) {
      if (typeof value === 'number') {
        throw new TypeError('"value" argument must not be a number')
      }

      if (typeof ArrayBuffer !== 'undefined' && value instanceof ArrayBuffer) {
        return fromArrayBuffer(that, value, encodingOrOffset, length)
      }

      if (typeof value === 'string') {
        return fromString(that, value, encodingOrOffset)
      }

      return fromObject(that, value)
    }

    /**
     * Functionally equivalent to Buffer(arg, encoding) but throws a TypeError
     * if value is a number.
     * Buffer.from(str[, encoding])
     * Buffer.from(array)
     * Buffer.from(buffer)
     * Buffer.from(arrayBuffer[, byteOffset[, length]])
     **/
    Buffer$1.from = function (value, encodingOrOffset, length) {
      return from(null, value, encodingOrOffset, length)
    };

    if (Buffer$1.TYPED_ARRAY_SUPPORT) {
      Buffer$1.prototype.__proto__ = Uint8Array.prototype;
      Buffer$1.__proto__ = Uint8Array;
    }

    function assertSize (size) {
      if (typeof size !== 'number') {
        throw new TypeError('"size" argument must be a number')
      } else if (size < 0) {
        throw new RangeError('"size" argument must not be negative')
      }
    }

    function alloc (that, size, fill, encoding) {
      assertSize(size);
      if (size <= 0) {
        return createBuffer(that, size)
      }
      if (fill !== undefined) {
        // Only pay attention to encoding if it's a string. This
        // prevents accidentally sending in a number that would
        // be interpretted as a start offset.
        return typeof encoding === 'string'
          ? createBuffer(that, size).fill(fill, encoding)
          : createBuffer(that, size).fill(fill)
      }
      return createBuffer(that, size)
    }

    /**
     * Creates a new filled Buffer instance.
     * alloc(size[, fill[, encoding]])
     **/
    Buffer$1.alloc = function (size, fill, encoding) {
      return alloc(null, size, fill, encoding)
    };

    function allocUnsafe (that, size) {
      assertSize(size);
      that = createBuffer(that, size < 0 ? 0 : checked(size) | 0);
      if (!Buffer$1.TYPED_ARRAY_SUPPORT) {
        for (var i = 0; i < size; ++i) {
          that[i] = 0;
        }
      }
      return that
    }

    /**
     * Equivalent to Buffer(num), by default creates a non-zero-filled Buffer instance.
     * */
    Buffer$1.allocUnsafe = function (size) {
      return allocUnsafe(null, size)
    };
    /**
     * Equivalent to SlowBuffer(num), by default creates a non-zero-filled Buffer instance.
     */
    Buffer$1.allocUnsafeSlow = function (size) {
      return allocUnsafe(null, size)
    };

    function fromString (that, string, encoding) {
      if (typeof encoding !== 'string' || encoding === '') {
        encoding = 'utf8';
      }

      if (!Buffer$1.isEncoding(encoding)) {
        throw new TypeError('"encoding" must be a valid string encoding')
      }

      var length = byteLength(string, encoding) | 0;
      that = createBuffer(that, length);

      var actual = that.write(string, encoding);

      if (actual !== length) {
        // Writing a hex string, for example, that contains invalid characters will
        // cause everything after the first invalid character to be ignored. (e.g.
        // 'abxxcd' will be treated as 'ab')
        that = that.slice(0, actual);
      }

      return that
    }

    function fromArrayLike (that, array) {
      var length = array.length < 0 ? 0 : checked(array.length) | 0;
      that = createBuffer(that, length);
      for (var i = 0; i < length; i += 1) {
        that[i] = array[i] & 255;
      }
      return that
    }

    function fromArrayBuffer (that, array, byteOffset, length) {
      array.byteLength; // this throws if `array` is not a valid ArrayBuffer

      if (byteOffset < 0 || array.byteLength < byteOffset) {
        throw new RangeError('\'offset\' is out of bounds')
      }

      if (array.byteLength < byteOffset + (length || 0)) {
        throw new RangeError('\'length\' is out of bounds')
      }

      if (byteOffset === undefined && length === undefined) {
        array = new Uint8Array(array);
      } else if (length === undefined) {
        array = new Uint8Array(array, byteOffset);
      } else {
        array = new Uint8Array(array, byteOffset, length);
      }

      if (Buffer$1.TYPED_ARRAY_SUPPORT) {
        // Return an augmented `Uint8Array` instance, for best performance
        that = array;
        that.__proto__ = Buffer$1.prototype;
      } else {
        // Fallback: Return an object instance of the Buffer class
        that = fromArrayLike(that, array);
      }
      return that
    }

    function fromObject (that, obj) {
      if (internalIsBuffer(obj)) {
        var len = checked(obj.length) | 0;
        that = createBuffer(that, len);

        if (that.length === 0) {
          return that
        }

        obj.copy(that, 0, 0, len);
        return that
      }

      if (obj) {
        if ((typeof ArrayBuffer !== 'undefined' &&
            obj.buffer instanceof ArrayBuffer) || 'length' in obj) {
          if (typeof obj.length !== 'number' || isnan(obj.length)) {
            return createBuffer(that, 0)
          }
          return fromArrayLike(that, obj)
        }

        if (obj.type === 'Buffer' && isArray$3(obj.data)) {
          return fromArrayLike(that, obj.data)
        }
      }

      throw new TypeError('First argument must be a string, Buffer, ArrayBuffer, Array, or array-like object.')
    }

    function checked (length) {
      // Note: cannot use `length < kMaxLength()` here because that fails when
      // length is NaN (which is otherwise coerced to zero.)
      if (length >= kMaxLength()) {
        throw new RangeError('Attempt to allocate Buffer larger than maximum ' +
                             'size: 0x' + kMaxLength().toString(16) + ' bytes')
      }
      return length | 0
    }

    function SlowBuffer (length) {
      if (+length != length) { // eslint-disable-line eqeqeq
        length = 0;
      }
      return Buffer$1.alloc(+length)
    }
    Buffer$1.isBuffer = isBuffer$1;
    function internalIsBuffer (b) {
      return !!(b != null && b._isBuffer)
    }

    Buffer$1.compare = function compare (a, b) {
      if (!internalIsBuffer(a) || !internalIsBuffer(b)) {
        throw new TypeError('Arguments must be Buffers')
      }

      if (a === b) return 0

      var x = a.length;
      var y = b.length;

      for (var i = 0, len = Math.min(x, y); i < len; ++i) {
        if (a[i] !== b[i]) {
          x = a[i];
          y = b[i];
          break
        }
      }

      if (x < y) return -1
      if (y < x) return 1
      return 0
    };

    Buffer$1.isEncoding = function isEncoding (encoding) {
      switch (String(encoding).toLowerCase()) {
        case 'hex':
        case 'utf8':
        case 'utf-8':
        case 'ascii':
        case 'latin1':
        case 'binary':
        case 'base64':
        case 'ucs2':
        case 'ucs-2':
        case 'utf16le':
        case 'utf-16le':
          return true
        default:
          return false
      }
    };

    Buffer$1.concat = function concat (list, length) {
      if (!isArray$3(list)) {
        throw new TypeError('"list" argument must be an Array of Buffers')
      }

      if (list.length === 0) {
        return Buffer$1.alloc(0)
      }

      var i;
      if (length === undefined) {
        length = 0;
        for (i = 0; i < list.length; ++i) {
          length += list[i].length;
        }
      }

      var buffer = Buffer$1.allocUnsafe(length);
      var pos = 0;
      for (i = 0; i < list.length; ++i) {
        var buf = list[i];
        if (!internalIsBuffer(buf)) {
          throw new TypeError('"list" argument must be an Array of Buffers')
        }
        buf.copy(buffer, pos);
        pos += buf.length;
      }
      return buffer
    };

    function byteLength (string, encoding) {
      if (internalIsBuffer(string)) {
        return string.length
      }
      if (typeof ArrayBuffer !== 'undefined' && typeof ArrayBuffer.isView === 'function' &&
          (ArrayBuffer.isView(string) || string instanceof ArrayBuffer)) {
        return string.byteLength
      }
      if (typeof string !== 'string') {
        string = '' + string;
      }

      var len = string.length;
      if (len === 0) return 0

      // Use a for loop to avoid recursion
      var loweredCase = false;
      for (;;) {
        switch (encoding) {
          case 'ascii':
          case 'latin1':
          case 'binary':
            return len
          case 'utf8':
          case 'utf-8':
          case undefined:
            return utf8ToBytes(string).length
          case 'ucs2':
          case 'ucs-2':
          case 'utf16le':
          case 'utf-16le':
            return len * 2
          case 'hex':
            return len >>> 1
          case 'base64':
            return base64ToBytes(string).length
          default:
            if (loweredCase) return utf8ToBytes(string).length // assume utf8
            encoding = ('' + encoding).toLowerCase();
            loweredCase = true;
        }
      }
    }
    Buffer$1.byteLength = byteLength;

    function slowToString (encoding, start, end) {
      var loweredCase = false;

      // No need to verify that "this.length <= MAX_UINT32" since it's a read-only
      // property of a typed array.

      // This behaves neither like String nor Uint8Array in that we set start/end
      // to their upper/lower bounds if the value passed is out of range.
      // undefined is handled specially as per ECMA-262 6th Edition,
      // Section 13.3.3.7 Runtime Semantics: KeyedBindingInitialization.
      if (start === undefined || start < 0) {
        start = 0;
      }
      // Return early if start > this.length. Done here to prevent potential uint32
      // coercion fail below.
      if (start > this.length) {
        return ''
      }

      if (end === undefined || end > this.length) {
        end = this.length;
      }

      if (end <= 0) {
        return ''
      }

      // Force coersion to uint32. This will also coerce falsey/NaN values to 0.
      end >>>= 0;
      start >>>= 0;

      if (end <= start) {
        return ''
      }

      if (!encoding) encoding = 'utf8';

      while (true) {
        switch (encoding) {
          case 'hex':
            return hexSlice(this, start, end)

          case 'utf8':
          case 'utf-8':
            return utf8Slice(this, start, end)

          case 'ascii':
            return asciiSlice(this, start, end)

          case 'latin1':
          case 'binary':
            return latin1Slice(this, start, end)

          case 'base64':
            return base64Slice(this, start, end)

          case 'ucs2':
          case 'ucs-2':
          case 'utf16le':
          case 'utf-16le':
            return utf16leSlice(this, start, end)

          default:
            if (loweredCase) throw new TypeError('Unknown encoding: ' + encoding)
            encoding = (encoding + '').toLowerCase();
            loweredCase = true;
        }
      }
    }

    // The property is used by `Buffer.isBuffer` and `is-buffer` (in Safari 5-7) to detect
    // Buffer instances.
    Buffer$1.prototype._isBuffer = true;

    function swap (b, n, m) {
      var i = b[n];
      b[n] = b[m];
      b[m] = i;
    }

    Buffer$1.prototype.swap16 = function swap16 () {
      var len = this.length;
      if (len % 2 !== 0) {
        throw new RangeError('Buffer size must be a multiple of 16-bits')
      }
      for (var i = 0; i < len; i += 2) {
        swap(this, i, i + 1);
      }
      return this
    };

    Buffer$1.prototype.swap32 = function swap32 () {
      var len = this.length;
      if (len % 4 !== 0) {
        throw new RangeError('Buffer size must be a multiple of 32-bits')
      }
      for (var i = 0; i < len; i += 4) {
        swap(this, i, i + 3);
        swap(this, i + 1, i + 2);
      }
      return this
    };

    Buffer$1.prototype.swap64 = function swap64 () {
      var len = this.length;
      if (len % 8 !== 0) {
        throw new RangeError('Buffer size must be a multiple of 64-bits')
      }
      for (var i = 0; i < len; i += 8) {
        swap(this, i, i + 7);
        swap(this, i + 1, i + 6);
        swap(this, i + 2, i + 5);
        swap(this, i + 3, i + 4);
      }
      return this
    };

    Buffer$1.prototype.toString = function toString () {
      var length = this.length | 0;
      if (length === 0) return ''
      if (arguments.length === 0) return utf8Slice(this, 0, length)
      return slowToString.apply(this, arguments)
    };

    Buffer$1.prototype.equals = function equals (b) {
      if (!internalIsBuffer(b)) throw new TypeError('Argument must be a Buffer')
      if (this === b) return true
      return Buffer$1.compare(this, b) === 0
    };

    Buffer$1.prototype.inspect = function inspect () {
      var str = '';
      var max = INSPECT_MAX_BYTES;
      if (this.length > 0) {
        str = this.toString('hex', 0, max).match(/.{2}/g).join(' ');
        if (this.length > max) str += ' ... ';
      }
      return '<Buffer ' + str + '>'
    };

    Buffer$1.prototype.compare = function compare (target, start, end, thisStart, thisEnd) {
      if (!internalIsBuffer(target)) {
        throw new TypeError('Argument must be a Buffer')
      }

      if (start === undefined) {
        start = 0;
      }
      if (end === undefined) {
        end = target ? target.length : 0;
      }
      if (thisStart === undefined) {
        thisStart = 0;
      }
      if (thisEnd === undefined) {
        thisEnd = this.length;
      }

      if (start < 0 || end > target.length || thisStart < 0 || thisEnd > this.length) {
        throw new RangeError('out of range index')
      }

      if (thisStart >= thisEnd && start >= end) {
        return 0
      }
      if (thisStart >= thisEnd) {
        return -1
      }
      if (start >= end) {
        return 1
      }

      start >>>= 0;
      end >>>= 0;
      thisStart >>>= 0;
      thisEnd >>>= 0;

      if (this === target) return 0

      var x = thisEnd - thisStart;
      var y = end - start;
      var len = Math.min(x, y);

      var thisCopy = this.slice(thisStart, thisEnd);
      var targetCopy = target.slice(start, end);

      for (var i = 0; i < len; ++i) {
        if (thisCopy[i] !== targetCopy[i]) {
          x = thisCopy[i];
          y = targetCopy[i];
          break
        }
      }

      if (x < y) return -1
      if (y < x) return 1
      return 0
    };

    // Finds either the first index of `val` in `buffer` at offset >= `byteOffset`,
    // OR the last index of `val` in `buffer` at offset <= `byteOffset`.
    //
    // Arguments:
    // - buffer - a Buffer to search
    // - val - a string, Buffer, or number
    // - byteOffset - an index into `buffer`; will be clamped to an int32
    // - encoding - an optional encoding, relevant is val is a string
    // - dir - true for indexOf, false for lastIndexOf
    function bidirectionalIndexOf (buffer, val, byteOffset, encoding, dir) {
      // Empty buffer means no match
      if (buffer.length === 0) return -1

      // Normalize byteOffset
      if (typeof byteOffset === 'string') {
        encoding = byteOffset;
        byteOffset = 0;
      } else if (byteOffset > 0x7fffffff) {
        byteOffset = 0x7fffffff;
      } else if (byteOffset < -0x80000000) {
        byteOffset = -0x80000000;
      }
      byteOffset = +byteOffset;  // Coerce to Number.
      if (isNaN(byteOffset)) {
        // byteOffset: it it's undefined, null, NaN, "foo", etc, search whole buffer
        byteOffset = dir ? 0 : (buffer.length - 1);
      }

      // Normalize byteOffset: negative offsets start from the end of the buffer
      if (byteOffset < 0) byteOffset = buffer.length + byteOffset;
      if (byteOffset >= buffer.length) {
        if (dir) return -1
        else byteOffset = buffer.length - 1;
      } else if (byteOffset < 0) {
        if (dir) byteOffset = 0;
        else return -1
      }

      // Normalize val
      if (typeof val === 'string') {
        val = Buffer$1.from(val, encoding);
      }

      // Finally, search either indexOf (if dir is true) or lastIndexOf
      if (internalIsBuffer(val)) {
        // Special case: looking for empty string/buffer always fails
        if (val.length === 0) {
          return -1
        }
        return arrayIndexOf(buffer, val, byteOffset, encoding, dir)
      } else if (typeof val === 'number') {
        val = val & 0xFF; // Search for a byte value [0-255]
        if (Buffer$1.TYPED_ARRAY_SUPPORT &&
            typeof Uint8Array.prototype.indexOf === 'function') {
          if (dir) {
            return Uint8Array.prototype.indexOf.call(buffer, val, byteOffset)
          } else {
            return Uint8Array.prototype.lastIndexOf.call(buffer, val, byteOffset)
          }
        }
        return arrayIndexOf(buffer, [ val ], byteOffset, encoding, dir)
      }

      throw new TypeError('val must be string, number or Buffer')
    }

    function arrayIndexOf (arr, val, byteOffset, encoding, dir) {
      var indexSize = 1;
      var arrLength = arr.length;
      var valLength = val.length;

      if (encoding !== undefined) {
        encoding = String(encoding).toLowerCase();
        if (encoding === 'ucs2' || encoding === 'ucs-2' ||
            encoding === 'utf16le' || encoding === 'utf-16le') {
          if (arr.length < 2 || val.length < 2) {
            return -1
          }
          indexSize = 2;
          arrLength /= 2;
          valLength /= 2;
          byteOffset /= 2;
        }
      }

      function read (buf, i) {
        if (indexSize === 1) {
          return buf[i]
        } else {
          return buf.readUInt16BE(i * indexSize)
        }
      }

      var i;
      if (dir) {
        var foundIndex = -1;
        for (i = byteOffset; i < arrLength; i++) {
          if (read(arr, i) === read(val, foundIndex === -1 ? 0 : i - foundIndex)) {
            if (foundIndex === -1) foundIndex = i;
            if (i - foundIndex + 1 === valLength) return foundIndex * indexSize
          } else {
            if (foundIndex !== -1) i -= i - foundIndex;
            foundIndex = -1;
          }
        }
      } else {
        if (byteOffset + valLength > arrLength) byteOffset = arrLength - valLength;
        for (i = byteOffset; i >= 0; i--) {
          var found = true;
          for (var j = 0; j < valLength; j++) {
            if (read(arr, i + j) !== read(val, j)) {
              found = false;
              break
            }
          }
          if (found) return i
        }
      }

      return -1
    }

    Buffer$1.prototype.includes = function includes (val, byteOffset, encoding) {
      return this.indexOf(val, byteOffset, encoding) !== -1
    };

    Buffer$1.prototype.indexOf = function indexOf (val, byteOffset, encoding) {
      return bidirectionalIndexOf(this, val, byteOffset, encoding, true)
    };

    Buffer$1.prototype.lastIndexOf = function lastIndexOf (val, byteOffset, encoding) {
      return bidirectionalIndexOf(this, val, byteOffset, encoding, false)
    };

    function hexWrite (buf, string, offset, length) {
      offset = Number(offset) || 0;
      var remaining = buf.length - offset;
      if (!length) {
        length = remaining;
      } else {
        length = Number(length);
        if (length > remaining) {
          length = remaining;
        }
      }

      // must be an even number of digits
      var strLen = string.length;
      if (strLen % 2 !== 0) throw new TypeError('Invalid hex string')

      if (length > strLen / 2) {
        length = strLen / 2;
      }
      for (var i = 0; i < length; ++i) {
        var parsed = parseInt(string.substr(i * 2, 2), 16);
        if (isNaN(parsed)) return i
        buf[offset + i] = parsed;
      }
      return i
    }

    function utf8Write (buf, string, offset, length) {
      return blitBuffer(utf8ToBytes(string, buf.length - offset), buf, offset, length)
    }

    function asciiWrite (buf, string, offset, length) {
      return blitBuffer(asciiToBytes(string), buf, offset, length)
    }

    function latin1Write (buf, string, offset, length) {
      return asciiWrite(buf, string, offset, length)
    }

    function base64Write (buf, string, offset, length) {
      return blitBuffer(base64ToBytes(string), buf, offset, length)
    }

    function ucs2Write (buf, string, offset, length) {
      return blitBuffer(utf16leToBytes(string, buf.length - offset), buf, offset, length)
    }

    Buffer$1.prototype.write = function write (string, offset, length, encoding) {
      // Buffer#write(string)
      if (offset === undefined) {
        encoding = 'utf8';
        length = this.length;
        offset = 0;
      // Buffer#write(string, encoding)
      } else if (length === undefined && typeof offset === 'string') {
        encoding = offset;
        length = this.length;
        offset = 0;
      // Buffer#write(string, offset[, length][, encoding])
      } else if (isFinite(offset)) {
        offset = offset | 0;
        if (isFinite(length)) {
          length = length | 0;
          if (encoding === undefined) encoding = 'utf8';
        } else {
          encoding = length;
          length = undefined;
        }
      // legacy write(string, encoding, offset, length) - remove in v0.13
      } else {
        throw new Error(
          'Buffer.write(string, encoding, offset[, length]) is no longer supported'
        )
      }

      var remaining = this.length - offset;
      if (length === undefined || length > remaining) length = remaining;

      if ((string.length > 0 && (length < 0 || offset < 0)) || offset > this.length) {
        throw new RangeError('Attempt to write outside buffer bounds')
      }

      if (!encoding) encoding = 'utf8';

      var loweredCase = false;
      for (;;) {
        switch (encoding) {
          case 'hex':
            return hexWrite(this, string, offset, length)

          case 'utf8':
          case 'utf-8':
            return utf8Write(this, string, offset, length)

          case 'ascii':
            return asciiWrite(this, string, offset, length)

          case 'latin1':
          case 'binary':
            return latin1Write(this, string, offset, length)

          case 'base64':
            // Warning: maxLength not taken into account in base64Write
            return base64Write(this, string, offset, length)

          case 'ucs2':
          case 'ucs-2':
          case 'utf16le':
          case 'utf-16le':
            return ucs2Write(this, string, offset, length)

          default:
            if (loweredCase) throw new TypeError('Unknown encoding: ' + encoding)
            encoding = ('' + encoding).toLowerCase();
            loweredCase = true;
        }
      }
    };

    Buffer$1.prototype.toJSON = function toJSON () {
      return {
        type: 'Buffer',
        data: Array.prototype.slice.call(this._arr || this, 0)
      }
    };

    function base64Slice (buf, start, end) {
      if (start === 0 && end === buf.length) {
        return fromByteArray(buf)
      } else {
        return fromByteArray(buf.slice(start, end))
      }
    }

    function utf8Slice (buf, start, end) {
      end = Math.min(buf.length, end);
      var res = [];

      var i = start;
      while (i < end) {
        var firstByte = buf[i];
        var codePoint = null;
        var bytesPerSequence = (firstByte > 0xEF) ? 4
          : (firstByte > 0xDF) ? 3
          : (firstByte > 0xBF) ? 2
          : 1;

        if (i + bytesPerSequence <= end) {
          var secondByte, thirdByte, fourthByte, tempCodePoint;

          switch (bytesPerSequence) {
            case 1:
              if (firstByte < 0x80) {
                codePoint = firstByte;
              }
              break
            case 2:
              secondByte = buf[i + 1];
              if ((secondByte & 0xC0) === 0x80) {
                tempCodePoint = (firstByte & 0x1F) << 0x6 | (secondByte & 0x3F);
                if (tempCodePoint > 0x7F) {
                  codePoint = tempCodePoint;
                }
              }
              break
            case 3:
              secondByte = buf[i + 1];
              thirdByte = buf[i + 2];
              if ((secondByte & 0xC0) === 0x80 && (thirdByte & 0xC0) === 0x80) {
                tempCodePoint = (firstByte & 0xF) << 0xC | (secondByte & 0x3F) << 0x6 | (thirdByte & 0x3F);
                if (tempCodePoint > 0x7FF && (tempCodePoint < 0xD800 || tempCodePoint > 0xDFFF)) {
                  codePoint = tempCodePoint;
                }
              }
              break
            case 4:
              secondByte = buf[i + 1];
              thirdByte = buf[i + 2];
              fourthByte = buf[i + 3];
              if ((secondByte & 0xC0) === 0x80 && (thirdByte & 0xC0) === 0x80 && (fourthByte & 0xC0) === 0x80) {
                tempCodePoint = (firstByte & 0xF) << 0x12 | (secondByte & 0x3F) << 0xC | (thirdByte & 0x3F) << 0x6 | (fourthByte & 0x3F);
                if (tempCodePoint > 0xFFFF && tempCodePoint < 0x110000) {
                  codePoint = tempCodePoint;
                }
              }
          }
        }

        if (codePoint === null) {
          // we did not generate a valid codePoint so insert a
          // replacement char (U+FFFD) and advance only 1 byte
          codePoint = 0xFFFD;
          bytesPerSequence = 1;
        } else if (codePoint > 0xFFFF) {
          // encode to utf16 (surrogate pair dance)
          codePoint -= 0x10000;
          res.push(codePoint >>> 10 & 0x3FF | 0xD800);
          codePoint = 0xDC00 | codePoint & 0x3FF;
        }

        res.push(codePoint);
        i += bytesPerSequence;
      }

      return decodeCodePointsArray(res)
    }

    // Based on http://stackoverflow.com/a/22747272/680742, the browser with
    // the lowest limit is Chrome, with 0x10000 args.
    // We go 1 magnitude less, for safety
    var MAX_ARGUMENTS_LENGTH = 0x1000;

    function decodeCodePointsArray (codePoints) {
      var len = codePoints.length;
      if (len <= MAX_ARGUMENTS_LENGTH) {
        return String.fromCharCode.apply(String, codePoints) // avoid extra slice()
      }

      // Decode in chunks to avoid "call stack size exceeded".
      var res = '';
      var i = 0;
      while (i < len) {
        res += String.fromCharCode.apply(
          String,
          codePoints.slice(i, i += MAX_ARGUMENTS_LENGTH)
        );
      }
      return res
    }

    function asciiSlice (buf, start, end) {
      var ret = '';
      end = Math.min(buf.length, end);

      for (var i = start; i < end; ++i) {
        ret += String.fromCharCode(buf[i] & 0x7F);
      }
      return ret
    }

    function latin1Slice (buf, start, end) {
      var ret = '';
      end = Math.min(buf.length, end);

      for (var i = start; i < end; ++i) {
        ret += String.fromCharCode(buf[i]);
      }
      return ret
    }

    function hexSlice (buf, start, end) {
      var len = buf.length;

      if (!start || start < 0) start = 0;
      if (!end || end < 0 || end > len) end = len;

      var out = '';
      for (var i = start; i < end; ++i) {
        out += toHex(buf[i]);
      }
      return out
    }

    function utf16leSlice (buf, start, end) {
      var bytes = buf.slice(start, end);
      var res = '';
      for (var i = 0; i < bytes.length; i += 2) {
        res += String.fromCharCode(bytes[i] + bytes[i + 1] * 256);
      }
      return res
    }

    Buffer$1.prototype.slice = function slice (start, end) {
      var len = this.length;
      start = ~~start;
      end = end === undefined ? len : ~~end;

      if (start < 0) {
        start += len;
        if (start < 0) start = 0;
      } else if (start > len) {
        start = len;
      }

      if (end < 0) {
        end += len;
        if (end < 0) end = 0;
      } else if (end > len) {
        end = len;
      }

      if (end < start) end = start;

      var newBuf;
      if (Buffer$1.TYPED_ARRAY_SUPPORT) {
        newBuf = this.subarray(start, end);
        newBuf.__proto__ = Buffer$1.prototype;
      } else {
        var sliceLen = end - start;
        newBuf = new Buffer$1(sliceLen, undefined);
        for (var i = 0; i < sliceLen; ++i) {
          newBuf[i] = this[i + start];
        }
      }

      return newBuf
    };

    /*
     * Need to make sure that buffer isn't trying to write out of bounds.
     */
    function checkOffset (offset, ext, length) {
      if ((offset % 1) !== 0 || offset < 0) throw new RangeError('offset is not uint')
      if (offset + ext > length) throw new RangeError('Trying to access beyond buffer length')
    }

    Buffer$1.prototype.readUIntLE = function readUIntLE (offset, byteLength, noAssert) {
      offset = offset | 0;
      byteLength = byteLength | 0;
      if (!noAssert) checkOffset(offset, byteLength, this.length);

      var val = this[offset];
      var mul = 1;
      var i = 0;
      while (++i < byteLength && (mul *= 0x100)) {
        val += this[offset + i] * mul;
      }

      return val
    };

    Buffer$1.prototype.readUIntBE = function readUIntBE (offset, byteLength, noAssert) {
      offset = offset | 0;
      byteLength = byteLength | 0;
      if (!noAssert) {
        checkOffset(offset, byteLength, this.length);
      }

      var val = this[offset + --byteLength];
      var mul = 1;
      while (byteLength > 0 && (mul *= 0x100)) {
        val += this[offset + --byteLength] * mul;
      }

      return val
    };

    Buffer$1.prototype.readUInt8 = function readUInt8 (offset, noAssert) {
      if (!noAssert) checkOffset(offset, 1, this.length);
      return this[offset]
    };

    Buffer$1.prototype.readUInt16LE = function readUInt16LE (offset, noAssert) {
      if (!noAssert) checkOffset(offset, 2, this.length);
      return this[offset] | (this[offset + 1] << 8)
    };

    Buffer$1.prototype.readUInt16BE = function readUInt16BE (offset, noAssert) {
      if (!noAssert) checkOffset(offset, 2, this.length);
      return (this[offset] << 8) | this[offset + 1]
    };

    Buffer$1.prototype.readUInt32LE = function readUInt32LE (offset, noAssert) {
      if (!noAssert) checkOffset(offset, 4, this.length);

      return ((this[offset]) |
          (this[offset + 1] << 8) |
          (this[offset + 2] << 16)) +
          (this[offset + 3] * 0x1000000)
    };

    Buffer$1.prototype.readUInt32BE = function readUInt32BE (offset, noAssert) {
      if (!noAssert) checkOffset(offset, 4, this.length);

      return (this[offset] * 0x1000000) +
        ((this[offset + 1] << 16) |
        (this[offset + 2] << 8) |
        this[offset + 3])
    };

    Buffer$1.prototype.readIntLE = function readIntLE (offset, byteLength, noAssert) {
      offset = offset | 0;
      byteLength = byteLength | 0;
      if (!noAssert) checkOffset(offset, byteLength, this.length);

      var val = this[offset];
      var mul = 1;
      var i = 0;
      while (++i < byteLength && (mul *= 0x100)) {
        val += this[offset + i] * mul;
      }
      mul *= 0x80;

      if (val >= mul) val -= Math.pow(2, 8 * byteLength);

      return val
    };

    Buffer$1.prototype.readIntBE = function readIntBE (offset, byteLength, noAssert) {
      offset = offset | 0;
      byteLength = byteLength | 0;
      if (!noAssert) checkOffset(offset, byteLength, this.length);

      var i = byteLength;
      var mul = 1;
      var val = this[offset + --i];
      while (i > 0 && (mul *= 0x100)) {
        val += this[offset + --i] * mul;
      }
      mul *= 0x80;

      if (val >= mul) val -= Math.pow(2, 8 * byteLength);

      return val
    };

    Buffer$1.prototype.readInt8 = function readInt8 (offset, noAssert) {
      if (!noAssert) checkOffset(offset, 1, this.length);
      if (!(this[offset] & 0x80)) return (this[offset])
      return ((0xff - this[offset] + 1) * -1)
    };

    Buffer$1.prototype.readInt16LE = function readInt16LE (offset, noAssert) {
      if (!noAssert) checkOffset(offset, 2, this.length);
      var val = this[offset] | (this[offset + 1] << 8);
      return (val & 0x8000) ? val | 0xFFFF0000 : val
    };

    Buffer$1.prototype.readInt16BE = function readInt16BE (offset, noAssert) {
      if (!noAssert) checkOffset(offset, 2, this.length);
      var val = this[offset + 1] | (this[offset] << 8);
      return (val & 0x8000) ? val | 0xFFFF0000 : val
    };

    Buffer$1.prototype.readInt32LE = function readInt32LE (offset, noAssert) {
      if (!noAssert) checkOffset(offset, 4, this.length);

      return (this[offset]) |
        (this[offset + 1] << 8) |
        (this[offset + 2] << 16) |
        (this[offset + 3] << 24)
    };

    Buffer$1.prototype.readInt32BE = function readInt32BE (offset, noAssert) {
      if (!noAssert) checkOffset(offset, 4, this.length);

      return (this[offset] << 24) |
        (this[offset + 1] << 16) |
        (this[offset + 2] << 8) |
        (this[offset + 3])
    };

    Buffer$1.prototype.readFloatLE = function readFloatLE (offset, noAssert) {
      if (!noAssert) checkOffset(offset, 4, this.length);
      return read(this, offset, true, 23, 4)
    };

    Buffer$1.prototype.readFloatBE = function readFloatBE (offset, noAssert) {
      if (!noAssert) checkOffset(offset, 4, this.length);
      return read(this, offset, false, 23, 4)
    };

    Buffer$1.prototype.readDoubleLE = function readDoubleLE (offset, noAssert) {
      if (!noAssert) checkOffset(offset, 8, this.length);
      return read(this, offset, true, 52, 8)
    };

    Buffer$1.prototype.readDoubleBE = function readDoubleBE (offset, noAssert) {
      if (!noAssert) checkOffset(offset, 8, this.length);
      return read(this, offset, false, 52, 8)
    };

    function checkInt (buf, value, offset, ext, max, min) {
      if (!internalIsBuffer(buf)) throw new TypeError('"buffer" argument must be a Buffer instance')
      if (value > max || value < min) throw new RangeError('"value" argument is out of bounds')
      if (offset + ext > buf.length) throw new RangeError('Index out of range')
    }

    Buffer$1.prototype.writeUIntLE = function writeUIntLE (value, offset, byteLength, noAssert) {
      value = +value;
      offset = offset | 0;
      byteLength = byteLength | 0;
      if (!noAssert) {
        var maxBytes = Math.pow(2, 8 * byteLength) - 1;
        checkInt(this, value, offset, byteLength, maxBytes, 0);
      }

      var mul = 1;
      var i = 0;
      this[offset] = value & 0xFF;
      while (++i < byteLength && (mul *= 0x100)) {
        this[offset + i] = (value / mul) & 0xFF;
      }

      return offset + byteLength
    };

    Buffer$1.prototype.writeUIntBE = function writeUIntBE (value, offset, byteLength, noAssert) {
      value = +value;
      offset = offset | 0;
      byteLength = byteLength | 0;
      if (!noAssert) {
        var maxBytes = Math.pow(2, 8 * byteLength) - 1;
        checkInt(this, value, offset, byteLength, maxBytes, 0);
      }

      var i = byteLength - 1;
      var mul = 1;
      this[offset + i] = value & 0xFF;
      while (--i >= 0 && (mul *= 0x100)) {
        this[offset + i] = (value / mul) & 0xFF;
      }

      return offset + byteLength
    };

    Buffer$1.prototype.writeUInt8 = function writeUInt8 (value, offset, noAssert) {
      value = +value;
      offset = offset | 0;
      if (!noAssert) checkInt(this, value, offset, 1, 0xff, 0);
      if (!Buffer$1.TYPED_ARRAY_SUPPORT) value = Math.floor(value);
      this[offset] = (value & 0xff);
      return offset + 1
    };

    function objectWriteUInt16 (buf, value, offset, littleEndian) {
      if (value < 0) value = 0xffff + value + 1;
      for (var i = 0, j = Math.min(buf.length - offset, 2); i < j; ++i) {
        buf[offset + i] = (value & (0xff << (8 * (littleEndian ? i : 1 - i)))) >>>
          (littleEndian ? i : 1 - i) * 8;
      }
    }

    Buffer$1.prototype.writeUInt16LE = function writeUInt16LE (value, offset, noAssert) {
      value = +value;
      offset = offset | 0;
      if (!noAssert) checkInt(this, value, offset, 2, 0xffff, 0);
      if (Buffer$1.TYPED_ARRAY_SUPPORT) {
        this[offset] = (value & 0xff);
        this[offset + 1] = (value >>> 8);
      } else {
        objectWriteUInt16(this, value, offset, true);
      }
      return offset + 2
    };

    Buffer$1.prototype.writeUInt16BE = function writeUInt16BE (value, offset, noAssert) {
      value = +value;
      offset = offset | 0;
      if (!noAssert) checkInt(this, value, offset, 2, 0xffff, 0);
      if (Buffer$1.TYPED_ARRAY_SUPPORT) {
        this[offset] = (value >>> 8);
        this[offset + 1] = (value & 0xff);
      } else {
        objectWriteUInt16(this, value, offset, false);
      }
      return offset + 2
    };

    function objectWriteUInt32 (buf, value, offset, littleEndian) {
      if (value < 0) value = 0xffffffff + value + 1;
      for (var i = 0, j = Math.min(buf.length - offset, 4); i < j; ++i) {
        buf[offset + i] = (value >>> (littleEndian ? i : 3 - i) * 8) & 0xff;
      }
    }

    Buffer$1.prototype.writeUInt32LE = function writeUInt32LE (value, offset, noAssert) {
      value = +value;
      offset = offset | 0;
      if (!noAssert) checkInt(this, value, offset, 4, 0xffffffff, 0);
      if (Buffer$1.TYPED_ARRAY_SUPPORT) {
        this[offset + 3] = (value >>> 24);
        this[offset + 2] = (value >>> 16);
        this[offset + 1] = (value >>> 8);
        this[offset] = (value & 0xff);
      } else {
        objectWriteUInt32(this, value, offset, true);
      }
      return offset + 4
    };

    Buffer$1.prototype.writeUInt32BE = function writeUInt32BE (value, offset, noAssert) {
      value = +value;
      offset = offset | 0;
      if (!noAssert) checkInt(this, value, offset, 4, 0xffffffff, 0);
      if (Buffer$1.TYPED_ARRAY_SUPPORT) {
        this[offset] = (value >>> 24);
        this[offset + 1] = (value >>> 16);
        this[offset + 2] = (value >>> 8);
        this[offset + 3] = (value & 0xff);
      } else {
        objectWriteUInt32(this, value, offset, false);
      }
      return offset + 4
    };

    Buffer$1.prototype.writeIntLE = function writeIntLE (value, offset, byteLength, noAssert) {
      value = +value;
      offset = offset | 0;
      if (!noAssert) {
        var limit = Math.pow(2, 8 * byteLength - 1);

        checkInt(this, value, offset, byteLength, limit - 1, -limit);
      }

      var i = 0;
      var mul = 1;
      var sub = 0;
      this[offset] = value & 0xFF;
      while (++i < byteLength && (mul *= 0x100)) {
        if (value < 0 && sub === 0 && this[offset + i - 1] !== 0) {
          sub = 1;
        }
        this[offset + i] = ((value / mul) >> 0) - sub & 0xFF;
      }

      return offset + byteLength
    };

    Buffer$1.prototype.writeIntBE = function writeIntBE (value, offset, byteLength, noAssert) {
      value = +value;
      offset = offset | 0;
      if (!noAssert) {
        var limit = Math.pow(2, 8 * byteLength - 1);

        checkInt(this, value, offset, byteLength, limit - 1, -limit);
      }

      var i = byteLength - 1;
      var mul = 1;
      var sub = 0;
      this[offset + i] = value & 0xFF;
      while (--i >= 0 && (mul *= 0x100)) {
        if (value < 0 && sub === 0 && this[offset + i + 1] !== 0) {
          sub = 1;
        }
        this[offset + i] = ((value / mul) >> 0) - sub & 0xFF;
      }

      return offset + byteLength
    };

    Buffer$1.prototype.writeInt8 = function writeInt8 (value, offset, noAssert) {
      value = +value;
      offset = offset | 0;
      if (!noAssert) checkInt(this, value, offset, 1, 0x7f, -0x80);
      if (!Buffer$1.TYPED_ARRAY_SUPPORT) value = Math.floor(value);
      if (value < 0) value = 0xff + value + 1;
      this[offset] = (value & 0xff);
      return offset + 1
    };

    Buffer$1.prototype.writeInt16LE = function writeInt16LE (value, offset, noAssert) {
      value = +value;
      offset = offset | 0;
      if (!noAssert) checkInt(this, value, offset, 2, 0x7fff, -0x8000);
      if (Buffer$1.TYPED_ARRAY_SUPPORT) {
        this[offset] = (value & 0xff);
        this[offset + 1] = (value >>> 8);
      } else {
        objectWriteUInt16(this, value, offset, true);
      }
      return offset + 2
    };

    Buffer$1.prototype.writeInt16BE = function writeInt16BE (value, offset, noAssert) {
      value = +value;
      offset = offset | 0;
      if (!noAssert) checkInt(this, value, offset, 2, 0x7fff, -0x8000);
      if (Buffer$1.TYPED_ARRAY_SUPPORT) {
        this[offset] = (value >>> 8);
        this[offset + 1] = (value & 0xff);
      } else {
        objectWriteUInt16(this, value, offset, false);
      }
      return offset + 2
    };

    Buffer$1.prototype.writeInt32LE = function writeInt32LE (value, offset, noAssert) {
      value = +value;
      offset = offset | 0;
      if (!noAssert) checkInt(this, value, offset, 4, 0x7fffffff, -0x80000000);
      if (Buffer$1.TYPED_ARRAY_SUPPORT) {
        this[offset] = (value & 0xff);
        this[offset + 1] = (value >>> 8);
        this[offset + 2] = (value >>> 16);
        this[offset + 3] = (value >>> 24);
      } else {
        objectWriteUInt32(this, value, offset, true);
      }
      return offset + 4
    };

    Buffer$1.prototype.writeInt32BE = function writeInt32BE (value, offset, noAssert) {
      value = +value;
      offset = offset | 0;
      if (!noAssert) checkInt(this, value, offset, 4, 0x7fffffff, -0x80000000);
      if (value < 0) value = 0xffffffff + value + 1;
      if (Buffer$1.TYPED_ARRAY_SUPPORT) {
        this[offset] = (value >>> 24);
        this[offset + 1] = (value >>> 16);
        this[offset + 2] = (value >>> 8);
        this[offset + 3] = (value & 0xff);
      } else {
        objectWriteUInt32(this, value, offset, false);
      }
      return offset + 4
    };

    function checkIEEE754 (buf, value, offset, ext, max, min) {
      if (offset + ext > buf.length) throw new RangeError('Index out of range')
      if (offset < 0) throw new RangeError('Index out of range')
    }

    function writeFloat (buf, value, offset, littleEndian, noAssert) {
      if (!noAssert) {
        checkIEEE754(buf, value, offset, 4);
      }
      write(buf, value, offset, littleEndian, 23, 4);
      return offset + 4
    }

    Buffer$1.prototype.writeFloatLE = function writeFloatLE (value, offset, noAssert) {
      return writeFloat(this, value, offset, true, noAssert)
    };

    Buffer$1.prototype.writeFloatBE = function writeFloatBE (value, offset, noAssert) {
      return writeFloat(this, value, offset, false, noAssert)
    };

    function writeDouble (buf, value, offset, littleEndian, noAssert) {
      if (!noAssert) {
        checkIEEE754(buf, value, offset, 8);
      }
      write(buf, value, offset, littleEndian, 52, 8);
      return offset + 8
    }

    Buffer$1.prototype.writeDoubleLE = function writeDoubleLE (value, offset, noAssert) {
      return writeDouble(this, value, offset, true, noAssert)
    };

    Buffer$1.prototype.writeDoubleBE = function writeDoubleBE (value, offset, noAssert) {
      return writeDouble(this, value, offset, false, noAssert)
    };

    // copy(targetBuffer, targetStart=0, sourceStart=0, sourceEnd=buffer.length)
    Buffer$1.prototype.copy = function copy (target, targetStart, start, end) {
      if (!start) start = 0;
      if (!end && end !== 0) end = this.length;
      if (targetStart >= target.length) targetStart = target.length;
      if (!targetStart) targetStart = 0;
      if (end > 0 && end < start) end = start;

      // Copy 0 bytes; we're done
      if (end === start) return 0
      if (target.length === 0 || this.length === 0) return 0

      // Fatal error conditions
      if (targetStart < 0) {
        throw new RangeError('targetStart out of bounds')
      }
      if (start < 0 || start >= this.length) throw new RangeError('sourceStart out of bounds')
      if (end < 0) throw new RangeError('sourceEnd out of bounds')

      // Are we oob?
      if (end > this.length) end = this.length;
      if (target.length - targetStart < end - start) {
        end = target.length - targetStart + start;
      }

      var len = end - start;
      var i;

      if (this === target && start < targetStart && targetStart < end) {
        // descending copy from end
        for (i = len - 1; i >= 0; --i) {
          target[i + targetStart] = this[i + start];
        }
      } else if (len < 1000 || !Buffer$1.TYPED_ARRAY_SUPPORT) {
        // ascending copy from start
        for (i = 0; i < len; ++i) {
          target[i + targetStart] = this[i + start];
        }
      } else {
        Uint8Array.prototype.set.call(
          target,
          this.subarray(start, start + len),
          targetStart
        );
      }

      return len
    };

    // Usage:
    //    buffer.fill(number[, offset[, end]])
    //    buffer.fill(buffer[, offset[, end]])
    //    buffer.fill(string[, offset[, end]][, encoding])
    Buffer$1.prototype.fill = function fill (val, start, end, encoding) {
      // Handle string cases:
      if (typeof val === 'string') {
        if (typeof start === 'string') {
          encoding = start;
          start = 0;
          end = this.length;
        } else if (typeof end === 'string') {
          encoding = end;
          end = this.length;
        }
        if (val.length === 1) {
          var code = val.charCodeAt(0);
          if (code < 256) {
            val = code;
          }
        }
        if (encoding !== undefined && typeof encoding !== 'string') {
          throw new TypeError('encoding must be a string')
        }
        if (typeof encoding === 'string' && !Buffer$1.isEncoding(encoding)) {
          throw new TypeError('Unknown encoding: ' + encoding)
        }
      } else if (typeof val === 'number') {
        val = val & 255;
      }

      // Invalid ranges are not set to a default, so can range check early.
      if (start < 0 || this.length < start || this.length < end) {
        throw new RangeError('Out of range index')
      }

      if (end <= start) {
        return this
      }

      start = start >>> 0;
      end = end === undefined ? this.length : end >>> 0;

      if (!val) val = 0;

      var i;
      if (typeof val === 'number') {
        for (i = start; i < end; ++i) {
          this[i] = val;
        }
      } else {
        var bytes = internalIsBuffer(val)
          ? val
          : utf8ToBytes(new Buffer$1(val, encoding).toString());
        var len = bytes.length;
        for (i = 0; i < end - start; ++i) {
          this[i + start] = bytes[i % len];
        }
      }

      return this
    };

    // HELPER FUNCTIONS
    // ================

    var INVALID_BASE64_RE = /[^+\/0-9A-Za-z-_]/g;

    function base64clean (str) {
      // Node strips out invalid characters like \n and \t from the string, base64-js does not
      str = stringtrim(str).replace(INVALID_BASE64_RE, '');
      // Node converts strings with length < 2 to ''
      if (str.length < 2) return ''
      // Node allows for non-padded base64 strings (missing trailing ===), base64-js does not
      while (str.length % 4 !== 0) {
        str = str + '=';
      }
      return str
    }

    function stringtrim (str) {
      if (str.trim) return str.trim()
      return str.replace(/^\s+|\s+$/g, '')
    }

    function toHex (n) {
      if (n < 16) return '0' + n.toString(16)
      return n.toString(16)
    }

    function utf8ToBytes (string, units) {
      units = units || Infinity;
      var codePoint;
      var length = string.length;
      var leadSurrogate = null;
      var bytes = [];

      for (var i = 0; i < length; ++i) {
        codePoint = string.charCodeAt(i);

        // is surrogate component
        if (codePoint > 0xD7FF && codePoint < 0xE000) {
          // last char was a lead
          if (!leadSurrogate) {
            // no lead yet
            if (codePoint > 0xDBFF) {
              // unexpected trail
              if ((units -= 3) > -1) bytes.push(0xEF, 0xBF, 0xBD);
              continue
            } else if (i + 1 === length) {
              // unpaired lead
              if ((units -= 3) > -1) bytes.push(0xEF, 0xBF, 0xBD);
              continue
            }

            // valid lead
            leadSurrogate = codePoint;

            continue
          }

          // 2 leads in a row
          if (codePoint < 0xDC00) {
            if ((units -= 3) > -1) bytes.push(0xEF, 0xBF, 0xBD);
            leadSurrogate = codePoint;
            continue
          }

          // valid surrogate pair
          codePoint = (leadSurrogate - 0xD800 << 10 | codePoint - 0xDC00) + 0x10000;
        } else if (leadSurrogate) {
          // valid bmp char, but last char was a lead
          if ((units -= 3) > -1) bytes.push(0xEF, 0xBF, 0xBD);
        }

        leadSurrogate = null;

        // encode utf8
        if (codePoint < 0x80) {
          if ((units -= 1) < 0) break
          bytes.push(codePoint);
        } else if (codePoint < 0x800) {
          if ((units -= 2) < 0) break
          bytes.push(
            codePoint >> 0x6 | 0xC0,
            codePoint & 0x3F | 0x80
          );
        } else if (codePoint < 0x10000) {
          if ((units -= 3) < 0) break
          bytes.push(
            codePoint >> 0xC | 0xE0,
            codePoint >> 0x6 & 0x3F | 0x80,
            codePoint & 0x3F | 0x80
          );
        } else if (codePoint < 0x110000) {
          if ((units -= 4) < 0) break
          bytes.push(
            codePoint >> 0x12 | 0xF0,
            codePoint >> 0xC & 0x3F | 0x80,
            codePoint >> 0x6 & 0x3F | 0x80,
            codePoint & 0x3F | 0x80
          );
        } else {
          throw new Error('Invalid code point')
        }
      }

      return bytes
    }

    function asciiToBytes (str) {
      var byteArray = [];
      for (var i = 0; i < str.length; ++i) {
        // Node's code seems to be doing this and not & 0x7F..
        byteArray.push(str.charCodeAt(i) & 0xFF);
      }
      return byteArray
    }

    function utf16leToBytes (str, units) {
      var c, hi, lo;
      var byteArray = [];
      for (var i = 0; i < str.length; ++i) {
        if ((units -= 2) < 0) break

        c = str.charCodeAt(i);
        hi = c >> 8;
        lo = c % 256;
        byteArray.push(lo);
        byteArray.push(hi);
      }

      return byteArray
    }


    function base64ToBytes (str) {
      return toByteArray(base64clean(str))
    }

    function blitBuffer (src, dst, offset, length) {
      for (var i = 0; i < length; ++i) {
        if ((i + offset >= dst.length) || (i >= src.length)) break
        dst[i + offset] = src[i];
      }
      return i
    }

    function isnan (val) {
      return val !== val // eslint-disable-line no-self-compare
    }


    // the following is from is-buffer, also by Feross Aboukhadijeh and with same lisence
    // The _isBuffer check is for Safari 5-7 support, because it's missing
    // Object.prototype.constructor. Remove this eventually
    function isBuffer$1(obj) {
      return obj != null && (!!obj._isBuffer || isFastBuffer(obj) || isSlowBuffer(obj))
    }

    function isFastBuffer (obj) {
      return !!obj.constructor && typeof obj.constructor.isBuffer === 'function' && obj.constructor.isBuffer(obj)
    }

    // For Node v0.10 support. Remove this eventually.
    function isSlowBuffer (obj) {
      return typeof obj.readFloatLE === 'function' && typeof obj.slice === 'function' && isFastBuffer(obj.slice(0, 0))
    }

    var bufferEs6 = /*#__PURE__*/Object.freeze({
        __proto__: null,
        INSPECT_MAX_BYTES: INSPECT_MAX_BYTES,
        kMaxLength: _kMaxLength,
        Buffer: Buffer$1,
        SlowBuffer: SlowBuffer,
        isBuffer: isBuffer$1
    });

    function BufferList() {
      this.head = null;
      this.tail = null;
      this.length = 0;
    }

    BufferList.prototype.push = function (v) {
      var entry = { data: v, next: null };
      if (this.length > 0) this.tail.next = entry;else this.head = entry;
      this.tail = entry;
      ++this.length;
    };

    BufferList.prototype.unshift = function (v) {
      var entry = { data: v, next: this.head };
      if (this.length === 0) this.tail = entry;
      this.head = entry;
      ++this.length;
    };

    BufferList.prototype.shift = function () {
      if (this.length === 0) return;
      var ret = this.head.data;
      if (this.length === 1) this.head = this.tail = null;else this.head = this.head.next;
      --this.length;
      return ret;
    };

    BufferList.prototype.clear = function () {
      this.head = this.tail = null;
      this.length = 0;
    };

    BufferList.prototype.join = function (s) {
      if (this.length === 0) return '';
      var p = this.head;
      var ret = '' + p.data;
      while (p = p.next) {
        ret += s + p.data;
      }return ret;
    };

    BufferList.prototype.concat = function (n) {
      if (this.length === 0) return Buffer$1.alloc(0);
      if (this.length === 1) return this.head.data;
      var ret = Buffer$1.allocUnsafe(n >>> 0);
      var p = this.head;
      var i = 0;
      while (p) {
        p.data.copy(ret, i);
        i += p.data.length;
        p = p.next;
      }
      return ret;
    };

    // Copyright Joyent, Inc. and other Node contributors.
    var isBufferEncoding = Buffer$1.isEncoding
      || function(encoding) {
           switch (encoding && encoding.toLowerCase()) {
             case 'hex': case 'utf8': case 'utf-8': case 'ascii': case 'binary': case 'base64': case 'ucs2': case 'ucs-2': case 'utf16le': case 'utf-16le': case 'raw': return true;
             default: return false;
           }
         };


    function assertEncoding(encoding) {
      if (encoding && !isBufferEncoding(encoding)) {
        throw new Error('Unknown encoding: ' + encoding);
      }
    }

    // StringDecoder provides an interface for efficiently splitting a series of
    // buffers into a series of JS strings without breaking apart multi-byte
    // characters. CESU-8 is handled as part of the UTF-8 encoding.
    //
    // @TODO Handling all encodings inside a single object makes it very difficult
    // to reason about this code, so it should be split up in the future.
    // @TODO There should be a utf8-strict encoding that rejects invalid UTF-8 code
    // points as used by CESU-8.
    function StringDecoder(encoding) {
      this.encoding = (encoding || 'utf8').toLowerCase().replace(/[-_]/, '');
      assertEncoding(encoding);
      switch (this.encoding) {
        case 'utf8':
          // CESU-8 represents each of Surrogate Pair by 3-bytes
          this.surrogateSize = 3;
          break;
        case 'ucs2':
        case 'utf16le':
          // UTF-16 represents each of Surrogate Pair by 2-bytes
          this.surrogateSize = 2;
          this.detectIncompleteChar = utf16DetectIncompleteChar;
          break;
        case 'base64':
          // Base-64 stores 3 bytes in 4 chars, and pads the remainder.
          this.surrogateSize = 3;
          this.detectIncompleteChar = base64DetectIncompleteChar;
          break;
        default:
          this.write = passThroughWrite;
          return;
      }

      // Enough space to store all bytes of a single character. UTF-8 needs 4
      // bytes, but CESU-8 may require up to 6 (3 bytes per surrogate).
      this.charBuffer = new Buffer$1(6);
      // Number of bytes received for the current incomplete multi-byte character.
      this.charReceived = 0;
      // Number of bytes expected for the current incomplete multi-byte character.
      this.charLength = 0;
    }

    // write decodes the given buffer and returns it as JS string that is
    // guaranteed to not contain any partial multi-byte characters. Any partial
    // character found at the end of the buffer is buffered up, and will be
    // returned when calling write again with the remaining bytes.
    //
    // Note: Converting a Buffer containing an orphan surrogate to a String
    // currently works, but converting a String to a Buffer (via `new Buffer`, or
    // Buffer#write) will replace incomplete surrogates with the unicode
    // replacement character. See https://codereview.chromium.org/121173009/ .
    StringDecoder.prototype.write = function(buffer) {
      var charStr = '';
      // if our last write ended with an incomplete multibyte character
      while (this.charLength) {
        // determine how many remaining bytes this buffer has to offer for this char
        var available = (buffer.length >= this.charLength - this.charReceived) ?
            this.charLength - this.charReceived :
            buffer.length;

        // add the new bytes to the char buffer
        buffer.copy(this.charBuffer, this.charReceived, 0, available);
        this.charReceived += available;

        if (this.charReceived < this.charLength) {
          // still not enough chars in this buffer? wait for more ...
          return '';
        }

        // remove bytes belonging to the current character from the buffer
        buffer = buffer.slice(available, buffer.length);

        // get the character that was split
        charStr = this.charBuffer.slice(0, this.charLength).toString(this.encoding);

        // CESU-8: lead surrogate (D800-DBFF) is also the incomplete character
        var charCode = charStr.charCodeAt(charStr.length - 1);
        if (charCode >= 0xD800 && charCode <= 0xDBFF) {
          this.charLength += this.surrogateSize;
          charStr = '';
          continue;
        }
        this.charReceived = this.charLength = 0;

        // if there are no more bytes in this buffer, just emit our char
        if (buffer.length === 0) {
          return charStr;
        }
        break;
      }

      // determine and set charLength / charReceived
      this.detectIncompleteChar(buffer);

      var end = buffer.length;
      if (this.charLength) {
        // buffer the incomplete character bytes we got
        buffer.copy(this.charBuffer, 0, buffer.length - this.charReceived, end);
        end -= this.charReceived;
      }

      charStr += buffer.toString(this.encoding, 0, end);

      var end = charStr.length - 1;
      var charCode = charStr.charCodeAt(end);
      // CESU-8: lead surrogate (D800-DBFF) is also the incomplete character
      if (charCode >= 0xD800 && charCode <= 0xDBFF) {
        var size = this.surrogateSize;
        this.charLength += size;
        this.charReceived += size;
        this.charBuffer.copy(this.charBuffer, size, 0, size);
        buffer.copy(this.charBuffer, 0, 0, size);
        return charStr.substring(0, end);
      }

      // or just emit the charStr
      return charStr;
    };

    // detectIncompleteChar determines if there is an incomplete UTF-8 character at
    // the end of the given buffer. If so, it sets this.charLength to the byte
    // length that character, and sets this.charReceived to the number of bytes
    // that are available for this character.
    StringDecoder.prototype.detectIncompleteChar = function(buffer) {
      // determine how many bytes we have to check at the end of this buffer
      var i = (buffer.length >= 3) ? 3 : buffer.length;

      // Figure out if one of the last i bytes of our buffer announces an
      // incomplete char.
      for (; i > 0; i--) {
        var c = buffer[buffer.length - i];

        // See http://en.wikipedia.org/wiki/UTF-8#Description

        // 110XXXXX
        if (i == 1 && c >> 5 == 0x06) {
          this.charLength = 2;
          break;
        }

        // 1110XXXX
        if (i <= 2 && c >> 4 == 0x0E) {
          this.charLength = 3;
          break;
        }

        // 11110XXX
        if (i <= 3 && c >> 3 == 0x1E) {
          this.charLength = 4;
          break;
        }
      }
      this.charReceived = i;
    };

    StringDecoder.prototype.end = function(buffer) {
      var res = '';
      if (buffer && buffer.length)
        res = this.write(buffer);

      if (this.charReceived) {
        var cr = this.charReceived;
        var buf = this.charBuffer;
        var enc = this.encoding;
        res += buf.slice(0, cr).toString(enc);
      }

      return res;
    };

    function passThroughWrite(buffer) {
      return buffer.toString(this.encoding);
    }

    function utf16DetectIncompleteChar(buffer) {
      this.charReceived = buffer.length % 2;
      this.charLength = this.charReceived ? 2 : 0;
    }

    function base64DetectIncompleteChar(buffer) {
      this.charReceived = buffer.length % 3;
      this.charLength = this.charReceived ? 3 : 0;
    }

    var stringDecoder = /*#__PURE__*/Object.freeze({
        __proto__: null,
        StringDecoder: StringDecoder
    });

    Readable.ReadableState = ReadableState;

    var debug = debuglog('stream');
    inherits$1(Readable, EventEmitter);

    function prependListener(emitter, event, fn) {
      // Sadly this is not cacheable as some libraries bundle their own
      // event emitter implementation with them.
      if (typeof emitter.prependListener === 'function') {
        return emitter.prependListener(event, fn);
      } else {
        // This is a hack to make sure that our error handler is attached before any
        // userland ones.  NEVER DO THIS. This is here only because this code needs
        // to continue to work with older versions of Node.js that do not include
        // the prependListener() method. The goal is to eventually remove this hack.
        if (!emitter._events || !emitter._events[event])
          emitter.on(event, fn);
        else if (Array.isArray(emitter._events[event]))
          emitter._events[event].unshift(fn);
        else
          emitter._events[event] = [fn, emitter._events[event]];
      }
    }
    function listenerCount$1 (emitter, type) {
      return emitter.listeners(type).length;
    }
    function ReadableState(options, stream) {

      options = options || {};

      // object stream flag. Used to make read(n) ignore n and to
      // make all the buffer merging and length checks go away
      this.objectMode = !!options.objectMode;

      if (stream instanceof Duplex) this.objectMode = this.objectMode || !!options.readableObjectMode;

      // the point at which it stops calling _read() to fill the buffer
      // Note: 0 is a valid value, means "don't call _read preemptively ever"
      var hwm = options.highWaterMark;
      var defaultHwm = this.objectMode ? 16 : 16 * 1024;
      this.highWaterMark = hwm || hwm === 0 ? hwm : defaultHwm;

      // cast to ints.
      this.highWaterMark = ~ ~this.highWaterMark;

      // A linked list is used to store data chunks instead of an array because the
      // linked list can remove elements from the beginning faster than
      // array.shift()
      this.buffer = new BufferList();
      this.length = 0;
      this.pipes = null;
      this.pipesCount = 0;
      this.flowing = null;
      this.ended = false;
      this.endEmitted = false;
      this.reading = false;

      // a flag to be able to tell if the onwrite cb is called immediately,
      // or on a later tick.  We set this to true at first, because any
      // actions that shouldn't happen until "later" should generally also
      // not happen before the first write call.
      this.sync = true;

      // whenever we return null, then we set a flag to say
      // that we're awaiting a 'readable' event emission.
      this.needReadable = false;
      this.emittedReadable = false;
      this.readableListening = false;
      this.resumeScheduled = false;

      // Crypto is kind of old and crusty.  Historically, its default string
      // encoding is 'binary' so we have to make this configurable.
      // Everything else in the universe uses 'utf8', though.
      this.defaultEncoding = options.defaultEncoding || 'utf8';

      // when piping, we only care about 'readable' events that happen
      // after read()ing all the bytes and not getting any pushback.
      this.ranOut = false;

      // the number of writers that are awaiting a drain event in .pipe()s
      this.awaitDrain = 0;

      // if true, a maybeReadMore has been scheduled
      this.readingMore = false;

      this.decoder = null;
      this.encoding = null;
      if (options.encoding) {
        this.decoder = new StringDecoder(options.encoding);
        this.encoding = options.encoding;
      }
    }
    function Readable(options) {

      if (!(this instanceof Readable)) return new Readable(options);

      this._readableState = new ReadableState(options, this);

      // legacy
      this.readable = true;

      if (options && typeof options.read === 'function') this._read = options.read;

      EventEmitter.call(this);
    }

    // Manually shove something into the read() buffer.
    // This returns true if the highWaterMark has not been hit yet,
    // similar to how Writable.write() returns true if you should
    // write() some more.
    Readable.prototype.push = function (chunk, encoding) {
      var state = this._readableState;

      if (!state.objectMode && typeof chunk === 'string') {
        encoding = encoding || state.defaultEncoding;
        if (encoding !== state.encoding) {
          chunk = Buffer.from(chunk, encoding);
          encoding = '';
        }
      }

      return readableAddChunk(this, state, chunk, encoding, false);
    };

    // Unshift should *always* be something directly out of read()
    Readable.prototype.unshift = function (chunk) {
      var state = this._readableState;
      return readableAddChunk(this, state, chunk, '', true);
    };

    Readable.prototype.isPaused = function () {
      return this._readableState.flowing === false;
    };

    function readableAddChunk(stream, state, chunk, encoding, addToFront) {
      var er = chunkInvalid(state, chunk);
      if (er) {
        stream.emit('error', er);
      } else if (chunk === null) {
        state.reading = false;
        onEofChunk(stream, state);
      } else if (state.objectMode || chunk && chunk.length > 0) {
        if (state.ended && !addToFront) {
          var e = new Error('stream.push() after EOF');
          stream.emit('error', e);
        } else if (state.endEmitted && addToFront) {
          var _e = new Error('stream.unshift() after end event');
          stream.emit('error', _e);
        } else {
          var skipAdd;
          if (state.decoder && !addToFront && !encoding) {
            chunk = state.decoder.write(chunk);
            skipAdd = !state.objectMode && chunk.length === 0;
          }

          if (!addToFront) state.reading = false;

          // Don't add to the buffer if we've decoded to an empty string chunk and
          // we're not in object mode
          if (!skipAdd) {
            // if we want the data now, just emit it.
            if (state.flowing && state.length === 0 && !state.sync) {
              stream.emit('data', chunk);
              stream.read(0);
            } else {
              // update the buffer info.
              state.length += state.objectMode ? 1 : chunk.length;
              if (addToFront) state.buffer.unshift(chunk);else state.buffer.push(chunk);

              if (state.needReadable) emitReadable(stream);
            }
          }

          maybeReadMore(stream, state);
        }
      } else if (!addToFront) {
        state.reading = false;
      }

      return needMoreData(state);
    }

    // if it's past the high water mark, we can push in some more.
    // Also, if we have no data yet, we can stand some
    // more bytes.  This is to work around cases where hwm=0,
    // such as the repl.  Also, if the push() triggered a
    // readable event, and the user called read(largeNumber) such that
    // needReadable was set, then we ought to push more, so that another
    // 'readable' event will be triggered.
    function needMoreData(state) {
      return !state.ended && (state.needReadable || state.length < state.highWaterMark || state.length === 0);
    }

    // backwards compatibility.
    Readable.prototype.setEncoding = function (enc) {
      this._readableState.decoder = new StringDecoder(enc);
      this._readableState.encoding = enc;
      return this;
    };

    // Don't raise the hwm > 8MB
    var MAX_HWM = 0x800000;
    function computeNewHighWaterMark(n) {
      if (n >= MAX_HWM) {
        n = MAX_HWM;
      } else {
        // Get the next highest power of 2 to prevent increasing hwm excessively in
        // tiny amounts
        n--;
        n |= n >>> 1;
        n |= n >>> 2;
        n |= n >>> 4;
        n |= n >>> 8;
        n |= n >>> 16;
        n++;
      }
      return n;
    }

    // This function is designed to be inlinable, so please take care when making
    // changes to the function body.
    function howMuchToRead(n, state) {
      if (n <= 0 || state.length === 0 && state.ended) return 0;
      if (state.objectMode) return 1;
      if (n !== n) {
        // Only flow one buffer at a time
        if (state.flowing && state.length) return state.buffer.head.data.length;else return state.length;
      }
      // If we're asking for more than the current hwm, then raise the hwm.
      if (n > state.highWaterMark) state.highWaterMark = computeNewHighWaterMark(n);
      if (n <= state.length) return n;
      // Don't have enough
      if (!state.ended) {
        state.needReadable = true;
        return 0;
      }
      return state.length;
    }

    // you can override either this method, or the async _read(n) below.
    Readable.prototype.read = function (n) {
      debug('read', n);
      n = parseInt(n, 10);
      var state = this._readableState;
      var nOrig = n;

      if (n !== 0) state.emittedReadable = false;

      // if we're doing read(0) to trigger a readable event, but we
      // already have a bunch of data in the buffer, then just trigger
      // the 'readable' event and move on.
      if (n === 0 && state.needReadable && (state.length >= state.highWaterMark || state.ended)) {
        debug('read: emitReadable', state.length, state.ended);
        if (state.length === 0 && state.ended) endReadable(this);else emitReadable(this);
        return null;
      }

      n = howMuchToRead(n, state);

      // if we've ended, and we're now clear, then finish it up.
      if (n === 0 && state.ended) {
        if (state.length === 0) endReadable(this);
        return null;
      }

      // All the actual chunk generation logic needs to be
      // *below* the call to _read.  The reason is that in certain
      // synthetic stream cases, such as passthrough streams, _read
      // may be a completely synchronous operation which may change
      // the state of the read buffer, providing enough data when
      // before there was *not* enough.
      //
      // So, the steps are:
      // 1. Figure out what the state of things will be after we do
      // a read from the buffer.
      //
      // 2. If that resulting state will trigger a _read, then call _read.
      // Note that this may be asynchronous, or synchronous.  Yes, it is
      // deeply ugly to write APIs this way, but that still doesn't mean
      // that the Readable class should behave improperly, as streams are
      // designed to be sync/async agnostic.
      // Take note if the _read call is sync or async (ie, if the read call
      // has returned yet), so that we know whether or not it's safe to emit
      // 'readable' etc.
      //
      // 3. Actually pull the requested chunks out of the buffer and return.

      // if we need a readable event, then we need to do some reading.
      var doRead = state.needReadable;
      debug('need readable', doRead);

      // if we currently have less than the highWaterMark, then also read some
      if (state.length === 0 || state.length - n < state.highWaterMark) {
        doRead = true;
        debug('length less than watermark', doRead);
      }

      // however, if we've ended, then there's no point, and if we're already
      // reading, then it's unnecessary.
      if (state.ended || state.reading) {
        doRead = false;
        debug('reading or ended', doRead);
      } else if (doRead) {
        debug('do read');
        state.reading = true;
        state.sync = true;
        // if the length is currently zero, then we *need* a readable event.
        if (state.length === 0) state.needReadable = true;
        // call internal read method
        this._read(state.highWaterMark);
        state.sync = false;
        // If _read pushed data synchronously, then `reading` will be false,
        // and we need to re-evaluate how much data we can return to the user.
        if (!state.reading) n = howMuchToRead(nOrig, state);
      }

      var ret;
      if (n > 0) ret = fromList(n, state);else ret = null;

      if (ret === null) {
        state.needReadable = true;
        n = 0;
      } else {
        state.length -= n;
      }

      if (state.length === 0) {
        // If we have nothing in the buffer, then we want to know
        // as soon as we *do* get something into the buffer.
        if (!state.ended) state.needReadable = true;

        // If we tried to read() past the EOF, then emit end on the next tick.
        if (nOrig !== n && state.ended) endReadable(this);
      }

      if (ret !== null) this.emit('data', ret);

      return ret;
    };

    function chunkInvalid(state, chunk) {
      var er = null;
      if (!Buffer.isBuffer(chunk) && typeof chunk !== 'string' && chunk !== null && chunk !== undefined && !state.objectMode) {
        er = new TypeError('Invalid non-string/buffer chunk');
      }
      return er;
    }

    function onEofChunk(stream, state) {
      if (state.ended) return;
      if (state.decoder) {
        var chunk = state.decoder.end();
        if (chunk && chunk.length) {
          state.buffer.push(chunk);
          state.length += state.objectMode ? 1 : chunk.length;
        }
      }
      state.ended = true;

      // emit 'readable' now to make sure it gets picked up.
      emitReadable(stream);
    }

    // Don't emit readable right away in sync mode, because this can trigger
    // another read() call => stack overflow.  This way, it might trigger
    // a nextTick recursion warning, but that's not so bad.
    function emitReadable(stream) {
      var state = stream._readableState;
      state.needReadable = false;
      if (!state.emittedReadable) {
        debug('emitReadable', state.flowing);
        state.emittedReadable = true;
        if (state.sync) nextTick(emitReadable_, stream);else emitReadable_(stream);
      }
    }

    function emitReadable_(stream) {
      debug('emit readable');
      stream.emit('readable');
      flow(stream);
    }

    // at this point, the user has presumably seen the 'readable' event,
    // and called read() to consume some data.  that may have triggered
    // in turn another _read(n) call, in which case reading = true if
    // it's in progress.
    // However, if we're not ended, or reading, and the length < hwm,
    // then go ahead and try to read some more preemptively.
    function maybeReadMore(stream, state) {
      if (!state.readingMore) {
        state.readingMore = true;
        nextTick(maybeReadMore_, stream, state);
      }
    }

    function maybeReadMore_(stream, state) {
      var len = state.length;
      while (!state.reading && !state.flowing && !state.ended && state.length < state.highWaterMark) {
        debug('maybeReadMore read 0');
        stream.read(0);
        if (len === state.length)
          // didn't get any data, stop spinning.
          break;else len = state.length;
      }
      state.readingMore = false;
    }

    // abstract method.  to be overridden in specific implementation classes.
    // call cb(er, data) where data is <= n in length.
    // for virtual (non-string, non-buffer) streams, "length" is somewhat
    // arbitrary, and perhaps not very meaningful.
    Readable.prototype._read = function (n) {
      this.emit('error', new Error('not implemented'));
    };

    Readable.prototype.pipe = function (dest, pipeOpts) {
      var src = this;
      var state = this._readableState;

      switch (state.pipesCount) {
        case 0:
          state.pipes = dest;
          break;
        case 1:
          state.pipes = [state.pipes, dest];
          break;
        default:
          state.pipes.push(dest);
          break;
      }
      state.pipesCount += 1;
      debug('pipe count=%d opts=%j', state.pipesCount, pipeOpts);

      var doEnd = (!pipeOpts || pipeOpts.end !== false);

      var endFn = doEnd ? onend : cleanup;
      if (state.endEmitted) nextTick(endFn);else src.once('end', endFn);

      dest.on('unpipe', onunpipe);
      function onunpipe(readable) {
        debug('onunpipe');
        if (readable === src) {
          cleanup();
        }
      }

      function onend() {
        debug('onend');
        dest.end();
      }

      // when the dest drains, it reduces the awaitDrain counter
      // on the source.  This would be more elegant with a .once()
      // handler in flow(), but adding and removing repeatedly is
      // too slow.
      var ondrain = pipeOnDrain(src);
      dest.on('drain', ondrain);

      var cleanedUp = false;
      function cleanup() {
        debug('cleanup');
        // cleanup event handlers once the pipe is broken
        dest.removeListener('close', onclose);
        dest.removeListener('finish', onfinish);
        dest.removeListener('drain', ondrain);
        dest.removeListener('error', onerror);
        dest.removeListener('unpipe', onunpipe);
        src.removeListener('end', onend);
        src.removeListener('end', cleanup);
        src.removeListener('data', ondata);

        cleanedUp = true;

        // if the reader is waiting for a drain event from this
        // specific writer, then it would cause it to never start
        // flowing again.
        // So, if this is awaiting a drain, then we just call it now.
        // If we don't know, then assume that we are waiting for one.
        if (state.awaitDrain && (!dest._writableState || dest._writableState.needDrain)) ondrain();
      }

      // If the user pushes more data while we're writing to dest then we'll end up
      // in ondata again. However, we only want to increase awaitDrain once because
      // dest will only emit one 'drain' event for the multiple writes.
      // => Introduce a guard on increasing awaitDrain.
      var increasedAwaitDrain = false;
      src.on('data', ondata);
      function ondata(chunk) {
        debug('ondata');
        increasedAwaitDrain = false;
        var ret = dest.write(chunk);
        if (false === ret && !increasedAwaitDrain) {
          // If the user unpiped during `dest.write()`, it is possible
          // to get stuck in a permanently paused state if that write
          // also returned false.
          // => Check whether `dest` is still a piping destination.
          if ((state.pipesCount === 1 && state.pipes === dest || state.pipesCount > 1 && indexOf(state.pipes, dest) !== -1) && !cleanedUp) {
            debug('false write response, pause', src._readableState.awaitDrain);
            src._readableState.awaitDrain++;
            increasedAwaitDrain = true;
          }
          src.pause();
        }
      }

      // if the dest has an error, then stop piping into it.
      // however, don't suppress the throwing behavior for this.
      function onerror(er) {
        debug('onerror', er);
        unpipe();
        dest.removeListener('error', onerror);
        if (listenerCount$1(dest, 'error') === 0) dest.emit('error', er);
      }

      // Make sure our error handler is attached before userland ones.
      prependListener(dest, 'error', onerror);

      // Both close and finish should trigger unpipe, but only once.
      function onclose() {
        dest.removeListener('finish', onfinish);
        unpipe();
      }
      dest.once('close', onclose);
      function onfinish() {
        debug('onfinish');
        dest.removeListener('close', onclose);
        unpipe();
      }
      dest.once('finish', onfinish);

      function unpipe() {
        debug('unpipe');
        src.unpipe(dest);
      }

      // tell the dest that it's being piped to
      dest.emit('pipe', src);

      // start the flow if it hasn't been started already.
      if (!state.flowing) {
        debug('pipe resume');
        src.resume();
      }

      return dest;
    };

    function pipeOnDrain(src) {
      return function () {
        var state = src._readableState;
        debug('pipeOnDrain', state.awaitDrain);
        if (state.awaitDrain) state.awaitDrain--;
        if (state.awaitDrain === 0 && src.listeners('data').length) {
          state.flowing = true;
          flow(src);
        }
      };
    }

    Readable.prototype.unpipe = function (dest) {
      var state = this._readableState;

      // if we're not piping anywhere, then do nothing.
      if (state.pipesCount === 0) return this;

      // just one destination.  most common case.
      if (state.pipesCount === 1) {
        // passed in one, but it's not the right one.
        if (dest && dest !== state.pipes) return this;

        if (!dest) dest = state.pipes;

        // got a match.
        state.pipes = null;
        state.pipesCount = 0;
        state.flowing = false;
        if (dest) dest.emit('unpipe', this);
        return this;
      }

      // slow case. multiple pipe destinations.

      if (!dest) {
        // remove all.
        var dests = state.pipes;
        var len = state.pipesCount;
        state.pipes = null;
        state.pipesCount = 0;
        state.flowing = false;

        for (var _i = 0; _i < len; _i++) {
          dests[_i].emit('unpipe', this);
        }return this;
      }

      // try to find the right one.
      var i = indexOf(state.pipes, dest);
      if (i === -1) return this;

      state.pipes.splice(i, 1);
      state.pipesCount -= 1;
      if (state.pipesCount === 1) state.pipes = state.pipes[0];

      dest.emit('unpipe', this);

      return this;
    };

    // set up data events if they are asked for
    // Ensure readable listeners eventually get something
    Readable.prototype.on = function (ev, fn) {
      var res = EventEmitter.prototype.on.call(this, ev, fn);

      if (ev === 'data') {
        // Start flowing on next tick if stream isn't explicitly paused
        if (this._readableState.flowing !== false) this.resume();
      } else if (ev === 'readable') {
        var state = this._readableState;
        if (!state.endEmitted && !state.readableListening) {
          state.readableListening = state.needReadable = true;
          state.emittedReadable = false;
          if (!state.reading) {
            nextTick(nReadingNextTick, this);
          } else if (state.length) {
            emitReadable(this);
          }
        }
      }

      return res;
    };
    Readable.prototype.addListener = Readable.prototype.on;

    function nReadingNextTick(self) {
      debug('readable nexttick read 0');
      self.read(0);
    }

    // pause() and resume() are remnants of the legacy readable stream API
    // If the user uses them, then switch into old mode.
    Readable.prototype.resume = function () {
      var state = this._readableState;
      if (!state.flowing) {
        debug('resume');
        state.flowing = true;
        resume(this, state);
      }
      return this;
    };

    function resume(stream, state) {
      if (!state.resumeScheduled) {
        state.resumeScheduled = true;
        nextTick(resume_, stream, state);
      }
    }

    function resume_(stream, state) {
      if (!state.reading) {
        debug('resume read 0');
        stream.read(0);
      }

      state.resumeScheduled = false;
      state.awaitDrain = 0;
      stream.emit('resume');
      flow(stream);
      if (state.flowing && !state.reading) stream.read(0);
    }

    Readable.prototype.pause = function () {
      debug('call pause flowing=%j', this._readableState.flowing);
      if (false !== this._readableState.flowing) {
        debug('pause');
        this._readableState.flowing = false;
        this.emit('pause');
      }
      return this;
    };

    function flow(stream) {
      var state = stream._readableState;
      debug('flow', state.flowing);
      while (state.flowing && stream.read() !== null) {}
    }

    // wrap an old-style stream as the async data source.
    // This is *not* part of the readable stream interface.
    // It is an ugly unfortunate mess of history.
    Readable.prototype.wrap = function (stream) {
      var state = this._readableState;
      var paused = false;

      var self = this;
      stream.on('end', function () {
        debug('wrapped end');
        if (state.decoder && !state.ended) {
          var chunk = state.decoder.end();
          if (chunk && chunk.length) self.push(chunk);
        }

        self.push(null);
      });

      stream.on('data', function (chunk) {
        debug('wrapped data');
        if (state.decoder) chunk = state.decoder.write(chunk);

        // don't skip over falsy values in objectMode
        if (state.objectMode && (chunk === null || chunk === undefined)) return;else if (!state.objectMode && (!chunk || !chunk.length)) return;

        var ret = self.push(chunk);
        if (!ret) {
          paused = true;
          stream.pause();
        }
      });

      // proxy all the other methods.
      // important when wrapping filters and duplexes.
      for (var i in stream) {
        if (this[i] === undefined && typeof stream[i] === 'function') {
          this[i] = function (method) {
            return function () {
              return stream[method].apply(stream, arguments);
            };
          }(i);
        }
      }

      // proxy certain important events.
      var events = ['error', 'close', 'destroy', 'pause', 'resume'];
      forEach(events, function (ev) {
        stream.on(ev, self.emit.bind(self, ev));
      });

      // when we try to consume some more bytes, simply unpause the
      // underlying stream.
      self._read = function (n) {
        debug('wrapped _read', n);
        if (paused) {
          paused = false;
          stream.resume();
        }
      };

      return self;
    };

    // exposed for testing purposes only.
    Readable._fromList = fromList;

    // Pluck off n bytes from an array of buffers.
    // Length is the combined lengths of all the buffers in the list.
    // This function is designed to be inlinable, so please take care when making
    // changes to the function body.
    function fromList(n, state) {
      // nothing buffered
      if (state.length === 0) return null;

      var ret;
      if (state.objectMode) ret = state.buffer.shift();else if (!n || n >= state.length) {
        // read it all, truncate the list
        if (state.decoder) ret = state.buffer.join('');else if (state.buffer.length === 1) ret = state.buffer.head.data;else ret = state.buffer.concat(state.length);
        state.buffer.clear();
      } else {
        // read part of list
        ret = fromListPartial(n, state.buffer, state.decoder);
      }

      return ret;
    }

    // Extracts only enough buffered data to satisfy the amount requested.
    // This function is designed to be inlinable, so please take care when making
    // changes to the function body.
    function fromListPartial(n, list, hasStrings) {
      var ret;
      if (n < list.head.data.length) {
        // slice is the same for buffers and strings
        ret = list.head.data.slice(0, n);
        list.head.data = list.head.data.slice(n);
      } else if (n === list.head.data.length) {
        // first chunk is a perfect match
        ret = list.shift();
      } else {
        // result spans more than one buffer
        ret = hasStrings ? copyFromBufferString(n, list) : copyFromBuffer(n, list);
      }
      return ret;
    }

    // Copies a specified amount of characters from the list of buffered data
    // chunks.
    // This function is designed to be inlinable, so please take care when making
    // changes to the function body.
    function copyFromBufferString(n, list) {
      var p = list.head;
      var c = 1;
      var ret = p.data;
      n -= ret.length;
      while (p = p.next) {
        var str = p.data;
        var nb = n > str.length ? str.length : n;
        if (nb === str.length) ret += str;else ret += str.slice(0, n);
        n -= nb;
        if (n === 0) {
          if (nb === str.length) {
            ++c;
            if (p.next) list.head = p.next;else list.head = list.tail = null;
          } else {
            list.head = p;
            p.data = str.slice(nb);
          }
          break;
        }
        ++c;
      }
      list.length -= c;
      return ret;
    }

    // Copies a specified amount of bytes from the list of buffered data chunks.
    // This function is designed to be inlinable, so please take care when making
    // changes to the function body.
    function copyFromBuffer(n, list) {
      var ret = Buffer.allocUnsafe(n);
      var p = list.head;
      var c = 1;
      p.data.copy(ret);
      n -= p.data.length;
      while (p = p.next) {
        var buf = p.data;
        var nb = n > buf.length ? buf.length : n;
        buf.copy(ret, ret.length - n, 0, nb);
        n -= nb;
        if (n === 0) {
          if (nb === buf.length) {
            ++c;
            if (p.next) list.head = p.next;else list.head = list.tail = null;
          } else {
            list.head = p;
            p.data = buf.slice(nb);
          }
          break;
        }
        ++c;
      }
      list.length -= c;
      return ret;
    }

    function endReadable(stream) {
      var state = stream._readableState;

      // If we get here before consuming all the bytes, then that is a
      // bug in node.  Should never happen.
      if (state.length > 0) throw new Error('"endReadable()" called on non-empty stream');

      if (!state.endEmitted) {
        state.ended = true;
        nextTick(endReadableNT, state, stream);
      }
    }

    function endReadableNT(state, stream) {
      // Check that we didn't get one last unshift.
      if (!state.endEmitted && state.length === 0) {
        state.endEmitted = true;
        stream.readable = false;
        stream.emit('end');
      }
    }

    function forEach(xs, f) {
      for (var i = 0, l = xs.length; i < l; i++) {
        f(xs[i], i);
      }
    }

    function indexOf(xs, x) {
      for (var i = 0, l = xs.length; i < l; i++) {
        if (xs[i] === x) return i;
      }
      return -1;
    }

    // A bit simpler than readable streams.
    Writable.WritableState = WritableState;
    inherits$1(Writable, EventEmitter);

    function nop() {}

    function WriteReq(chunk, encoding, cb) {
      this.chunk = chunk;
      this.encoding = encoding;
      this.callback = cb;
      this.next = null;
    }

    function WritableState(options, stream) {
      Object.defineProperty(this, 'buffer', {
        get: deprecate(function () {
          return this.getBuffer();
        }, '_writableState.buffer is deprecated. Use _writableState.getBuffer ' + 'instead.')
      });
      options = options || {};

      // object stream flag to indicate whether or not this stream
      // contains buffers or objects.
      this.objectMode = !!options.objectMode;

      if (stream instanceof Duplex) this.objectMode = this.objectMode || !!options.writableObjectMode;

      // the point at which write() starts returning false
      // Note: 0 is a valid value, means that we always return false if
      // the entire buffer is not flushed immediately on write()
      var hwm = options.highWaterMark;
      var defaultHwm = this.objectMode ? 16 : 16 * 1024;
      this.highWaterMark = hwm || hwm === 0 ? hwm : defaultHwm;

      // cast to ints.
      this.highWaterMark = ~ ~this.highWaterMark;

      this.needDrain = false;
      // at the start of calling end()
      this.ending = false;
      // when end() has been called, and returned
      this.ended = false;
      // when 'finish' is emitted
      this.finished = false;

      // should we decode strings into buffers before passing to _write?
      // this is here so that some node-core streams can optimize string
      // handling at a lower level.
      var noDecode = options.decodeStrings === false;
      this.decodeStrings = !noDecode;

      // Crypto is kind of old and crusty.  Historically, its default string
      // encoding is 'binary' so we have to make this configurable.
      // Everything else in the universe uses 'utf8', though.
      this.defaultEncoding = options.defaultEncoding || 'utf8';

      // not an actual buffer we keep track of, but a measurement
      // of how much we're waiting to get pushed to some underlying
      // socket or file.
      this.length = 0;

      // a flag to see when we're in the middle of a write.
      this.writing = false;

      // when true all writes will be buffered until .uncork() call
      this.corked = 0;

      // a flag to be able to tell if the onwrite cb is called immediately,
      // or on a later tick.  We set this to true at first, because any
      // actions that shouldn't happen until "later" should generally also
      // not happen before the first write call.
      this.sync = true;

      // a flag to know if we're processing previously buffered items, which
      // may call the _write() callback in the same tick, so that we don't
      // end up in an overlapped onwrite situation.
      this.bufferProcessing = false;

      // the callback that's passed to _write(chunk,cb)
      this.onwrite = function (er) {
        onwrite(stream, er);
      };

      // the callback that the user supplies to write(chunk,encoding,cb)
      this.writecb = null;

      // the amount that is being written when _write is called.
      this.writelen = 0;

      this.bufferedRequest = null;
      this.lastBufferedRequest = null;

      // number of pending user-supplied write callbacks
      // this must be 0 before 'finish' can be emitted
      this.pendingcb = 0;

      // emit prefinish if the only thing we're waiting for is _write cbs
      // This is relevant for synchronous Transform streams
      this.prefinished = false;

      // True if the error was already emitted and should not be thrown again
      this.errorEmitted = false;

      // count buffered requests
      this.bufferedRequestCount = 0;

      // allocate the first CorkedRequest, there is always
      // one allocated and free to use, and we maintain at most two
      this.corkedRequestsFree = new CorkedRequest(this);
    }

    WritableState.prototype.getBuffer = function writableStateGetBuffer() {
      var current = this.bufferedRequest;
      var out = [];
      while (current) {
        out.push(current);
        current = current.next;
      }
      return out;
    };
    function Writable(options) {

      // Writable ctor is applied to Duplexes, though they're not
      // instanceof Writable, they're instanceof Readable.
      if (!(this instanceof Writable) && !(this instanceof Duplex)) return new Writable(options);

      this._writableState = new WritableState(options, this);

      // legacy.
      this.writable = true;

      if (options) {
        if (typeof options.write === 'function') this._write = options.write;

        if (typeof options.writev === 'function') this._writev = options.writev;
      }

      EventEmitter.call(this);
    }

    // Otherwise people can pipe Writable streams, which is just wrong.
    Writable.prototype.pipe = function () {
      this.emit('error', new Error('Cannot pipe, not readable'));
    };

    function writeAfterEnd(stream, cb) {
      var er = new Error('write after end');
      // TODO: defer error events consistently everywhere, not just the cb
      stream.emit('error', er);
      nextTick(cb, er);
    }

    // If we get something that is not a buffer, string, null, or undefined,
    // and we're not in objectMode, then that's an error.
    // Otherwise stream chunks are all considered to be of length=1, and the
    // watermarks determine how many objects to keep in the buffer, rather than
    // how many bytes or characters.
    function validChunk(stream, state, chunk, cb) {
      var valid = true;
      var er = false;
      // Always throw error if a null is written
      // if we are not in object mode then throw
      // if it is not a buffer, string, or undefined.
      if (chunk === null) {
        er = new TypeError('May not write null values to stream');
      } else if (!Buffer$1.isBuffer(chunk) && typeof chunk !== 'string' && chunk !== undefined && !state.objectMode) {
        er = new TypeError('Invalid non-string/buffer chunk');
      }
      if (er) {
        stream.emit('error', er);
        nextTick(cb, er);
        valid = false;
      }
      return valid;
    }

    Writable.prototype.write = function (chunk, encoding, cb) {
      var state = this._writableState;
      var ret = false;

      if (typeof encoding === 'function') {
        cb = encoding;
        encoding = null;
      }

      if (Buffer$1.isBuffer(chunk)) encoding = 'buffer';else if (!encoding) encoding = state.defaultEncoding;

      if (typeof cb !== 'function') cb = nop;

      if (state.ended) writeAfterEnd(this, cb);else if (validChunk(this, state, chunk, cb)) {
        state.pendingcb++;
        ret = writeOrBuffer(this, state, chunk, encoding, cb);
      }

      return ret;
    };

    Writable.prototype.cork = function () {
      var state = this._writableState;

      state.corked++;
    };

    Writable.prototype.uncork = function () {
      var state = this._writableState;

      if (state.corked) {
        state.corked--;

        if (!state.writing && !state.corked && !state.finished && !state.bufferProcessing && state.bufferedRequest) clearBuffer(this, state);
      }
    };

    Writable.prototype.setDefaultEncoding = function setDefaultEncoding(encoding) {
      // node::ParseEncoding() requires lower case.
      if (typeof encoding === 'string') encoding = encoding.toLowerCase();
      if (!(['hex', 'utf8', 'utf-8', 'ascii', 'binary', 'base64', 'ucs2', 'ucs-2', 'utf16le', 'utf-16le', 'raw'].indexOf((encoding + '').toLowerCase()) > -1)) throw new TypeError('Unknown encoding: ' + encoding);
      this._writableState.defaultEncoding = encoding;
      return this;
    };

    function decodeChunk(state, chunk, encoding) {
      if (!state.objectMode && state.decodeStrings !== false && typeof chunk === 'string') {
        chunk = Buffer$1.from(chunk, encoding);
      }
      return chunk;
    }

    // if we're already writing something, then just put this
    // in the queue, and wait our turn.  Otherwise, call _write
    // If we return false, then we need a drain event, so set that flag.
    function writeOrBuffer(stream, state, chunk, encoding, cb) {
      chunk = decodeChunk(state, chunk, encoding);

      if (Buffer$1.isBuffer(chunk)) encoding = 'buffer';
      var len = state.objectMode ? 1 : chunk.length;

      state.length += len;

      var ret = state.length < state.highWaterMark;
      // we must ensure that previous needDrain will not be reset to false.
      if (!ret) state.needDrain = true;

      if (state.writing || state.corked) {
        var last = state.lastBufferedRequest;
        state.lastBufferedRequest = new WriteReq(chunk, encoding, cb);
        if (last) {
          last.next = state.lastBufferedRequest;
        } else {
          state.bufferedRequest = state.lastBufferedRequest;
        }
        state.bufferedRequestCount += 1;
      } else {
        doWrite(stream, state, false, len, chunk, encoding, cb);
      }

      return ret;
    }

    function doWrite(stream, state, writev, len, chunk, encoding, cb) {
      state.writelen = len;
      state.writecb = cb;
      state.writing = true;
      state.sync = true;
      if (writev) stream._writev(chunk, state.onwrite);else stream._write(chunk, encoding, state.onwrite);
      state.sync = false;
    }

    function onwriteError(stream, state, sync, er, cb) {
      --state.pendingcb;
      if (sync) nextTick(cb, er);else cb(er);

      stream._writableState.errorEmitted = true;
      stream.emit('error', er);
    }

    function onwriteStateUpdate(state) {
      state.writing = false;
      state.writecb = null;
      state.length -= state.writelen;
      state.writelen = 0;
    }

    function onwrite(stream, er) {
      var state = stream._writableState;
      var sync = state.sync;
      var cb = state.writecb;

      onwriteStateUpdate(state);

      if (er) onwriteError(stream, state, sync, er, cb);else {
        // Check if we're actually ready to finish, but don't emit yet
        var finished = needFinish(state);

        if (!finished && !state.corked && !state.bufferProcessing && state.bufferedRequest) {
          clearBuffer(stream, state);
        }

        if (sync) {
          /*<replacement>*/
            nextTick(afterWrite, stream, state, finished, cb);
          /*</replacement>*/
        } else {
            afterWrite(stream, state, finished, cb);
          }
      }
    }

    function afterWrite(stream, state, finished, cb) {
      if (!finished) onwriteDrain(stream, state);
      state.pendingcb--;
      cb();
      finishMaybe(stream, state);
    }

    // Must force callback to be called on nextTick, so that we don't
    // emit 'drain' before the write() consumer gets the 'false' return
    // value, and has a chance to attach a 'drain' listener.
    function onwriteDrain(stream, state) {
      if (state.length === 0 && state.needDrain) {
        state.needDrain = false;
        stream.emit('drain');
      }
    }

    // if there's something in the buffer waiting, then process it
    function clearBuffer(stream, state) {
      state.bufferProcessing = true;
      var entry = state.bufferedRequest;

      if (stream._writev && entry && entry.next) {
        // Fast case, write everything using _writev()
        var l = state.bufferedRequestCount;
        var buffer = new Array(l);
        var holder = state.corkedRequestsFree;
        holder.entry = entry;

        var count = 0;
        while (entry) {
          buffer[count] = entry;
          entry = entry.next;
          count += 1;
        }

        doWrite(stream, state, true, state.length, buffer, '', holder.finish);

        // doWrite is almost always async, defer these to save a bit of time
        // as the hot path ends with doWrite
        state.pendingcb++;
        state.lastBufferedRequest = null;
        if (holder.next) {
          state.corkedRequestsFree = holder.next;
          holder.next = null;
        } else {
          state.corkedRequestsFree = new CorkedRequest(state);
        }
      } else {
        // Slow case, write chunks one-by-one
        while (entry) {
          var chunk = entry.chunk;
          var encoding = entry.encoding;
          var cb = entry.callback;
          var len = state.objectMode ? 1 : chunk.length;

          doWrite(stream, state, false, len, chunk, encoding, cb);
          entry = entry.next;
          // if we didn't call the onwrite immediately, then
          // it means that we need to wait until it does.
          // also, that means that the chunk and cb are currently
          // being processed, so move the buffer counter past them.
          if (state.writing) {
            break;
          }
        }

        if (entry === null) state.lastBufferedRequest = null;
      }

      state.bufferedRequestCount = 0;
      state.bufferedRequest = entry;
      state.bufferProcessing = false;
    }

    Writable.prototype._write = function (chunk, encoding, cb) {
      cb(new Error('not implemented'));
    };

    Writable.prototype._writev = null;

    Writable.prototype.end = function (chunk, encoding, cb) {
      var state = this._writableState;

      if (typeof chunk === 'function') {
        cb = chunk;
        chunk = null;
        encoding = null;
      } else if (typeof encoding === 'function') {
        cb = encoding;
        encoding = null;
      }

      if (chunk !== null && chunk !== undefined) this.write(chunk, encoding);

      // .end() fully uncorks
      if (state.corked) {
        state.corked = 1;
        this.uncork();
      }

      // ignore unnecessary end() calls.
      if (!state.ending && !state.finished) endWritable(this, state, cb);
    };

    function needFinish(state) {
      return state.ending && state.length === 0 && state.bufferedRequest === null && !state.finished && !state.writing;
    }

    function prefinish(stream, state) {
      if (!state.prefinished) {
        state.prefinished = true;
        stream.emit('prefinish');
      }
    }

    function finishMaybe(stream, state) {
      var need = needFinish(state);
      if (need) {
        if (state.pendingcb === 0) {
          prefinish(stream, state);
          state.finished = true;
          stream.emit('finish');
        } else {
          prefinish(stream, state);
        }
      }
      return need;
    }

    function endWritable(stream, state, cb) {
      state.ending = true;
      finishMaybe(stream, state);
      if (cb) {
        if (state.finished) nextTick(cb);else stream.once('finish', cb);
      }
      state.ended = true;
      stream.writable = false;
    }

    // It seems a linked list but it is not
    // there will be only 2 of these for each stream
    function CorkedRequest(state) {
      var _this = this;

      this.next = null;
      this.entry = null;

      this.finish = function (err) {
        var entry = _this.entry;
        _this.entry = null;
        while (entry) {
          var cb = entry.callback;
          state.pendingcb--;
          cb(err);
          entry = entry.next;
        }
        if (state.corkedRequestsFree) {
          state.corkedRequestsFree.next = _this;
        } else {
          state.corkedRequestsFree = _this;
        }
      };
    }

    inherits$1(Duplex, Readable);

    var keys = Object.keys(Writable.prototype);
    for (var v = 0; v < keys.length; v++) {
      var method = keys[v];
      if (!Duplex.prototype[method]) Duplex.prototype[method] = Writable.prototype[method];
    }
    function Duplex(options) {
      if (!(this instanceof Duplex)) return new Duplex(options);

      Readable.call(this, options);
      Writable.call(this, options);

      if (options && options.readable === false) this.readable = false;

      if (options && options.writable === false) this.writable = false;

      this.allowHalfOpen = true;
      if (options && options.allowHalfOpen === false) this.allowHalfOpen = false;

      this.once('end', onend);
    }

    // the no-half-open enforcer
    function onend() {
      // if we allow half-open state, or if the writable side ended,
      // then we're ok.
      if (this.allowHalfOpen || this._writableState.ended) return;

      // no more data can be written.
      // But allow more writes to happen in this tick.
      nextTick(onEndNT, this);
    }

    function onEndNT(self) {
      self.end();
    }

    // a transform stream is a readable/writable stream where you do
    inherits$1(Transform, Duplex);

    function TransformState(stream) {
      this.afterTransform = function (er, data) {
        return afterTransform(stream, er, data);
      };

      this.needTransform = false;
      this.transforming = false;
      this.writecb = null;
      this.writechunk = null;
      this.writeencoding = null;
    }

    function afterTransform(stream, er, data) {
      var ts = stream._transformState;
      ts.transforming = false;

      var cb = ts.writecb;

      if (!cb) return stream.emit('error', new Error('no writecb in Transform class'));

      ts.writechunk = null;
      ts.writecb = null;

      if (data !== null && data !== undefined) stream.push(data);

      cb(er);

      var rs = stream._readableState;
      rs.reading = false;
      if (rs.needReadable || rs.length < rs.highWaterMark) {
        stream._read(rs.highWaterMark);
      }
    }
    function Transform(options) {
      if (!(this instanceof Transform)) return new Transform(options);

      Duplex.call(this, options);

      this._transformState = new TransformState(this);

      // when the writable side finishes, then flush out anything remaining.
      var stream = this;

      // start out asking for a readable event once data is transformed.
      this._readableState.needReadable = true;

      // we have implemented the _read method, and done the other things
      // that Readable wants before the first _read call, so unset the
      // sync guard flag.
      this._readableState.sync = false;

      if (options) {
        if (typeof options.transform === 'function') this._transform = options.transform;

        if (typeof options.flush === 'function') this._flush = options.flush;
      }

      this.once('prefinish', function () {
        if (typeof this._flush === 'function') this._flush(function (er) {
          done(stream, er);
        });else done(stream);
      });
    }

    Transform.prototype.push = function (chunk, encoding) {
      this._transformState.needTransform = false;
      return Duplex.prototype.push.call(this, chunk, encoding);
    };

    // This is the part where you do stuff!
    // override this function in implementation classes.
    // 'chunk' is an input chunk.
    //
    // Call `push(newChunk)` to pass along transformed output
    // to the readable side.  You may call 'push' zero or more times.
    //
    // Call `cb(err)` when you are done with this chunk.  If you pass
    // an error, then that'll put the hurt on the whole operation.  If you
    // never call cb(), then you'll never get another chunk.
    Transform.prototype._transform = function (chunk, encoding, cb) {
      throw new Error('Not implemented');
    };

    Transform.prototype._write = function (chunk, encoding, cb) {
      var ts = this._transformState;
      ts.writecb = cb;
      ts.writechunk = chunk;
      ts.writeencoding = encoding;
      if (!ts.transforming) {
        var rs = this._readableState;
        if (ts.needTransform || rs.needReadable || rs.length < rs.highWaterMark) this._read(rs.highWaterMark);
      }
    };

    // Doesn't matter what the args are here.
    // _transform does all the work.
    // That we got here means that the readable side wants more data.
    Transform.prototype._read = function (n) {
      var ts = this._transformState;

      if (ts.writechunk !== null && ts.writecb && !ts.transforming) {
        ts.transforming = true;
        this._transform(ts.writechunk, ts.writeencoding, ts.afterTransform);
      } else {
        // mark that we need a transform, so that any data that comes in
        // will get processed, now that we've asked for it.
        ts.needTransform = true;
      }
    };

    function done(stream, er) {
      if (er) return stream.emit('error', er);

      // if there's nothing in the write buffer, then that means
      // that nothing more will ever be provided
      var ws = stream._writableState;
      var ts = stream._transformState;

      if (ws.length) throw new Error('Calling transform done when ws.length != 0');

      if (ts.transforming) throw new Error('Calling transform done when still transforming');

      return stream.push(null);
    }

    inherits$1(PassThrough, Transform);
    function PassThrough(options) {
      if (!(this instanceof PassThrough)) return new PassThrough(options);

      Transform.call(this, options);
    }

    PassThrough.prototype._transform = function (chunk, encoding, cb) {
      cb(null, chunk);
    };

    inherits$1(Stream, EventEmitter);
    Stream.Readable = Readable;
    Stream.Writable = Writable;
    Stream.Duplex = Duplex;
    Stream.Transform = Transform;
    Stream.PassThrough = PassThrough;

    // Backwards-compat with node 0.4.x
    Stream.Stream = Stream;

    // old-style streams.  Note that the pipe method (the only relevant
    // part of this class) is overridden in the Readable class.

    function Stream() {
      EventEmitter.call(this);
    }

    Stream.prototype.pipe = function(dest, options) {
      var source = this;

      function ondata(chunk) {
        if (dest.writable) {
          if (false === dest.write(chunk) && source.pause) {
            source.pause();
          }
        }
      }

      source.on('data', ondata);

      function ondrain() {
        if (source.readable && source.resume) {
          source.resume();
        }
      }

      dest.on('drain', ondrain);

      // If the 'end' option is not supplied, dest.end() will be called when
      // source gets the 'end' or 'close' events.  Only dest.end() once.
      if (!dest._isStdio && (!options || options.end !== false)) {
        source.on('end', onend);
        source.on('close', onclose);
      }

      var didOnEnd = false;
      function onend() {
        if (didOnEnd) return;
        didOnEnd = true;

        dest.end();
      }


      function onclose() {
        if (didOnEnd) return;
        didOnEnd = true;

        if (typeof dest.destroy === 'function') dest.destroy();
      }

      // don't leave dangling pipes when there are errors.
      function onerror(er) {
        cleanup();
        if (EventEmitter.listenerCount(this, 'error') === 0) {
          throw er; // Unhandled stream error in pipe.
        }
      }

      source.on('error', onerror);
      dest.on('error', onerror);

      // remove all the event listeners that were added.
      function cleanup() {
        source.removeListener('data', ondata);
        dest.removeListener('drain', ondrain);

        source.removeListener('end', onend);
        source.removeListener('close', onclose);

        source.removeListener('error', onerror);
        dest.removeListener('error', onerror);

        source.removeListener('end', cleanup);
        source.removeListener('close', cleanup);

        dest.removeListener('close', cleanup);
      }

      source.on('end', cleanup);
      source.on('close', cleanup);

      dest.on('close', cleanup);

      dest.emit('pipe', source);

      // Allow for unix-like usage: A.pipe(B).pipe(C)
      return dest;
    };

    var processNextickArgs = createCommonjsModule(function (module) {

    if (typeof process === 'undefined' ||
        !process.version ||
        process.version.indexOf('v0.') === 0 ||
        process.version.indexOf('v1.') === 0 && process.version.indexOf('v1.8.') !== 0) {
      module.exports = { nextTick: nextTick };
    } else {
      module.exports = process;
    }

    function nextTick(fn, arg1, arg2, arg3) {
      if (typeof fn !== 'function') {
        throw new TypeError('"callback" argument must be a function');
      }
      var len = arguments.length;
      var args, i;
      switch (len) {
      case 0:
      case 1:
        return process.nextTick(fn);
      case 2:
        return process.nextTick(function afterTickOne() {
          fn.call(null, arg1);
        });
      case 3:
        return process.nextTick(function afterTickTwo() {
          fn.call(null, arg1, arg2);
        });
      case 4:
        return process.nextTick(function afterTickThree() {
          fn.call(null, arg1, arg2, arg3);
        });
      default:
        args = new Array(len - 1);
        i = 0;
        while (i < args.length) {
          args[i++] = arguments[i];
        }
        return process.nextTick(function afterTick() {
          fn.apply(null, args);
        });
      }
    }
    });
    var processNextickArgs_1 = processNextickArgs.nextTick;

    var toString$1 = {}.toString;

    var isarray = Array.isArray || function (arr) {
      return toString$1.call(arr) == '[object Array]';
    };

    var stream = Stream;

    var safeBuffer = createCommonjsModule(function (module, exports) {
    /* eslint-disable node/no-deprecated-api */

    var Buffer = bufferEs6.Buffer;

    // alternative to using Object.keys for old browsers
    function copyProps (src, dst) {
      for (var key in src) {
        dst[key] = src[key];
      }
    }
    if (Buffer.from && Buffer.alloc && Buffer.allocUnsafe && Buffer.allocUnsafeSlow) {
      module.exports = bufferEs6;
    } else {
      // Copy properties from require('buffer')
      copyProps(bufferEs6, exports);
      exports.Buffer = SafeBuffer;
    }

    function SafeBuffer (arg, encodingOrOffset, length) {
      return Buffer(arg, encodingOrOffset, length)
    }

    // Copy static methods from Buffer
    copyProps(Buffer, SafeBuffer);

    SafeBuffer.from = function (arg, encodingOrOffset, length) {
      if (typeof arg === 'number') {
        throw new TypeError('Argument must not be a number')
      }
      return Buffer(arg, encodingOrOffset, length)
    };

    SafeBuffer.alloc = function (size, fill, encoding) {
      if (typeof size !== 'number') {
        throw new TypeError('Argument must be a number')
      }
      var buf = Buffer(size);
      if (fill !== undefined) {
        if (typeof encoding === 'string') {
          buf.fill(fill, encoding);
        } else {
          buf.fill(fill);
        }
      } else {
        buf.fill(0);
      }
      return buf
    };

    SafeBuffer.allocUnsafe = function (size) {
      if (typeof size !== 'number') {
        throw new TypeError('Argument must be a number')
      }
      return Buffer(size)
    };

    SafeBuffer.allocUnsafeSlow = function (size) {
      if (typeof size !== 'number') {
        throw new TypeError('Argument must be a number')
      }
      return bufferEs6.SlowBuffer(size)
    };
    });
    var safeBuffer_1 = safeBuffer.Buffer;

    // Copyright Joyent, Inc. and other Node contributors.
    //
    // Permission is hereby granted, free of charge, to any person obtaining a
    // copy of this software and associated documentation files (the
    // "Software"), to deal in the Software without restriction, including
    // without limitation the rights to use, copy, modify, merge, publish,
    // distribute, sublicense, and/or sell copies of the Software, and to permit
    // persons to whom the Software is furnished to do so, subject to the
    // following conditions:
    //
    // The above copyright notice and this permission notice shall be included
    // in all copies or substantial portions of the Software.
    //
    // THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
    // OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
    // MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN
    // NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
    // DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
    // OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
    // USE OR OTHER DEALINGS IN THE SOFTWARE.

    // NOTE: These type checking functions intentionally don't use `instanceof`
    // because it is fragile and can be easily faked with `Object.create()`.

    function isArray$4(arg) {
      if (Array.isArray) {
        return Array.isArray(arg);
      }
      return objectToString$1(arg) === '[object Array]';
    }
    var isArray_1$1 = isArray$4;

    function isBoolean$1(arg) {
      return typeof arg === 'boolean';
    }
    var isBoolean_1 = isBoolean$1;

    function isNull$1(arg) {
      return arg === null;
    }
    var isNull_1 = isNull$1;

    function isNullOrUndefined$1(arg) {
      return arg == null;
    }
    var isNullOrUndefined_1 = isNullOrUndefined$1;

    function isNumber$1(arg) {
      return typeof arg === 'number';
    }
    var isNumber_1 = isNumber$1;

    function isString$1(arg) {
      return typeof arg === 'string';
    }
    var isString_1 = isString$1;

    function isSymbol$1(arg) {
      return typeof arg === 'symbol';
    }
    var isSymbol_1 = isSymbol$1;

    function isUndefined$1(arg) {
      return arg === void 0;
    }
    var isUndefined_1 = isUndefined$1;

    function isRegExp$1(re) {
      return objectToString$1(re) === '[object RegExp]';
    }
    var isRegExp_1 = isRegExp$1;

    function isObject$2(arg) {
      return typeof arg === 'object' && arg !== null;
    }
    var isObject_1$1 = isObject$2;

    function isDate$1(d) {
      return objectToString$1(d) === '[object Date]';
    }
    var isDate_1 = isDate$1;

    function isError$1(e) {
      return (objectToString$1(e) === '[object Error]' || e instanceof Error);
    }
    var isError_1 = isError$1;

    function isFunction$2(arg) {
      return typeof arg === 'function';
    }
    var isFunction_1$1 = isFunction$2;

    function isPrimitive$1(arg) {
      return arg === null ||
             typeof arg === 'boolean' ||
             typeof arg === 'number' ||
             typeof arg === 'string' ||
             typeof arg === 'symbol' ||  // ES6 symbol
             typeof arg === 'undefined';
    }
    var isPrimitive_1 = isPrimitive$1;

    var isBuffer$2 = Buffer.isBuffer;

    function objectToString$1(o) {
      return Object.prototype.toString.call(o);
    }

    var util = {
    	isArray: isArray_1$1,
    	isBoolean: isBoolean_1,
    	isNull: isNull_1,
    	isNullOrUndefined: isNullOrUndefined_1,
    	isNumber: isNumber_1,
    	isString: isString_1,
    	isSymbol: isSymbol_1,
    	isUndefined: isUndefined_1,
    	isRegExp: isRegExp_1,
    	isObject: isObject_1$1,
    	isDate: isDate_1,
    	isError: isError_1,
    	isFunction: isFunction_1$1,
    	isPrimitive: isPrimitive_1,
    	isBuffer: isBuffer$2
    };

    var inherits_browser = createCommonjsModule(function (module) {
    if (typeof Object.create === 'function') {
      // implementation from standard node.js 'util' module
      module.exports = function inherits(ctor, superCtor) {
        if (superCtor) {
          ctor.super_ = superCtor;
          ctor.prototype = Object.create(superCtor.prototype, {
            constructor: {
              value: ctor,
              enumerable: false,
              writable: true,
              configurable: true
            }
          });
        }
      };
    } else {
      // old school shim for old browsers
      module.exports = function inherits(ctor, superCtor) {
        if (superCtor) {
          ctor.super_ = superCtor;
          var TempCtor = function () {};
          TempCtor.prototype = superCtor.prototype;
          ctor.prototype = new TempCtor();
          ctor.prototype.constructor = ctor;
        }
      };
    }
    });

    var inherits$2 = createCommonjsModule(function (module) {
    try {
      var util = debugUtil;
      /* istanbul ignore next */
      if (typeof util.inherits !== 'function') throw '';
      module.exports = util.inherits;
    } catch (e) {
      /* istanbul ignore next */
      module.exports = inherits_browser;
    }
    });

    var BufferList$1 = createCommonjsModule(function (module) {

    function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

    var Buffer = safeBuffer.Buffer;


    function copyBuffer(src, target, offset) {
      src.copy(target, offset);
    }

    module.exports = function () {
      function BufferList() {
        _classCallCheck(this, BufferList);

        this.head = null;
        this.tail = null;
        this.length = 0;
      }

      BufferList.prototype.push = function push(v) {
        var entry = { data: v, next: null };
        if (this.length > 0) this.tail.next = entry;else this.head = entry;
        this.tail = entry;
        ++this.length;
      };

      BufferList.prototype.unshift = function unshift(v) {
        var entry = { data: v, next: this.head };
        if (this.length === 0) this.tail = entry;
        this.head = entry;
        ++this.length;
      };

      BufferList.prototype.shift = function shift() {
        if (this.length === 0) return;
        var ret = this.head.data;
        if (this.length === 1) this.head = this.tail = null;else this.head = this.head.next;
        --this.length;
        return ret;
      };

      BufferList.prototype.clear = function clear() {
        this.head = this.tail = null;
        this.length = 0;
      };

      BufferList.prototype.join = function join(s) {
        if (this.length === 0) return '';
        var p = this.head;
        var ret = '' + p.data;
        while (p = p.next) {
          ret += s + p.data;
        }return ret;
      };

      BufferList.prototype.concat = function concat(n) {
        if (this.length === 0) return Buffer.alloc(0);
        if (this.length === 1) return this.head.data;
        var ret = Buffer.allocUnsafe(n >>> 0);
        var p = this.head;
        var i = 0;
        while (p) {
          copyBuffer(p.data, ret, i);
          i += p.data.length;
          p = p.next;
        }
        return ret;
      };

      return BufferList;
    }();

    if (debugUtil && debugUtil.inspect && debugUtil.inspect.custom) {
      module.exports.prototype[debugUtil.inspect.custom] = function () {
        var obj = debugUtil.inspect({ length: this.length });
        return this.constructor.name + ' ' + obj;
      };
    }
    });

    /*<replacement>*/


    /*</replacement>*/

    // undocumented cb() API, needed for core, not for public API
    function destroy(err, cb) {
      var _this = this;

      var readableDestroyed = this._readableState && this._readableState.destroyed;
      var writableDestroyed = this._writableState && this._writableState.destroyed;

      if (readableDestroyed || writableDestroyed) {
        if (cb) {
          cb(err);
        } else if (err && (!this._writableState || !this._writableState.errorEmitted)) {
          processNextickArgs.nextTick(emitErrorNT, this, err);
        }
        return this;
      }

      // we set destroyed to true before firing error callbacks in order
      // to make it re-entrance safe in case destroy() is called within callbacks

      if (this._readableState) {
        this._readableState.destroyed = true;
      }

      // if this is a duplex stream mark the writable part as destroyed as well
      if (this._writableState) {
        this._writableState.destroyed = true;
      }

      this._destroy(err || null, function (err) {
        if (!cb && err) {
          processNextickArgs.nextTick(emitErrorNT, _this, err);
          if (_this._writableState) {
            _this._writableState.errorEmitted = true;
          }
        } else if (cb) {
          cb(err);
        }
      });

      return this;
    }

    function undestroy() {
      if (this._readableState) {
        this._readableState.destroyed = false;
        this._readableState.reading = false;
        this._readableState.ended = false;
        this._readableState.endEmitted = false;
      }

      if (this._writableState) {
        this._writableState.destroyed = false;
        this._writableState.ended = false;
        this._writableState.ending = false;
        this._writableState.finished = false;
        this._writableState.errorEmitted = false;
      }
    }

    function emitErrorNT(self, err) {
      self.emit('error', err);
    }

    var destroy_1 = {
      destroy: destroy,
      undestroy: undestroy
    };

    /**
     * For Node.js, simply re-export the core `util.deprecate` function.
     */

    var node = debugUtil.deprecate;

    /*<replacement>*/


    /*</replacement>*/

    var _stream_writable = Writable$1;

    // It seems a linked list but it is not
    // there will be only 2 of these for each stream
    function CorkedRequest$1(state) {
      var _this = this;

      this.next = null;
      this.entry = null;
      this.finish = function () {
        onCorkedFinish(_this, state);
      };
    }
    /* </replacement> */

    /*<replacement>*/
    var asyncWrite = !process.browser && ['v0.10', 'v0.9.'].indexOf(process.version.slice(0, 5)) > -1 ? setImmediate : processNextickArgs.nextTick;
    /*</replacement>*/

    /*<replacement>*/
    var Duplex$1;
    /*</replacement>*/

    Writable$1.WritableState = WritableState$1;

    /*<replacement>*/
    var util$1 = Object.create(util);
    util$1.inherits = inherits$2;
    /*</replacement>*/

    /*<replacement>*/
    var internalUtil = {
      deprecate: node
    };
    /*</replacement>*/

    /*<replacement>*/

    /*</replacement>*/

    /*<replacement>*/

    var Buffer$2 = safeBuffer.Buffer;
    var OurUint8Array = commonjsGlobal.Uint8Array || function () {};
    function _uint8ArrayToBuffer(chunk) {
      return Buffer$2.from(chunk);
    }
    function _isUint8Array(obj) {
      return Buffer$2.isBuffer(obj) || obj instanceof OurUint8Array;
    }

    /*</replacement>*/



    util$1.inherits(Writable$1, stream);

    function nop$1() {}

    function WritableState$1(options, stream) {
      Duplex$1 = Duplex$1 || _stream_duplex;

      options = options || {};

      // Duplex streams are both readable and writable, but share
      // the same options object.
      // However, some cases require setting options to different
      // values for the readable and the writable sides of the duplex stream.
      // These options can be provided separately as readableXXX and writableXXX.
      var isDuplex = stream instanceof Duplex$1;

      // object stream flag to indicate whether or not this stream
      // contains buffers or objects.
      this.objectMode = !!options.objectMode;

      if (isDuplex) this.objectMode = this.objectMode || !!options.writableObjectMode;

      // the point at which write() starts returning false
      // Note: 0 is a valid value, means that we always return false if
      // the entire buffer is not flushed immediately on write()
      var hwm = options.highWaterMark;
      var writableHwm = options.writableHighWaterMark;
      var defaultHwm = this.objectMode ? 16 : 16 * 1024;

      if (hwm || hwm === 0) this.highWaterMark = hwm;else if (isDuplex && (writableHwm || writableHwm === 0)) this.highWaterMark = writableHwm;else this.highWaterMark = defaultHwm;

      // cast to ints.
      this.highWaterMark = Math.floor(this.highWaterMark);

      // if _final has been called
      this.finalCalled = false;

      // drain event flag.
      this.needDrain = false;
      // at the start of calling end()
      this.ending = false;
      // when end() has been called, and returned
      this.ended = false;
      // when 'finish' is emitted
      this.finished = false;

      // has it been destroyed
      this.destroyed = false;

      // should we decode strings into buffers before passing to _write?
      // this is here so that some node-core streams can optimize string
      // handling at a lower level.
      var noDecode = options.decodeStrings === false;
      this.decodeStrings = !noDecode;

      // Crypto is kind of old and crusty.  Historically, its default string
      // encoding is 'binary' so we have to make this configurable.
      // Everything else in the universe uses 'utf8', though.
      this.defaultEncoding = options.defaultEncoding || 'utf8';

      // not an actual buffer we keep track of, but a measurement
      // of how much we're waiting to get pushed to some underlying
      // socket or file.
      this.length = 0;

      // a flag to see when we're in the middle of a write.
      this.writing = false;

      // when true all writes will be buffered until .uncork() call
      this.corked = 0;

      // a flag to be able to tell if the onwrite cb is called immediately,
      // or on a later tick.  We set this to true at first, because any
      // actions that shouldn't happen until "later" should generally also
      // not happen before the first write call.
      this.sync = true;

      // a flag to know if we're processing previously buffered items, which
      // may call the _write() callback in the same tick, so that we don't
      // end up in an overlapped onwrite situation.
      this.bufferProcessing = false;

      // the callback that's passed to _write(chunk,cb)
      this.onwrite = function (er) {
        onwrite$1(stream, er);
      };

      // the callback that the user supplies to write(chunk,encoding,cb)
      this.writecb = null;

      // the amount that is being written when _write is called.
      this.writelen = 0;

      this.bufferedRequest = null;
      this.lastBufferedRequest = null;

      // number of pending user-supplied write callbacks
      // this must be 0 before 'finish' can be emitted
      this.pendingcb = 0;

      // emit prefinish if the only thing we're waiting for is _write cbs
      // This is relevant for synchronous Transform streams
      this.prefinished = false;

      // True if the error was already emitted and should not be thrown again
      this.errorEmitted = false;

      // count buffered requests
      this.bufferedRequestCount = 0;

      // allocate the first CorkedRequest, there is always
      // one allocated and free to use, and we maintain at most two
      this.corkedRequestsFree = new CorkedRequest$1(this);
    }

    WritableState$1.prototype.getBuffer = function getBuffer() {
      var current = this.bufferedRequest;
      var out = [];
      while (current) {
        out.push(current);
        current = current.next;
      }
      return out;
    };

    (function () {
      try {
        Object.defineProperty(WritableState$1.prototype, 'buffer', {
          get: internalUtil.deprecate(function () {
            return this.getBuffer();
          }, '_writableState.buffer is deprecated. Use _writableState.getBuffer ' + 'instead.', 'DEP0003')
        });
      } catch (_) {}
    })();

    // Test _writableState for inheritance to account for Duplex streams,
    // whose prototype chain only points to Readable.
    var realHasInstance;
    if (typeof Symbol === 'function' && Symbol.hasInstance && typeof Function.prototype[Symbol.hasInstance] === 'function') {
      realHasInstance = Function.prototype[Symbol.hasInstance];
      Object.defineProperty(Writable$1, Symbol.hasInstance, {
        value: function (object) {
          if (realHasInstance.call(this, object)) return true;
          if (this !== Writable$1) return false;

          return object && object._writableState instanceof WritableState$1;
        }
      });
    } else {
      realHasInstance = function (object) {
        return object instanceof this;
      };
    }

    function Writable$1(options) {
      Duplex$1 = Duplex$1 || _stream_duplex;

      // Writable ctor is applied to Duplexes, too.
      // `realHasInstance` is necessary because using plain `instanceof`
      // would return false, as no `_writableState` property is attached.

      // Trying to use the custom `instanceof` for Writable here will also break the
      // Node.js LazyTransform implementation, which has a non-trivial getter for
      // `_writableState` that would lead to infinite recursion.
      if (!realHasInstance.call(Writable$1, this) && !(this instanceof Duplex$1)) {
        return new Writable$1(options);
      }

      this._writableState = new WritableState$1(options, this);

      // legacy.
      this.writable = true;

      if (options) {
        if (typeof options.write === 'function') this._write = options.write;

        if (typeof options.writev === 'function') this._writev = options.writev;

        if (typeof options.destroy === 'function') this._destroy = options.destroy;

        if (typeof options.final === 'function') this._final = options.final;
      }

      stream.call(this);
    }

    // Otherwise people can pipe Writable streams, which is just wrong.
    Writable$1.prototype.pipe = function () {
      this.emit('error', new Error('Cannot pipe, not readable'));
    };

    function writeAfterEnd$1(stream, cb) {
      var er = new Error('write after end');
      // TODO: defer error events consistently everywhere, not just the cb
      stream.emit('error', er);
      processNextickArgs.nextTick(cb, er);
    }

    // Checks that a user-supplied chunk is valid, especially for the particular
    // mode the stream is in. Currently this means that `null` is never accepted
    // and undefined/non-string values are only allowed in object mode.
    function validChunk$1(stream, state, chunk, cb) {
      var valid = true;
      var er = false;

      if (chunk === null) {
        er = new TypeError('May not write null values to stream');
      } else if (typeof chunk !== 'string' && chunk !== undefined && !state.objectMode) {
        er = new TypeError('Invalid non-string/buffer chunk');
      }
      if (er) {
        stream.emit('error', er);
        processNextickArgs.nextTick(cb, er);
        valid = false;
      }
      return valid;
    }

    Writable$1.prototype.write = function (chunk, encoding, cb) {
      var state = this._writableState;
      var ret = false;
      var isBuf = !state.objectMode && _isUint8Array(chunk);

      if (isBuf && !Buffer$2.isBuffer(chunk)) {
        chunk = _uint8ArrayToBuffer(chunk);
      }

      if (typeof encoding === 'function') {
        cb = encoding;
        encoding = null;
      }

      if (isBuf) encoding = 'buffer';else if (!encoding) encoding = state.defaultEncoding;

      if (typeof cb !== 'function') cb = nop$1;

      if (state.ended) writeAfterEnd$1(this, cb);else if (isBuf || validChunk$1(this, state, chunk, cb)) {
        state.pendingcb++;
        ret = writeOrBuffer$1(this, state, isBuf, chunk, encoding, cb);
      }

      return ret;
    };

    Writable$1.prototype.cork = function () {
      var state = this._writableState;

      state.corked++;
    };

    Writable$1.prototype.uncork = function () {
      var state = this._writableState;

      if (state.corked) {
        state.corked--;

        if (!state.writing && !state.corked && !state.finished && !state.bufferProcessing && state.bufferedRequest) clearBuffer$1(this, state);
      }
    };

    Writable$1.prototype.setDefaultEncoding = function setDefaultEncoding(encoding) {
      // node::ParseEncoding() requires lower case.
      if (typeof encoding === 'string') encoding = encoding.toLowerCase();
      if (!(['hex', 'utf8', 'utf-8', 'ascii', 'binary', 'base64', 'ucs2', 'ucs-2', 'utf16le', 'utf-16le', 'raw'].indexOf((encoding + '').toLowerCase()) > -1)) throw new TypeError('Unknown encoding: ' + encoding);
      this._writableState.defaultEncoding = encoding;
      return this;
    };

    function decodeChunk$1(state, chunk, encoding) {
      if (!state.objectMode && state.decodeStrings !== false && typeof chunk === 'string') {
        chunk = Buffer$2.from(chunk, encoding);
      }
      return chunk;
    }

    Object.defineProperty(Writable$1.prototype, 'writableHighWaterMark', {
      // making it explicit this property is not enumerable
      // because otherwise some prototype manipulation in
      // userland will fail
      enumerable: false,
      get: function () {
        return this._writableState.highWaterMark;
      }
    });

    // if we're already writing something, then just put this
    // in the queue, and wait our turn.  Otherwise, call _write
    // If we return false, then we need a drain event, so set that flag.
    function writeOrBuffer$1(stream, state, isBuf, chunk, encoding, cb) {
      if (!isBuf) {
        var newChunk = decodeChunk$1(state, chunk, encoding);
        if (chunk !== newChunk) {
          isBuf = true;
          encoding = 'buffer';
          chunk = newChunk;
        }
      }
      var len = state.objectMode ? 1 : chunk.length;

      state.length += len;

      var ret = state.length < state.highWaterMark;
      // we must ensure that previous needDrain will not be reset to false.
      if (!ret) state.needDrain = true;

      if (state.writing || state.corked) {
        var last = state.lastBufferedRequest;
        state.lastBufferedRequest = {
          chunk: chunk,
          encoding: encoding,
          isBuf: isBuf,
          callback: cb,
          next: null
        };
        if (last) {
          last.next = state.lastBufferedRequest;
        } else {
          state.bufferedRequest = state.lastBufferedRequest;
        }
        state.bufferedRequestCount += 1;
      } else {
        doWrite$1(stream, state, false, len, chunk, encoding, cb);
      }

      return ret;
    }

    function doWrite$1(stream, state, writev, len, chunk, encoding, cb) {
      state.writelen = len;
      state.writecb = cb;
      state.writing = true;
      state.sync = true;
      if (writev) stream._writev(chunk, state.onwrite);else stream._write(chunk, encoding, state.onwrite);
      state.sync = false;
    }

    function onwriteError$1(stream, state, sync, er, cb) {
      --state.pendingcb;

      if (sync) {
        // defer the callback if we are being called synchronously
        // to avoid piling up things on the stack
        processNextickArgs.nextTick(cb, er);
        // this can emit finish, and it will always happen
        // after error
        processNextickArgs.nextTick(finishMaybe$1, stream, state);
        stream._writableState.errorEmitted = true;
        stream.emit('error', er);
      } else {
        // the caller expect this to happen before if
        // it is async
        cb(er);
        stream._writableState.errorEmitted = true;
        stream.emit('error', er);
        // this can emit finish, but finish must
        // always follow error
        finishMaybe$1(stream, state);
      }
    }

    function onwriteStateUpdate$1(state) {
      state.writing = false;
      state.writecb = null;
      state.length -= state.writelen;
      state.writelen = 0;
    }

    function onwrite$1(stream, er) {
      var state = stream._writableState;
      var sync = state.sync;
      var cb = state.writecb;

      onwriteStateUpdate$1(state);

      if (er) onwriteError$1(stream, state, sync, er, cb);else {
        // Check if we're actually ready to finish, but don't emit yet
        var finished = needFinish$1(state);

        if (!finished && !state.corked && !state.bufferProcessing && state.bufferedRequest) {
          clearBuffer$1(stream, state);
        }

        if (sync) {
          /*<replacement>*/
          asyncWrite(afterWrite$1, stream, state, finished, cb);
          /*</replacement>*/
        } else {
          afterWrite$1(stream, state, finished, cb);
        }
      }
    }

    function afterWrite$1(stream, state, finished, cb) {
      if (!finished) onwriteDrain$1(stream, state);
      state.pendingcb--;
      cb();
      finishMaybe$1(stream, state);
    }

    // Must force callback to be called on nextTick, so that we don't
    // emit 'drain' before the write() consumer gets the 'false' return
    // value, and has a chance to attach a 'drain' listener.
    function onwriteDrain$1(stream, state) {
      if (state.length === 0 && state.needDrain) {
        state.needDrain = false;
        stream.emit('drain');
      }
    }

    // if there's something in the buffer waiting, then process it
    function clearBuffer$1(stream, state) {
      state.bufferProcessing = true;
      var entry = state.bufferedRequest;

      if (stream._writev && entry && entry.next) {
        // Fast case, write everything using _writev()
        var l = state.bufferedRequestCount;
        var buffer = new Array(l);
        var holder = state.corkedRequestsFree;
        holder.entry = entry;

        var count = 0;
        var allBuffers = true;
        while (entry) {
          buffer[count] = entry;
          if (!entry.isBuf) allBuffers = false;
          entry = entry.next;
          count += 1;
        }
        buffer.allBuffers = allBuffers;

        doWrite$1(stream, state, true, state.length, buffer, '', holder.finish);

        // doWrite is almost always async, defer these to save a bit of time
        // as the hot path ends with doWrite
        state.pendingcb++;
        state.lastBufferedRequest = null;
        if (holder.next) {
          state.corkedRequestsFree = holder.next;
          holder.next = null;
        } else {
          state.corkedRequestsFree = new CorkedRequest$1(state);
        }
        state.bufferedRequestCount = 0;
      } else {
        // Slow case, write chunks one-by-one
        while (entry) {
          var chunk = entry.chunk;
          var encoding = entry.encoding;
          var cb = entry.callback;
          var len = state.objectMode ? 1 : chunk.length;

          doWrite$1(stream, state, false, len, chunk, encoding, cb);
          entry = entry.next;
          state.bufferedRequestCount--;
          // if we didn't call the onwrite immediately, then
          // it means that we need to wait until it does.
          // also, that means that the chunk and cb are currently
          // being processed, so move the buffer counter past them.
          if (state.writing) {
            break;
          }
        }

        if (entry === null) state.lastBufferedRequest = null;
      }

      state.bufferedRequest = entry;
      state.bufferProcessing = false;
    }

    Writable$1.prototype._write = function (chunk, encoding, cb) {
      cb(new Error('_write() is not implemented'));
    };

    Writable$1.prototype._writev = null;

    Writable$1.prototype.end = function (chunk, encoding, cb) {
      var state = this._writableState;

      if (typeof chunk === 'function') {
        cb = chunk;
        chunk = null;
        encoding = null;
      } else if (typeof encoding === 'function') {
        cb = encoding;
        encoding = null;
      }

      if (chunk !== null && chunk !== undefined) this.write(chunk, encoding);

      // .end() fully uncorks
      if (state.corked) {
        state.corked = 1;
        this.uncork();
      }

      // ignore unnecessary end() calls.
      if (!state.ending && !state.finished) endWritable$1(this, state, cb);
    };

    function needFinish$1(state) {
      return state.ending && state.length === 0 && state.bufferedRequest === null && !state.finished && !state.writing;
    }
    function callFinal(stream, state) {
      stream._final(function (err) {
        state.pendingcb--;
        if (err) {
          stream.emit('error', err);
        }
        state.prefinished = true;
        stream.emit('prefinish');
        finishMaybe$1(stream, state);
      });
    }
    function prefinish$1(stream, state) {
      if (!state.prefinished && !state.finalCalled) {
        if (typeof stream._final === 'function') {
          state.pendingcb++;
          state.finalCalled = true;
          processNextickArgs.nextTick(callFinal, stream, state);
        } else {
          state.prefinished = true;
          stream.emit('prefinish');
        }
      }
    }

    function finishMaybe$1(stream, state) {
      var need = needFinish$1(state);
      if (need) {
        prefinish$1(stream, state);
        if (state.pendingcb === 0) {
          state.finished = true;
          stream.emit('finish');
        }
      }
      return need;
    }

    function endWritable$1(stream, state, cb) {
      state.ending = true;
      finishMaybe$1(stream, state);
      if (cb) {
        if (state.finished) processNextickArgs.nextTick(cb);else stream.once('finish', cb);
      }
      state.ended = true;
      stream.writable = false;
    }

    function onCorkedFinish(corkReq, state, err) {
      var entry = corkReq.entry;
      corkReq.entry = null;
      while (entry) {
        var cb = entry.callback;
        state.pendingcb--;
        cb(err);
        entry = entry.next;
      }
      if (state.corkedRequestsFree) {
        state.corkedRequestsFree.next = corkReq;
      } else {
        state.corkedRequestsFree = corkReq;
      }
    }

    Object.defineProperty(Writable$1.prototype, 'destroyed', {
      get: function () {
        if (this._writableState === undefined) {
          return false;
        }
        return this._writableState.destroyed;
      },
      set: function (value) {
        // we ignore the value if the stream
        // has not been initialized yet
        if (!this._writableState) {
          return;
        }

        // backward compatibility, the user is explicitly
        // managing destroyed
        this._writableState.destroyed = value;
      }
    });

    Writable$1.prototype.destroy = destroy_1.destroy;
    Writable$1.prototype._undestroy = destroy_1.undestroy;
    Writable$1.prototype._destroy = function (err, cb) {
      this.end();
      cb(err);
    };

    /*<replacement>*/


    /*</replacement>*/

    /*<replacement>*/
    var objectKeys = Object.keys || function (obj) {
      var keys = [];
      for (var key in obj) {
        keys.push(key);
      }return keys;
    };
    /*</replacement>*/

    var _stream_duplex = Duplex$2;

    /*<replacement>*/
    var util$2 = Object.create(util);
    util$2.inherits = inherits$2;
    /*</replacement>*/




    util$2.inherits(Duplex$2, _stream_readable);

    {
      // avoid scope creep, the keys array can then be collected
      var keys$1 = objectKeys(_stream_writable.prototype);
      for (var v$1 = 0; v$1 < keys$1.length; v$1++) {
        var method$1 = keys$1[v$1];
        if (!Duplex$2.prototype[method$1]) Duplex$2.prototype[method$1] = _stream_writable.prototype[method$1];
      }
    }

    function Duplex$2(options) {
      if (!(this instanceof Duplex$2)) return new Duplex$2(options);

      _stream_readable.call(this, options);
      _stream_writable.call(this, options);

      if (options && options.readable === false) this.readable = false;

      if (options && options.writable === false) this.writable = false;

      this.allowHalfOpen = true;
      if (options && options.allowHalfOpen === false) this.allowHalfOpen = false;

      this.once('end', onend$1);
    }

    Object.defineProperty(Duplex$2.prototype, 'writableHighWaterMark', {
      // making it explicit this property is not enumerable
      // because otherwise some prototype manipulation in
      // userland will fail
      enumerable: false,
      get: function () {
        return this._writableState.highWaterMark;
      }
    });

    // the no-half-open enforcer
    function onend$1() {
      // if we allow half-open state, or if the writable side ended,
      // then we're ok.
      if (this.allowHalfOpen || this._writableState.ended) return;

      // no more data can be written.
      // But allow more writes to happen in this tick.
      processNextickArgs.nextTick(onEndNT$1, this);
    }

    function onEndNT$1(self) {
      self.end();
    }

    Object.defineProperty(Duplex$2.prototype, 'destroyed', {
      get: function () {
        if (this._readableState === undefined || this._writableState === undefined) {
          return false;
        }
        return this._readableState.destroyed && this._writableState.destroyed;
      },
      set: function (value) {
        // we ignore the value if the stream
        // has not been initialized yet
        if (this._readableState === undefined || this._writableState === undefined) {
          return;
        }

        // backward compatibility, the user is explicitly
        // managing destroyed
        this._readableState.destroyed = value;
        this._writableState.destroyed = value;
      }
    });

    Duplex$2.prototype._destroy = function (err, cb) {
      this.push(null);
      this.end();

      processNextickArgs.nextTick(cb, err);
    };

    /*<replacement>*/

    var Buffer$3 = safeBuffer.Buffer;
    /*</replacement>*/

    var isEncoding = Buffer$3.isEncoding || function (encoding) {
      encoding = '' + encoding;
      switch (encoding && encoding.toLowerCase()) {
        case 'hex':case 'utf8':case 'utf-8':case 'ascii':case 'binary':case 'base64':case 'ucs2':case 'ucs-2':case 'utf16le':case 'utf-16le':case 'raw':
          return true;
        default:
          return false;
      }
    };

    function _normalizeEncoding(enc) {
      if (!enc) return 'utf8';
      var retried;
      while (true) {
        switch (enc) {
          case 'utf8':
          case 'utf-8':
            return 'utf8';
          case 'ucs2':
          case 'ucs-2':
          case 'utf16le':
          case 'utf-16le':
            return 'utf16le';
          case 'latin1':
          case 'binary':
            return 'latin1';
          case 'base64':
          case 'ascii':
          case 'hex':
            return enc;
          default:
            if (retried) return; // undefined
            enc = ('' + enc).toLowerCase();
            retried = true;
        }
      }
    }
    // Do not cache `Buffer.isEncoding` when checking encoding names as some
    // modules monkey-patch it to support additional encodings
    function normalizeEncoding(enc) {
      var nenc = _normalizeEncoding(enc);
      if (typeof nenc !== 'string' && (Buffer$3.isEncoding === isEncoding || !isEncoding(enc))) throw new Error('Unknown encoding: ' + enc);
      return nenc || enc;
    }

    // StringDecoder provides an interface for efficiently splitting a series of
    // buffers into a series of JS strings without breaking apart multi-byte
    // characters.
    var StringDecoder_1 = StringDecoder$1;
    function StringDecoder$1(encoding) {
      this.encoding = normalizeEncoding(encoding);
      var nb;
      switch (this.encoding) {
        case 'utf16le':
          this.text = utf16Text;
          this.end = utf16End;
          nb = 4;
          break;
        case 'utf8':
          this.fillLast = utf8FillLast;
          nb = 4;
          break;
        case 'base64':
          this.text = base64Text;
          this.end = base64End;
          nb = 3;
          break;
        default:
          this.write = simpleWrite;
          this.end = simpleEnd;
          return;
      }
      this.lastNeed = 0;
      this.lastTotal = 0;
      this.lastChar = Buffer$3.allocUnsafe(nb);
    }

    StringDecoder$1.prototype.write = function (buf) {
      if (buf.length === 0) return '';
      var r;
      var i;
      if (this.lastNeed) {
        r = this.fillLast(buf);
        if (r === undefined) return '';
        i = this.lastNeed;
        this.lastNeed = 0;
      } else {
        i = 0;
      }
      if (i < buf.length) return r ? r + this.text(buf, i) : this.text(buf, i);
      return r || '';
    };

    StringDecoder$1.prototype.end = utf8End;

    // Returns only complete characters in a Buffer
    StringDecoder$1.prototype.text = utf8Text;

    // Attempts to complete a partial non-UTF-8 character using bytes from a Buffer
    StringDecoder$1.prototype.fillLast = function (buf) {
      if (this.lastNeed <= buf.length) {
        buf.copy(this.lastChar, this.lastTotal - this.lastNeed, 0, this.lastNeed);
        return this.lastChar.toString(this.encoding, 0, this.lastTotal);
      }
      buf.copy(this.lastChar, this.lastTotal - this.lastNeed, 0, buf.length);
      this.lastNeed -= buf.length;
    };

    // Checks the type of a UTF-8 byte, whether it's ASCII, a leading byte, or a
    // continuation byte. If an invalid byte is detected, -2 is returned.
    function utf8CheckByte(byte) {
      if (byte <= 0x7F) return 0;else if (byte >> 5 === 0x06) return 2;else if (byte >> 4 === 0x0E) return 3;else if (byte >> 3 === 0x1E) return 4;
      return byte >> 6 === 0x02 ? -1 : -2;
    }

    // Checks at most 3 bytes at the end of a Buffer in order to detect an
    // incomplete multi-byte UTF-8 character. The total number of bytes (2, 3, or 4)
    // needed to complete the UTF-8 character (if applicable) are returned.
    function utf8CheckIncomplete(self, buf, i) {
      var j = buf.length - 1;
      if (j < i) return 0;
      var nb = utf8CheckByte(buf[j]);
      if (nb >= 0) {
        if (nb > 0) self.lastNeed = nb - 1;
        return nb;
      }
      if (--j < i || nb === -2) return 0;
      nb = utf8CheckByte(buf[j]);
      if (nb >= 0) {
        if (nb > 0) self.lastNeed = nb - 2;
        return nb;
      }
      if (--j < i || nb === -2) return 0;
      nb = utf8CheckByte(buf[j]);
      if (nb >= 0) {
        if (nb > 0) {
          if (nb === 2) nb = 0;else self.lastNeed = nb - 3;
        }
        return nb;
      }
      return 0;
    }

    // Validates as many continuation bytes for a multi-byte UTF-8 character as
    // needed or are available. If we see a non-continuation byte where we expect
    // one, we "replace" the validated continuation bytes we've seen so far with
    // a single UTF-8 replacement character ('\ufffd'), to match v8's UTF-8 decoding
    // behavior. The continuation byte check is included three times in the case
    // where all of the continuation bytes for a character exist in the same buffer.
    // It is also done this way as a slight performance increase instead of using a
    // loop.
    function utf8CheckExtraBytes(self, buf, p) {
      if ((buf[0] & 0xC0) !== 0x80) {
        self.lastNeed = 0;
        return '\ufffd';
      }
      if (self.lastNeed > 1 && buf.length > 1) {
        if ((buf[1] & 0xC0) !== 0x80) {
          self.lastNeed = 1;
          return '\ufffd';
        }
        if (self.lastNeed > 2 && buf.length > 2) {
          if ((buf[2] & 0xC0) !== 0x80) {
            self.lastNeed = 2;
            return '\ufffd';
          }
        }
      }
    }

    // Attempts to complete a multi-byte UTF-8 character using bytes from a Buffer.
    function utf8FillLast(buf) {
      var p = this.lastTotal - this.lastNeed;
      var r = utf8CheckExtraBytes(this, buf);
      if (r !== undefined) return r;
      if (this.lastNeed <= buf.length) {
        buf.copy(this.lastChar, p, 0, this.lastNeed);
        return this.lastChar.toString(this.encoding, 0, this.lastTotal);
      }
      buf.copy(this.lastChar, p, 0, buf.length);
      this.lastNeed -= buf.length;
    }

    // Returns all complete UTF-8 characters in a Buffer. If the Buffer ended on a
    // partial character, the character's bytes are buffered until the required
    // number of bytes are available.
    function utf8Text(buf, i) {
      var total = utf8CheckIncomplete(this, buf, i);
      if (!this.lastNeed) return buf.toString('utf8', i);
      this.lastTotal = total;
      var end = buf.length - (total - this.lastNeed);
      buf.copy(this.lastChar, 0, end);
      return buf.toString('utf8', i, end);
    }

    // For UTF-8, a replacement character is added when ending on a partial
    // character.
    function utf8End(buf) {
      var r = buf && buf.length ? this.write(buf) : '';
      if (this.lastNeed) return r + '\ufffd';
      return r;
    }

    // UTF-16LE typically needs two bytes per character, but even if we have an even
    // number of bytes available, we need to check if we end on a leading/high
    // surrogate. In that case, we need to wait for the next two bytes in order to
    // decode the last character properly.
    function utf16Text(buf, i) {
      if ((buf.length - i) % 2 === 0) {
        var r = buf.toString('utf16le', i);
        if (r) {
          var c = r.charCodeAt(r.length - 1);
          if (c >= 0xD800 && c <= 0xDBFF) {
            this.lastNeed = 2;
            this.lastTotal = 4;
            this.lastChar[0] = buf[buf.length - 2];
            this.lastChar[1] = buf[buf.length - 1];
            return r.slice(0, -1);
          }
        }
        return r;
      }
      this.lastNeed = 1;
      this.lastTotal = 2;
      this.lastChar[0] = buf[buf.length - 1];
      return buf.toString('utf16le', i, buf.length - 1);
    }

    // For UTF-16LE we do not explicitly append special replacement characters if we
    // end on a partial character, we simply let v8 handle that.
    function utf16End(buf) {
      var r = buf && buf.length ? this.write(buf) : '';
      if (this.lastNeed) {
        var end = this.lastTotal - this.lastNeed;
        return r + this.lastChar.toString('utf16le', 0, end);
      }
      return r;
    }

    function base64Text(buf, i) {
      var n = (buf.length - i) % 3;
      if (n === 0) return buf.toString('base64', i);
      this.lastNeed = 3 - n;
      this.lastTotal = 3;
      if (n === 1) {
        this.lastChar[0] = buf[buf.length - 1];
      } else {
        this.lastChar[0] = buf[buf.length - 2];
        this.lastChar[1] = buf[buf.length - 1];
      }
      return buf.toString('base64', i, buf.length - n);
    }

    function base64End(buf) {
      var r = buf && buf.length ? this.write(buf) : '';
      if (this.lastNeed) return r + this.lastChar.toString('base64', 0, 3 - this.lastNeed);
      return r;
    }

    // Pass bytes on through for single-byte encodings (e.g. ascii, latin1, hex)
    function simpleWrite(buf) {
      return buf.toString(this.encoding);
    }

    function simpleEnd(buf) {
      return buf && buf.length ? this.write(buf) : '';
    }

    var string_decoder = {
    	StringDecoder: StringDecoder_1
    };

    /*<replacement>*/


    /*</replacement>*/

    var _stream_readable = Readable$1;

    /*<replacement>*/

    /*</replacement>*/

    /*<replacement>*/
    var Duplex$3;
    /*</replacement>*/

    Readable$1.ReadableState = ReadableState$1;

    var EElistenerCount = function (emitter, type) {
      return emitter.listeners(type).length;
    };
    /*</replacement>*/

    /*<replacement>*/

    /*</replacement>*/

    /*<replacement>*/

    var Buffer$4 = safeBuffer.Buffer;
    var OurUint8Array$1 = commonjsGlobal.Uint8Array || function () {};
    function _uint8ArrayToBuffer$1(chunk) {
      return Buffer$4.from(chunk);
    }
    function _isUint8Array$1(obj) {
      return Buffer$4.isBuffer(obj) || obj instanceof OurUint8Array$1;
    }

    /*</replacement>*/

    /*<replacement>*/
    var util$3 = Object.create(util);
    util$3.inherits = inherits$2;
    /*</replacement>*/

    /*<replacement>*/

    var debug$1 = void 0;
    if (debugUtil && debugUtil.debuglog) {
      debug$1 = debugUtil.debuglog('stream');
    } else {
      debug$1 = function () {};
    }
    /*</replacement>*/



    var StringDecoder$2;

    util$3.inherits(Readable$1, stream);

    var kProxyEvents = ['error', 'close', 'destroy', 'pause', 'resume'];

    function prependListener$1(emitter, event, fn) {
      // Sadly this is not cacheable as some libraries bundle their own
      // event emitter implementation with them.
      if (typeof emitter.prependListener === 'function') return emitter.prependListener(event, fn);

      // This is a hack to make sure that our error handler is attached before any
      // userland ones.  NEVER DO THIS. This is here only because this code needs
      // to continue to work with older versions of Node.js that do not include
      // the prependListener() method. The goal is to eventually remove this hack.
      if (!emitter._events || !emitter._events[event]) emitter.on(event, fn);else if (isarray(emitter._events[event])) emitter._events[event].unshift(fn);else emitter._events[event] = [fn, emitter._events[event]];
    }

    function ReadableState$1(options, stream) {
      Duplex$3 = Duplex$3 || _stream_duplex;

      options = options || {};

      // Duplex streams are both readable and writable, but share
      // the same options object.
      // However, some cases require setting options to different
      // values for the readable and the writable sides of the duplex stream.
      // These options can be provided separately as readableXXX and writableXXX.
      var isDuplex = stream instanceof Duplex$3;

      // object stream flag. Used to make read(n) ignore n and to
      // make all the buffer merging and length checks go away
      this.objectMode = !!options.objectMode;

      if (isDuplex) this.objectMode = this.objectMode || !!options.readableObjectMode;

      // the point at which it stops calling _read() to fill the buffer
      // Note: 0 is a valid value, means "don't call _read preemptively ever"
      var hwm = options.highWaterMark;
      var readableHwm = options.readableHighWaterMark;
      var defaultHwm = this.objectMode ? 16 : 16 * 1024;

      if (hwm || hwm === 0) this.highWaterMark = hwm;else if (isDuplex && (readableHwm || readableHwm === 0)) this.highWaterMark = readableHwm;else this.highWaterMark = defaultHwm;

      // cast to ints.
      this.highWaterMark = Math.floor(this.highWaterMark);

      // A linked list is used to store data chunks instead of an array because the
      // linked list can remove elements from the beginning faster than
      // array.shift()
      this.buffer = new BufferList$1();
      this.length = 0;
      this.pipes = null;
      this.pipesCount = 0;
      this.flowing = null;
      this.ended = false;
      this.endEmitted = false;
      this.reading = false;

      // a flag to be able to tell if the event 'readable'/'data' is emitted
      // immediately, or on a later tick.  We set this to true at first, because
      // any actions that shouldn't happen until "later" should generally also
      // not happen before the first read call.
      this.sync = true;

      // whenever we return null, then we set a flag to say
      // that we're awaiting a 'readable' event emission.
      this.needReadable = false;
      this.emittedReadable = false;
      this.readableListening = false;
      this.resumeScheduled = false;

      // has it been destroyed
      this.destroyed = false;

      // Crypto is kind of old and crusty.  Historically, its default string
      // encoding is 'binary' so we have to make this configurable.
      // Everything else in the universe uses 'utf8', though.
      this.defaultEncoding = options.defaultEncoding || 'utf8';

      // the number of writers that are awaiting a drain event in .pipe()s
      this.awaitDrain = 0;

      // if true, a maybeReadMore has been scheduled
      this.readingMore = false;

      this.decoder = null;
      this.encoding = null;
      if (options.encoding) {
        if (!StringDecoder$2) StringDecoder$2 = string_decoder.StringDecoder;
        this.decoder = new StringDecoder$2(options.encoding);
        this.encoding = options.encoding;
      }
    }

    function Readable$1(options) {
      Duplex$3 = Duplex$3 || _stream_duplex;

      if (!(this instanceof Readable$1)) return new Readable$1(options);

      this._readableState = new ReadableState$1(options, this);

      // legacy
      this.readable = true;

      if (options) {
        if (typeof options.read === 'function') this._read = options.read;

        if (typeof options.destroy === 'function') this._destroy = options.destroy;
      }

      stream.call(this);
    }

    Object.defineProperty(Readable$1.prototype, 'destroyed', {
      get: function () {
        if (this._readableState === undefined) {
          return false;
        }
        return this._readableState.destroyed;
      },
      set: function (value) {
        // we ignore the value if the stream
        // has not been initialized yet
        if (!this._readableState) {
          return;
        }

        // backward compatibility, the user is explicitly
        // managing destroyed
        this._readableState.destroyed = value;
      }
    });

    Readable$1.prototype.destroy = destroy_1.destroy;
    Readable$1.prototype._undestroy = destroy_1.undestroy;
    Readable$1.prototype._destroy = function (err, cb) {
      this.push(null);
      cb(err);
    };

    // Manually shove something into the read() buffer.
    // This returns true if the highWaterMark has not been hit yet,
    // similar to how Writable.write() returns true if you should
    // write() some more.
    Readable$1.prototype.push = function (chunk, encoding) {
      var state = this._readableState;
      var skipChunkCheck;

      if (!state.objectMode) {
        if (typeof chunk === 'string') {
          encoding = encoding || state.defaultEncoding;
          if (encoding !== state.encoding) {
            chunk = Buffer$4.from(chunk, encoding);
            encoding = '';
          }
          skipChunkCheck = true;
        }
      } else {
        skipChunkCheck = true;
      }

      return readableAddChunk$1(this, chunk, encoding, false, skipChunkCheck);
    };

    // Unshift should *always* be something directly out of read()
    Readable$1.prototype.unshift = function (chunk) {
      return readableAddChunk$1(this, chunk, null, true, false);
    };

    function readableAddChunk$1(stream, chunk, encoding, addToFront, skipChunkCheck) {
      var state = stream._readableState;
      if (chunk === null) {
        state.reading = false;
        onEofChunk$1(stream, state);
      } else {
        var er;
        if (!skipChunkCheck) er = chunkInvalid$1(state, chunk);
        if (er) {
          stream.emit('error', er);
        } else if (state.objectMode || chunk && chunk.length > 0) {
          if (typeof chunk !== 'string' && !state.objectMode && Object.getPrototypeOf(chunk) !== Buffer$4.prototype) {
            chunk = _uint8ArrayToBuffer$1(chunk);
          }

          if (addToFront) {
            if (state.endEmitted) stream.emit('error', new Error('stream.unshift() after end event'));else addChunk(stream, state, chunk, true);
          } else if (state.ended) {
            stream.emit('error', new Error('stream.push() after EOF'));
          } else {
            state.reading = false;
            if (state.decoder && !encoding) {
              chunk = state.decoder.write(chunk);
              if (state.objectMode || chunk.length !== 0) addChunk(stream, state, chunk, false);else maybeReadMore$1(stream, state);
            } else {
              addChunk(stream, state, chunk, false);
            }
          }
        } else if (!addToFront) {
          state.reading = false;
        }
      }

      return needMoreData$1(state);
    }

    function addChunk(stream, state, chunk, addToFront) {
      if (state.flowing && state.length === 0 && !state.sync) {
        stream.emit('data', chunk);
        stream.read(0);
      } else {
        // update the buffer info.
        state.length += state.objectMode ? 1 : chunk.length;
        if (addToFront) state.buffer.unshift(chunk);else state.buffer.push(chunk);

        if (state.needReadable) emitReadable$1(stream);
      }
      maybeReadMore$1(stream, state);
    }

    function chunkInvalid$1(state, chunk) {
      var er;
      if (!_isUint8Array$1(chunk) && typeof chunk !== 'string' && chunk !== undefined && !state.objectMode) {
        er = new TypeError('Invalid non-string/buffer chunk');
      }
      return er;
    }

    // if it's past the high water mark, we can push in some more.
    // Also, if we have no data yet, we can stand some
    // more bytes.  This is to work around cases where hwm=0,
    // such as the repl.  Also, if the push() triggered a
    // readable event, and the user called read(largeNumber) such that
    // needReadable was set, then we ought to push more, so that another
    // 'readable' event will be triggered.
    function needMoreData$1(state) {
      return !state.ended && (state.needReadable || state.length < state.highWaterMark || state.length === 0);
    }

    Readable$1.prototype.isPaused = function () {
      return this._readableState.flowing === false;
    };

    // backwards compatibility.
    Readable$1.prototype.setEncoding = function (enc) {
      if (!StringDecoder$2) StringDecoder$2 = string_decoder.StringDecoder;
      this._readableState.decoder = new StringDecoder$2(enc);
      this._readableState.encoding = enc;
      return this;
    };

    // Don't raise the hwm > 8MB
    var MAX_HWM$1 = 0x800000;
    function computeNewHighWaterMark$1(n) {
      if (n >= MAX_HWM$1) {
        n = MAX_HWM$1;
      } else {
        // Get the next highest power of 2 to prevent increasing hwm excessively in
        // tiny amounts
        n--;
        n |= n >>> 1;
        n |= n >>> 2;
        n |= n >>> 4;
        n |= n >>> 8;
        n |= n >>> 16;
        n++;
      }
      return n;
    }

    // This function is designed to be inlinable, so please take care when making
    // changes to the function body.
    function howMuchToRead$1(n, state) {
      if (n <= 0 || state.length === 0 && state.ended) return 0;
      if (state.objectMode) return 1;
      if (n !== n) {
        // Only flow one buffer at a time
        if (state.flowing && state.length) return state.buffer.head.data.length;else return state.length;
      }
      // If we're asking for more than the current hwm, then raise the hwm.
      if (n > state.highWaterMark) state.highWaterMark = computeNewHighWaterMark$1(n);
      if (n <= state.length) return n;
      // Don't have enough
      if (!state.ended) {
        state.needReadable = true;
        return 0;
      }
      return state.length;
    }

    // you can override either this method, or the async _read(n) below.
    Readable$1.prototype.read = function (n) {
      debug$1('read', n);
      n = parseInt(n, 10);
      var state = this._readableState;
      var nOrig = n;

      if (n !== 0) state.emittedReadable = false;

      // if we're doing read(0) to trigger a readable event, but we
      // already have a bunch of data in the buffer, then just trigger
      // the 'readable' event and move on.
      if (n === 0 && state.needReadable && (state.length >= state.highWaterMark || state.ended)) {
        debug$1('read: emitReadable', state.length, state.ended);
        if (state.length === 0 && state.ended) endReadable$1(this);else emitReadable$1(this);
        return null;
      }

      n = howMuchToRead$1(n, state);

      // if we've ended, and we're now clear, then finish it up.
      if (n === 0 && state.ended) {
        if (state.length === 0) endReadable$1(this);
        return null;
      }

      // All the actual chunk generation logic needs to be
      // *below* the call to _read.  The reason is that in certain
      // synthetic stream cases, such as passthrough streams, _read
      // may be a completely synchronous operation which may change
      // the state of the read buffer, providing enough data when
      // before there was *not* enough.
      //
      // So, the steps are:
      // 1. Figure out what the state of things will be after we do
      // a read from the buffer.
      //
      // 2. If that resulting state will trigger a _read, then call _read.
      // Note that this may be asynchronous, or synchronous.  Yes, it is
      // deeply ugly to write APIs this way, but that still doesn't mean
      // that the Readable class should behave improperly, as streams are
      // designed to be sync/async agnostic.
      // Take note if the _read call is sync or async (ie, if the read call
      // has returned yet), so that we know whether or not it's safe to emit
      // 'readable' etc.
      //
      // 3. Actually pull the requested chunks out of the buffer and return.

      // if we need a readable event, then we need to do some reading.
      var doRead = state.needReadable;
      debug$1('need readable', doRead);

      // if we currently have less than the highWaterMark, then also read some
      if (state.length === 0 || state.length - n < state.highWaterMark) {
        doRead = true;
        debug$1('length less than watermark', doRead);
      }

      // however, if we've ended, then there's no point, and if we're already
      // reading, then it's unnecessary.
      if (state.ended || state.reading) {
        doRead = false;
        debug$1('reading or ended', doRead);
      } else if (doRead) {
        debug$1('do read');
        state.reading = true;
        state.sync = true;
        // if the length is currently zero, then we *need* a readable event.
        if (state.length === 0) state.needReadable = true;
        // call internal read method
        this._read(state.highWaterMark);
        state.sync = false;
        // If _read pushed data synchronously, then `reading` will be false,
        // and we need to re-evaluate how much data we can return to the user.
        if (!state.reading) n = howMuchToRead$1(nOrig, state);
      }

      var ret;
      if (n > 0) ret = fromList$1(n, state);else ret = null;

      if (ret === null) {
        state.needReadable = true;
        n = 0;
      } else {
        state.length -= n;
      }

      if (state.length === 0) {
        // If we have nothing in the buffer, then we want to know
        // as soon as we *do* get something into the buffer.
        if (!state.ended) state.needReadable = true;

        // If we tried to read() past the EOF, then emit end on the next tick.
        if (nOrig !== n && state.ended) endReadable$1(this);
      }

      if (ret !== null) this.emit('data', ret);

      return ret;
    };

    function onEofChunk$1(stream, state) {
      if (state.ended) return;
      if (state.decoder) {
        var chunk = state.decoder.end();
        if (chunk && chunk.length) {
          state.buffer.push(chunk);
          state.length += state.objectMode ? 1 : chunk.length;
        }
      }
      state.ended = true;

      // emit 'readable' now to make sure it gets picked up.
      emitReadable$1(stream);
    }

    // Don't emit readable right away in sync mode, because this can trigger
    // another read() call => stack overflow.  This way, it might trigger
    // a nextTick recursion warning, but that's not so bad.
    function emitReadable$1(stream) {
      var state = stream._readableState;
      state.needReadable = false;
      if (!state.emittedReadable) {
        debug$1('emitReadable', state.flowing);
        state.emittedReadable = true;
        if (state.sync) processNextickArgs.nextTick(emitReadable_$1, stream);else emitReadable_$1(stream);
      }
    }

    function emitReadable_$1(stream) {
      debug$1('emit readable');
      stream.emit('readable');
      flow$1(stream);
    }

    // at this point, the user has presumably seen the 'readable' event,
    // and called read() to consume some data.  that may have triggered
    // in turn another _read(n) call, in which case reading = true if
    // it's in progress.
    // However, if we're not ended, or reading, and the length < hwm,
    // then go ahead and try to read some more preemptively.
    function maybeReadMore$1(stream, state) {
      if (!state.readingMore) {
        state.readingMore = true;
        processNextickArgs.nextTick(maybeReadMore_$1, stream, state);
      }
    }

    function maybeReadMore_$1(stream, state) {
      var len = state.length;
      while (!state.reading && !state.flowing && !state.ended && state.length < state.highWaterMark) {
        debug$1('maybeReadMore read 0');
        stream.read(0);
        if (len === state.length)
          // didn't get any data, stop spinning.
          break;else len = state.length;
      }
      state.readingMore = false;
    }

    // abstract method.  to be overridden in specific implementation classes.
    // call cb(er, data) where data is <= n in length.
    // for virtual (non-string, non-buffer) streams, "length" is somewhat
    // arbitrary, and perhaps not very meaningful.
    Readable$1.prototype._read = function (n) {
      this.emit('error', new Error('_read() is not implemented'));
    };

    Readable$1.prototype.pipe = function (dest, pipeOpts) {
      var src = this;
      var state = this._readableState;

      switch (state.pipesCount) {
        case 0:
          state.pipes = dest;
          break;
        case 1:
          state.pipes = [state.pipes, dest];
          break;
        default:
          state.pipes.push(dest);
          break;
      }
      state.pipesCount += 1;
      debug$1('pipe count=%d opts=%j', state.pipesCount, pipeOpts);

      var doEnd = (!pipeOpts || pipeOpts.end !== false) && dest !== process.stdout && dest !== process.stderr;

      var endFn = doEnd ? onend : unpipe;
      if (state.endEmitted) processNextickArgs.nextTick(endFn);else src.once('end', endFn);

      dest.on('unpipe', onunpipe);
      function onunpipe(readable, unpipeInfo) {
        debug$1('onunpipe');
        if (readable === src) {
          if (unpipeInfo && unpipeInfo.hasUnpiped === false) {
            unpipeInfo.hasUnpiped = true;
            cleanup();
          }
        }
      }

      function onend() {
        debug$1('onend');
        dest.end();
      }

      // when the dest drains, it reduces the awaitDrain counter
      // on the source.  This would be more elegant with a .once()
      // handler in flow(), but adding and removing repeatedly is
      // too slow.
      var ondrain = pipeOnDrain$1(src);
      dest.on('drain', ondrain);

      var cleanedUp = false;
      function cleanup() {
        debug$1('cleanup');
        // cleanup event handlers once the pipe is broken
        dest.removeListener('close', onclose);
        dest.removeListener('finish', onfinish);
        dest.removeListener('drain', ondrain);
        dest.removeListener('error', onerror);
        dest.removeListener('unpipe', onunpipe);
        src.removeListener('end', onend);
        src.removeListener('end', unpipe);
        src.removeListener('data', ondata);

        cleanedUp = true;

        // if the reader is waiting for a drain event from this
        // specific writer, then it would cause it to never start
        // flowing again.
        // So, if this is awaiting a drain, then we just call it now.
        // If we don't know, then assume that we are waiting for one.
        if (state.awaitDrain && (!dest._writableState || dest._writableState.needDrain)) ondrain();
      }

      // If the user pushes more data while we're writing to dest then we'll end up
      // in ondata again. However, we only want to increase awaitDrain once because
      // dest will only emit one 'drain' event for the multiple writes.
      // => Introduce a guard on increasing awaitDrain.
      var increasedAwaitDrain = false;
      src.on('data', ondata);
      function ondata(chunk) {
        debug$1('ondata');
        increasedAwaitDrain = false;
        var ret = dest.write(chunk);
        if (false === ret && !increasedAwaitDrain) {
          // If the user unpiped during `dest.write()`, it is possible
          // to get stuck in a permanently paused state if that write
          // also returned false.
          // => Check whether `dest` is still a piping destination.
          if ((state.pipesCount === 1 && state.pipes === dest || state.pipesCount > 1 && indexOf$1(state.pipes, dest) !== -1) && !cleanedUp) {
            debug$1('false write response, pause', src._readableState.awaitDrain);
            src._readableState.awaitDrain++;
            increasedAwaitDrain = true;
          }
          src.pause();
        }
      }

      // if the dest has an error, then stop piping into it.
      // however, don't suppress the throwing behavior for this.
      function onerror(er) {
        debug$1('onerror', er);
        unpipe();
        dest.removeListener('error', onerror);
        if (EElistenerCount(dest, 'error') === 0) dest.emit('error', er);
      }

      // Make sure our error handler is attached before userland ones.
      prependListener$1(dest, 'error', onerror);

      // Both close and finish should trigger unpipe, but only once.
      function onclose() {
        dest.removeListener('finish', onfinish);
        unpipe();
      }
      dest.once('close', onclose);
      function onfinish() {
        debug$1('onfinish');
        dest.removeListener('close', onclose);
        unpipe();
      }
      dest.once('finish', onfinish);

      function unpipe() {
        debug$1('unpipe');
        src.unpipe(dest);
      }

      // tell the dest that it's being piped to
      dest.emit('pipe', src);

      // start the flow if it hasn't been started already.
      if (!state.flowing) {
        debug$1('pipe resume');
        src.resume();
      }

      return dest;
    };

    function pipeOnDrain$1(src) {
      return function () {
        var state = src._readableState;
        debug$1('pipeOnDrain', state.awaitDrain);
        if (state.awaitDrain) state.awaitDrain--;
        if (state.awaitDrain === 0 && EElistenerCount(src, 'data')) {
          state.flowing = true;
          flow$1(src);
        }
      };
    }

    Readable$1.prototype.unpipe = function (dest) {
      var state = this._readableState;
      var unpipeInfo = { hasUnpiped: false };

      // if we're not piping anywhere, then do nothing.
      if (state.pipesCount === 0) return this;

      // just one destination.  most common case.
      if (state.pipesCount === 1) {
        // passed in one, but it's not the right one.
        if (dest && dest !== state.pipes) return this;

        if (!dest) dest = state.pipes;

        // got a match.
        state.pipes = null;
        state.pipesCount = 0;
        state.flowing = false;
        if (dest) dest.emit('unpipe', this, unpipeInfo);
        return this;
      }

      // slow case. multiple pipe destinations.

      if (!dest) {
        // remove all.
        var dests = state.pipes;
        var len = state.pipesCount;
        state.pipes = null;
        state.pipesCount = 0;
        state.flowing = false;

        for (var i = 0; i < len; i++) {
          dests[i].emit('unpipe', this, unpipeInfo);
        }return this;
      }

      // try to find the right one.
      var index = indexOf$1(state.pipes, dest);
      if (index === -1) return this;

      state.pipes.splice(index, 1);
      state.pipesCount -= 1;
      if (state.pipesCount === 1) state.pipes = state.pipes[0];

      dest.emit('unpipe', this, unpipeInfo);

      return this;
    };

    // set up data events if they are asked for
    // Ensure readable listeners eventually get something
    Readable$1.prototype.on = function (ev, fn) {
      var res = stream.prototype.on.call(this, ev, fn);

      if (ev === 'data') {
        // Start flowing on next tick if stream isn't explicitly paused
        if (this._readableState.flowing !== false) this.resume();
      } else if (ev === 'readable') {
        var state = this._readableState;
        if (!state.endEmitted && !state.readableListening) {
          state.readableListening = state.needReadable = true;
          state.emittedReadable = false;
          if (!state.reading) {
            processNextickArgs.nextTick(nReadingNextTick$1, this);
          } else if (state.length) {
            emitReadable$1(this);
          }
        }
      }

      return res;
    };
    Readable$1.prototype.addListener = Readable$1.prototype.on;

    function nReadingNextTick$1(self) {
      debug$1('readable nexttick read 0');
      self.read(0);
    }

    // pause() and resume() are remnants of the legacy readable stream API
    // If the user uses them, then switch into old mode.
    Readable$1.prototype.resume = function () {
      var state = this._readableState;
      if (!state.flowing) {
        debug$1('resume');
        state.flowing = true;
        resume$1(this, state);
      }
      return this;
    };

    function resume$1(stream, state) {
      if (!state.resumeScheduled) {
        state.resumeScheduled = true;
        processNextickArgs.nextTick(resume_$1, stream, state);
      }
    }

    function resume_$1(stream, state) {
      if (!state.reading) {
        debug$1('resume read 0');
        stream.read(0);
      }

      state.resumeScheduled = false;
      state.awaitDrain = 0;
      stream.emit('resume');
      flow$1(stream);
      if (state.flowing && !state.reading) stream.read(0);
    }

    Readable$1.prototype.pause = function () {
      debug$1('call pause flowing=%j', this._readableState.flowing);
      if (false !== this._readableState.flowing) {
        debug$1('pause');
        this._readableState.flowing = false;
        this.emit('pause');
      }
      return this;
    };

    function flow$1(stream) {
      var state = stream._readableState;
      debug$1('flow', state.flowing);
      while (state.flowing && stream.read() !== null) {}
    }

    // wrap an old-style stream as the async data source.
    // This is *not* part of the readable stream interface.
    // It is an ugly unfortunate mess of history.
    Readable$1.prototype.wrap = function (stream) {
      var _this = this;

      var state = this._readableState;
      var paused = false;

      stream.on('end', function () {
        debug$1('wrapped end');
        if (state.decoder && !state.ended) {
          var chunk = state.decoder.end();
          if (chunk && chunk.length) _this.push(chunk);
        }

        _this.push(null);
      });

      stream.on('data', function (chunk) {
        debug$1('wrapped data');
        if (state.decoder) chunk = state.decoder.write(chunk);

        // don't skip over falsy values in objectMode
        if (state.objectMode && (chunk === null || chunk === undefined)) return;else if (!state.objectMode && (!chunk || !chunk.length)) return;

        var ret = _this.push(chunk);
        if (!ret) {
          paused = true;
          stream.pause();
        }
      });

      // proxy all the other methods.
      // important when wrapping filters and duplexes.
      for (var i in stream) {
        if (this[i] === undefined && typeof stream[i] === 'function') {
          this[i] = function (method) {
            return function () {
              return stream[method].apply(stream, arguments);
            };
          }(i);
        }
      }

      // proxy certain important events.
      for (var n = 0; n < kProxyEvents.length; n++) {
        stream.on(kProxyEvents[n], this.emit.bind(this, kProxyEvents[n]));
      }

      // when we try to consume some more bytes, simply unpause the
      // underlying stream.
      this._read = function (n) {
        debug$1('wrapped _read', n);
        if (paused) {
          paused = false;
          stream.resume();
        }
      };

      return this;
    };

    Object.defineProperty(Readable$1.prototype, 'readableHighWaterMark', {
      // making it explicit this property is not enumerable
      // because otherwise some prototype manipulation in
      // userland will fail
      enumerable: false,
      get: function () {
        return this._readableState.highWaterMark;
      }
    });

    // exposed for testing purposes only.
    Readable$1._fromList = fromList$1;

    // Pluck off n bytes from an array of buffers.
    // Length is the combined lengths of all the buffers in the list.
    // This function is designed to be inlinable, so please take care when making
    // changes to the function body.
    function fromList$1(n, state) {
      // nothing buffered
      if (state.length === 0) return null;

      var ret;
      if (state.objectMode) ret = state.buffer.shift();else if (!n || n >= state.length) {
        // read it all, truncate the list
        if (state.decoder) ret = state.buffer.join('');else if (state.buffer.length === 1) ret = state.buffer.head.data;else ret = state.buffer.concat(state.length);
        state.buffer.clear();
      } else {
        // read part of list
        ret = fromListPartial$1(n, state.buffer, state.decoder);
      }

      return ret;
    }

    // Extracts only enough buffered data to satisfy the amount requested.
    // This function is designed to be inlinable, so please take care when making
    // changes to the function body.
    function fromListPartial$1(n, list, hasStrings) {
      var ret;
      if (n < list.head.data.length) {
        // slice is the same for buffers and strings
        ret = list.head.data.slice(0, n);
        list.head.data = list.head.data.slice(n);
      } else if (n === list.head.data.length) {
        // first chunk is a perfect match
        ret = list.shift();
      } else {
        // result spans more than one buffer
        ret = hasStrings ? copyFromBufferString$1(n, list) : copyFromBuffer$1(n, list);
      }
      return ret;
    }

    // Copies a specified amount of characters from the list of buffered data
    // chunks.
    // This function is designed to be inlinable, so please take care when making
    // changes to the function body.
    function copyFromBufferString$1(n, list) {
      var p = list.head;
      var c = 1;
      var ret = p.data;
      n -= ret.length;
      while (p = p.next) {
        var str = p.data;
        var nb = n > str.length ? str.length : n;
        if (nb === str.length) ret += str;else ret += str.slice(0, n);
        n -= nb;
        if (n === 0) {
          if (nb === str.length) {
            ++c;
            if (p.next) list.head = p.next;else list.head = list.tail = null;
          } else {
            list.head = p;
            p.data = str.slice(nb);
          }
          break;
        }
        ++c;
      }
      list.length -= c;
      return ret;
    }

    // Copies a specified amount of bytes from the list of buffered data chunks.
    // This function is designed to be inlinable, so please take care when making
    // changes to the function body.
    function copyFromBuffer$1(n, list) {
      var ret = Buffer$4.allocUnsafe(n);
      var p = list.head;
      var c = 1;
      p.data.copy(ret);
      n -= p.data.length;
      while (p = p.next) {
        var buf = p.data;
        var nb = n > buf.length ? buf.length : n;
        buf.copy(ret, ret.length - n, 0, nb);
        n -= nb;
        if (n === 0) {
          if (nb === buf.length) {
            ++c;
            if (p.next) list.head = p.next;else list.head = list.tail = null;
          } else {
            list.head = p;
            p.data = buf.slice(nb);
          }
          break;
        }
        ++c;
      }
      list.length -= c;
      return ret;
    }

    function endReadable$1(stream) {
      var state = stream._readableState;

      // If we get here before consuming all the bytes, then that is a
      // bug in node.  Should never happen.
      if (state.length > 0) throw new Error('"endReadable()" called on non-empty stream');

      if (!state.endEmitted) {
        state.ended = true;
        processNextickArgs.nextTick(endReadableNT$1, state, stream);
      }
    }

    function endReadableNT$1(state, stream) {
      // Check that we didn't get one last unshift.
      if (!state.endEmitted && state.length === 0) {
        state.endEmitted = true;
        stream.readable = false;
        stream.emit('end');
      }
    }

    function indexOf$1(xs, x) {
      for (var i = 0, l = xs.length; i < l; i++) {
        if (xs[i] === x) return i;
      }
      return -1;
    }

    var _stream_transform = Transform$1;



    /*<replacement>*/
    var util$4 = Object.create(util);
    util$4.inherits = inherits$2;
    /*</replacement>*/

    util$4.inherits(Transform$1, _stream_duplex);

    function afterTransform$1(er, data) {
      var ts = this._transformState;
      ts.transforming = false;

      var cb = ts.writecb;

      if (!cb) {
        return this.emit('error', new Error('write callback called multiple times'));
      }

      ts.writechunk = null;
      ts.writecb = null;

      if (data != null) // single equals check for both `null` and `undefined`
        this.push(data);

      cb(er);

      var rs = this._readableState;
      rs.reading = false;
      if (rs.needReadable || rs.length < rs.highWaterMark) {
        this._read(rs.highWaterMark);
      }
    }

    function Transform$1(options) {
      if (!(this instanceof Transform$1)) return new Transform$1(options);

      _stream_duplex.call(this, options);

      this._transformState = {
        afterTransform: afterTransform$1.bind(this),
        needTransform: false,
        transforming: false,
        writecb: null,
        writechunk: null,
        writeencoding: null
      };

      // start out asking for a readable event once data is transformed.
      this._readableState.needReadable = true;

      // we have implemented the _read method, and done the other things
      // that Readable wants before the first _read call, so unset the
      // sync guard flag.
      this._readableState.sync = false;

      if (options) {
        if (typeof options.transform === 'function') this._transform = options.transform;

        if (typeof options.flush === 'function') this._flush = options.flush;
      }

      // When the writable side finishes, then flush out anything remaining.
      this.on('prefinish', prefinish$2);
    }

    function prefinish$2() {
      var _this = this;

      if (typeof this._flush === 'function') {
        this._flush(function (er, data) {
          done$1(_this, er, data);
        });
      } else {
        done$1(this, null, null);
      }
    }

    Transform$1.prototype.push = function (chunk, encoding) {
      this._transformState.needTransform = false;
      return _stream_duplex.prototype.push.call(this, chunk, encoding);
    };

    // This is the part where you do stuff!
    // override this function in implementation classes.
    // 'chunk' is an input chunk.
    //
    // Call `push(newChunk)` to pass along transformed output
    // to the readable side.  You may call 'push' zero or more times.
    //
    // Call `cb(err)` when you are done with this chunk.  If you pass
    // an error, then that'll put the hurt on the whole operation.  If you
    // never call cb(), then you'll never get another chunk.
    Transform$1.prototype._transform = function (chunk, encoding, cb) {
      throw new Error('_transform() is not implemented');
    };

    Transform$1.prototype._write = function (chunk, encoding, cb) {
      var ts = this._transformState;
      ts.writecb = cb;
      ts.writechunk = chunk;
      ts.writeencoding = encoding;
      if (!ts.transforming) {
        var rs = this._readableState;
        if (ts.needTransform || rs.needReadable || rs.length < rs.highWaterMark) this._read(rs.highWaterMark);
      }
    };

    // Doesn't matter what the args are here.
    // _transform does all the work.
    // That we got here means that the readable side wants more data.
    Transform$1.prototype._read = function (n) {
      var ts = this._transformState;

      if (ts.writechunk !== null && ts.writecb && !ts.transforming) {
        ts.transforming = true;
        this._transform(ts.writechunk, ts.writeencoding, ts.afterTransform);
      } else {
        // mark that we need a transform, so that any data that comes in
        // will get processed, now that we've asked for it.
        ts.needTransform = true;
      }
    };

    Transform$1.prototype._destroy = function (err, cb) {
      var _this2 = this;

      _stream_duplex.prototype._destroy.call(this, err, function (err2) {
        cb(err2);
        _this2.emit('close');
      });
    };

    function done$1(stream, er, data) {
      if (er) return stream.emit('error', er);

      if (data != null) // single equals check for both `null` and `undefined`
        stream.push(data);

      // if there's nothing in the write buffer, then that means
      // that nothing more will ever be provided
      if (stream._writableState.length) throw new Error('Calling transform done when ws.length != 0');

      if (stream._transformState.transforming) throw new Error('Calling transform done when still transforming');

      return stream.push(null);
    }

    var _stream_passthrough = PassThrough$1;



    /*<replacement>*/
    var util$5 = Object.create(util);
    util$5.inherits = inherits$2;
    /*</replacement>*/

    util$5.inherits(PassThrough$1, _stream_transform);

    function PassThrough$1(options) {
      if (!(this instanceof PassThrough$1)) return new PassThrough$1(options);

      _stream_transform.call(this, options);
    }

    PassThrough$1.prototype._transform = function (chunk, encoding, cb) {
      cb(null, chunk);
    };

    var readable = createCommonjsModule(function (module, exports) {
    if (process.env.READABLE_STREAM === 'disable' && Stream) {
      module.exports = Stream;
      exports = module.exports = Stream.Readable;
      exports.Readable = Stream.Readable;
      exports.Writable = Stream.Writable;
      exports.Duplex = Stream.Duplex;
      exports.Transform = Stream.Transform;
      exports.PassThrough = Stream.PassThrough;
      exports.Stream = Stream;
    } else {
      exports = module.exports = _stream_readable;
      exports.Stream = Stream || exports;
      exports.Readable = exports;
      exports.Writable = _stream_writable;
      exports.Duplex = _stream_duplex;
      exports.Transform = _stream_transform;
      exports.PassThrough = _stream_passthrough;
    }
    });
    var readable_1 = readable.Readable;
    var readable_2 = readable.Writable;
    var readable_3 = readable.Duplex;
    var readable_4 = readable.Transform;
    var readable_5 = readable.PassThrough;
    var readable_6 = readable.Stream;

    var isImplemented = function () {
    	var map, iterator, result;
    	if (typeof Map !== 'function') return false;
    	try {
    		// WebKit doesn't support arguments and crashes
    		map = new Map([['raz', 'one'], ['dwa', 'two'], ['trzy', 'three']]);
    	} catch (e) {
    		return false;
    	}
    	if (String(map) !== '[object Map]') return false;
    	if (map.size !== 3) return false;
    	if (typeof map.clear !== 'function') return false;
    	if (typeof map.delete !== 'function') return false;
    	if (typeof map.entries !== 'function') return false;
    	if (typeof map.forEach !== 'function') return false;
    	if (typeof map.get !== 'function') return false;
    	if (typeof map.has !== 'function') return false;
    	if (typeof map.keys !== 'function') return false;
    	if (typeof map.set !== 'function') return false;
    	if (typeof map.values !== 'function') return false;

    	iterator = map.entries();
    	result = iterator.next();
    	if (result.done !== false) return false;
    	if (!result.value) return false;
    	if (result.value[0] !== 'raz') return false;
    	if (result.value[1] !== 'one') return false;

    	return true;
    };

    // eslint-disable-next-line no-empty-function
    var noop$1 = function () {};

    var _undefined = noop$1(); // Support ES3 engines

    var isValue = function (val) { return val !== _undefined && val !== null; };

    var validValue = function (value) {
    	if (!isValue(value)) throw new TypeError("Cannot use null or undefined");
    	return value;
    };

    var clear = function () {
    	validValue(this).length = 0;
    	return this;
    };

    var isImplemented$1 = function () {
    	var numberIsNaN = Number.isNaN;
    	if (typeof numberIsNaN !== "function") return false;
    	return !numberIsNaN({}) && numberIsNaN(NaN) && !numberIsNaN(34);
    };

    var shim = function (value) {
    	// eslint-disable-next-line no-self-compare
    	return value !== value;
    };

    var isNan = isImplemented$1() ? Number.isNaN : shim;

    var isImplemented$2 = function () {
    	var sign = Math.sign;
    	if (typeof sign !== "function") return false;
    	return sign(10) === 1 && sign(-20) === -1;
    };

    var shim$1 = function (value) {
    	value = Number(value);
    	if (isNaN(value) || value === 0) return value;
    	return value > 0 ? 1 : -1;
    };

    var sign = isImplemented$2() ? Math.sign : shim$1;

    var abs   = Math.abs
      , floor = Math.floor;

    var toInteger = function (value) {
    	if (isNaN(value)) return 0;
    	value = Number(value);
    	if (value === 0 || !isFinite(value)) return value;
    	return sign(value) * floor(abs(value));
    };

    var max       = Math.max;

    var toPosInteger = function (value) { return max(0, toInteger(value)); };

    var indexOf$2           = Array.prototype.indexOf
      , objHasOwnProperty = Object.prototype.hasOwnProperty
      , abs$1               = Math.abs
      , floor$1             = Math.floor;

    var eIndexOf = function (searchElement/*, fromIndex*/) {
    	var i, length, fromIndex, val;
    	if (!isNan(searchElement)) return indexOf$2.apply(this, arguments);

    	length = toPosInteger(validValue(this).length);
    	fromIndex = arguments[1];
    	if (isNaN(fromIndex)) fromIndex = 0;
    	else if (fromIndex >= 0) fromIndex = floor$1(fromIndex);
    	else fromIndex = toPosInteger(this.length) - floor$1(abs$1(fromIndex));

    	for (i = fromIndex; i < length; ++i) {
    		if (objHasOwnProperty.call(this, i)) {
    			val = this[i];
    			if (isNan(val)) return i; // Jslint: ignore
    		}
    	}
    	return -1;
    };

    var create = Object.create, getPrototypeOf = Object.getPrototypeOf, plainObject = {};

    var isImplemented$3 = function (/* CustomCreate*/) {
    	var setPrototypeOf = Object.setPrototypeOf, customCreate = arguments[0] || create;
    	if (typeof setPrototypeOf !== "function") return false;
    	return getPrototypeOf(setPrototypeOf(customCreate(null), plainObject)) === plainObject;
    };

    var map = { function: true, object: true };

    var isObject$3 = function (value) { return (isValue(value) && map[typeof value]) || false; };

    var create$1 = Object.create, shim$2;

    if (!isImplemented$3()) {
    	shim$2 = shim$3;
    }

    var create_1 = (function () {
    	var nullObject, polyProps, desc;
    	if (!shim$2) return create$1;
    	if (shim$2.level !== 1) return create$1;

    	nullObject = {};
    	polyProps = {};
    	desc = { configurable: false, enumerable: false, writable: true, value: undefined };
    	Object.getOwnPropertyNames(Object.prototype).forEach(function (name) {
    		if (name === "__proto__") {
    			polyProps[name] = {
    				configurable: true,
    				enumerable: false,
    				writable: true,
    				value: undefined
    			};
    			return;
    		}
    		polyProps[name] = desc;
    	});
    	Object.defineProperties(nullObject, polyProps);

    	Object.defineProperty(shim$2, "nullPolyfill", {
    		configurable: false,
    		enumerable: false,
    		writable: false,
    		value: nullObject
    	});

    	return function (prototype, props) {
    		return create$1(prototype === null ? nullObject : prototype, props);
    	};
    })();

    var objIsPrototypeOf = Object.prototype.isPrototypeOf
      , defineProperty   = Object.defineProperty
      , nullDesc         = { configurable: true, enumerable: false, writable: true, value: undefined }
      , validate;

    validate = function (obj, prototype) {
    	validValue(obj);
    	if (prototype === null || isObject$3(prototype)) return obj;
    	throw new TypeError("Prototype must be null or an object");
    };

    var shim$3 = (function (status) {
    	var fn, set;
    	if (!status) return null;
    	if (status.level === 2) {
    		if (status.set) {
    			set = status.set;
    			fn = function (obj, prototype) {
    				set.call(validate(obj, prototype), prototype);
    				return obj;
    			};
    		} else {
    			fn = function (obj, prototype) {
    				validate(obj, prototype).__proto__ = prototype;
    				return obj;
    			};
    		}
    	} else {
    		fn = function self(obj, prototype) {
    			var isNullBase;
    			validate(obj, prototype);
    			isNullBase = objIsPrototypeOf.call(self.nullPolyfill, obj);
    			if (isNullBase) delete self.nullPolyfill.__proto__;
    			if (prototype === null) prototype = self.nullPolyfill;
    			obj.__proto__ = prototype;
    			if (isNullBase) defineProperty(self.nullPolyfill, "__proto__", nullDesc);
    			return obj;
    		};
    	}
    	return Object.defineProperty(fn, "level", {
    		configurable: false,
    		enumerable: false,
    		writable: false,
    		value: status.level
    	});
    })(
    	(function () {
    		var tmpObj1 = Object.create(null)
    		  , tmpObj2 = {}
    		  , set
    		  , desc = Object.getOwnPropertyDescriptor(Object.prototype, "__proto__");

    		if (desc) {
    			try {
    				set = desc.set; // Opera crashes at this point
    				set.call(tmpObj1, tmpObj2);
    			} catch (ignore) {}
    			if (Object.getPrototypeOf(tmpObj1) === tmpObj2) return { set: set, level: 2 };
    		}

    		tmpObj1.__proto__ = tmpObj2;
    		if (Object.getPrototypeOf(tmpObj1) === tmpObj2) return { level: 2 };

    		tmpObj1 = {};
    		tmpObj1.__proto__ = tmpObj2;
    		if (Object.getPrototypeOf(tmpObj1) === tmpObj2) return { level: 1 };

    		return false;
    	})()
    );

    var setPrototypeOf = isImplemented$3() ? Object.setPrototypeOf : shim$3;

    var validCallable = function (fn) {
    	if (typeof fn !== "function") throw new TypeError(fn + " is not a function");
    	return fn;
    };

    // ES3 safe
    var _undefined$1 = void 0;

    var is = function (value) { return value !== _undefined$1 && value !== null; };

    // prettier-ignore
    var possibleTypes = { "object": true, "function": true, "undefined": true /* document.all */ };

    var is$1 = function (value) {
    	if (!is(value)) return false;
    	return hasOwnProperty.call(possibleTypes, typeof value);
    };

    var is$2 = function (value) {
    	if (!is$1(value)) return false;
    	try {
    		if (!value.constructor) return false;
    		return value.constructor.prototype === value;
    	} catch (error) {
    		return false;
    	}
    };

    var is$3 = function (value) {
    	if (typeof value !== "function") return false;

    	if (!hasOwnProperty.call(value, "length")) return false;

    	try {
    		if (typeof value.length !== "number") return false;
    		if (typeof value.call !== "function") return false;
    		if (typeof value.apply !== "function") return false;
    	} catch (error) {
    		return false;
    	}

    	return !is$2(value);
    };

    var classRe = /^\s*class[\s{/}]/, functionToString = Function.prototype.toString;

    var is$4 = function (value) {
    	if (!is$3(value)) return false;
    	if (classRe.test(functionToString.call(value))) return false;
    	return true;
    };

    var isImplemented$4 = function () {
    	var assign = Object.assign, obj;
    	if (typeof assign !== "function") return false;
    	obj = { foo: "raz" };
    	assign(obj, { bar: "dwa" }, { trzy: "trzy" });
    	return obj.foo + obj.bar + obj.trzy === "razdwatrzy";
    };

    var isImplemented$5 = function () {
    	try {
    		Object.keys("primitive");
    		return true;
    	} catch (e) {
    		return false;
    	}
    };

    var keys$2 = Object.keys;

    var shim$4 = function (object) { return keys$2(isValue(object) ? Object(object) : object); };

    var keys$3 = isImplemented$5() ? Object.keys : shim$4;

    var max$1   = Math.max;

    var shim$5 = function (dest, src/*, …srcn*/) {
    	var error, i, length = max$1(arguments.length, 2), assign;
    	dest = Object(validValue(dest));
    	assign = function (key) {
    		try {
    			dest[key] = src[key];
    		} catch (e) {
    			if (!error) error = e;
    		}
    	};
    	for (i = 1; i < length; ++i) {
    		src = arguments[i];
    		keys$3(src).forEach(assign);
    	}
    	if (error !== undefined) throw error;
    	return dest;
    };

    var assign = isImplemented$4() ? Object.assign : shim$5;

    var forEach$1 = Array.prototype.forEach, create$2 = Object.create;

    var process$1 = function (src, obj) {
    	var key;
    	for (key in src) obj[key] = src[key];
    };

    // eslint-disable-next-line no-unused-vars
    var normalizeOptions = function (opts1/*, …options*/) {
    	var result = create$2(null);
    	forEach$1.call(arguments, function (options) {
    		if (!isValue(options)) return;
    		process$1(Object(options), result);
    	});
    	return result;
    };

    var str = "razdwatrzy";

    var isImplemented$6 = function () {
    	if (typeof str.contains !== "function") return false;
    	return str.contains("dwa") === true && str.contains("foo") === false;
    };

    var indexOf$3 = String.prototype.indexOf;

    var shim$6 = function (searchString/*, position*/) {
    	return indexOf$3.call(this, searchString, arguments[1]) > -1;
    };

    var contains = isImplemented$6() ? String.prototype.contains : shim$6;

    var d_1 = createCommonjsModule(function (module) {



    var d = (module.exports = function (dscr, value/*, options*/) {
    	var c, e, w, options, desc;
    	if (arguments.length < 2 || typeof dscr !== "string") {
    		options = value;
    		value = dscr;
    		dscr = null;
    	} else {
    		options = arguments[2];
    	}
    	if (is(dscr)) {
    		c = contains.call(dscr, "c");
    		e = contains.call(dscr, "e");
    		w = contains.call(dscr, "w");
    	} else {
    		c = w = true;
    		e = false;
    	}

    	desc = { value: value, configurable: c, enumerable: e, writable: w };
    	return !options ? desc : assign(normalizeOptions(options), desc);
    });

    d.gs = function (dscr, get, set/*, options*/) {
    	var c, e, options, desc;
    	if (typeof dscr !== "string") {
    		options = set;
    		set = get;
    		get = dscr;
    		dscr = null;
    	} else {
    		options = arguments[3];
    	}
    	if (!is(get)) {
    		get = undefined;
    	} else if (!is$4(get)) {
    		options = get;
    		get = set = undefined;
    	} else if (!is(set)) {
    		set = undefined;
    	} else if (!is$4(set)) {
    		options = set;
    		set = undefined;
    	}
    	if (is(dscr)) {
    		c = contains.call(dscr, "c");
    		e = contains.call(dscr, "e");
    	} else {
    		c = true;
    		e = false;
    	}

    	desc = { get: get, set: set, configurable: c, enumerable: e };
    	return !options ? desc : assign(normalizeOptions(options), desc);
    };
    });

    var eventEmitter = createCommonjsModule(function (module, exports) {

    var apply = Function.prototype.apply, call = Function.prototype.call
      , create = Object.create, defineProperty = Object.defineProperty
      , defineProperties = Object.defineProperties
      , hasOwnProperty = Object.prototype.hasOwnProperty
      , descriptor = { configurable: true, enumerable: false, writable: true }

      , on, once, off, emit, methods, descriptors, base;

    on = function (type, listener) {
    	var data;

    	validCallable(listener);

    	if (!hasOwnProperty.call(this, '__ee__')) {
    		data = descriptor.value = create(null);
    		defineProperty(this, '__ee__', descriptor);
    		descriptor.value = null;
    	} else {
    		data = this.__ee__;
    	}
    	if (!data[type]) data[type] = listener;
    	else if (typeof data[type] === 'object') data[type].push(listener);
    	else data[type] = [data[type], listener];

    	return this;
    };

    once = function (type, listener) {
    	var once, self;

    	validCallable(listener);
    	self = this;
    	on.call(this, type, once = function () {
    		off.call(self, type, once);
    		apply.call(listener, this, arguments);
    	});

    	once.__eeOnceListener__ = listener;
    	return this;
    };

    off = function (type, listener) {
    	var data, listeners, candidate, i;

    	validCallable(listener);

    	if (!hasOwnProperty.call(this, '__ee__')) return this;
    	data = this.__ee__;
    	if (!data[type]) return this;
    	listeners = data[type];

    	if (typeof listeners === 'object') {
    		for (i = 0; (candidate = listeners[i]); ++i) {
    			if ((candidate === listener) ||
    					(candidate.__eeOnceListener__ === listener)) {
    				if (listeners.length === 2) data[type] = listeners[i ? 0 : 1];
    				else listeners.splice(i, 1);
    			}
    		}
    	} else {
    		if ((listeners === listener) ||
    				(listeners.__eeOnceListener__ === listener)) {
    			delete data[type];
    		}
    	}

    	return this;
    };

    emit = function (type) {
    	var i, l, listener, listeners, args;

    	if (!hasOwnProperty.call(this, '__ee__')) return;
    	listeners = this.__ee__[type];
    	if (!listeners) return;

    	if (typeof listeners === 'object') {
    		l = arguments.length;
    		args = new Array(l - 1);
    		for (i = 1; i < l; ++i) args[i - 1] = arguments[i];

    		listeners = listeners.slice();
    		for (i = 0; (listener = listeners[i]); ++i) {
    			apply.call(listener, this, args);
    		}
    	} else {
    		switch (arguments.length) {
    		case 1:
    			call.call(listeners, this);
    			break;
    		case 2:
    			call.call(listeners, this, arguments[1]);
    			break;
    		case 3:
    			call.call(listeners, this, arguments[1], arguments[2]);
    			break;
    		default:
    			l = arguments.length;
    			args = new Array(l - 1);
    			for (i = 1; i < l; ++i) {
    				args[i - 1] = arguments[i];
    			}
    			apply.call(listeners, this, args);
    		}
    	}
    };

    methods = {
    	on: on,
    	once: once,
    	off: off,
    	emit: emit
    };

    descriptors = {
    	on: d_1(on),
    	once: d_1(once),
    	off: d_1(off),
    	emit: d_1(emit)
    };

    base = defineProperties({}, descriptors);

    module.exports = exports = function (o) {
    	return (o == null) ? create(base) : defineProperties(Object(o), descriptors);
    };
    exports.methods = methods;
    });
    var eventEmitter_1 = eventEmitter.methods;

    var isImplemented$7 = function () {
    	if (typeof globalThis !== "object") return false;
    	if (!globalThis) return false;
    	return globalThis.Array === Array;
    };

    var naiveFallback = function () {
    	if (typeof self === "object" && self) return self;
    	if (typeof window === "object" && window) return window;
    	throw new Error("Unable to resolve global `this`");
    };

    var implementation = (function () {
    	if (this) return this;

    	// Unexpected strict mode (may happen if e.g. bundled into ESM module)

    	// Thanks @mathiasbynens -> https://mathiasbynens.be/notes/globalthis
    	// In all ES5+ engines global object inherits from Object.prototype
    	// (if you approached one that doesn't please report)
    	try {
    		Object.defineProperty(Object.prototype, "__global__", {
    			get: function () { return this; },
    			configurable: true
    		});
    	} catch (error) {
    		// Unfortunate case of Object.prototype being sealed (via preventExtensions, seal or freeze)
    		return naiveFallback();
    	}
    	try {
    		// Safari case (window.__global__ is resolved with global context, but __global__ does not)
    		if (!__global__) return naiveFallback();
    		return __global__;
    	} finally {
    		delete Object.prototype.__global__;
    	}
    })();

    var globalThis_1 = isImplemented$7() ? globalThis : implementation;

    var validTypes = { object: true, symbol: true };

    var isImplemented$8 = function () {
    	var Symbol = globalThis_1.Symbol;
    	var symbol;
    	if (typeof Symbol !== "function") return false;
    	symbol = Symbol("test symbol");
    	try { String(symbol); }
    	catch (e) { return false; }

    	// Return 'true' also for polyfills
    	if (!validTypes[typeof Symbol.iterator]) return false;
    	if (!validTypes[typeof Symbol.toPrimitive]) return false;
    	if (!validTypes[typeof Symbol.toStringTag]) return false;

    	return true;
    };

    var isSymbol$2 = function (value) {
    	if (!value) return false;
    	if (typeof value === "symbol") return true;
    	if (!value.constructor) return false;
    	if (value.constructor.name !== "Symbol") return false;
    	return value[value.constructor.toStringTag] === "Symbol";
    };

    var validateSymbol = function (value) {
    	if (!isSymbol$2(value)) throw new TypeError(value + " is not a symbol");
    	return value;
    };

    var create$3 = Object.create, defineProperty$1 = Object.defineProperty, objPrototype = Object.prototype;

    var created = create$3(null);
    var generateName = function (desc) {
    	var postfix = 0, name, ie11BugWorkaround;
    	while (created[desc + (postfix || "")]) ++postfix;
    	desc += postfix || "";
    	created[desc] = true;
    	name = "@@" + desc;
    	defineProperty$1(
    		objPrototype,
    		name,
    		d_1.gs(null, function (value) {
    			// For IE11 issue see:
    			// https://connect.microsoft.com/IE/feedbackdetail/view/1928508/
    			//    ie11-broken-getters-on-dom-objects
    			// https://github.com/medikoo/es6-symbol/issues/12
    			if (ie11BugWorkaround) return;
    			ie11BugWorkaround = true;
    			defineProperty$1(this, name, d_1(value));
    			ie11BugWorkaround = false;
    		})
    	);
    	return name;
    };

    var NativeSymbol = globalThis_1.Symbol;

    var standardSymbols = function (SymbolPolyfill) {
    	return Object.defineProperties(SymbolPolyfill, {
    		// To ensure proper interoperability with other native functions (e.g. Array.from)
    		// fallback to eventual native implementation of given symbol
    		hasInstance: d_1(
    			"", (NativeSymbol && NativeSymbol.hasInstance) || SymbolPolyfill("hasInstance")
    		),
    		isConcatSpreadable: d_1(
    			"",
    			(NativeSymbol && NativeSymbol.isConcatSpreadable) ||
    				SymbolPolyfill("isConcatSpreadable")
    		),
    		iterator: d_1("", (NativeSymbol && NativeSymbol.iterator) || SymbolPolyfill("iterator")),
    		match: d_1("", (NativeSymbol && NativeSymbol.match) || SymbolPolyfill("match")),
    		replace: d_1("", (NativeSymbol && NativeSymbol.replace) || SymbolPolyfill("replace")),
    		search: d_1("", (NativeSymbol && NativeSymbol.search) || SymbolPolyfill("search")),
    		species: d_1("", (NativeSymbol && NativeSymbol.species) || SymbolPolyfill("species")),
    		split: d_1("", (NativeSymbol && NativeSymbol.split) || SymbolPolyfill("split")),
    		toPrimitive: d_1(
    			"", (NativeSymbol && NativeSymbol.toPrimitive) || SymbolPolyfill("toPrimitive")
    		),
    		toStringTag: d_1(
    			"", (NativeSymbol && NativeSymbol.toStringTag) || SymbolPolyfill("toStringTag")
    		),
    		unscopables: d_1(
    			"", (NativeSymbol && NativeSymbol.unscopables) || SymbolPolyfill("unscopables")
    		)
    	});
    };

    var registry = Object.create(null);

    var symbolRegistry = function (SymbolPolyfill) {
    	return Object.defineProperties(SymbolPolyfill, {
    		for: d_1(function (key) {
    			if (registry[key]) return registry[key];
    			return (registry[key] = SymbolPolyfill(String(key)));
    		}),
    		keyFor: d_1(function (symbol) {
    			var key;
    			validateSymbol(symbol);
    			for (key in registry) {
    				if (registry[key] === symbol) return key;
    			}
    			return undefined;
    		})
    	});
    };

    var NativeSymbol$1         = globalThis_1.Symbol;

    var create$4 = Object.create
      , defineProperties = Object.defineProperties
      , defineProperty$2 = Object.defineProperty;

    var SymbolPolyfill, HiddenSymbol, isNativeSafe;

    if (typeof NativeSymbol$1 === "function") {
    	try {
    		String(NativeSymbol$1());
    		isNativeSafe = true;
    	} catch (ignore) {}
    } else {
    	NativeSymbol$1 = null;
    }

    // Internal constructor (not one exposed) for creating Symbol instances.
    // This one is used to ensure that `someSymbol instanceof Symbol` always return false
    HiddenSymbol = function Symbol(description) {
    	if (this instanceof HiddenSymbol) throw new TypeError("Symbol is not a constructor");
    	return SymbolPolyfill(description);
    };

    // Exposed `Symbol` constructor
    // (returns instances of HiddenSymbol)
    var polyfill = SymbolPolyfill = function Symbol(description) {
    	var symbol;
    	if (this instanceof Symbol) throw new TypeError("Symbol is not a constructor");
    	if (isNativeSafe) return NativeSymbol$1(description);
    	symbol = create$4(HiddenSymbol.prototype);
    	description = description === undefined ? "" : String(description);
    	return defineProperties(symbol, {
    		__description__: d_1("", description),
    		__name__: d_1("", generateName(description))
    	});
    };

    standardSymbols(SymbolPolyfill);
    symbolRegistry(SymbolPolyfill);

    // Internal tweaks for real symbol producer
    defineProperties(HiddenSymbol.prototype, {
    	constructor: d_1(SymbolPolyfill),
    	toString: d_1("", function () { return this.__name__; })
    });

    // Proper implementation of methods exposed on Symbol.prototype
    // They won't be accessible on produced symbol instances as they derive from HiddenSymbol.prototype
    defineProperties(SymbolPolyfill.prototype, {
    	toString: d_1(function () { return "Symbol (" + validateSymbol(this).__description__ + ")"; }),
    	valueOf: d_1(function () { return validateSymbol(this); })
    });
    defineProperty$2(
    	SymbolPolyfill.prototype,
    	SymbolPolyfill.toPrimitive,
    	d_1("", function () {
    		var symbol = validateSymbol(this);
    		if (typeof symbol === "symbol") return symbol;
    		return symbol.toString();
    	})
    );
    defineProperty$2(SymbolPolyfill.prototype, SymbolPolyfill.toStringTag, d_1("c", "Symbol"));

    // Proper implementaton of toPrimitive and toStringTag for returned symbol instances
    defineProperty$2(
    	HiddenSymbol.prototype, SymbolPolyfill.toStringTag,
    	d_1("c", SymbolPolyfill.prototype[SymbolPolyfill.toStringTag])
    );

    // Note: It's important to define `toPrimitive` as last one, as some implementations
    // implement `toPrimitive` natively without implementing `toStringTag` (or other specified symbols)
    // And that may invoke error in definition flow:
    // See: https://github.com/medikoo/es6-symbol/issues/13#issuecomment-164146149
    defineProperty$2(
    	HiddenSymbol.prototype, SymbolPolyfill.toPrimitive,
    	d_1("c", SymbolPolyfill.prototype[SymbolPolyfill.toPrimitive])
    );

    var es6Symbol = isImplemented$8()
    	? globalThis_1.Symbol
    	: polyfill;

    var objToString = Object.prototype.toString
      , id = objToString.call((function () { return arguments; })());

    var isArguments = function (value) { return objToString.call(value) === id; };

    var objToString$1 = Object.prototype.toString, id$1 = objToString$1.call("");

    var isString$2 = function (value) {
    	return (
    		typeof value === "string" ||
    		(value &&
    			typeof value === "object" &&
    			(value instanceof String || objToString$1.call(value) === id$1)) ||
    		false
    	);
    };

    var iteratorSymbol = es6Symbol.iterator
      , isArray$5        = Array.isArray;

    var isIterable = function (value) {
    	if (!isValue(value)) return false;
    	if (isArray$5(value)) return true;
    	if (isString$2(value)) return true;
    	if (isArguments(value)) return true;
    	return typeof value[iteratorSymbol] === "function";
    };

    var validIterable = function (value) {
    	if (!isIterable(value)) throw new TypeError(value + " is not iterable");
    	return value;
    };

    var objectToString$2 = Object.prototype.toString;

    var coerce = function (value) {
    	if (!is(value)) return null;
    	if (is$1(value)) {
    		// Reject Object.prototype.toString coercion
    		var valueToString = value.toString;
    		if (typeof valueToString !== "function") return null;
    		if (valueToString === objectToString$2) return null;
    		// Note: It can be object coming from other realm, still as there's no ES3 and CSP compliant
    		// way to resolve its realm's Object.prototype.toString it's left as not addressed edge case
    	}
    	try {
    		return "" + value; // Ensure implicit coercion
    	} catch (error) {
    		return null;
    	}
    };

    var safeToString = function (value) {
    	try {
    		return value.toString();
    	} catch (error) {
    		try { return String(value); }
    		catch (error2) { return null; }
    	}
    };

    var reNewLine = /[\n\r\u2028\u2029]/g;

    var toShortString = function (value) {
    	var string = safeToString(value);
    	if (string === null) return "<Non-coercible to string value>";
    	// Trim if too long
    	if (string.length > 100) string = string.slice(0, 99) + "…";
    	// Replace eventual new lines
    	string = string.replace(reNewLine, function (char) {
    		switch (char) {
    			case "\n":
    				return "\\n";
    			case "\r":
    				return "\\r";
    			case "\u2028":
    				return "\\u2028";
    			case "\u2029":
    				return "\\u2029";
    			/* istanbul ignore next */
    			default:
    				throw new Error("Unexpected character");
    		}
    	});
    	return string;
    };

    var resolveMessage = function (message, value) {
    	return message.replace("%v", toShortString(value));
    };

    var resolveException = function (value, defaultMessage, inputOptions) {
    	if (!is$1(inputOptions)) throw new TypeError(resolveMessage(defaultMessage, value));
    	if (!is(value)) {
    		if ("default" in inputOptions) return inputOptions["default"];
    		if (inputOptions.isOptional) return null;
    	}
    	var errorMessage = coerce(inputOptions.errorMessage);
    	if (!is(errorMessage)) errorMessage = defaultMessage;
    	throw new TypeError(resolveMessage(errorMessage, value));
    };

    var ensure = function (value/*, options*/) {
    	if (is(value)) return value;
    	return resolveException(value, "Cannot use %v", arguments[1]);
    };

    var ensure$1 = function (value/*, options*/) {
    	if (is$4(value)) return value;
    	return resolveException(value, "%v is not a plain function", arguments[1]);
    };

    var isImplemented$9 = function () {
    	var from = Array.from, arr, result;
    	if (typeof from !== "function") return false;
    	arr = ["raz", "dwa"];
    	result = from(arr);
    	return Boolean(result && result !== arr && result[1] === "dwa");
    };

    var objToString$2 = Object.prototype.toString
      , isFunctionStringTag = RegExp.prototype.test.bind(/^[object [A-Za-z0-9]*Function]$/);

    var isFunction$3 = function (value) {
    	return typeof value === "function" && isFunctionStringTag(objToString$2.call(value));
    };

    var iteratorSymbol$1 = es6Symbol.iterator
      , isArray$6        = Array.isArray
      , call           = Function.prototype.call
      , desc           = { configurable: true, enumerable: true, writable: true, value: null }
      , defineProperty$3 = Object.defineProperty;

    // eslint-disable-next-line complexity, max-lines-per-function
    var shim$7 = function (arrayLike/*, mapFn, thisArg*/) {
    	var mapFn = arguments[1]
    	  , thisArg = arguments[2]
    	  , Context
    	  , i
    	  , j
    	  , arr
    	  , length
    	  , code
    	  , iterator
    	  , result
    	  , getIterator
    	  , value;

    	arrayLike = Object(validValue(arrayLike));

    	if (isValue(mapFn)) validCallable(mapFn);
    	if (!this || this === Array || !isFunction$3(this)) {
    		// Result: Plain array
    		if (!mapFn) {
    			if (isArguments(arrayLike)) {
    				// Source: Arguments
    				length = arrayLike.length;
    				if (length !== 1) return Array.apply(null, arrayLike);
    				arr = new Array(1);
    				arr[0] = arrayLike[0];
    				return arr;
    			}
    			if (isArray$6(arrayLike)) {
    				// Source: Array
    				arr = new Array((length = arrayLike.length));
    				for (i = 0; i < length; ++i) arr[i] = arrayLike[i];
    				return arr;
    			}
    		}
    		arr = [];
    	} else {
    		// Result: Non plain array
    		Context = this;
    	}

    	if (!isArray$6(arrayLike)) {
    		if ((getIterator = arrayLike[iteratorSymbol$1]) !== undefined) {
    			// Source: Iterator
    			iterator = validCallable(getIterator).call(arrayLike);
    			if (Context) arr = new Context();
    			result = iterator.next();
    			i = 0;
    			while (!result.done) {
    				value = mapFn ? call.call(mapFn, thisArg, result.value, i) : result.value;
    				if (Context) {
    					desc.value = value;
    					defineProperty$3(arr, i, desc);
    				} else {
    					arr[i] = value;
    				}
    				result = iterator.next();
    				++i;
    			}
    			length = i;
    		} else if (isString$2(arrayLike)) {
    			// Source: String
    			length = arrayLike.length;
    			if (Context) arr = new Context();
    			for (i = 0, j = 0; i < length; ++i) {
    				value = arrayLike[i];
    				if (i + 1 < length) {
    					code = value.charCodeAt(0);
    					// eslint-disable-next-line max-depth
    					if (code >= 0xd800 && code <= 0xdbff) value += arrayLike[++i];
    				}
    				value = mapFn ? call.call(mapFn, thisArg, value, j) : value;
    				if (Context) {
    					desc.value = value;
    					defineProperty$3(arr, j, desc);
    				} else {
    					arr[j] = value;
    				}
    				++j;
    			}
    			length = j;
    		}
    	}
    	if (length === undefined) {
    		// Source: array or array-like
    		length = toPosInteger(arrayLike.length);
    		if (Context) arr = new Context(length);
    		for (i = 0; i < length; ++i) {
    			value = mapFn ? call.call(mapFn, thisArg, arrayLike[i], i) : arrayLike[i];
    			if (Context) {
    				desc.value = value;
    				defineProperty$3(arr, i, desc);
    			} else {
    				arr[i] = value;
    			}
    		}
    	}
    	if (Context) {
    		desc.value = null;
    		arr.length = length;
    	}
    	return arr;
    };

    var from_1 = isImplemented$9() ? Array.from : shim$7;

    var copy = function (obj/*, propertyNames, options*/) {
    	var copy = Object(validValue(obj)), propertyNames = arguments[1], options = Object(arguments[2]);
    	if (copy !== obj && !propertyNames) return copy;
    	var result = {};
    	if (propertyNames) {
    		from_1(propertyNames, function (propertyName) {
    			if (options.ensure || propertyName in obj) result[propertyName] = obj[propertyName];
    		});
    	} else {
    		assign(result, obj);
    	}
    	return result;
    };

    var bind                    = Function.prototype.bind
      , call$1                    = Function.prototype.call
      , keys$4                    = Object.keys
      , objPropertyIsEnumerable = Object.prototype.propertyIsEnumerable;

    var _iterate = function (method, defVal) {
    	return function (obj, cb/*, thisArg, compareFn*/) {
    		var list, thisArg = arguments[2], compareFn = arguments[3];
    		obj = Object(validValue(obj));
    		validCallable(cb);

    		list = keys$4(obj);
    		if (compareFn) {
    			list.sort(typeof compareFn === "function" ? bind.call(compareFn, obj) : undefined);
    		}
    		if (typeof method !== "function") method = list[method];
    		return call$1.call(method, list, function (key, index) {
    			if (!objPropertyIsEnumerable.call(obj, key)) return defVal;
    			return call$1.call(cb, thisArg, obj[key], key, obj, index);
    		});
    	};
    };

    var forEach$2 = _iterate("forEach");

    var call$2     = Function.prototype.call;

    var map$1 = function (obj, cb/*, thisArg*/) {
    	var result = {}, thisArg = arguments[2];
    	validCallable(cb);
    	forEach$2(obj, function (value, key, targetObj, index) {
    		result[key] = call$2.call(cb, thisArg, value, key, targetObj, index);
    	});
    	return result;
    };

    var bind$1 = Function.prototype.bind
      , defineProperty$4 = Object.defineProperty
      , hasOwnProperty$3 = Object.prototype.hasOwnProperty
      , define;

    define = function (name, desc, options) {
    	var value = ensure(desc) && ensure$1(desc.value), dgs;
    	dgs = copy(desc);
    	delete dgs.writable;
    	delete dgs.value;
    	dgs.get = function () {
    		if (!options.overwriteDefinition && hasOwnProperty$3.call(this, name)) return value;
    		desc.value = bind$1.call(value, options.resolveContext ? options.resolveContext(this) : this);
    		defineProperty$4(this, name, desc);
    		return this[name];
    	};
    	return dgs;
    };

    var autoBind = function (props/*, options*/) {
    	var options = normalizeOptions(arguments[1]);
    	if (is(options.resolveContext)) ensure$1(options.resolveContext);
    	return map$1(props, function (desc, name) { return define(name, desc, options); });
    };

    var defineProperty$5 = Object.defineProperty, defineProperties$1 = Object.defineProperties, Iterator;

    var es6Iterator = Iterator = function (list, context) {
    	if (!(this instanceof Iterator)) throw new TypeError("Constructor requires 'new'");
    	defineProperties$1(this, {
    		__list__: d_1("w", validValue(list)),
    		__context__: d_1("w", context),
    		__nextIndex__: d_1("w", 0)
    	});
    	if (!context) return;
    	validCallable(context.on);
    	context.on("_add", this._onAdd);
    	context.on("_delete", this._onDelete);
    	context.on("_clear", this._onClear);
    };

    // Internal %IteratorPrototype% doesn't expose its constructor
    delete Iterator.prototype.constructor;

    defineProperties$1(
    	Iterator.prototype,
    	assign(
    		{
    			_next: d_1(function () {
    				var i;
    				if (!this.__list__) return undefined;
    				if (this.__redo__) {
    					i = this.__redo__.shift();
    					if (i !== undefined) return i;
    				}
    				if (this.__nextIndex__ < this.__list__.length) return this.__nextIndex__++;
    				this._unBind();
    				return undefined;
    			}),
    			next: d_1(function () {
    				return this._createResult(this._next());
    			}),
    			_createResult: d_1(function (i) {
    				if (i === undefined) return { done: true, value: undefined };
    				return { done: false, value: this._resolve(i) };
    			}),
    			_resolve: d_1(function (i) {
    				return this.__list__[i];
    			}),
    			_unBind: d_1(function () {
    				this.__list__ = null;
    				delete this.__redo__;
    				if (!this.__context__) return;
    				this.__context__.off("_add", this._onAdd);
    				this.__context__.off("_delete", this._onDelete);
    				this.__context__.off("_clear", this._onClear);
    				this.__context__ = null;
    			}),
    			toString: d_1(function () {
    				return "[object " + (this[es6Symbol.toStringTag] || "Object") + "]";
    			})
    		},
    		autoBind({
    			_onAdd: d_1(function (index) {
    				if (index >= this.__nextIndex__) return;
    				++this.__nextIndex__;
    				if (!this.__redo__) {
    					defineProperty$5(this, "__redo__", d_1("c", [index]));
    					return;
    				}
    				this.__redo__.forEach(function (redo, i) {
    					if (redo >= index) this.__redo__[i] = ++redo;
    				}, this);
    				this.__redo__.push(index);
    			}),
    			_onDelete: d_1(function (index) {
    				var i;
    				if (index >= this.__nextIndex__) return;
    				--this.__nextIndex__;
    				if (!this.__redo__) return;
    				i = this.__redo__.indexOf(index);
    				if (i !== -1) this.__redo__.splice(i, 1);
    				this.__redo__.forEach(function (redo, j) {
    					if (redo > index) this.__redo__[j] = --redo;
    				}, this);
    			}),
    			_onClear: d_1(function () {
    				if (this.__redo__) clear.call(this.__redo__);
    				this.__nextIndex__ = 0;
    			})
    		})
    	)
    );

    defineProperty$5(
    	Iterator.prototype,
    	es6Symbol.iterator,
    	d_1(function () {
    		return this;
    	})
    );

    var array = createCommonjsModule(function (module) {



    var defineProperty = Object.defineProperty, ArrayIterator;

    ArrayIterator = module.exports = function (arr, kind) {
    	if (!(this instanceof ArrayIterator)) throw new TypeError("Constructor requires 'new'");
    	es6Iterator.call(this, arr);
    	if (!kind) kind = "value";
    	else if (contains.call(kind, "key+value")) kind = "key+value";
    	else if (contains.call(kind, "key")) kind = "key";
    	else kind = "value";
    	defineProperty(this, "__kind__", d_1("", kind));
    };
    if (setPrototypeOf) setPrototypeOf(ArrayIterator, es6Iterator);

    // Internal %ArrayIteratorPrototype% doesn't expose its constructor
    delete ArrayIterator.prototype.constructor;

    ArrayIterator.prototype = Object.create(es6Iterator.prototype, {
    	_resolve: d_1(function (i) {
    		if (this.__kind__ === "value") return this.__list__[i];
    		if (this.__kind__ === "key+value") return [i, this.__list__[i]];
    		return i;
    	})
    });
    defineProperty(ArrayIterator.prototype, es6Symbol.toStringTag, d_1("c", "Array Iterator"));
    });

    var string = createCommonjsModule(function (module) {



    var defineProperty = Object.defineProperty, StringIterator;

    StringIterator = module.exports = function (str) {
    	if (!(this instanceof StringIterator)) throw new TypeError("Constructor requires 'new'");
    	str = String(str);
    	es6Iterator.call(this, str);
    	defineProperty(this, "__length__", d_1("", str.length));
    };
    if (setPrototypeOf) setPrototypeOf(StringIterator, es6Iterator);

    // Internal %ArrayIteratorPrototype% doesn't expose its constructor
    delete StringIterator.prototype.constructor;

    StringIterator.prototype = Object.create(es6Iterator.prototype, {
    	_next: d_1(function () {
    		if (!this.__list__) return undefined;
    		if (this.__nextIndex__ < this.__length__) return this.__nextIndex__++;
    		this._unBind();
    		return undefined;
    	}),
    	_resolve: d_1(function (i) {
    		var char = this.__list__[i], code;
    		if (this.__nextIndex__ === this.__length__) return char;
    		code = char.charCodeAt(0);
    		if (code >= 0xd800 && code <= 0xdbff) return char + this.__list__[this.__nextIndex__++];
    		return char;
    	})
    });
    defineProperty(StringIterator.prototype, es6Symbol.toStringTag, d_1("c", "String Iterator"));
    });

    var iteratorSymbol$2 = es6Symbol.iterator;

    var get = function (obj) {
    	if (typeof validIterable(obj)[iteratorSymbol$2] === "function") return obj[iteratorSymbol$2]();
    	if (isArguments(obj)) return new array(obj);
    	if (isString$2(obj)) return new string(obj);
    	return new array(obj);
    };

    var isArray$7 = Array.isArray, call$3 = Function.prototype.call, some = Array.prototype.some;

    var forOf = function (iterable, cb /*, thisArg*/) {
    	var mode, thisArg = arguments[2], result, doBreak, broken, i, length, char, code;
    	if (isArray$7(iterable) || isArguments(iterable)) mode = "array";
    	else if (isString$2(iterable)) mode = "string";
    	else iterable = get(iterable);

    	validCallable(cb);
    	doBreak = function () {
    		broken = true;
    	};
    	if (mode === "array") {
    		some.call(iterable, function (value) {
    			call$3.call(cb, thisArg, value, doBreak);
    			return broken;
    		});
    		return;
    	}
    	if (mode === "string") {
    		length = iterable.length;
    		for (i = 0; i < length; ++i) {
    			char = iterable[i];
    			if (i + 1 < length) {
    				code = char.charCodeAt(0);
    				if (code >= 0xd800 && code <= 0xdbff) char += iterable[++i];
    			}
    			call$3.call(cb, thisArg, char, doBreak);
    			if (broken) break;
    		}
    		return;
    	}
    	result = iterable.next();

    	while (!result.done) {
    		call$3.call(cb, thisArg, result.value, doBreak);
    		if (broken) return;
    		result = iterable.next();
    	}
    };

    var forEach$3 = Array.prototype.forEach, create$5 = Object.create;

    // eslint-disable-next-line no-unused-vars
    var primitiveSet = function (arg/*, …args*/) {
    	var set = create$5(null);
    	forEach$3.call(arguments, function (name) { set[name] = true; });
    	return set;
    };

    var iteratorKinds = primitiveSet('key',
    	'value', 'key+value');

    var iterator = createCommonjsModule(function (module) {

    var toStringTagSymbol = es6Symbol.toStringTag

      , defineProperties = Object.defineProperties
      , unBind = es6Iterator.prototype._unBind
      , MapIterator;

    MapIterator = module.exports = function (map, kind) {
    	if (!(this instanceof MapIterator)) return new MapIterator(map, kind);
    	es6Iterator.call(this, map.__mapKeysData__, map);
    	if (!kind || !iteratorKinds[kind]) kind = 'key+value';
    	defineProperties(this, {
    		__kind__: d_1('', kind),
    		__values__: d_1('w', map.__mapValuesData__)
    	});
    };
    if (setPrototypeOf) setPrototypeOf(MapIterator, es6Iterator);

    MapIterator.prototype = Object.create(es6Iterator.prototype, {
    	constructor: d_1(MapIterator),
    	_resolve: d_1(function (i) {
    		if (this.__kind__ === 'value') return this.__values__[i];
    		if (this.__kind__ === 'key') return this.__list__[i];
    		return [this.__list__[i], this.__values__[i]];
    	}),
    	_unBind: d_1(function () {
    		this.__values__ = null;
    		unBind.call(this);
    	}),
    	toString: d_1(function () { return '[object Map Iterator]'; })
    });
    Object.defineProperty(MapIterator.prototype, toStringTagSymbol,
    	d_1('c', 'Map Iterator'));
    });

    // Exports true if environment provides native `Map` implementation,

    var isNativeImplemented = (function () {
    	if (typeof Map === 'undefined') return false;
    	return (Object.prototype.toString.call(new Map()) === '[object Map]');
    }());

    var iterator$1       = validIterable

      , call$4 = Function.prototype.call
      , defineProperties$2 = Object.defineProperties, getPrototypeOf$1 = Object.getPrototypeOf
      , MapPoly;

    var polyfill$1 = MapPoly = function (/*iterable*/) {
    	var iterable = arguments[0], keys, values, self;
    	if (!(this instanceof MapPoly)) throw new TypeError('Constructor requires \'new\'');
    	if (isNativeImplemented && setPrototypeOf && (Map !== MapPoly)) {
    		self = setPrototypeOf(new Map(), getPrototypeOf$1(this));
    	} else {
    		self = this;
    	}
    	if (iterable != null) iterator$1(iterable);
    	defineProperties$2(self, {
    		__mapKeysData__: d_1('c', keys = []),
    		__mapValuesData__: d_1('c', values = [])
    	});
    	if (!iterable) return self;
    	forOf(iterable, function (value) {
    		var key = validValue(value)[0];
    		value = value[1];
    		if (eIndexOf.call(keys, key) !== -1) return;
    		keys.push(key);
    		values.push(value);
    	}, self);
    	return self;
    };

    if (isNativeImplemented) {
    	if (setPrototypeOf) setPrototypeOf(MapPoly, Map);
    	MapPoly.prototype = Object.create(Map.prototype, {
    		constructor: d_1(MapPoly)
    	});
    }

    eventEmitter(defineProperties$2(MapPoly.prototype, {
    	clear: d_1(function () {
    		if (!this.__mapKeysData__.length) return;
    		clear.call(this.__mapKeysData__);
    		clear.call(this.__mapValuesData__);
    		this.emit('_clear');
    	}),
    	delete: d_1(function (key) {
    		var index = eIndexOf.call(this.__mapKeysData__, key);
    		if (index === -1) return false;
    		this.__mapKeysData__.splice(index, 1);
    		this.__mapValuesData__.splice(index, 1);
    		this.emit('_delete', index, key);
    		return true;
    	}),
    	entries: d_1(function () { return new iterator(this, 'key+value'); }),
    	forEach: d_1(function (cb/*, thisArg*/) {
    		var thisArg = arguments[1], iterator, result;
    		validCallable(cb);
    		iterator = this.entries();
    		result = iterator._next();
    		while (result !== undefined) {
    			call$4.call(cb, thisArg, this.__mapValuesData__[result],
    				this.__mapKeysData__[result], this);
    			result = iterator._next();
    		}
    	}),
    	get: d_1(function (key) {
    		var index = eIndexOf.call(this.__mapKeysData__, key);
    		if (index === -1) return;
    		return this.__mapValuesData__[index];
    	}),
    	has: d_1(function (key) {
    		return (eIndexOf.call(this.__mapKeysData__, key) !== -1);
    	}),
    	keys: d_1(function () { return new iterator(this, 'key'); }),
    	set: d_1(function (key, value) {
    		var index = eIndexOf.call(this.__mapKeysData__, key), emit;
    		if (index === -1) {
    			index = this.__mapKeysData__.push(key) - 1;
    			emit = true;
    		}
    		this.__mapValuesData__[index] = value;
    		if (emit) this.emit('_add', index, key);
    		return this;
    	}),
    	size: d_1.gs(function () { return this.__mapKeysData__.length; }),
    	values: d_1(function () { return new iterator(this, 'value'); }),
    	toString: d_1(function () { return '[object Map]'; })
    }));
    Object.defineProperty(MapPoly.prototype, es6Symbol.iterator, d_1(function () {
    	return this.entries();
    }));
    Object.defineProperty(MapPoly.prototype, es6Symbol.toStringTag, d_1('c', 'Map'));

    var es6Map = isImplemented() ? Map : polyfill$1;

    /**
     * Module dependencies
     */


    var Readable$2 = readable.Readable;
    var streamsOpts = { objectMode: true };
    var defaultStoreOptions = {
      clean: true
    };

    /**
     * es6-map can preserve insertion order even if ES version is older.
     *
     * https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Map#Description
     * It should be noted that a Map which is a map of an object, especially
     * a dictionary of dictionaries, will only map to the object's insertion
     * order. In ES2015 this is ordered for objects but for older versions of
     * ES, this may be random and not ordered.
     *
     */


    /**
     * In-memory implementation of the message store
     * This can actually be saved into files.
     *
     * @param {Object} [options] - store options
     */
    function Store (options) {
      if (!(this instanceof Store)) {
        return new Store(options)
      }

      this.options = options || {};

      // Defaults
      this.options = immutable(defaultStoreOptions, options);

      this._inflights = new es6Map();
    }

    /**
     * Adds a packet to the store, a packet is
     * anything that has a messageId property.
     *
     */
    Store.prototype.put = function (packet, cb) {
      this._inflights.set(packet.messageId, packet);

      if (cb) {
        cb();
      }

      return this
    };

    /**
     * Creates a stream with all the packets in the store
     *
     */
    Store.prototype.createStream = function () {
      var stream = new Readable$2(streamsOpts);
      var destroyed = false;
      var values = [];
      var i = 0;

      this._inflights.forEach(function (value, key) {
        values.push(value);
      });

      stream._read = function () {
        if (!destroyed && i < values.length) {
          this.push(values[i++]);
        } else {
          this.push(null);
        }
      };

      stream.destroy = function () {
        if (destroyed) {
          return
        }

        var self = this;

        destroyed = true;

        process.nextTick(function () {
          self.emit('close');
        });
      };

      return stream
    };

    /**
     * deletes a packet from the store.
     */
    Store.prototype.del = function (packet, cb) {
      packet = this._inflights.get(packet.messageId);
      if (packet) {
        this._inflights.delete(packet.messageId);
        cb(null, packet);
      } else if (cb) {
        cb(new Error('missing packet'));
      }

      return this
    };

    /**
     * get a packet from the store.
     */
    Store.prototype.get = function (packet, cb) {
      packet = this._inflights.get(packet.messageId);
      if (packet) {
        cb(null, packet);
      } else if (cb) {
        cb(new Error('missing packet'));
      }

      return this
    };

    /**
     * Close the store
     */
    Store.prototype.close = function (cb) {
      if (this.options.clean) {
        this._inflights = null;
      }
      if (cb) {
        cb();
      }
    };

    var store = Store;

    var duplex = readable.Duplex;

    var safeBuffer$1 = createCommonjsModule(function (module, exports) {
    /* eslint-disable node/no-deprecated-api */

    var Buffer = bufferEs6.Buffer;

    // alternative to using Object.keys for old browsers
    function copyProps (src, dst) {
      for (var key in src) {
        dst[key] = src[key];
      }
    }
    if (Buffer.from && Buffer.alloc && Buffer.allocUnsafe && Buffer.allocUnsafeSlow) {
      module.exports = bufferEs6;
    } else {
      // Copy properties from require('buffer')
      copyProps(bufferEs6, exports);
      exports.Buffer = SafeBuffer;
    }

    function SafeBuffer (arg, encodingOrOffset, length) {
      return Buffer(arg, encodingOrOffset, length)
    }

    SafeBuffer.prototype = Object.create(Buffer.prototype);

    // Copy static methods from Buffer
    copyProps(Buffer, SafeBuffer);

    SafeBuffer.from = function (arg, encodingOrOffset, length) {
      if (typeof arg === 'number') {
        throw new TypeError('Argument must not be a number')
      }
      return Buffer(arg, encodingOrOffset, length)
    };

    SafeBuffer.alloc = function (size, fill, encoding) {
      if (typeof size !== 'number') {
        throw new TypeError('Argument must be a number')
      }
      var buf = Buffer(size);
      if (fill !== undefined) {
        if (typeof encoding === 'string') {
          buf.fill(fill, encoding);
        } else {
          buf.fill(fill);
        }
      } else {
        buf.fill(0);
      }
      return buf
    };

    SafeBuffer.allocUnsafe = function (size) {
      if (typeof size !== 'number') {
        throw new TypeError('Argument must be a number')
      }
      return Buffer(size)
    };

    SafeBuffer.allocUnsafeSlow = function (size) {
      if (typeof size !== 'number') {
        throw new TypeError('Argument must be a number')
      }
      return bufferEs6.SlowBuffer(size)
    };
    });
    var safeBuffer_1$1 = safeBuffer$1.Buffer;

    var Buffer$5       = safeBuffer$1.Buffer;


    function BufferList$2 (callback) {
      if (!(this instanceof BufferList$2))
        return new BufferList$2(callback)

      this._bufs  = [];
      this.length = 0;

      if (typeof callback == 'function') {
        this._callback = callback;

        var piper = function piper (err) {
          if (this._callback) {
            this._callback(err);
            this._callback = null;
          }
        }.bind(this);

        this.on('pipe', function onPipe (src) {
          src.on('error', piper);
        });
        this.on('unpipe', function onUnpipe (src) {
          src.removeListener('error', piper);
        });
      } else {
        this.append(callback);
      }

      duplex.call(this);
    }


    debugUtil.inherits(BufferList$2, duplex);


    BufferList$2.prototype._offset = function _offset (offset) {
      var tot = 0, i = 0, _t;
      if (offset === 0) return [ 0, 0 ]
      for (; i < this._bufs.length; i++) {
        _t = tot + this._bufs[i].length;
        if (offset < _t || i == this._bufs.length - 1)
          return [ i, offset - tot ]
        tot = _t;
      }
    };


    BufferList$2.prototype.append = function append (buf) {
      var i = 0;

      if (Buffer$5.isBuffer(buf)) {
        this._appendBuffer(buf);
      } else if (Array.isArray(buf)) {
        for (; i < buf.length; i++)
          this.append(buf[i]);
      } else if (buf instanceof BufferList$2) {
        // unwrap argument into individual BufferLists
        for (; i < buf._bufs.length; i++)
          this.append(buf._bufs[i]);
      } else if (buf != null) {
        // coerce number arguments to strings, since Buffer(number) does
        // uninitialized memory allocation
        if (typeof buf == 'number')
          buf = buf.toString();

        this._appendBuffer(Buffer$5.from(buf));
      }

      return this
    };


    BufferList$2.prototype._appendBuffer = function appendBuffer (buf) {
      this._bufs.push(buf);
      this.length += buf.length;
    };


    BufferList$2.prototype._write = function _write (buf, encoding, callback) {
      this._appendBuffer(buf);

      if (typeof callback == 'function')
        callback();
    };


    BufferList$2.prototype._read = function _read (size) {
      if (!this.length)
        return this.push(null)

      size = Math.min(size, this.length);
      this.push(this.slice(0, size));
      this.consume(size);
    };


    BufferList$2.prototype.end = function end (chunk) {
      duplex.prototype.end.call(this, chunk);

      if (this._callback) {
        this._callback(null, this.slice());
        this._callback = null;
      }
    };


    BufferList$2.prototype.get = function get (index) {
      return this.slice(index, index + 1)[0]
    };


    BufferList$2.prototype.slice = function slice (start, end) {
      if (typeof start == 'number' && start < 0)
        start += this.length;
      if (typeof end == 'number' && end < 0)
        end += this.length;
      return this.copy(null, 0, start, end)
    };


    BufferList$2.prototype.copy = function copy (dst, dstStart, srcStart, srcEnd) {
      if (typeof srcStart != 'number' || srcStart < 0)
        srcStart = 0;
      if (typeof srcEnd != 'number' || srcEnd > this.length)
        srcEnd = this.length;
      if (srcStart >= this.length)
        return dst || Buffer$5.alloc(0)
      if (srcEnd <= 0)
        return dst || Buffer$5.alloc(0)

      var copy   = !!dst
        , off    = this._offset(srcStart)
        , len    = srcEnd - srcStart
        , bytes  = len
        , bufoff = (copy && dstStart) || 0
        , start  = off[1]
        , l
        , i;

      // copy/slice everything
      if (srcStart === 0 && srcEnd == this.length) {
        if (!copy) { // slice, but full concat if multiple buffers
          return this._bufs.length === 1
            ? this._bufs[0]
            : Buffer$5.concat(this._bufs, this.length)
        }

        // copy, need to copy individual buffers
        for (i = 0; i < this._bufs.length; i++) {
          this._bufs[i].copy(dst, bufoff);
          bufoff += this._bufs[i].length;
        }

        return dst
      }

      // easy, cheap case where it's a subset of one of the buffers
      if (bytes <= this._bufs[off[0]].length - start) {
        return copy
          ? this._bufs[off[0]].copy(dst, dstStart, start, start + bytes)
          : this._bufs[off[0]].slice(start, start + bytes)
      }

      if (!copy) // a slice, we need something to copy in to
        dst = Buffer$5.allocUnsafe(len);

      for (i = off[0]; i < this._bufs.length; i++) {
        l = this._bufs[i].length - start;

        if (bytes > l) {
          this._bufs[i].copy(dst, bufoff, start);
        } else {
          this._bufs[i].copy(dst, bufoff, start, start + bytes);
          break
        }

        bufoff += l;
        bytes -= l;

        if (start)
          start = 0;
      }

      return dst
    };

    BufferList$2.prototype.shallowSlice = function shallowSlice (start, end) {
      start = start || 0;
      end = end || this.length;

      if (start < 0)
        start += this.length;
      if (end < 0)
        end += this.length;

      var startOffset = this._offset(start)
        , endOffset = this._offset(end)
        , buffers = this._bufs.slice(startOffset[0], endOffset[0] + 1);

      if (endOffset[1] == 0)
        buffers.pop();
      else
        buffers[buffers.length-1] = buffers[buffers.length-1].slice(0, endOffset[1]);

      if (startOffset[1] != 0)
        buffers[0] = buffers[0].slice(startOffset[1]);

      return new BufferList$2(buffers)
    };

    BufferList$2.prototype.toString = function toString (encoding, start, end) {
      return this.slice(start, end).toString(encoding)
    };

    BufferList$2.prototype.consume = function consume (bytes) {
      while (this._bufs.length) {
        if (bytes >= this._bufs[0].length) {
          bytes -= this._bufs[0].length;
          this.length -= this._bufs[0].length;
          this._bufs.shift();
        } else {
          this._bufs[0] = this._bufs[0].slice(bytes);
          this.length -= bytes;
          break
        }
      }
      return this
    };


    BufferList$2.prototype.duplicate = function duplicate () {
      var i = 0
        , copy = new BufferList$2();

      for (; i < this._bufs.length; i++)
        copy.append(this._bufs[i]);

      return copy
    };


    BufferList$2.prototype.destroy = function destroy () {
      this._bufs.length = 0;
      this.length = 0;
      this.push(null);
    }


    ;(function () {
      var methods = {
          'readDoubleBE' : 8
        , 'readDoubleLE' : 8
        , 'readFloatBE'  : 4
        , 'readFloatLE'  : 4
        , 'readInt32BE'  : 4
        , 'readInt32LE'  : 4
        , 'readUInt32BE' : 4
        , 'readUInt32LE' : 4
        , 'readInt16BE'  : 2
        , 'readInt16LE'  : 2
        , 'readUInt16BE' : 2
        , 'readUInt16LE' : 2
        , 'readInt8'     : 1
        , 'readUInt8'    : 1
      };

      for (var m in methods) {
        (function (m) {
          BufferList$2.prototype[m] = function (offset) {
            return this.slice(offset, offset + methods[m])[m](0)
          };
        }(m));
      }
    }());


    var bl = BufferList$2;

    function Packet () {
      this.cmd = null;
      this.retain = false;
      this.qos = 0;
      this.dup = false;
      this.length = -1;
      this.topic = null;
      this.payload = null;
    }

    var packet = Packet;

    var constants = createCommonjsModule(function (module) {

    var Buffer = safeBuffer$1.Buffer;

    /* Protocol - protocol constants */
    var protocol = module.exports;

    /* Command code => mnemonic */
    protocol.types = {
      0: 'reserved',
      1: 'connect',
      2: 'connack',
      3: 'publish',
      4: 'puback',
      5: 'pubrec',
      6: 'pubrel',
      7: 'pubcomp',
      8: 'subscribe',
      9: 'suback',
      10: 'unsubscribe',
      11: 'unsuback',
      12: 'pingreq',
      13: 'pingresp',
      14: 'disconnect',
      15: 'auth'
    };

    /* Mnemonic => Command code */
    protocol.codes = {};
    for (var k in protocol.types) {
      var v = protocol.types[k];
      protocol.codes[v] = k;
    }

    /* Header */
    protocol.CMD_SHIFT = 4;
    protocol.CMD_MASK = 0xF0;
    protocol.DUP_MASK = 0x08;
    protocol.QOS_MASK = 0x03;
    protocol.QOS_SHIFT = 1;
    protocol.RETAIN_MASK = 0x01;

    /* Length */
    protocol.LENGTH_MASK = 0x7F;
    protocol.LENGTH_FIN_MASK = 0x80;

    /* Connack */
    protocol.SESSIONPRESENT_MASK = 0x01;
    protocol.SESSIONPRESENT_HEADER = Buffer.from([protocol.SESSIONPRESENT_MASK]);
    protocol.CONNACK_HEADER = Buffer.from([protocol.codes['connack'] << protocol.CMD_SHIFT]);

    /* Connect */
    protocol.USERNAME_MASK = 0x80;
    protocol.PASSWORD_MASK = 0x40;
    protocol.WILL_RETAIN_MASK = 0x20;
    protocol.WILL_QOS_MASK = 0x18;
    protocol.WILL_QOS_SHIFT = 3;
    protocol.WILL_FLAG_MASK = 0x04;
    protocol.CLEAN_SESSION_MASK = 0x02;
    protocol.CONNECT_HEADER = Buffer.from([protocol.codes['connect'] << protocol.CMD_SHIFT]);

    /* Properties */
    protocol.properties = {
      sessionExpiryInterval: 17,
      willDelayInterval: 24,
      receiveMaximum: 33,
      maximumPacketSize: 39,
      topicAliasMaximum: 34,
      requestResponseInformation: 25,
      requestProblemInformation: 23,
      userProperties: 38,
      authenticationMethod: 21,
      authenticationData: 22,
      payloadFormatIndicator: 1,
      messageExpiryInterval: 2,
      contentType: 3,
      responseTopic: 8,
      correlationData: 9,
      maximumQoS: 36,
      retainAvailable: 37,
      assignedClientIdentifier: 18,
      reasonString: 31,
      wildcardSubscriptionAvailable: 40,
      subscriptionIdentifiersAvailable: 41,
      sharedSubscriptionAvailable: 42,
      serverKeepAlive: 19,
      responseInformation: 26,
      serverReference: 28,
      topicAlias: 35,
      subscriptionIdentifier: 11
    };
    protocol.propertiesCodes = {};
    for (var prop in protocol.properties) {
      var id = protocol.properties[prop];
      protocol.propertiesCodes[id] = prop;
    }
    protocol.propertiesTypes = {
      sessionExpiryInterval: 'int32',
      willDelayInterval: 'int32',
      receiveMaximum: 'int16',
      maximumPacketSize: 'int32',
      topicAliasMaximum: 'int16',
      requestResponseInformation: 'byte',
      requestProblemInformation: 'byte',
      userProperties: 'pair',
      authenticationMethod: 'string',
      authenticationData: 'binary',
      payloadFormatIndicator: 'byte',
      messageExpiryInterval: 'int32',
      contentType: 'string',
      responseTopic: 'string',
      correlationData: 'binary',
      maximumQoS: 'int8',
      retainAvailable: 'byte',
      assignedClientIdentifier: 'string',
      reasonString: 'string',
      wildcardSubscriptionAvailable: 'byte',
      subscriptionIdentifiersAvailable: 'byte',
      sharedSubscriptionAvailable: 'byte',
      serverKeepAlive: 'int16',
      responseInformation: 'string',
      serverReference: 'string',
      topicAlias: 'int16',
      subscriptionIdentifier: 'var'
    };

    function genHeader (type) {
      return [0, 1, 2].map(function (qos) {
        return [0, 1].map(function (dup) {
          return [0, 1].map(function (retain) {
            var buf = Buffer.alloc(1);
            buf.writeUInt8(
              protocol.codes[type] << protocol.CMD_SHIFT |
              (dup ? protocol.DUP_MASK : 0) |
              qos << protocol.QOS_SHIFT | retain, 0, true);
            return buf
          })
        })
      })
    }

    /* Publish */
    protocol.PUBLISH_HEADER = genHeader('publish');

    /* Subscribe */
    protocol.SUBSCRIBE_HEADER = genHeader('subscribe');
    protocol.SUBSCRIBE_OPTIONS_QOS_MASK = 0x03;
    protocol.SUBSCRIBE_OPTIONS_NL_MASK = 0x01;
    protocol.SUBSCRIBE_OPTIONS_NL_SHIFT = 2;
    protocol.SUBSCRIBE_OPTIONS_RAP_MASK = 0x01;
    protocol.SUBSCRIBE_OPTIONS_RAP_SHIFT = 3;
    protocol.SUBSCRIBE_OPTIONS_RH_MASK = 0x03;
    protocol.SUBSCRIBE_OPTIONS_RH_SHIFT = 4;
    protocol.SUBSCRIBE_OPTIONS_RH = [0x00, 0x10, 0x20];
    protocol.SUBSCRIBE_OPTIONS_NL = 0x04;
    protocol.SUBSCRIBE_OPTIONS_RAP = 0x08;
    protocol.SUBSCRIBE_OPTIONS_QOS = [0x00, 0x01, 0x02];

    /* Unsubscribe */
    protocol.UNSUBSCRIBE_HEADER = genHeader('unsubscribe');

    /* Confirmations */
    protocol.ACKS = {
      unsuback: genHeader('unsuback'),
      puback: genHeader('puback'),
      pubcomp: genHeader('pubcomp'),
      pubrel: genHeader('pubrel'),
      pubrec: genHeader('pubrec')
    };

    protocol.SUBACK_HEADER = Buffer.from([protocol.codes['suback'] << protocol.CMD_SHIFT]);

    /* Protocol versions */
    protocol.VERSION3 = Buffer.from([3]);
    protocol.VERSION4 = Buffer.from([4]);
    protocol.VERSION5 = Buffer.from([5]);

    /* QoS */
    protocol.QOS = [0, 1, 2].map(function (qos) {
      return Buffer.from([qos])
    });

    /* Empty packets */
    protocol.EMPTY = {
      pingreq: Buffer.from([protocol.codes['pingreq'] << 4, 0]),
      pingresp: Buffer.from([protocol.codes['pingresp'] << 4, 0]),
      disconnect: Buffer.from([protocol.codes['disconnect'] << 4, 0])
    };
    });

    /**
     * Helpers.
     */

    var s = 1000;
    var m = s * 60;
    var h = m * 60;
    var d = h * 24;
    var w = d * 7;
    var y = d * 365.25;

    /**
     * Parse or format the given `val`.
     *
     * Options:
     *
     *  - `long` verbose formatting [false]
     *
     * @param {String|Number} val
     * @param {Object} [options]
     * @throws {Error} throw an error if val is not a non-empty string or a number
     * @return {String|Number}
     * @api public
     */

    var ms = function(val, options) {
      options = options || {};
      var type = typeof val;
      if (type === 'string' && val.length > 0) {
        return parse(val);
      } else if (type === 'number' && isFinite(val)) {
        return options.long ? fmtLong(val) : fmtShort(val);
      }
      throw new Error(
        'val is not a non-empty string or a valid number. val=' +
          JSON.stringify(val)
      );
    };

    /**
     * Parse the given `str` and return milliseconds.
     *
     * @param {String} str
     * @return {Number}
     * @api private
     */

    function parse(str) {
      str = String(str);
      if (str.length > 100) {
        return;
      }
      var match = /^(-?(?:\d+)?\.?\d+) *(milliseconds?|msecs?|ms|seconds?|secs?|s|minutes?|mins?|m|hours?|hrs?|h|days?|d|weeks?|w|years?|yrs?|y)?$/i.exec(
        str
      );
      if (!match) {
        return;
      }
      var n = parseFloat(match[1]);
      var type = (match[2] || 'ms').toLowerCase();
      switch (type) {
        case 'years':
        case 'year':
        case 'yrs':
        case 'yr':
        case 'y':
          return n * y;
        case 'weeks':
        case 'week':
        case 'w':
          return n * w;
        case 'days':
        case 'day':
        case 'd':
          return n * d;
        case 'hours':
        case 'hour':
        case 'hrs':
        case 'hr':
        case 'h':
          return n * h;
        case 'minutes':
        case 'minute':
        case 'mins':
        case 'min':
        case 'm':
          return n * m;
        case 'seconds':
        case 'second':
        case 'secs':
        case 'sec':
        case 's':
          return n * s;
        case 'milliseconds':
        case 'millisecond':
        case 'msecs':
        case 'msec':
        case 'ms':
          return n;
        default:
          return undefined;
      }
    }

    /**
     * Short format for `ms`.
     *
     * @param {Number} ms
     * @return {String}
     * @api private
     */

    function fmtShort(ms) {
      var msAbs = Math.abs(ms);
      if (msAbs >= d) {
        return Math.round(ms / d) + 'd';
      }
      if (msAbs >= h) {
        return Math.round(ms / h) + 'h';
      }
      if (msAbs >= m) {
        return Math.round(ms / m) + 'm';
      }
      if (msAbs >= s) {
        return Math.round(ms / s) + 's';
      }
      return ms + 'ms';
    }

    /**
     * Long format for `ms`.
     *
     * @param {Number} ms
     * @return {String}
     * @api private
     */

    function fmtLong(ms) {
      var msAbs = Math.abs(ms);
      if (msAbs >= d) {
        return plural(ms, msAbs, d, 'day');
      }
      if (msAbs >= h) {
        return plural(ms, msAbs, h, 'hour');
      }
      if (msAbs >= m) {
        return plural(ms, msAbs, m, 'minute');
      }
      if (msAbs >= s) {
        return plural(ms, msAbs, s, 'second');
      }
      return ms + ' ms';
    }

    /**
     * Pluralization helper.
     */

    function plural(ms, msAbs, n, name) {
      var isPlural = msAbs >= n * 1.5;
      return Math.round(ms / n) + ' ' + name + (isPlural ? 's' : '');
    }

    /**
     * This is the common logic for both the Node.js and web browser
     * implementations of `debug()`.
     */

    function setup(env) {
    	createDebug.debug = createDebug;
    	createDebug.default = createDebug;
    	createDebug.coerce = coerce;
    	createDebug.disable = disable;
    	createDebug.enable = enable;
    	createDebug.enabled = enabled;
    	createDebug.humanize = ms;

    	Object.keys(env).forEach(key => {
    		createDebug[key] = env[key];
    	});

    	/**
    	* Active `debug` instances.
    	*/
    	createDebug.instances = [];

    	/**
    	* The currently active debug mode names, and names to skip.
    	*/

    	createDebug.names = [];
    	createDebug.skips = [];

    	/**
    	* Map of special "%n" handling functions, for the debug "format" argument.
    	*
    	* Valid key names are a single, lower or upper-case letter, i.e. "n" and "N".
    	*/
    	createDebug.formatters = {};

    	/**
    	* Selects a color for a debug namespace
    	* @param {String} namespace The namespace string for the for the debug instance to be colored
    	* @return {Number|String} An ANSI color code for the given namespace
    	* @api private
    	*/
    	function selectColor(namespace) {
    		let hash = 0;

    		for (let i = 0; i < namespace.length; i++) {
    			hash = ((hash << 5) - hash) + namespace.charCodeAt(i);
    			hash |= 0; // Convert to 32bit integer
    		}

    		return createDebug.colors[Math.abs(hash) % createDebug.colors.length];
    	}
    	createDebug.selectColor = selectColor;

    	/**
    	* Create a debugger with the given `namespace`.
    	*
    	* @param {String} namespace
    	* @return {Function}
    	* @api public
    	*/
    	function createDebug(namespace) {
    		let prevTime;

    		function debug(...args) {
    			// Disabled?
    			if (!debug.enabled) {
    				return;
    			}

    			const self = debug;

    			// Set `diff` timestamp
    			const curr = Number(new Date());
    			const ms = curr - (prevTime || curr);
    			self.diff = ms;
    			self.prev = prevTime;
    			self.curr = curr;
    			prevTime = curr;

    			args[0] = createDebug.coerce(args[0]);

    			if (typeof args[0] !== 'string') {
    				// Anything else let's inspect with %O
    				args.unshift('%O');
    			}

    			// Apply any `formatters` transformations
    			let index = 0;
    			args[0] = args[0].replace(/%([a-zA-Z%])/g, (match, format) => {
    				// If we encounter an escaped % then don't increase the array index
    				if (match === '%%') {
    					return match;
    				}
    				index++;
    				const formatter = createDebug.formatters[format];
    				if (typeof formatter === 'function') {
    					const val = args[index];
    					match = formatter.call(self, val);

    					// Now we need to remove `args[index]` since it's inlined in the `format`
    					args.splice(index, 1);
    					index--;
    				}
    				return match;
    			});

    			// Apply env-specific formatting (colors, etc.)
    			createDebug.formatArgs.call(self, args);

    			const logFn = self.log || createDebug.log;
    			logFn.apply(self, args);
    		}

    		debug.namespace = namespace;
    		debug.enabled = createDebug.enabled(namespace);
    		debug.useColors = createDebug.useColors();
    		debug.color = selectColor(namespace);
    		debug.destroy = destroy;
    		debug.extend = extend;
    		// Debug.formatArgs = formatArgs;
    		// debug.rawLog = rawLog;

    		// env-specific initialization logic for debug instances
    		if (typeof createDebug.init === 'function') {
    			createDebug.init(debug);
    		}

    		createDebug.instances.push(debug);

    		return debug;
    	}

    	function destroy() {
    		const index = createDebug.instances.indexOf(this);
    		if (index !== -1) {
    			createDebug.instances.splice(index, 1);
    			return true;
    		}
    		return false;
    	}

    	function extend(namespace, delimiter) {
    		const newDebug = createDebug(this.namespace + (typeof delimiter === 'undefined' ? ':' : delimiter) + namespace);
    		newDebug.log = this.log;
    		return newDebug;
    	}

    	/**
    	* Enables a debug mode by namespaces. This can include modes
    	* separated by a colon and wildcards.
    	*
    	* @param {String} namespaces
    	* @api public
    	*/
    	function enable(namespaces) {
    		createDebug.save(namespaces);

    		createDebug.names = [];
    		createDebug.skips = [];

    		let i;
    		const split = (typeof namespaces === 'string' ? namespaces : '').split(/[\s,]+/);
    		const len = split.length;

    		for (i = 0; i < len; i++) {
    			if (!split[i]) {
    				// ignore empty strings
    				continue;
    			}

    			namespaces = split[i].replace(/\*/g, '.*?');

    			if (namespaces[0] === '-') {
    				createDebug.skips.push(new RegExp('^' + namespaces.substr(1) + '$'));
    			} else {
    				createDebug.names.push(new RegExp('^' + namespaces + '$'));
    			}
    		}

    		for (i = 0; i < createDebug.instances.length; i++) {
    			const instance = createDebug.instances[i];
    			instance.enabled = createDebug.enabled(instance.namespace);
    		}
    	}

    	/**
    	* Disable debug output.
    	*
    	* @return {String} namespaces
    	* @api public
    	*/
    	function disable() {
    		const namespaces = [
    			...createDebug.names.map(toNamespace),
    			...createDebug.skips.map(toNamespace).map(namespace => '-' + namespace)
    		].join(',');
    		createDebug.enable('');
    		return namespaces;
    	}

    	/**
    	* Returns true if the given mode name is enabled, false otherwise.
    	*
    	* @param {String} name
    	* @return {Boolean}
    	* @api public
    	*/
    	function enabled(name) {
    		if (name[name.length - 1] === '*') {
    			return true;
    		}

    		let i;
    		let len;

    		for (i = 0, len = createDebug.skips.length; i < len; i++) {
    			if (createDebug.skips[i].test(name)) {
    				return false;
    			}
    		}

    		for (i = 0, len = createDebug.names.length; i < len; i++) {
    			if (createDebug.names[i].test(name)) {
    				return true;
    			}
    		}

    		return false;
    	}

    	/**
    	* Convert regexp to namespace
    	*
    	* @param {RegExp} regxep
    	* @return {String} namespace
    	* @api private
    	*/
    	function toNamespace(regexp) {
    		return regexp.toString()
    			.substring(2, regexp.toString().length - 2)
    			.replace(/\.\*\?$/, '*');
    	}

    	/**
    	* Coerce `val`.
    	*
    	* @param {Mixed} val
    	* @return {Mixed}
    	* @api private
    	*/
    	function coerce(val) {
    		if (val instanceof Error) {
    			return val.stack || val.message;
    		}
    		return val;
    	}

    	createDebug.enable(createDebug.load());

    	return createDebug;
    }

    var common = setup;

    var browser = createCommonjsModule(function (module, exports) {
    /* eslint-env browser */

    /**
     * This is the web browser implementation of `debug()`.
     */

    exports.log = log;
    exports.formatArgs = formatArgs;
    exports.save = save;
    exports.load = load;
    exports.useColors = useColors;
    exports.storage = localstorage();

    /**
     * Colors.
     */

    exports.colors = [
    	'#0000CC',
    	'#0000FF',
    	'#0033CC',
    	'#0033FF',
    	'#0066CC',
    	'#0066FF',
    	'#0099CC',
    	'#0099FF',
    	'#00CC00',
    	'#00CC33',
    	'#00CC66',
    	'#00CC99',
    	'#00CCCC',
    	'#00CCFF',
    	'#3300CC',
    	'#3300FF',
    	'#3333CC',
    	'#3333FF',
    	'#3366CC',
    	'#3366FF',
    	'#3399CC',
    	'#3399FF',
    	'#33CC00',
    	'#33CC33',
    	'#33CC66',
    	'#33CC99',
    	'#33CCCC',
    	'#33CCFF',
    	'#6600CC',
    	'#6600FF',
    	'#6633CC',
    	'#6633FF',
    	'#66CC00',
    	'#66CC33',
    	'#9900CC',
    	'#9900FF',
    	'#9933CC',
    	'#9933FF',
    	'#99CC00',
    	'#99CC33',
    	'#CC0000',
    	'#CC0033',
    	'#CC0066',
    	'#CC0099',
    	'#CC00CC',
    	'#CC00FF',
    	'#CC3300',
    	'#CC3333',
    	'#CC3366',
    	'#CC3399',
    	'#CC33CC',
    	'#CC33FF',
    	'#CC6600',
    	'#CC6633',
    	'#CC9900',
    	'#CC9933',
    	'#CCCC00',
    	'#CCCC33',
    	'#FF0000',
    	'#FF0033',
    	'#FF0066',
    	'#FF0099',
    	'#FF00CC',
    	'#FF00FF',
    	'#FF3300',
    	'#FF3333',
    	'#FF3366',
    	'#FF3399',
    	'#FF33CC',
    	'#FF33FF',
    	'#FF6600',
    	'#FF6633',
    	'#FF9900',
    	'#FF9933',
    	'#FFCC00',
    	'#FFCC33'
    ];

    /**
     * Currently only WebKit-based Web Inspectors, Firefox >= v31,
     * and the Firebug extension (any Firefox version) are known
     * to support "%c" CSS customizations.
     *
     * TODO: add a `localStorage` variable to explicitly enable/disable colors
     */

    // eslint-disable-next-line complexity
    function useColors() {
    	// NB: In an Electron preload script, document will be defined but not fully
    	// initialized. Since we know we're in Chrome, we'll just detect this case
    	// explicitly
    	if (typeof window !== 'undefined' && window.process && (window.process.type === 'renderer' || window.process.__nwjs)) {
    		return true;
    	}

    	// Internet Explorer and Edge do not support colors.
    	if (typeof navigator !== 'undefined' && navigator.userAgent && navigator.userAgent.toLowerCase().match(/(edge|trident)\/(\d+)/)) {
    		return false;
    	}

    	// Is webkit? http://stackoverflow.com/a/16459606/376773
    	// document is undefined in react-native: https://github.com/facebook/react-native/pull/1632
    	return (typeof document !== 'undefined' && document.documentElement && document.documentElement.style && document.documentElement.style.WebkitAppearance) ||
    		// Is firebug? http://stackoverflow.com/a/398120/376773
    		(typeof window !== 'undefined' && window.console && (window.console.firebug || (window.console.exception && window.console.table))) ||
    		// Is firefox >= v31?
    		// https://developer.mozilla.org/en-US/docs/Tools/Web_Console#Styling_messages
    		(typeof navigator !== 'undefined' && navigator.userAgent && navigator.userAgent.toLowerCase().match(/firefox\/(\d+)/) && parseInt(RegExp.$1, 10) >= 31) ||
    		// Double check webkit in userAgent just in case we are in a worker
    		(typeof navigator !== 'undefined' && navigator.userAgent && navigator.userAgent.toLowerCase().match(/applewebkit\/(\d+)/));
    }

    /**
     * Colorize log arguments if enabled.
     *
     * @api public
     */

    function formatArgs(args) {
    	args[0] = (this.useColors ? '%c' : '') +
    		this.namespace +
    		(this.useColors ? ' %c' : ' ') +
    		args[0] +
    		(this.useColors ? '%c ' : ' ') +
    		'+' + module.exports.humanize(this.diff);

    	if (!this.useColors) {
    		return;
    	}

    	const c = 'color: ' + this.color;
    	args.splice(1, 0, c, 'color: inherit');

    	// The final "%c" is somewhat tricky, because there could be other
    	// arguments passed either before or after the %c, so we need to
    	// figure out the correct index to insert the CSS into
    	let index = 0;
    	let lastC = 0;
    	args[0].replace(/%[a-zA-Z%]/g, match => {
    		if (match === '%%') {
    			return;
    		}
    		index++;
    		if (match === '%c') {
    			// We only are interested in the *last* %c
    			// (the user may have provided their own)
    			lastC = index;
    		}
    	});

    	args.splice(lastC, 0, c);
    }

    /**
     * Invokes `console.log()` when available.
     * No-op when `console.log` is not a "function".
     *
     * @api public
     */
    function log(...args) {
    	// This hackery is required for IE8/9, where
    	// the `console.log` function doesn't have 'apply'
    	return typeof console === 'object' &&
    		console.log &&
    		console.log(...args);
    }

    /**
     * Save `namespaces`.
     *
     * @param {String} namespaces
     * @api private
     */
    function save(namespaces) {
    	try {
    		if (namespaces) {
    			exports.storage.setItem('debug', namespaces);
    		} else {
    			exports.storage.removeItem('debug');
    		}
    	} catch (error) {
    		// Swallow
    		// XXX (@Qix-) should we be logging these?
    	}
    }

    /**
     * Load `namespaces`.
     *
     * @return {String} returns the previously persisted debug modes
     * @api private
     */
    function load() {
    	let r;
    	try {
    		r = exports.storage.getItem('debug');
    	} catch (error) {
    		// Swallow
    		// XXX (@Qix-) should we be logging these?
    	}

    	// If debug isn't set in LS, and we're in Electron, try to load $DEBUG
    	if (!r && typeof process !== 'undefined' && 'env' in process) {
    		r = process.env.DEBUG;
    	}

    	return r;
    }

    /**
     * Localstorage attempts to return the localstorage.
     *
     * This is necessary because safari throws
     * when a user disables cookies/localstorage
     * and you attempt to access it.
     *
     * @return {LocalStorage}
     * @api private
     */

    function localstorage() {
    	try {
    		// TVMLKit (Apple TV JS Runtime) does not have a window object, just localStorage in the global context
    		// The Browser also has localStorage in the global context.
    		return localStorage;
    	} catch (error) {
    		// Swallow
    		// XXX (@Qix-) should we be logging these?
    	}
    }

    module.exports = common(exports);

    const {formatters} = module.exports;

    /**
     * Map %j to `JSON.stringify()`, since no Web Inspectors do that by default.
     */

    formatters.j = function (v) {
    	try {
    		return JSON.stringify(v);
    	} catch (error) {
    		return '[UnexpectedJSONParseError]: ' + error.message;
    	}
    };
    });
    var browser_1 = browser.log;
    var browser_2 = browser.formatArgs;
    var browser_3 = browser.save;
    var browser_4 = browser.load;
    var browser_5 = browser.useColors;
    var browser_6 = browser.storage;
    var browser_7 = browser.colors;

    // MIT lisence
    // from https://github.com/substack/tty-browserify/blob/1ba769a6429d242f36226538835b4034bf6b7886/index.js

    function isatty() {
      return false;
    }

    function ReadStream() {
      throw new Error('tty.ReadStream is not implemented');
    }

    function WriteStream() {
      throw new Error('tty.ReadStream is not implemented');
    }

    var tty = {
      isatty: isatty,
      ReadStream: ReadStream,
      WriteStream: WriteStream
    };

    /*
    The MIT License (MIT)

    Copyright (c) 2016 CoderPuppy

    Permission is hereby granted, free of charge, to any person obtaining a copy
    of this software and associated documentation files (the "Software"), to deal
    in the Software without restriction, including without limitation the rights
    to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
    copies of the Software, and to permit persons to whom the Software is
    furnished to do so, subject to the following conditions:

    The above copyright notice and this permission notice shall be included in all
    copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
    IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
    FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
    AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
    LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
    OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
    SOFTWARE.

    */
    var _endianness;
    function endianness() {
      if (typeof _endianness === 'undefined') {
        var a = new ArrayBuffer(2);
        var b = new Uint8Array(a);
        var c = new Uint16Array(a);
        b[0] = 1;
        b[1] = 2;
        if (c[0] === 258) {
          _endianness = 'BE';
        } else if (c[0] === 513){
          _endianness = 'LE';
        } else {
          throw new Error('unable to figure out endianess');
        }
      }
      return _endianness;
    }

    function hostname() {
      if (typeof global.location !== 'undefined') {
        return global.location.hostname
      } else return '';
    }

    function loadavg() {
      return [];
    }

    function uptime() {
      return 0;
    }

    function freemem() {
      return Number.MAX_VALUE;
    }

    function totalmem() {
      return Number.MAX_VALUE;
    }

    function cpus() {
      return [];
    }

    function type() {
      return 'Browser';
    }

    function release () {
      if (typeof global.navigator !== 'undefined') {
        return global.navigator.appVersion;
      }
      return '';
    }

    function networkInterfaces(){}
    function getNetworkInterfaces(){}

    function tmpDir() {
      return '/tmp';
    }
    var tmpdir = tmpDir;

    var EOL = '\n';
    var require$$0 = {
      EOL: EOL,
      tmpdir: tmpdir,
      tmpDir: tmpDir,
      networkInterfaces:networkInterfaces,
      getNetworkInterfaces: getNetworkInterfaces,
      release: release,
      type: type,
      cpus: cpus,
      totalmem: totalmem,
      freemem: freemem,
      uptime: uptime,
      loadavg: loadavg,
      hostname: hostname,
      endianness: endianness,
    };

    var hasFlag = (flag, argv = process.argv) => {
    	const prefix = flag.startsWith('-') ? '' : (flag.length === 1 ? '-' : '--');
    	const position = argv.indexOf(prefix + flag);
    	const terminatorPosition = argv.indexOf('--');
    	return position !== -1 && (terminatorPosition === -1 || position < terminatorPosition);
    };

    const {env} = process;

    let forceColor;
    if (hasFlag('no-color') ||
    	hasFlag('no-colors') ||
    	hasFlag('color=false') ||
    	hasFlag('color=never')) {
    	forceColor = 0;
    } else if (hasFlag('color') ||
    	hasFlag('colors') ||
    	hasFlag('color=true') ||
    	hasFlag('color=always')) {
    	forceColor = 1;
    }

    if ('FORCE_COLOR' in env) {
    	if (env.FORCE_COLOR === 'true') {
    		forceColor = 1;
    	} else if (env.FORCE_COLOR === 'false') {
    		forceColor = 0;
    	} else {
    		forceColor = env.FORCE_COLOR.length === 0 ? 1 : Math.min(parseInt(env.FORCE_COLOR, 10), 3);
    	}
    }

    function translateLevel(level) {
    	if (level === 0) {
    		return false;
    	}

    	return {
    		level,
    		hasBasic: true,
    		has256: level >= 2,
    		has16m: level >= 3
    	};
    }

    function supportsColor(haveStream, streamIsTTY) {
    	if (forceColor === 0) {
    		return 0;
    	}

    	if (hasFlag('color=16m') ||
    		hasFlag('color=full') ||
    		hasFlag('color=truecolor')) {
    		return 3;
    	}

    	if (hasFlag('color=256')) {
    		return 2;
    	}

    	if (haveStream && !streamIsTTY && forceColor === undefined) {
    		return 0;
    	}

    	const min = forceColor || 0;

    	if (env.TERM === 'dumb') {
    		return min;
    	}

    	if (process.platform === 'win32') {
    		// Windows 10 build 10586 is the first Windows release that supports 256 colors.
    		// Windows 10 build 14931 is the first release that supports 16m/TrueColor.
    		const osRelease = require$$0.release().split('.');
    		if (
    			Number(osRelease[0]) >= 10 &&
    			Number(osRelease[2]) >= 10586
    		) {
    			return Number(osRelease[2]) >= 14931 ? 3 : 2;
    		}

    		return 1;
    	}

    	if ('CI' in env) {
    		if (['TRAVIS', 'CIRCLECI', 'APPVEYOR', 'GITLAB_CI'].some(sign => sign in env) || env.CI_NAME === 'codeship') {
    			return 1;
    		}

    		return min;
    	}

    	if ('TEAMCITY_VERSION' in env) {
    		return /^(9\.(0*[1-9]\d*)\.|\d{2,}\.)/.test(env.TEAMCITY_VERSION) ? 1 : 0;
    	}

    	if ('GITHUB_ACTIONS' in env) {
    		return 1;
    	}

    	if (env.COLORTERM === 'truecolor') {
    		return 3;
    	}

    	if ('TERM_PROGRAM' in env) {
    		const version = parseInt((env.TERM_PROGRAM_VERSION || '').split('.')[0], 10);

    		switch (env.TERM_PROGRAM) {
    			case 'iTerm.app':
    				return version >= 3 ? 3 : 2;
    			case 'Apple_Terminal':
    				return 2;
    			// No default
    		}
    	}

    	if (/-256(color)?$/i.test(env.TERM)) {
    		return 2;
    	}

    	if (/^screen|^xterm|^vt100|^vt220|^rxvt|color|ansi|cygwin|linux/i.test(env.TERM)) {
    		return 1;
    	}

    	if ('COLORTERM' in env) {
    		return 1;
    	}

    	return min;
    }

    function getSupportLevel(stream) {
    	const level = supportsColor(stream, stream && stream.isTTY);
    	return translateLevel(level);
    }

    var supportsColor_1 = {
    	supportsColor: getSupportLevel,
    	stdout: translateLevel(supportsColor(true, tty.isatty(1))),
    	stderr: translateLevel(supportsColor(true, tty.isatty(2)))
    };

    var node$1 = createCommonjsModule(function (module, exports) {
    /**
     * Module dependencies.
     */




    /**
     * This is the Node.js implementation of `debug()`.
     */

    exports.init = init;
    exports.log = log;
    exports.formatArgs = formatArgs;
    exports.save = save;
    exports.load = load;
    exports.useColors = useColors;

    /**
     * Colors.
     */

    exports.colors = [6, 2, 3, 4, 5, 1];

    try {
    	// Optional dependency (as in, doesn't need to be installed, NOT like optionalDependencies in package.json)
    	// eslint-disable-next-line import/no-extraneous-dependencies
    	const supportsColor = supportsColor_1;

    	if (supportsColor && (supportsColor.stderr || supportsColor).level >= 2) {
    		exports.colors = [
    			20,
    			21,
    			26,
    			27,
    			32,
    			33,
    			38,
    			39,
    			40,
    			41,
    			42,
    			43,
    			44,
    			45,
    			56,
    			57,
    			62,
    			63,
    			68,
    			69,
    			74,
    			75,
    			76,
    			77,
    			78,
    			79,
    			80,
    			81,
    			92,
    			93,
    			98,
    			99,
    			112,
    			113,
    			128,
    			129,
    			134,
    			135,
    			148,
    			149,
    			160,
    			161,
    			162,
    			163,
    			164,
    			165,
    			166,
    			167,
    			168,
    			169,
    			170,
    			171,
    			172,
    			173,
    			178,
    			179,
    			184,
    			185,
    			196,
    			197,
    			198,
    			199,
    			200,
    			201,
    			202,
    			203,
    			204,
    			205,
    			206,
    			207,
    			208,
    			209,
    			214,
    			215,
    			220,
    			221
    		];
    	}
    } catch (error) {
    	// Swallow - we only care if `supports-color` is available; it doesn't have to be.
    }

    /**
     * Build up the default `inspectOpts` object from the environment variables.
     *
     *   $ DEBUG_COLORS=no DEBUG_DEPTH=10 DEBUG_SHOW_HIDDEN=enabled node script.js
     */

    exports.inspectOpts = Object.keys(process.env).filter(key => {
    	return /^debug_/i.test(key);
    }).reduce((obj, key) => {
    	// Camel-case
    	const prop = key
    		.substring(6)
    		.toLowerCase()
    		.replace(/_([a-z])/g, (_, k) => {
    			return k.toUpperCase();
    		});

    	// Coerce string value into JS value
    	let val = process.env[key];
    	if (/^(yes|on|true|enabled)$/i.test(val)) {
    		val = true;
    	} else if (/^(no|off|false|disabled)$/i.test(val)) {
    		val = false;
    	} else if (val === 'null') {
    		val = null;
    	} else {
    		val = Number(val);
    	}

    	obj[prop] = val;
    	return obj;
    }, {});

    /**
     * Is stdout a TTY? Colored output is enabled when `true`.
     */

    function useColors() {
    	return 'colors' in exports.inspectOpts ?
    		Boolean(exports.inspectOpts.colors) :
    		tty.isatty(process.stderr.fd);
    }

    /**
     * Adds ANSI color escape codes if enabled.
     *
     * @api public
     */

    function formatArgs(args) {
    	const {namespace: name, useColors} = this;

    	if (useColors) {
    		const c = this.color;
    		const colorCode = '\u001B[3' + (c < 8 ? c : '8;5;' + c);
    		const prefix = `  ${colorCode};1m${name} \u001B[0m`;

    		args[0] = prefix + args[0].split('\n').join('\n' + prefix);
    		args.push(colorCode + 'm+' + module.exports.humanize(this.diff) + '\u001B[0m');
    	} else {
    		args[0] = getDate() + name + ' ' + args[0];
    	}
    }

    function getDate() {
    	if (exports.inspectOpts.hideDate) {
    		return '';
    	}
    	return new Date().toISOString() + ' ';
    }

    /**
     * Invokes `util.format()` with the specified arguments and writes to stderr.
     */

    function log(...args) {
    	return process.stderr.write(debugUtil.format(...args) + '\n');
    }

    /**
     * Save `namespaces`.
     *
     * @param {String} namespaces
     * @api private
     */
    function save(namespaces) {
    	if (namespaces) {
    		process.env.DEBUG = namespaces;
    	} else {
    		// If you set a process.env field to null or undefined, it gets cast to the
    		// string 'null' or 'undefined'. Just delete instead.
    		delete process.env.DEBUG;
    	}
    }

    /**
     * Load `namespaces`.
     *
     * @return {String} returns the previously persisted debug modes
     * @api private
     */

    function load() {
    	return process.env.DEBUG;
    }

    /**
     * Init logic for `debug` instances.
     *
     * Create a new `inspectOpts` object in case `useColors` is set
     * differently for a particular `debug` instance.
     */

    function init(debug) {
    	debug.inspectOpts = {};

    	const keys = Object.keys(exports.inspectOpts);
    	for (let i = 0; i < keys.length; i++) {
    		debug.inspectOpts[keys[i]] = exports.inspectOpts[keys[i]];
    	}
    }

    module.exports = common(exports);

    const {formatters} = module.exports;

    /**
     * Map %o to `util.inspect()`, all on a single line.
     */

    formatters.o = function (v) {
    	this.inspectOpts.colors = this.useColors;
    	return debugUtil.inspect(v, this.inspectOpts)
    		.replace(/\s*\n\s*/g, ' ');
    };

    /**
     * Map %O to `util.inspect()`, allowing multiple lines if needed.
     */

    formatters.O = function (v) {
    	this.inspectOpts.colors = this.useColors;
    	return debugUtil.inspect(v, this.inspectOpts);
    };
    });
    var node_1 = node$1.init;
    var node_2 = node$1.log;
    var node_3 = node$1.formatArgs;
    var node_4 = node$1.save;
    var node_5 = node$1.load;
    var node_6 = node$1.useColors;
    var node_7 = node$1.colors;
    var node_8 = node$1.inspectOpts;

    var src = createCommonjsModule(function (module) {
    /**
     * Detect Electron renderer / nwjs process, which is node, but we should
     * treat as a browser.
     */

    if (typeof process === 'undefined' || process.type === 'renderer' || process.browser === true || process.__nwjs) {
    	module.exports = browser;
    } else {
    	module.exports = node$1;
    }
    });

    var EE = EventEmitter.EventEmitter;


    var debug$2 = src('mqtt-packet:parser');

    function Parser (opt) {
      if (!(this instanceof Parser)) return new Parser(opt)

      this.settings = opt || {};

      this._states = [
        '_parseHeader',
        '_parseLength',
        '_parsePayload',
        '_newPacket'
      ];

      this._resetState();
    }

    inherits$2(Parser, EE);

    Parser.prototype._resetState = function () {
      debug$2('_resetState: resetting packet, error, _list, and _stateCounter');
      this.packet = new packet();
      this.error = null;
      this._list = bl();
      this._stateCounter = 0;
    };

    Parser.prototype.parse = function (buf) {
      if (this.error) this._resetState();

      this._list.append(buf);
      debug$2('parse: current state: %s', this._states[this._stateCounter]);
      while ((this.packet.length !== -1 || this._list.length > 0) &&
      this[this._states[this._stateCounter]]() &&
      !this.error) {
        this._stateCounter++;
        debug$2('parse: state complete. _stateCounter is now: %d', this._stateCounter);
        debug$2('parse: packet.length: %d, buffer list length: %d', this.packet.length, this._list.length);
        if (this._stateCounter >= this._states.length) this._stateCounter = 0;
      }
      debug$2('parse: exited while loop. packet: %d, buffer list length: %d', this.packet.length, this._list.length);
      return this._list.length
    };

    Parser.prototype._parseHeader = function () {
      // There is at least one byte in the buffer
      var zero = this._list.readUInt8(0);
      this.packet.cmd = constants.types[zero >> constants.CMD_SHIFT];
      this.packet.retain = (zero & constants.RETAIN_MASK) !== 0;
      this.packet.qos = (zero >> constants.QOS_SHIFT) & constants.QOS_MASK;
      this.packet.dup = (zero & constants.DUP_MASK) !== 0;
      debug$2('_parseHeader: packet: %o', this.packet);

      this._list.consume(1);

      return true
    };

    Parser.prototype._parseLength = function () {
      // There is at least one byte in the list
      var result = this._parseVarByteNum(true);

      if (result) {
        this.packet.length = result.value;
        this._list.consume(result.bytes);
      }
      debug$2('_parseLength %d', result.value);
      return !!result
    };

    Parser.prototype._parsePayload = function () {
      debug$2('_parsePayload: payload %O', this._list);
      var result = false;

      // Do we have a payload? Do we have enough data to complete the payload?
      // PINGs have no payload
      if (this.packet.length === 0 || this._list.length >= this.packet.length) {
        this._pos = 0;

        switch (this.packet.cmd) {
          case 'connect':
            this._parseConnect();
            break
          case 'connack':
            this._parseConnack();
            break
          case 'publish':
            this._parsePublish();
            break
          case 'puback':
          case 'pubrec':
          case 'pubrel':
          case 'pubcomp':
            this._parseConfirmation();
            break
          case 'subscribe':
            this._parseSubscribe();
            break
          case 'suback':
            this._parseSuback();
            break
          case 'unsubscribe':
            this._parseUnsubscribe();
            break
          case 'unsuback':
            this._parseUnsuback();
            break
          case 'pingreq':
          case 'pingresp':
            // These are empty, nothing to do
            break
          case 'disconnect':
            this._parseDisconnect();
            break
          case 'auth':
            this._parseAuth();
            break
          default:
            this._emitError(new Error('Not supported'));
        }

        result = true;
      }
      debug$2('_parsePayload complete result: %s', result);
      return result
    };

    Parser.prototype._parseConnect = function () {
      debug$2('_parseConnect');
      var protocolId; // Protocol ID
      var clientId; // Client ID
      var topic; // Will topic
      var payload; // Will payload
      var password; // Password
      var username; // Username
      var flags = {};
      var packet = this.packet;

      // Parse protocolId
      protocolId = this._parseString();

      if (protocolId === null) return this._emitError(new Error('Cannot parse protocolId'))
      if (protocolId !== 'MQTT' && protocolId !== 'MQIsdp') {
        return this._emitError(new Error('Invalid protocolId'))
      }

      packet.protocolId = protocolId;

      // Parse constants version number
      if (this._pos >= this._list.length) return this._emitError(new Error('Packet too short'))

      packet.protocolVersion = this._list.readUInt8(this._pos);

      if (packet.protocolVersion !== 3 && packet.protocolVersion !== 4 && packet.protocolVersion !== 5) {
        return this._emitError(new Error('Invalid protocol version'))
      }

      this._pos++;

      if (this._pos >= this._list.length) {
        return this._emitError(new Error('Packet too short'))
      }

      // Parse connect flags
      flags.username = (this._list.readUInt8(this._pos) & constants.USERNAME_MASK);
      flags.password = (this._list.readUInt8(this._pos) & constants.PASSWORD_MASK);
      flags.will = (this._list.readUInt8(this._pos) & constants.WILL_FLAG_MASK);

      if (flags.will) {
        packet.will = {};
        packet.will.retain = (this._list.readUInt8(this._pos) & constants.WILL_RETAIN_MASK) !== 0;
        packet.will.qos = (this._list.readUInt8(this._pos) &
                              constants.WILL_QOS_MASK) >> constants.WILL_QOS_SHIFT;
      }

      packet.clean = (this._list.readUInt8(this._pos) & constants.CLEAN_SESSION_MASK) !== 0;
      this._pos++;

      // Parse keepalive
      packet.keepalive = this._parseNum();
      if (packet.keepalive === -1) return this._emitError(new Error('Packet too short'))

      // parse properties
      if (packet.protocolVersion === 5) {
        var properties = this._parseProperties();
        if (Object.getOwnPropertyNames(properties).length) {
          packet.properties = properties;
        }
      }
      // Parse clientId
      clientId = this._parseString();
      if (clientId === null) return this._emitError(new Error('Packet too short'))
      packet.clientId = clientId;
      debug$2('_parseConnect: packet.clientId: %s', packet.clientId);

      if (flags.will) {
        if (packet.protocolVersion === 5) {
          var willProperties = this._parseProperties();
          if (Object.getOwnPropertyNames(willProperties).length) {
            packet.will.properties = willProperties;
          }
        }
        // Parse will topic
        topic = this._parseString();
        if (topic === null) return this._emitError(new Error('Cannot parse will topic'))
        packet.will.topic = topic;
        debug$2('_parseConnect: packet.will.topic: %s', packet.will.topic);

        // Parse will payload
        payload = this._parseBuffer();
        if (payload === null) return this._emitError(new Error('Cannot parse will payload'))
        packet.will.payload = payload;
        debug$2('_parseConnect: packet.will.paylaod: %s', packet.will.payload);
      }

      // Parse username
      if (flags.username) {
        username = this._parseString();
        if (username === null) return this._emitError(new Error('Cannot parse username'))
        packet.username = username;
        debug$2('_parseConnect: packet.username: %s', packet.username);
      }

      // Parse password
      if (flags.password) {
        password = this._parseBuffer();
        if (password === null) return this._emitError(new Error('Cannot parse password'))
        packet.password = password;
      }
      // need for right parse auth packet and self set up
      this.settings = packet;
      debug$2('_parseConnect: complete');
      return packet
    };

    Parser.prototype._parseConnack = function () {
      debug$2('_parseConnack');
      var packet = this.packet;

      if (this._list.length < 2) return null

      packet.sessionPresent = !!(this._list.readUInt8(this._pos++) & constants.SESSIONPRESENT_MASK);
      if (this.settings.protocolVersion === 5) {
        packet.reasonCode = this._list.readUInt8(this._pos++);
      } else {
        packet.returnCode = this._list.readUInt8(this._pos++);
      }

      if (packet.returnCode === -1 || packet.reasonCode === -1) return this._emitError(new Error('Cannot parse return code'))
      // mqtt 5 properties
      if (this.settings.protocolVersion === 5) {
        var properties = this._parseProperties();
        if (Object.getOwnPropertyNames(properties).length) {
          packet.properties = properties;
        }
      }
      debug$2('_parseConnack: complete');
    };

    Parser.prototype._parsePublish = function () {
      debug$2('_parsePublish');
      var packet = this.packet;
      packet.topic = this._parseString();

      if (packet.topic === null) return this._emitError(new Error('Cannot parse topic'))

      // Parse messageId
      if (packet.qos > 0) if (!this._parseMessageId()) { return }

      // Properties mqtt 5
      if (this.settings.protocolVersion === 5) {
        var properties = this._parseProperties();
        if (Object.getOwnPropertyNames(properties).length) {
          packet.properties = properties;
        }
      }

      packet.payload = this._list.slice(this._pos, packet.length);
      debug$2('_parsePublish: payload from buffer list: %o', packet.payload);
    };

    Parser.prototype._parseSubscribe = function () {
      debug$2('_parseSubscribe');
      var packet = this.packet;
      var topic;
      var options;
      var qos;
      var rh;
      var rap;
      var nl;
      var subscription;

      if (packet.qos !== 1) {
        return this._emitError(new Error('Wrong subscribe header'))
      }

      packet.subscriptions = [];

      if (!this._parseMessageId()) { return }

      // Properties mqtt 5
      if (this.settings.protocolVersion === 5) {
        var properties = this._parseProperties();
        if (Object.getOwnPropertyNames(properties).length) {
          packet.properties = properties;
        }
      }

      while (this._pos < packet.length) {
        // Parse topic
        topic = this._parseString();
        if (topic === null) return this._emitError(new Error('Cannot parse topic'))
        if (this._pos >= packet.length) return this._emitError(new Error('Malformed Subscribe Payload'))

        options = this._parseByte();
        qos = options & constants.SUBSCRIBE_OPTIONS_QOS_MASK;
        nl = ((options >> constants.SUBSCRIBE_OPTIONS_NL_SHIFT) & constants.SUBSCRIBE_OPTIONS_NL_MASK) !== 0;
        rap = ((options >> constants.SUBSCRIBE_OPTIONS_RAP_SHIFT) & constants.SUBSCRIBE_OPTIONS_RAP_MASK) !== 0;
        rh = (options >> constants.SUBSCRIBE_OPTIONS_RH_SHIFT) & constants.SUBSCRIBE_OPTIONS_RH_MASK;

        subscription = { topic: topic, qos: qos };

        // mqtt 5 options
        if (this.settings.protocolVersion === 5) {
          subscription.nl = nl;
          subscription.rap = rap;
          subscription.rh = rh;
        }

        // Push pair to subscriptions
        debug$2('_parseSubscribe: push subscription `%s` to subscription', subscription);
        packet.subscriptions.push(subscription);
      }
    };

    Parser.prototype._parseSuback = function () {
      debug$2('_parseSuback');
      var packet = this.packet;
      this.packet.granted = [];

      if (!this._parseMessageId()) { return }

      // Properties mqtt 5
      if (this.settings.protocolVersion === 5) {
        var properties = this._parseProperties();
        if (Object.getOwnPropertyNames(properties).length) {
          packet.properties = properties;
        }
      }

      // Parse granted QoSes
      while (this._pos < this.packet.length) {
        this.packet.granted.push(this._list.readUInt8(this._pos++));
      }
    };

    Parser.prototype._parseUnsubscribe = function () {
      debug$2('_parseUnsubscribe');
      var packet = this.packet;

      packet.unsubscriptions = [];

      // Parse messageId
      if (!this._parseMessageId()) { return }

      // Properties mqtt 5
      if (this.settings.protocolVersion === 5) {
        var properties = this._parseProperties();
        if (Object.getOwnPropertyNames(properties).length) {
          packet.properties = properties;
        }
      }

      while (this._pos < packet.length) {
        var topic;

        // Parse topic
        topic = this._parseString();
        if (topic === null) return this._emitError(new Error('Cannot parse topic'))

        // Push topic to unsubscriptions
        debug$2('_parseUnsubscribe: push topic `%s` to unsubscriptions', topic);
        packet.unsubscriptions.push(topic);
      }
    };

    Parser.prototype._parseUnsuback = function () {
      debug$2('_parseUnsuback');
      var packet = this.packet;
      if (!this._parseMessageId()) return this._emitError(new Error('Cannot parse messageId'))
      // Properties mqtt 5
      if (this.settings.protocolVersion === 5) {
        var properties = this._parseProperties();
        if (Object.getOwnPropertyNames(properties).length) {
          packet.properties = properties;
        }
        // Parse granted QoSes
        packet.granted = [];
        while (this._pos < this.packet.length) {
          this.packet.granted.push(this._list.readUInt8(this._pos++));
        }
      }
    };

    // parse packets like puback, pubrec, pubrel, pubcomp
    Parser.prototype._parseConfirmation = function () {
      debug$2('_parseConfirmation: packet.cmd: `%s`', this.packet.cmd);
      var packet = this.packet;

      this._parseMessageId();

      if (this.settings.protocolVersion === 5) {
        if (packet.length > 2) {
          // response code
          packet.reasonCode = this._parseByte();
          debug$2('_parseConfirmation: packet.reasonCode `%d`', packet.reasonCode);
        }

        if (packet.length > 3) {
          // properies mqtt 5
          var properties = this._parseProperties();
          if (Object.getOwnPropertyNames(properties).length) {
            packet.properties = properties;
          }
        }
      }

      return true
    };

    // parse disconnect packet
    Parser.prototype._parseDisconnect = function () {
      var packet = this.packet;
      debug$2('_parseDisconnect');

      if (this.settings.protocolVersion === 5) {
        // response code
        packet.reasonCode = this._parseByte();
        // properies mqtt 5
        var properties = this._parseProperties();
        if (Object.getOwnPropertyNames(properties).length) {
          packet.properties = properties;
        }
      }

      debug$2('_parseDisconnect result: true');
      return true
    };

    // parse auth packet
    Parser.prototype._parseAuth = function () {
      debug$2('_parseAuth');
      var packet = this.packet;

      if (this.settings.protocolVersion !== 5) {
        return this._emitError(new Error('Not supported auth packet for this version MQTT'))
      }

      // response code
      packet.reasonCode = this._parseByte();
      // properies mqtt 5
      var properties = this._parseProperties();
      if (Object.getOwnPropertyNames(properties).length) {
        packet.properties = properties;
      }

      debug$2('_parseAuth: result: true');
      return true
    };

    Parser.prototype._parseMessageId = function () {
      var packet = this.packet;

      packet.messageId = this._parseNum();

      if (packet.messageId === null) {
        this._emitError(new Error('Cannot parse messageId'));
        return false
      }

      debug$2('_parseMessageId: packet.messageId %d', packet.messageId);
      return true
    };

    Parser.prototype._parseString = function (maybeBuffer) {
      var length = this._parseNum();
      var result;
      var end = length + this._pos;

      if (length === -1 || end > this._list.length || end > this.packet.length) return null

      result = this._list.toString('utf8', this._pos, end);
      this._pos += length;
      debug$2('_parseString: result: %s', result);
      return result
    };

    Parser.prototype._parseStringPair = function () {
      debug$2('_parseStringPair');
      return {
        name: this._parseString(),
        value: this._parseString()
      }
    };

    Parser.prototype._parseBuffer = function () {
      var length = this._parseNum();
      var result;
      var end = length + this._pos;

      if (length === -1 || end > this._list.length || end > this.packet.length) return null

      result = this._list.slice(this._pos, end);

      this._pos += length;
      debug$2('_parseBuffer: result: %o', result);
      return result
    };

    Parser.prototype._parseNum = function () {
      if (this._list.length - this._pos < 2) return -1

      var result = this._list.readUInt16BE(this._pos);
      this._pos += 2;
      debug$2('_parseNum: result: %s', result);
      return result
    };

    Parser.prototype._parse4ByteNum = function () {
      if (this._list.length - this._pos < 4) return -1

      var result = this._list.readUInt32BE(this._pos);
      this._pos += 4;
      debug$2('_parse4ByteNum: result: %s', result);
      return result
    };

    Parser.prototype._parseVarByteNum = function (fullInfoFlag) {
      debug$2('_parseVarByteNum');
      var bytes = 0;
      var mul = 1;
      var length = 0;
      var result = true;
      var current;
      var padding = this._pos ? this._pos : 0;

      while (bytes < 5) {
        current = this._list.readUInt8(padding + bytes++);
        length += mul * (current & constants.LENGTH_MASK);
        mul *= 0x80;

        if ((current & constants.LENGTH_FIN_MASK) === 0) break
        if (this._list.length <= bytes) {
          result = false;
          break
        }
      }

      if (padding) {
        this._pos += bytes;
      }

      result = result
        ? fullInfoFlag ? {
          bytes: bytes,
          value: length
        } : length
        : false;

      debug$2('_parseVarByteNum: result: %o', result);
      return result
    };

    Parser.prototype._parseByte = function () {
      var result = this._list.readUInt8(this._pos);
      this._pos++;
      debug$2('_parseByte: result: %o', result);
      return result
    };

    Parser.prototype._parseByType = function (type) {
      debug$2('_parseByType: type: %s', type);
      switch (type) {
        case 'byte': {
          return this._parseByte() !== 0
        }
        case 'int8': {
          return this._parseByte()
        }
        case 'int16': {
          return this._parseNum()
        }
        case 'int32': {
          return this._parse4ByteNum()
        }
        case 'var': {
          return this._parseVarByteNum()
        }
        case 'string': {
          return this._parseString()
        }
        case 'pair': {
          return this._parseStringPair()
        }
        case 'binary': {
          return this._parseBuffer()
        }
      }
    };

    Parser.prototype._parseProperties = function () {
      debug$2('_parseProperties');
      var length = this._parseVarByteNum();
      var start = this._pos;
      var end = start + length;
      var result = {};
      while (this._pos < end) {
        var type = this._parseByte();
        var name = constants.propertiesCodes[type];
        if (!name) {
          this._emitError(new Error('Unknown property'));
          return false
        }
        // user properties process
        if (name === 'userProperties') {
          if (!result[name]) {
            result[name] = {};
          }
          var currentUserProperty = this._parseByType(constants.propertiesTypes[name]);
          if (result[name][currentUserProperty.name]) {
            if (Array.isArray(result[name][currentUserProperty.name])) {
              result[name][currentUserProperty.name].push(currentUserProperty.value);
            } else {
              var currentValue = result[name][currentUserProperty.name];
              result[name][currentUserProperty.name] = [currentValue];
              result[name][currentUserProperty.name].push(currentUserProperty.value);
            }
          } else {
            result[name][currentUserProperty.name] = currentUserProperty.value;
          }
          continue
        }
        if (result[name]) {
          if (Array.isArray(result[name])) {
            result[name].push(this._parseByType(constants.propertiesTypes[name]));
          } else {
            result[name] = [result[name]];
            result[name].push(this._parseByType(constants.propertiesTypes[name]));
          }
        } else {
          result[name] = this._parseByType(constants.propertiesTypes[name]);
        }
      }
      return result
    };

    Parser.prototype._newPacket = function () {
      debug$2('_newPacket');
      if (this.packet) {
        this._list.consume(this.packet.length);
        debug$2('_newPacket: parser emit packet: packet.cmd: %s, packet.payload: %s, packet.length: %d', this.packet.cmd, this.packet.payload, this.packet.length);
        this.emit('packet', this.packet);
      }
      debug$2('_newPacket: new packet');
      this.packet = new packet();

      this._pos = 0;

      return true
    };

    Parser.prototype._emitError = function (err) {
      debug$2('_emitError');
      this.error = err;
      this.emit('error', err);
    };

    var parser = Parser;

    var Buffer$6 = safeBuffer$1.Buffer;
    var max$2 = 65536;
    var cache = {};

    function generateBuffer (i) {
      var buffer = Buffer$6.allocUnsafe(2);
      buffer.writeUInt8(i >> 8, 0);
      buffer.writeUInt8(i & 0x00FF, 0 + 1);

      return buffer
    }

    function generateCache () {
      for (var i = 0; i < max$2; i++) {
        cache[i] = generateBuffer(i);
      }
    }

    /**
     * calcVariableByteIntLength - calculate the variable byte integer
     * length field
     *
     * @api private
     */
    function calcVariableByteIntLength (length) {
      if (length >= 0 && length < 128) return 1
      else if (length >= 128 && length < 16384) return 2
      else if (length >= 16384 && length < 2097152) return 3
      else if (length >= 2097152 && length < 268435456) return 4
      else return 0
    }

    function genBufVariableByteInt (num) {
      var digit = 0;
      var pos = 0;
      var length = calcVariableByteIntLength(num);
      var buffer = Buffer$6.allocUnsafe(length);

      do {
        digit = num % 128 | 0;
        num = num / 128 | 0;
        if (num > 0) digit = digit | 0x80;

        buffer.writeUInt8(digit, pos++);
      } while (num > 0)

      return {
        data: buffer,
        length: length
      }
    }

    function generate4ByteBuffer (num) {
      var buffer = Buffer$6.allocUnsafe(4);
      buffer.writeUInt32BE(num, 0);
      return buffer
    }

    var numbers = {
      cache: cache,
      generateCache: generateCache,
      generateNumber: generateBuffer,
      genBufVariableByteInt: genBufVariableByteInt,
      generate4ByteBuffer: generate4ByteBuffer
    };

    var Buffer$7 = safeBuffer$1.Buffer;
    var empty$2 = Buffer$7.allocUnsafe(0);
    var zeroBuf = Buffer$7.from([0]);

    var nextTick$1 = processNextickArgs.nextTick;
    var debug$3 = src('mqtt-packet:writeToStream');

    var numCache = numbers.cache;
    var generateNumber = numbers.generateNumber;
    var generateCache$1 = numbers.generateCache;
    var genBufVariableByteInt$1 = numbers.genBufVariableByteInt;
    var generate4ByteBuffer$1 = numbers.generate4ByteBuffer;
    var writeNumber = writeNumberCached;
    var toGenerate = true;

    function generate (packet, stream, opts) {
      debug$3('generate called');
      if (stream.cork) {
        stream.cork();
        nextTick$1(uncork, stream);
      }

      if (toGenerate) {
        toGenerate = false;
        generateCache$1();
      }
      debug$3('generate: packet.cmd: %s', packet.cmd);
      switch (packet.cmd) {
        case 'connect':
          return connect(packet, stream)
        case 'connack':
          return connack(packet, stream, opts)
        case 'publish':
          return publish(packet, stream, opts)
        case 'puback':
        case 'pubrec':
        case 'pubrel':
        case 'pubcomp':
          return confirmation(packet, stream, opts)
        case 'subscribe':
          return subscribe(packet, stream, opts)
        case 'suback':
          return suback(packet, stream, opts)
        case 'unsubscribe':
          return unsubscribe(packet, stream, opts)
        case 'unsuback':
          return unsuback(packet, stream, opts)
        case 'pingreq':
        case 'pingresp':
          return emptyPacket(packet, stream)
        case 'disconnect':
          return disconnect(packet, stream, opts)
        case 'auth':
          return auth(packet, stream, opts)
        default:
          stream.emit('error', new Error('Unknown command'));
          return false
      }
    }
    /**
     * Controls numbers cache.
     * Set to "false" to allocate buffers on-the-flight instead of pre-generated cache
     */
    Object.defineProperty(generate, 'cacheNumbers', {
      get: function () {
        return writeNumber === writeNumberCached
      },
      set: function (value) {
        if (value) {
          if (!numCache || Object.keys(numCache).length === 0) toGenerate = true;
          writeNumber = writeNumberCached;
        } else {
          toGenerate = false;
          writeNumber = writeNumberGenerated;
        }
      }
    });

    function uncork (stream) {
      stream.uncork();
    }

    function connect (packet, stream, opts) {
      var settings = packet || {};
      var protocolId = settings.protocolId || 'MQTT';
      var protocolVersion = settings.protocolVersion || 4;
      var will = settings.will;
      var clean = settings.clean;
      var keepalive = settings.keepalive || 0;
      var clientId = settings.clientId || '';
      var username = settings.username;
      var password = settings.password;
      /* mqtt5 new oprions */
      var properties = settings.properties;

      if (clean === undefined) clean = true;

      var length = 0;

      // Must be a string and non-falsy
      if (!protocolId ||
         (typeof protocolId !== 'string' && !Buffer$7.isBuffer(protocolId))) {
        stream.emit('error', new Error('Invalid protocolId'));
        return false
      } else length += protocolId.length + 2;

      // Must be 3 or 4 or 5
      if (protocolVersion !== 3 && protocolVersion !== 4 && protocolVersion !== 5) {
        stream.emit('error', new Error('Invalid protocol version'));
        return false
      } else length += 1;

      // ClientId might be omitted in 3.1.1, but only if cleanSession is set to 1
      if ((typeof clientId === 'string' || Buffer$7.isBuffer(clientId)) &&
         (clientId || protocolVersion === 4) && (clientId || clean)) {
        length += clientId.length + 2;
      } else {
        if (protocolVersion < 4) {
          stream.emit('error', new Error('clientId must be supplied before 3.1.1'));
          return false
        }
        if ((clean * 1) === 0) {
          stream.emit('error', new Error('clientId must be given if cleanSession set to 0'));
          return false
        }
      }

      // Must be a two byte number
      if (typeof keepalive !== 'number' ||
          keepalive < 0 ||
          keepalive > 65535 ||
          keepalive % 1 !== 0) {
        stream.emit('error', new Error('Invalid keepalive'));
        return false
      } else length += 2;

      // Connect flags
      length += 1;

      // Properties
      if (protocolVersion === 5) {
        var propertiesData = getProperties(stream, properties);
        length += propertiesData.length;
      }

      // If will exists...
      if (will) {
        // It must be an object
        if (typeof will !== 'object') {
          stream.emit('error', new Error('Invalid will'));
          return false
        }
        // It must have topic typeof string
        if (!will.topic || typeof will.topic !== 'string') {
          stream.emit('error', new Error('Invalid will topic'));
          return false
        } else {
          length += Buffer$7.byteLength(will.topic) + 2;
        }

        // Payload
        length += 2; // payload length
        if (will.payload) {
          if (will.payload.length >= 0) {
            if (typeof will.payload === 'string') {
              length += Buffer$7.byteLength(will.payload);
            } else {
              length += will.payload.length;
            }
          } else {
            stream.emit('error', new Error('Invalid will payload'));
            return false
          }
        }
        // will properties
        var willProperties = {};
        if (protocolVersion === 5) {
          willProperties = getProperties(stream, will.properties);
          length += willProperties.length;
        }
      }

      // Username
      var providedUsername = false;
      if (username != null) {
        if (isStringOrBuffer(username)) {
          providedUsername = true;
          length += Buffer$7.byteLength(username) + 2;
        } else {
          stream.emit('error', new Error('Invalid username'));
          return false
        }
      }

      // Password
      if (password != null) {
        if (!providedUsername) {
          stream.emit('error', new Error('Username is required to use password'));
          return false
        }

        if (isStringOrBuffer(password)) {
          length += byteLength$1(password) + 2;
        } else {
          stream.emit('error', new Error('Invalid password'));
          return false
        }
      }

      // Generate header
      stream.write(constants.CONNECT_HEADER);

      // Generate length
      writeVarByteInt(stream, length);

      // Generate protocol ID
      writeStringOrBuffer(stream, protocolId);
      stream.write(
        protocolVersion === 4
          ? constants.VERSION4
          : protocolVersion === 5
            ? constants.VERSION5
            : constants.VERSION3
      );

      // Connect flags
      var flags = 0;
      flags |= (username != null) ? constants.USERNAME_MASK : 0;
      flags |= (password != null) ? constants.PASSWORD_MASK : 0;
      flags |= (will && will.retain) ? constants.WILL_RETAIN_MASK : 0;
      flags |= (will && will.qos) ? will.qos << constants.WILL_QOS_SHIFT : 0;
      flags |= will ? constants.WILL_FLAG_MASK : 0;
      flags |= clean ? constants.CLEAN_SESSION_MASK : 0;

      stream.write(Buffer$7.from([flags]));

      // Keepalive
      writeNumber(stream, keepalive);

      // Properties
      if (protocolVersion === 5) {
        propertiesData.write();
      }

      // Client ID
      writeStringOrBuffer(stream, clientId);

      // Will
      if (will) {
        if (protocolVersion === 5) {
          willProperties.write();
        }
        writeString(stream, will.topic);
        writeStringOrBuffer(stream, will.payload);
      }

      // Username and password
      if (username != null) {
        writeStringOrBuffer(stream, username);
      }
      if (password != null) {
        writeStringOrBuffer(stream, password);
      }
      // This is a small packet that happens only once on a stream
      // We assume the stream is always free to receive more data after this
      return true
    }

    function connack (packet, stream, opts) {
      var version = opts ? opts.protocolVersion : 4;
      var settings = packet || {};
      var rc = version === 5 ? settings.reasonCode : settings.returnCode;
      var properties = settings.properties;
      var length = 2; // length of rc and sessionHeader

      // Check return code
      if (typeof rc !== 'number') {
        stream.emit('error', new Error('Invalid return code'));
        return false
      }
      // mqtt5 properties
      var propertiesData = null;
      if (version === 5) {
        propertiesData = getProperties(stream, properties);
        length += propertiesData.length;
      }

      stream.write(constants.CONNACK_HEADER);
      // length
      writeVarByteInt(stream, length);
      stream.write(settings.sessionPresent ? constants.SESSIONPRESENT_HEADER : zeroBuf);

      stream.write(Buffer$7.from([rc]));
      if (propertiesData != null) {
        propertiesData.write();
      }
      return true
    }

    function publish (packet, stream, opts) {
      debug$3('publish: packet: %o', packet);
      var version = opts ? opts.protocolVersion : 4;
      var settings = packet || {};
      var qos = settings.qos || 0;
      var retain = settings.retain ? constants.RETAIN_MASK : 0;
      var topic = settings.topic;
      var payload = settings.payload || empty$2;
      var id = settings.messageId;
      var properties = settings.properties;

      var length = 0;

      // Topic must be a non-empty string or Buffer
      if (typeof topic === 'string') length += Buffer$7.byteLength(topic) + 2;
      else if (Buffer$7.isBuffer(topic)) length += topic.length + 2;
      else {
        stream.emit('error', new Error('Invalid topic'));
        return false
      }

      // Get the payload length
      if (!Buffer$7.isBuffer(payload)) length += Buffer$7.byteLength(payload);
      else length += payload.length;

      // Message ID must a number if qos > 0
      if (qos && typeof id !== 'number') {
        stream.emit('error', new Error('Invalid messageId'));
        return false
      } else if (qos) length += 2;

      // mqtt5 properties
      var propertiesData = null;
      if (version === 5) {
        propertiesData = getProperties(stream, properties);
        length += propertiesData.length;
      }

      // Header
      stream.write(constants.PUBLISH_HEADER[qos][settings.dup ? 1 : 0][retain ? 1 : 0]);

      // Remaining length
      writeVarByteInt(stream, length);

      // Topic
      writeNumber(stream, byteLength$1(topic));
      stream.write(topic);

      // Message ID
      if (qos > 0) writeNumber(stream, id);

      // Properties
      if (propertiesData != null) {
        propertiesData.write();
      }

      // Payload
      debug$3('publish: payload: %o', payload);
      return stream.write(payload)
    }

    /* Puback, pubrec, pubrel and pubcomp */
    function confirmation (packet, stream, opts) {
      var version = opts ? opts.protocolVersion : 4;
      var settings = packet || {};
      var type = settings.cmd || 'puback';
      var id = settings.messageId;
      var dup = (settings.dup && type === 'pubrel') ? constants.DUP_MASK : 0;
      var qos = 0;
      var reasonCode = settings.reasonCode;
      var properties = settings.properties;
      var length = version === 5 ? 3 : 2;

      if (type === 'pubrel') qos = 1;

      // Check message ID
      if (typeof id !== 'number') {
        stream.emit('error', new Error('Invalid messageId'));
        return false
      }

      // properies mqtt 5
      var propertiesData = null;
      if (version === 5) {
        // Confirm should not add empty property length with no properties (rfc 3.4.2.2.1)
        if (typeof properties === 'object') {
          propertiesData = getPropertiesByMaximumPacketSize(stream, properties, opts, length);
          if (!propertiesData) { return false }
          length += propertiesData.length;
        }
      }

      // Header
      stream.write(constants.ACKS[type][qos][dup][0]);

      // Length
      writeVarByteInt(stream, length);

      // Message ID
      writeNumber(stream, id);

      // reason code in header
      if (version === 5) {
        stream.write(Buffer$7.from([reasonCode]));
      }

      // properies mqtt 5
      if (propertiesData !== null) {
        propertiesData.write();
      }
      return true
    }

    function subscribe (packet, stream, opts) {
      debug$3('subscribe: packet: ');
      var version = opts ? opts.protocolVersion : 4;
      var settings = packet || {};
      var dup = settings.dup ? constants.DUP_MASK : 0;
      var id = settings.messageId;
      var subs = settings.subscriptions;
      var properties = settings.properties;

      var length = 0;

      // Check message ID
      if (typeof id !== 'number') {
        stream.emit('error', new Error('Invalid messageId'));
        return false
      } else length += 2;

      // properies mqtt 5
      var propertiesData = null;
      if (version === 5) {
        propertiesData = getProperties(stream, properties);
        length += propertiesData.length;
      }

      // Check subscriptions
      if (typeof subs === 'object' && subs.length) {
        for (var i = 0; i < subs.length; i += 1) {
          var itopic = subs[i].topic;
          var iqos = subs[i].qos;

          if (typeof itopic !== 'string') {
            stream.emit('error', new Error('Invalid subscriptions - invalid topic'));
            return false
          }
          if (typeof iqos !== 'number') {
            stream.emit('error', new Error('Invalid subscriptions - invalid qos'));
            return false
          }

          if (version === 5) {
            var nl = subs[i].nl || false;
            if (typeof nl !== 'boolean') {
              stream.emit('error', new Error('Invalid subscriptions - invalid No Local'));
              return false
            }
            var rap = subs[i].rap || false;
            if (typeof rap !== 'boolean') {
              stream.emit('error', new Error('Invalid subscriptions - invalid Retain as Published'));
              return false
            }
            var rh = subs[i].rh || 0;
            if (typeof rh !== 'number' || rh > 2) {
              stream.emit('error', new Error('Invalid subscriptions - invalid Retain Handling'));
              return false
            }
          }

          length += Buffer$7.byteLength(itopic) + 2 + 1;
        }
      } else {
        stream.emit('error', new Error('Invalid subscriptions'));
        return false
      }

      // Generate header
      debug$3('subscribe: writing to stream: %o', constants.SUBSCRIBE_HEADER);
      stream.write(constants.SUBSCRIBE_HEADER[1][dup ? 1 : 0][0]);

      // Generate length
      writeVarByteInt(stream, length);

      // Generate message ID
      writeNumber(stream, id);

      // properies mqtt 5
      if (propertiesData !== null) {
        propertiesData.write();
      }

      var result = true;

      // Generate subs
      for (var j = 0; j < subs.length; j++) {
        var sub = subs[j];
        var jtopic = sub.topic;
        var jqos = sub.qos;
        var jnl = +sub.nl;
        var jrap = +sub.rap;
        var jrh = sub.rh;
        var joptions;

        // Write topic string
        writeString(stream, jtopic);

        // options process
        joptions = constants.SUBSCRIBE_OPTIONS_QOS[jqos];
        if (version === 5) {
          joptions |= jnl ? constants.SUBSCRIBE_OPTIONS_NL : 0;
          joptions |= jrap ? constants.SUBSCRIBE_OPTIONS_RAP : 0;
          joptions |= jrh ? constants.SUBSCRIBE_OPTIONS_RH[jrh] : 0;
        }
        // Write options
        result = stream.write(Buffer$7.from([joptions]));
      }

      return result
    }

    function suback (packet, stream, opts) {
      var version = opts ? opts.protocolVersion : 4;
      var settings = packet || {};
      var id = settings.messageId;
      var granted = settings.granted;
      var properties = settings.properties;
      var length = 0;

      // Check message ID
      if (typeof id !== 'number') {
        stream.emit('error', new Error('Invalid messageId'));
        return false
      } else length += 2;

      // Check granted qos vector
      if (typeof granted === 'object' && granted.length) {
        for (var i = 0; i < granted.length; i += 1) {
          if (typeof granted[i] !== 'number') {
            stream.emit('error', new Error('Invalid qos vector'));
            return false
          }
          length += 1;
        }
      } else {
        stream.emit('error', new Error('Invalid qos vector'));
        return false
      }

      // properies mqtt 5
      var propertiesData = null;
      if (version === 5) {
        propertiesData = getPropertiesByMaximumPacketSize(stream, properties, opts, length);
        if (!propertiesData) { return false }
        length += propertiesData.length;
      }

      // header
      stream.write(constants.SUBACK_HEADER);

      // Length
      writeVarByteInt(stream, length);

      // Message ID
      writeNumber(stream, id);

      // properies mqtt 5
      if (propertiesData !== null) {
        propertiesData.write();
      }

      return stream.write(Buffer$7.from(granted))
    }

    function unsubscribe (packet, stream, opts) {
      var version = opts ? opts.protocolVersion : 4;
      var settings = packet || {};
      var id = settings.messageId;
      var dup = settings.dup ? constants.DUP_MASK : 0;
      var unsubs = settings.unsubscriptions;
      var properties = settings.properties;

      var length = 0;

      // Check message ID
      if (typeof id !== 'number') {
        stream.emit('error', new Error('Invalid messageId'));
        return false
      } else {
        length += 2;
      }
      // Check unsubs
      if (typeof unsubs === 'object' && unsubs.length) {
        for (var i = 0; i < unsubs.length; i += 1) {
          if (typeof unsubs[i] !== 'string') {
            stream.emit('error', new Error('Invalid unsubscriptions'));
            return false
          }
          length += Buffer$7.byteLength(unsubs[i]) + 2;
        }
      } else {
        stream.emit('error', new Error('Invalid unsubscriptions'));
        return false
      }
      // properies mqtt 5
      var propertiesData = null;
      if (version === 5) {
        propertiesData = getProperties(stream, properties);
        length += propertiesData.length;
      }

      // Header
      stream.write(constants.UNSUBSCRIBE_HEADER[1][dup ? 1 : 0][0]);

      // Length
      writeVarByteInt(stream, length);

      // Message ID
      writeNumber(stream, id);

      // properies mqtt 5
      if (propertiesData !== null) {
        propertiesData.write();
      }

      // Unsubs
      var result = true;
      for (var j = 0; j < unsubs.length; j++) {
        result = writeString(stream, unsubs[j]);
      }

      return result
    }

    function unsuback (packet, stream, opts) {
      var version = opts ? opts.protocolVersion : 4;
      var settings = packet || {};
      var id = settings.messageId;
      var dup = settings.dup ? constants.DUP_MASK : 0;
      var granted = settings.granted;
      var properties = settings.properties;
      var type = settings.cmd;
      var qos = 0;

      var length = 2;

      // Check message ID
      if (typeof id !== 'number') {
        stream.emit('error', new Error('Invalid messageId'));
        return false
      }

      // Check granted
      if (version === 5) {
        if (typeof granted === 'object' && granted.length) {
          for (var i = 0; i < granted.length; i += 1) {
            if (typeof granted[i] !== 'number') {
              stream.emit('error', new Error('Invalid qos vector'));
              return false
            }
            length += 1;
          }
        } else {
          stream.emit('error', new Error('Invalid qos vector'));
          return false
        }
      }

      // properies mqtt 5
      var propertiesData = null;
      if (version === 5) {
        propertiesData = getPropertiesByMaximumPacketSize(stream, properties, opts, length);
        if (!propertiesData) { return false }
        length += propertiesData.length;
      }

      // Header
      stream.write(constants.ACKS[type][qos][dup][0]);

      // Length
      writeVarByteInt(stream, length);

      // Message ID
      writeNumber(stream, id);

      // properies mqtt 5
      if (propertiesData !== null) {
        propertiesData.write();
      }

      // payload
      if (version === 5) {
        stream.write(Buffer$7.from(granted));
      }
      return true
    }

    function emptyPacket (packet, stream, opts) {
      return stream.write(constants.EMPTY[packet.cmd])
    }

    function disconnect (packet, stream, opts) {
      var version = opts ? opts.protocolVersion : 4;
      var settings = packet || {};
      var reasonCode = settings.reasonCode;
      var properties = settings.properties;
      var length = version === 5 ? 1 : 0;

      // properies mqtt 5
      var propertiesData = null;
      if (version === 5) {
        propertiesData = getPropertiesByMaximumPacketSize(stream, properties, opts, length);
        if (!propertiesData) { return false }
        length += propertiesData.length;
      }

      // Header
      stream.write(Buffer$7.from([constants.codes['disconnect'] << 4]));

      // Length
      writeVarByteInt(stream, length);

      // reason code in header
      if (version === 5) {
        stream.write(Buffer$7.from([reasonCode]));
      }

      // properies mqtt 5
      if (propertiesData !== null) {
        propertiesData.write();
      }

      return true
    }

    function auth (packet, stream, opts) {
      var version = opts ? opts.protocolVersion : 4;
      var settings = packet || {};
      var reasonCode = settings.reasonCode;
      var properties = settings.properties;
      var length = version === 5 ? 1 : 0;

      if (version !== 5) stream.emit('error', new Error('Invalid mqtt version for auth packet'));

      // properies mqtt 5
      var propertiesData = getPropertiesByMaximumPacketSize(stream, properties, opts, length);
      if (!propertiesData) { return false }
      length += propertiesData.length;

      // Header
      stream.write(Buffer$7.from([constants.codes['auth'] << 4]));

      // Length
      writeVarByteInt(stream, length);

      // reason code in header
      stream.write(Buffer$7.from([reasonCode]));

      // properies mqtt 5
      if (propertiesData !== null) {
        propertiesData.write();
      }
      return true
    }

    /**
     * writeVarByteInt - write an MQTT style variable byte integer to the buffer
     *
     * @param <Buffer> buffer - destination
     * @param <Number> pos - offset
     * @param <Number> length - length (>0)
     * @returns <Number> number of bytes written
     *
     * @api private
     */

    var varByteIntCache = {};
    function writeVarByteInt (stream, num) {
      var buffer = varByteIntCache[num];

      if (!buffer) {
        buffer = genBufVariableByteInt$1(num).data;
        if (num < 16384) varByteIntCache[num] = buffer;
      }
      debug$3('writeVarByteInt: writing to stream: %o', buffer);
      stream.write(buffer);
    }

    /**
     * writeString - write a utf8 string to the buffer
     *
     * @param <Buffer> buffer - destination
     * @param <Number> pos - offset
     * @param <String> string - string to write
     * @return <Number> number of bytes written
     *
     * @api private
     */

    function writeString (stream, string) {
      var strlen = Buffer$7.byteLength(string);
      writeNumber(stream, strlen);

      debug$3('writeString: %s', string);
      return stream.write(string, 'utf8')
    }

    /**
     * writeStringPair - write a utf8 string pairs to the buffer
     *
     * @param <Buffer> buffer - destination
     * @param <String> name - string name to write
     * @param <String> value - string value to write
     * @return <Number> number of bytes written
     *
     * @api private
     */
    function writeStringPair (stream, name, value) {
      writeString(stream, name);
      writeString(stream, value);
    }

    /**
     * writeNumber - write a two byte number to the buffer
     *
     * @param <Buffer> buffer - destination
     * @param <Number> pos - offset
     * @param <String> number - number to write
     * @return <Number> number of bytes written
     *
     * @api private
     */
    function writeNumberCached (stream, number) {
      debug$3('writeNumberCached: number: %d', number);
      debug$3('writeNumberCached: %o', numCache[number]);
      return stream.write(numCache[number])
    }
    function writeNumberGenerated (stream, number) {
      var generatedNumber = generateNumber(number);
      debug$3('writeNumberGenerated: %o', generatedNumber);
      return stream.write(generatedNumber)
    }
    function write4ByteNumber (stream, number) {
      var generated4ByteBuffer = generate4ByteBuffer$1(number);
      debug$3('write4ByteNumber: %o', generated4ByteBuffer);
      return stream.write(generated4ByteBuffer)
    }
    /**
     * writeStringOrBuffer - write a String or Buffer with the its length prefix
     *
     * @param <Buffer> buffer - destination
     * @param <Number> pos - offset
     * @param <String> toWrite - String or Buffer
     * @return <Number> number of bytes written
     */
    function writeStringOrBuffer (stream, toWrite) {
      if (typeof toWrite === 'string') {
        writeString(stream, toWrite);
      } else if (toWrite) {
        writeNumber(stream, toWrite.length);
        stream.write(toWrite);
      } else writeNumber(stream, 0);
    }

    function getProperties (stream, properties) {
      /* connect properties */
      if (typeof properties !== 'object' || properties.length != null) {
        return {
          length: 1,
          write: function () {
            writeProperties(stream, {}, 0);
          }
        }
      }
      var propertiesLength = 0;
      function getLengthProperty (name, value) {
        var type = constants.propertiesTypes[name];
        var length = 0;
        switch (type) {
          case 'byte': {
            if (typeof value !== 'boolean') {
              stream.emit('error', new Error('Invalid ' + name));
              return false
            }
            length += 1 + 1;
            break
          }
          case 'int8': {
            if (typeof value !== 'number') {
              stream.emit('error', new Error('Invalid ' + name));
              return false
            }
            length += 1 + 1;
            break
          }
          case 'binary': {
            if (value && value === null) {
              stream.emit('error', new Error('Invalid ' + name));
              return false
            }
            length += 1 + Buffer$7.byteLength(value) + 2;
            break
          }
          case 'int16': {
            if (typeof value !== 'number') {
              stream.emit('error', new Error('Invalid ' + name));
              return false
            }
            length += 1 + 2;
            break
          }
          case 'int32': {
            if (typeof value !== 'number') {
              stream.emit('error', new Error('Invalid ' + name));
              return false
            }
            length += 1 + 4;
            break
          }
          case 'var': {
            if (typeof value !== 'number') {
              stream.emit('error', new Error('Invalid ' + name));
              return false
            }
            length += 1 + genBufVariableByteInt$1(value).length;
            break
          }
          case 'string': {
            if (typeof value !== 'string') {
              stream.emit('error', new Error('Invalid ' + name));
              return false
            }
            length += 1 + 2 + Buffer$7.byteLength(value.toString());
            break
          }
          case 'pair': {
            if (typeof value !== 'object') {
              stream.emit('error', new Error('Invalid ' + name));
              return false
            }
            length += Object.getOwnPropertyNames(value).reduce(function (result, name) {
              var currentValue = value[name];
              if (Array.isArray(currentValue)) {
                result += currentValue.reduce(function (currentLength, value) {
                  currentLength += 1 + 2 + Buffer$7.byteLength(name.toString()) + 2 + Buffer$7.byteLength(value.toString());
                  return currentLength
                }, 0);
              } else {
                result += 1 + 2 + Buffer$7.byteLength(name.toString()) + 2 + Buffer$7.byteLength(value[name].toString());
              }
              return result
            }, 0);
            break
          }
          default: {
            stream.emit('error', new Error('Invalid property ' + name));
            return false
          }
        }
        return length
      }
      if (properties) {
        for (var propName in properties) {
          var propLength = 0;
          var propValue = properties[propName];
          if (Array.isArray(propValue)) {
            for (var valueIndex = 0; valueIndex < propValue.length; valueIndex++) {
              propLength += getLengthProperty(propName, propValue[valueIndex]);
            }
          } else {
            propLength = getLengthProperty(propName, propValue);
          }
          if (!propLength) return false
          propertiesLength += propLength;
        }
      }
      var propertiesLengthLength = genBufVariableByteInt$1(propertiesLength).length;

      return {
        length: propertiesLengthLength + propertiesLength,
        write: function () {
          writeProperties(stream, properties, propertiesLength);
        }
      }
    }

    function getPropertiesByMaximumPacketSize (stream, properties, opts, length) {
      var mayEmptyProps = ['reasonString', 'userProperties'];
      var maximumPacketSize = opts && opts.properties && opts.properties.maximumPacketSize ? opts.properties.maximumPacketSize : 0;

      var propertiesData = getProperties(stream, properties);
      if (maximumPacketSize) {
        while (length + propertiesData.length > maximumPacketSize) {
          var currentMayEmptyProp = mayEmptyProps.shift();
          if (currentMayEmptyProp && properties[currentMayEmptyProp]) {
            delete properties[currentMayEmptyProp];
            propertiesData = getProperties(stream, properties);
          } else {
            return false
          }
        }
      }
      return propertiesData
    }

    function writeProperty (stream, propName, value) {
      var type = constants.propertiesTypes[propName];
      switch (type) {
        case 'byte': {
          stream.write(Buffer$7.from([constants.properties[propName]]));
          stream.write(Buffer$7.from([+value]));
          break
        }
        case 'int8': {
          stream.write(Buffer$7.from([constants.properties[propName]]));
          stream.write(Buffer$7.from([value]));
          break
        }
        case 'binary': {
          stream.write(Buffer$7.from([constants.properties[propName]]));
          writeStringOrBuffer(stream, value);
          break
        }
        case 'int16': {
          stream.write(Buffer$7.from([constants.properties[propName]]));
          writeNumber(stream, value);
          break
        }
        case 'int32': {
          stream.write(Buffer$7.from([constants.properties[propName]]));
          write4ByteNumber(stream, value);
          break
        }
        case 'var': {
          stream.write(Buffer$7.from([constants.properties[propName]]));
          writeVarByteInt(stream, value);
          break
        }
        case 'string': {
          stream.write(Buffer$7.from([constants.properties[propName]]));
          writeString(stream, value);
          break
        }
        case 'pair': {
          Object.getOwnPropertyNames(value).forEach(function (name) {
            var currentValue = value[name];
            if (Array.isArray(currentValue)) {
              currentValue.forEach(function (value) {
                stream.write(Buffer$7.from([constants.properties[propName]]));
                writeStringPair(stream, name.toString(), value.toString());
              });
            } else {
              stream.write(Buffer$7.from([constants.properties[propName]]));
              writeStringPair(stream, name.toString(), currentValue.toString());
            }
          });
          break
        }
        default: {
          stream.emit('error', new Error('Invalid property ' + propName + ' value: ' + value));
          return false
        }
      }
    }

    function writeProperties (stream, properties, propertiesLength) {
      /* write properties to stream */
      writeVarByteInt(stream, propertiesLength);
      for (var propName in properties) {
        if (properties.hasOwnProperty(propName) && properties[propName] !== null) {
          var value = properties[propName];
          if (Array.isArray(value)) {
            for (var valueIndex = 0; valueIndex < value.length; valueIndex++) {
              writeProperty(stream, propName, value[valueIndex]);
            }
          } else {
            writeProperty(stream, propName, value);
          }
        }
      }
    }

    function byteLength$1 (bufOrString) {
      if (!bufOrString) return 0
      else if (bufOrString instanceof Buffer$7) return bufOrString.length
      else return Buffer$7.byteLength(bufOrString)
    }

    function isStringOrBuffer (field) {
      return typeof field === 'string' || field instanceof Buffer$7
    }

    var writeToStream = generate;

    var Buffer$8 = safeBuffer$1.Buffer;

    var EE$1 = EventEmitter.EventEmitter;


    function generate$1 (packet, opts) {
      var stream = new Accumulator();
      writeToStream(packet, stream, opts);
      return stream.concat()
    }

    function Accumulator () {
      this._array = new Array(20);
      this._i = 0;
    }

    inherits$2(Accumulator, EE$1);

    Accumulator.prototype.write = function (chunk) {
      this._array[this._i++] = chunk;
      return true
    };

    Accumulator.prototype.concat = function () {
      var length = 0;
      var lengths = new Array(this._array.length);
      var list = this._array;
      var pos = 0;
      var i;
      var result;

      for (i = 0; i < list.length && list[i] !== undefined; i++) {
        if (typeof list[i] !== 'string') lengths[i] = list[i].length;
        else lengths[i] = Buffer$8.byteLength(list[i]);

        length += lengths[i];
      }

      result = Buffer$8.allocUnsafe(length);

      for (i = 0; i < list.length && list[i] !== undefined; i++) {
        if (typeof list[i] !== 'string') {
          list[i].copy(result, pos);
          pos += lengths[i];
        } else {
          result.write(list[i], pos);
          pos += lengths[i];
        }
      }

      return result
    };

    var generate_1 = generate$1;

    var parser$1 = parser;
    var generate$2 = generate_1;
    var writeToStream$1 = writeToStream;

    var mqtt = {
    	parser: parser$1,
    	generate: generate$2,
    	writeToStream: writeToStream$1
    };

    function ReInterval (callback, interval, args) {
      var self = this;

      this._callback = callback;
      this._args = args;

      this._interval = setInterval(callback, interval, this._args);

      this.reschedule = function (interval) {
        // if no interval entered, use the interval passed in on creation
        if (!interval)
          interval = self._interval;

        if (self._interval)
          clearInterval(self._interval);
        self._interval = setInterval(self._callback, interval, self._args);
      };

      this.clear = function () {
        if (self._interval) {
          clearInterval(self._interval);
          self._interval = undefined;
        }
      };
      
      this.destroy = function () {
        if (self._interval) {
          clearInterval(self._interval);
        }
        self._callback = undefined;
        self._interval = undefined;
        self._args = undefined;
      };
    }

    function reInterval () {
      if (typeof arguments[0] !== 'function')
        throw new Error('callback needed');
      if (typeof arguments[1] !== 'number')
        throw new Error('interval needed');

      var args;

      if (arguments.length > 0) {
        args = new Array(arguments.length - 2);

        for (var i = 0; i < args.length; i++) {
          args[i] = arguments[i + 2];
        }
      }

      return new ReInterval(arguments[0], arguments[1], args);
    }

    var reinterval = reInterval;

    /**
     * Validate a topic to see if it's valid or not.
     * A topic is valid if it follow below rules:
     * - Rule #1: If any part of the topic is not `+` or `#`, then it must not contain `+` and '#'
     * - Rule #2: Part `#` must be located at the end of the mailbox
     *
     * @param {String} topic - A topic
     * @returns {Boolean} If the topic is valid, returns true. Otherwise, returns false.
     */
    function validateTopic (topic) {
      var parts = topic.split('/');

      for (var i = 0; i < parts.length; i++) {
        if (parts[i] === '+') {
          continue
        }

        if (parts[i] === '#') {
          // for Rule #2
          return i === parts.length - 1
        }

        if (parts[i].indexOf('+') !== -1 || parts[i].indexOf('#') !== -1) {
          return false
        }
      }

      return true
    }

    /**
     * Validate an array of topics to see if any of them is valid or not
      * @param {Array} topics - Array of topics
     * @returns {String} If the topics is valid, returns null. Otherwise, returns the invalid one
     */
    function validateTopics (topics) {
      if (topics.length === 0) {
        return 'empty_topic_list'
      }
      for (var i = 0; i < topics.length; i++) {
        if (!validateTopic(topics[i])) {
          return topics[i]
        }
      }
      return null
    }

    var validations = {
      validateTopics: validateTopics
    };

    /**
     * Module dependencies
     */



    var Writable$2 = readable.Writable;




    var setImmediate$1 = commonjsGlobal.setImmediate || function (callback) {
      // works in node v0.8
      process.nextTick(callback);
    };
    var defaultConnectOptions = {
      keepalive: 60,
      reschedulePings: true,
      protocolId: 'MQTT',
      protocolVersion: 4,
      reconnectPeriod: 1000,
      connectTimeout: 30 * 1000,
      clean: true,
      resubscribe: true
    };
    var errors = {
      0: '',
      1: 'Unacceptable protocol version',
      2: 'Identifier rejected',
      3: 'Server unavailable',
      4: 'Bad username or password',
      5: 'Not authorized',
      16: 'No matching subscribers',
      17: 'No subscription existed',
      128: 'Unspecified error',
      129: 'Malformed Packet',
      130: 'Protocol Error',
      131: 'Implementation specific error',
      132: 'Unsupported Protocol Version',
      133: 'Client Identifier not valid',
      134: 'Bad User Name or Password',
      135: 'Not authorized',
      136: 'Server unavailable',
      137: 'Server busy',
      138: 'Banned',
      139: 'Server shutting down',
      140: 'Bad authentication method',
      141: 'Keep Alive timeout',
      142: 'Session taken over',
      143: 'Topic Filter invalid',
      144: 'Topic Name invalid',
      145: 'Packet identifier in use',
      146: 'Packet Identifier not found',
      147: 'Receive Maximum exceeded',
      148: 'Topic Alias invalid',
      149: 'Packet too large',
      150: 'Message rate too high',
      151: 'Quota exceeded',
      152: 'Administrative action',
      153: 'Payload format invalid',
      154: 'Retain not supported',
      155: 'QoS not supported',
      156: 'Use another server',
      157: 'Server moved',
      158: 'Shared Subscriptions not supported',
      159: 'Connection rate exceeded',
      160: 'Maximum connect time',
      161: 'Subscription Identifiers not supported',
      162: 'Wildcard Subscriptions not supported'
    };

    function defaultId () {
      return 'mqttjs_' + Math.random().toString(16).substr(2, 8)
    }

    function sendPacket (client, packet, cb) {
      client.emit('packetsend', packet);

      var result = mqtt.writeToStream(packet, client.stream, client.options);

      if (!result && cb) {
        client.stream.once('drain', cb);
      } else if (cb) {
        cb();
      }
    }

    function flush (queue) {
      if (queue) {
        Object.keys(queue).forEach(function (messageId) {
          if (typeof queue[messageId].cb === 'function') {
            queue[messageId].cb(new Error('Connection closed'));
            delete queue[messageId];
          }
        });
      }
    }

    function flushVolatile (queue) {
      if (queue) {
        Object.keys(queue).forEach(function (messageId) {
          if (queue[messageId].volatile && typeof queue[messageId].cb === 'function') {
            queue[messageId].cb(new Error('Connection closed'));
            delete queue[messageId];
          }
        });
      }
    }

    function storeAndSend (client, packet, cb, cbStorePut) {
      client.outgoingStore.put(packet, function storedPacket (err) {
        if (err) {
          return cb && cb(err)
        }
        cbStorePut();
        sendPacket(client, packet, cb);
      });
    }

    function nop$2 () {}

    /**
     * MqttClient constructor
     *
     * @param {Stream} stream - stream
     * @param {Object} [options] - connection options
     * (see Connection#connect)
     */
    function MqttClient (streamBuilder, options) {
      var k;
      var that = this;

      if (!(this instanceof MqttClient)) {
        return new MqttClient(streamBuilder, options)
      }

      this.options = options || {};

      // Defaults
      for (k in defaultConnectOptions) {
        if (typeof this.options[k] === 'undefined') {
          this.options[k] = defaultConnectOptions[k];
        } else {
          this.options[k] = options[k];
        }
      }

      this.options.clientId = (typeof options.clientId === 'string') ? options.clientId : defaultId();

      this.options.customHandleAcks = (options.protocolVersion === 5 && options.customHandleAcks) ? options.customHandleAcks : function () { arguments[3](0); };

      this.streamBuilder = streamBuilder;

      // Inflight message storages
      this.outgoingStore = options.outgoingStore || new store();
      this.incomingStore = options.incomingStore || new store();

      // Should QoS zero messages be queued when the connection is broken?
      this.queueQoSZero = options.queueQoSZero === undefined ? true : options.queueQoSZero;

      // map of subscribed topics to support reconnection
      this._resubscribeTopics = {};

      // map of a subscribe messageId and a topic
      this.messageIdToTopic = {};

      // Ping timer, setup in _setupPingTimer
      this.pingTimer = null;
      // Is the client connected?
      this.connected = false;
      // Are we disconnecting?
      this.disconnecting = false;
      // Packet queue
      this.queue = [];
      // connack timer
      this.connackTimer = null;
      // Reconnect timer
      this.reconnectTimer = null;
      // Is processing store?
      this._storeProcessing = false;
      // Packet Ids are put into the store during store processing
      this._packetIdsDuringStoreProcessing = {};
      /**
       * MessageIDs starting with 1
       * ensure that nextId is min. 1, see https://github.com/mqttjs/MQTT.js/issues/810
       */
      this.nextId = Math.max(1, Math.floor(Math.random() * 65535));

      // Inflight callbacks
      this.outgoing = {};

      // True if connection is first time.
      this._firstConnection = true;

      // Mark disconnected on stream close
      this.on('close', function () {
        this.connected = false;
        clearTimeout(this.connackTimer);
      });

      // Send queued packets
      this.on('connect', function () {
        var queue = this.queue;

        function deliver () {
          var entry = queue.shift();
          var packet = null;

          if (!entry) {
            return
          }

          packet = entry.packet;

          that._sendPacket(
            packet,
            function (err) {
              if (entry.cb) {
                entry.cb(err);
              }
              deliver();
            }
          );
        }

        deliver();
      });

      // Clear ping timer
      this.on('close', function () {
        if (that.pingTimer !== null) {
          that.pingTimer.clear();
          that.pingTimer = null;
        }
      });

      // Setup reconnect timer on disconnect
      this.on('close', this._setupReconnect);

      EventEmitter.EventEmitter.call(this);

      this._setupStream();
    }
    inherits$2(MqttClient, EventEmitter.EventEmitter);

    /**
     * setup the event handlers in the inner stream.
     *
     * @api private
     */
    MqttClient.prototype._setupStream = function () {
      var connectPacket;
      var that = this;
      var writable = new Writable$2();
      var parser = mqtt.parser(this.options);
      var completeParse = null;
      var packets = [];

      this._clearReconnect();

      this.stream = this.streamBuilder(this);

      parser.on('packet', function (packet) {
        packets.push(packet);
      });

      function nextTickWork () {
        if (packets.length) {
          process.nextTick(work);
        } else {
          var done = completeParse;
          completeParse = null;
          done();
        }
      }

      function work () {
        var packet = packets.shift();

        if (packet) {
          that._handlePacket(packet, nextTickWork);
        } else {
          var done = completeParse;
          completeParse = null;
          if (done) done();
        }
      }

      writable._write = function (buf, enc, done) {
        completeParse = done;
        parser.parse(buf);
        work();
      };

      this.stream.pipe(writable);

      // Suppress connection errors
      this.stream.on('error', nop$2);

      // Echo stream close
      this.stream.on('close', function () {
        flushVolatile(that.outgoing);
        that.emit('close');
      });

      // Send a connect packet
      connectPacket = Object.create(this.options);
      connectPacket.cmd = 'connect';
      // avoid message queue
      sendPacket(this, connectPacket);

      // Echo connection errors
      parser.on('error', this.emit.bind(this, 'error'));

      // auth
      if (this.options.properties) {
        if (!this.options.properties.authenticationMethod && this.options.properties.authenticationData) {
          this.emit('error', new Error('Packet has no Authentication Method'));
          return this
        }
        if (this.options.properties.authenticationMethod && this.options.authPacket && typeof this.options.authPacket === 'object') {
          var authPacket = immutable({cmd: 'auth', reasonCode: 0}, this.options.authPacket);
          sendPacket(this, authPacket);
        }
      }

      // many drain listeners are needed for qos 1 callbacks if the connection is intermittent
      this.stream.setMaxListeners(1000);

      clearTimeout(this.connackTimer);
      this.connackTimer = setTimeout(function () {
        that._cleanUp(true);
      }, this.options.connectTimeout);
    };

    MqttClient.prototype._handlePacket = function (packet, done) {
      var options = this.options;

      if (options.protocolVersion === 5 && options.properties && options.properties.maximumPacketSize && options.properties.maximumPacketSize < packet.length) {
        this.emit('error', new Error('exceeding packets size ' + packet.cmd));
        this.end({reasonCode: 149, properties: { reasonString: 'Maximum packet size was exceeded' }});
        return this
      }

      this.emit('packetreceive', packet);

      switch (packet.cmd) {
        case 'publish':
          this._handlePublish(packet, done);
          break
        case 'puback':
        case 'pubrec':
        case 'pubcomp':
        case 'suback':
        case 'unsuback':
          this._handleAck(packet);
          done();
          break
        case 'pubrel':
          this._handlePubrel(packet, done);
          break
        case 'connack':
          this._handleConnack(packet);
          done();
          break
        case 'pingresp':
          this._handlePingresp(packet);
          done();
          break
        case 'disconnect':
          this._handleDisconnect(packet);
          done();
          break
      }
    };

    MqttClient.prototype._checkDisconnecting = function (callback) {
      if (this.disconnecting) {
        if (callback) {
          callback(new Error('client disconnecting'));
        } else {
          this.emit('error', new Error('client disconnecting'));
        }
      }
      return this.disconnecting
    };

    /**
     * publish - publish <message> to <topic>
     *
     * @param {String} topic - topic to publish to
     * @param {String, Buffer} message - message to publish
     * @param {Object} [opts] - publish options, includes:
     *    {Number} qos - qos level to publish on
     *    {Boolean} retain - whether or not to retain the message
     *    {Boolean} dup - whether or not mark a message as duplicate
     *    {Function} cbStorePut - function(){} called when message is put into `outgoingStore`
     * @param {Function} [callback] - function(err){}
     *    called when publish succeeds or fails
     * @returns {MqttClient} this - for chaining
     * @api public
     *
     * @example client.publish('topic', 'message');
     * @example
     *     client.publish('topic', 'message', {qos: 1, retain: true, dup: true});
     * @example client.publish('topic', 'message', console.log);
     */
    MqttClient.prototype.publish = function (topic, message, opts, callback) {
      var packet;
      var options = this.options;

      // .publish(topic, payload, cb);
      if (typeof opts === 'function') {
        callback = opts;
        opts = null;
      }

      // default opts
      var defaultOpts = {qos: 0, retain: false, dup: false};
      opts = immutable(defaultOpts, opts);

      if (this._checkDisconnecting(callback)) {
        return this
      }

      packet = {
        cmd: 'publish',
        topic: topic,
        payload: message,
        qos: opts.qos,
        retain: opts.retain,
        messageId: this._nextId(),
        dup: opts.dup
      };

      if (options.protocolVersion === 5) {
        packet.properties = opts.properties;
        if ((!options.properties && packet.properties && packet.properties.topicAlias) || ((opts.properties && options.properties) &&
          ((opts.properties.topicAlias && options.properties.topicAliasMaximum && opts.properties.topicAlias > options.properties.topicAliasMaximum) ||
            (!options.properties.topicAliasMaximum && opts.properties.topicAlias)))) {
          /*
          if we are don`t setup topic alias or
          topic alias maximum less than topic alias or
          server don`t give topic alias maximum,
          we are removing topic alias from packet
          */
          delete packet.properties.topicAlias;
        }
      }

      switch (opts.qos) {
        case 1:
        case 2:
          // Add to callbacks
          this.outgoing[packet.messageId] = {
            volatile: false,
            cb: callback || nop$2
          };
          if (this._storeProcessing) {
            this._packetIdsDuringStoreProcessing[packet.messageId] = false;
            this._storePacket(packet, undefined, opts.cbStorePut);
          } else {
            this._sendPacket(packet, undefined, opts.cbStorePut);
          }
          break
        default:
          if (this._storeProcessing) {
            this._storePacket(packet, callback, opts.cbStorePut);
          } else {
            this._sendPacket(packet, callback, opts.cbStorePut);
          }
          break
      }

      return this
    };

    /**
     * subscribe - subscribe to <topic>
     *
     * @param {String, Array, Object} topic - topic(s) to subscribe to, supports objects in the form {'topic': qos}
     * @param {Object} [opts] - optional subscription options, includes:
     *    {Number} qos - subscribe qos level
     * @param {Function} [callback] - function(err, granted){} where:
     *    {Error} err - subscription error (none at the moment!)
     *    {Array} granted - array of {topic: 't', qos: 0}
     * @returns {MqttClient} this - for chaining
     * @api public
     * @example client.subscribe('topic');
     * @example client.subscribe('topic', {qos: 1});
     * @example client.subscribe({'topic': {qos: 0}, 'topic2': {qos: 1}}, console.log);
     * @example client.subscribe('topic', console.log);
     */
    MqttClient.prototype.subscribe = function () {
      var packet;
      var args = new Array(arguments.length);
      for (var i = 0; i < arguments.length; i++) {
        args[i] = arguments[i];
      }
      var subs = [];
      var obj = args.shift();
      var resubscribe = obj.resubscribe;
      var callback = args.pop() || nop$2;
      var opts = args.pop();
      var invalidTopic;
      var that = this;
      var version = this.options.protocolVersion;

      delete obj.resubscribe;

      if (typeof obj === 'string') {
        obj = [obj];
      }

      if (typeof callback !== 'function') {
        opts = callback;
        callback = nop$2;
      }

      invalidTopic = validations.validateTopics(obj);
      if (invalidTopic !== null) {
        setImmediate$1(callback, new Error('Invalid topic ' + invalidTopic));
        return this
      }

      if (this._checkDisconnecting(callback)) {
        return this
      }

      var defaultOpts = {
        qos: 0
      };
      if (version === 5) {
        defaultOpts.nl = false;
        defaultOpts.rap = false;
        defaultOpts.rh = 0;
      }
      opts = immutable(defaultOpts, opts);

      if (Array.isArray(obj)) {
        obj.forEach(function (topic) {
          if (!that._resubscribeTopics.hasOwnProperty(topic) ||
            that._resubscribeTopics[topic].qos < opts.qos ||
              resubscribe) {
            var currentOpts = {
              topic: topic,
              qos: opts.qos
            };
            if (version === 5) {
              currentOpts.nl = opts.nl;
              currentOpts.rap = opts.rap;
              currentOpts.rh = opts.rh;
              currentOpts.properties = opts.properties;
            }
            subs.push(currentOpts);
          }
        });
      } else {
        Object
          .keys(obj)
          .forEach(function (k) {
            if (!that._resubscribeTopics.hasOwnProperty(k) ||
              that._resubscribeTopics[k].qos < obj[k].qos ||
                resubscribe) {
              var currentOpts = {
                topic: k,
                qos: obj[k].qos
              };
              if (version === 5) {
                currentOpts.nl = obj[k].nl;
                currentOpts.rap = obj[k].rap;
                currentOpts.rh = obj[k].rh;
                currentOpts.properties = opts.properties;
              }
              subs.push(currentOpts);
            }
          });
      }

      packet = {
        cmd: 'subscribe',
        subscriptions: subs,
        qos: 1,
        retain: false,
        dup: false,
        messageId: this._nextId()
      };

      if (opts.properties) {
        packet.properties = opts.properties;
      }

      if (!subs.length) {
        callback(null, []);
        return
      }

      // subscriptions to resubscribe to in case of disconnect
      if (this.options.resubscribe) {
        var topics = [];
        subs.forEach(function (sub) {
          if (that.options.reconnectPeriod > 0) {
            var topic = { qos: sub.qos };
            if (version === 5) {
              topic.nl = sub.nl || false;
              topic.rap = sub.rap || false;
              topic.rh = sub.rh || 0;
              topic.properties = sub.properties;
            }
            that._resubscribeTopics[sub.topic] = topic;
            topics.push(sub.topic);
          }
        });
        that.messageIdToTopic[packet.messageId] = topics;
      }

      this.outgoing[packet.messageId] = {
        volatile: true,
        cb: function (err, packet) {
          if (!err) {
            var granted = packet.granted;
            for (var i = 0; i < granted.length; i += 1) {
              subs[i].qos = granted[i];
            }
          }

          callback(err, subs);
        }
      };

      this._sendPacket(packet);

      return this
    };

    /**
     * unsubscribe - unsubscribe from topic(s)
     *
     * @param {String, Array} topic - topics to unsubscribe from
     * @param {Object} [opts] - optional subscription options, includes:
     *    {Object} properties - properties of unsubscribe packet
     * @param {Function} [callback] - callback fired on unsuback
     * @returns {MqttClient} this - for chaining
     * @api public
     * @example client.unsubscribe('topic');
     * @example client.unsubscribe('topic', console.log);
     */
    MqttClient.prototype.unsubscribe = function () {
      var packet = {
        cmd: 'unsubscribe',
        qos: 1,
        messageId: this._nextId()
      };
      var that = this;
      var args = new Array(arguments.length);
      for (var i = 0; i < arguments.length; i++) {
        args[i] = arguments[i];
      }
      var topic = args.shift();
      var callback = args.pop() || nop$2;
      var opts = args.pop();

      if (typeof topic === 'string') {
        topic = [topic];
      }

      if (typeof callback !== 'function') {
        opts = callback;
        callback = nop$2;
      }

      if (this._checkDisconnecting(callback)) {
        return this
      }

      if (typeof topic === 'string') {
        packet.unsubscriptions = [topic];
      } else if (typeof topic === 'object' && topic.length) {
        packet.unsubscriptions = topic;
      }

      if (this.options.resubscribe) {
        packet.unsubscriptions.forEach(function (topic) {
          delete that._resubscribeTopics[topic];
        });
      }

      if (typeof opts === 'object' && opts.properties) {
        packet.properties = opts.properties;
      }

      this.outgoing[packet.messageId] = {
        volatile: true,
        cb: callback
      };

      this._sendPacket(packet);

      return this
    };

    /**
     * end - close connection
     *
     * @returns {MqttClient} this - for chaining
     * @param {Boolean} force - do not wait for all in-flight messages to be acked
     * @param {Function} cb - called when the client has been closed
     *
     * @api public
     */
    MqttClient.prototype.end = function () {
      var that = this;

      var force = arguments[0];
      var opts = arguments[1];
      var cb = arguments[2];

      if (force == null || typeof force !== 'boolean') {
        cb = opts || nop$2;
        opts = force;
        force = false;
        if (typeof opts !== 'object') {
          cb = opts;
          opts = null;
          if (typeof cb !== 'function') {
            cb = nop$2;
          }
        }
      }

      if (typeof opts !== 'object') {
        cb = opts;
        opts = null;
      }

      cb = cb || nop$2;

      function closeStores () {
        that.disconnected = true;
        that.incomingStore.close(function () {
          that.outgoingStore.close(function () {
            if (cb) {
              cb.apply(null, arguments);
            }
            that.emit('end');
          });
        });
        if (that._deferredReconnect) {
          that._deferredReconnect();
        }
      }

      function finish () {
        // defer closesStores of an I/O cycle,
        // just to make sure things are
        // ok for websockets
        that._cleanUp(force, setImmediate$1.bind(null, closeStores), opts);
      }

      if (this.disconnecting) {
        return this
      }

      this._clearReconnect();

      this.disconnecting = true;

      if (!force && Object.keys(this.outgoing).length > 0) {
        // wait 10ms, just to be sure we received all of it
        this.once('outgoingEmpty', setTimeout.bind(null, finish, 10));
      } else {
        finish();
      }

      return this
    };

    /**
     * removeOutgoingMessage - remove a message in outgoing store
     * the outgoing callback will be called withe Error('Message removed') if the message is removed
     *
     * @param {Number} mid - messageId to remove message
     * @returns {MqttClient} this - for chaining
     * @api public
     *
     * @example client.removeOutgoingMessage(client.getLastMessageId());
     */
    MqttClient.prototype.removeOutgoingMessage = function (mid) {
      var cb = this.outgoing[mid] ? this.outgoing[mid].cb : null;
      delete this.outgoing[mid];
      this.outgoingStore.del({messageId: mid}, function () {
        cb(new Error('Message removed'));
      });
      return this
    };

    /**
     * reconnect - connect again using the same options as connect()
     *
     * @param {Object} [opts] - optional reconnect options, includes:
     *    {Store} incomingStore - a store for the incoming packets
     *    {Store} outgoingStore - a store for the outgoing packets
     *    if opts is not given, current stores are used
     * @returns {MqttClient} this - for chaining
     *
     * @api public
     */
    MqttClient.prototype.reconnect = function (opts) {
      var that = this;
      var f = function () {
        if (opts) {
          that.options.incomingStore = opts.incomingStore;
          that.options.outgoingStore = opts.outgoingStore;
        } else {
          that.options.incomingStore = null;
          that.options.outgoingStore = null;
        }
        that.incomingStore = that.options.incomingStore || new store();
        that.outgoingStore = that.options.outgoingStore || new store();
        that.disconnecting = false;
        that.disconnected = false;
        that._deferredReconnect = null;
        that._reconnect();
      };

      if (this.disconnecting && !this.disconnected) {
        this._deferredReconnect = f;
      } else {
        f();
      }
      return this
    };

    /**
     * _reconnect - implement reconnection
     * @api privateish
     */
    MqttClient.prototype._reconnect = function () {
      this.emit('reconnect');
      this._setupStream();
    };

    /**
     * _setupReconnect - setup reconnect timer
     */
    MqttClient.prototype._setupReconnect = function () {
      var that = this;

      if (!that.disconnecting && !that.reconnectTimer && (that.options.reconnectPeriod > 0)) {
        if (!this.reconnecting) {
          this.emit('offline');
          this.reconnecting = true;
        }
        that.reconnectTimer = setInterval(function () {
          that._reconnect();
        }, that.options.reconnectPeriod);
      }
    };

    /**
     * _clearReconnect - clear the reconnect timer
     */
    MqttClient.prototype._clearReconnect = function () {
      if (this.reconnectTimer) {
        clearInterval(this.reconnectTimer);
        this.reconnectTimer = null;
      }
    };

    /**
     * _cleanUp - clean up on connection end
     * @api private
     */
    MqttClient.prototype._cleanUp = function (forced, done) {
      var opts = arguments[2];
      if (done) {
        this.stream.on('close', done);
      }

      if (forced) {
        if ((this.options.reconnectPeriod === 0) && this.options.clean) {
          flush(this.outgoing);
        }
        this.stream.destroy();
      } else {
        var packet = immutable({ cmd: 'disconnect' }, opts);
        this._sendPacket(
          packet,
          setImmediate$1.bind(
            null,
            this.stream.end.bind(this.stream)
          )
        );
      }

      if (!this.disconnecting) {
        this._clearReconnect();
        this._setupReconnect();
      }

      if (this.pingTimer !== null) {
        this.pingTimer.clear();
        this.pingTimer = null;
      }

      if (done && !this.connected) {
        this.stream.removeListener('close', done);
        done();
      }
    };

    /**
     * _sendPacket - send or queue a packet
     * @param {String} type - packet type (see `protocol`)
     * @param {Object} packet - packet options
     * @param {Function} cb - callback when the packet is sent
     * @param {Function} cbStorePut - called when message is put into outgoingStore
     * @api private
     */
    MqttClient.prototype._sendPacket = function (packet, cb, cbStorePut) {
      cbStorePut = cbStorePut || nop$2;

      if (!this.connected) {
        this._storePacket(packet, cb, cbStorePut);
        return
      }

      // When sending a packet, reschedule the ping timer
      this._shiftPingInterval();

      switch (packet.cmd) {
        case 'publish':
          break
        case 'pubrel':
          storeAndSend(this, packet, cb, cbStorePut);
          return
        default:
          sendPacket(this, packet, cb);
          return
      }

      switch (packet.qos) {
        case 2:
        case 1:
          storeAndSend(this, packet, cb, cbStorePut);
          break
        /**
         * no need of case here since it will be caught by default
         * and jshint comply that before default it must be a break
         * anyway it will result in -1 evaluation
         */
        case 0:
          /* falls through */
        default:
          sendPacket(this, packet, cb);
          break
      }
    };

    /**
     * _storePacket - queue a packet
     * @param {String} type - packet type (see `protocol`)
     * @param {Object} packet - packet options
     * @param {Function} cb - callback when the packet is sent
     * @param {Function} cbStorePut - called when message is put into outgoingStore
     * @api private
     */
    MqttClient.prototype._storePacket = function (packet, cb, cbStorePut) {
      cbStorePut = cbStorePut || nop$2;

      if (((packet.qos || 0) === 0 && this.queueQoSZero) || packet.cmd !== 'publish') {
        this.queue.push({ packet: packet, cb: cb });
      } else if (packet.qos > 0) {
        cb = this.outgoing[packet.messageId] ? this.outgoing[packet.messageId].cb : null;
        this.outgoingStore.put(packet, function (err) {
          if (err) {
            return cb && cb(err)
          }
          cbStorePut();
        });
      } else if (cb) {
        cb(new Error('No connection to broker'));
      }
    };

    /**
     * _setupPingTimer - setup the ping timer
     *
     * @api private
     */
    MqttClient.prototype._setupPingTimer = function () {
      var that = this;

      if (!this.pingTimer && this.options.keepalive) {
        this.pingResp = true;
        this.pingTimer = reinterval(function () {
          that._checkPing();
        }, this.options.keepalive * 1000);
      }
    };

    /**
     * _shiftPingInterval - reschedule the ping interval
     *
     * @api private
     */
    MqttClient.prototype._shiftPingInterval = function () {
      if (this.pingTimer && this.options.keepalive && this.options.reschedulePings) {
        this.pingTimer.reschedule(this.options.keepalive * 1000);
      }
    };
    /**
     * _checkPing - check if a pingresp has come back, and ping the server again
     *
     * @api private
     */
    MqttClient.prototype._checkPing = function () {
      if (this.pingResp) {
        this.pingResp = false;
        this._sendPacket({ cmd: 'pingreq' });
      } else {
        // do a forced cleanup since socket will be in bad shape
        this._cleanUp(true);
      }
    };

    /**
     * _handlePingresp - handle a pingresp
     *
     * @api private
     */
    MqttClient.prototype._handlePingresp = function () {
      this.pingResp = true;
    };

    /**
     * _handleConnack
     *
     * @param {Object} packet
     * @api private
     */

    MqttClient.prototype._handleConnack = function (packet) {
      var options = this.options;
      var version = options.protocolVersion;
      var rc = version === 5 ? packet.reasonCode : packet.returnCode;

      clearTimeout(this.connackTimer);

      if (packet.properties) {
        if (packet.properties.topicAliasMaximum) {
          if (!options.properties) { options.properties = {}; }
          options.properties.topicAliasMaximum = packet.properties.topicAliasMaximum;
        }
        if (packet.properties.serverKeepAlive && options.keepalive) {
          options.keepalive = packet.properties.serverKeepAlive;
          this._shiftPingInterval();
        }
        if (packet.properties.maximumPacketSize) {
          if (!options.properties) { options.properties = {}; }
          options.properties.maximumPacketSize = packet.properties.maximumPacketSize;
        }
      }

      if (rc === 0) {
        this.reconnecting = false;
        this._onConnect(packet);
      } else if (rc > 0) {
        var err = new Error('Connection refused: ' + errors[rc]);
        err.code = rc;
        this.emit('error', err);
      }
    };

    /**
     * _handlePublish
     *
     * @param {Object} packet
     * @api private
     */
    /*
    those late 2 case should be rewrite to comply with coding style:

    case 1:
    case 0:
      // do not wait sending a puback
      // no callback passed
      if (1 === qos) {
        this._sendPacket({
          cmd: 'puback',
          messageId: mid
        });
      }
      // emit the message event for both qos 1 and 0
      this.emit('message', topic, message, packet);
      this.handleMessage(packet, done);
      break;
    default:
      // do nothing but every switch mus have a default
      // log or throw an error about unknown qos
      break;

    for now i just suppressed the warnings
    */
    MqttClient.prototype._handlePublish = function (packet, done) {
      done = typeof done !== 'undefined' ? done : nop$2;
      var topic = packet.topic.toString();
      var message = packet.payload;
      var qos = packet.qos;
      var mid = packet.messageId;
      var that = this;
      var options = this.options;
      var validReasonCodes = [0, 16, 128, 131, 135, 144, 145, 151, 153];

      switch (qos) {
        case 2: {
          options.customHandleAcks(topic, message, packet, function (error, code) {
            if (!(error instanceof Error)) {
              code = error;
              error = null;
            }
            if (error) { return that.emit('error', error) }
            if (validReasonCodes.indexOf(code) === -1) { return that.emit('error', new Error('Wrong reason code for pubrec')) }
            if (code) {
              that._sendPacket({cmd: 'pubrec', messageId: mid, reasonCode: code}, done);
            } else {
              that.incomingStore.put(packet, function () {
                that._sendPacket({cmd: 'pubrec', messageId: mid}, done);
              });
            }
          });
          break
        }
        case 1: {
          // emit the message event
          options.customHandleAcks(topic, message, packet, function (error, code) {
            if (!(error instanceof Error)) {
              code = error;
              error = null;
            }
            if (error) { return that.emit('error', error) }
            if (validReasonCodes.indexOf(code) === -1) { return that.emit('error', new Error('Wrong reason code for puback')) }
            if (!code) { that.emit('message', topic, message, packet); }
            that.handleMessage(packet, function (err) {
              if (err) {
                return done && done(err)
              }
              that._sendPacket({cmd: 'puback', messageId: mid, reasonCode: code}, done);
            });
          });
          break
        }
        case 0:
          // emit the message event
          this.emit('message', topic, message, packet);
          this.handleMessage(packet, done);
          break
      }
    };

    /**
     * Handle messages with backpressure support, one at a time.
     * Override at will.
     *
     * @param Packet packet the packet
     * @param Function callback call when finished
     * @api public
     */
    MqttClient.prototype.handleMessage = function (packet, callback) {
      callback();
    };

    /**
     * _handleAck
     *
     * @param {Object} packet
     * @api private
     */

    MqttClient.prototype._handleAck = function (packet) {
      /* eslint no-fallthrough: "off" */
      var mid = packet.messageId;
      var type = packet.cmd;
      var response = null;
      var cb = this.outgoing[mid] ? this.outgoing[mid].cb : null;
      var that = this;
      var err;

      if (!cb) {
        // Server sent an ack in error, ignore it.
        return
      }

      // Process
      switch (type) {
        case 'pubcomp':
          // same thing as puback for QoS 2
        case 'puback':
          var pubackRC = packet.reasonCode;
          // Callback - we're done
          if (pubackRC && pubackRC > 0 && pubackRC !== 16) {
            err = new Error('Publish error: ' + errors[pubackRC]);
            err.code = pubackRC;
            cb(err, packet);
          }
          delete this.outgoing[mid];
          this.outgoingStore.del(packet, cb);
          break
        case 'pubrec':
          response = {
            cmd: 'pubrel',
            qos: 2,
            messageId: mid
          };
          var pubrecRC = packet.reasonCode;

          if (pubrecRC && pubrecRC > 0 && pubrecRC !== 16) {
            err = new Error('Publish error: ' + errors[pubrecRC]);
            err.code = pubrecRC;
            cb(err, packet);
          } else {
            this._sendPacket(response);
          }
          break
        case 'suback':
          delete this.outgoing[mid];
          for (var grantedI = 0; grantedI < packet.granted.length; grantedI++) {
            if ((packet.granted[grantedI] & 0x80) !== 0) {
              // suback with Failure status
              var topics = this.messageIdToTopic[mid];
              if (topics) {
                topics.forEach(function (topic) {
                  delete that._resubscribeTopics[topic];
                });
              }
            }
          }
          cb(null, packet);
          break
        case 'unsuback':
          delete this.outgoing[mid];
          cb(null);
          break
        default:
          that.emit('error', new Error('unrecognized packet type'));
      }

      if (this.disconnecting &&
          Object.keys(this.outgoing).length === 0) {
        this.emit('outgoingEmpty');
      }
    };

    /**
     * _handlePubrel
     *
     * @param {Object} packet
     * @api private
     */
    MqttClient.prototype._handlePubrel = function (packet, callback) {
      callback = typeof callback !== 'undefined' ? callback : nop$2;
      var mid = packet.messageId;
      var that = this;

      var comp = {cmd: 'pubcomp', messageId: mid};

      that.incomingStore.get(packet, function (err, pub) {
        if (!err) {
          that.emit('message', pub.topic, pub.payload, pub);
          that.handleMessage(pub, function (err) {
            if (err) {
              return callback(err)
            }
            that.incomingStore.del(pub, nop$2);
            that._sendPacket(comp, callback);
          });
        } else {
          that._sendPacket(comp, callback);
        }
      });
    };

    /**
     * _handleDisconnect
     *
     * @param {Object} packet
     * @api private
     */
    MqttClient.prototype._handleDisconnect = function (packet) {
      this.emit('disconnect', packet);
    };

    /**
     * _nextId
     * @return unsigned int
     */
    MqttClient.prototype._nextId = function () {
      // id becomes current state of this.nextId and increments afterwards
      var id = this.nextId++;
      // Ensure 16 bit unsigned int (max 65535, nextId got one higher)
      if (this.nextId === 65536) {
        this.nextId = 1;
      }
      return id
    };

    /**
     * getLastMessageId
     * @return unsigned int
     */
    MqttClient.prototype.getLastMessageId = function () {
      return (this.nextId === 1) ? 65535 : (this.nextId - 1)
    };

    /**
     * _resubscribe
     * @api private
     */
    MqttClient.prototype._resubscribe = function (connack) {
      var _resubscribeTopicsKeys = Object.keys(this._resubscribeTopics);
      if (!this._firstConnection &&
          (this.options.clean || (this.options.protocolVersion === 5 && !connack.sessionPresent)) &&
          _resubscribeTopicsKeys.length > 0) {
        if (this.options.resubscribe) {
          if (this.options.protocolVersion === 5) {
            for (var topicI = 0; topicI < _resubscribeTopicsKeys.length; topicI++) {
              var resubscribeTopic = {};
              resubscribeTopic[_resubscribeTopicsKeys[topicI]] = this._resubscribeTopics[_resubscribeTopicsKeys[topicI]];
              resubscribeTopic.resubscribe = true;
              this.subscribe(resubscribeTopic, {properties: resubscribeTopic[_resubscribeTopicsKeys[topicI]].properties});
            }
          } else {
            this._resubscribeTopics.resubscribe = true;
            this.subscribe(this._resubscribeTopics);
          }
        } else {
          this._resubscribeTopics = {};
        }
      }

      this._firstConnection = false;
    };

    /**
     * _onConnect
     *
     * @api private
     */
    MqttClient.prototype._onConnect = function (packet) {
      if (this.disconnected) {
        this.emit('connect', packet);
        return
      }

      var that = this;

      this._setupPingTimer();
      this._resubscribe(packet);

      this.connected = true;

      function startStreamProcess () {
        var outStore = that.outgoingStore.createStream();

        function clearStoreProcessing () {
          that._storeProcessing = false;
          that._packetIdsDuringStoreProcessing = {};
        }

        that.once('close', remove);
        outStore.on('error', function (err) {
          clearStoreProcessing();
          that.removeListener('close', remove);
          that.emit('error', err);
        });

        function remove () {
          outStore.destroy();
          outStore = null;
          clearStoreProcessing();
        }

        function storeDeliver () {
          // edge case, we wrapped this twice
          if (!outStore) {
            return
          }
          that._storeProcessing = true;

          var packet = outStore.read(1);

          var cb;

          if (!packet) {
            // read when data is available in the future
            outStore.once('readable', storeDeliver);
            return
          }

          // Skip already processed store packets
          if (that._packetIdsDuringStoreProcessing[packet.messageId]) {
            storeDeliver();
            return
          }

          // Avoid unnecessary stream read operations when disconnected
          if (!that.disconnecting && !that.reconnectTimer) {
            cb = that.outgoing[packet.messageId] ? that.outgoing[packet.messageId].cb : null;
            that.outgoing[packet.messageId] = {
              volatile: false,
              cb: function (err, status) {
                // Ensure that the original callback passed in to publish gets invoked
                if (cb) {
                  cb(err, status);
                }

                storeDeliver();
              }
            };
            that._packetIdsDuringStoreProcessing[packet.messageId] = true;
            that._sendPacket(packet);
          } else if (outStore.destroy) {
            outStore.destroy();
          }
        }

        outStore.on('end', function () {
          var allProcessed = true;
          for (var id in that._packetIdsDuringStoreProcessing) {
            if (!that._packetIdsDuringStoreProcessing[id]) {
              allProcessed = false;
              break
            }
          }
          if (allProcessed) {
            clearStoreProcessing();
            that.removeListener('close', remove);
            that.emit('connect', packet);
          } else {
            startStreamProcess();
          }
        });
        storeDeliver();
      }
      // start flowing
      startStreamProcess();
    };

    var client = MqttClient;

    /*! https://mths.be/punycode v1.4.1 by @mathias */


    /** Highest positive signed 32-bit float value */
    var maxInt = 2147483647; // aka. 0x7FFFFFFF or 2^31-1

    /** Bootstring parameters */
    var base = 36;
    var tMin = 1;
    var tMax = 26;
    var skew = 38;
    var damp = 700;
    var initialBias = 72;
    var initialN = 128; // 0x80
    var delimiter = '-'; // '\x2D'
    var regexNonASCII = /[^\x20-\x7E]/; // unprintable ASCII chars + non-ASCII chars
    var regexSeparators = /[\x2E\u3002\uFF0E\uFF61]/g; // RFC 3490 separators

    /** Error messages */
    var errors$1 = {
      'overflow': 'Overflow: input needs wider integers to process',
      'not-basic': 'Illegal input >= 0x80 (not a basic code point)',
      'invalid-input': 'Invalid input'
    };

    /** Convenience shortcuts */
    var baseMinusTMin = base - tMin;
    var floor$2 = Math.floor;
    var stringFromCharCode = String.fromCharCode;

    /*--------------------------------------------------------------------------*/

    /**
     * A generic error utility function.
     * @private
     * @param {String} type The error type.
     * @returns {Error} Throws a `RangeError` with the applicable error message.
     */
    function error(type) {
      throw new RangeError(errors$1[type]);
    }

    /**
     * A generic `Array#map` utility function.
     * @private
     * @param {Array} array The array to iterate over.
     * @param {Function} callback The function that gets called for every array
     * item.
     * @returns {Array} A new array of values returned by the callback function.
     */
    function map$2(array, fn) {
      var length = array.length;
      var result = [];
      while (length--) {
        result[length] = fn(array[length]);
      }
      return result;
    }

    /**
     * A simple `Array#map`-like wrapper to work with domain name strings or email
     * addresses.
     * @private
     * @param {String} domain The domain name or email address.
     * @param {Function} callback The function that gets called for every
     * character.
     * @returns {Array} A new string of characters returned by the callback
     * function.
     */
    function mapDomain(string, fn) {
      var parts = string.split('@');
      var result = '';
      if (parts.length > 1) {
        // In email addresses, only the domain name should be punycoded. Leave
        // the local part (i.e. everything up to `@`) intact.
        result = parts[0] + '@';
        string = parts[1];
      }
      // Avoid `split(regex)` for IE8 compatibility. See #17.
      string = string.replace(regexSeparators, '\x2E');
      var labels = string.split('.');
      var encoded = map$2(labels, fn).join('.');
      return result + encoded;
    }

    /**
     * Creates an array containing the numeric code points of each Unicode
     * character in the string. While JavaScript uses UCS-2 internally,
     * this function will convert a pair of surrogate halves (each of which
     * UCS-2 exposes as separate characters) into a single code point,
     * matching UTF-16.
     * @see `punycode.ucs2.encode`
     * @see <https://mathiasbynens.be/notes/javascript-encoding>
     * @memberOf punycode.ucs2
     * @name decode
     * @param {String} string The Unicode input string (UCS-2).
     * @returns {Array} The new array of code points.
     */
    function ucs2decode(string) {
      var output = [],
        counter = 0,
        length = string.length,
        value,
        extra;
      while (counter < length) {
        value = string.charCodeAt(counter++);
        if (value >= 0xD800 && value <= 0xDBFF && counter < length) {
          // high surrogate, and there is a next character
          extra = string.charCodeAt(counter++);
          if ((extra & 0xFC00) == 0xDC00) { // low surrogate
            output.push(((value & 0x3FF) << 10) + (extra & 0x3FF) + 0x10000);
          } else {
            // unmatched surrogate; only append this code unit, in case the next
            // code unit is the high surrogate of a surrogate pair
            output.push(value);
            counter--;
          }
        } else {
          output.push(value);
        }
      }
      return output;
    }

    /**
     * Converts a digit/integer into a basic code point.
     * @see `basicToDigit()`
     * @private
     * @param {Number} digit The numeric value of a basic code point.
     * @returns {Number} The basic code point whose value (when used for
     * representing integers) is `digit`, which needs to be in the range
     * `0` to `base - 1`. If `flag` is non-zero, the uppercase form is
     * used; else, the lowercase form is used. The behavior is undefined
     * if `flag` is non-zero and `digit` has no uppercase form.
     */
    function digitToBasic(digit, flag) {
      //  0..25 map to ASCII a..z or A..Z
      // 26..35 map to ASCII 0..9
      return digit + 22 + 75 * (digit < 26) - ((flag != 0) << 5);
    }

    /**
     * Bias adaptation function as per section 3.4 of RFC 3492.
     * https://tools.ietf.org/html/rfc3492#section-3.4
     * @private
     */
    function adapt(delta, numPoints, firstTime) {
      var k = 0;
      delta = firstTime ? floor$2(delta / damp) : delta >> 1;
      delta += floor$2(delta / numPoints);
      for ( /* no initialization */ ; delta > baseMinusTMin * tMax >> 1; k += base) {
        delta = floor$2(delta / baseMinusTMin);
      }
      return floor$2(k + (baseMinusTMin + 1) * delta / (delta + skew));
    }

    /**
     * Converts a string of Unicode symbols (e.g. a domain name label) to a
     * Punycode string of ASCII-only symbols.
     * @memberOf punycode
     * @param {String} input The string of Unicode symbols.
     * @returns {String} The resulting Punycode string of ASCII-only symbols.
     */
    function encode(input) {
      var n,
        delta,
        handledCPCount,
        basicLength,
        bias,
        j,
        m,
        q,
        k,
        t,
        currentValue,
        output = [],
        /** `inputLength` will hold the number of code points in `input`. */
        inputLength,
        /** Cached calculation results */
        handledCPCountPlusOne,
        baseMinusT,
        qMinusT;

      // Convert the input in UCS-2 to Unicode
      input = ucs2decode(input);

      // Cache the length
      inputLength = input.length;

      // Initialize the state
      n = initialN;
      delta = 0;
      bias = initialBias;

      // Handle the basic code points
      for (j = 0; j < inputLength; ++j) {
        currentValue = input[j];
        if (currentValue < 0x80) {
          output.push(stringFromCharCode(currentValue));
        }
      }

      handledCPCount = basicLength = output.length;

      // `handledCPCount` is the number of code points that have been handled;
      // `basicLength` is the number of basic code points.

      // Finish the basic string - if it is not empty - with a delimiter
      if (basicLength) {
        output.push(delimiter);
      }

      // Main encoding loop:
      while (handledCPCount < inputLength) {

        // All non-basic code points < n have been handled already. Find the next
        // larger one:
        for (m = maxInt, j = 0; j < inputLength; ++j) {
          currentValue = input[j];
          if (currentValue >= n && currentValue < m) {
            m = currentValue;
          }
        }

        // Increase `delta` enough to advance the decoder's <n,i> state to <m,0>,
        // but guard against overflow
        handledCPCountPlusOne = handledCPCount + 1;
        if (m - n > floor$2((maxInt - delta) / handledCPCountPlusOne)) {
          error('overflow');
        }

        delta += (m - n) * handledCPCountPlusOne;
        n = m;

        for (j = 0; j < inputLength; ++j) {
          currentValue = input[j];

          if (currentValue < n && ++delta > maxInt) {
            error('overflow');
          }

          if (currentValue == n) {
            // Represent delta as a generalized variable-length integer
            for (q = delta, k = base; /* no condition */ ; k += base) {
              t = k <= bias ? tMin : (k >= bias + tMax ? tMax : k - bias);
              if (q < t) {
                break;
              }
              qMinusT = q - t;
              baseMinusT = base - t;
              output.push(
                stringFromCharCode(digitToBasic(t + qMinusT % baseMinusT, 0))
              );
              q = floor$2(qMinusT / baseMinusT);
            }

            output.push(stringFromCharCode(digitToBasic(q, 0)));
            bias = adapt(delta, handledCPCountPlusOne, handledCPCount == basicLength);
            delta = 0;
            ++handledCPCount;
          }
        }

        ++delta;
        ++n;

      }
      return output.join('');
    }

    /**
     * Converts a Unicode string representing a domain name or an email address to
     * Punycode. Only the non-ASCII parts of the domain name will be converted,
     * i.e. it doesn't matter if you call it with a domain that's already in
     * ASCII.
     * @memberOf punycode
     * @param {String} input The domain name or email address to convert, as a
     * Unicode string.
     * @returns {String} The Punycode representation of the given domain name or
     * email address.
     */
    function toASCII(input) {
      return mapDomain(input, function(string) {
        return regexNonASCII.test(string) ?
          'xn--' + encode(string) :
          string;
      });
    }

    // Copyright Joyent, Inc. and other Node contributors.
    //
    // Permission is hereby granted, free of charge, to any person obtaining a
    // copy of this software and associated documentation files (the
    // "Software"), to deal in the Software without restriction, including
    // without limitation the rights to use, copy, modify, merge, publish,
    // distribute, sublicense, and/or sell copies of the Software, and to permit
    // persons to whom the Software is furnished to do so, subject to the
    // following conditions:
    //
    // The above copyright notice and this permission notice shall be included
    // in all copies or substantial portions of the Software.
    //
    // THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
    // OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
    // MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN
    // NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
    // DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
    // OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
    // USE OR OTHER DEALINGS IN THE SOFTWARE.


    // If obj.hasOwnProperty has been overridden, then calling
    // obj.hasOwnProperty(prop) will break.
    // See: https://github.com/joyent/node/issues/1707
    function hasOwnProperty$4(obj, prop) {
      return Object.prototype.hasOwnProperty.call(obj, prop);
    }
    var isArray$8 = Array.isArray || function (xs) {
      return Object.prototype.toString.call(xs) === '[object Array]';
    };
    function stringifyPrimitive(v) {
      switch (typeof v) {
        case 'string':
          return v;

        case 'boolean':
          return v ? 'true' : 'false';

        case 'number':
          return isFinite(v) ? v : '';

        default:
          return '';
      }
    }

    function stringify (obj, sep, eq, name) {
      sep = sep || '&';
      eq = eq || '=';
      if (obj === null) {
        obj = undefined;
      }

      if (typeof obj === 'object') {
        return map$3(objectKeys$1(obj), function(k) {
          var ks = encodeURIComponent(stringifyPrimitive(k)) + eq;
          if (isArray$8(obj[k])) {
            return map$3(obj[k], function(v) {
              return ks + encodeURIComponent(stringifyPrimitive(v));
            }).join(sep);
          } else {
            return ks + encodeURIComponent(stringifyPrimitive(obj[k]));
          }
        }).join(sep);

      }

      if (!name) return '';
      return encodeURIComponent(stringifyPrimitive(name)) + eq +
             encodeURIComponent(stringifyPrimitive(obj));
    }
    function map$3 (xs, f) {
      if (xs.map) return xs.map(f);
      var res = [];
      for (var i = 0; i < xs.length; i++) {
        res.push(f(xs[i], i));
      }
      return res;
    }

    var objectKeys$1 = Object.keys || function (obj) {
      var res = [];
      for (var key in obj) {
        if (Object.prototype.hasOwnProperty.call(obj, key)) res.push(key);
      }
      return res;
    };

    function parse$1(qs, sep, eq, options) {
      sep = sep || '&';
      eq = eq || '=';
      var obj = {};

      if (typeof qs !== 'string' || qs.length === 0) {
        return obj;
      }

      var regexp = /\+/g;
      qs = qs.split(sep);

      var maxKeys = 1000;
      if (options && typeof options.maxKeys === 'number') {
        maxKeys = options.maxKeys;
      }

      var len = qs.length;
      // maxKeys <= 0 means that we should not limit keys count
      if (maxKeys > 0 && len > maxKeys) {
        len = maxKeys;
      }

      for (var i = 0; i < len; ++i) {
        var x = qs[i].replace(regexp, '%20'),
            idx = x.indexOf(eq),
            kstr, vstr, k, v;

        if (idx >= 0) {
          kstr = x.substr(0, idx);
          vstr = x.substr(idx + 1);
        } else {
          kstr = x;
          vstr = '';
        }

        k = decodeURIComponent(kstr);
        v = decodeURIComponent(vstr);

        if (!hasOwnProperty$4(obj, k)) {
          obj[k] = v;
        } else if (isArray$8(obj[k])) {
          obj[k].push(v);
        } else {
          obj[k] = [obj[k], v];
        }
      }

      return obj;
    }

    // Copyright Joyent, Inc. and other Node contributors.
    var url = {
      parse: urlParse,
      resolve: urlResolve,
      resolveObject: urlResolveObject,
      format: urlFormat,
      Url: Url
    };
    function Url() {
      this.protocol = null;
      this.slashes = null;
      this.auth = null;
      this.host = null;
      this.port = null;
      this.hostname = null;
      this.hash = null;
      this.search = null;
      this.query = null;
      this.pathname = null;
      this.path = null;
      this.href = null;
    }

    // Reference: RFC 3986, RFC 1808, RFC 2396

    // define these here so at least they only have to be
    // compiled once on the first module load.
    var protocolPattern = /^([a-z0-9.+-]+:)/i,
      portPattern = /:[0-9]*$/,

      // Special case for a simple path URL
      simplePathPattern = /^(\/\/?(?!\/)[^\?\s]*)(\?[^\s]*)?$/,

      // RFC 2396: characters reserved for delimiting URLs.
      // We actually just auto-escape these.
      delims = ['<', '>', '"', '`', ' ', '\r', '\n', '\t'],

      // RFC 2396: characters not allowed for various reasons.
      unwise = ['{', '}', '|', '\\', '^', '`'].concat(delims),

      // Allowed by RFCs, but cause of XSS attacks.  Always escape these.
      autoEscape = ['\''].concat(unwise),
      // Characters that are never ever allowed in a hostname.
      // Note that any invalid chars are also handled, but these
      // are the ones that are *expected* to be seen, so we fast-path
      // them.
      nonHostChars = ['%', '/', '?', ';', '#'].concat(autoEscape),
      hostEndingChars = ['/', '?', '#'],
      hostnameMaxLen = 255,
      hostnamePartPattern = /^[+a-z0-9A-Z_-]{0,63}$/,
      hostnamePartStart = /^([+a-z0-9A-Z_-]{0,63})(.*)$/,
      // protocols that can allow "unsafe" and "unwise" chars.
      unsafeProtocol = {
        'javascript': true,
        'javascript:': true
      },
      // protocols that never have a hostname.
      hostlessProtocol = {
        'javascript': true,
        'javascript:': true
      },
      // protocols that always contain a // bit.
      slashedProtocol = {
        'http': true,
        'https': true,
        'ftp': true,
        'gopher': true,
        'file': true,
        'http:': true,
        'https:': true,
        'ftp:': true,
        'gopher:': true,
        'file:': true
      };

    function urlParse(url, parseQueryString, slashesDenoteHost) {
      if (url && isObject$1(url) && url instanceof Url) return url;

      var u = new Url;
      u.parse(url, parseQueryString, slashesDenoteHost);
      return u;
    }
    Url.prototype.parse = function(url, parseQueryString, slashesDenoteHost) {
      return parse$2(this, url, parseQueryString, slashesDenoteHost);
    };

    function parse$2(self, url, parseQueryString, slashesDenoteHost) {
      if (!isString(url)) {
        throw new TypeError('Parameter \'url\' must be a string, not ' + typeof url);
      }

      // Copy chrome, IE, opera backslash-handling behavior.
      // Back slashes before the query string get converted to forward slashes
      // See: https://code.google.com/p/chromium/issues/detail?id=25916
      var queryIndex = url.indexOf('?'),
        splitter =
        (queryIndex !== -1 && queryIndex < url.indexOf('#')) ? '?' : '#',
        uSplit = url.split(splitter),
        slashRegex = /\\/g;
      uSplit[0] = uSplit[0].replace(slashRegex, '/');
      url = uSplit.join(splitter);

      var rest = url;

      // trim before proceeding.
      // This is to support parse stuff like "  http://foo.com  \n"
      rest = rest.trim();

      if (!slashesDenoteHost && url.split('#').length === 1) {
        // Try fast path regexp
        var simplePath = simplePathPattern.exec(rest);
        if (simplePath) {
          self.path = rest;
          self.href = rest;
          self.pathname = simplePath[1];
          if (simplePath[2]) {
            self.search = simplePath[2];
            if (parseQueryString) {
              self.query = parse$1(self.search.substr(1));
            } else {
              self.query = self.search.substr(1);
            }
          } else if (parseQueryString) {
            self.search = '';
            self.query = {};
          }
          return self;
        }
      }

      var proto = protocolPattern.exec(rest);
      if (proto) {
        proto = proto[0];
        var lowerProto = proto.toLowerCase();
        self.protocol = lowerProto;
        rest = rest.substr(proto.length);
      }

      // figure out if it's got a host
      // user@server is *always* interpreted as a hostname, and url
      // resolution will treat //foo/bar as host=foo,path=bar because that's
      // how the browser resolves relative URLs.
      if (slashesDenoteHost || proto || rest.match(/^\/\/[^@\/]+@[^@\/]+/)) {
        var slashes = rest.substr(0, 2) === '//';
        if (slashes && !(proto && hostlessProtocol[proto])) {
          rest = rest.substr(2);
          self.slashes = true;
        }
      }
      var i, hec, l, p;
      if (!hostlessProtocol[proto] &&
        (slashes || (proto && !slashedProtocol[proto]))) {

        // there's a hostname.
        // the first instance of /, ?, ;, or # ends the host.
        //
        // If there is an @ in the hostname, then non-host chars *are* allowed
        // to the left of the last @ sign, unless some host-ending character
        // comes *before* the @-sign.
        // URLs are obnoxious.
        //
        // ex:
        // http://a@b@c/ => user:a@b host:c
        // http://a@b?@c => user:a host:c path:/?@c

        // v0.12 TODO(isaacs): This is not quite how Chrome does things.
        // Review our test case against browsers more comprehensively.

        // find the first instance of any hostEndingChars
        var hostEnd = -1;
        for (i = 0; i < hostEndingChars.length; i++) {
          hec = rest.indexOf(hostEndingChars[i]);
          if (hec !== -1 && (hostEnd === -1 || hec < hostEnd))
            hostEnd = hec;
        }

        // at this point, either we have an explicit point where the
        // auth portion cannot go past, or the last @ char is the decider.
        var auth, atSign;
        if (hostEnd === -1) {
          // atSign can be anywhere.
          atSign = rest.lastIndexOf('@');
        } else {
          // atSign must be in auth portion.
          // http://a@b/c@d => host:b auth:a path:/c@d
          atSign = rest.lastIndexOf('@', hostEnd);
        }

        // Now we have a portion which is definitely the auth.
        // Pull that off.
        if (atSign !== -1) {
          auth = rest.slice(0, atSign);
          rest = rest.slice(atSign + 1);
          self.auth = decodeURIComponent(auth);
        }

        // the host is the remaining to the left of the first non-host char
        hostEnd = -1;
        for (i = 0; i < nonHostChars.length; i++) {
          hec = rest.indexOf(nonHostChars[i]);
          if (hec !== -1 && (hostEnd === -1 || hec < hostEnd))
            hostEnd = hec;
        }
        // if we still have not hit it, then the entire thing is a host.
        if (hostEnd === -1)
          hostEnd = rest.length;

        self.host = rest.slice(0, hostEnd);
        rest = rest.slice(hostEnd);

        // pull out port.
        parseHost(self);

        // we've indicated that there is a hostname,
        // so even if it's empty, it has to be present.
        self.hostname = self.hostname || '';

        // if hostname begins with [ and ends with ]
        // assume that it's an IPv6 address.
        var ipv6Hostname = self.hostname[0] === '[' &&
          self.hostname[self.hostname.length - 1] === ']';

        // validate a little.
        if (!ipv6Hostname) {
          var hostparts = self.hostname.split(/\./);
          for (i = 0, l = hostparts.length; i < l; i++) {
            var part = hostparts[i];
            if (!part) continue;
            if (!part.match(hostnamePartPattern)) {
              var newpart = '';
              for (var j = 0, k = part.length; j < k; j++) {
                if (part.charCodeAt(j) > 127) {
                  // we replace non-ASCII char with a temporary placeholder
                  // we need this to make sure size of hostname is not
                  // broken by replacing non-ASCII by nothing
                  newpart += 'x';
                } else {
                  newpart += part[j];
                }
              }
              // we test again with ASCII char only
              if (!newpart.match(hostnamePartPattern)) {
                var validParts = hostparts.slice(0, i);
                var notHost = hostparts.slice(i + 1);
                var bit = part.match(hostnamePartStart);
                if (bit) {
                  validParts.push(bit[1]);
                  notHost.unshift(bit[2]);
                }
                if (notHost.length) {
                  rest = '/' + notHost.join('.') + rest;
                }
                self.hostname = validParts.join('.');
                break;
              }
            }
          }
        }

        if (self.hostname.length > hostnameMaxLen) {
          self.hostname = '';
        } else {
          // hostnames are always lower case.
          self.hostname = self.hostname.toLowerCase();
        }

        if (!ipv6Hostname) {
          // IDNA Support: Returns a punycoded representation of "domain".
          // It only converts parts of the domain name that
          // have non-ASCII characters, i.e. it doesn't matter if
          // you call it with a domain that already is ASCII-only.
          self.hostname = toASCII(self.hostname);
        }

        p = self.port ? ':' + self.port : '';
        var h = self.hostname || '';
        self.host = h + p;
        self.href += self.host;

        // strip [ and ] from the hostname
        // the host field still retains them, though
        if (ipv6Hostname) {
          self.hostname = self.hostname.substr(1, self.hostname.length - 2);
          if (rest[0] !== '/') {
            rest = '/' + rest;
          }
        }
      }

      // now rest is set to the post-host stuff.
      // chop off any delim chars.
      if (!unsafeProtocol[lowerProto]) {

        // First, make 100% sure that any "autoEscape" chars get
        // escaped, even if encodeURIComponent doesn't think they
        // need to be.
        for (i = 0, l = autoEscape.length; i < l; i++) {
          var ae = autoEscape[i];
          if (rest.indexOf(ae) === -1)
            continue;
          var esc = encodeURIComponent(ae);
          if (esc === ae) {
            esc = escape(ae);
          }
          rest = rest.split(ae).join(esc);
        }
      }


      // chop off from the tail first.
      var hash = rest.indexOf('#');
      if (hash !== -1) {
        // got a fragment string.
        self.hash = rest.substr(hash);
        rest = rest.slice(0, hash);
      }
      var qm = rest.indexOf('?');
      if (qm !== -1) {
        self.search = rest.substr(qm);
        self.query = rest.substr(qm + 1);
        if (parseQueryString) {
          self.query = parse$1(self.query);
        }
        rest = rest.slice(0, qm);
      } else if (parseQueryString) {
        // no query string, but parseQueryString still requested
        self.search = '';
        self.query = {};
      }
      if (rest) self.pathname = rest;
      if (slashedProtocol[lowerProto] &&
        self.hostname && !self.pathname) {
        self.pathname = '/';
      }

      //to support http.request
      if (self.pathname || self.search) {
        p = self.pathname || '';
        var s = self.search || '';
        self.path = p + s;
      }

      // finally, reconstruct the href based on what has been validated.
      self.href = format$1(self);
      return self;
    }

    // format a parsed object into a url string
    function urlFormat(obj) {
      // ensure it's an object, and not a string url.
      // If it's an obj, this is a no-op.
      // this way, you can call url_format() on strings
      // to clean up potentially wonky urls.
      if (isString(obj)) obj = parse$2({}, obj);
      return format$1(obj);
    }

    function format$1(self) {
      var auth = self.auth || '';
      if (auth) {
        auth = encodeURIComponent(auth);
        auth = auth.replace(/%3A/i, ':');
        auth += '@';
      }

      var protocol = self.protocol || '',
        pathname = self.pathname || '',
        hash = self.hash || '',
        host = false,
        query = '';

      if (self.host) {
        host = auth + self.host;
      } else if (self.hostname) {
        host = auth + (self.hostname.indexOf(':') === -1 ?
          self.hostname :
          '[' + this.hostname + ']');
        if (self.port) {
          host += ':' + self.port;
        }
      }

      if (self.query &&
        isObject$1(self.query) &&
        Object.keys(self.query).length) {
        query = stringify(self.query);
      }

      var search = self.search || (query && ('?' + query)) || '';

      if (protocol && protocol.substr(-1) !== ':') protocol += ':';

      // only the slashedProtocols get the //.  Not mailto:, xmpp:, etc.
      // unless they had them to begin with.
      if (self.slashes ||
        (!protocol || slashedProtocol[protocol]) && host !== false) {
        host = '//' + (host || '');
        if (pathname && pathname.charAt(0) !== '/') pathname = '/' + pathname;
      } else if (!host) {
        host = '';
      }

      if (hash && hash.charAt(0) !== '#') hash = '#' + hash;
      if (search && search.charAt(0) !== '?') search = '?' + search;

      pathname = pathname.replace(/[?#]/g, function(match) {
        return encodeURIComponent(match);
      });
      search = search.replace('#', '%23');

      return protocol + host + pathname + search + hash;
    }

    Url.prototype.format = function() {
      return format$1(this);
    };

    function urlResolve(source, relative) {
      return urlParse(source, false, true).resolve(relative);
    }

    Url.prototype.resolve = function(relative) {
      return this.resolveObject(urlParse(relative, false, true)).format();
    };

    function urlResolveObject(source, relative) {
      if (!source) return relative;
      return urlParse(source, false, true).resolveObject(relative);
    }

    Url.prototype.resolveObject = function(relative) {
      if (isString(relative)) {
        var rel = new Url();
        rel.parse(relative, false, true);
        relative = rel;
      }

      var result = new Url();
      var tkeys = Object.keys(this);
      for (var tk = 0; tk < tkeys.length; tk++) {
        var tkey = tkeys[tk];
        result[tkey] = this[tkey];
      }

      // hash is always overridden, no matter what.
      // even href="" will remove it.
      result.hash = relative.hash;

      // if the relative url is empty, then there's nothing left to do here.
      if (relative.href === '') {
        result.href = result.format();
        return result;
      }

      // hrefs like //foo/bar always cut to the protocol.
      if (relative.slashes && !relative.protocol) {
        // take everything except the protocol from relative
        var rkeys = Object.keys(relative);
        for (var rk = 0; rk < rkeys.length; rk++) {
          var rkey = rkeys[rk];
          if (rkey !== 'protocol')
            result[rkey] = relative[rkey];
        }

        //urlParse appends trailing / to urls like http://www.example.com
        if (slashedProtocol[result.protocol] &&
          result.hostname && !result.pathname) {
          result.path = result.pathname = '/';
        }

        result.href = result.format();
        return result;
      }
      var relPath;
      if (relative.protocol && relative.protocol !== result.protocol) {
        // if it's a known url protocol, then changing
        // the protocol does weird things
        // first, if it's not file:, then we MUST have a host,
        // and if there was a path
        // to begin with, then we MUST have a path.
        // if it is file:, then the host is dropped,
        // because that's known to be hostless.
        // anything else is assumed to be absolute.
        if (!slashedProtocol[relative.protocol]) {
          var keys = Object.keys(relative);
          for (var v = 0; v < keys.length; v++) {
            var k = keys[v];
            result[k] = relative[k];
          }
          result.href = result.format();
          return result;
        }

        result.protocol = relative.protocol;
        if (!relative.host && !hostlessProtocol[relative.protocol]) {
          relPath = (relative.pathname || '').split('/');
          while (relPath.length && !(relative.host = relPath.shift()));
          if (!relative.host) relative.host = '';
          if (!relative.hostname) relative.hostname = '';
          if (relPath[0] !== '') relPath.unshift('');
          if (relPath.length < 2) relPath.unshift('');
          result.pathname = relPath.join('/');
        } else {
          result.pathname = relative.pathname;
        }
        result.search = relative.search;
        result.query = relative.query;
        result.host = relative.host || '';
        result.auth = relative.auth;
        result.hostname = relative.hostname || relative.host;
        result.port = relative.port;
        // to support http.request
        if (result.pathname || result.search) {
          var p = result.pathname || '';
          var s = result.search || '';
          result.path = p + s;
        }
        result.slashes = result.slashes || relative.slashes;
        result.href = result.format();
        return result;
      }

      var isSourceAbs = (result.pathname && result.pathname.charAt(0) === '/'),
        isRelAbs = (
          relative.host ||
          relative.pathname && relative.pathname.charAt(0) === '/'
        ),
        mustEndAbs = (isRelAbs || isSourceAbs ||
          (result.host && relative.pathname)),
        removeAllDots = mustEndAbs,
        srcPath = result.pathname && result.pathname.split('/') || [],
        psychotic = result.protocol && !slashedProtocol[result.protocol];
      relPath = relative.pathname && relative.pathname.split('/') || [];
      // if the url is a non-slashed url, then relative
      // links like ../.. should be able
      // to crawl up to the hostname, as well.  This is strange.
      // result.protocol has already been set by now.
      // Later on, put the first path part into the host field.
      if (psychotic) {
        result.hostname = '';
        result.port = null;
        if (result.host) {
          if (srcPath[0] === '') srcPath[0] = result.host;
          else srcPath.unshift(result.host);
        }
        result.host = '';
        if (relative.protocol) {
          relative.hostname = null;
          relative.port = null;
          if (relative.host) {
            if (relPath[0] === '') relPath[0] = relative.host;
            else relPath.unshift(relative.host);
          }
          relative.host = null;
        }
        mustEndAbs = mustEndAbs && (relPath[0] === '' || srcPath[0] === '');
      }
      var authInHost;
      if (isRelAbs) {
        // it's absolute.
        result.host = (relative.host || relative.host === '') ?
          relative.host : result.host;
        result.hostname = (relative.hostname || relative.hostname === '') ?
          relative.hostname : result.hostname;
        result.search = relative.search;
        result.query = relative.query;
        srcPath = relPath;
        // fall through to the dot-handling below.
      } else if (relPath.length) {
        // it's relative
        // throw away the existing file, and take the new path instead.
        if (!srcPath) srcPath = [];
        srcPath.pop();
        srcPath = srcPath.concat(relPath);
        result.search = relative.search;
        result.query = relative.query;
      } else if (!isNullOrUndefined(relative.search)) {
        // just pull out the search.
        // like href='?foo'.
        // Put this after the other two cases because it simplifies the booleans
        if (psychotic) {
          result.hostname = result.host = srcPath.shift();
          //occationaly the auth can get stuck only in host
          //this especially happens in cases like
          //url.resolveObject('mailto:local1@domain1', 'local2@domain2')
          authInHost = result.host && result.host.indexOf('@') > 0 ?
            result.host.split('@') : false;
          if (authInHost) {
            result.auth = authInHost.shift();
            result.host = result.hostname = authInHost.shift();
          }
        }
        result.search = relative.search;
        result.query = relative.query;
        //to support http.request
        if (!isNull(result.pathname) || !isNull(result.search)) {
          result.path = (result.pathname ? result.pathname : '') +
            (result.search ? result.search : '');
        }
        result.href = result.format();
        return result;
      }

      if (!srcPath.length) {
        // no path at all.  easy.
        // we've already handled the other stuff above.
        result.pathname = null;
        //to support http.request
        if (result.search) {
          result.path = '/' + result.search;
        } else {
          result.path = null;
        }
        result.href = result.format();
        return result;
      }

      // if a url ENDs in . or .., then it must get a trailing slash.
      // however, if it ends in anything else non-slashy,
      // then it must NOT get a trailing slash.
      var last = srcPath.slice(-1)[0];
      var hasTrailingSlash = (
        (result.host || relative.host || srcPath.length > 1) &&
        (last === '.' || last === '..') || last === '');

      // strip single dots, resolve double dots to parent dir
      // if the path tries to go above the root, `up` ends up > 0
      var up = 0;
      for (var i = srcPath.length; i >= 0; i--) {
        last = srcPath[i];
        if (last === '.') {
          srcPath.splice(i, 1);
        } else if (last === '..') {
          srcPath.splice(i, 1);
          up++;
        } else if (up) {
          srcPath.splice(i, 1);
          up--;
        }
      }

      // if the path is allowed to go above the root, restore leading ..s
      if (!mustEndAbs && !removeAllDots) {
        for (; up--; up) {
          srcPath.unshift('..');
        }
      }

      if (mustEndAbs && srcPath[0] !== '' &&
        (!srcPath[0] || srcPath[0].charAt(0) !== '/')) {
        srcPath.unshift('');
      }

      if (hasTrailingSlash && (srcPath.join('/').substr(-1) !== '/')) {
        srcPath.push('');
      }

      var isAbsolute = srcPath[0] === '' ||
        (srcPath[0] && srcPath[0].charAt(0) === '/');

      // put the host back
      if (psychotic) {
        result.hostname = result.host = isAbsolute ? '' :
          srcPath.length ? srcPath.shift() : '';
        //occationaly the auth can get stuck only in host
        //this especially happens in cases like
        //url.resolveObject('mailto:local1@domain1', 'local2@domain2')
        authInHost = result.host && result.host.indexOf('@') > 0 ?
          result.host.split('@') : false;
        if (authInHost) {
          result.auth = authInHost.shift();
          result.host = result.hostname = authInHost.shift();
        }
      }

      mustEndAbs = mustEndAbs || (result.host && srcPath.length);

      if (mustEndAbs && !isAbsolute) {
        srcPath.unshift('');
      }

      if (!srcPath.length) {
        result.pathname = null;
        result.path = null;
      } else {
        result.pathname = srcPath.join('/');
      }

      //to support request.http
      if (!isNull(result.pathname) || !isNull(result.search)) {
        result.path = (result.pathname ? result.pathname : '') +
          (result.search ? result.search : '');
      }
      result.auth = relative.auth || result.auth;
      result.slashes = result.slashes || relative.slashes;
      result.href = result.format();
      return result;
    };

    Url.prototype.parseHost = function() {
      return parseHost(this);
    };

    function parseHost(self) {
      var host = self.host;
      var port = portPattern.exec(host);
      if (port) {
        port = port[0];
        if (port !== ':') {
          self.port = port.substr(1);
        }
        host = host.substr(0, host.length - port.length);
      }
      if (host) self.hostname = host;
    }

    var fs = {};

    /*
      variables port and host can be removed since
      you have all required information in opts object
    */
    function buildBuilder (client, opts) {
      var port, host;
      opts.port = opts.port || 1883;
      opts.hostname = opts.hostname || opts.host || 'localhost';

      port = opts.port;
      host = opts.hostname;

      return fs.createConnection(port, host)
    }

    var tcp = buildBuilder;

    function buildBuilder$1 (mqttClient, opts) {
      var connection;
      opts.port = opts.port || 8883;
      opts.host = opts.hostname || opts.host || 'localhost';

      opts.rejectUnauthorized = opts.rejectUnauthorized !== false;

      delete opts.path;

      connection = fs.connect(opts);
      /* eslint no-use-before-define: [2, "nofunc"] */
      connection.on('secureConnect', function () {
        if (opts.rejectUnauthorized && !connection.authorized) {
          connection.emit('error', new Error('TLS not authorized'));
        } else {
          connection.removeListener('error', handleTLSerrors);
        }
      });

      function handleTLSerrors (err) {
        // How can I get verify this error is a tls error?
        if (opts.rejectUnauthorized) {
          mqttClient.emit('error', err);
        }

        // close this connection to match the behaviour of net
        // otherwise all we get is an error from the connection
        // and close event doesn't fire. This is a work around
        // to enable the reconnect code to work the same as with
        // net.createConnection
        connection.end();
      }

      connection.on('error', handleTLSerrors);
      return connection
    }

    var tls_1 = buildBuilder$1;

    // Returns a wrapper function that returns a wrapped callback
    // The wrapper function should do some stuff, and return a
    // presumably different callback function.
    // This makes sure that own properties are retained, so that
    // decorations and such are not lost along the way.
    var wrappy_1 = wrappy;
    function wrappy (fn, cb) {
      if (fn && cb) return wrappy(fn)(cb)

      if (typeof fn !== 'function')
        throw new TypeError('need wrapper function')

      Object.keys(fn).forEach(function (k) {
        wrapper[k] = fn[k];
      });

      return wrapper

      function wrapper() {
        var args = new Array(arguments.length);
        for (var i = 0; i < args.length; i++) {
          args[i] = arguments[i];
        }
        var ret = fn.apply(this, args);
        var cb = args[args.length-1];
        if (typeof ret === 'function' && ret !== cb) {
          Object.keys(cb).forEach(function (k) {
            ret[k] = cb[k];
          });
        }
        return ret
      }
    }

    var once_1 = wrappy_1(once);
    var strict = wrappy_1(onceStrict);

    once.proto = once(function () {
      Object.defineProperty(Function.prototype, 'once', {
        value: function () {
          return once(this)
        },
        configurable: true
      });

      Object.defineProperty(Function.prototype, 'onceStrict', {
        value: function () {
          return onceStrict(this)
        },
        configurable: true
      });
    });

    function once (fn) {
      var f = function () {
        if (f.called) return f.value
        f.called = true;
        return f.value = fn.apply(this, arguments)
      };
      f.called = false;
      return f
    }

    function onceStrict (fn) {
      var f = function () {
        if (f.called)
          throw new Error(f.onceError)
        f.called = true;
        return f.value = fn.apply(this, arguments)
      };
      var name = fn.name || 'Function wrapped with `once`';
      f.onceError = name + " shouldn't be called more than once";
      f.called = false;
      return f
    }
    once_1.strict = strict;

    var noop$2 = function() {};

    var isRequest = function(stream) {
    	return stream.setHeader && typeof stream.abort === 'function';
    };

    var isChildProcess = function(stream) {
    	return stream.stdio && Array.isArray(stream.stdio) && stream.stdio.length === 3
    };

    var eos = function(stream, opts, callback) {
    	if (typeof opts === 'function') return eos(stream, null, opts);
    	if (!opts) opts = {};

    	callback = once_1(callback || noop$2);

    	var ws = stream._writableState;
    	var rs = stream._readableState;
    	var readable = opts.readable || (opts.readable !== false && stream.readable);
    	var writable = opts.writable || (opts.writable !== false && stream.writable);
    	var cancelled = false;

    	var onlegacyfinish = function() {
    		if (!stream.writable) onfinish();
    	};

    	var onfinish = function() {
    		writable = false;
    		if (!readable) callback.call(stream);
    	};

    	var onend = function() {
    		readable = false;
    		if (!writable) callback.call(stream);
    	};

    	var onexit = function(exitCode) {
    		callback.call(stream, exitCode ? new Error('exited with error code: ' + exitCode) : null);
    	};

    	var onerror = function(err) {
    		callback.call(stream, err);
    	};

    	var onclose = function() {
    		process.nextTick(onclosenexttick);
    	};

    	var onclosenexttick = function() {
    		if (cancelled) return;
    		if (readable && !(rs && (rs.ended && !rs.destroyed))) return callback.call(stream, new Error('premature close'));
    		if (writable && !(ws && (ws.ended && !ws.destroyed))) return callback.call(stream, new Error('premature close'));
    	};

    	var onrequest = function() {
    		stream.req.on('finish', onfinish);
    	};

    	if (isRequest(stream)) {
    		stream.on('complete', onfinish);
    		stream.on('abort', onclose);
    		if (stream.req) onrequest();
    		else stream.on('request', onrequest);
    	} else if (writable && !ws) { // legacy streams
    		stream.on('end', onlegacyfinish);
    		stream.on('close', onlegacyfinish);
    	}

    	if (isChildProcess(stream)) stream.on('exit', onexit);

    	stream.on('end', onend);
    	stream.on('finish', onfinish);
    	if (opts.error !== false) stream.on('error', onerror);
    	stream.on('close', onclose);

    	return function() {
    		cancelled = true;
    		stream.removeListener('complete', onfinish);
    		stream.removeListener('abort', onclose);
    		stream.removeListener('request', onrequest);
    		if (stream.req) stream.req.removeListener('finish', onfinish);
    		stream.removeListener('end', onlegacyfinish);
    		stream.removeListener('close', onlegacyfinish);
    		stream.removeListener('finish', onfinish);
    		stream.removeListener('exit', onexit);
    		stream.removeListener('end', onend);
    		stream.removeListener('error', onerror);
    		stream.removeListener('close', onclose);
    	};
    };

    var endOfStream = eos;

    var streamShift = shift;

    function shift (stream) {
      var rs = stream._readableState;
      if (!rs) return null
      return (rs.objectMode || typeof stream._duplexState === 'number') ? stream.read() : stream.read(getStateLength(rs))
    }

    function getStateLength (state) {
      if (state.buffer.length) {
        // Since node 6.3.0 state.buffer is a BufferList not an array
        if (state.buffer.head) {
          return state.buffer.head.data.length
        }

        return state.buffer[0].length
      }

      return state.length
    }

    var SIGNAL_FLUSH = (Buffer.from && Buffer.from !== Uint8Array.from)
      ? Buffer.from([0])
      : new Buffer([0]);

    var onuncork = function(self, fn) {
      if (self._corked) self.once('uncork', fn);
      else fn();
    };

    var autoDestroy = function (self, err) {
      if (self._autoDestroy) self.destroy(err);
    };

    var destroyer = function(self, end) {
      return function(err) {
        if (err) autoDestroy(self, err.message === 'premature close' ? null : err);
        else if (end && !self._ended) self.end();
      }
    };

    var end = function(ws, fn) {
      if (!ws) return fn()
      if (ws._writableState && ws._writableState.finished) return fn()
      if (ws._writableState) return ws.end(fn)
      ws.end();
      fn();
    };

    var toStreams2 = function(rs) {
      return new (readable.Readable)({objectMode:true, highWaterMark:16}).wrap(rs)
    };

    var Duplexify = function(writable, readable$1, opts) {
      if (!(this instanceof Duplexify)) return new Duplexify(writable, readable$1, opts)
      readable.Duplex.call(this, opts);

      this._writable = null;
      this._readable = null;
      this._readable2 = null;

      this._autoDestroy = !opts || opts.autoDestroy !== false;
      this._forwardDestroy = !opts || opts.destroy !== false;
      this._forwardEnd = !opts || opts.end !== false;
      this._corked = 1; // start corked
      this._ondrain = null;
      this._drained = false;
      this._forwarding = false;
      this._unwrite = null;
      this._unread = null;
      this._ended = false;

      this.destroyed = false;

      if (writable) this.setWritable(writable);
      if (readable$1) this.setReadable(readable$1);
    };

    inherits$2(Duplexify, readable.Duplex);

    Duplexify.obj = function(writable, readable, opts) {
      if (!opts) opts = {};
      opts.objectMode = true;
      opts.highWaterMark = 16;
      return new Duplexify(writable, readable, opts)
    };

    Duplexify.prototype.cork = function() {
      if (++this._corked === 1) this.emit('cork');
    };

    Duplexify.prototype.uncork = function() {
      if (this._corked && --this._corked === 0) this.emit('uncork');
    };

    Duplexify.prototype.setWritable = function(writable) {
      if (this._unwrite) this._unwrite();

      if (this.destroyed) {
        if (writable && writable.destroy) writable.destroy();
        return
      }

      if (writable === null || writable === false) {
        this.end();
        return
      }

      var self = this;
      var unend = endOfStream(writable, {writable:true, readable:false}, destroyer(this, this._forwardEnd));

      var ondrain = function() {
        var ondrain = self._ondrain;
        self._ondrain = null;
        if (ondrain) ondrain();
      };

      var clear = function() {
        self._writable.removeListener('drain', ondrain);
        unend();
      };

      if (this._unwrite) process.nextTick(ondrain); // force a drain on stream reset to avoid livelocks

      this._writable = writable;
      this._writable.on('drain', ondrain);
      this._unwrite = clear;

      this.uncork(); // always uncork setWritable
    };

    Duplexify.prototype.setReadable = function(readable) {
      if (this._unread) this._unread();

      if (this.destroyed) {
        if (readable && readable.destroy) readable.destroy();
        return
      }

      if (readable === null || readable === false) {
        this.push(null);
        this.resume();
        return
      }

      var self = this;
      var unend = endOfStream(readable, {writable:false, readable:true}, destroyer(this));

      var onreadable = function() {
        self._forward();
      };

      var onend = function() {
        self.push(null);
      };

      var clear = function() {
        self._readable2.removeListener('readable', onreadable);
        self._readable2.removeListener('end', onend);
        unend();
      };

      this._drained = true;
      this._readable = readable;
      this._readable2 = readable._readableState ? readable : toStreams2(readable);
      this._readable2.on('readable', onreadable);
      this._readable2.on('end', onend);
      this._unread = clear;

      this._forward();
    };

    Duplexify.prototype._read = function() {
      this._drained = true;
      this._forward();
    };

    Duplexify.prototype._forward = function() {
      if (this._forwarding || !this._readable2 || !this._drained) return
      this._forwarding = true;

      var data;

      while (this._drained && (data = streamShift(this._readable2)) !== null) {
        if (this.destroyed) continue
        this._drained = this.push(data);
      }

      this._forwarding = false;
    };

    Duplexify.prototype.destroy = function(err) {
      if (this.destroyed) return
      this.destroyed = true;

      var self = this;
      process.nextTick(function() {
        self._destroy(err);
      });
    };

    Duplexify.prototype._destroy = function(err) {
      if (err) {
        var ondrain = this._ondrain;
        this._ondrain = null;
        if (ondrain) ondrain(err);
        else this.emit('error', err);
      }

      if (this._forwardDestroy) {
        if (this._readable && this._readable.destroy) this._readable.destroy();
        if (this._writable && this._writable.destroy) this._writable.destroy();
      }

      this.emit('close');
    };

    Duplexify.prototype._write = function(data, enc, cb) {
      if (this.destroyed) return cb()
      if (this._corked) return onuncork(this, this._write.bind(this, data, enc, cb))
      if (data === SIGNAL_FLUSH) return this._finish(cb)
      if (!this._writable) return cb()

      if (this._writable.write(data) === false) this._ondrain = cb;
      else cb();
    };

    Duplexify.prototype._finish = function(cb) {
      var self = this;
      this.emit('preend');
      onuncork(this, function() {
        end(self._forwardEnd && self._writable, function() {
          // haxx to not emit prefinish twice
          if (self._writableState.prefinished === false) self._writableState.prefinished = true;
          self.emit('prefinish');
          onuncork(self, cb);
        });
      });
    };

    Duplexify.prototype.end = function(data, enc, cb) {
      if (typeof data === 'function') return this.end(null, null, data)
      if (typeof enc === 'function') return this.end(data, null, enc)
      this._ended = true;
      if (data) this.write(data);
      if (!this._writableState.ending) this.write(SIGNAL_FLUSH);
      return readable.Writable.prototype.end.call(this, cb)
    };

    var duplexify = Duplexify;

    var Transform$2 = readable.Transform;


    /* global wx */
    var socketTask;
    var proxy;
    var stream$1;

    function buildProxy () {
      var proxy = new Transform$2();
      proxy._write = function (chunk, encoding, next) {
        socketTask.send({
          data: chunk.buffer,
          success: function () {
            next();
          },
          fail: function (errMsg) {
            next(new Error(errMsg));
          }
        });
      };
      proxy._flush = function socketEnd (done) {
        socketTask.close({
          success: function () {
            done();
          }
        });
      };

      return proxy
    }

    function setDefaultOpts (opts) {
      if (!opts.hostname) {
        opts.hostname = 'localhost';
      }
      if (!opts.path) {
        opts.path = '/';
      }

      if (!opts.wsOptions) {
        opts.wsOptions = {};
      }
    }

    function buildUrl (opts, client) {
      var protocol = opts.protocol === 'wxs' ? 'wss' : 'ws';
      var url = protocol + '://' + opts.hostname + opts.path;
      if (opts.port && opts.port !== 80 && opts.port !== 443) {
        url = protocol + '://' + opts.hostname + ':' + opts.port + opts.path;
      }
      if (typeof (opts.transformWsUrl) === 'function') {
        url = opts.transformWsUrl(url, opts, client);
      }
      return url
    }

    function bindEventHandler () {
      socketTask.onOpen(function () {
        stream$1.setReadable(proxy);
        stream$1.setWritable(proxy);
        stream$1.emit('connect');
      });

      socketTask.onMessage(function (res) {
        var data = res.data;

        if (data instanceof ArrayBuffer) data = Buffer.from(data);
        else data = Buffer.from(data, 'utf8');
        proxy.push(data);
      });

      socketTask.onClose(function () {
        stream$1.end();
        stream$1.destroy();
      });

      socketTask.onError(function (res) {
        stream$1.destroy(new Error(res.errMsg));
      });
    }

    function buildStream (client, opts) {
      opts.hostname = opts.hostname || opts.host;

      if (!opts.hostname) {
        throw new Error('Could not determine host. Specify host manually.')
      }

      var websocketSubProtocol =
        (opts.protocolId === 'MQIsdp') && (opts.protocolVersion === 3)
          ? 'mqttv3.1'
          : 'mqtt';

      setDefaultOpts(opts);

      var url = buildUrl(opts, client);
      socketTask = wx.connectSocket({
        url: url,
        protocols: websocketSubProtocol
      });

      proxy = buildProxy();
      stream$1 = duplexify.obj();
      stream$1._destroy = function (err, cb) {
        socketTask.close({
          success: function () {
            cb && cb(err);
          }
        });
      };

      var destroyRef = stream$1.destroy;
      stream$1.destroy = function () {
        stream$1.destroy = destroyRef;

        var self = this;
        process.nextTick(function () {
          socketTask.close({
            fail: function () {
              self._destroy(new Error());
            }
          });
        });
      }.bind(stream$1);

      bindEventHandler();

      return stream$1
    }

    var wx_1 = buildStream;

    var byteLength_1 = byteLength$2;
    var toByteArray_1 = toByteArray$1;
    var fromByteArray_1 = fromByteArray$1;

    var lookup$1 = [];
    var revLookup$1 = [];
    var Arr$1 = typeof Uint8Array !== 'undefined' ? Uint8Array : Array;

    var code = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/';
    for (var i = 0, len = code.length; i < len; ++i) {
      lookup$1[i] = code[i];
      revLookup$1[code.charCodeAt(i)] = i;
    }

    // Support decoding URL-safe base64 strings, as Node.js does.
    // See: https://en.wikipedia.org/wiki/Base64#URL_applications
    revLookup$1['-'.charCodeAt(0)] = 62;
    revLookup$1['_'.charCodeAt(0)] = 63;

    function getLens (b64) {
      var len = b64.length;

      if (len % 4 > 0) {
        throw new Error('Invalid string. Length must be a multiple of 4')
      }

      // Trim off extra bytes after placeholder bytes are found
      // See: https://github.com/beatgammit/base64-js/issues/42
      var validLen = b64.indexOf('=');
      if (validLen === -1) validLen = len;

      var placeHoldersLen = validLen === len
        ? 0
        : 4 - (validLen % 4);

      return [validLen, placeHoldersLen]
    }

    // base64 is 4/3 + up to two characters of the original data
    function byteLength$2 (b64) {
      var lens = getLens(b64);
      var validLen = lens[0];
      var placeHoldersLen = lens[1];
      return ((validLen + placeHoldersLen) * 3 / 4) - placeHoldersLen
    }

    function _byteLength (b64, validLen, placeHoldersLen) {
      return ((validLen + placeHoldersLen) * 3 / 4) - placeHoldersLen
    }

    function toByteArray$1 (b64) {
      var tmp;
      var lens = getLens(b64);
      var validLen = lens[0];
      var placeHoldersLen = lens[1];

      var arr = new Arr$1(_byteLength(b64, validLen, placeHoldersLen));

      var curByte = 0;

      // if there are placeholders, only get up to the last complete 4 chars
      var len = placeHoldersLen > 0
        ? validLen - 4
        : validLen;

      var i;
      for (i = 0; i < len; i += 4) {
        tmp =
          (revLookup$1[b64.charCodeAt(i)] << 18) |
          (revLookup$1[b64.charCodeAt(i + 1)] << 12) |
          (revLookup$1[b64.charCodeAt(i + 2)] << 6) |
          revLookup$1[b64.charCodeAt(i + 3)];
        arr[curByte++] = (tmp >> 16) & 0xFF;
        arr[curByte++] = (tmp >> 8) & 0xFF;
        arr[curByte++] = tmp & 0xFF;
      }

      if (placeHoldersLen === 2) {
        tmp =
          (revLookup$1[b64.charCodeAt(i)] << 2) |
          (revLookup$1[b64.charCodeAt(i + 1)] >> 4);
        arr[curByte++] = tmp & 0xFF;
      }

      if (placeHoldersLen === 1) {
        tmp =
          (revLookup$1[b64.charCodeAt(i)] << 10) |
          (revLookup$1[b64.charCodeAt(i + 1)] << 4) |
          (revLookup$1[b64.charCodeAt(i + 2)] >> 2);
        arr[curByte++] = (tmp >> 8) & 0xFF;
        arr[curByte++] = tmp & 0xFF;
      }

      return arr
    }

    function tripletToBase64$1 (num) {
      return lookup$1[num >> 18 & 0x3F] +
        lookup$1[num >> 12 & 0x3F] +
        lookup$1[num >> 6 & 0x3F] +
        lookup$1[num & 0x3F]
    }

    function encodeChunk$1 (uint8, start, end) {
      var tmp;
      var output = [];
      for (var i = start; i < end; i += 3) {
        tmp =
          ((uint8[i] << 16) & 0xFF0000) +
          ((uint8[i + 1] << 8) & 0xFF00) +
          (uint8[i + 2] & 0xFF);
        output.push(tripletToBase64$1(tmp));
      }
      return output.join('')
    }

    function fromByteArray$1 (uint8) {
      var tmp;
      var len = uint8.length;
      var extraBytes = len % 3; // if we have 1 byte left, pad 2 bytes
      var parts = [];
      var maxChunkLength = 16383; // must be multiple of 3

      // go through the array every three bytes, we'll deal with trailing stuff later
      for (var i = 0, len2 = len - extraBytes; i < len2; i += maxChunkLength) {
        parts.push(encodeChunk$1(
          uint8, i, (i + maxChunkLength) > len2 ? len2 : (i + maxChunkLength)
        ));
      }

      // pad the end with zeros, but make sure to not forget the extra bytes
      if (extraBytes === 1) {
        tmp = uint8[len - 1];
        parts.push(
          lookup$1[tmp >> 2] +
          lookup$1[(tmp << 4) & 0x3F] +
          '=='
        );
      } else if (extraBytes === 2) {
        tmp = (uint8[len - 2] << 8) + uint8[len - 1];
        parts.push(
          lookup$1[tmp >> 10] +
          lookup$1[(tmp >> 4) & 0x3F] +
          lookup$1[(tmp << 2) & 0x3F] +
          '='
        );
      }

      return parts.join('')
    }

    var base64Js = {
    	byteLength: byteLength_1,
    	toByteArray: toByteArray_1,
    	fromByteArray: fromByteArray_1
    };

    var Transform$3 = readable.Transform;



    /* global FileReader */
    var my;
    var proxy$1;
    var stream$2;
    var isInitialized = false;

    function buildProxy$1 () {
      var proxy = new Transform$3();
      proxy._write = function (chunk, encoding, next) {
        my.sendSocketMessage({
          data: chunk.buffer,
          success: function () {
            next();
          },
          fail: function () {
            next(new Error());
          }
        });
      };
      proxy._flush = function socketEnd (done) {
        my.closeSocket({
          success: function () {
            done();
          }
        });
      };

      return proxy
    }

    function setDefaultOpts$1 (opts) {
      if (!opts.hostname) {
        opts.hostname = 'localhost';
      }
      if (!opts.path) {
        opts.path = '/';
      }

      if (!opts.wsOptions) {
        opts.wsOptions = {};
      }
    }

    function buildUrl$1 (opts, client) {
      var protocol = opts.protocol === 'alis' ? 'wss' : 'ws';
      var url = protocol + '://' + opts.hostname + opts.path;
      if (opts.port && opts.port !== 80 && opts.port !== 443) {
        url = protocol + '://' + opts.hostname + ':' + opts.port + opts.path;
      }
      if (typeof (opts.transformWsUrl) === 'function') {
        url = opts.transformWsUrl(url, opts, client);
      }
      return url
    }

    function bindEventHandler$1 () {
      if (isInitialized) return

      isInitialized = true;

      my.onSocketOpen(function () {
        stream$2.setReadable(proxy$1);
        stream$2.setWritable(proxy$1);
        stream$2.emit('connect');
      });

      my.onSocketMessage(function (res) {
        if (typeof res.data === 'string') {
          var array = base64Js.toByteArray(res.data);
          var buffer = Buffer.from(array);
          proxy$1.push(buffer);
        } else {
          var reader = new FileReader();
          reader.addEventListener('load', function () {
            var data = reader.result;

            if (data instanceof ArrayBuffer) data = Buffer.from(data);
            else data = Buffer.from(data, 'utf8');
            proxy$1.push(data);
          });
          reader.readAsArrayBuffer(res.data);
        }
      });

      my.onSocketClose(function () {
        stream$2.end();
        stream$2.destroy();
      });

      my.onSocketError(function (res) {
        stream$2.destroy(res);
      });
    }

    function buildStream$1 (client, opts) {
      opts.hostname = opts.hostname || opts.host;

      if (!opts.hostname) {
        throw new Error('Could not determine host. Specify host manually.')
      }

      var websocketSubProtocol =
        (opts.protocolId === 'MQIsdp') && (opts.protocolVersion === 3)
          ? 'mqttv3.1'
          : 'mqtt';

      setDefaultOpts$1(opts);

      var url = buildUrl$1(opts, client);
      my = opts.my;
      my.connectSocket({
        url: url,
        protocols: websocketSubProtocol
      });

      proxy$1 = buildProxy$1();
      stream$2 = duplexify.obj();

      bindEventHandler$1();

      return stream$2
    }

    var ali = buildStream$1;

    var has = Object.prototype.hasOwnProperty;

    /**
     * An auto incrementing id which we can use to create "unique" Ultron instances
     * so we can track the event emitters that are added through the Ultron
     * interface.
     *
     * @type {Number}
     * @private
     */
    var id$2 = 0;

    /**
     * Ultron is high-intelligence robot. It gathers intelligence so it can start improving
     * upon his rudimentary design. It will learn from your EventEmitting patterns
     * and exterminate them.
     *
     * @constructor
     * @param {EventEmitter} ee EventEmitter instance we need to wrap.
     * @api public
     */
    function Ultron(ee) {
      if (!(this instanceof Ultron)) return new Ultron(ee);

      this.id = id$2++;
      this.ee = ee;
    }

    /**
     * Register a new EventListener for the given event.
     *
     * @param {String} event Name of the event.
     * @param {Functon} fn Callback function.
     * @param {Mixed} context The context of the function.
     * @returns {Ultron}
     * @api public
     */
    Ultron.prototype.on = function on(event, fn, context) {
      fn.__ultron = this.id;
      this.ee.on(event, fn, context);

      return this;
    };
    /**
     * Add an EventListener that's only called once.
     *
     * @param {String} event Name of the event.
     * @param {Function} fn Callback function.
     * @param {Mixed} context The context of the function.
     * @returns {Ultron}
     * @api public
     */
    Ultron.prototype.once = function once(event, fn, context) {
      fn.__ultron = this.id;
      this.ee.once(event, fn, context);

      return this;
    };

    /**
     * Remove the listeners we assigned for the given event.
     *
     * @returns {Ultron}
     * @api public
     */
    Ultron.prototype.remove = function remove() {
      var args = arguments
        , ee = this.ee
        , event;

      //
      // When no event names are provided we assume that we need to clear all the
      // events that were assigned through us.
      //
      if (args.length === 1 && 'string' === typeof args[0]) {
        args = args[0].split(/[, ]+/);
      } else if (!args.length) {
        if (ee.eventNames) {
          args = ee.eventNames();
        } else if (ee._events) {
          args = [];

          for (event in ee._events) {
            if (has.call(ee._events, event)) args.push(event);
          }

          if (Object.getOwnPropertySymbols) {
            args = args.concat(Object.getOwnPropertySymbols(ee._events));
          }
        }
      }

      for (var i = 0; i < args.length; i++) {
        var listeners = ee.listeners(args[i]);

        for (var j = 0; j < listeners.length; j++) {
          event = listeners[j];

          //
          // Once listeners have a `listener` property that stores the real listener
          // in the EventEmitter that ships with Node.js.
          //
          if (event.listener) {
            if (event.listener.__ultron !== this.id) continue;
          } else if (event.__ultron !== this.id) {
            continue;
          }

          ee.removeListener(args[i], event);
        }
      }

      return this;
    };

    /**
     * Destroy the Ultron instance, remove all listeners and release all references.
     *
     * @returns {Boolean}
     * @api public
     */
    Ultron.prototype.destroy = function destroy() {
      if (!this.ee) return false;

      this.remove();
      this.ee = null;

      return true;
    };

    //
    // Expose the module.
    //
    var ultron = Ultron;

    var hasFetch = isFunction$4(global.fetch) && isFunction$4(global.ReadableStream);

    var _blobConstructor;
    function blobConstructor() {
      if (typeof _blobConstructor !== 'undefined') {
        return _blobConstructor;
      }
      try {
        new global.Blob([new ArrayBuffer(1)]);
        _blobConstructor = true;
      } catch (e) {
        _blobConstructor = false;
      }
      return _blobConstructor
    }
    var xhr;

    function checkTypeSupport(type) {
      if (!xhr) {
        xhr = new global.XMLHttpRequest();
        // If location.host is empty, e.g. if this page/worker was loaded
        // from a Blob, then use example.com to avoid an error
        xhr.open('GET', global.location.host ? '/' : 'https://example.com');
      }
      try {
        xhr.responseType = type;
        return xhr.responseType === type
      } catch (e) {
        return false
      }

    }

    // For some strange reason, Safari 7.0 reports typeof global.ArrayBuffer === 'object'.
    // Safari 7.1 appears to have fixed this bug.
    var haveArrayBuffer = typeof global.ArrayBuffer !== 'undefined';
    var haveSlice = haveArrayBuffer && isFunction$4(global.ArrayBuffer.prototype.slice);

    var arraybuffer = haveArrayBuffer && checkTypeSupport('arraybuffer');
      // These next two tests unavoidably show warnings in Chrome. Since fetch will always
      // be used if it's available, just return false for these to avoid the warnings.
    var msstream = !hasFetch && haveSlice && checkTypeSupport('ms-stream');
    var mozchunkedarraybuffer = !hasFetch && haveArrayBuffer &&
      checkTypeSupport('moz-chunked-arraybuffer');
    var overrideMimeType = isFunction$4(xhr.overrideMimeType);
    var vbArray = isFunction$4(global.VBArray);

    function isFunction$4(value) {
      return typeof value === 'function'
    }

    xhr = null; // Help gc

    var rStates = {
      UNSENT: 0,
      OPENED: 1,
      HEADERS_RECEIVED: 2,
      LOADING: 3,
      DONE: 4
    };
    function IncomingMessage(xhr, response, mode) {
      var self = this;
      Readable.call(self);

      self._mode = mode;
      self.headers = {};
      self.rawHeaders = [];
      self.trailers = {};
      self.rawTrailers = [];

      // Fake the 'close' event, but only once 'end' fires
      self.on('end', function() {
        // The nextTick is necessary to prevent the 'request' module from causing an infinite loop
        process.nextTick(function() {
          self.emit('close');
        });
      });
      var read;
      if (mode === 'fetch') {
        self._fetchResponse = response;

        self.url = response.url;
        self.statusCode = response.status;
        self.statusMessage = response.statusText;
          // backwards compatible version of for (<item> of <iterable>):
          // for (var <item>,_i,_it = <iterable>[Symbol.iterator](); <item> = (_i = _it.next()).value,!_i.done;)
        for (var header, _i, _it = response.headers[Symbol.iterator](); header = (_i = _it.next()).value, !_i.done;) {
          self.headers[header[0].toLowerCase()] = header[1];
          self.rawHeaders.push(header[0], header[1]);
        }

        // TODO: this doesn't respect backpressure. Once WritableStream is available, this can be fixed
        var reader = response.body.getReader();

        read = function () {
          reader.read().then(function(result) {
            if (self._destroyed)
              return
            if (result.done) {
              self.push(null);
              return
            }
            self.push(new Buffer(result.value));
            read();
          });
        };
        read();

      } else {
        self._xhr = xhr;
        self._pos = 0;

        self.url = xhr.responseURL;
        self.statusCode = xhr.status;
        self.statusMessage = xhr.statusText;
        var headers = xhr.getAllResponseHeaders().split(/\r?\n/);
        headers.forEach(function(header) {
          var matches = header.match(/^([^:]+):\s*(.*)/);
          if (matches) {
            var key = matches[1].toLowerCase();
            if (key === 'set-cookie') {
              if (self.headers[key] === undefined) {
                self.headers[key] = [];
              }
              self.headers[key].push(matches[2]);
            } else if (self.headers[key] !== undefined) {
              self.headers[key] += ', ' + matches[2];
            } else {
              self.headers[key] = matches[2];
            }
            self.rawHeaders.push(matches[1], matches[2]);
          }
        });

        self._charset = 'x-user-defined';
        if (!overrideMimeType) {
          var mimeType = self.rawHeaders['mime-type'];
          if (mimeType) {
            var charsetMatch = mimeType.match(/;\s*charset=([^;])(;|$)/);
            if (charsetMatch) {
              self._charset = charsetMatch[1].toLowerCase();
            }
          }
          if (!self._charset)
            self._charset = 'utf-8'; // best guess
        }
      }
    }

    inherits$1(IncomingMessage, Readable);

    IncomingMessage.prototype._read = function() {};

    IncomingMessage.prototype._onXHRProgress = function() {
      var self = this;

      var xhr = self._xhr;

      var response = null;
      switch (self._mode) {
      case 'text:vbarray': // For IE9
        if (xhr.readyState !== rStates.DONE)
          break
        try {
          // This fails in IE8
          response = new global.VBArray(xhr.responseBody).toArray();
        } catch (e) {
          // pass
        }
        if (response !== null) {
          self.push(new Buffer(response));
          break
        }
        // Falls through in IE8
      case 'text':
        try { // This will fail when readyState = 3 in IE9. Switch mode and wait for readyState = 4
          response = xhr.responseText;
        } catch (e) {
          self._mode = 'text:vbarray';
          break
        }
        if (response.length > self._pos) {
          var newData = response.substr(self._pos);
          if (self._charset === 'x-user-defined') {
            var buffer = new Buffer(newData.length);
            for (var i = 0; i < newData.length; i++)
              buffer[i] = newData.charCodeAt(i) & 0xff;

            self.push(buffer);
          } else {
            self.push(newData, self._charset);
          }
          self._pos = response.length;
        }
        break
      case 'arraybuffer':
        if (xhr.readyState !== rStates.DONE || !xhr.response)
          break
        response = xhr.response;
        self.push(new Buffer(new Uint8Array(response)));
        break
      case 'moz-chunked-arraybuffer': // take whole
        response = xhr.response;
        if (xhr.readyState !== rStates.LOADING || !response)
          break
        self.push(new Buffer(new Uint8Array(response)));
        break
      case 'ms-stream':
        response = xhr.response;
        if (xhr.readyState !== rStates.LOADING)
          break
        var reader = new global.MSStreamReader();
        reader.onprogress = function() {
          if (reader.result.byteLength > self._pos) {
            self.push(new Buffer(new Uint8Array(reader.result.slice(self._pos))));
            self._pos = reader.result.byteLength;
          }
        };
        reader.onload = function() {
          self.push(null);
        };
          // reader.onerror = ??? // TODO: this
        reader.readAsArrayBuffer(response);
        break
      }

      // The ms-stream case handles end separately in reader.onload()
      if (self._xhr.readyState === rStates.DONE && self._mode !== 'ms-stream') {
        self.push(null);
      }
    };

    // from https://github.com/jhiesey/to-arraybuffer/blob/6502d9850e70ba7935a7df4ad86b358fc216f9f0/index.js
    function toArrayBuffer (buf) {
      // If the buffer is backed by a Uint8Array, a faster version will work
      if (buf instanceof Uint8Array) {
        // If the buffer isn't a subarray, return the underlying ArrayBuffer
        if (buf.byteOffset === 0 && buf.byteLength === buf.buffer.byteLength) {
          return buf.buffer
        } else if (typeof buf.buffer.slice === 'function') {
          // Otherwise we need to get a proper copy
          return buf.buffer.slice(buf.byteOffset, buf.byteOffset + buf.byteLength)
        }
      }

      if (isBuffer$1(buf)) {
        // This is the slow version that will work with any Buffer
        // implementation (even in old browsers)
        var arrayCopy = new Uint8Array(buf.length);
        var len = buf.length;
        for (var i = 0; i < len; i++) {
          arrayCopy[i] = buf[i];
        }
        return arrayCopy.buffer
      } else {
        throw new Error('Argument must be a Buffer')
      }
    }

    function decideMode(preferBinary, useFetch) {
      if (hasFetch && useFetch) {
        return 'fetch'
      } else if (mozchunkedarraybuffer) {
        return 'moz-chunked-arraybuffer'
      } else if (msstream) {
        return 'ms-stream'
      } else if (arraybuffer && preferBinary) {
        return 'arraybuffer'
      } else if (vbArray && preferBinary) {
        return 'text:vbarray'
      } else {
        return 'text'
      }
    }

    function ClientRequest(opts) {
      var self = this;
      Writable.call(self);

      self._opts = opts;
      self._body = [];
      self._headers = {};
      if (opts.auth)
        self.setHeader('Authorization', 'Basic ' + new Buffer(opts.auth).toString('base64'));
      Object.keys(opts.headers).forEach(function(name) {
        self.setHeader(name, opts.headers[name]);
      });

      var preferBinary;
      var useFetch = true;
      if (opts.mode === 'disable-fetch') {
        // If the use of XHR should be preferred and includes preserving the 'content-type' header
        useFetch = false;
        preferBinary = true;
      } else if (opts.mode === 'prefer-streaming') {
        // If streaming is a high priority but binary compatibility and
        // the accuracy of the 'content-type' header aren't
        preferBinary = false;
      } else if (opts.mode === 'allow-wrong-content-type') {
        // If streaming is more important than preserving the 'content-type' header
        preferBinary = !overrideMimeType;
      } else if (!opts.mode || opts.mode === 'default' || opts.mode === 'prefer-fast') {
        // Use binary if text streaming may corrupt data or the content-type header, or for speed
        preferBinary = true;
      } else {
        throw new Error('Invalid value for opts.mode')
      }
      self._mode = decideMode(preferBinary, useFetch);

      self.on('finish', function() {
        self._onFinish();
      });
    }

    inherits$1(ClientRequest, Writable);
    // Taken from http://www.w3.org/TR/XMLHttpRequest/#the-setrequestheader%28%29-method
    var unsafeHeaders = [
      'accept-charset',
      'accept-encoding',
      'access-control-request-headers',
      'access-control-request-method',
      'connection',
      'content-length',
      'cookie',
      'cookie2',
      'date',
      'dnt',
      'expect',
      'host',
      'keep-alive',
      'origin',
      'referer',
      'te',
      'trailer',
      'transfer-encoding',
      'upgrade',
      'user-agent',
      'via'
    ];
    ClientRequest.prototype.setHeader = function(name, value) {
      var self = this;
      var lowerName = name.toLowerCase();
        // This check is not necessary, but it prevents warnings from browsers about setting unsafe
        // headers. To be honest I'm not entirely sure hiding these warnings is a good thing, but
        // http-browserify did it, so I will too.
      if (unsafeHeaders.indexOf(lowerName) !== -1)
        return

      self._headers[lowerName] = {
        name: name,
        value: value
      };
    };

    ClientRequest.prototype.getHeader = function(name) {
      var self = this;
      return self._headers[name.toLowerCase()].value
    };

    ClientRequest.prototype.removeHeader = function(name) {
      var self = this;
      delete self._headers[name.toLowerCase()];
    };

    ClientRequest.prototype._onFinish = function() {
      var self = this;

      if (self._destroyed)
        return
      var opts = self._opts;

      var headersObj = self._headers;
      var body;
      if (opts.method === 'POST' || opts.method === 'PUT' || opts.method === 'PATCH') {
        if (blobConstructor()) {
          body = new global.Blob(self._body.map(function(buffer) {
            return toArrayBuffer(buffer)
          }), {
            type: (headersObj['content-type'] || {}).value || ''
          });
        } else {
          // get utf8 string
          body = Buffer.concat(self._body).toString();
        }
      }

      if (self._mode === 'fetch') {
        var headers = Object.keys(headersObj).map(function(name) {
          return [headersObj[name].name, headersObj[name].value]
        });

        global.fetch(self._opts.url, {
          method: self._opts.method,
          headers: headers,
          body: body,
          mode: 'cors',
          credentials: opts.withCredentials ? 'include' : 'same-origin'
        }).then(function(response) {
          self._fetchResponse = response;
          self._connect();
        }, function(reason) {
          self.emit('error', reason);
        });
      } else {
        var xhr = self._xhr = new global.XMLHttpRequest();
        try {
          xhr.open(self._opts.method, self._opts.url, true);
        } catch (err) {
          process.nextTick(function() {
            self.emit('error', err);
          });
          return
        }

        // Can't set responseType on really old browsers
        if ('responseType' in xhr)
          xhr.responseType = self._mode.split(':')[0];

        if ('withCredentials' in xhr)
          xhr.withCredentials = !!opts.withCredentials;

        if (self._mode === 'text' && 'overrideMimeType' in xhr)
          xhr.overrideMimeType('text/plain; charset=x-user-defined');

        Object.keys(headersObj).forEach(function(name) {
          xhr.setRequestHeader(headersObj[name].name, headersObj[name].value);
        });

        self._response = null;
        xhr.onreadystatechange = function() {
          switch (xhr.readyState) {
          case rStates.LOADING:
          case rStates.DONE:
            self._onXHRProgress();
            break
          }
        };
          // Necessary for streaming in Firefox, since xhr.response is ONLY defined
          // in onprogress, not in onreadystatechange with xhr.readyState = 3
        if (self._mode === 'moz-chunked-arraybuffer') {
          xhr.onprogress = function() {
            self._onXHRProgress();
          };
        }

        xhr.onerror = function() {
          if (self._destroyed)
            return
          self.emit('error', new Error('XHR error'));
        };

        try {
          xhr.send(body);
        } catch (err) {
          process.nextTick(function() {
            self.emit('error', err);
          });
          return
        }
      }
    };

    /**
     * Checks if xhr.status is readable and non-zero, indicating no error.
     * Even though the spec says it should be available in readyState 3,
     * accessing it throws an exception in IE8
     */
    function statusValid(xhr) {
      try {
        var status = xhr.status;
        return (status !== null && status !== 0)
      } catch (e) {
        return false
      }
    }

    ClientRequest.prototype._onXHRProgress = function() {
      var self = this;

      if (!statusValid(self._xhr) || self._destroyed)
        return

      if (!self._response)
        self._connect();

      self._response._onXHRProgress();
    };

    ClientRequest.prototype._connect = function() {
      var self = this;

      if (self._destroyed)
        return

      self._response = new IncomingMessage(self._xhr, self._fetchResponse, self._mode);
      self.emit('response', self._response);
    };

    ClientRequest.prototype._write = function(chunk, encoding, cb) {
      var self = this;

      self._body.push(chunk);
      cb();
    };

    ClientRequest.prototype.abort = ClientRequest.prototype.destroy = function() {
      var self = this;
      self._destroyed = true;
      if (self._response)
        self._response._destroyed = true;
      if (self._xhr)
        self._xhr.abort();
        // Currently, there isn't a way to truly abort a fetch.
        // If you like bikeshedding, see https://github.com/whatwg/fetch/issues/27
    };

    ClientRequest.prototype.end = function(data, encoding, cb) {
      var self = this;
      if (typeof data === 'function') {
        cb = data;
        data = undefined;
      }

      Writable.prototype.end.call(self, data, encoding, cb);
    };

    ClientRequest.prototype.flushHeaders = function() {};
    ClientRequest.prototype.setTimeout = function() {};
    ClientRequest.prototype.setNoDelay = function() {};
    ClientRequest.prototype.setSocketKeepAlive = function() {};

    /*
    this and http-lib folder

    The MIT License

    Copyright (c) 2015 John Hiesey

    Permission is hereby granted, free of charge,
    to any person obtaining a copy of this software and
    associated documentation files (the "Software"), to
    deal in the Software without restriction, including
    without limitation the rights to use, copy, modify,
    merge, publish, distribute, sublicense, and/or sell
    copies of the Software, and to permit persons to whom
    the Software is furnished to do so,
    subject to the following conditions:

    The above copyright notice and this permission notice
    shall be included in all copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
    EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
    OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
    IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR
    ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
    TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
    SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

    */

    function request(opts, cb) {
      if (typeof opts === 'string')
        opts = urlParse(opts);


      // Normally, the page is loaded from http or https, so not specifying a protocol
      // will result in a (valid) protocol-relative url. However, this won't work if
      // the protocol is something else, like 'file:'
      var defaultProtocol = global.location.protocol.search(/^https?:$/) === -1 ? 'http:' : '';

      var protocol = opts.protocol || defaultProtocol;
      var host = opts.hostname || opts.host;
      var port = opts.port;
      var path = opts.path || '/';

      // Necessary for IPv6 addresses
      if (host && host.indexOf(':') !== -1)
        host = '[' + host + ']';

      // This may be a relative url. The browser should always be able to interpret it correctly.
      opts.url = (host ? (protocol + '//' + host) : '') + (port ? ':' + port : '') + path;
      opts.method = (opts.method || 'GET').toUpperCase();
      opts.headers = opts.headers || {};

      // Also valid opts.auth, opts.mode

      var req = new ClientRequest(opts);
      if (cb)
        req.on('response', cb);
      return req
    }

    function get$1(opts, cb) {
      var req = request(opts, cb);
      req.end();
      return req
    }

    function Agent() {}
    Agent.defaultMaxSockets = 4;

    var METHODS = [
      'CHECKOUT',
      'CONNECT',
      'COPY',
      'DELETE',
      'GET',
      'HEAD',
      'LOCK',
      'M-SEARCH',
      'MERGE',
      'MKACTIVITY',
      'MKCOL',
      'MOVE',
      'NOTIFY',
      'OPTIONS',
      'PATCH',
      'POST',
      'PROPFIND',
      'PROPPATCH',
      'PURGE',
      'PUT',
      'REPORT',
      'SEARCH',
      'SUBSCRIBE',
      'TRACE',
      'UNLOCK',
      'UNSUBSCRIBE'
    ];
    var STATUS_CODES = {
      100: 'Continue',
      101: 'Switching Protocols',
      102: 'Processing', // RFC 2518, obsoleted by RFC 4918
      200: 'OK',
      201: 'Created',
      202: 'Accepted',
      203: 'Non-Authoritative Information',
      204: 'No Content',
      205: 'Reset Content',
      206: 'Partial Content',
      207: 'Multi-Status', // RFC 4918
      300: 'Multiple Choices',
      301: 'Moved Permanently',
      302: 'Moved Temporarily',
      303: 'See Other',
      304: 'Not Modified',
      305: 'Use Proxy',
      307: 'Temporary Redirect',
      400: 'Bad Request',
      401: 'Unauthorized',
      402: 'Payment Required',
      403: 'Forbidden',
      404: 'Not Found',
      405: 'Method Not Allowed',
      406: 'Not Acceptable',
      407: 'Proxy Authentication Required',
      408: 'Request Time-out',
      409: 'Conflict',
      410: 'Gone',
      411: 'Length Required',
      412: 'Precondition Failed',
      413: 'Request Entity Too Large',
      414: 'Request-URI Too Large',
      415: 'Unsupported Media Type',
      416: 'Requested Range Not Satisfiable',
      417: 'Expectation Failed',
      418: 'I\'m a teapot', // RFC 2324
      422: 'Unprocessable Entity', // RFC 4918
      423: 'Locked', // RFC 4918
      424: 'Failed Dependency', // RFC 4918
      425: 'Unordered Collection', // RFC 4918
      426: 'Upgrade Required', // RFC 2817
      428: 'Precondition Required', // RFC 6585
      429: 'Too Many Requests', // RFC 6585
      431: 'Request Header Fields Too Large', // RFC 6585
      500: 'Internal Server Error',
      501: 'Not Implemented',
      502: 'Bad Gateway',
      503: 'Service Unavailable',
      504: 'Gateway Time-out',
      505: 'HTTP Version Not Supported',
      506: 'Variant Also Negotiates', // RFC 2295
      507: 'Insufficient Storage', // RFC 4918
      509: 'Bandwidth Limit Exceeded',
      510: 'Not Extended', // RFC 2774
      511: 'Network Authentication Required' // RFC 6585
    };

    var http = {
      request,
      get: get$1,
      Agent,
      METHODS,
      STATUS_CODES
    };

    var safeBuffer$2 = createCommonjsModule(function (module, exports) {
    /* eslint-disable node/no-deprecated-api */

    var Buffer = bufferEs6.Buffer;

    // alternative to using Object.keys for old browsers
    function copyProps (src, dst) {
      for (var key in src) {
        dst[key] = src[key];
      }
    }
    if (Buffer.from && Buffer.alloc && Buffer.allocUnsafe && Buffer.allocUnsafeSlow) {
      module.exports = bufferEs6;
    } else {
      // Copy properties from require('buffer')
      copyProps(bufferEs6, exports);
      exports.Buffer = SafeBuffer;
    }

    function SafeBuffer (arg, encodingOrOffset, length) {
      return Buffer(arg, encodingOrOffset, length)
    }

    // Copy static methods from Buffer
    copyProps(Buffer, SafeBuffer);

    SafeBuffer.from = function (arg, encodingOrOffset, length) {
      if (typeof arg === 'number') {
        throw new TypeError('Argument must not be a number')
      }
      return Buffer(arg, encodingOrOffset, length)
    };

    SafeBuffer.alloc = function (size, fill, encoding) {
      if (typeof size !== 'number') {
        throw new TypeError('Argument must be a number')
      }
      var buf = Buffer(size);
      if (fill !== undefined) {
        if (typeof encoding === 'string') {
          buf.fill(fill, encoding);
        } else {
          buf.fill(fill);
        }
      } else {
        buf.fill(0);
      }
      return buf
    };

    SafeBuffer.allocUnsafe = function (size) {
      if (typeof size !== 'number') {
        throw new TypeError('Argument must be a number')
      }
      return Buffer(size)
    };

    SafeBuffer.allocUnsafeSlow = function (size) {
      if (typeof size !== 'number') {
        throw new TypeError('Argument must be a number')
      }
      return bufferEs6.SlowBuffer(size)
    };
    });
    var safeBuffer_1$2 = safeBuffer$2.Buffer;

    function Queue(options) {
      if (!(this instanceof Queue)) {
        return new Queue(options);
      }

      options = options || {};
      this.concurrency = options.concurrency || Infinity;
      this.pending = 0;
      this.jobs = [];
      this.cbs = [];
      this._done = done$2.bind(this);
    }

    var arrayAddMethods = [
      'push',
      'unshift',
      'splice'
    ];

    arrayAddMethods.forEach(function(method) {
      Queue.prototype[method] = function() {
        var methodResult = Array.prototype[method].apply(this.jobs, arguments);
        this._run();
        return methodResult;
      };
    });

    Object.defineProperty(Queue.prototype, 'length', {
      get: function() {
        return this.pending + this.jobs.length;
      }
    });

    Queue.prototype._run = function() {
      if (this.pending === this.concurrency) {
        return;
      }
      if (this.jobs.length) {
        var job = this.jobs.shift();
        this.pending++;
        job(this._done);
        this._run();
      }

      if (this.pending === 0) {
        while (this.cbs.length !== 0) {
          var cb = this.cbs.pop();
          process.nextTick(cb);
        }
      }
    };

    Queue.prototype.onDone = function(cb) {
      if (typeof cb === 'function') {
        this.cbs.push(cb);
        this._run();
      }
    };

    function done$2() {
      this.pending--;
      this._run();
    }

    var asyncLimiter = Queue;

    var msg = {
      2:      'need dictionary',     /* Z_NEED_DICT       2  */
      1:      'stream end',          /* Z_STREAM_END      1  */
      0:      '',                    /* Z_OK              0  */
      '-1':   'file error',          /* Z_ERRNO         (-1) */
      '-2':   'stream error',        /* Z_STREAM_ERROR  (-2) */
      '-3':   'data error',          /* Z_DATA_ERROR    (-3) */
      '-4':   'insufficient memory', /* Z_MEM_ERROR     (-4) */
      '-5':   'buffer error',        /* Z_BUF_ERROR     (-5) */
      '-6':   'incompatible version' /* Z_VERSION_ERROR (-6) */
    };

    function ZStream() {
      /* next input byte */
      this.input = null; // JS specific, because we have no pointers
      this.next_in = 0;
      /* number of bytes available at input */
      this.avail_in = 0;
      /* total number of input bytes read so far */
      this.total_in = 0;
      /* next output byte should be put there */
      this.output = null; // JS specific, because we have no pointers
      this.next_out = 0;
      /* remaining free space at output */
      this.avail_out = 0;
      /* total number of bytes output so far */
      this.total_out = 0;
      /* last error message, NULL if no error */
      this.msg = ''/*Z_NULL*/;
      /* not visible by applications */
      this.state = null;
      /* best guess about the data type: binary or text */
      this.data_type = 2/*Z_UNKNOWN*/;
      /* adler32 value of the uncompressed data */
      this.adler = 0;
    }

    function arraySet(dest, src, src_offs, len, dest_offs) {
      if (src.subarray && dest.subarray) {
        dest.set(src.subarray(src_offs, src_offs + len), dest_offs);
        return;
      }
      // Fallback to ordinary array
      for (var i = 0; i < len; i++) {
        dest[dest_offs + i] = src[src_offs + i];
      }
    }


    var Buf8 = Uint8Array;
    var Buf16 = Uint16Array;
    var Buf32 = Int32Array;
    // Enable/Disable typed arrays use, for testing
    //

    /* Public constants ==========================================================*/
    /* ===========================================================================*/


    //var Z_FILTERED          = 1;
    //var Z_HUFFMAN_ONLY      = 2;
    //var Z_RLE               = 3;
    var Z_FIXED = 4;
    //var Z_DEFAULT_STRATEGY  = 0;

    /* Possible values of the data_type field (though see inflate()) */
    var Z_BINARY = 0;
    var Z_TEXT = 1;
    //var Z_ASCII             = 1; // = Z_TEXT
    var Z_UNKNOWN = 2;

    /*============================================================================*/


    function zero(buf) {
      var len = buf.length;
      while (--len >= 0) {
        buf[len] = 0;
      }
    }

    // From zutil.h

    var STORED_BLOCK = 0;
    var STATIC_TREES = 1;
    var DYN_TREES = 2;
    /* The three kinds of block type */

    var MIN_MATCH = 3;
    var MAX_MATCH = 258;
    /* The minimum and maximum match lengths */

    // From deflate.h
    /* ===========================================================================
     * Internal compression state.
     */

    var LENGTH_CODES = 29;
    /* number of length codes, not counting the special END_BLOCK code */

    var LITERALS = 256;
    /* number of literal bytes 0..255 */

    var L_CODES = LITERALS + 1 + LENGTH_CODES;
    /* number of Literal or Length codes, including the END_BLOCK code */

    var D_CODES = 30;
    /* number of distance codes */

    var BL_CODES = 19;
    /* number of codes used to transfer the bit lengths */

    var HEAP_SIZE = 2 * L_CODES + 1;
    /* maximum heap size */

    var MAX_BITS = 15;
    /* All codes must not exceed MAX_BITS bits */

    var Buf_size = 16;
    /* size of bit buffer in bi_buf */


    /* ===========================================================================
     * Constants
     */

    var MAX_BL_BITS = 7;
    /* Bit length codes must not exceed MAX_BL_BITS bits */

    var END_BLOCK = 256;
    /* end of block literal code */

    var REP_3_6 = 16;
    /* repeat previous bit length 3-6 times (2 bits of repeat count) */

    var REPZ_3_10 = 17;
    /* repeat a zero length 3-10 times  (3 bits of repeat count) */

    var REPZ_11_138 = 18;
    /* repeat a zero length 11-138 times  (7 bits of repeat count) */

    /* eslint-disable comma-spacing,array-bracket-spacing */
    var extra_lbits = /* extra bits for each length code */ [0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 4, 4, 4, 4, 5, 5, 5, 5, 0];

    var extra_dbits = /* extra bits for each distance code */ [0, 0, 0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13];

    var extra_blbits = /* extra bits for each bit length code */ [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 3, 7];

    var bl_order = [16, 17, 18, 0, 8, 7, 9, 6, 10, 5, 11, 4, 12, 3, 13, 2, 14, 1, 15];
    /* eslint-enable comma-spacing,array-bracket-spacing */

    /* The lengths of the bit length codes are sent in order of decreasing
     * probability, to avoid transmitting the lengths for unused bit length codes.
     */

    /* ===========================================================================
     * Local data. These are initialized only once.
     */

    // We pre-fill arrays with 0 to avoid uninitialized gaps

    var DIST_CODE_LEN = 512; /* see definition of array dist_code below */

    // !!!! Use flat array insdead of structure, Freq = i*2, Len = i*2+1
    var static_ltree = new Array((L_CODES + 2) * 2);
    zero(static_ltree);
    /* The static literal tree. Since the bit lengths are imposed, there is no
     * need for the L_CODES extra codes used during heap construction. However
     * The codes 286 and 287 are needed to build a canonical tree (see _tr_init
     * below).
     */

    var static_dtree = new Array(D_CODES * 2);
    zero(static_dtree);
    /* The static distance tree. (Actually a trivial tree since all codes use
     * 5 bits.)
     */

    var _dist_code = new Array(DIST_CODE_LEN);
    zero(_dist_code);
    /* Distance codes. The first 256 values correspond to the distances
     * 3 .. 258, the last 256 values correspond to the top 8 bits of
     * the 15 bit distances.
     */

    var _length_code = new Array(MAX_MATCH - MIN_MATCH + 1);
    zero(_length_code);
    /* length code for each normalized match length (0 == MIN_MATCH) */

    var base_length = new Array(LENGTH_CODES);
    zero(base_length);
    /* First normalized length for each code (0 = MIN_MATCH) */

    var base_dist = new Array(D_CODES);
    zero(base_dist);
    /* First normalized distance for each code (0 = distance of 1) */


    function StaticTreeDesc(static_tree, extra_bits, extra_base, elems, max_length) {

      this.static_tree = static_tree; /* static tree or NULL */
      this.extra_bits = extra_bits; /* extra bits for each code or NULL */
      this.extra_base = extra_base; /* base index for extra_bits */
      this.elems = elems; /* max number of elements in the tree */
      this.max_length = max_length; /* max bit length for the codes */

      // show if `static_tree` has data or dummy - needed for monomorphic objects
      this.has_stree = static_tree && static_tree.length;
    }


    var static_l_desc;
    var static_d_desc;
    var static_bl_desc;


    function TreeDesc(dyn_tree, stat_desc) {
      this.dyn_tree = dyn_tree; /* the dynamic tree */
      this.max_code = 0; /* largest code with non zero frequency */
      this.stat_desc = stat_desc; /* the corresponding static tree */
    }



    function d_code(dist) {
      return dist < 256 ? _dist_code[dist] : _dist_code[256 + (dist >>> 7)];
    }


    /* ===========================================================================
     * Output a short LSB first on the stream.
     * IN assertion: there is enough room in pendingBuf.
     */
    function put_short(s, w) {
      //    put_byte(s, (uch)((w) & 0xff));
      //    put_byte(s, (uch)((ush)(w) >> 8));
      s.pending_buf[s.pending++] = (w) & 0xff;
      s.pending_buf[s.pending++] = (w >>> 8) & 0xff;
    }


    /* ===========================================================================
     * Send a value on a given number of bits.
     * IN assertion: length <= 16 and value fits in length bits.
     */
    function send_bits(s, value, length) {
      if (s.bi_valid > (Buf_size - length)) {
        s.bi_buf |= (value << s.bi_valid) & 0xffff;
        put_short(s, s.bi_buf);
        s.bi_buf = value >> (Buf_size - s.bi_valid);
        s.bi_valid += length - Buf_size;
      } else {
        s.bi_buf |= (value << s.bi_valid) & 0xffff;
        s.bi_valid += length;
      }
    }


    function send_code(s, c, tree) {
      send_bits(s, tree[c * 2] /*.Code*/ , tree[c * 2 + 1] /*.Len*/ );
    }


    /* ===========================================================================
     * Reverse the first len bits of a code, using straightforward code (a faster
     * method would use a table)
     * IN assertion: 1 <= len <= 15
     */
    function bi_reverse(code, len) {
      var res = 0;
      do {
        res |= code & 1;
        code >>>= 1;
        res <<= 1;
      } while (--len > 0);
      return res >>> 1;
    }


    /* ===========================================================================
     * Flush the bit buffer, keeping at most 7 bits in it.
     */
    function bi_flush(s) {
      if (s.bi_valid === 16) {
        put_short(s, s.bi_buf);
        s.bi_buf = 0;
        s.bi_valid = 0;

      } else if (s.bi_valid >= 8) {
        s.pending_buf[s.pending++] = s.bi_buf & 0xff;
        s.bi_buf >>= 8;
        s.bi_valid -= 8;
      }
    }


    /* ===========================================================================
     * Compute the optimal bit lengths for a tree and update the total bit length
     * for the current block.
     * IN assertion: the fields freq and dad are set, heap[heap_max] and
     *    above are the tree nodes sorted by increasing frequency.
     * OUT assertions: the field len is set to the optimal bit length, the
     *     array bl_count contains the frequencies for each bit length.
     *     The length opt_len is updated; static_len is also updated if stree is
     *     not null.
     */
    function gen_bitlen(s, desc) {
    //    deflate_state *s;
    //    tree_desc *desc;    /* the tree descriptor */
      var tree = desc.dyn_tree;
      var max_code = desc.max_code;
      var stree = desc.stat_desc.static_tree;
      var has_stree = desc.stat_desc.has_stree;
      var extra = desc.stat_desc.extra_bits;
      var base = desc.stat_desc.extra_base;
      var max_length = desc.stat_desc.max_length;
      var h; /* heap index */
      var n, m; /* iterate over the tree elements */
      var bits; /* bit length */
      var xbits; /* extra bits */
      var f; /* frequency */
      var overflow = 0; /* number of elements with bit length too large */

      for (bits = 0; bits <= MAX_BITS; bits++) {
        s.bl_count[bits] = 0;
      }

      /* In a first pass, compute the optimal bit lengths (which may
       * overflow in the case of the bit length tree).
       */
      tree[s.heap[s.heap_max] * 2 + 1] /*.Len*/ = 0; /* root of the heap */

      for (h = s.heap_max + 1; h < HEAP_SIZE; h++) {
        n = s.heap[h];
        bits = tree[tree[n * 2 + 1] /*.Dad*/ * 2 + 1] /*.Len*/ + 1;
        if (bits > max_length) {
          bits = max_length;
          overflow++;
        }
        tree[n * 2 + 1] /*.Len*/ = bits;
        /* We overwrite tree[n].Dad which is no longer needed */

        if (n > max_code) {
          continue;
        } /* not a leaf node */

        s.bl_count[bits]++;
        xbits = 0;
        if (n >= base) {
          xbits = extra[n - base];
        }
        f = tree[n * 2] /*.Freq*/ ;
        s.opt_len += f * (bits + xbits);
        if (has_stree) {
          s.static_len += f * (stree[n * 2 + 1] /*.Len*/ + xbits);
        }
      }
      if (overflow === 0) {
        return;
      }

      // Trace((stderr,"\nbit length overflow\n"));
      /* This happens for example on obj2 and pic of the Calgary corpus */

      /* Find the first bit length which could increase: */
      do {
        bits = max_length - 1;
        while (s.bl_count[bits] === 0) {
          bits--;
        }
        s.bl_count[bits]--; /* move one leaf down the tree */
        s.bl_count[bits + 1] += 2; /* move one overflow item as its brother */
        s.bl_count[max_length]--;
        /* The brother of the overflow item also moves one step up,
         * but this does not affect bl_count[max_length]
         */
        overflow -= 2;
      } while (overflow > 0);

      /* Now recompute all bit lengths, scanning in increasing frequency.
       * h is still equal to HEAP_SIZE. (It is simpler to reconstruct all
       * lengths instead of fixing only the wrong ones. This idea is taken
       * from 'ar' written by Haruhiko Okumura.)
       */
      for (bits = max_length; bits !== 0; bits--) {
        n = s.bl_count[bits];
        while (n !== 0) {
          m = s.heap[--h];
          if (m > max_code) {
            continue;
          }
          if (tree[m * 2 + 1] /*.Len*/ !== bits) {
            // Trace((stderr,"code %d bits %d->%d\n", m, tree[m].Len, bits));
            s.opt_len += (bits - tree[m * 2 + 1] /*.Len*/ ) * tree[m * 2] /*.Freq*/ ;
            tree[m * 2 + 1] /*.Len*/ = bits;
          }
          n--;
        }
      }
    }


    /* ===========================================================================
     * Generate the codes for a given tree and bit counts (which need not be
     * optimal).
     * IN assertion: the array bl_count contains the bit length statistics for
     * the given tree and the field len is set for all tree elements.
     * OUT assertion: the field code is set for all tree elements of non
     *     zero code length.
     */
    function gen_codes(tree, max_code, bl_count) {
    //    ct_data *tree;             /* the tree to decorate */
    //    int max_code;              /* largest code with non zero frequency */
    //    ushf *bl_count;            /* number of codes at each bit length */

      var next_code = new Array(MAX_BITS + 1); /* next code value for each bit length */
      var code = 0; /* running code value */
      var bits; /* bit index */
      var n; /* code index */

      /* The distribution counts are first used to generate the code values
       * without bit reversal.
       */
      for (bits = 1; bits <= MAX_BITS; bits++) {
        next_code[bits] = code = (code + bl_count[bits - 1]) << 1;
      }
      /* Check that the bit counts in bl_count are consistent. The last code
       * must be all ones.
       */
      //Assert (code + bl_count[MAX_BITS]-1 == (1<<MAX_BITS)-1,
      //        "inconsistent bit counts");
      //Tracev((stderr,"\ngen_codes: max_code %d ", max_code));

      for (n = 0; n <= max_code; n++) {
        var len = tree[n * 2 + 1] /*.Len*/ ;
        if (len === 0) {
          continue;
        }
        /* Now reverse the bits */
        tree[n * 2] /*.Code*/ = bi_reverse(next_code[len]++, len);

        //Tracecv(tree != static_ltree, (stderr,"\nn %3d %c l %2d c %4x (%x) ",
        //     n, (isgraph(n) ? n : ' '), len, tree[n].Code, next_code[len]-1));
      }
    }


    /* ===========================================================================
     * Initialize the various 'constant' tables.
     */
    function tr_static_init() {
      var n; /* iterates over tree elements */
      var bits; /* bit counter */
      var length; /* length value */
      var code; /* code value */
      var dist; /* distance index */
      var bl_count = new Array(MAX_BITS + 1);
      /* number of codes at each bit length for an optimal tree */

      // do check in _tr_init()
      //if (static_init_done) return;

      /* For some embedded targets, global variables are not initialized: */
      /*#ifdef NO_INIT_GLOBAL_POINTERS
        static_l_desc.static_tree = static_ltree;
        static_l_desc.extra_bits = extra_lbits;
        static_d_desc.static_tree = static_dtree;
        static_d_desc.extra_bits = extra_dbits;
        static_bl_desc.extra_bits = extra_blbits;
      #endif*/

      /* Initialize the mapping length (0..255) -> length code (0..28) */
      length = 0;
      for (code = 0; code < LENGTH_CODES - 1; code++) {
        base_length[code] = length;
        for (n = 0; n < (1 << extra_lbits[code]); n++) {
          _length_code[length++] = code;
        }
      }
      //Assert (length == 256, "tr_static_init: length != 256");
      /* Note that the length 255 (match length 258) can be represented
       * in two different ways: code 284 + 5 bits or code 285, so we
       * overwrite length_code[255] to use the best encoding:
       */
      _length_code[length - 1] = code;

      /* Initialize the mapping dist (0..32K) -> dist code (0..29) */
      dist = 0;
      for (code = 0; code < 16; code++) {
        base_dist[code] = dist;
        for (n = 0; n < (1 << extra_dbits[code]); n++) {
          _dist_code[dist++] = code;
        }
      }
      //Assert (dist == 256, "tr_static_init: dist != 256");
      dist >>= 7; /* from now on, all distances are divided by 128 */
      for (; code < D_CODES; code++) {
        base_dist[code] = dist << 7;
        for (n = 0; n < (1 << (extra_dbits[code] - 7)); n++) {
          _dist_code[256 + dist++] = code;
        }
      }
      //Assert (dist == 256, "tr_static_init: 256+dist != 512");

      /* Construct the codes of the static literal tree */
      for (bits = 0; bits <= MAX_BITS; bits++) {
        bl_count[bits] = 0;
      }

      n = 0;
      while (n <= 143) {
        static_ltree[n * 2 + 1] /*.Len*/ = 8;
        n++;
        bl_count[8]++;
      }
      while (n <= 255) {
        static_ltree[n * 2 + 1] /*.Len*/ = 9;
        n++;
        bl_count[9]++;
      }
      while (n <= 279) {
        static_ltree[n * 2 + 1] /*.Len*/ = 7;
        n++;
        bl_count[7]++;
      }
      while (n <= 287) {
        static_ltree[n * 2 + 1] /*.Len*/ = 8;
        n++;
        bl_count[8]++;
      }
      /* Codes 286 and 287 do not exist, but we must include them in the
       * tree construction to get a canonical Huffman tree (longest code
       * all ones)
       */
      gen_codes(static_ltree, L_CODES + 1, bl_count);

      /* The static distance tree is trivial: */
      for (n = 0; n < D_CODES; n++) {
        static_dtree[n * 2 + 1] /*.Len*/ = 5;
        static_dtree[n * 2] /*.Code*/ = bi_reverse(n, 5);
      }

      // Now data ready and we can init static trees
      static_l_desc = new StaticTreeDesc(static_ltree, extra_lbits, LITERALS + 1, L_CODES, MAX_BITS);
      static_d_desc = new StaticTreeDesc(static_dtree, extra_dbits, 0, D_CODES, MAX_BITS);
      static_bl_desc = new StaticTreeDesc(new Array(0), extra_blbits, 0, BL_CODES, MAX_BL_BITS);

      //static_init_done = true;
    }


    /* ===========================================================================
     * Initialize a new block.
     */
    function init_block(s) {
      var n; /* iterates over tree elements */

      /* Initialize the trees. */
      for (n = 0; n < L_CODES; n++) {
        s.dyn_ltree[n * 2] /*.Freq*/ = 0;
      }
      for (n = 0; n < D_CODES; n++) {
        s.dyn_dtree[n * 2] /*.Freq*/ = 0;
      }
      for (n = 0; n < BL_CODES; n++) {
        s.bl_tree[n * 2] /*.Freq*/ = 0;
      }

      s.dyn_ltree[END_BLOCK * 2] /*.Freq*/ = 1;
      s.opt_len = s.static_len = 0;
      s.last_lit = s.matches = 0;
    }


    /* ===========================================================================
     * Flush the bit buffer and align the output on a byte boundary
     */
    function bi_windup(s) {
      if (s.bi_valid > 8) {
        put_short(s, s.bi_buf);
      } else if (s.bi_valid > 0) {
        //put_byte(s, (Byte)s->bi_buf);
        s.pending_buf[s.pending++] = s.bi_buf;
      }
      s.bi_buf = 0;
      s.bi_valid = 0;
    }

    /* ===========================================================================
     * Copy a stored block, storing first the length and its
     * one's complement if requested.
     */
    function copy_block(s, buf, len, header) {
    //DeflateState *s;
    //charf    *buf;    /* the input data */
    //unsigned len;     /* its length */
    //int      header;  /* true if block header must be written */

      bi_windup(s); /* align on byte boundary */

      if (header) {
        put_short(s, len);
        put_short(s, ~len);
      }
      //  while (len--) {
      //    put_byte(s, *buf++);
      //  }
      arraySet(s.pending_buf, s.window, buf, len, s.pending);
      s.pending += len;
    }

    /* ===========================================================================
     * Compares to subtrees, using the tree depth as tie breaker when
     * the subtrees have equal frequency. This minimizes the worst case length.
     */
    function smaller(tree, n, m, depth) {
      var _n2 = n * 2;
      var _m2 = m * 2;
      return (tree[_n2] /*.Freq*/ < tree[_m2] /*.Freq*/ ||
        (tree[_n2] /*.Freq*/ === tree[_m2] /*.Freq*/ && depth[n] <= depth[m]));
    }

    /* ===========================================================================
     * Restore the heap property by moving down the tree starting at node k,
     * exchanging a node with the smallest of its two sons if necessary, stopping
     * when the heap property is re-established (each father smaller than its
     * two sons).
     */
    function pqdownheap(s, tree, k)
    //    deflate_state *s;
    //    ct_data *tree;  /* the tree to restore */
    //    int k;               /* node to move down */
    {
      var v = s.heap[k];
      var j = k << 1; /* left son of k */
      while (j <= s.heap_len) {
        /* Set j to the smallest of the two sons: */
        if (j < s.heap_len &&
          smaller(tree, s.heap[j + 1], s.heap[j], s.depth)) {
          j++;
        }
        /* Exit if v is smaller than both sons */
        if (smaller(tree, v, s.heap[j], s.depth)) {
          break;
        }

        /* Exchange v with the smallest son */
        s.heap[k] = s.heap[j];
        k = j;

        /* And continue down the tree, setting j to the left son of k */
        j <<= 1;
      }
      s.heap[k] = v;
    }


    // inlined manually
    // var SMALLEST = 1;

    /* ===========================================================================
     * Send the block data compressed using the given Huffman trees
     */
    function compress_block(s, ltree, dtree)
    //    deflate_state *s;
    //    const ct_data *ltree; /* literal tree */
    //    const ct_data *dtree; /* distance tree */
    {
      var dist; /* distance of matched string */
      var lc; /* match length or unmatched char (if dist == 0) */
      var lx = 0; /* running index in l_buf */
      var code; /* the code to send */
      var extra; /* number of extra bits to send */

      if (s.last_lit !== 0) {
        do {
          dist = (s.pending_buf[s.d_buf + lx * 2] << 8) | (s.pending_buf[s.d_buf + lx * 2 + 1]);
          lc = s.pending_buf[s.l_buf + lx];
          lx++;

          if (dist === 0) {
            send_code(s, lc, ltree); /* send a literal byte */
            //Tracecv(isgraph(lc), (stderr," '%c' ", lc));
          } else {
            /* Here, lc is the match length - MIN_MATCH */
            code = _length_code[lc];
            send_code(s, code + LITERALS + 1, ltree); /* send the length code */
            extra = extra_lbits[code];
            if (extra !== 0) {
              lc -= base_length[code];
              send_bits(s, lc, extra); /* send the extra length bits */
            }
            dist--; /* dist is now the match distance - 1 */
            code = d_code(dist);
            //Assert (code < D_CODES, "bad d_code");

            send_code(s, code, dtree); /* send the distance code */
            extra = extra_dbits[code];
            if (extra !== 0) {
              dist -= base_dist[code];
              send_bits(s, dist, extra); /* send the extra distance bits */
            }
          } /* literal or match pair ? */

          /* Check that the overlay between pending_buf and d_buf+l_buf is ok: */
          //Assert((uInt)(s->pending) < s->lit_bufsize + 2*lx,
          //       "pendingBuf overflow");

        } while (lx < s.last_lit);
      }

      send_code(s, END_BLOCK, ltree);
    }


    /* ===========================================================================
     * Construct one Huffman tree and assigns the code bit strings and lengths.
     * Update the total bit length for the current block.
     * IN assertion: the field freq is set for all tree elements.
     * OUT assertions: the fields len and code are set to the optimal bit length
     *     and corresponding code. The length opt_len is updated; static_len is
     *     also updated if stree is not null. The field max_code is set.
     */
    function build_tree(s, desc)
    //    deflate_state *s;
    //    tree_desc *desc; /* the tree descriptor */
    {
      var tree = desc.dyn_tree;
      var stree = desc.stat_desc.static_tree;
      var has_stree = desc.stat_desc.has_stree;
      var elems = desc.stat_desc.elems;
      var n, m; /* iterate over heap elements */
      var max_code = -1; /* largest code with non zero frequency */
      var node; /* new node being created */

      /* Construct the initial heap, with least frequent element in
       * heap[SMALLEST]. The sons of heap[n] are heap[2*n] and heap[2*n+1].
       * heap[0] is not used.
       */
      s.heap_len = 0;
      s.heap_max = HEAP_SIZE;

      for (n = 0; n < elems; n++) {
        if (tree[n * 2] /*.Freq*/ !== 0) {
          s.heap[++s.heap_len] = max_code = n;
          s.depth[n] = 0;

        } else {
          tree[n * 2 + 1] /*.Len*/ = 0;
        }
      }

      /* The pkzip format requires that at least one distance code exists,
       * and that at least one bit should be sent even if there is only one
       * possible code. So to avoid special checks later on we force at least
       * two codes of non zero frequency.
       */
      while (s.heap_len < 2) {
        node = s.heap[++s.heap_len] = (max_code < 2 ? ++max_code : 0);
        tree[node * 2] /*.Freq*/ = 1;
        s.depth[node] = 0;
        s.opt_len--;

        if (has_stree) {
          s.static_len -= stree[node * 2 + 1] /*.Len*/ ;
        }
        /* node is 0 or 1 so it does not have extra bits */
      }
      desc.max_code = max_code;

      /* The elements heap[heap_len/2+1 .. heap_len] are leaves of the tree,
       * establish sub-heaps of increasing lengths:
       */
      for (n = (s.heap_len >> 1 /*int /2*/ ); n >= 1; n--) {
        pqdownheap(s, tree, n);
      }

      /* Construct the Huffman tree by repeatedly combining the least two
       * frequent nodes.
       */
      node = elems; /* next internal node of the tree */
      do {
        //pqremove(s, tree, n);  /* n = node of least frequency */
        /*** pqremove ***/
        n = s.heap[1 /*SMALLEST*/ ];
        s.heap[1 /*SMALLEST*/ ] = s.heap[s.heap_len--];
        pqdownheap(s, tree, 1 /*SMALLEST*/ );
        /***/

        m = s.heap[1 /*SMALLEST*/ ]; /* m = node of next least frequency */

        s.heap[--s.heap_max] = n; /* keep the nodes sorted by frequency */
        s.heap[--s.heap_max] = m;

        /* Create a new node father of n and m */
        tree[node * 2] /*.Freq*/ = tree[n * 2] /*.Freq*/ + tree[m * 2] /*.Freq*/ ;
        s.depth[node] = (s.depth[n] >= s.depth[m] ? s.depth[n] : s.depth[m]) + 1;
        tree[n * 2 + 1] /*.Dad*/ = tree[m * 2 + 1] /*.Dad*/ = node;

        /* and insert the new node in the heap */
        s.heap[1 /*SMALLEST*/ ] = node++;
        pqdownheap(s, tree, 1 /*SMALLEST*/ );

      } while (s.heap_len >= 2);

      s.heap[--s.heap_max] = s.heap[1 /*SMALLEST*/ ];

      /* At this point, the fields freq and dad are set. We can now
       * generate the bit lengths.
       */
      gen_bitlen(s, desc);

      /* The field len is now set, we can generate the bit codes */
      gen_codes(tree, max_code, s.bl_count);
    }


    /* ===========================================================================
     * Scan a literal or distance tree to determine the frequencies of the codes
     * in the bit length tree.
     */
    function scan_tree(s, tree, max_code)
    //    deflate_state *s;
    //    ct_data *tree;   /* the tree to be scanned */
    //    int max_code;    /* and its largest code of non zero frequency */
    {
      var n; /* iterates over all tree elements */
      var prevlen = -1; /* last emitted length */
      var curlen; /* length of current code */

      var nextlen = tree[0 * 2 + 1] /*.Len*/ ; /* length of next code */

      var count = 0; /* repeat count of the current code */
      var max_count = 7; /* max repeat count */
      var min_count = 4; /* min repeat count */

      if (nextlen === 0) {
        max_count = 138;
        min_count = 3;
      }
      tree[(max_code + 1) * 2 + 1] /*.Len*/ = 0xffff; /* guard */

      for (n = 0; n <= max_code; n++) {
        curlen = nextlen;
        nextlen = tree[(n + 1) * 2 + 1] /*.Len*/ ;

        if (++count < max_count && curlen === nextlen) {
          continue;

        } else if (count < min_count) {
          s.bl_tree[curlen * 2] /*.Freq*/ += count;

        } else if (curlen !== 0) {

          if (curlen !== prevlen) {
            s.bl_tree[curlen * 2] /*.Freq*/ ++;
          }
          s.bl_tree[REP_3_6 * 2] /*.Freq*/ ++;

        } else if (count <= 10) {
          s.bl_tree[REPZ_3_10 * 2] /*.Freq*/ ++;

        } else {
          s.bl_tree[REPZ_11_138 * 2] /*.Freq*/ ++;
        }

        count = 0;
        prevlen = curlen;

        if (nextlen === 0) {
          max_count = 138;
          min_count = 3;

        } else if (curlen === nextlen) {
          max_count = 6;
          min_count = 3;

        } else {
          max_count = 7;
          min_count = 4;
        }
      }
    }


    /* ===========================================================================
     * Send a literal or distance tree in compressed form, using the codes in
     * bl_tree.
     */
    function send_tree(s, tree, max_code)
    //    deflate_state *s;
    //    ct_data *tree; /* the tree to be scanned */
    //    int max_code;       /* and its largest code of non zero frequency */
    {
      var n; /* iterates over all tree elements */
      var prevlen = -1; /* last emitted length */
      var curlen; /* length of current code */

      var nextlen = tree[0 * 2 + 1] /*.Len*/ ; /* length of next code */

      var count = 0; /* repeat count of the current code */
      var max_count = 7; /* max repeat count */
      var min_count = 4; /* min repeat count */

      /* tree[max_code+1].Len = -1; */
      /* guard already set */
      if (nextlen === 0) {
        max_count = 138;
        min_count = 3;
      }

      for (n = 0; n <= max_code; n++) {
        curlen = nextlen;
        nextlen = tree[(n + 1) * 2 + 1] /*.Len*/ ;

        if (++count < max_count && curlen === nextlen) {
          continue;

        } else if (count < min_count) {
          do {
            send_code(s, curlen, s.bl_tree);
          } while (--count !== 0);

        } else if (curlen !== 0) {
          if (curlen !== prevlen) {
            send_code(s, curlen, s.bl_tree);
            count--;
          }
          //Assert(count >= 3 && count <= 6, " 3_6?");
          send_code(s, REP_3_6, s.bl_tree);
          send_bits(s, count - 3, 2);

        } else if (count <= 10) {
          send_code(s, REPZ_3_10, s.bl_tree);
          send_bits(s, count - 3, 3);

        } else {
          send_code(s, REPZ_11_138, s.bl_tree);
          send_bits(s, count - 11, 7);
        }

        count = 0;
        prevlen = curlen;
        if (nextlen === 0) {
          max_count = 138;
          min_count = 3;

        } else if (curlen === nextlen) {
          max_count = 6;
          min_count = 3;

        } else {
          max_count = 7;
          min_count = 4;
        }
      }
    }


    /* ===========================================================================
     * Construct the Huffman tree for the bit lengths and return the index in
     * bl_order of the last bit length code to send.
     */
    function build_bl_tree(s) {
      var max_blindex; /* index of last bit length code of non zero freq */

      /* Determine the bit length frequencies for literal and distance trees */
      scan_tree(s, s.dyn_ltree, s.l_desc.max_code);
      scan_tree(s, s.dyn_dtree, s.d_desc.max_code);

      /* Build the bit length tree: */
      build_tree(s, s.bl_desc);
      /* opt_len now includes the length of the tree representations, except
       * the lengths of the bit lengths codes and the 5+5+4 bits for the counts.
       */

      /* Determine the number of bit length codes to send. The pkzip format
       * requires that at least 4 bit length codes be sent. (appnote.txt says
       * 3 but the actual value used is 4.)
       */
      for (max_blindex = BL_CODES - 1; max_blindex >= 3; max_blindex--) {
        if (s.bl_tree[bl_order[max_blindex] * 2 + 1] /*.Len*/ !== 0) {
          break;
        }
      }
      /* Update opt_len to include the bit length tree and counts */
      s.opt_len += 3 * (max_blindex + 1) + 5 + 5 + 4;
      //Tracev((stderr, "\ndyn trees: dyn %ld, stat %ld",
      //        s->opt_len, s->static_len));

      return max_blindex;
    }


    /* ===========================================================================
     * Send the header for a block using dynamic Huffman trees: the counts, the
     * lengths of the bit length codes, the literal tree and the distance tree.
     * IN assertion: lcodes >= 257, dcodes >= 1, blcodes >= 4.
     */
    function send_all_trees(s, lcodes, dcodes, blcodes)
    //    deflate_state *s;
    //    int lcodes, dcodes, blcodes; /* number of codes for each tree */
    {
      var rank; /* index in bl_order */

      //Assert (lcodes >= 257 && dcodes >= 1 && blcodes >= 4, "not enough codes");
      //Assert (lcodes <= L_CODES && dcodes <= D_CODES && blcodes <= BL_CODES,
      //        "too many codes");
      //Tracev((stderr, "\nbl counts: "));
      send_bits(s, lcodes - 257, 5); /* not +255 as stated in appnote.txt */
      send_bits(s, dcodes - 1, 5);
      send_bits(s, blcodes - 4, 4); /* not -3 as stated in appnote.txt */
      for (rank = 0; rank < blcodes; rank++) {
        //Tracev((stderr, "\nbl code %2d ", bl_order[rank]));
        send_bits(s, s.bl_tree[bl_order[rank] * 2 + 1] /*.Len*/ , 3);
      }
      //Tracev((stderr, "\nbl tree: sent %ld", s->bits_sent));

      send_tree(s, s.dyn_ltree, lcodes - 1); /* literal tree */
      //Tracev((stderr, "\nlit tree: sent %ld", s->bits_sent));

      send_tree(s, s.dyn_dtree, dcodes - 1); /* distance tree */
      //Tracev((stderr, "\ndist tree: sent %ld", s->bits_sent));
    }


    /* ===========================================================================
     * Check if the data type is TEXT or BINARY, using the following algorithm:
     * - TEXT if the two conditions below are satisfied:
     *    a) There are no non-portable control characters belonging to the
     *       "black list" (0..6, 14..25, 28..31).
     *    b) There is at least one printable character belonging to the
     *       "white list" (9 {TAB}, 10 {LF}, 13 {CR}, 32..255).
     * - BINARY otherwise.
     * - The following partially-portable control characters form a
     *   "gray list" that is ignored in this detection algorithm:
     *   (7 {BEL}, 8 {BS}, 11 {VT}, 12 {FF}, 26 {SUB}, 27 {ESC}).
     * IN assertion: the fields Freq of dyn_ltree are set.
     */
    function detect_data_type(s) {
      /* black_mask is the bit mask of black-listed bytes
       * set bits 0..6, 14..25, and 28..31
       * 0xf3ffc07f = binary 11110011111111111100000001111111
       */
      var black_mask = 0xf3ffc07f;
      var n;

      /* Check for non-textual ("black-listed") bytes. */
      for (n = 0; n <= 31; n++, black_mask >>>= 1) {
        if ((black_mask & 1) && (s.dyn_ltree[n * 2] /*.Freq*/ !== 0)) {
          return Z_BINARY;
        }
      }

      /* Check for textual ("white-listed") bytes. */
      if (s.dyn_ltree[9 * 2] /*.Freq*/ !== 0 || s.dyn_ltree[10 * 2] /*.Freq*/ !== 0 ||
        s.dyn_ltree[13 * 2] /*.Freq*/ !== 0) {
        return Z_TEXT;
      }
      for (n = 32; n < LITERALS; n++) {
        if (s.dyn_ltree[n * 2] /*.Freq*/ !== 0) {
          return Z_TEXT;
        }
      }

      /* There are no "black-listed" or "white-listed" bytes:
       * this stream either is empty or has tolerated ("gray-listed") bytes only.
       */
      return Z_BINARY;
    }


    var static_init_done = false;

    /* ===========================================================================
     * Initialize the tree data structures for a new zlib stream.
     */
    function _tr_init(s) {

      if (!static_init_done) {
        tr_static_init();
        static_init_done = true;
      }

      s.l_desc = new TreeDesc(s.dyn_ltree, static_l_desc);
      s.d_desc = new TreeDesc(s.dyn_dtree, static_d_desc);
      s.bl_desc = new TreeDesc(s.bl_tree, static_bl_desc);

      s.bi_buf = 0;
      s.bi_valid = 0;

      /* Initialize the first block of the first file: */
      init_block(s);
    }


    /* ===========================================================================
     * Send a stored block
     */
    function _tr_stored_block(s, buf, stored_len, last)
    //DeflateState *s;
    //charf *buf;       /* input block */
    //ulg stored_len;   /* length of input block */
    //int last;         /* one if this is the last block for a file */
    {
      send_bits(s, (STORED_BLOCK << 1) + (last ? 1 : 0), 3); /* send block type */
      copy_block(s, buf, stored_len, true); /* with header */
    }


    /* ===========================================================================
     * Send one empty static block to give enough lookahead for inflate.
     * This takes 10 bits, of which 7 may remain in the bit buffer.
     */
    function _tr_align(s) {
      send_bits(s, STATIC_TREES << 1, 3);
      send_code(s, END_BLOCK, static_ltree);
      bi_flush(s);
    }


    /* ===========================================================================
     * Determine the best encoding for the current block: dynamic trees, static
     * trees or store, and output the encoded block to the zip file.
     */
    function _tr_flush_block(s, buf, stored_len, last)
    //DeflateState *s;
    //charf *buf;       /* input block, or NULL if too old */
    //ulg stored_len;   /* length of input block */
    //int last;         /* one if this is the last block for a file */
    {
      var opt_lenb, static_lenb; /* opt_len and static_len in bytes */
      var max_blindex = 0; /* index of last bit length code of non zero freq */

      /* Build the Huffman trees unless a stored block is forced */
      if (s.level > 0) {

        /* Check if the file is binary or text */
        if (s.strm.data_type === Z_UNKNOWN) {
          s.strm.data_type = detect_data_type(s);
        }

        /* Construct the literal and distance trees */
        build_tree(s, s.l_desc);
        // Tracev((stderr, "\nlit data: dyn %ld, stat %ld", s->opt_len,
        //        s->static_len));

        build_tree(s, s.d_desc);
        // Tracev((stderr, "\ndist data: dyn %ld, stat %ld", s->opt_len,
        //        s->static_len));
        /* At this point, opt_len and static_len are the total bit lengths of
         * the compressed block data, excluding the tree representations.
         */

        /* Build the bit length tree for the above two trees, and get the index
         * in bl_order of the last bit length code to send.
         */
        max_blindex = build_bl_tree(s);

        /* Determine the best encoding. Compute the block lengths in bytes. */
        opt_lenb = (s.opt_len + 3 + 7) >>> 3;
        static_lenb = (s.static_len + 3 + 7) >>> 3;

        // Tracev((stderr, "\nopt %lu(%lu) stat %lu(%lu) stored %lu lit %u ",
        //        opt_lenb, s->opt_len, static_lenb, s->static_len, stored_len,
        //        s->last_lit));

        if (static_lenb <= opt_lenb) {
          opt_lenb = static_lenb;
        }

      } else {
        // Assert(buf != (char*)0, "lost buf");
        opt_lenb = static_lenb = stored_len + 5; /* force a stored block */
      }

      if ((stored_len + 4 <= opt_lenb) && (buf !== -1)) {
        /* 4: two words for the lengths */

        /* The test buf != NULL is only necessary if LIT_BUFSIZE > WSIZE.
         * Otherwise we can't have processed more than WSIZE input bytes since
         * the last block flush, because compression would have been
         * successful. If LIT_BUFSIZE <= WSIZE, it is never too late to
         * transform a block into a stored block.
         */
        _tr_stored_block(s, buf, stored_len, last);

      } else if (s.strategy === Z_FIXED || static_lenb === opt_lenb) {

        send_bits(s, (STATIC_TREES << 1) + (last ? 1 : 0), 3);
        compress_block(s, static_ltree, static_dtree);

      } else {
        send_bits(s, (DYN_TREES << 1) + (last ? 1 : 0), 3);
        send_all_trees(s, s.l_desc.max_code + 1, s.d_desc.max_code + 1, max_blindex + 1);
        compress_block(s, s.dyn_ltree, s.dyn_dtree);
      }
      // Assert (s->compressed_len == s->bits_sent, "bad compressed size");
      /* The above check is made mod 2^32, for files larger than 512 MB
       * and uLong implemented on 32 bits.
       */
      init_block(s);

      if (last) {
        bi_windup(s);
      }
      // Tracev((stderr,"\ncomprlen %lu(%lu) ", s->compressed_len>>3,
      //       s->compressed_len-7*last));
    }

    /* ===========================================================================
     * Save the match info and tally the frequency counts. Return true if
     * the current block must be flushed.
     */
    function _tr_tally(s, dist, lc)
    //    deflate_state *s;
    //    unsigned dist;  /* distance of matched string */
    //    unsigned lc;    /* match length-MIN_MATCH or unmatched char (if dist==0) */
    {
      //var out_length, in_length, dcode;

      s.pending_buf[s.d_buf + s.last_lit * 2] = (dist >>> 8) & 0xff;
      s.pending_buf[s.d_buf + s.last_lit * 2 + 1] = dist & 0xff;

      s.pending_buf[s.l_buf + s.last_lit] = lc & 0xff;
      s.last_lit++;

      if (dist === 0) {
        /* lc is the unmatched char */
        s.dyn_ltree[lc * 2] /*.Freq*/ ++;
      } else {
        s.matches++;
        /* Here, lc is the match length - MIN_MATCH */
        dist--; /* dist = match distance - 1 */
        //Assert((ush)dist < (ush)MAX_DIST(s) &&
        //       (ush)lc <= (ush)(MAX_MATCH-MIN_MATCH) &&
        //       (ush)d_code(dist) < (ush)D_CODES,  "_tr_tally: bad match");

        s.dyn_ltree[(_length_code[lc] + LITERALS + 1) * 2] /*.Freq*/ ++;
        s.dyn_dtree[d_code(dist) * 2] /*.Freq*/ ++;
      }

      // (!) This block is disabled in zlib defailts,
      // don't enable it for binary compatibility

      //#ifdef TRUNCATE_BLOCK
      //  /* Try to guess if it is profitable to stop the current block here */
      //  if ((s.last_lit & 0x1fff) === 0 && s.level > 2) {
      //    /* Compute an upper bound for the compressed length */
      //    out_length = s.last_lit*8;
      //    in_length = s.strstart - s.block_start;
      //
      //    for (dcode = 0; dcode < D_CODES; dcode++) {
      //      out_length += s.dyn_dtree[dcode*2]/*.Freq*/ * (5 + extra_dbits[dcode]);
      //    }
      //    out_length >>>= 3;
      //    //Tracev((stderr,"\nlast_lit %u, in %ld, out ~%ld(%ld%%) ",
      //    //       s->last_lit, in_length, out_length,
      //    //       100L - out_length*100L/in_length));
      //    if (s.matches < (s.last_lit>>1)/*int /2*/ && out_length < (in_length>>1)/*int /2*/) {
      //      return true;
      //    }
      //  }
      //#endif

      return (s.last_lit === s.lit_bufsize - 1);
      /* We avoid equality with lit_bufsize because of wraparound at 64K
       * on 16 bit machines and because stored blocks are restricted to
       * 64K-1 bytes.
       */
    }

    // Note: adler32 takes 12% for level 0 and 2% for level 6.
    // It doesn't worth to make additional optimizationa as in original.
    // Small size is preferable.

    function adler32(adler, buf, len, pos) {
      var s1 = (adler & 0xffff) |0,
          s2 = ((adler >>> 16) & 0xffff) |0,
          n = 0;

      while (len !== 0) {
        // Set limit ~ twice less than 5552, to keep
        // s2 in 31-bits, because we force signed ints.
        // in other case %= will fail.
        n = len > 2000 ? 2000 : len;
        len -= n;

        do {
          s1 = (s1 + buf[pos++]) |0;
          s2 = (s2 + s1) |0;
        } while (--n);

        s1 %= 65521;
        s2 %= 65521;
      }

      return (s1 | (s2 << 16)) |0;
    }

    // Note: we can't get significant speed boost here.
    // So write code to minimize size - no pregenerated tables
    // and array tools dependencies.


    // Use ordinary array, since untyped makes no boost here
    function makeTable() {
      var c, table = [];

      for (var n = 0; n < 256; n++) {
        c = n;
        for (var k = 0; k < 8; k++) {
          c = ((c & 1) ? (0xEDB88320 ^ (c >>> 1)) : (c >>> 1));
        }
        table[n] = c;
      }

      return table;
    }

    // Create table on load. Just 255 signed longs. Not a problem.
    var crcTable = makeTable();


    function crc32(crc, buf, len, pos) {
      var t = crcTable,
          end = pos + len;

      crc ^= -1;

      for (var i = pos; i < end; i++) {
        crc = (crc >>> 8) ^ t[(crc ^ buf[i]) & 0xFF];
      }

      return (crc ^ (-1)); // >>> 0;
    }

    /* Public constants ==========================================================*/
    /* ===========================================================================*/


    /* Allowed flush values; see deflate() and inflate() below for details */
    var Z_NO_FLUSH = 0;
    var Z_PARTIAL_FLUSH = 1;
    //var Z_SYNC_FLUSH    = 2;
    var Z_FULL_FLUSH = 3;
    var Z_FINISH = 4;
    var Z_BLOCK = 5;
    //var Z_TREES         = 6;


    /* Return codes for the compression/decompression functions. Negative values
     * are errors, positive values are used for special but normal events.
     */
    var Z_OK = 0;
    var Z_STREAM_END = 1;
    //var Z_NEED_DICT     = 2;
    //var Z_ERRNO         = -1;
    var Z_STREAM_ERROR = -2;
    var Z_DATA_ERROR = -3;
    //var Z_MEM_ERROR     = -4;
    var Z_BUF_ERROR = -5;
    //var Z_VERSION_ERROR = -6;


    /* compression levels */
    //var Z_NO_COMPRESSION      = 0;
    //var Z_BEST_SPEED          = 1;
    //var Z_BEST_COMPRESSION    = 9;
    var Z_DEFAULT_COMPRESSION = -1;


    var Z_FILTERED = 1;
    var Z_HUFFMAN_ONLY = 2;
    var Z_RLE = 3;
    var Z_FIXED$1 = 4;

    /* Possible values of the data_type field (though see inflate()) */
    //var Z_BINARY              = 0;
    //var Z_TEXT                = 1;
    //var Z_ASCII               = 1; // = Z_TEXT
    var Z_UNKNOWN$1 = 2;


    /* The deflate compression method */
    var Z_DEFLATED = 8;

    /*============================================================================*/


    var MAX_MEM_LEVEL = 9;


    var LENGTH_CODES$1 = 29;
    /* number of length codes, not counting the special END_BLOCK code */
    var LITERALS$1 = 256;
    /* number of literal bytes 0..255 */
    var L_CODES$1 = LITERALS$1 + 1 + LENGTH_CODES$1;
    /* number of Literal or Length codes, including the END_BLOCK code */
    var D_CODES$1 = 30;
    /* number of distance codes */
    var BL_CODES$1 = 19;
    /* number of codes used to transfer the bit lengths */
    var HEAP_SIZE$1 = 2 * L_CODES$1 + 1;
    /* maximum heap size */
    var MAX_BITS$1 = 15;
    /* All codes must not exceed MAX_BITS bits */

    var MIN_MATCH$1 = 3;
    var MAX_MATCH$1 = 258;
    var MIN_LOOKAHEAD = (MAX_MATCH$1 + MIN_MATCH$1 + 1);

    var PRESET_DICT = 0x20;

    var INIT_STATE = 42;
    var EXTRA_STATE = 69;
    var NAME_STATE = 73;
    var COMMENT_STATE = 91;
    var HCRC_STATE = 103;
    var BUSY_STATE = 113;
    var FINISH_STATE = 666;

    var BS_NEED_MORE = 1; /* block not completed, need more input or more output */
    var BS_BLOCK_DONE = 2; /* block flush performed */
    var BS_FINISH_STARTED = 3; /* finish started, need only more output at next deflate */
    var BS_FINISH_DONE = 4; /* finish done, accept no more input or output */

    var OS_CODE = 0x03; // Unix :) . Don't detect, use this default.

    function err(strm, errorCode) {
      strm.msg = msg[errorCode];
      return errorCode;
    }

    function rank(f) {
      return ((f) << 1) - ((f) > 4 ? 9 : 0);
    }

    function zero$1(buf) {
      var len = buf.length;
      while (--len >= 0) {
        buf[len] = 0;
      }
    }


    /* =========================================================================
     * Flush as much pending output as possible. All deflate() output goes
     * through this function so some applications may wish to modify it
     * to avoid allocating a large strm->output buffer and copying into it.
     * (See also read_buf()).
     */
    function flush_pending(strm) {
      var s = strm.state;

      //_tr_flush_bits(s);
      var len = s.pending;
      if (len > strm.avail_out) {
        len = strm.avail_out;
      }
      if (len === 0) {
        return;
      }

      arraySet(strm.output, s.pending_buf, s.pending_out, len, strm.next_out);
      strm.next_out += len;
      s.pending_out += len;
      strm.total_out += len;
      strm.avail_out -= len;
      s.pending -= len;
      if (s.pending === 0) {
        s.pending_out = 0;
      }
    }


    function flush_block_only(s, last) {
      _tr_flush_block(s, (s.block_start >= 0 ? s.block_start : -1), s.strstart - s.block_start, last);
      s.block_start = s.strstart;
      flush_pending(s.strm);
    }


    function put_byte(s, b) {
      s.pending_buf[s.pending++] = b;
    }


    /* =========================================================================
     * Put a short in the pending buffer. The 16-bit value is put in MSB order.
     * IN assertion: the stream state is correct and there is enough room in
     * pending_buf.
     */
    function putShortMSB(s, b) {
      //  put_byte(s, (Byte)(b >> 8));
      //  put_byte(s, (Byte)(b & 0xff));
      s.pending_buf[s.pending++] = (b >>> 8) & 0xff;
      s.pending_buf[s.pending++] = b & 0xff;
    }


    /* ===========================================================================
     * Read a new buffer from the current input stream, update the adler32
     * and total number of bytes read.  All deflate() input goes through
     * this function so some applications may wish to modify it to avoid
     * allocating a large strm->input buffer and copying from it.
     * (See also flush_pending()).
     */
    function read_buf(strm, buf, start, size) {
      var len = strm.avail_in;

      if (len > size) {
        len = size;
      }
      if (len === 0) {
        return 0;
      }

      strm.avail_in -= len;

      // zmemcpy(buf, strm->next_in, len);
      arraySet(buf, strm.input, strm.next_in, len, start);
      if (strm.state.wrap === 1) {
        strm.adler = adler32(strm.adler, buf, len, start);
      } else if (strm.state.wrap === 2) {
        strm.adler = crc32(strm.adler, buf, len, start);
      }

      strm.next_in += len;
      strm.total_in += len;

      return len;
    }


    /* ===========================================================================
     * Set match_start to the longest match starting at the given string and
     * return its length. Matches shorter or equal to prev_length are discarded,
     * in which case the result is equal to prev_length and match_start is
     * garbage.
     * IN assertions: cur_match is the head of the hash chain for the current
     *   string (strstart) and its distance is <= MAX_DIST, and prev_length >= 1
     * OUT assertion: the match length is not greater than s->lookahead.
     */
    function longest_match(s, cur_match) {
      var chain_length = s.max_chain_length; /* max hash chain length */
      var scan = s.strstart; /* current string */
      var match; /* matched string */
      var len; /* length of current match */
      var best_len = s.prev_length; /* best match length so far */
      var nice_match = s.nice_match; /* stop if match long enough */
      var limit = (s.strstart > (s.w_size - MIN_LOOKAHEAD)) ?
        s.strstart - (s.w_size - MIN_LOOKAHEAD) : 0 /*NIL*/ ;

      var _win = s.window; // shortcut

      var wmask = s.w_mask;
      var prev = s.prev;

      /* Stop when cur_match becomes <= limit. To simplify the code,
       * we prevent matches with the string of window index 0.
       */

      var strend = s.strstart + MAX_MATCH$1;
      var scan_end1 = _win[scan + best_len - 1];
      var scan_end = _win[scan + best_len];

      /* The code is optimized for HASH_BITS >= 8 and MAX_MATCH-2 multiple of 16.
       * It is easy to get rid of this optimization if necessary.
       */
      // Assert(s->hash_bits >= 8 && MAX_MATCH == 258, "Code too clever");

      /* Do not waste too much time if we already have a good match: */
      if (s.prev_length >= s.good_match) {
        chain_length >>= 2;
      }
      /* Do not look for matches beyond the end of the input. This is necessary
       * to make deflate deterministic.
       */
      if (nice_match > s.lookahead) {
        nice_match = s.lookahead;
      }

      // Assert((ulg)s->strstart <= s->window_size-MIN_LOOKAHEAD, "need lookahead");

      do {
        // Assert(cur_match < s->strstart, "no future");
        match = cur_match;

        /* Skip to next match if the match length cannot increase
         * or if the match length is less than 2.  Note that the checks below
         * for insufficient lookahead only occur occasionally for performance
         * reasons.  Therefore uninitialized memory will be accessed, and
         * conditional jumps will be made that depend on those values.
         * However the length of the match is limited to the lookahead, so
         * the output of deflate is not affected by the uninitialized values.
         */

        if (_win[match + best_len] !== scan_end ||
          _win[match + best_len - 1] !== scan_end1 ||
          _win[match] !== _win[scan] ||
          _win[++match] !== _win[scan + 1]) {
          continue;
        }

        /* The check at best_len-1 can be removed because it will be made
         * again later. (This heuristic is not always a win.)
         * It is not necessary to compare scan[2] and match[2] since they
         * are always equal when the other bytes match, given that
         * the hash keys are equal and that HASH_BITS >= 8.
         */
        scan += 2;
        match++;
        // Assert(*scan == *match, "match[2]?");

        /* We check for insufficient lookahead only every 8th comparison;
         * the 256th check will be made at strstart+258.
         */
        do {
          /*jshint noempty:false*/
        } while (_win[++scan] === _win[++match] && _win[++scan] === _win[++match] &&
          _win[++scan] === _win[++match] && _win[++scan] === _win[++match] &&
          _win[++scan] === _win[++match] && _win[++scan] === _win[++match] &&
          _win[++scan] === _win[++match] && _win[++scan] === _win[++match] &&
          scan < strend);

        // Assert(scan <= s->window+(unsigned)(s->window_size-1), "wild scan");

        len = MAX_MATCH$1 - (strend - scan);
        scan = strend - MAX_MATCH$1;

        if (len > best_len) {
          s.match_start = cur_match;
          best_len = len;
          if (len >= nice_match) {
            break;
          }
          scan_end1 = _win[scan + best_len - 1];
          scan_end = _win[scan + best_len];
        }
      } while ((cur_match = prev[cur_match & wmask]) > limit && --chain_length !== 0);

      if (best_len <= s.lookahead) {
        return best_len;
      }
      return s.lookahead;
    }


    /* ===========================================================================
     * Fill the window when the lookahead becomes insufficient.
     * Updates strstart and lookahead.
     *
     * IN assertion: lookahead < MIN_LOOKAHEAD
     * OUT assertions: strstart <= window_size-MIN_LOOKAHEAD
     *    At least one byte has been read, or avail_in == 0; reads are
     *    performed for at least two bytes (required for the zip translate_eol
     *    option -- not supported here).
     */
    function fill_window(s) {
      var _w_size = s.w_size;
      var p, n, m, more, str;

      //Assert(s->lookahead < MIN_LOOKAHEAD, "already enough lookahead");

      do {
        more = s.window_size - s.lookahead - s.strstart;

        // JS ints have 32 bit, block below not needed
        /* Deal with !@#$% 64K limit: */
        //if (sizeof(int) <= 2) {
        //    if (more == 0 && s->strstart == 0 && s->lookahead == 0) {
        //        more = wsize;
        //
        //  } else if (more == (unsigned)(-1)) {
        //        /* Very unlikely, but possible on 16 bit machine if
        //         * strstart == 0 && lookahead == 1 (input done a byte at time)
        //         */
        //        more--;
        //    }
        //}


        /* If the window is almost full and there is insufficient lookahead,
         * move the upper half to the lower one to make room in the upper half.
         */
        if (s.strstart >= _w_size + (_w_size - MIN_LOOKAHEAD)) {

          arraySet(s.window, s.window, _w_size, _w_size, 0);
          s.match_start -= _w_size;
          s.strstart -= _w_size;
          /* we now have strstart >= MAX_DIST */
          s.block_start -= _w_size;

          /* Slide the hash table (could be avoided with 32 bit values
           at the expense of memory usage). We slide even when level == 0
           to keep the hash table consistent if we switch back to level > 0
           later. (Using level 0 permanently is not an optimal usage of
           zlib, so we don't care about this pathological case.)
           */

          n = s.hash_size;
          p = n;
          do {
            m = s.head[--p];
            s.head[p] = (m >= _w_size ? m - _w_size : 0);
          } while (--n);

          n = _w_size;
          p = n;
          do {
            m = s.prev[--p];
            s.prev[p] = (m >= _w_size ? m - _w_size : 0);
            /* If n is not on any hash chain, prev[n] is garbage but
             * its value will never be used.
             */
          } while (--n);

          more += _w_size;
        }
        if (s.strm.avail_in === 0) {
          break;
        }

        /* If there was no sliding:
         *    strstart <= WSIZE+MAX_DIST-1 && lookahead <= MIN_LOOKAHEAD - 1 &&
         *    more == window_size - lookahead - strstart
         * => more >= window_size - (MIN_LOOKAHEAD-1 + WSIZE + MAX_DIST-1)
         * => more >= window_size - 2*WSIZE + 2
         * In the BIG_MEM or MMAP case (not yet supported),
         *   window_size == input_size + MIN_LOOKAHEAD  &&
         *   strstart + s->lookahead <= input_size => more >= MIN_LOOKAHEAD.
         * Otherwise, window_size == 2*WSIZE so more >= 2.
         * If there was sliding, more >= WSIZE. So in all cases, more >= 2.
         */
        //Assert(more >= 2, "more < 2");
        n = read_buf(s.strm, s.window, s.strstart + s.lookahead, more);
        s.lookahead += n;

        /* Initialize the hash value now that we have some input: */
        if (s.lookahead + s.insert >= MIN_MATCH$1) {
          str = s.strstart - s.insert;
          s.ins_h = s.window[str];

          /* UPDATE_HASH(s, s->ins_h, s->window[str + 1]); */
          s.ins_h = ((s.ins_h << s.hash_shift) ^ s.window[str + 1]) & s.hash_mask;
          //#if MIN_MATCH != 3
          //        Call update_hash() MIN_MATCH-3 more times
          //#endif
          while (s.insert) {
            /* UPDATE_HASH(s, s->ins_h, s->window[str + MIN_MATCH-1]); */
            s.ins_h = ((s.ins_h << s.hash_shift) ^ s.window[str + MIN_MATCH$1 - 1]) & s.hash_mask;

            s.prev[str & s.w_mask] = s.head[s.ins_h];
            s.head[s.ins_h] = str;
            str++;
            s.insert--;
            if (s.lookahead + s.insert < MIN_MATCH$1) {
              break;
            }
          }
        }
        /* If the whole input has less than MIN_MATCH bytes, ins_h is garbage,
         * but this is not important since only literal bytes will be emitted.
         */

      } while (s.lookahead < MIN_LOOKAHEAD && s.strm.avail_in !== 0);

      /* If the WIN_INIT bytes after the end of the current data have never been
       * written, then zero those bytes in order to avoid memory check reports of
       * the use of uninitialized (or uninitialised as Julian writes) bytes by
       * the longest match routines.  Update the high water mark for the next
       * time through here.  WIN_INIT is set to MAX_MATCH since the longest match
       * routines allow scanning to strstart + MAX_MATCH, ignoring lookahead.
       */
      //  if (s.high_water < s.window_size) {
      //    var curr = s.strstart + s.lookahead;
      //    var init = 0;
      //
      //    if (s.high_water < curr) {
      //      /* Previous high water mark below current data -- zero WIN_INIT
      //       * bytes or up to end of window, whichever is less.
      //       */
      //      init = s.window_size - curr;
      //      if (init > WIN_INIT)
      //        init = WIN_INIT;
      //      zmemzero(s->window + curr, (unsigned)init);
      //      s->high_water = curr + init;
      //    }
      //    else if (s->high_water < (ulg)curr + WIN_INIT) {
      //      /* High water mark at or above current data, but below current data
      //       * plus WIN_INIT -- zero out to current data plus WIN_INIT, or up
      //       * to end of window, whichever is less.
      //       */
      //      init = (ulg)curr + WIN_INIT - s->high_water;
      //      if (init > s->window_size - s->high_water)
      //        init = s->window_size - s->high_water;
      //      zmemzero(s->window + s->high_water, (unsigned)init);
      //      s->high_water += init;
      //    }
      //  }
      //
      //  Assert((ulg)s->strstart <= s->window_size - MIN_LOOKAHEAD,
      //    "not enough room for search");
    }

    /* ===========================================================================
     * Copy without compression as much as possible from the input stream, return
     * the current block state.
     * This function does not insert new strings in the dictionary since
     * uncompressible data is probably not useful. This function is used
     * only for the level=0 compression option.
     * NOTE: this function should be optimized to avoid extra copying from
     * window to pending_buf.
     */
    function deflate_stored(s, flush) {
      /* Stored blocks are limited to 0xffff bytes, pending_buf is limited
       * to pending_buf_size, and each stored block has a 5 byte header:
       */
      var max_block_size = 0xffff;

      if (max_block_size > s.pending_buf_size - 5) {
        max_block_size = s.pending_buf_size - 5;
      }

      /* Copy as much as possible from input to output: */
      for (;;) {
        /* Fill the window as much as possible: */
        if (s.lookahead <= 1) {

          //Assert(s->strstart < s->w_size+MAX_DIST(s) ||
          //  s->block_start >= (long)s->w_size, "slide too late");
          //      if (!(s.strstart < s.w_size + (s.w_size - MIN_LOOKAHEAD) ||
          //        s.block_start >= s.w_size)) {
          //        throw  new Error("slide too late");
          //      }

          fill_window(s);
          if (s.lookahead === 0 && flush === Z_NO_FLUSH) {
            return BS_NEED_MORE;
          }

          if (s.lookahead === 0) {
            break;
          }
          /* flush the current block */
        }
        //Assert(s->block_start >= 0L, "block gone");
        //    if (s.block_start < 0) throw new Error("block gone");

        s.strstart += s.lookahead;
        s.lookahead = 0;

        /* Emit a stored block if pending_buf will be full: */
        var max_start = s.block_start + max_block_size;

        if (s.strstart === 0 || s.strstart >= max_start) {
          /* strstart == 0 is possible when wraparound on 16-bit machine */
          s.lookahead = s.strstart - max_start;
          s.strstart = max_start;
          /*** FLUSH_BLOCK(s, 0); ***/
          flush_block_only(s, false);
          if (s.strm.avail_out === 0) {
            return BS_NEED_MORE;
          }
          /***/


        }
        /* Flush if we may have to slide, otherwise block_start may become
         * negative and the data will be gone:
         */
        if (s.strstart - s.block_start >= (s.w_size - MIN_LOOKAHEAD)) {
          /*** FLUSH_BLOCK(s, 0); ***/
          flush_block_only(s, false);
          if (s.strm.avail_out === 0) {
            return BS_NEED_MORE;
          }
          /***/
        }
      }

      s.insert = 0;

      if (flush === Z_FINISH) {
        /*** FLUSH_BLOCK(s, 1); ***/
        flush_block_only(s, true);
        if (s.strm.avail_out === 0) {
          return BS_FINISH_STARTED;
        }
        /***/
        return BS_FINISH_DONE;
      }

      if (s.strstart > s.block_start) {
        /*** FLUSH_BLOCK(s, 0); ***/
        flush_block_only(s, false);
        if (s.strm.avail_out === 0) {
          return BS_NEED_MORE;
        }
        /***/
      }

      return BS_NEED_MORE;
    }

    /* ===========================================================================
     * Compress as much as possible from the input stream, return the current
     * block state.
     * This function does not perform lazy evaluation of matches and inserts
     * new strings in the dictionary only for unmatched strings or for short
     * matches. It is used only for the fast compression options.
     */
    function deflate_fast(s, flush) {
      var hash_head; /* head of the hash chain */
      var bflush; /* set if current block must be flushed */

      for (;;) {
        /* Make sure that we always have enough lookahead, except
         * at the end of the input file. We need MAX_MATCH bytes
         * for the next match, plus MIN_MATCH bytes to insert the
         * string following the next match.
         */
        if (s.lookahead < MIN_LOOKAHEAD) {
          fill_window(s);
          if (s.lookahead < MIN_LOOKAHEAD && flush === Z_NO_FLUSH) {
            return BS_NEED_MORE;
          }
          if (s.lookahead === 0) {
            break; /* flush the current block */
          }
        }

        /* Insert the string window[strstart .. strstart+2] in the
         * dictionary, and set hash_head to the head of the hash chain:
         */
        hash_head = 0 /*NIL*/ ;
        if (s.lookahead >= MIN_MATCH$1) {
          /*** INSERT_STRING(s, s.strstart, hash_head); ***/
          s.ins_h = ((s.ins_h << s.hash_shift) ^ s.window[s.strstart + MIN_MATCH$1 - 1]) & s.hash_mask;
          hash_head = s.prev[s.strstart & s.w_mask] = s.head[s.ins_h];
          s.head[s.ins_h] = s.strstart;
          /***/
        }

        /* Find the longest match, discarding those <= prev_length.
         * At this point we have always match_length < MIN_MATCH
         */
        if (hash_head !== 0 /*NIL*/ && ((s.strstart - hash_head) <= (s.w_size - MIN_LOOKAHEAD))) {
          /* To simplify the code, we prevent matches with the string
           * of window index 0 (in particular we have to avoid a match
           * of the string with itself at the start of the input file).
           */
          s.match_length = longest_match(s, hash_head);
          /* longest_match() sets match_start */
        }
        if (s.match_length >= MIN_MATCH$1) {
          // check_match(s, s.strstart, s.match_start, s.match_length); // for debug only

          /*** _tr_tally_dist(s, s.strstart - s.match_start,
                         s.match_length - MIN_MATCH, bflush); ***/
          bflush = _tr_tally(s, s.strstart - s.match_start, s.match_length - MIN_MATCH$1);

          s.lookahead -= s.match_length;

          /* Insert new strings in the hash table only if the match length
           * is not too large. This saves time but degrades compression.
           */
          if (s.match_length <= s.max_lazy_match /*max_insert_length*/ && s.lookahead >= MIN_MATCH$1) {
            s.match_length--; /* string at strstart already in table */
            do {
              s.strstart++;
              /*** INSERT_STRING(s, s.strstart, hash_head); ***/
              s.ins_h = ((s.ins_h << s.hash_shift) ^ s.window[s.strstart + MIN_MATCH$1 - 1]) & s.hash_mask;
              hash_head = s.prev[s.strstart & s.w_mask] = s.head[s.ins_h];
              s.head[s.ins_h] = s.strstart;
              /***/
              /* strstart never exceeds WSIZE-MAX_MATCH, so there are
               * always MIN_MATCH bytes ahead.
               */
            } while (--s.match_length !== 0);
            s.strstart++;
          } else {
            s.strstart += s.match_length;
            s.match_length = 0;
            s.ins_h = s.window[s.strstart];
            /* UPDATE_HASH(s, s.ins_h, s.window[s.strstart+1]); */
            s.ins_h = ((s.ins_h << s.hash_shift) ^ s.window[s.strstart + 1]) & s.hash_mask;

            //#if MIN_MATCH != 3
            //                Call UPDATE_HASH() MIN_MATCH-3 more times
            //#endif
            /* If lookahead < MIN_MATCH, ins_h is garbage, but it does not
             * matter since it will be recomputed at next deflate call.
             */
          }
        } else {
          /* No match, output a literal byte */
          //Tracevv((stderr,"%c", s.window[s.strstart]));
          /*** _tr_tally_lit(s, s.window[s.strstart], bflush); ***/
          bflush = _tr_tally(s, 0, s.window[s.strstart]);

          s.lookahead--;
          s.strstart++;
        }
        if (bflush) {
          /*** FLUSH_BLOCK(s, 0); ***/
          flush_block_only(s, false);
          if (s.strm.avail_out === 0) {
            return BS_NEED_MORE;
          }
          /***/
        }
      }
      s.insert = ((s.strstart < (MIN_MATCH$1 - 1)) ? s.strstart : MIN_MATCH$1 - 1);
      if (flush === Z_FINISH) {
        /*** FLUSH_BLOCK(s, 1); ***/
        flush_block_only(s, true);
        if (s.strm.avail_out === 0) {
          return BS_FINISH_STARTED;
        }
        /***/
        return BS_FINISH_DONE;
      }
      if (s.last_lit) {
        /*** FLUSH_BLOCK(s, 0); ***/
        flush_block_only(s, false);
        if (s.strm.avail_out === 0) {
          return BS_NEED_MORE;
        }
        /***/
      }
      return BS_BLOCK_DONE;
    }

    /* ===========================================================================
     * Same as above, but achieves better compression. We use a lazy
     * evaluation for matches: a match is finally adopted only if there is
     * no better match at the next window position.
     */
    function deflate_slow(s, flush) {
      var hash_head; /* head of hash chain */
      var bflush; /* set if current block must be flushed */

      var max_insert;

      /* Process the input block. */
      for (;;) {
        /* Make sure that we always have enough lookahead, except
         * at the end of the input file. We need MAX_MATCH bytes
         * for the next match, plus MIN_MATCH bytes to insert the
         * string following the next match.
         */
        if (s.lookahead < MIN_LOOKAHEAD) {
          fill_window(s);
          if (s.lookahead < MIN_LOOKAHEAD && flush === Z_NO_FLUSH) {
            return BS_NEED_MORE;
          }
          if (s.lookahead === 0) {
            break;
          } /* flush the current block */
        }

        /* Insert the string window[strstart .. strstart+2] in the
         * dictionary, and set hash_head to the head of the hash chain:
         */
        hash_head = 0 /*NIL*/ ;
        if (s.lookahead >= MIN_MATCH$1) {
          /*** INSERT_STRING(s, s.strstart, hash_head); ***/
          s.ins_h = ((s.ins_h << s.hash_shift) ^ s.window[s.strstart + MIN_MATCH$1 - 1]) & s.hash_mask;
          hash_head = s.prev[s.strstart & s.w_mask] = s.head[s.ins_h];
          s.head[s.ins_h] = s.strstart;
          /***/
        }

        /* Find the longest match, discarding those <= prev_length.
         */
        s.prev_length = s.match_length;
        s.prev_match = s.match_start;
        s.match_length = MIN_MATCH$1 - 1;

        if (hash_head !== 0 /*NIL*/ && s.prev_length < s.max_lazy_match &&
          s.strstart - hash_head <= (s.w_size - MIN_LOOKAHEAD) /*MAX_DIST(s)*/ ) {
          /* To simplify the code, we prevent matches with the string
           * of window index 0 (in particular we have to avoid a match
           * of the string with itself at the start of the input file).
           */
          s.match_length = longest_match(s, hash_head);
          /* longest_match() sets match_start */

          if (s.match_length <= 5 &&
            (s.strategy === Z_FILTERED || (s.match_length === MIN_MATCH$1 && s.strstart - s.match_start > 4096 /*TOO_FAR*/ ))) {

            /* If prev_match is also MIN_MATCH, match_start is garbage
             * but we will ignore the current match anyway.
             */
            s.match_length = MIN_MATCH$1 - 1;
          }
        }
        /* If there was a match at the previous step and the current
         * match is not better, output the previous match:
         */
        if (s.prev_length >= MIN_MATCH$1 && s.match_length <= s.prev_length) {
          max_insert = s.strstart + s.lookahead - MIN_MATCH$1;
          /* Do not insert strings in hash table beyond this. */

          //check_match(s, s.strstart-1, s.prev_match, s.prev_length);

          /***_tr_tally_dist(s, s.strstart - 1 - s.prev_match,
                         s.prev_length - MIN_MATCH, bflush);***/
          bflush = _tr_tally(s, s.strstart - 1 - s.prev_match, s.prev_length - MIN_MATCH$1);
          /* Insert in hash table all strings up to the end of the match.
           * strstart-1 and strstart are already inserted. If there is not
           * enough lookahead, the last two strings are not inserted in
           * the hash table.
           */
          s.lookahead -= s.prev_length - 1;
          s.prev_length -= 2;
          do {
            if (++s.strstart <= max_insert) {
              /*** INSERT_STRING(s, s.strstart, hash_head); ***/
              s.ins_h = ((s.ins_h << s.hash_shift) ^ s.window[s.strstart + MIN_MATCH$1 - 1]) & s.hash_mask;
              hash_head = s.prev[s.strstart & s.w_mask] = s.head[s.ins_h];
              s.head[s.ins_h] = s.strstart;
              /***/
            }
          } while (--s.prev_length !== 0);
          s.match_available = 0;
          s.match_length = MIN_MATCH$1 - 1;
          s.strstart++;

          if (bflush) {
            /*** FLUSH_BLOCK(s, 0); ***/
            flush_block_only(s, false);
            if (s.strm.avail_out === 0) {
              return BS_NEED_MORE;
            }
            /***/
          }

        } else if (s.match_available) {
          /* If there was no match at the previous position, output a
           * single literal. If there was a match but the current match
           * is longer, truncate the previous match to a single literal.
           */
          //Tracevv((stderr,"%c", s->window[s->strstart-1]));
          /*** _tr_tally_lit(s, s.window[s.strstart-1], bflush); ***/
          bflush = _tr_tally(s, 0, s.window[s.strstart - 1]);

          if (bflush) {
            /*** FLUSH_BLOCK_ONLY(s, 0) ***/
            flush_block_only(s, false);
            /***/
          }
          s.strstart++;
          s.lookahead--;
          if (s.strm.avail_out === 0) {
            return BS_NEED_MORE;
          }
        } else {
          /* There is no previous match to compare with, wait for
           * the next step to decide.
           */
          s.match_available = 1;
          s.strstart++;
          s.lookahead--;
        }
      }
      //Assert (flush != Z_NO_FLUSH, "no flush?");
      if (s.match_available) {
        //Tracevv((stderr,"%c", s->window[s->strstart-1]));
        /*** _tr_tally_lit(s, s.window[s.strstart-1], bflush); ***/
        bflush = _tr_tally(s, 0, s.window[s.strstart - 1]);

        s.match_available = 0;
      }
      s.insert = s.strstart < MIN_MATCH$1 - 1 ? s.strstart : MIN_MATCH$1 - 1;
      if (flush === Z_FINISH) {
        /*** FLUSH_BLOCK(s, 1); ***/
        flush_block_only(s, true);
        if (s.strm.avail_out === 0) {
          return BS_FINISH_STARTED;
        }
        /***/
        return BS_FINISH_DONE;
      }
      if (s.last_lit) {
        /*** FLUSH_BLOCK(s, 0); ***/
        flush_block_only(s, false);
        if (s.strm.avail_out === 0) {
          return BS_NEED_MORE;
        }
        /***/
      }

      return BS_BLOCK_DONE;
    }


    /* ===========================================================================
     * For Z_RLE, simply look for runs of bytes, generate matches only of distance
     * one.  Do not maintain a hash table.  (It will be regenerated if this run of
     * deflate switches away from Z_RLE.)
     */
    function deflate_rle(s, flush) {
      var bflush; /* set if current block must be flushed */
      var prev; /* byte at distance one to match */
      var scan, strend; /* scan goes up to strend for length of run */

      var _win = s.window;

      for (;;) {
        /* Make sure that we always have enough lookahead, except
         * at the end of the input file. We need MAX_MATCH bytes
         * for the longest run, plus one for the unrolled loop.
         */
        if (s.lookahead <= MAX_MATCH$1) {
          fill_window(s);
          if (s.lookahead <= MAX_MATCH$1 && flush === Z_NO_FLUSH) {
            return BS_NEED_MORE;
          }
          if (s.lookahead === 0) {
            break;
          } /* flush the current block */
        }

        /* See how many times the previous byte repeats */
        s.match_length = 0;
        if (s.lookahead >= MIN_MATCH$1 && s.strstart > 0) {
          scan = s.strstart - 1;
          prev = _win[scan];
          if (prev === _win[++scan] && prev === _win[++scan] && prev === _win[++scan]) {
            strend = s.strstart + MAX_MATCH$1;
            do {
              /*jshint noempty:false*/
            } while (prev === _win[++scan] && prev === _win[++scan] &&
              prev === _win[++scan] && prev === _win[++scan] &&
              prev === _win[++scan] && prev === _win[++scan] &&
              prev === _win[++scan] && prev === _win[++scan] &&
              scan < strend);
            s.match_length = MAX_MATCH$1 - (strend - scan);
            if (s.match_length > s.lookahead) {
              s.match_length = s.lookahead;
            }
          }
          //Assert(scan <= s->window+(uInt)(s->window_size-1), "wild scan");
        }

        /* Emit match if have run of MIN_MATCH or longer, else emit literal */
        if (s.match_length >= MIN_MATCH$1) {
          //check_match(s, s.strstart, s.strstart - 1, s.match_length);

          /*** _tr_tally_dist(s, 1, s.match_length - MIN_MATCH, bflush); ***/
          bflush = _tr_tally(s, 1, s.match_length - MIN_MATCH$1);

          s.lookahead -= s.match_length;
          s.strstart += s.match_length;
          s.match_length = 0;
        } else {
          /* No match, output a literal byte */
          //Tracevv((stderr,"%c", s->window[s->strstart]));
          /*** _tr_tally_lit(s, s.window[s.strstart], bflush); ***/
          bflush = _tr_tally(s, 0, s.window[s.strstart]);

          s.lookahead--;
          s.strstart++;
        }
        if (bflush) {
          /*** FLUSH_BLOCK(s, 0); ***/
          flush_block_only(s, false);
          if (s.strm.avail_out === 0) {
            return BS_NEED_MORE;
          }
          /***/
        }
      }
      s.insert = 0;
      if (flush === Z_FINISH) {
        /*** FLUSH_BLOCK(s, 1); ***/
        flush_block_only(s, true);
        if (s.strm.avail_out === 0) {
          return BS_FINISH_STARTED;
        }
        /***/
        return BS_FINISH_DONE;
      }
      if (s.last_lit) {
        /*** FLUSH_BLOCK(s, 0); ***/
        flush_block_only(s, false);
        if (s.strm.avail_out === 0) {
          return BS_NEED_MORE;
        }
        /***/
      }
      return BS_BLOCK_DONE;
    }

    /* ===========================================================================
     * For Z_HUFFMAN_ONLY, do not look for matches.  Do not maintain a hash table.
     * (It will be regenerated if this run of deflate switches away from Huffman.)
     */
    function deflate_huff(s, flush) {
      var bflush; /* set if current block must be flushed */

      for (;;) {
        /* Make sure that we have a literal to write. */
        if (s.lookahead === 0) {
          fill_window(s);
          if (s.lookahead === 0) {
            if (flush === Z_NO_FLUSH) {
              return BS_NEED_MORE;
            }
            break; /* flush the current block */
          }
        }

        /* Output a literal byte */
        s.match_length = 0;
        //Tracevv((stderr,"%c", s->window[s->strstart]));
        /*** _tr_tally_lit(s, s.window[s.strstart], bflush); ***/
        bflush = _tr_tally(s, 0, s.window[s.strstart]);
        s.lookahead--;
        s.strstart++;
        if (bflush) {
          /*** FLUSH_BLOCK(s, 0); ***/
          flush_block_only(s, false);
          if (s.strm.avail_out === 0) {
            return BS_NEED_MORE;
          }
          /***/
        }
      }
      s.insert = 0;
      if (flush === Z_FINISH) {
        /*** FLUSH_BLOCK(s, 1); ***/
        flush_block_only(s, true);
        if (s.strm.avail_out === 0) {
          return BS_FINISH_STARTED;
        }
        /***/
        return BS_FINISH_DONE;
      }
      if (s.last_lit) {
        /*** FLUSH_BLOCK(s, 0); ***/
        flush_block_only(s, false);
        if (s.strm.avail_out === 0) {
          return BS_NEED_MORE;
        }
        /***/
      }
      return BS_BLOCK_DONE;
    }

    /* Values for max_lazy_match, good_match and max_chain_length, depending on
     * the desired pack level (0..9). The values given below have been tuned to
     * exclude worst case performance for pathological files. Better values may be
     * found for specific files.
     */
    function Config(good_length, max_lazy, nice_length, max_chain, func) {
      this.good_length = good_length;
      this.max_lazy = max_lazy;
      this.nice_length = nice_length;
      this.max_chain = max_chain;
      this.func = func;
    }

    var configuration_table;

    configuration_table = [
      /*      good lazy nice chain */
      new Config(0, 0, 0, 0, deflate_stored), /* 0 store only */
      new Config(4, 4, 8, 4, deflate_fast), /* 1 max speed, no lazy matches */
      new Config(4, 5, 16, 8, deflate_fast), /* 2 */
      new Config(4, 6, 32, 32, deflate_fast), /* 3 */

      new Config(4, 4, 16, 16, deflate_slow), /* 4 lazy matches */
      new Config(8, 16, 32, 32, deflate_slow), /* 5 */
      new Config(8, 16, 128, 128, deflate_slow), /* 6 */
      new Config(8, 32, 128, 256, deflate_slow), /* 7 */
      new Config(32, 128, 258, 1024, deflate_slow), /* 8 */
      new Config(32, 258, 258, 4096, deflate_slow) /* 9 max compression */
    ];


    /* ===========================================================================
     * Initialize the "longest match" routines for a new zlib stream
     */
    function lm_init(s) {
      s.window_size = 2 * s.w_size;

      /*** CLEAR_HASH(s); ***/
      zero$1(s.head); // Fill with NIL (= 0);

      /* Set the default configuration parameters:
       */
      s.max_lazy_match = configuration_table[s.level].max_lazy;
      s.good_match = configuration_table[s.level].good_length;
      s.nice_match = configuration_table[s.level].nice_length;
      s.max_chain_length = configuration_table[s.level].max_chain;

      s.strstart = 0;
      s.block_start = 0;
      s.lookahead = 0;
      s.insert = 0;
      s.match_length = s.prev_length = MIN_MATCH$1 - 1;
      s.match_available = 0;
      s.ins_h = 0;
    }


    function DeflateState() {
      this.strm = null; /* pointer back to this zlib stream */
      this.status = 0; /* as the name implies */
      this.pending_buf = null; /* output still pending */
      this.pending_buf_size = 0; /* size of pending_buf */
      this.pending_out = 0; /* next pending byte to output to the stream */
      this.pending = 0; /* nb of bytes in the pending buffer */
      this.wrap = 0; /* bit 0 true for zlib, bit 1 true for gzip */
      this.gzhead = null; /* gzip header information to write */
      this.gzindex = 0; /* where in extra, name, or comment */
      this.method = Z_DEFLATED; /* can only be DEFLATED */
      this.last_flush = -1; /* value of flush param for previous deflate call */

      this.w_size = 0; /* LZ77 window size (32K by default) */
      this.w_bits = 0; /* log2(w_size)  (8..16) */
      this.w_mask = 0; /* w_size - 1 */

      this.window = null;
      /* Sliding window. Input bytes are read into the second half of the window,
       * and move to the first half later to keep a dictionary of at least wSize
       * bytes. With this organization, matches are limited to a distance of
       * wSize-MAX_MATCH bytes, but this ensures that IO is always
       * performed with a length multiple of the block size.
       */

      this.window_size = 0;
      /* Actual size of window: 2*wSize, except when the user input buffer
       * is directly used as sliding window.
       */

      this.prev = null;
      /* Link to older string with same hash index. To limit the size of this
       * array to 64K, this link is maintained only for the last 32K strings.
       * An index in this array is thus a window index modulo 32K.
       */

      this.head = null; /* Heads of the hash chains or NIL. */

      this.ins_h = 0; /* hash index of string to be inserted */
      this.hash_size = 0; /* number of elements in hash table */
      this.hash_bits = 0; /* log2(hash_size) */
      this.hash_mask = 0; /* hash_size-1 */

      this.hash_shift = 0;
      /* Number of bits by which ins_h must be shifted at each input
       * step. It must be such that after MIN_MATCH steps, the oldest
       * byte no longer takes part in the hash key, that is:
       *   hash_shift * MIN_MATCH >= hash_bits
       */

      this.block_start = 0;
      /* Window position at the beginning of the current output block. Gets
       * negative when the window is moved backwards.
       */

      this.match_length = 0; /* length of best match */
      this.prev_match = 0; /* previous match */
      this.match_available = 0; /* set if previous match exists */
      this.strstart = 0; /* start of string to insert */
      this.match_start = 0; /* start of matching string */
      this.lookahead = 0; /* number of valid bytes ahead in window */

      this.prev_length = 0;
      /* Length of the best match at previous step. Matches not greater than this
       * are discarded. This is used in the lazy match evaluation.
       */

      this.max_chain_length = 0;
      /* To speed up deflation, hash chains are never searched beyond this
       * length.  A higher limit improves compression ratio but degrades the
       * speed.
       */

      this.max_lazy_match = 0;
      /* Attempt to find a better match only when the current match is strictly
       * smaller than this value. This mechanism is used only for compression
       * levels >= 4.
       */
      // That's alias to max_lazy_match, don't use directly
      //this.max_insert_length = 0;
      /* Insert new strings in the hash table only if the match length is not
       * greater than this length. This saves time but degrades compression.
       * max_insert_length is used only for compression levels <= 3.
       */

      this.level = 0; /* compression level (1..9) */
      this.strategy = 0; /* favor or force Huffman coding*/

      this.good_match = 0;
      /* Use a faster search when the previous match is longer than this */

      this.nice_match = 0; /* Stop searching when current match exceeds this */

      /* used by c: */

      /* Didn't use ct_data typedef below to suppress compiler warning */

      // struct ct_data_s dyn_ltree[HEAP_SIZE];   /* literal and length tree */
      // struct ct_data_s dyn_dtree[2*D_CODES+1]; /* distance tree */
      // struct ct_data_s bl_tree[2*BL_CODES+1];  /* Huffman tree for bit lengths */

      // Use flat array of DOUBLE size, with interleaved fata,
      // because JS does not support effective
      this.dyn_ltree = new Buf16(HEAP_SIZE$1 * 2);
      this.dyn_dtree = new Buf16((2 * D_CODES$1 + 1) * 2);
      this.bl_tree = new Buf16((2 * BL_CODES$1 + 1) * 2);
      zero$1(this.dyn_ltree);
      zero$1(this.dyn_dtree);
      zero$1(this.bl_tree);

      this.l_desc = null; /* desc. for literal tree */
      this.d_desc = null; /* desc. for distance tree */
      this.bl_desc = null; /* desc. for bit length tree */

      //ush bl_count[MAX_BITS+1];
      this.bl_count = new Buf16(MAX_BITS$1 + 1);
      /* number of codes at each bit length for an optimal tree */

      //int heap[2*L_CODES+1];      /* heap used to build the Huffman trees */
      this.heap = new Buf16(2 * L_CODES$1 + 1); /* heap used to build the Huffman trees */
      zero$1(this.heap);

      this.heap_len = 0; /* number of elements in the heap */
      this.heap_max = 0; /* element of largest frequency */
      /* The sons of heap[n] are heap[2*n] and heap[2*n+1]. heap[0] is not used.
       * The same heap array is used to build all
       */

      this.depth = new Buf16(2 * L_CODES$1 + 1); //uch depth[2*L_CODES+1];
      zero$1(this.depth);
      /* Depth of each subtree used as tie breaker for trees of equal frequency
       */

      this.l_buf = 0; /* buffer index for literals or lengths */

      this.lit_bufsize = 0;
      /* Size of match buffer for literals/lengths.  There are 4 reasons for
       * limiting lit_bufsize to 64K:
       *   - frequencies can be kept in 16 bit counters
       *   - if compression is not successful for the first block, all input
       *     data is still in the window so we can still emit a stored block even
       *     when input comes from standard input.  (This can also be done for
       *     all blocks if lit_bufsize is not greater than 32K.)
       *   - if compression is not successful for a file smaller than 64K, we can
       *     even emit a stored file instead of a stored block (saving 5 bytes).
       *     This is applicable only for zip (not gzip or zlib).
       *   - creating new Huffman trees less frequently may not provide fast
       *     adaptation to changes in the input data statistics. (Take for
       *     example a binary file with poorly compressible code followed by
       *     a highly compressible string table.) Smaller buffer sizes give
       *     fast adaptation but have of course the overhead of transmitting
       *     trees more frequently.
       *   - I can't count above 4
       */

      this.last_lit = 0; /* running index in l_buf */

      this.d_buf = 0;
      /* Buffer index for distances. To simplify the code, d_buf and l_buf have
       * the same number of elements. To use different lengths, an extra flag
       * array would be necessary.
       */

      this.opt_len = 0; /* bit length of current block with optimal trees */
      this.static_len = 0; /* bit length of current block with static trees */
      this.matches = 0; /* number of string matches in current block */
      this.insert = 0; /* bytes at end of window left to insert */


      this.bi_buf = 0;
      /* Output buffer. bits are inserted starting at the bottom (least
       * significant bits).
       */
      this.bi_valid = 0;
      /* Number of valid bits in bi_buf.  All bits above the last valid bit
       * are always zero.
       */

      // Used for window memory init. We safely ignore it for JS. That makes
      // sense only for pointers and memory check tools.
      //this.high_water = 0;
      /* High water mark offset in window for initialized bytes -- bytes above
       * this are set to zero in order to avoid memory check warnings when
       * longest match routines access bytes past the input.  This is then
       * updated to the new high water mark.
       */
    }


    function deflateResetKeep(strm) {
      var s;

      if (!strm || !strm.state) {
        return err(strm, Z_STREAM_ERROR);
      }

      strm.total_in = strm.total_out = 0;
      strm.data_type = Z_UNKNOWN$1;

      s = strm.state;
      s.pending = 0;
      s.pending_out = 0;

      if (s.wrap < 0) {
        s.wrap = -s.wrap;
        /* was made negative by deflate(..., Z_FINISH); */
      }
      s.status = (s.wrap ? INIT_STATE : BUSY_STATE);
      strm.adler = (s.wrap === 2) ?
        0 // crc32(0, Z_NULL, 0)
        :
        1; // adler32(0, Z_NULL, 0)
      s.last_flush = Z_NO_FLUSH;
      _tr_init(s);
      return Z_OK;
    }


    function deflateReset(strm) {
      var ret = deflateResetKeep(strm);
      if (ret === Z_OK) {
        lm_init(strm.state);
      }
      return ret;
    }


    function deflateInit2(strm, level, method, windowBits, memLevel, strategy) {
      if (!strm) { // === Z_NULL
        return Z_STREAM_ERROR;
      }
      var wrap = 1;

      if (level === Z_DEFAULT_COMPRESSION) {
        level = 6;
      }

      if (windowBits < 0) { /* suppress zlib wrapper */
        wrap = 0;
        windowBits = -windowBits;
      } else if (windowBits > 15) {
        wrap = 2; /* write gzip wrapper instead */
        windowBits -= 16;
      }


      if (memLevel < 1 || memLevel > MAX_MEM_LEVEL || method !== Z_DEFLATED ||
        windowBits < 8 || windowBits > 15 || level < 0 || level > 9 ||
        strategy < 0 || strategy > Z_FIXED$1) {
        return err(strm, Z_STREAM_ERROR);
      }


      if (windowBits === 8) {
        windowBits = 9;
      }
      /* until 256-byte window bug fixed */

      var s = new DeflateState();

      strm.state = s;
      s.strm = strm;

      s.wrap = wrap;
      s.gzhead = null;
      s.w_bits = windowBits;
      s.w_size = 1 << s.w_bits;
      s.w_mask = s.w_size - 1;

      s.hash_bits = memLevel + 7;
      s.hash_size = 1 << s.hash_bits;
      s.hash_mask = s.hash_size - 1;
      s.hash_shift = ~~((s.hash_bits + MIN_MATCH$1 - 1) / MIN_MATCH$1);

      s.window = new Buf8(s.w_size * 2);
      s.head = new Buf16(s.hash_size);
      s.prev = new Buf16(s.w_size);

      // Don't need mem init magic for JS.
      //s.high_water = 0;  /* nothing written to s->window yet */

      s.lit_bufsize = 1 << (memLevel + 6); /* 16K elements by default */

      s.pending_buf_size = s.lit_bufsize * 4;

      //overlay = (ushf *) ZALLOC(strm, s->lit_bufsize, sizeof(ush)+2);
      //s->pending_buf = (uchf *) overlay;
      s.pending_buf = new Buf8(s.pending_buf_size);

      // It is offset from `s.pending_buf` (size is `s.lit_bufsize * 2`)
      //s->d_buf = overlay + s->lit_bufsize/sizeof(ush);
      s.d_buf = 1 * s.lit_bufsize;

      //s->l_buf = s->pending_buf + (1+sizeof(ush))*s->lit_bufsize;
      s.l_buf = (1 + 2) * s.lit_bufsize;

      s.level = level;
      s.strategy = strategy;
      s.method = method;

      return deflateReset(strm);
    }


    function deflate(strm, flush) {
      var old_flush, s;
      var beg, val; // for gzip header write only

      if (!strm || !strm.state ||
        flush > Z_BLOCK || flush < 0) {
        return strm ? err(strm, Z_STREAM_ERROR) : Z_STREAM_ERROR;
      }

      s = strm.state;

      if (!strm.output ||
        (!strm.input && strm.avail_in !== 0) ||
        (s.status === FINISH_STATE && flush !== Z_FINISH)) {
        return err(strm, (strm.avail_out === 0) ? Z_BUF_ERROR : Z_STREAM_ERROR);
      }

      s.strm = strm; /* just in case */
      old_flush = s.last_flush;
      s.last_flush = flush;

      /* Write the header */
      if (s.status === INIT_STATE) {
        if (s.wrap === 2) {
          // GZIP header
          strm.adler = 0; //crc32(0L, Z_NULL, 0);
          put_byte(s, 31);
          put_byte(s, 139);
          put_byte(s, 8);
          if (!s.gzhead) { // s->gzhead == Z_NULL
            put_byte(s, 0);
            put_byte(s, 0);
            put_byte(s, 0);
            put_byte(s, 0);
            put_byte(s, 0);
            put_byte(s, s.level === 9 ? 2 :
              (s.strategy >= Z_HUFFMAN_ONLY || s.level < 2 ?
                4 : 0));
            put_byte(s, OS_CODE);
            s.status = BUSY_STATE;
          } else {
            put_byte(s, (s.gzhead.text ? 1 : 0) +
              (s.gzhead.hcrc ? 2 : 0) +
              (!s.gzhead.extra ? 0 : 4) +
              (!s.gzhead.name ? 0 : 8) +
              (!s.gzhead.comment ? 0 : 16)
            );
            put_byte(s, s.gzhead.time & 0xff);
            put_byte(s, (s.gzhead.time >> 8) & 0xff);
            put_byte(s, (s.gzhead.time >> 16) & 0xff);
            put_byte(s, (s.gzhead.time >> 24) & 0xff);
            put_byte(s, s.level === 9 ? 2 :
              (s.strategy >= Z_HUFFMAN_ONLY || s.level < 2 ?
                4 : 0));
            put_byte(s, s.gzhead.os & 0xff);
            if (s.gzhead.extra && s.gzhead.extra.length) {
              put_byte(s, s.gzhead.extra.length & 0xff);
              put_byte(s, (s.gzhead.extra.length >> 8) & 0xff);
            }
            if (s.gzhead.hcrc) {
              strm.adler = crc32(strm.adler, s.pending_buf, s.pending, 0);
            }
            s.gzindex = 0;
            s.status = EXTRA_STATE;
          }
        } else // DEFLATE header
        {
          var header = (Z_DEFLATED + ((s.w_bits - 8) << 4)) << 8;
          var level_flags = -1;

          if (s.strategy >= Z_HUFFMAN_ONLY || s.level < 2) {
            level_flags = 0;
          } else if (s.level < 6) {
            level_flags = 1;
          } else if (s.level === 6) {
            level_flags = 2;
          } else {
            level_flags = 3;
          }
          header |= (level_flags << 6);
          if (s.strstart !== 0) {
            header |= PRESET_DICT;
          }
          header += 31 - (header % 31);

          s.status = BUSY_STATE;
          putShortMSB(s, header);

          /* Save the adler32 of the preset dictionary: */
          if (s.strstart !== 0) {
            putShortMSB(s, strm.adler >>> 16);
            putShortMSB(s, strm.adler & 0xffff);
          }
          strm.adler = 1; // adler32(0L, Z_NULL, 0);
        }
      }

      //#ifdef GZIP
      if (s.status === EXTRA_STATE) {
        if (s.gzhead.extra /* != Z_NULL*/ ) {
          beg = s.pending; /* start of bytes to update crc */

          while (s.gzindex < (s.gzhead.extra.length & 0xffff)) {
            if (s.pending === s.pending_buf_size) {
              if (s.gzhead.hcrc && s.pending > beg) {
                strm.adler = crc32(strm.adler, s.pending_buf, s.pending - beg, beg);
              }
              flush_pending(strm);
              beg = s.pending;
              if (s.pending === s.pending_buf_size) {
                break;
              }
            }
            put_byte(s, s.gzhead.extra[s.gzindex] & 0xff);
            s.gzindex++;
          }
          if (s.gzhead.hcrc && s.pending > beg) {
            strm.adler = crc32(strm.adler, s.pending_buf, s.pending - beg, beg);
          }
          if (s.gzindex === s.gzhead.extra.length) {
            s.gzindex = 0;
            s.status = NAME_STATE;
          }
        } else {
          s.status = NAME_STATE;
        }
      }
      if (s.status === NAME_STATE) {
        if (s.gzhead.name /* != Z_NULL*/ ) {
          beg = s.pending; /* start of bytes to update crc */
          //int val;

          do {
            if (s.pending === s.pending_buf_size) {
              if (s.gzhead.hcrc && s.pending > beg) {
                strm.adler = crc32(strm.adler, s.pending_buf, s.pending - beg, beg);
              }
              flush_pending(strm);
              beg = s.pending;
              if (s.pending === s.pending_buf_size) {
                val = 1;
                break;
              }
            }
            // JS specific: little magic to add zero terminator to end of string
            if (s.gzindex < s.gzhead.name.length) {
              val = s.gzhead.name.charCodeAt(s.gzindex++) & 0xff;
            } else {
              val = 0;
            }
            put_byte(s, val);
          } while (val !== 0);

          if (s.gzhead.hcrc && s.pending > beg) {
            strm.adler = crc32(strm.adler, s.pending_buf, s.pending - beg, beg);
          }
          if (val === 0) {
            s.gzindex = 0;
            s.status = COMMENT_STATE;
          }
        } else {
          s.status = COMMENT_STATE;
        }
      }
      if (s.status === COMMENT_STATE) {
        if (s.gzhead.comment /* != Z_NULL*/ ) {
          beg = s.pending; /* start of bytes to update crc */
          //int val;

          do {
            if (s.pending === s.pending_buf_size) {
              if (s.gzhead.hcrc && s.pending > beg) {
                strm.adler = crc32(strm.adler, s.pending_buf, s.pending - beg, beg);
              }
              flush_pending(strm);
              beg = s.pending;
              if (s.pending === s.pending_buf_size) {
                val = 1;
                break;
              }
            }
            // JS specific: little magic to add zero terminator to end of string
            if (s.gzindex < s.gzhead.comment.length) {
              val = s.gzhead.comment.charCodeAt(s.gzindex++) & 0xff;
            } else {
              val = 0;
            }
            put_byte(s, val);
          } while (val !== 0);

          if (s.gzhead.hcrc && s.pending > beg) {
            strm.adler = crc32(strm.adler, s.pending_buf, s.pending - beg, beg);
          }
          if (val === 0) {
            s.status = HCRC_STATE;
          }
        } else {
          s.status = HCRC_STATE;
        }
      }
      if (s.status === HCRC_STATE) {
        if (s.gzhead.hcrc) {
          if (s.pending + 2 > s.pending_buf_size) {
            flush_pending(strm);
          }
          if (s.pending + 2 <= s.pending_buf_size) {
            put_byte(s, strm.adler & 0xff);
            put_byte(s, (strm.adler >> 8) & 0xff);
            strm.adler = 0; //crc32(0L, Z_NULL, 0);
            s.status = BUSY_STATE;
          }
        } else {
          s.status = BUSY_STATE;
        }
      }
      //#endif

      /* Flush as much pending output as possible */
      if (s.pending !== 0) {
        flush_pending(strm);
        if (strm.avail_out === 0) {
          /* Since avail_out is 0, deflate will be called again with
           * more output space, but possibly with both pending and
           * avail_in equal to zero. There won't be anything to do,
           * but this is not an error situation so make sure we
           * return OK instead of BUF_ERROR at next call of deflate:
           */
          s.last_flush = -1;
          return Z_OK;
        }

        /* Make sure there is something to do and avoid duplicate consecutive
         * flushes. For repeated and useless calls with Z_FINISH, we keep
         * returning Z_STREAM_END instead of Z_BUF_ERROR.
         */
      } else if (strm.avail_in === 0 && rank(flush) <= rank(old_flush) &&
        flush !== Z_FINISH) {
        return err(strm, Z_BUF_ERROR);
      }

      /* User must not provide more input after the first FINISH: */
      if (s.status === FINISH_STATE && strm.avail_in !== 0) {
        return err(strm, Z_BUF_ERROR);
      }

      /* Start a new block or continue the current one.
       */
      if (strm.avail_in !== 0 || s.lookahead !== 0 ||
        (flush !== Z_NO_FLUSH && s.status !== FINISH_STATE)) {
        var bstate = (s.strategy === Z_HUFFMAN_ONLY) ? deflate_huff(s, flush) :
          (s.strategy === Z_RLE ? deflate_rle(s, flush) :
            configuration_table[s.level].func(s, flush));

        if (bstate === BS_FINISH_STARTED || bstate === BS_FINISH_DONE) {
          s.status = FINISH_STATE;
        }
        if (bstate === BS_NEED_MORE || bstate === BS_FINISH_STARTED) {
          if (strm.avail_out === 0) {
            s.last_flush = -1;
            /* avoid BUF_ERROR next call, see above */
          }
          return Z_OK;
          /* If flush != Z_NO_FLUSH && avail_out == 0, the next call
           * of deflate should use the same flush parameter to make sure
           * that the flush is complete. So we don't have to output an
           * empty block here, this will be done at next call. This also
           * ensures that for a very small output buffer, we emit at most
           * one empty block.
           */
        }
        if (bstate === BS_BLOCK_DONE) {
          if (flush === Z_PARTIAL_FLUSH) {
            _tr_align(s);
          } else if (flush !== Z_BLOCK) { /* FULL_FLUSH or SYNC_FLUSH */

            _tr_stored_block(s, 0, 0, false);
            /* For a full flush, this empty block will be recognized
             * as a special marker by inflate_sync().
             */
            if (flush === Z_FULL_FLUSH) {
              /*** CLEAR_HASH(s); ***/
              /* forget history */
              zero$1(s.head); // Fill with NIL (= 0);

              if (s.lookahead === 0) {
                s.strstart = 0;
                s.block_start = 0;
                s.insert = 0;
              }
            }
          }
          flush_pending(strm);
          if (strm.avail_out === 0) {
            s.last_flush = -1; /* avoid BUF_ERROR at next call, see above */
            return Z_OK;
          }
        }
      }
      //Assert(strm->avail_out > 0, "bug2");
      //if (strm.avail_out <= 0) { throw new Error("bug2");}

      if (flush !== Z_FINISH) {
        return Z_OK;
      }
      if (s.wrap <= 0) {
        return Z_STREAM_END;
      }

      /* Write the trailer */
      if (s.wrap === 2) {
        put_byte(s, strm.adler & 0xff);
        put_byte(s, (strm.adler >> 8) & 0xff);
        put_byte(s, (strm.adler >> 16) & 0xff);
        put_byte(s, (strm.adler >> 24) & 0xff);
        put_byte(s, strm.total_in & 0xff);
        put_byte(s, (strm.total_in >> 8) & 0xff);
        put_byte(s, (strm.total_in >> 16) & 0xff);
        put_byte(s, (strm.total_in >> 24) & 0xff);
      } else {
        putShortMSB(s, strm.adler >>> 16);
        putShortMSB(s, strm.adler & 0xffff);
      }

      flush_pending(strm);
      /* If avail_out is zero, the application will call deflate again
       * to flush the rest.
       */
      if (s.wrap > 0) {
        s.wrap = -s.wrap;
      }
      /* write the trailer only once! */
      return s.pending !== 0 ? Z_OK : Z_STREAM_END;
    }

    function deflateEnd(strm) {
      var status;

      if (!strm /*== Z_NULL*/ || !strm.state /*== Z_NULL*/ ) {
        return Z_STREAM_ERROR;
      }

      status = strm.state.status;
      if (status !== INIT_STATE &&
        status !== EXTRA_STATE &&
        status !== NAME_STATE &&
        status !== COMMENT_STATE &&
        status !== HCRC_STATE &&
        status !== BUSY_STATE &&
        status !== FINISH_STATE
      ) {
        return err(strm, Z_STREAM_ERROR);
      }

      strm.state = null;

      return status === BUSY_STATE ? err(strm, Z_DATA_ERROR) : Z_OK;
    }

    /* Not implemented
    exports.deflateBound = deflateBound;
    exports.deflateCopy = deflateCopy;
    exports.deflateParams = deflateParams;
    exports.deflatePending = deflatePending;
    exports.deflatePrime = deflatePrime;
    exports.deflateTune = deflateTune;
    */

    // See state defs from inflate.js
    var BAD = 30;       /* got a data error -- remain here until reset */
    var TYPE = 12;      /* i: waiting for type bits, including last-flag bit */

    /*
       Decode literal, length, and distance codes and write out the resulting
       literal and match bytes until either not enough input or output is
       available, an end-of-block is encountered, or a data error is encountered.
       When large enough input and output buffers are supplied to inflate(), for
       example, a 16K input buffer and a 64K output buffer, more than 95% of the
       inflate execution time is spent in this routine.

       Entry assumptions:

            state.mode === LEN
            strm.avail_in >= 6
            strm.avail_out >= 258
            start >= strm.avail_out
            state.bits < 8

       On return, state.mode is one of:

            LEN -- ran out of enough output space or enough available input
            TYPE -- reached end of block code, inflate() to interpret next block
            BAD -- error in block data

       Notes:

        - The maximum input bits used by a length/distance pair is 15 bits for the
          length code, 5 bits for the length extra, 15 bits for the distance code,
          and 13 bits for the distance extra.  This totals 48 bits, or six bytes.
          Therefore if strm.avail_in >= 6, then there is enough input to avoid
          checking for available input while decoding.

        - The maximum bytes that a single length/distance pair can output is 258
          bytes, which is the maximum length that can be coded.  inflate_fast()
          requires strm.avail_out >= 258 for each loop to avoid checking for
          output space.
     */
    function inflate_fast(strm, start) {
      var state;
      var _in;                    /* local strm.input */
      var last;                   /* have enough input while in < last */
      var _out;                   /* local strm.output */
      var beg;                    /* inflate()'s initial strm.output */
      var end;                    /* while out < end, enough space available */
    //#ifdef INFLATE_STRICT
      var dmax;                   /* maximum distance from zlib header */
    //#endif
      var wsize;                  /* window size or zero if not using window */
      var whave;                  /* valid bytes in the window */
      var wnext;                  /* window write index */
      // Use `s_window` instead `window`, avoid conflict with instrumentation tools
      var s_window;               /* allocated sliding window, if wsize != 0 */
      var hold;                   /* local strm.hold */
      var bits;                   /* local strm.bits */
      var lcode;                  /* local strm.lencode */
      var dcode;                  /* local strm.distcode */
      var lmask;                  /* mask for first level of length codes */
      var dmask;                  /* mask for first level of distance codes */
      var here;                   /* retrieved table entry */
      var op;                     /* code bits, operation, extra bits, or */
                                  /*  window position, window bytes to copy */
      var len;                    /* match length, unused bytes */
      var dist;                   /* match distance */
      var from;                   /* where to copy match from */
      var from_source;


      var input, output; // JS specific, because we have no pointers

      /* copy state to local variables */
      state = strm.state;
      //here = state.here;
      _in = strm.next_in;
      input = strm.input;
      last = _in + (strm.avail_in - 5);
      _out = strm.next_out;
      output = strm.output;
      beg = _out - (start - strm.avail_out);
      end = _out + (strm.avail_out - 257);
    //#ifdef INFLATE_STRICT
      dmax = state.dmax;
    //#endif
      wsize = state.wsize;
      whave = state.whave;
      wnext = state.wnext;
      s_window = state.window;
      hold = state.hold;
      bits = state.bits;
      lcode = state.lencode;
      dcode = state.distcode;
      lmask = (1 << state.lenbits) - 1;
      dmask = (1 << state.distbits) - 1;


      /* decode literals and length/distances until end-of-block or not enough
         input data or output space */

      top:
      do {
        if (bits < 15) {
          hold += input[_in++] << bits;
          bits += 8;
          hold += input[_in++] << bits;
          bits += 8;
        }

        here = lcode[hold & lmask];

        dolen:
        for (;;) { // Goto emulation
          op = here >>> 24/*here.bits*/;
          hold >>>= op;
          bits -= op;
          op = (here >>> 16) & 0xff/*here.op*/;
          if (op === 0) {                          /* literal */
            //Tracevv((stderr, here.val >= 0x20 && here.val < 0x7f ?
            //        "inflate:         literal '%c'\n" :
            //        "inflate:         literal 0x%02x\n", here.val));
            output[_out++] = here & 0xffff/*here.val*/;
          }
          else if (op & 16) {                     /* length base */
            len = here & 0xffff/*here.val*/;
            op &= 15;                           /* number of extra bits */
            if (op) {
              if (bits < op) {
                hold += input[_in++] << bits;
                bits += 8;
              }
              len += hold & ((1 << op) - 1);
              hold >>>= op;
              bits -= op;
            }
            //Tracevv((stderr, "inflate:         length %u\n", len));
            if (bits < 15) {
              hold += input[_in++] << bits;
              bits += 8;
              hold += input[_in++] << bits;
              bits += 8;
            }
            here = dcode[hold & dmask];

            dodist:
            for (;;) { // goto emulation
              op = here >>> 24/*here.bits*/;
              hold >>>= op;
              bits -= op;
              op = (here >>> 16) & 0xff/*here.op*/;

              if (op & 16) {                      /* distance base */
                dist = here & 0xffff/*here.val*/;
                op &= 15;                       /* number of extra bits */
                if (bits < op) {
                  hold += input[_in++] << bits;
                  bits += 8;
                  if (bits < op) {
                    hold += input[_in++] << bits;
                    bits += 8;
                  }
                }
                dist += hold & ((1 << op) - 1);
    //#ifdef INFLATE_STRICT
                if (dist > dmax) {
                  strm.msg = 'invalid distance too far back';
                  state.mode = BAD;
                  break top;
                }
    //#endif
                hold >>>= op;
                bits -= op;
                //Tracevv((stderr, "inflate:         distance %u\n", dist));
                op = _out - beg;                /* max distance in output */
                if (dist > op) {                /* see if copy from window */
                  op = dist - op;               /* distance back in window */
                  if (op > whave) {
                    if (state.sane) {
                      strm.msg = 'invalid distance too far back';
                      state.mode = BAD;
                      break top;
                    }

    // (!) This block is disabled in zlib defailts,
    // don't enable it for binary compatibility
    //#ifdef INFLATE_ALLOW_INVALID_DISTANCE_TOOFAR_ARRR
    //                if (len <= op - whave) {
    //                  do {
    //                    output[_out++] = 0;
    //                  } while (--len);
    //                  continue top;
    //                }
    //                len -= op - whave;
    //                do {
    //                  output[_out++] = 0;
    //                } while (--op > whave);
    //                if (op === 0) {
    //                  from = _out - dist;
    //                  do {
    //                    output[_out++] = output[from++];
    //                  } while (--len);
    //                  continue top;
    //                }
    //#endif
                  }
                  from = 0; // window index
                  from_source = s_window;
                  if (wnext === 0) {           /* very common case */
                    from += wsize - op;
                    if (op < len) {         /* some from window */
                      len -= op;
                      do {
                        output[_out++] = s_window[from++];
                      } while (--op);
                      from = _out - dist;  /* rest from output */
                      from_source = output;
                    }
                  }
                  else if (wnext < op) {      /* wrap around window */
                    from += wsize + wnext - op;
                    op -= wnext;
                    if (op < len) {         /* some from end of window */
                      len -= op;
                      do {
                        output[_out++] = s_window[from++];
                      } while (--op);
                      from = 0;
                      if (wnext < len) {  /* some from start of window */
                        op = wnext;
                        len -= op;
                        do {
                          output[_out++] = s_window[from++];
                        } while (--op);
                        from = _out - dist;      /* rest from output */
                        from_source = output;
                      }
                    }
                  }
                  else {                      /* contiguous in window */
                    from += wnext - op;
                    if (op < len) {         /* some from window */
                      len -= op;
                      do {
                        output[_out++] = s_window[from++];
                      } while (--op);
                      from = _out - dist;  /* rest from output */
                      from_source = output;
                    }
                  }
                  while (len > 2) {
                    output[_out++] = from_source[from++];
                    output[_out++] = from_source[from++];
                    output[_out++] = from_source[from++];
                    len -= 3;
                  }
                  if (len) {
                    output[_out++] = from_source[from++];
                    if (len > 1) {
                      output[_out++] = from_source[from++];
                    }
                  }
                }
                else {
                  from = _out - dist;          /* copy direct from output */
                  do {                        /* minimum length is three */
                    output[_out++] = output[from++];
                    output[_out++] = output[from++];
                    output[_out++] = output[from++];
                    len -= 3;
                  } while (len > 2);
                  if (len) {
                    output[_out++] = output[from++];
                    if (len > 1) {
                      output[_out++] = output[from++];
                    }
                  }
                }
              }
              else if ((op & 64) === 0) {          /* 2nd level distance code */
                here = dcode[(here & 0xffff)/*here.val*/ + (hold & ((1 << op) - 1))];
                continue dodist;
              }
              else {
                strm.msg = 'invalid distance code';
                state.mode = BAD;
                break top;
              }

              break; // need to emulate goto via "continue"
            }
          }
          else if ((op & 64) === 0) {              /* 2nd level length code */
            here = lcode[(here & 0xffff)/*here.val*/ + (hold & ((1 << op) - 1))];
            continue dolen;
          }
          else if (op & 32) {                     /* end-of-block */
            //Tracevv((stderr, "inflate:         end of block\n"));
            state.mode = TYPE;
            break top;
          }
          else {
            strm.msg = 'invalid literal/length code';
            state.mode = BAD;
            break top;
          }

          break; // need to emulate goto via "continue"
        }
      } while (_in < last && _out < end);

      /* return unused bytes (on entry, bits < 8, so in won't go too far back) */
      len = bits >> 3;
      _in -= len;
      bits -= len << 3;
      hold &= (1 << bits) - 1;

      /* update state and return */
      strm.next_in = _in;
      strm.next_out = _out;
      strm.avail_in = (_in < last ? 5 + (last - _in) : 5 - (_in - last));
      strm.avail_out = (_out < end ? 257 + (end - _out) : 257 - (_out - end));
      state.hold = hold;
      state.bits = bits;
      return;
    }

    var MAXBITS = 15;
    var ENOUGH_LENS = 852;
    var ENOUGH_DISTS = 592;
    //var ENOUGH = (ENOUGH_LENS+ENOUGH_DISTS);

    var CODES = 0;
    var LENS = 1;
    var DISTS = 2;

    var lbase = [ /* Length codes 257..285 base */
      3, 4, 5, 6, 7, 8, 9, 10, 11, 13, 15, 17, 19, 23, 27, 31,
      35, 43, 51, 59, 67, 83, 99, 115, 131, 163, 195, 227, 258, 0, 0
    ];

    var lext = [ /* Length codes 257..285 extra */
      16, 16, 16, 16, 16, 16, 16, 16, 17, 17, 17, 17, 18, 18, 18, 18,
      19, 19, 19, 19, 20, 20, 20, 20, 21, 21, 21, 21, 16, 72, 78
    ];

    var dbase = [ /* Distance codes 0..29 base */
      1, 2, 3, 4, 5, 7, 9, 13, 17, 25, 33, 49, 65, 97, 129, 193,
      257, 385, 513, 769, 1025, 1537, 2049, 3073, 4097, 6145,
      8193, 12289, 16385, 24577, 0, 0
    ];

    var dext = [ /* Distance codes 0..29 extra */
      16, 16, 16, 16, 17, 17, 18, 18, 19, 19, 20, 20, 21, 21, 22, 22,
      23, 23, 24, 24, 25, 25, 26, 26, 27, 27,
      28, 28, 29, 29, 64, 64
    ];

    function inflate_table(type, lens, lens_index, codes, table, table_index, work, opts) {
      var bits = opts.bits;
      //here = opts.here; /* table entry for duplication */

      var len = 0; /* a code's length in bits */
      var sym = 0; /* index of code symbols */
      var min = 0,
        max = 0; /* minimum and maximum code lengths */
      var root = 0; /* number of index bits for root table */
      var curr = 0; /* number of index bits for current table */
      var drop = 0; /* code bits to drop for sub-table */
      var left = 0; /* number of prefix codes available */
      var used = 0; /* code entries in table used */
      var huff = 0; /* Huffman code */
      var incr; /* for incrementing code, index */
      var fill; /* index for replicating entries */
      var low; /* low bits for current root entry */
      var mask; /* mask for low root bits */
      var next; /* next available space in table */
      var base = null; /* base value table to use */
      var base_index = 0;
      //  var shoextra;    /* extra bits table to use */
      var end; /* use base and extra for symbol > end */
      var count = new Buf16(MAXBITS + 1); //[MAXBITS+1];    /* number of codes of each length */
      var offs = new Buf16(MAXBITS + 1); //[MAXBITS+1];     /* offsets in table for each length */
      var extra = null;
      var extra_index = 0;

      var here_bits, here_op, here_val;

      /*
       Process a set of code lengths to create a canonical Huffman code.  The
       code lengths are lens[0..codes-1].  Each length corresponds to the
       symbols 0..codes-1.  The Huffman code is generated by first sorting the
       symbols by length from short to long, and retaining the symbol order
       for codes with equal lengths.  Then the code starts with all zero bits
       for the first code of the shortest length, and the codes are integer
       increments for the same length, and zeros are appended as the length
       increases.  For the deflate format, these bits are stored backwards
       from their more natural integer increment ordering, and so when the
       decoding tables are built in the large loop below, the integer codes
       are incremented backwards.

       This routine assumes, but does not check, that all of the entries in
       lens[] are in the range 0..MAXBITS.  The caller must assure this.
       1..MAXBITS is interpreted as that code length.  zero means that that
       symbol does not occur in this code.

       The codes are sorted by computing a count of codes for each length,
       creating from that a table of starting indices for each length in the
       sorted table, and then entering the symbols in order in the sorted
       table.  The sorted table is work[], with that space being provided by
       the caller.

       The length counts are used for other purposes as well, i.e. finding
       the minimum and maximum length codes, determining if there are any
       codes at all, checking for a valid set of lengths, and looking ahead
       at length counts to determine sub-table sizes when building the
       decoding tables.
       */

      /* accumulate lengths for codes (assumes lens[] all in 0..MAXBITS) */
      for (len = 0; len <= MAXBITS; len++) {
        count[len] = 0;
      }
      for (sym = 0; sym < codes; sym++) {
        count[lens[lens_index + sym]]++;
      }

      /* bound code lengths, force root to be within code lengths */
      root = bits;
      for (max = MAXBITS; max >= 1; max--) {
        if (count[max] !== 0) {
          break;
        }
      }
      if (root > max) {
        root = max;
      }
      if (max === 0) { /* no symbols to code at all */
        //table.op[opts.table_index] = 64;  //here.op = (var char)64;    /* invalid code marker */
        //table.bits[opts.table_index] = 1;   //here.bits = (var char)1;
        //table.val[opts.table_index++] = 0;   //here.val = (var short)0;
        table[table_index++] = (1 << 24) | (64 << 16) | 0;


        //table.op[opts.table_index] = 64;
        //table.bits[opts.table_index] = 1;
        //table.val[opts.table_index++] = 0;
        table[table_index++] = (1 << 24) | (64 << 16) | 0;

        opts.bits = 1;
        return 0; /* no symbols, but wait for decoding to report error */
      }
      for (min = 1; min < max; min++) {
        if (count[min] !== 0) {
          break;
        }
      }
      if (root < min) {
        root = min;
      }

      /* check for an over-subscribed or incomplete set of lengths */
      left = 1;
      for (len = 1; len <= MAXBITS; len++) {
        left <<= 1;
        left -= count[len];
        if (left < 0) {
          return -1;
        } /* over-subscribed */
      }
      if (left > 0 && (type === CODES || max !== 1)) {
        return -1; /* incomplete set */
      }

      /* generate offsets into symbol table for each length for sorting */
      offs[1] = 0;
      for (len = 1; len < MAXBITS; len++) {
        offs[len + 1] = offs[len] + count[len];
      }

      /* sort symbols by length, by symbol order within each length */
      for (sym = 0; sym < codes; sym++) {
        if (lens[lens_index + sym] !== 0) {
          work[offs[lens[lens_index + sym]]++] = sym;
        }
      }

      /*
       Create and fill in decoding tables.  In this loop, the table being
       filled is at next and has curr index bits.  The code being used is huff
       with length len.  That code is converted to an index by dropping drop
       bits off of the bottom.  For codes where len is less than drop + curr,
       those top drop + curr - len bits are incremented through all values to
       fill the table with replicated entries.

       root is the number of index bits for the root table.  When len exceeds
       root, sub-tables are created pointed to by the root entry with an index
       of the low root bits of huff.  This is saved in low to check for when a
       new sub-table should be started.  drop is zero when the root table is
       being filled, and drop is root when sub-tables are being filled.

       When a new sub-table is needed, it is necessary to look ahead in the
       code lengths to determine what size sub-table is needed.  The length
       counts are used for this, and so count[] is decremented as codes are
       entered in the tables.

       used keeps track of how many table entries have been allocated from the
       provided *table space.  It is checked for LENS and DIST tables against
       the constants ENOUGH_LENS and ENOUGH_DISTS to guard against changes in
       the initial root table size constants.  See the comments in inftrees.h
       for more information.

       sym increments through all symbols, and the loop terminates when
       all codes of length max, i.e. all codes, have been processed.  This
       routine permits incomplete codes, so another loop after this one fills
       in the rest of the decoding tables with invalid code markers.
       */

      /* set up for code type */
      // poor man optimization - use if-else instead of switch,
      // to avoid deopts in old v8
      if (type === CODES) {
        base = extra = work; /* dummy value--not used */
        end = 19;

      } else if (type === LENS) {
        base = lbase;
        base_index -= 257;
        extra = lext;
        extra_index -= 257;
        end = 256;

      } else { /* DISTS */
        base = dbase;
        extra = dext;
        end = -1;
      }

      /* initialize opts for loop */
      huff = 0; /* starting code */
      sym = 0; /* starting code symbol */
      len = min; /* starting code length */
      next = table_index; /* current table to fill in */
      curr = root; /* current table index bits */
      drop = 0; /* current bits to drop from code for index */
      low = -1; /* trigger new sub-table when len > root */
      used = 1 << root; /* use root table entries */
      mask = used - 1; /* mask for comparing low */

      /* check available table space */
      if ((type === LENS && used > ENOUGH_LENS) ||
        (type === DISTS && used > ENOUGH_DISTS)) {
        return 1;
      }
      /* process all codes and make table entries */
      for (;;) {
        /* create table entry */
        here_bits = len - drop;
        if (work[sym] < end) {
          here_op = 0;
          here_val = work[sym];
        } else if (work[sym] > end) {
          here_op = extra[extra_index + work[sym]];
          here_val = base[base_index + work[sym]];
        } else {
          here_op = 32 + 64; /* end of block */
          here_val = 0;
        }

        /* replicate for those indices with low len bits equal to huff */
        incr = 1 << (len - drop);
        fill = 1 << curr;
        min = fill; /* save offset to next table */
        do {
          fill -= incr;
          table[next + (huff >> drop) + fill] = (here_bits << 24) | (here_op << 16) | here_val | 0;
        } while (fill !== 0);

        /* backwards increment the len-bit code huff */
        incr = 1 << (len - 1);
        while (huff & incr) {
          incr >>= 1;
        }
        if (incr !== 0) {
          huff &= incr - 1;
          huff += incr;
        } else {
          huff = 0;
        }

        /* go to next symbol, update count, len */
        sym++;
        if (--count[len] === 0) {
          if (len === max) {
            break;
          }
          len = lens[lens_index + work[sym]];
        }

        /* create new sub-table if needed */
        if (len > root && (huff & mask) !== low) {
          /* if first time, transition to sub-tables */
          if (drop === 0) {
            drop = root;
          }

          /* increment past last table */
          next += min; /* here min is 1 << curr */

          /* determine length of next table */
          curr = len - drop;
          left = 1 << curr;
          while (curr + drop < max) {
            left -= count[curr + drop];
            if (left <= 0) {
              break;
            }
            curr++;
            left <<= 1;
          }

          /* check for enough space */
          used += 1 << curr;
          if ((type === LENS && used > ENOUGH_LENS) ||
            (type === DISTS && used > ENOUGH_DISTS)) {
            return 1;
          }

          /* point entry in root table to sub-table */
          low = huff & mask;
          /*table.op[low] = curr;
          table.bits[low] = root;
          table.val[low] = next - opts.table_index;*/
          table[low] = (root << 24) | (curr << 16) | (next - table_index) | 0;
        }
      }

      /* fill in remaining table entry if code is incomplete (guaranteed to have
       at most one remaining entry, since if the code is incomplete, the
       maximum code length that was allowed to get this far is one bit) */
      if (huff !== 0) {
        //table.op[next + huff] = 64;            /* invalid code marker */
        //table.bits[next + huff] = len - drop;
        //table.val[next + huff] = 0;
        table[next + huff] = ((len - drop) << 24) | (64 << 16) | 0;
      }

      /* set return parameters */
      //opts.table_index += used;
      opts.bits = root;
      return 0;
    }

    var CODES$1 = 0;
    var LENS$1 = 1;
    var DISTS$1 = 2;

    /* Public constants ==========================================================*/
    /* ===========================================================================*/


    /* Allowed flush values; see deflate() and inflate() below for details */
    //var Z_NO_FLUSH      = 0;
    //var Z_PARTIAL_FLUSH = 1;
    //var Z_SYNC_FLUSH    = 2;
    //var Z_FULL_FLUSH    = 3;
    var Z_FINISH$1 = 4;
    var Z_BLOCK$1 = 5;
    var Z_TREES = 6;


    /* Return codes for the compression/decompression functions. Negative values
     * are errors, positive values are used for special but normal events.
     */
    var Z_OK$1 = 0;
    var Z_STREAM_END$1 = 1;
    var Z_NEED_DICT = 2;
    //var Z_ERRNO         = -1;
    var Z_STREAM_ERROR$1 = -2;
    var Z_DATA_ERROR$1 = -3;
    var Z_MEM_ERROR = -4;
    var Z_BUF_ERROR$1 = -5;
    //var Z_VERSION_ERROR = -6;

    /* The deflate compression method */
    var Z_DEFLATED$1 = 8;


    /* STATES ====================================================================*/
    /* ===========================================================================*/


    var HEAD = 1; /* i: waiting for magic header */
    var FLAGS = 2; /* i: waiting for method and flags (gzip) */
    var TIME = 3; /* i: waiting for modification time (gzip) */
    var OS = 4; /* i: waiting for extra flags and operating system (gzip) */
    var EXLEN = 5; /* i: waiting for extra length (gzip) */
    var EXTRA = 6; /* i: waiting for extra bytes (gzip) */
    var NAME = 7; /* i: waiting for end of file name (gzip) */
    var COMMENT = 8; /* i: waiting for end of comment (gzip) */
    var HCRC = 9; /* i: waiting for header crc (gzip) */
    var DICTID = 10; /* i: waiting for dictionary check value */
    var DICT = 11; /* waiting for inflateSetDictionary() call */
    var TYPE$1 = 12; /* i: waiting for type bits, including last-flag bit */
    var TYPEDO = 13; /* i: same, but skip check to exit inflate on new block */
    var STORED = 14; /* i: waiting for stored size (length and complement) */
    var COPY_ = 15; /* i/o: same as COPY below, but only first time in */
    var COPY = 16; /* i/o: waiting for input or output to copy stored block */
    var TABLE = 17; /* i: waiting for dynamic block table lengths */
    var LENLENS = 18; /* i: waiting for code length code lengths */
    var CODELENS = 19; /* i: waiting for length/lit and distance code lengths */
    var LEN_ = 20; /* i: same as LEN below, but only first time in */
    var LEN = 21; /* i: waiting for length/lit/eob code */
    var LENEXT = 22; /* i: waiting for length extra bits */
    var DIST = 23; /* i: waiting for distance code */
    var DISTEXT = 24; /* i: waiting for distance extra bits */
    var MATCH = 25; /* o: waiting for output space to copy string */
    var LIT = 26; /* o: waiting for output space to write literal */
    var CHECK = 27; /* i: waiting for 32-bit check value */
    var LENGTH = 28; /* i: waiting for 32-bit length (gzip) */
    var DONE = 29; /* finished check, done -- remain here until reset */
    var BAD$1 = 30; /* got a data error -- remain here until reset */
    var MEM = 31; /* got an inflate() memory error -- remain here until reset */
    var SYNC = 32; /* looking for synchronization bytes to restart inflate() */

    /* ===========================================================================*/



    var ENOUGH_LENS$1 = 852;
    var ENOUGH_DISTS$1 = 592;


    function zswap32(q) {
      return (((q >>> 24) & 0xff) +
        ((q >>> 8) & 0xff00) +
        ((q & 0xff00) << 8) +
        ((q & 0xff) << 24));
    }


    function InflateState() {
      this.mode = 0; /* current inflate mode */
      this.last = false; /* true if processing last block */
      this.wrap = 0; /* bit 0 true for zlib, bit 1 true for gzip */
      this.havedict = false; /* true if dictionary provided */
      this.flags = 0; /* gzip header method and flags (0 if zlib) */
      this.dmax = 0; /* zlib header max distance (INFLATE_STRICT) */
      this.check = 0; /* protected copy of check value */
      this.total = 0; /* protected copy of output count */
      // TODO: may be {}
      this.head = null; /* where to save gzip header information */

      /* sliding window */
      this.wbits = 0; /* log base 2 of requested window size */
      this.wsize = 0; /* window size or zero if not using window */
      this.whave = 0; /* valid bytes in the window */
      this.wnext = 0; /* window write index */
      this.window = null; /* allocated sliding window, if needed */

      /* bit accumulator */
      this.hold = 0; /* input bit accumulator */
      this.bits = 0; /* number of bits in "in" */

      /* for string and stored block copying */
      this.length = 0; /* literal or length of data to copy */
      this.offset = 0; /* distance back to copy string from */

      /* for table and code decoding */
      this.extra = 0; /* extra bits needed */

      /* fixed and dynamic code tables */
      this.lencode = null; /* starting table for length/literal codes */
      this.distcode = null; /* starting table for distance codes */
      this.lenbits = 0; /* index bits for lencode */
      this.distbits = 0; /* index bits for distcode */

      /* dynamic table building */
      this.ncode = 0; /* number of code length code lengths */
      this.nlen = 0; /* number of length code lengths */
      this.ndist = 0; /* number of distance code lengths */
      this.have = 0; /* number of code lengths in lens[] */
      this.next = null; /* next available space in codes[] */

      this.lens = new Buf16(320); /* temporary storage for code lengths */
      this.work = new Buf16(288); /* work area for code table building */

      /*
       because we don't have pointers in js, we use lencode and distcode directly
       as buffers so we don't need codes
      */
      //this.codes = new Buf32(ENOUGH);       /* space for code tables */
      this.lendyn = null; /* dynamic table for length/literal codes (JS specific) */
      this.distdyn = null; /* dynamic table for distance codes (JS specific) */
      this.sane = 0; /* if false, allow invalid distance too far */
      this.back = 0; /* bits back of last unprocessed length/lit */
      this.was = 0; /* initial length of match */
    }

    function inflateResetKeep(strm) {
      var state;

      if (!strm || !strm.state) {
        return Z_STREAM_ERROR$1;
      }
      state = strm.state;
      strm.total_in = strm.total_out = state.total = 0;
      strm.msg = ''; /*Z_NULL*/
      if (state.wrap) { /* to support ill-conceived Java test suite */
        strm.adler = state.wrap & 1;
      }
      state.mode = HEAD;
      state.last = 0;
      state.havedict = 0;
      state.dmax = 32768;
      state.head = null /*Z_NULL*/ ;
      state.hold = 0;
      state.bits = 0;
      //state.lencode = state.distcode = state.next = state.codes;
      state.lencode = state.lendyn = new Buf32(ENOUGH_LENS$1);
      state.distcode = state.distdyn = new Buf32(ENOUGH_DISTS$1);

      state.sane = 1;
      state.back = -1;
      //Tracev((stderr, "inflate: reset\n"));
      return Z_OK$1;
    }

    function inflateReset(strm) {
      var state;

      if (!strm || !strm.state) {
        return Z_STREAM_ERROR$1;
      }
      state = strm.state;
      state.wsize = 0;
      state.whave = 0;
      state.wnext = 0;
      return inflateResetKeep(strm);

    }

    function inflateReset2(strm, windowBits) {
      var wrap;
      var state;

      /* get the state */
      if (!strm || !strm.state) {
        return Z_STREAM_ERROR$1;
      }
      state = strm.state;

      /* extract wrap request from windowBits parameter */
      if (windowBits < 0) {
        wrap = 0;
        windowBits = -windowBits;
      } else {
        wrap = (windowBits >> 4) + 1;
        if (windowBits < 48) {
          windowBits &= 15;
        }
      }

      /* set number of window bits, free window if different */
      if (windowBits && (windowBits < 8 || windowBits > 15)) {
        return Z_STREAM_ERROR$1;
      }
      if (state.window !== null && state.wbits !== windowBits) {
        state.window = null;
      }

      /* update state and reset the rest of it */
      state.wrap = wrap;
      state.wbits = windowBits;
      return inflateReset(strm);
    }

    function inflateInit2(strm, windowBits) {
      var ret;
      var state;

      if (!strm) {
        return Z_STREAM_ERROR$1;
      }
      //strm.msg = Z_NULL;                 /* in case we return an error */

      state = new InflateState();

      //if (state === Z_NULL) return Z_MEM_ERROR;
      //Tracev((stderr, "inflate: allocated\n"));
      strm.state = state;
      state.window = null /*Z_NULL*/ ;
      ret = inflateReset2(strm, windowBits);
      if (ret !== Z_OK$1) {
        strm.state = null /*Z_NULL*/ ;
      }
      return ret;
    }


    /*
     Return state with length and distance decoding tables and index sizes set to
     fixed code decoding.  Normally this returns fixed tables from inffixed.h.
     If BUILDFIXED is defined, then instead this routine builds the tables the
     first time it's called, and returns those tables the first time and
     thereafter.  This reduces the size of the code by about 2K bytes, in
     exchange for a little execution time.  However, BUILDFIXED should not be
     used for threaded applications, since the rewriting of the tables and virgin
     may not be thread-safe.
     */
    var virgin = true;

    var lenfix, distfix; // We have no pointers in JS, so keep tables separate

    function fixedtables(state) {
      /* build fixed huffman tables if first call (may not be thread safe) */
      if (virgin) {
        var sym;

        lenfix = new Buf32(512);
        distfix = new Buf32(32);

        /* literal/length table */
        sym = 0;
        while (sym < 144) {
          state.lens[sym++] = 8;
        }
        while (sym < 256) {
          state.lens[sym++] = 9;
        }
        while (sym < 280) {
          state.lens[sym++] = 7;
        }
        while (sym < 288) {
          state.lens[sym++] = 8;
        }

        inflate_table(LENS$1, state.lens, 0, 288, lenfix, 0, state.work, {
          bits: 9
        });

        /* distance table */
        sym = 0;
        while (sym < 32) {
          state.lens[sym++] = 5;
        }

        inflate_table(DISTS$1, state.lens, 0, 32, distfix, 0, state.work, {
          bits: 5
        });

        /* do this just once */
        virgin = false;
      }

      state.lencode = lenfix;
      state.lenbits = 9;
      state.distcode = distfix;
      state.distbits = 5;
    }


    /*
     Update the window with the last wsize (normally 32K) bytes written before
     returning.  If window does not exist yet, create it.  This is only called
     when a window is already in use, or when output has been written during this
     inflate call, but the end of the deflate stream has not been reached yet.
     It is also called to create a window for dictionary data when a dictionary
     is loaded.

     Providing output buffers larger than 32K to inflate() should provide a speed
     advantage, since only the last 32K of output is copied to the sliding window
     upon return from inflate(), and since all distances after the first 32K of
     output will fall in the output data, making match copies simpler and faster.
     The advantage may be dependent on the size of the processor's data caches.
     */
    function updatewindow(strm, src, end, copy) {
      var dist;
      var state = strm.state;

      /* if it hasn't been done already, allocate space for the window */
      if (state.window === null) {
        state.wsize = 1 << state.wbits;
        state.wnext = 0;
        state.whave = 0;

        state.window = new Buf8(state.wsize);
      }

      /* copy state->wsize or less output bytes into the circular window */
      if (copy >= state.wsize) {
        arraySet(state.window, src, end - state.wsize, state.wsize, 0);
        state.wnext = 0;
        state.whave = state.wsize;
      } else {
        dist = state.wsize - state.wnext;
        if (dist > copy) {
          dist = copy;
        }
        //zmemcpy(state->window + state->wnext, end - copy, dist);
        arraySet(state.window, src, end - copy, dist, state.wnext);
        copy -= dist;
        if (copy) {
          //zmemcpy(state->window, end - copy, copy);
          arraySet(state.window, src, end - copy, copy, 0);
          state.wnext = copy;
          state.whave = state.wsize;
        } else {
          state.wnext += dist;
          if (state.wnext === state.wsize) {
            state.wnext = 0;
          }
          if (state.whave < state.wsize) {
            state.whave += dist;
          }
        }
      }
      return 0;
    }

    function inflate(strm, flush) {
      var state;
      var input, output; // input/output buffers
      var next; /* next input INDEX */
      var put; /* next output INDEX */
      var have, left; /* available input and output */
      var hold; /* bit buffer */
      var bits; /* bits in bit buffer */
      var _in, _out; /* save starting available input and output */
      var copy; /* number of stored or match bytes to copy */
      var from; /* where to copy match bytes from */
      var from_source;
      var here = 0; /* current decoding table entry */
      var here_bits, here_op, here_val; // paked "here" denormalized (JS specific)
      //var last;                   /* parent table entry */
      var last_bits, last_op, last_val; // paked "last" denormalized (JS specific)
      var len; /* length to copy for repeats, bits to drop */
      var ret; /* return code */
      var hbuf = new Buf8(4); /* buffer for gzip header crc calculation */
      var opts;

      var n; // temporary var for NEED_BITS

      var order = /* permutation of code lengths */ [16, 17, 18, 0, 8, 7, 9, 6, 10, 5, 11, 4, 12, 3, 13, 2, 14, 1, 15];


      if (!strm || !strm.state || !strm.output ||
        (!strm.input && strm.avail_in !== 0)) {
        return Z_STREAM_ERROR$1;
      }

      state = strm.state;
      if (state.mode === TYPE$1) {
        state.mode = TYPEDO;
      } /* skip check */


      //--- LOAD() ---
      put = strm.next_out;
      output = strm.output;
      left = strm.avail_out;
      next = strm.next_in;
      input = strm.input;
      have = strm.avail_in;
      hold = state.hold;
      bits = state.bits;
      //---

      _in = have;
      _out = left;
      ret = Z_OK$1;

      inf_leave: // goto emulation
        for (;;) {
          switch (state.mode) {
          case HEAD:
            if (state.wrap === 0) {
              state.mode = TYPEDO;
              break;
            }
            //=== NEEDBITS(16);
            while (bits < 16) {
              if (have === 0) {
                break inf_leave;
              }
              have--;
              hold += input[next++] << bits;
              bits += 8;
            }
            //===//
            if ((state.wrap & 2) && hold === 0x8b1f) { /* gzip header */
              state.check = 0 /*crc32(0L, Z_NULL, 0)*/ ;
              //=== CRC2(state.check, hold);
              hbuf[0] = hold & 0xff;
              hbuf[1] = (hold >>> 8) & 0xff;
              state.check = crc32(state.check, hbuf, 2, 0);
              //===//

              //=== INITBITS();
              hold = 0;
              bits = 0;
              //===//
              state.mode = FLAGS;
              break;
            }
            state.flags = 0; /* expect zlib header */
            if (state.head) {
              state.head.done = false;
            }
            if (!(state.wrap & 1) || /* check if zlib header allowed */
              (((hold & 0xff) /*BITS(8)*/ << 8) + (hold >> 8)) % 31) {
              strm.msg = 'incorrect header check';
              state.mode = BAD$1;
              break;
            }
            if ((hold & 0x0f) /*BITS(4)*/ !== Z_DEFLATED$1) {
              strm.msg = 'unknown compression method';
              state.mode = BAD$1;
              break;
            }
            //--- DROPBITS(4) ---//
            hold >>>= 4;
            bits -= 4;
            //---//
            len = (hold & 0x0f) /*BITS(4)*/ + 8;
            if (state.wbits === 0) {
              state.wbits = len;
            } else if (len > state.wbits) {
              strm.msg = 'invalid window size';
              state.mode = BAD$1;
              break;
            }
            state.dmax = 1 << len;
            //Tracev((stderr, "inflate:   zlib header ok\n"));
            strm.adler = state.check = 1 /*adler32(0L, Z_NULL, 0)*/ ;
            state.mode = hold & 0x200 ? DICTID : TYPE$1;
            //=== INITBITS();
            hold = 0;
            bits = 0;
            //===//
            break;
          case FLAGS:
            //=== NEEDBITS(16); */
            while (bits < 16) {
              if (have === 0) {
                break inf_leave;
              }
              have--;
              hold += input[next++] << bits;
              bits += 8;
            }
            //===//
            state.flags = hold;
            if ((state.flags & 0xff) !== Z_DEFLATED$1) {
              strm.msg = 'unknown compression method';
              state.mode = BAD$1;
              break;
            }
            if (state.flags & 0xe000) {
              strm.msg = 'unknown header flags set';
              state.mode = BAD$1;
              break;
            }
            if (state.head) {
              state.head.text = ((hold >> 8) & 1);
            }
            if (state.flags & 0x0200) {
              //=== CRC2(state.check, hold);
              hbuf[0] = hold & 0xff;
              hbuf[1] = (hold >>> 8) & 0xff;
              state.check = crc32(state.check, hbuf, 2, 0);
              //===//
            }
            //=== INITBITS();
            hold = 0;
            bits = 0;
            //===//
            state.mode = TIME;
            /* falls through */
          case TIME:
            //=== NEEDBITS(32); */
            while (bits < 32) {
              if (have === 0) {
                break inf_leave;
              }
              have--;
              hold += input[next++] << bits;
              bits += 8;
            }
            //===//
            if (state.head) {
              state.head.time = hold;
            }
            if (state.flags & 0x0200) {
              //=== CRC4(state.check, hold)
              hbuf[0] = hold & 0xff;
              hbuf[1] = (hold >>> 8) & 0xff;
              hbuf[2] = (hold >>> 16) & 0xff;
              hbuf[3] = (hold >>> 24) & 0xff;
              state.check = crc32(state.check, hbuf, 4, 0);
              //===
            }
            //=== INITBITS();
            hold = 0;
            bits = 0;
            //===//
            state.mode = OS;
            /* falls through */
          case OS:
            //=== NEEDBITS(16); */
            while (bits < 16) {
              if (have === 0) {
                break inf_leave;
              }
              have--;
              hold += input[next++] << bits;
              bits += 8;
            }
            //===//
            if (state.head) {
              state.head.xflags = (hold & 0xff);
              state.head.os = (hold >> 8);
            }
            if (state.flags & 0x0200) {
              //=== CRC2(state.check, hold);
              hbuf[0] = hold & 0xff;
              hbuf[1] = (hold >>> 8) & 0xff;
              state.check = crc32(state.check, hbuf, 2, 0);
              //===//
            }
            //=== INITBITS();
            hold = 0;
            bits = 0;
            //===//
            state.mode = EXLEN;
            /* falls through */
          case EXLEN:
            if (state.flags & 0x0400) {
              //=== NEEDBITS(16); */
              while (bits < 16) {
                if (have === 0) {
                  break inf_leave;
                }
                have--;
                hold += input[next++] << bits;
                bits += 8;
              }
              //===//
              state.length = hold;
              if (state.head) {
                state.head.extra_len = hold;
              }
              if (state.flags & 0x0200) {
                //=== CRC2(state.check, hold);
                hbuf[0] = hold & 0xff;
                hbuf[1] = (hold >>> 8) & 0xff;
                state.check = crc32(state.check, hbuf, 2, 0);
                //===//
              }
              //=== INITBITS();
              hold = 0;
              bits = 0;
              //===//
            } else if (state.head) {
              state.head.extra = null /*Z_NULL*/ ;
            }
            state.mode = EXTRA;
            /* falls through */
          case EXTRA:
            if (state.flags & 0x0400) {
              copy = state.length;
              if (copy > have) {
                copy = have;
              }
              if (copy) {
                if (state.head) {
                  len = state.head.extra_len - state.length;
                  if (!state.head.extra) {
                    // Use untyped array for more conveniend processing later
                    state.head.extra = new Array(state.head.extra_len);
                  }
                  arraySet(
                    state.head.extra,
                    input,
                    next,
                    // extra field is limited to 65536 bytes
                    // - no need for additional size check
                    copy,
                    /*len + copy > state.head.extra_max - len ? state.head.extra_max : copy,*/
                    len
                  );
                  //zmemcpy(state.head.extra + len, next,
                  //        len + copy > state.head.extra_max ?
                  //        state.head.extra_max - len : copy);
                }
                if (state.flags & 0x0200) {
                  state.check = crc32(state.check, input, copy, next);
                }
                have -= copy;
                next += copy;
                state.length -= copy;
              }
              if (state.length) {
                break inf_leave;
              }
            }
            state.length = 0;
            state.mode = NAME;
            /* falls through */
          case NAME:
            if (state.flags & 0x0800) {
              if (have === 0) {
                break inf_leave;
              }
              copy = 0;
              do {
                // TODO: 2 or 1 bytes?
                len = input[next + copy++];
                /* use constant limit because in js we should not preallocate memory */
                if (state.head && len &&
                  (state.length < 65536 /*state.head.name_max*/ )) {
                  state.head.name += String.fromCharCode(len);
                }
              } while (len && copy < have);

              if (state.flags & 0x0200) {
                state.check = crc32(state.check, input, copy, next);
              }
              have -= copy;
              next += copy;
              if (len) {
                break inf_leave;
              }
            } else if (state.head) {
              state.head.name = null;
            }
            state.length = 0;
            state.mode = COMMENT;
            /* falls through */
          case COMMENT:
            if (state.flags & 0x1000) {
              if (have === 0) {
                break inf_leave;
              }
              copy = 0;
              do {
                len = input[next + copy++];
                /* use constant limit because in js we should not preallocate memory */
                if (state.head && len &&
                  (state.length < 65536 /*state.head.comm_max*/ )) {
                  state.head.comment += String.fromCharCode(len);
                }
              } while (len && copy < have);
              if (state.flags & 0x0200) {
                state.check = crc32(state.check, input, copy, next);
              }
              have -= copy;
              next += copy;
              if (len) {
                break inf_leave;
              }
            } else if (state.head) {
              state.head.comment = null;
            }
            state.mode = HCRC;
            /* falls through */
          case HCRC:
            if (state.flags & 0x0200) {
              //=== NEEDBITS(16); */
              while (bits < 16) {
                if (have === 0) {
                  break inf_leave;
                }
                have--;
                hold += input[next++] << bits;
                bits += 8;
              }
              //===//
              if (hold !== (state.check & 0xffff)) {
                strm.msg = 'header crc mismatch';
                state.mode = BAD$1;
                break;
              }
              //=== INITBITS();
              hold = 0;
              bits = 0;
              //===//
            }
            if (state.head) {
              state.head.hcrc = ((state.flags >> 9) & 1);
              state.head.done = true;
            }
            strm.adler = state.check = 0;
            state.mode = TYPE$1;
            break;
          case DICTID:
            //=== NEEDBITS(32); */
            while (bits < 32) {
              if (have === 0) {
                break inf_leave;
              }
              have--;
              hold += input[next++] << bits;
              bits += 8;
            }
            //===//
            strm.adler = state.check = zswap32(hold);
            //=== INITBITS();
            hold = 0;
            bits = 0;
            //===//
            state.mode = DICT;
            /* falls through */
          case DICT:
            if (state.havedict === 0) {
              //--- RESTORE() ---
              strm.next_out = put;
              strm.avail_out = left;
              strm.next_in = next;
              strm.avail_in = have;
              state.hold = hold;
              state.bits = bits;
              //---
              return Z_NEED_DICT;
            }
            strm.adler = state.check = 1 /*adler32(0L, Z_NULL, 0)*/ ;
            state.mode = TYPE$1;
            /* falls through */
          case TYPE$1:
            if (flush === Z_BLOCK$1 || flush === Z_TREES) {
              break inf_leave;
            }
            /* falls through */
          case TYPEDO:
            if (state.last) {
              //--- BYTEBITS() ---//
              hold >>>= bits & 7;
              bits -= bits & 7;
              //---//
              state.mode = CHECK;
              break;
            }
            //=== NEEDBITS(3); */
            while (bits < 3) {
              if (have === 0) {
                break inf_leave;
              }
              have--;
              hold += input[next++] << bits;
              bits += 8;
            }
            //===//
            state.last = (hold & 0x01) /*BITS(1)*/ ;
            //--- DROPBITS(1) ---//
            hold >>>= 1;
            bits -= 1;
            //---//

            switch ((hold & 0x03) /*BITS(2)*/ ) {
            case 0:
              /* stored block */
              //Tracev((stderr, "inflate:     stored block%s\n",
              //        state.last ? " (last)" : ""));
              state.mode = STORED;
              break;
            case 1:
              /* fixed block */
              fixedtables(state);
              //Tracev((stderr, "inflate:     fixed codes block%s\n",
              //        state.last ? " (last)" : ""));
              state.mode = LEN_; /* decode codes */
              if (flush === Z_TREES) {
                //--- DROPBITS(2) ---//
                hold >>>= 2;
                bits -= 2;
                //---//
                break inf_leave;
              }
              break;
            case 2:
              /* dynamic block */
              //Tracev((stderr, "inflate:     dynamic codes block%s\n",
              //        state.last ? " (last)" : ""));
              state.mode = TABLE;
              break;
            case 3:
              strm.msg = 'invalid block type';
              state.mode = BAD$1;
            }
            //--- DROPBITS(2) ---//
            hold >>>= 2;
            bits -= 2;
            //---//
            break;
          case STORED:
            //--- BYTEBITS() ---// /* go to byte boundary */
            hold >>>= bits & 7;
            bits -= bits & 7;
            //---//
            //=== NEEDBITS(32); */
            while (bits < 32) {
              if (have === 0) {
                break inf_leave;
              }
              have--;
              hold += input[next++] << bits;
              bits += 8;
            }
            //===//
            if ((hold & 0xffff) !== ((hold >>> 16) ^ 0xffff)) {
              strm.msg = 'invalid stored block lengths';
              state.mode = BAD$1;
              break;
            }
            state.length = hold & 0xffff;
            //Tracev((stderr, "inflate:       stored length %u\n",
            //        state.length));
            //=== INITBITS();
            hold = 0;
            bits = 0;
            //===//
            state.mode = COPY_;
            if (flush === Z_TREES) {
              break inf_leave;
            }
            /* falls through */
          case COPY_:
            state.mode = COPY;
            /* falls through */
          case COPY:
            copy = state.length;
            if (copy) {
              if (copy > have) {
                copy = have;
              }
              if (copy > left) {
                copy = left;
              }
              if (copy === 0) {
                break inf_leave;
              }
              //--- zmemcpy(put, next, copy); ---
              arraySet(output, input, next, copy, put);
              //---//
              have -= copy;
              next += copy;
              left -= copy;
              put += copy;
              state.length -= copy;
              break;
            }
            //Tracev((stderr, "inflate:       stored end\n"));
            state.mode = TYPE$1;
            break;
          case TABLE:
            //=== NEEDBITS(14); */
            while (bits < 14) {
              if (have === 0) {
                break inf_leave;
              }
              have--;
              hold += input[next++] << bits;
              bits += 8;
            }
            //===//
            state.nlen = (hold & 0x1f) /*BITS(5)*/ + 257;
            //--- DROPBITS(5) ---//
            hold >>>= 5;
            bits -= 5;
            //---//
            state.ndist = (hold & 0x1f) /*BITS(5)*/ + 1;
            //--- DROPBITS(5) ---//
            hold >>>= 5;
            bits -= 5;
            //---//
            state.ncode = (hold & 0x0f) /*BITS(4)*/ + 4;
            //--- DROPBITS(4) ---//
            hold >>>= 4;
            bits -= 4;
            //---//
            //#ifndef PKZIP_BUG_WORKAROUND
            if (state.nlen > 286 || state.ndist > 30) {
              strm.msg = 'too many length or distance symbols';
              state.mode = BAD$1;
              break;
            }
            //#endif
            //Tracev((stderr, "inflate:       table sizes ok\n"));
            state.have = 0;
            state.mode = LENLENS;
            /* falls through */
          case LENLENS:
            while (state.have < state.ncode) {
              //=== NEEDBITS(3);
              while (bits < 3) {
                if (have === 0) {
                  break inf_leave;
                }
                have--;
                hold += input[next++] << bits;
                bits += 8;
              }
              //===//
              state.lens[order[state.have++]] = (hold & 0x07); //BITS(3);
              //--- DROPBITS(3) ---//
              hold >>>= 3;
              bits -= 3;
              //---//
            }
            while (state.have < 19) {
              state.lens[order[state.have++]] = 0;
            }
            // We have separate tables & no pointers. 2 commented lines below not needed.
            //state.next = state.codes;
            //state.lencode = state.next;
            // Switch to use dynamic table
            state.lencode = state.lendyn;
            state.lenbits = 7;

            opts = {
              bits: state.lenbits
            };
            ret = inflate_table(CODES$1, state.lens, 0, 19, state.lencode, 0, state.work, opts);
            state.lenbits = opts.bits;

            if (ret) {
              strm.msg = 'invalid code lengths set';
              state.mode = BAD$1;
              break;
            }
            //Tracev((stderr, "inflate:       code lengths ok\n"));
            state.have = 0;
            state.mode = CODELENS;
            /* falls through */
          case CODELENS:
            while (state.have < state.nlen + state.ndist) {
              for (;;) {
                here = state.lencode[hold & ((1 << state.lenbits) - 1)]; /*BITS(state.lenbits)*/
                here_bits = here >>> 24;
                here_op = (here >>> 16) & 0xff;
                here_val = here & 0xffff;

                if ((here_bits) <= bits) {
                  break;
                }
                //--- PULLBYTE() ---//
                if (have === 0) {
                  break inf_leave;
                }
                have--;
                hold += input[next++] << bits;
                bits += 8;
                //---//
              }
              if (here_val < 16) {
                //--- DROPBITS(here.bits) ---//
                hold >>>= here_bits;
                bits -= here_bits;
                //---//
                state.lens[state.have++] = here_val;
              } else {
                if (here_val === 16) {
                  //=== NEEDBITS(here.bits + 2);
                  n = here_bits + 2;
                  while (bits < n) {
                    if (have === 0) {
                      break inf_leave;
                    }
                    have--;
                    hold += input[next++] << bits;
                    bits += 8;
                  }
                  //===//
                  //--- DROPBITS(here.bits) ---//
                  hold >>>= here_bits;
                  bits -= here_bits;
                  //---//
                  if (state.have === 0) {
                    strm.msg = 'invalid bit length repeat';
                    state.mode = BAD$1;
                    break;
                  }
                  len = state.lens[state.have - 1];
                  copy = 3 + (hold & 0x03); //BITS(2);
                  //--- DROPBITS(2) ---//
                  hold >>>= 2;
                  bits -= 2;
                  //---//
                } else if (here_val === 17) {
                  //=== NEEDBITS(here.bits + 3);
                  n = here_bits + 3;
                  while (bits < n) {
                    if (have === 0) {
                      break inf_leave;
                    }
                    have--;
                    hold += input[next++] << bits;
                    bits += 8;
                  }
                  //===//
                  //--- DROPBITS(here.bits) ---//
                  hold >>>= here_bits;
                  bits -= here_bits;
                  //---//
                  len = 0;
                  copy = 3 + (hold & 0x07); //BITS(3);
                  //--- DROPBITS(3) ---//
                  hold >>>= 3;
                  bits -= 3;
                  //---//
                } else {
                  //=== NEEDBITS(here.bits + 7);
                  n = here_bits + 7;
                  while (bits < n) {
                    if (have === 0) {
                      break inf_leave;
                    }
                    have--;
                    hold += input[next++] << bits;
                    bits += 8;
                  }
                  //===//
                  //--- DROPBITS(here.bits) ---//
                  hold >>>= here_bits;
                  bits -= here_bits;
                  //---//
                  len = 0;
                  copy = 11 + (hold & 0x7f); //BITS(7);
                  //--- DROPBITS(7) ---//
                  hold >>>= 7;
                  bits -= 7;
                  //---//
                }
                if (state.have + copy > state.nlen + state.ndist) {
                  strm.msg = 'invalid bit length repeat';
                  state.mode = BAD$1;
                  break;
                }
                while (copy--) {
                  state.lens[state.have++] = len;
                }
              }
            }

            /* handle error breaks in while */
            if (state.mode === BAD$1) {
              break;
            }

            /* check for end-of-block code (better have one) */
            if (state.lens[256] === 0) {
              strm.msg = 'invalid code -- missing end-of-block';
              state.mode = BAD$1;
              break;
            }

            /* build code tables -- note: do not change the lenbits or distbits
               values here (9 and 6) without reading the comments in inftrees.h
               concerning the ENOUGH constants, which depend on those values */
            state.lenbits = 9;

            opts = {
              bits: state.lenbits
            };
            ret = inflate_table(LENS$1, state.lens, 0, state.nlen, state.lencode, 0, state.work, opts);
            // We have separate tables & no pointers. 2 commented lines below not needed.
            // state.next_index = opts.table_index;
            state.lenbits = opts.bits;
            // state.lencode = state.next;

            if (ret) {
              strm.msg = 'invalid literal/lengths set';
              state.mode = BAD$1;
              break;
            }

            state.distbits = 6;
            //state.distcode.copy(state.codes);
            // Switch to use dynamic table
            state.distcode = state.distdyn;
            opts = {
              bits: state.distbits
            };
            ret = inflate_table(DISTS$1, state.lens, state.nlen, state.ndist, state.distcode, 0, state.work, opts);
            // We have separate tables & no pointers. 2 commented lines below not needed.
            // state.next_index = opts.table_index;
            state.distbits = opts.bits;
            // state.distcode = state.next;

            if (ret) {
              strm.msg = 'invalid distances set';
              state.mode = BAD$1;
              break;
            }
            //Tracev((stderr, 'inflate:       codes ok\n'));
            state.mode = LEN_;
            if (flush === Z_TREES) {
              break inf_leave;
            }
            /* falls through */
          case LEN_:
            state.mode = LEN;
            /* falls through */
          case LEN:
            if (have >= 6 && left >= 258) {
              //--- RESTORE() ---
              strm.next_out = put;
              strm.avail_out = left;
              strm.next_in = next;
              strm.avail_in = have;
              state.hold = hold;
              state.bits = bits;
              //---
              inflate_fast(strm, _out);
              //--- LOAD() ---
              put = strm.next_out;
              output = strm.output;
              left = strm.avail_out;
              next = strm.next_in;
              input = strm.input;
              have = strm.avail_in;
              hold = state.hold;
              bits = state.bits;
              //---

              if (state.mode === TYPE$1) {
                state.back = -1;
              }
              break;
            }
            state.back = 0;
            for (;;) {
              here = state.lencode[hold & ((1 << state.lenbits) - 1)]; /*BITS(state.lenbits)*/
              here_bits = here >>> 24;
              here_op = (here >>> 16) & 0xff;
              here_val = here & 0xffff;

              if (here_bits <= bits) {
                break;
              }
              //--- PULLBYTE() ---//
              if (have === 0) {
                break inf_leave;
              }
              have--;
              hold += input[next++] << bits;
              bits += 8;
              //---//
            }
            if (here_op && (here_op & 0xf0) === 0) {
              last_bits = here_bits;
              last_op = here_op;
              last_val = here_val;
              for (;;) {
                here = state.lencode[last_val +
                  ((hold & ((1 << (last_bits + last_op)) - 1)) /*BITS(last.bits + last.op)*/ >> last_bits)];
                here_bits = here >>> 24;
                here_op = (here >>> 16) & 0xff;
                here_val = here & 0xffff;

                if ((last_bits + here_bits) <= bits) {
                  break;
                }
                //--- PULLBYTE() ---//
                if (have === 0) {
                  break inf_leave;
                }
                have--;
                hold += input[next++] << bits;
                bits += 8;
                //---//
              }
              //--- DROPBITS(last.bits) ---//
              hold >>>= last_bits;
              bits -= last_bits;
              //---//
              state.back += last_bits;
            }
            //--- DROPBITS(here.bits) ---//
            hold >>>= here_bits;
            bits -= here_bits;
            //---//
            state.back += here_bits;
            state.length = here_val;
            if (here_op === 0) {
              //Tracevv((stderr, here.val >= 0x20 && here.val < 0x7f ?
              //        "inflate:         literal '%c'\n" :
              //        "inflate:         literal 0x%02x\n", here.val));
              state.mode = LIT;
              break;
            }
            if (here_op & 32) {
              //Tracevv((stderr, "inflate:         end of block\n"));
              state.back = -1;
              state.mode = TYPE$1;
              break;
            }
            if (here_op & 64) {
              strm.msg = 'invalid literal/length code';
              state.mode = BAD$1;
              break;
            }
            state.extra = here_op & 15;
            state.mode = LENEXT;
            /* falls through */
          case LENEXT:
            if (state.extra) {
              //=== NEEDBITS(state.extra);
              n = state.extra;
              while (bits < n) {
                if (have === 0) {
                  break inf_leave;
                }
                have--;
                hold += input[next++] << bits;
                bits += 8;
              }
              //===//
              state.length += hold & ((1 << state.extra) - 1) /*BITS(state.extra)*/ ;
              //--- DROPBITS(state.extra) ---//
              hold >>>= state.extra;
              bits -= state.extra;
              //---//
              state.back += state.extra;
            }
            //Tracevv((stderr, "inflate:         length %u\n", state.length));
            state.was = state.length;
            state.mode = DIST;
            /* falls through */
          case DIST:
            for (;;) {
              here = state.distcode[hold & ((1 << state.distbits) - 1)]; /*BITS(state.distbits)*/
              here_bits = here >>> 24;
              here_op = (here >>> 16) & 0xff;
              here_val = here & 0xffff;

              if ((here_bits) <= bits) {
                break;
              }
              //--- PULLBYTE() ---//
              if (have === 0) {
                break inf_leave;
              }
              have--;
              hold += input[next++] << bits;
              bits += 8;
              //---//
            }
            if ((here_op & 0xf0) === 0) {
              last_bits = here_bits;
              last_op = here_op;
              last_val = here_val;
              for (;;) {
                here = state.distcode[last_val +
                  ((hold & ((1 << (last_bits + last_op)) - 1)) /*BITS(last.bits + last.op)*/ >> last_bits)];
                here_bits = here >>> 24;
                here_op = (here >>> 16) & 0xff;
                here_val = here & 0xffff;

                if ((last_bits + here_bits) <= bits) {
                  break;
                }
                //--- PULLBYTE() ---//
                if (have === 0) {
                  break inf_leave;
                }
                have--;
                hold += input[next++] << bits;
                bits += 8;
                //---//
              }
              //--- DROPBITS(last.bits) ---//
              hold >>>= last_bits;
              bits -= last_bits;
              //---//
              state.back += last_bits;
            }
            //--- DROPBITS(here.bits) ---//
            hold >>>= here_bits;
            bits -= here_bits;
            //---//
            state.back += here_bits;
            if (here_op & 64) {
              strm.msg = 'invalid distance code';
              state.mode = BAD$1;
              break;
            }
            state.offset = here_val;
            state.extra = (here_op) & 15;
            state.mode = DISTEXT;
            /* falls through */
          case DISTEXT:
            if (state.extra) {
              //=== NEEDBITS(state.extra);
              n = state.extra;
              while (bits < n) {
                if (have === 0) {
                  break inf_leave;
                }
                have--;
                hold += input[next++] << bits;
                bits += 8;
              }
              //===//
              state.offset += hold & ((1 << state.extra) - 1) /*BITS(state.extra)*/ ;
              //--- DROPBITS(state.extra) ---//
              hold >>>= state.extra;
              bits -= state.extra;
              //---//
              state.back += state.extra;
            }
            //#ifdef INFLATE_STRICT
            if (state.offset > state.dmax) {
              strm.msg = 'invalid distance too far back';
              state.mode = BAD$1;
              break;
            }
            //#endif
            //Tracevv((stderr, "inflate:         distance %u\n", state.offset));
            state.mode = MATCH;
            /* falls through */
          case MATCH:
            if (left === 0) {
              break inf_leave;
            }
            copy = _out - left;
            if (state.offset > copy) { /* copy from window */
              copy = state.offset - copy;
              if (copy > state.whave) {
                if (state.sane) {
                  strm.msg = 'invalid distance too far back';
                  state.mode = BAD$1;
                  break;
                }
                // (!) This block is disabled in zlib defailts,
                // don't enable it for binary compatibility
                //#ifdef INFLATE_ALLOW_INVALID_DISTANCE_TOOFAR_ARRR
                //          Trace((stderr, "inflate.c too far\n"));
                //          copy -= state.whave;
                //          if (copy > state.length) { copy = state.length; }
                //          if (copy > left) { copy = left; }
                //          left -= copy;
                //          state.length -= copy;
                //          do {
                //            output[put++] = 0;
                //          } while (--copy);
                //          if (state.length === 0) { state.mode = LEN; }
                //          break;
                //#endif
              }
              if (copy > state.wnext) {
                copy -= state.wnext;
                from = state.wsize - copy;
              } else {
                from = state.wnext - copy;
              }
              if (copy > state.length) {
                copy = state.length;
              }
              from_source = state.window;
            } else { /* copy from output */
              from_source = output;
              from = put - state.offset;
              copy = state.length;
            }
            if (copy > left) {
              copy = left;
            }
            left -= copy;
            state.length -= copy;
            do {
              output[put++] = from_source[from++];
            } while (--copy);
            if (state.length === 0) {
              state.mode = LEN;
            }
            break;
          case LIT:
            if (left === 0) {
              break inf_leave;
            }
            output[put++] = state.length;
            left--;
            state.mode = LEN;
            break;
          case CHECK:
            if (state.wrap) {
              //=== NEEDBITS(32);
              while (bits < 32) {
                if (have === 0) {
                  break inf_leave;
                }
                have--;
                // Use '|' insdead of '+' to make sure that result is signed
                hold |= input[next++] << bits;
                bits += 8;
              }
              //===//
              _out -= left;
              strm.total_out += _out;
              state.total += _out;
              if (_out) {
                strm.adler = state.check =
                  /*UPDATE(state.check, put - _out, _out);*/
                  (state.flags ? crc32(state.check, output, _out, put - _out) : adler32(state.check, output, _out, put - _out));

              }
              _out = left;
              // NB: crc32 stored as signed 32-bit int, zswap32 returns signed too
              if ((state.flags ? hold : zswap32(hold)) !== state.check) {
                strm.msg = 'incorrect data check';
                state.mode = BAD$1;
                break;
              }
              //=== INITBITS();
              hold = 0;
              bits = 0;
              //===//
              //Tracev((stderr, "inflate:   check matches trailer\n"));
            }
            state.mode = LENGTH;
            /* falls through */
          case LENGTH:
            if (state.wrap && state.flags) {
              //=== NEEDBITS(32);
              while (bits < 32) {
                if (have === 0) {
                  break inf_leave;
                }
                have--;
                hold += input[next++] << bits;
                bits += 8;
              }
              //===//
              if (hold !== (state.total & 0xffffffff)) {
                strm.msg = 'incorrect length check';
                state.mode = BAD$1;
                break;
              }
              //=== INITBITS();
              hold = 0;
              bits = 0;
              //===//
              //Tracev((stderr, "inflate:   length matches trailer\n"));
            }
            state.mode = DONE;
            /* falls through */
          case DONE:
            ret = Z_STREAM_END$1;
            break inf_leave;
          case BAD$1:
            ret = Z_DATA_ERROR$1;
            break inf_leave;
          case MEM:
            return Z_MEM_ERROR;
          case SYNC:
            /* falls through */
          default:
            return Z_STREAM_ERROR$1;
          }
        }

      // inf_leave <- here is real place for "goto inf_leave", emulated via "break inf_leave"

      /*
         Return from inflate(), updating the total counts and the check value.
         If there was no progress during the inflate() call, return a buffer
         error.  Call updatewindow() to create and/or update the window state.
         Note: a memory error from inflate() is non-recoverable.
       */

      //--- RESTORE() ---
      strm.next_out = put;
      strm.avail_out = left;
      strm.next_in = next;
      strm.avail_in = have;
      state.hold = hold;
      state.bits = bits;
      //---

      if (state.wsize || (_out !== strm.avail_out && state.mode < BAD$1 &&
          (state.mode < CHECK || flush !== Z_FINISH$1))) {
        if (updatewindow(strm, strm.output, strm.next_out, _out - strm.avail_out)) ;
      }
      _in -= strm.avail_in;
      _out -= strm.avail_out;
      strm.total_in += _in;
      strm.total_out += _out;
      state.total += _out;
      if (state.wrap && _out) {
        strm.adler = state.check = /*UPDATE(state.check, strm.next_out - _out, _out);*/
          (state.flags ? crc32(state.check, output, _out, strm.next_out - _out) : adler32(state.check, output, _out, strm.next_out - _out));
      }
      strm.data_type = state.bits + (state.last ? 64 : 0) +
        (state.mode === TYPE$1 ? 128 : 0) +
        (state.mode === LEN_ || state.mode === COPY_ ? 256 : 0);
      if (((_in === 0 && _out === 0) || flush === Z_FINISH$1) && ret === Z_OK$1) {
        ret = Z_BUF_ERROR$1;
      }
      return ret;
    }

    function inflateEnd(strm) {

      if (!strm || !strm.state /*|| strm->zfree == (free_func)0*/ ) {
        return Z_STREAM_ERROR$1;
      }

      var state = strm.state;
      if (state.window) {
        state.window = null;
      }
      strm.state = null;
      return Z_OK$1;
    }

    /* Not implemented
    exports.inflateCopy = inflateCopy;
    exports.inflateGetDictionary = inflateGetDictionary;
    exports.inflateMark = inflateMark;
    exports.inflatePrime = inflatePrime;
    exports.inflateSync = inflateSync;
    exports.inflateSyncPoint = inflateSyncPoint;
    exports.inflateUndermine = inflateUndermine;
    */

    // import constants from './constants';


    // zlib modes
    var NONE = 0;
    var DEFLATE = 1;
    var INFLATE = 2;
    var GZIP = 3;
    var GUNZIP = 4;
    var DEFLATERAW = 5;
    var INFLATERAW = 6;
    var UNZIP = 7;
    var Z_NO_FLUSH$1=         0,
      Z_PARTIAL_FLUSH$1=    1,
      Z_SYNC_FLUSH=    2,
      Z_FULL_FLUSH$1=       3,
      Z_FINISH$2=       4,
      Z_BLOCK$2=           5,
      Z_TREES$1=            6,

      /* Return codes for the compression/decompression functions. Negative values
      * are errors, positive values are used for special but normal events.
      */
      Z_OK$2=               0,
      Z_STREAM_END$2=       1,
      Z_NEED_DICT$1=      2,
      Z_ERRNO=       -1,
      Z_STREAM_ERROR$2=   -2,
      Z_DATA_ERROR$2=    -3,
      //Z_MEM_ERROR:     -4,
      Z_BUF_ERROR$2=    -5,
      //Z_VERSION_ERROR: -6,

      /* compression levels */
      Z_NO_COMPRESSION=         0,
      Z_BEST_SPEED=             1,
      Z_BEST_COMPRESSION=       9,
      Z_DEFAULT_COMPRESSION$1=   -1,


      Z_FILTERED$1=               1,
      Z_HUFFMAN_ONLY$1=           2,
      Z_RLE$1=                    3,
      Z_FIXED$2=                  4,
      Z_DEFAULT_STRATEGY=       0,

      /* Possible values of the data_type field (though see inflate()) */
      Z_BINARY$1=                 0,
      Z_TEXT$1=                   1,
      //Z_ASCII:                1, // = Z_TEXT (deprecated)
      Z_UNKNOWN$2=                2,

      /* The deflate compression method */
      Z_DEFLATED$2=               8;
    function Zlib(mode) {
      if (mode < DEFLATE || mode > UNZIP)
        throw new TypeError('Bad argument');

      this.mode = mode;
      this.init_done = false;
      this.write_in_progress = false;
      this.pending_close = false;
      this.windowBits = 0;
      this.level = 0;
      this.memLevel = 0;
      this.strategy = 0;
      this.dictionary = null;
    }

    Zlib.prototype.init = function(windowBits, level, memLevel, strategy, dictionary) {
      this.windowBits = windowBits;
      this.level = level;
      this.memLevel = memLevel;
      this.strategy = strategy;
      // dictionary not supported.

      if (this.mode === GZIP || this.mode === GUNZIP)
        this.windowBits += 16;

      if (this.mode === UNZIP)
        this.windowBits += 32;

      if (this.mode === DEFLATERAW || this.mode === INFLATERAW)
        this.windowBits = -this.windowBits;

      this.strm = new ZStream();
      var status;
      switch (this.mode) {
      case DEFLATE:
      case GZIP:
      case DEFLATERAW:
        status = deflateInit2(
          this.strm,
          this.level,
          Z_DEFLATED$2,
          this.windowBits,
          this.memLevel,
          this.strategy
        );
        break;
      case INFLATE:
      case GUNZIP:
      case INFLATERAW:
      case UNZIP:
        status  = inflateInit2(
          this.strm,
          this.windowBits
        );
        break;
      default:
        throw new Error('Unknown mode ' + this.mode);
      }

      if (status !== Z_OK$2) {
        this._error(status);
        return;
      }

      this.write_in_progress = false;
      this.init_done = true;
    };

    Zlib.prototype.params = function() {
      throw new Error('deflateParams Not supported');
    };

    Zlib.prototype._writeCheck = function() {
      if (!this.init_done)
        throw new Error('write before init');

      if (this.mode === NONE)
        throw new Error('already finalized');

      if (this.write_in_progress)
        throw new Error('write already in progress');

      if (this.pending_close)
        throw new Error('close is pending');
    };

    Zlib.prototype.write = function(flush, input, in_off, in_len, out, out_off, out_len) {
      this._writeCheck();
      this.write_in_progress = true;

      var self = this;
      process.nextTick(function() {
        self.write_in_progress = false;
        var res = self._write(flush, input, in_off, in_len, out, out_off, out_len);
        self.callback(res[0], res[1]);

        if (self.pending_close)
          self.close();
      });

      return this;
    };

    // set method for Node buffers, used by pako
    function bufferSet(data, offset) {
      for (var i = 0; i < data.length; i++) {
        this[offset + i] = data[i];
      }
    }

    Zlib.prototype.writeSync = function(flush, input, in_off, in_len, out, out_off, out_len) {
      this._writeCheck();
      return this._write(flush, input, in_off, in_len, out, out_off, out_len);
    };

    Zlib.prototype._write = function(flush, input, in_off, in_len, out, out_off, out_len) {
      this.write_in_progress = true;

      if (flush !== Z_NO_FLUSH$1 &&
          flush !== Z_PARTIAL_FLUSH$1 &&
          flush !== Z_SYNC_FLUSH &&
          flush !== Z_FULL_FLUSH$1 &&
          flush !== Z_FINISH$2 &&
          flush !== Z_BLOCK$2) {
        throw new Error('Invalid flush value');
      }

      if (input == null) {
        input = new Buffer(0);
        in_len = 0;
        in_off = 0;
      }

      if (out._set)
        out.set = out._set;
      else
        out.set = bufferSet;

      var strm = this.strm;
      strm.avail_in = in_len;
      strm.input = input;
      strm.next_in = in_off;
      strm.avail_out = out_len;
      strm.output = out;
      strm.next_out = out_off;
      var status;
      switch (this.mode) {
      case DEFLATE:
      case GZIP:
      case DEFLATERAW:
        status = deflate(strm, flush);
        break;
      case UNZIP:
      case INFLATE:
      case GUNZIP:
      case INFLATERAW:
        status = inflate(strm, flush);
        break;
      default:
        throw new Error('Unknown mode ' + this.mode);
      }

      if (status !== Z_STREAM_END$2 && status !== Z_OK$2) {
        this._error(status);
      }

      this.write_in_progress = false;
      return [strm.avail_in, strm.avail_out];
    };

    Zlib.prototype.close = function() {
      if (this.write_in_progress) {
        this.pending_close = true;
        return;
      }

      this.pending_close = false;

      if (this.mode === DEFLATE || this.mode === GZIP || this.mode === DEFLATERAW) {
        deflateEnd(this.strm);
      } else {
        inflateEnd(this.strm);
      }

      this.mode = NONE;
    };
    var status;
    Zlib.prototype.reset = function() {
      switch (this.mode) {
      case DEFLATE:
      case DEFLATERAW:
        status = deflateReset(this.strm);
        break;
      case INFLATE:
      case INFLATERAW:
        status = inflateReset(this.strm);
        break;
      }

      if (status !== Z_OK$2) {
        this._error(status);
      }
    };

    Zlib.prototype._error = function(status) {
      this.onerror(msg[status] + ': ' + this.strm.msg, status);

      this.write_in_progress = false;
      if (this.pending_close)
        this.close();
    };

    var _binding = /*#__PURE__*/Object.freeze({
        __proto__: null,
        NONE: NONE,
        DEFLATE: DEFLATE,
        INFLATE: INFLATE,
        GZIP: GZIP,
        GUNZIP: GUNZIP,
        DEFLATERAW: DEFLATERAW,
        INFLATERAW: INFLATERAW,
        UNZIP: UNZIP,
        Z_NO_FLUSH: Z_NO_FLUSH$1,
        Z_PARTIAL_FLUSH: Z_PARTIAL_FLUSH$1,
        Z_SYNC_FLUSH: Z_SYNC_FLUSH,
        Z_FULL_FLUSH: Z_FULL_FLUSH$1,
        Z_FINISH: Z_FINISH$2,
        Z_BLOCK: Z_BLOCK$2,
        Z_TREES: Z_TREES$1,
        Z_OK: Z_OK$2,
        Z_STREAM_END: Z_STREAM_END$2,
        Z_NEED_DICT: Z_NEED_DICT$1,
        Z_ERRNO: Z_ERRNO,
        Z_STREAM_ERROR: Z_STREAM_ERROR$2,
        Z_DATA_ERROR: Z_DATA_ERROR$2,
        Z_BUF_ERROR: Z_BUF_ERROR$2,
        Z_NO_COMPRESSION: Z_NO_COMPRESSION,
        Z_BEST_SPEED: Z_BEST_SPEED,
        Z_BEST_COMPRESSION: Z_BEST_COMPRESSION,
        Z_DEFAULT_COMPRESSION: Z_DEFAULT_COMPRESSION$1,
        Z_FILTERED: Z_FILTERED$1,
        Z_HUFFMAN_ONLY: Z_HUFFMAN_ONLY$1,
        Z_RLE: Z_RLE$1,
        Z_FIXED: Z_FIXED$2,
        Z_DEFAULT_STRATEGY: Z_DEFAULT_STRATEGY,
        Z_BINARY: Z_BINARY$1,
        Z_TEXT: Z_TEXT$1,
        Z_UNKNOWN: Z_UNKNOWN$2,
        Z_DEFLATED: Z_DEFLATED$2,
        Zlib: Zlib
    });

    // Copyright Joyent, Inc. and other Node contributors.
    function assert (a, msg) {
      if (!a) {
        throw new Error(msg);
      }
    }
    var binding = {};
    Object.keys(_binding).forEach(function (key) {
      binding[key] = _binding[key];
    });
    // zlib doesn't provide these, so kludge them in following the same
    // const naming scheme zlib uses.
    binding.Z_MIN_WINDOWBITS = 8;
    binding.Z_MAX_WINDOWBITS = 15;
    binding.Z_DEFAULT_WINDOWBITS = 15;

    // fewer than 64 bytes per chunk is stupid.
    // technically it could work with as few as 8, but even 64 bytes
    // is absurdly low.  Usually a MB or more is best.
    binding.Z_MIN_CHUNK = 64;
    binding.Z_MAX_CHUNK = Infinity;
    binding.Z_DEFAULT_CHUNK = (16 * 1024);

    binding.Z_MIN_MEMLEVEL = 1;
    binding.Z_MAX_MEMLEVEL = 9;
    binding.Z_DEFAULT_MEMLEVEL = 8;

    binding.Z_MIN_LEVEL = -1;
    binding.Z_MAX_LEVEL = 9;
    binding.Z_DEFAULT_LEVEL = binding.Z_DEFAULT_COMPRESSION;


    // translation table for return codes.
    var codes = {
      Z_OK: binding.Z_OK,
      Z_STREAM_END: binding.Z_STREAM_END,
      Z_NEED_DICT: binding.Z_NEED_DICT,
      Z_ERRNO: binding.Z_ERRNO,
      Z_STREAM_ERROR: binding.Z_STREAM_ERROR,
      Z_DATA_ERROR: binding.Z_DATA_ERROR,
      Z_MEM_ERROR: binding.Z_MEM_ERROR,
      Z_BUF_ERROR: binding.Z_BUF_ERROR,
      Z_VERSION_ERROR: binding.Z_VERSION_ERROR
    };

    Object.keys(codes).forEach(function(k) {
      codes[codes[k]] = k;
    });

    function createDeflate(o) {
      return new Deflate(o);
    }

    function createInflate(o) {
      return new Inflate(o);
    }

    function createDeflateRaw(o) {
      return new DeflateRaw(o);
    }

    function createInflateRaw(o) {
      return new InflateRaw(o);
    }

    function createGzip(o) {
      return new Gzip(o);
    }

    function createGunzip(o) {
      return new Gunzip(o);
    }

    function createUnzip(o) {
      return new Unzip(o);
    }


    // Convenience methods.
    // compress/decompress a string or buffer in one step.
    function deflate$1(buffer, opts, callback) {
      if (typeof opts === 'function') {
        callback = opts;
        opts = {};
      }
      return zlibBuffer(new Deflate(opts), buffer, callback);
    }

    function deflateSync(buffer, opts) {
      return zlibBufferSync(new Deflate(opts), buffer);
    }

    function gzip(buffer, opts, callback) {
      if (typeof opts === 'function') {
        callback = opts;
        opts = {};
      }
      return zlibBuffer(new Gzip(opts), buffer, callback);
    }

    function gzipSync(buffer, opts) {
      return zlibBufferSync(new Gzip(opts), buffer);
    }

    function deflateRaw(buffer, opts, callback) {
      if (typeof opts === 'function') {
        callback = opts;
        opts = {};
      }
      return zlibBuffer(new DeflateRaw(opts), buffer, callback);
    }

    function deflateRawSync(buffer, opts) {
      return zlibBufferSync(new DeflateRaw(opts), buffer);
    }

    function unzip(buffer, opts, callback) {
      if (typeof opts === 'function') {
        callback = opts;
        opts = {};
      }
      return zlibBuffer(new Unzip(opts), buffer, callback);
    }

    function unzipSync(buffer, opts) {
      return zlibBufferSync(new Unzip(opts), buffer);
    }

    function inflate$1(buffer, opts, callback) {
      if (typeof opts === 'function') {
        callback = opts;
        opts = {};
      }
      return zlibBuffer(new Inflate(opts), buffer, callback);
    }

    function inflateSync(buffer, opts) {
      return zlibBufferSync(new Inflate(opts), buffer);
    }

    function gunzip(buffer, opts, callback) {
      if (typeof opts === 'function') {
        callback = opts;
        opts = {};
      }
      return zlibBuffer(new Gunzip(opts), buffer, callback);
    }

    function gunzipSync(buffer, opts) {
      return zlibBufferSync(new Gunzip(opts), buffer);
    }

    function inflateRaw(buffer, opts, callback) {
      if (typeof opts === 'function') {
        callback = opts;
        opts = {};
      }
      return zlibBuffer(new InflateRaw(opts), buffer, callback);
    }

    function inflateRawSync(buffer, opts) {
      return zlibBufferSync(new InflateRaw(opts), buffer);
    }

    function zlibBuffer(engine, buffer, callback) {
      var buffers = [];
      var nread = 0;

      engine.on('error', onError);
      engine.on('end', onEnd);

      engine.end(buffer);
      flow();

      function flow() {
        var chunk;
        while (null !== (chunk = engine.read())) {
          buffers.push(chunk);
          nread += chunk.length;
        }
        engine.once('readable', flow);
      }

      function onError(err) {
        engine.removeListener('end', onEnd);
        engine.removeListener('readable', flow);
        callback(err);
      }

      function onEnd() {
        var buf = Buffer.concat(buffers, nread);
        buffers = [];
        callback(null, buf);
        engine.close();
      }
    }

    function zlibBufferSync(engine, buffer) {
      if (typeof buffer === 'string')
        buffer = new Buffer(buffer);
      if (!Buffer.isBuffer(buffer))
        throw new TypeError('Not a string or buffer');

      var flushFlag = binding.Z_FINISH;

      return engine._processChunk(buffer, flushFlag);
    }

    // generic zlib
    // minimal 2-byte header
    function Deflate(opts) {
      if (!(this instanceof Deflate)) return new Deflate(opts);
      Zlib$1.call(this, opts, binding.DEFLATE);
    }

    function Inflate(opts) {
      if (!(this instanceof Inflate)) return new Inflate(opts);
      Zlib$1.call(this, opts, binding.INFLATE);
    }



    // gzip - bigger header, same deflate compression
    function Gzip(opts) {
      if (!(this instanceof Gzip)) return new Gzip(opts);
      Zlib$1.call(this, opts, binding.GZIP);
    }

    function Gunzip(opts) {
      if (!(this instanceof Gunzip)) return new Gunzip(opts);
      Zlib$1.call(this, opts, binding.GUNZIP);
    }



    // raw - no header
    function DeflateRaw(opts) {
      if (!(this instanceof DeflateRaw)) return new DeflateRaw(opts);
      Zlib$1.call(this, opts, binding.DEFLATERAW);
    }

    function InflateRaw(opts) {
      if (!(this instanceof InflateRaw)) return new InflateRaw(opts);
      Zlib$1.call(this, opts, binding.INFLATERAW);
    }


    // auto-detect header.
    function Unzip(opts) {
      if (!(this instanceof Unzip)) return new Unzip(opts);
      Zlib$1.call(this, opts, binding.UNZIP);
    }


    // the Zlib class they all inherit from
    // This thing manages the queue of requests, and returns
    // true or false if there is anything in the queue when
    // you call the .write() method.

    function Zlib$1(opts, mode) {
      this._opts = opts = opts || {};
      this._chunkSize = opts.chunkSize || binding.Z_DEFAULT_CHUNK;

      Transform.call(this, opts);

      if (opts.flush) {
        if (opts.flush !== binding.Z_NO_FLUSH &&
            opts.flush !== binding.Z_PARTIAL_FLUSH &&
            opts.flush !== binding.Z_SYNC_FLUSH &&
            opts.flush !== binding.Z_FULL_FLUSH &&
            opts.flush !== binding.Z_FINISH &&
            opts.flush !== binding.Z_BLOCK) {
          throw new Error('Invalid flush flag: ' + opts.flush);
        }
      }
      this._flushFlag = opts.flush || binding.Z_NO_FLUSH;

      if (opts.chunkSize) {
        if (opts.chunkSize < binding.Z_MIN_CHUNK ||
            opts.chunkSize > binding.Z_MAX_CHUNK) {
          throw new Error('Invalid chunk size: ' + opts.chunkSize);
        }
      }

      if (opts.windowBits) {
        if (opts.windowBits < binding.Z_MIN_WINDOWBITS ||
            opts.windowBits > binding.Z_MAX_WINDOWBITS) {
          throw new Error('Invalid windowBits: ' + opts.windowBits);
        }
      }

      if (opts.level) {
        if (opts.level < binding.Z_MIN_LEVEL ||
            opts.level > binding.Z_MAX_LEVEL) {
          throw new Error('Invalid compression level: ' + opts.level);
        }
      }

      if (opts.memLevel) {
        if (opts.memLevel < binding.Z_MIN_MEMLEVEL ||
            opts.memLevel > binding.Z_MAX_MEMLEVEL) {
          throw new Error('Invalid memLevel: ' + opts.memLevel);
        }
      }

      if (opts.strategy) {
        if (opts.strategy != binding.Z_FILTERED &&
            opts.strategy != binding.Z_HUFFMAN_ONLY &&
            opts.strategy != binding.Z_RLE &&
            opts.strategy != binding.Z_FIXED &&
            opts.strategy != binding.Z_DEFAULT_STRATEGY) {
          throw new Error('Invalid strategy: ' + opts.strategy);
        }
      }

      if (opts.dictionary) {
        if (!Buffer.isBuffer(opts.dictionary)) {
          throw new Error('Invalid dictionary: it should be a Buffer instance');
        }
      }

      this._binding = new binding.Zlib(mode);

      var self = this;
      this._hadError = false;
      this._binding.onerror = function(message, errno) {
        // there is no way to cleanly recover.
        // continuing only obscures problems.
        self._binding = null;
        self._hadError = true;

        var error = new Error(message);
        error.errno = errno;
        error.code = binding.codes[errno];
        self.emit('error', error);
      };

      var level = binding.Z_DEFAULT_COMPRESSION;
      if (typeof opts.level === 'number') level = opts.level;

      var strategy = binding.Z_DEFAULT_STRATEGY;
      if (typeof opts.strategy === 'number') strategy = opts.strategy;

      this._binding.init(opts.windowBits || binding.Z_DEFAULT_WINDOWBITS,
                         level,
                         opts.memLevel || binding.Z_DEFAULT_MEMLEVEL,
                         strategy,
                         opts.dictionary);

      this._buffer = new Buffer(this._chunkSize);
      this._offset = 0;
      this._closed = false;
      this._level = level;
      this._strategy = strategy;

      this.once('end', this.close);
    }

    inherits$1(Zlib$1, Transform);

    Zlib$1.prototype.params = function(level, strategy, callback) {
      if (level < binding.Z_MIN_LEVEL ||
          level > binding.Z_MAX_LEVEL) {
        throw new RangeError('Invalid compression level: ' + level);
      }
      if (strategy != binding.Z_FILTERED &&
          strategy != binding.Z_HUFFMAN_ONLY &&
          strategy != binding.Z_RLE &&
          strategy != binding.Z_FIXED &&
          strategy != binding.Z_DEFAULT_STRATEGY) {
        throw new TypeError('Invalid strategy: ' + strategy);
      }

      if (this._level !== level || this._strategy !== strategy) {
        var self = this;
        this.flush(binding.Z_SYNC_FLUSH, function() {
          self._binding.params(level, strategy);
          if (!self._hadError) {
            self._level = level;
            self._strategy = strategy;
            if (callback) callback();
          }
        });
      } else {
        process.nextTick(callback);
      }
    };

    Zlib$1.prototype.reset = function() {
      return this._binding.reset();
    };

    // This is the _flush function called by the transform class,
    // internally, when the last chunk has been written.
    Zlib$1.prototype._flush = function(callback) {
      this._transform(new Buffer(0), '', callback);
    };

    Zlib$1.prototype.flush = function(kind, callback) {
      var ws = this._writableState;

      if (typeof kind === 'function' || (kind === void 0 && !callback)) {
        callback = kind;
        kind = binding.Z_FULL_FLUSH;
      }

      if (ws.ended) {
        if (callback)
          process.nextTick(callback);
      } else if (ws.ending) {
        if (callback)
          this.once('end', callback);
      } else if (ws.needDrain) {
        var self = this;
        this.once('drain', function() {
          self.flush(callback);
        });
      } else {
        this._flushFlag = kind;
        this.write(new Buffer(0), '', callback);
      }
    };

    Zlib$1.prototype.close = function(callback) {
      if (callback)
        process.nextTick(callback);

      if (this._closed)
        return;

      this._closed = true;

      this._binding.close();

      var self = this;
      process.nextTick(function() {
        self.emit('close');
      });
    };

    Zlib$1.prototype._transform = function(chunk, encoding, cb) {
      var flushFlag;
      var ws = this._writableState;
      var ending = ws.ending || ws.ended;
      var last = ending && (!chunk || ws.length === chunk.length);

      if (!chunk === null && !Buffer.isBuffer(chunk))
        return cb(new Error('invalid input'));

      // If it's the last chunk, or a final flush, we use the Z_FINISH flush flag.
      // If it's explicitly flushing at some other time, then we use
      // Z_FULL_FLUSH. Otherwise, use Z_NO_FLUSH for maximum compression
      // goodness.
      if (last)
        flushFlag = binding.Z_FINISH;
      else {
        flushFlag = this._flushFlag;
        // once we've flushed the last of the queue, stop flushing and
        // go back to the normal behavior.
        if (chunk.length >= ws.length) {
          this._flushFlag = this._opts.flush || binding.Z_NO_FLUSH;
        }
      }

      this._processChunk(chunk, flushFlag, cb);
    };

    Zlib$1.prototype._processChunk = function(chunk, flushFlag, cb) {
      var availInBefore = chunk && chunk.length;
      var availOutBefore = this._chunkSize - this._offset;
      var inOff = 0;

      var self = this;

      var async = typeof cb === 'function';

      if (!async) {
        var buffers = [];
        var nread = 0;

        var error;
        this.on('error', function(er) {
          error = er;
        });

        do {
          var res = this._binding.writeSync(flushFlag,
                                            chunk, // in
                                            inOff, // in_off
                                            availInBefore, // in_len
                                            this._buffer, // out
                                            this._offset, //out_off
                                            availOutBefore); // out_len
        } while (!this._hadError && callback(res[0], res[1]));

        if (this._hadError) {
          throw error;
        }

        var buf = Buffer.concat(buffers, nread);
        this.close();

        return buf;
      }

      var req = this._binding.write(flushFlag,
                                    chunk, // in
                                    inOff, // in_off
                                    availInBefore, // in_len
                                    this._buffer, // out
                                    this._offset, //out_off
                                    availOutBefore); // out_len

      req.buffer = chunk;
      req.callback = callback;

      function callback(availInAfter, availOutAfter) {
        if (self._hadError)
          return;

        var have = availOutBefore - availOutAfter;
        assert(have >= 0, 'have should not go down');

        if (have > 0) {
          var out = self._buffer.slice(self._offset, self._offset + have);
          self._offset += have;
          // serve some output to the consumer.
          if (async) {
            self.push(out);
          } else {
            buffers.push(out);
            nread += out.length;
          }
        }

        // exhausted the output buffer, or used all the input create a new one.
        if (availOutAfter === 0 || self._offset >= self._chunkSize) {
          availOutBefore = self._chunkSize;
          self._offset = 0;
          self._buffer = new Buffer(self._chunkSize);
        }

        if (availOutAfter === 0) {
          // Not actually done.  Need to reprocess.
          // Also, update the availInBefore to the availInAfter value,
          // so that if we have to hit it a third (fourth, etc.) time,
          // it'll have the correct byte counts.
          inOff += (availInBefore - availInAfter);
          availInBefore = availInAfter;

          if (!async)
            return true;

          var newReq = self._binding.write(flushFlag,
                                           chunk,
                                           inOff,
                                           availInBefore,
                                           self._buffer,
                                           self._offset,
                                           self._chunkSize);
          newReq.callback = callback; // this same function
          newReq.buffer = chunk;
          return;
        }

        if (!async)
          return false;

        // finished with the chunk.
        cb();
      }
    };

    inherits$1(Deflate, Zlib$1);
    inherits$1(Inflate, Zlib$1);
    inherits$1(Gzip, Zlib$1);
    inherits$1(Gunzip, Zlib$1);
    inherits$1(DeflateRaw, Zlib$1);
    inherits$1(InflateRaw, Zlib$1);
    inherits$1(Unzip, Zlib$1);
    var zlib = {
      codes: codes,
      createDeflate: createDeflate,
      createInflate: createInflate,
      createDeflateRaw: createDeflateRaw,
      createInflateRaw: createInflateRaw,
      createGzip: createGzip,
      createGunzip: createGunzip,
      createUnzip: createUnzip,
      deflate: deflate$1,
      deflateSync: deflateSync,
      gzip: gzip,
      gzipSync: gzipSync,
      deflateRaw: deflateRaw,
      deflateRawSync: deflateRawSync,
      unzip: unzip,
      unzipSync: unzipSync,
      inflate: inflate$1,
      inflateSync: inflateSync,
      gunzip: gunzip,
      gunzipSync: gunzipSync,
      inflateRaw: inflateRaw,
      inflateRawSync: inflateRawSync,
      Deflate: Deflate,
      Inflate: Inflate,
      Gzip: Gzip,
      Gunzip: Gunzip,
      DeflateRaw: DeflateRaw,
      InflateRaw: InflateRaw,
      Unzip: Unzip,
      Zlib: Zlib$1
    };

    var BufferUtil = createCommonjsModule(function (module) {



    const Buffer = safeBuffer$2.Buffer;

    /**
     * Merges an array of buffers into a new buffer.
     *
     * @param {Buffer[]} list The array of buffers to concat
     * @param {Number} totalLength The total length of buffers in the list
     * @return {Buffer} The resulting buffer
     * @public
     */
    const concat = (list, totalLength) => {
      const target = Buffer.allocUnsafe(totalLength);
      var offset = 0;

      for (var i = 0; i < list.length; i++) {
        const buf = list[i];
        buf.copy(target, offset);
        offset += buf.length;
      }

      return target;
    };

    try {
      const bufferUtil = bufferutil;

      module.exports = Object.assign({ concat }, bufferUtil.BufferUtil || bufferUtil);
    } catch (e) /* istanbul ignore next */ {
      /**
       * Masks a buffer using the given mask.
       *
       * @param {Buffer} source The buffer to mask
       * @param {Buffer} mask The mask to use
       * @param {Buffer} output The buffer where to store the result
       * @param {Number} offset The offset at which to start writing
       * @param {Number} length The number of bytes to mask.
       * @public
       */
      const mask = (source, mask, output, offset, length) => {
        for (var i = 0; i < length; i++) {
          output[offset + i] = source[i] ^ mask[i & 3];
        }
      };

      /**
       * Unmasks a buffer using the given mask.
       *
       * @param {Buffer} buffer The buffer to unmask
       * @param {Buffer} mask The mask to use
       * @public
       */
      const unmask = (buffer, mask) => {
        // Required until https://github.com/nodejs/node/issues/9006 is resolved.
        const length = buffer.length;
        for (var i = 0; i < length; i++) {
          buffer[i] ^= mask[i & 3];
        }
      };

      module.exports = { concat, mask, unmask };
    }
    });
    var BufferUtil_1 = BufferUtil.concat;
    var BufferUtil_2 = BufferUtil.mask;
    var BufferUtil_3 = BufferUtil.unmask;

    const Buffer$9 = safeBuffer$2.Buffer;

    const TRAILER = Buffer$9.from([0x00, 0x00, 0xff, 0xff]);
    const EMPTY_BLOCK = Buffer$9.from([0x00]);

    const kWriteInProgress = Symbol('write-in-progress');
    const kPendingClose = Symbol('pending-close');
    const kTotalLength = Symbol('total-length');
    const kCallback = Symbol('callback');
    const kBuffers = Symbol('buffers');
    const kError = Symbol('error');
    const kOwner = Symbol('owner');

    //
    // We limit zlib concurrency, which prevents severe memory fragmentation
    // as documented in https://github.com/nodejs/node/issues/8871#issuecomment-250915913
    // and https://github.com/websockets/ws/issues/1202
    //
    // Intentionally global; it's the global thread pool that's an issue.
    //
    let zlibLimiter;

    /**
     * permessage-deflate implementation.
     */
    class PerMessageDeflate {
      /**
       * Creates a PerMessageDeflate instance.
       *
       * @param {Object} options Configuration options
       * @param {Boolean} options.serverNoContextTakeover Request/accept disabling
       *     of server context takeover
       * @param {Boolean} options.clientNoContextTakeover Advertise/acknowledge
       *     disabling of client context takeover
       * @param {(Boolean|Number)} options.serverMaxWindowBits Request/confirm the
       *     use of a custom server window size
       * @param {(Boolean|Number)} options.clientMaxWindowBits Advertise support
       *     for, or request, a custom client window size
       * @param {Number} options.level The value of zlib's `level` param
       * @param {Number} options.memLevel The value of zlib's `memLevel` param
       * @param {Number} options.threshold Size (in bytes) below which messages
       *     should not be compressed
       * @param {Number} options.concurrencyLimit The number of concurrent calls to
       *     zlib
       * @param {Boolean} isServer Create the instance in either server or client
       *     mode
       * @param {Number} maxPayload The maximum allowed message length
       */
      constructor (options, isServer, maxPayload) {
        this._maxPayload = maxPayload | 0;
        this._options = options || {};
        this._threshold = this._options.threshold !== undefined
          ? this._options.threshold
          : 1024;
        this._isServer = !!isServer;
        this._deflate = null;
        this._inflate = null;

        this.params = null;

        if (!zlibLimiter) {
          const concurrency = this._options.concurrencyLimit !== undefined
            ? this._options.concurrencyLimit
            : 10;
          zlibLimiter = new asyncLimiter({ concurrency });
        }
      }

      /**
       * @type {String}
       */
      static get extensionName () {
        return 'permessage-deflate';
      }

      /**
       * Create extension parameters offer.
       *
       * @return {Object} Extension parameters
       * @public
       */
      offer () {
        const params = {};

        if (this._options.serverNoContextTakeover) {
          params.server_no_context_takeover = true;
        }
        if (this._options.clientNoContextTakeover) {
          params.client_no_context_takeover = true;
        }
        if (this._options.serverMaxWindowBits) {
          params.server_max_window_bits = this._options.serverMaxWindowBits;
        }
        if (this._options.clientMaxWindowBits) {
          params.client_max_window_bits = this._options.clientMaxWindowBits;
        } else if (this._options.clientMaxWindowBits == null) {
          params.client_max_window_bits = true;
        }

        return params;
      }

      /**
       * Accept extension offer.
       *
       * @param {Array} paramsList Extension parameters
       * @return {Object} Accepted configuration
       * @public
       */
      accept (paramsList) {
        paramsList = this.normalizeParams(paramsList);

        var params;
        if (this._isServer) {
          params = this.acceptAsServer(paramsList);
        } else {
          params = this.acceptAsClient(paramsList);
        }

        this.params = params;
        return params;
      }

      /**
       * Releases all resources used by the extension.
       *
       * @public
       */
      cleanup () {
        if (this._inflate) {
          if (this._inflate[kWriteInProgress]) {
            this._inflate[kPendingClose] = true;
          } else {
            this._inflate.close();
            this._inflate = null;
          }
        }
        if (this._deflate) {
          if (this._deflate[kWriteInProgress]) {
            this._deflate[kPendingClose] = true;
          } else {
            this._deflate.close();
            this._deflate = null;
          }
        }
      }

      /**
       * Accept extension offer from client.
       *
       * @param {Array} paramsList Extension parameters
       * @return {Object} Accepted configuration
       * @private
       */
      acceptAsServer (paramsList) {
        const accepted = {};
        const result = paramsList.some((params) => {
          if (
            (this._options.serverNoContextTakeover === false &&
              params.server_no_context_takeover) ||
            (this._options.serverMaxWindowBits === false &&
              params.server_max_window_bits) ||
            (typeof this._options.serverMaxWindowBits === 'number' &&
              typeof params.server_max_window_bits === 'number' &&
              this._options.serverMaxWindowBits > params.server_max_window_bits) ||
            (typeof this._options.clientMaxWindowBits === 'number' &&
              !params.client_max_window_bits)
          ) {
            return;
          }

          if (
            this._options.serverNoContextTakeover ||
            params.server_no_context_takeover
          ) {
            accepted.server_no_context_takeover = true;
          }
          if (
            this._options.clientNoContextTakeover ||
            (this._options.clientNoContextTakeover !== false &&
              params.client_no_context_takeover)
          ) {
            accepted.client_no_context_takeover = true;
          }
          if (typeof this._options.serverMaxWindowBits === 'number') {
            accepted.server_max_window_bits = this._options.serverMaxWindowBits;
          } else if (typeof params.server_max_window_bits === 'number') {
            accepted.server_max_window_bits = params.server_max_window_bits;
          }
          if (typeof this._options.clientMaxWindowBits === 'number') {
            accepted.client_max_window_bits = this._options.clientMaxWindowBits;
          } else if (
            this._options.clientMaxWindowBits !== false &&
            typeof params.client_max_window_bits === 'number'
          ) {
            accepted.client_max_window_bits = params.client_max_window_bits;
          }
          return true;
        });

        if (!result) throw new Error("Doesn't support the offered configuration");

        return accepted;
      }

      /**
       * Accept extension response from server.
       *
       * @param {Array} paramsList Extension parameters
       * @return {Object} Accepted configuration
       * @private
       */
      acceptAsClient (paramsList) {
        const params = paramsList[0];

        if (
          this._options.clientNoContextTakeover === false &&
          params.client_no_context_takeover
        ) {
          throw new Error('Invalid value for "client_no_context_takeover"');
        }

        if (
          (typeof this._options.clientMaxWindowBits === 'number' &&
            (!params.client_max_window_bits ||
              params.client_max_window_bits > this._options.clientMaxWindowBits)) ||
          (this._options.clientMaxWindowBits === false &&
            params.client_max_window_bits)
        ) {
          throw new Error('Invalid value for "client_max_window_bits"');
        }

        return params;
      }

      /**
       * Normalize extensions parameters.
       *
       * @param {Array} paramsList Extension parameters
       * @return {Array} Normalized extensions parameters
       * @private
       */
      normalizeParams (paramsList) {
        return paramsList.map((params) => {
          Object.keys(params).forEach((key) => {
            var value = params[key];
            if (value.length > 1) {
              throw new Error(`Multiple extension parameters for ${key}`);
            }

            value = value[0];

            switch (key) {
              case 'server_no_context_takeover':
              case 'client_no_context_takeover':
                if (value !== true) {
                  throw new Error(`invalid extension parameter value for ${key} (${value})`);
                }
                params[key] = true;
                break;
              case 'server_max_window_bits':
              case 'client_max_window_bits':
                if (typeof value === 'string') {
                  value = parseInt(value, 10);
                  if (
                    Number.isNaN(value) ||
                    value < zlib.Z_MIN_WINDOWBITS ||
                    value > zlib.Z_MAX_WINDOWBITS
                  ) {
                    throw new Error(`invalid extension parameter value for ${key} (${value})`);
                  }
                }
                if (!this._isServer && value === true) {
                  throw new Error(`Missing extension parameter value for ${key}`);
                }
                params[key] = value;
                break;
              default:
                throw new Error(`Not defined extension parameter (${key})`);
            }
          });
          return params;
        });
      }

      /**
       * Decompress data. Concurrency limited by async-limiter.
       *
       * @param {Buffer} data Compressed data
       * @param {Boolean} fin Specifies whether or not this is the last fragment
       * @param {Function} callback Callback
       * @public
       */
      decompress (data, fin, callback) {
        zlibLimiter.push((done) => {
          this._decompress(data, fin, (err, result) => {
            done();
            callback(err, result);
          });
        });
      }

      /**
       * Compress data. Concurrency limited by async-limiter.
       *
       * @param {Buffer} data Data to compress
       * @param {Boolean} fin Specifies whether or not this is the last fragment
       * @param {Function} callback Callback
       * @public
       */
      compress (data, fin, callback) {
        zlibLimiter.push((done) => {
          this._compress(data, fin, (err, result) => {
            done();
            callback(err, result);
          });
        });
      }

      /**
       * Decompress data.
       *
       * @param {Buffer} data Compressed data
       * @param {Boolean} fin Specifies whether or not this is the last fragment
       * @param {Function} callback Callback
       * @private
       */
      _decompress (data, fin, callback) {
        const endpoint = this._isServer ? 'client' : 'server';

        if (!this._inflate) {
          const key = `${endpoint}_max_window_bits`;
          const windowBits = typeof this.params[key] !== 'number'
            ? zlib.Z_DEFAULT_WINDOWBITS
            : this.params[key];

          this._inflate = zlib.createInflateRaw({ windowBits });
          this._inflate[kTotalLength] = 0;
          this._inflate[kBuffers] = [];
          this._inflate[kOwner] = this;
          this._inflate.on('error', inflateOnError);
          this._inflate.on('data', inflateOnData);
        }

        this._inflate[kCallback] = callback;
        this._inflate[kWriteInProgress] = true;

        this._inflate.write(data);
        if (fin) this._inflate.write(TRAILER);

        this._inflate.flush(() => {
          const err = this._inflate[kError];

          if (err) {
            this._inflate.close();
            this._inflate = null;
            callback(err);
            return;
          }

          const data = BufferUtil.concat(
            this._inflate[kBuffers],
            this._inflate[kTotalLength]
          );

          if (
            (fin && this.params[`${endpoint}_no_context_takeover`]) ||
            this._inflate[kPendingClose]
          ) {
            this._inflate.close();
            this._inflate = null;
          } else {
            this._inflate[kWriteInProgress] = false;
            this._inflate[kTotalLength] = 0;
            this._inflate[kBuffers] = [];
          }

          callback(null, data);
        });
      }

      /**
       * Compress data.
       *
       * @param {Buffer} data Data to compress
       * @param {Boolean} fin Specifies whether or not this is the last fragment
       * @param {Function} callback Callback
       * @private
       */
      _compress (data, fin, callback) {
        if (!data || data.length === 0) {
          process.nextTick(callback, null, EMPTY_BLOCK);
          return;
        }

        const endpoint = this._isServer ? 'server' : 'client';

        if (!this._deflate) {
          const key = `${endpoint}_max_window_bits`;
          const windowBits = typeof this.params[key] !== 'number'
            ? zlib.Z_DEFAULT_WINDOWBITS
            : this.params[key];

          this._deflate = zlib.createDeflateRaw({
            memLevel: this._options.memLevel,
            level: this._options.level,
            flush: zlib.Z_SYNC_FLUSH,
            windowBits
          });

          this._deflate[kTotalLength] = 0;
          this._deflate[kBuffers] = [];

          //
          // `zlib.DeflateRaw` emits an `'error'` event only when an attempt to use
          // it is made after it has already been closed. This cannot happen here,
          // so we only add a listener for the `'data'` event.
          //
          this._deflate.on('data', deflateOnData);
        }

        this._deflate[kWriteInProgress] = true;

        this._deflate.write(data);
        this._deflate.flush(zlib.Z_SYNC_FLUSH, () => {
          var data = BufferUtil.concat(
            this._deflate[kBuffers],
            this._deflate[kTotalLength]
          );

          if (fin) data = data.slice(0, data.length - 4);

          if (
            (fin && this.params[`${endpoint}_no_context_takeover`]) ||
            this._deflate[kPendingClose]
          ) {
            this._deflate.close();
            this._deflate = null;
          } else {
            this._deflate[kWriteInProgress] = false;
            this._deflate[kTotalLength] = 0;
            this._deflate[kBuffers] = [];
          }

          callback(null, data);
        });
      }
    }

    var PerMessageDeflate_1 = PerMessageDeflate;

    /**
     * The listener of the `zlib.DeflateRaw` stream `'data'` event.
     *
     * @param {Buffer} chunk A chunk of data
     * @private
     */
    function deflateOnData (chunk) {
      this[kBuffers].push(chunk);
      this[kTotalLength] += chunk.length;
    }

    /**
     * The listener of the `zlib.InflateRaw` stream `'data'` event.
     *
     * @param {Buffer} chunk A chunk of data
     * @private
     */
    function inflateOnData (chunk) {
      this[kTotalLength] += chunk.length;

      if (
        this[kOwner]._maxPayload < 1 ||
        this[kTotalLength] <= this[kOwner]._maxPayload
      ) {
        this[kBuffers].push(chunk);
        return;
      }

      this[kError] = new Error('max payload size exceeded');
      this[kError].closeCode = 1009;
      this.removeListener('data', inflateOnData);
      this.reset();
    }

    /**
     * The listener of the `zlib.InflateRaw` stream `'error'` event.
     *
     * @param {Error} err The emitted error
     * @private
     */
    function inflateOnError (err) {
      //
      // There is no need to call `Zlib#close()` as the handle is automatically
      // closed when an error is emitted.
      //
      this[kOwner]._inflate = null;
      this[kCallback](err);
    }

    /**
     * Class representing an event.
     *
     * @private
     */
    class Event {
      /**
       * Create a new `Event`.
       *
       * @param {String} type The name of the event
       * @param {Object} target A reference to the target to which the event was dispatched
       */
      constructor (type, target) {
        this.target = target;
        this.type = type;
      }
    }

    /**
     * Class representing a message event.
     *
     * @extends Event
     * @private
     */
    class MessageEvent extends Event {
      /**
       * Create a new `MessageEvent`.
       *
       * @param {(String|Buffer|ArrayBuffer|Buffer[])} data The received data
       * @param {WebSocket} target A reference to the target to which the event was dispatched
       */
      constructor (data, target) {
        super('message', target);

        this.data = data;
      }
    }

    /**
     * Class representing a close event.
     *
     * @extends Event
     * @private
     */
    class CloseEvent extends Event {
      /**
       * Create a new `CloseEvent`.
       *
       * @param {Number} code The status code explaining why the connection is being closed
       * @param {String} reason A human-readable string explaining why the connection is closing
       * @param {WebSocket} target A reference to the target to which the event was dispatched
       */
      constructor (code, reason, target) {
        super('close', target);

        this.wasClean = target._closeFrameReceived && target._closeFrameSent;
        this.reason = reason;
        this.code = code;
      }
    }

    /**
     * Class representing an open event.
     *
     * @extends Event
     * @private
     */
    class OpenEvent extends Event {
      /**
       * Create a new `OpenEvent`.
       *
       * @param {WebSocket} target A reference to the target to which the event was dispatched
       */
      constructor (target) {
        super('open', target);
      }
    }

    /**
     * This provides methods for emulating the `EventTarget` interface. It's not
     * meant to be used directly.
     *
     * @mixin
     */
    const EventTarget = {
      /**
       * Register an event listener.
       *
       * @param {String} method A string representing the event type to listen for
       * @param {Function} listener The listener to add
       * @public
       */
      addEventListener (method, listener) {
        if (typeof listener !== 'function') return;

        function onMessage (data) {
          listener.call(this, new MessageEvent(data, this));
        }

        function onClose (code, message) {
          listener.call(this, new CloseEvent(code, message, this));
        }

        function onError (event) {
          event.type = 'error';
          event.target = this;
          listener.call(this, event);
        }

        function onOpen () {
          listener.call(this, new OpenEvent(this));
        }

        if (method === 'message') {
          onMessage._listener = listener;
          this.on(method, onMessage);
        } else if (method === 'close') {
          onClose._listener = listener;
          this.on(method, onClose);
        } else if (method === 'error') {
          onError._listener = listener;
          this.on(method, onError);
        } else if (method === 'open') {
          onOpen._listener = listener;
          this.on(method, onOpen);
        } else {
          this.on(method, listener);
        }
      },

      /**
       * Remove an event listener.
       *
       * @param {String} method A string representing the event type to remove
       * @param {Function} listener The listener to remove
       * @public
       */
      removeEventListener (method, listener) {
        const listeners = this.listeners(method);

        for (var i = 0; i < listeners.length; i++) {
          if (listeners[i] === listener || listeners[i]._listener === listener) {
            this.removeListener(method, listeners[i]);
          }
        }
      }
    };

    var EventTarget_1 = EventTarget;

    //
    // Allowed token characters:
    //
    // '!', '#', '$', '%', '&', ''', '*', '+', '-',
    // '.', 0-9, A-Z, '^', '_', '`', a-z, '|', '~'
    //
    // tokenChars[32] === 0 // ' '
    // tokenChars[33] === 1 // '!'
    // tokenChars[34] === 0 // '"'
    // ...
    //
    const tokenChars = [
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, // 0 - 15
      0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, // 16 - 31
      0, 1, 0, 1, 1, 1, 1, 1, 0, 0, 1, 1, 0, 1, 1, 0, // 32 - 47
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, // 48 - 63
      0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, // 64 - 79
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 1, 1, // 80 - 95
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, // 96 - 111
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 0, 1, 0 // 112 - 127
    ];

    /**
     * Adds an offer to the map of extension offers or a parameter to the map of
     * parameters.
     *
     * @param {Object} dest The map of extension offers or parameters
     * @param {String} name The extension or parameter name
     * @param {(Object|Boolean|String)} elem The extension parameters or the
     *     parameter value
     * @private
     */
    function push (dest, name, elem) {
      if (Object.prototype.hasOwnProperty.call(dest, name)) dest[name].push(elem);
      else dest[name] = [elem];
    }

    /**
     * Parses the `Sec-WebSocket-Extensions` header into an object.
     *
     * @param {String} header The field value of the header
     * @return {Object} The parsed object
     * @public
     */
    function parse$3 (header) {
      const offers = {};

      if (header === undefined || header === '') return offers;

      var params = {};
      var mustUnescape = false;
      var isEscaping = false;
      var inQuotes = false;
      var extensionName;
      var paramName;
      var start = -1;
      var end = -1;

      for (var i = 0; i < header.length; i++) {
        const code = header.charCodeAt(i);

        if (extensionName === undefined) {
          if (end === -1 && tokenChars[code] === 1) {
            if (start === -1) start = i;
          } else if (code === 0x20/* ' ' */|| code === 0x09/* '\t' */) {
            if (end === -1 && start !== -1) end = i;
          } else if (code === 0x3b/* ';' */ || code === 0x2c/* ',' */) {
            if (start === -1) throw new Error(`unexpected character at index ${i}`);

            if (end === -1) end = i;
            const name = header.slice(start, end);
            if (code === 0x2c) {
              push(offers, name, params);
              params = {};
            } else {
              extensionName = name;
            }

            start = end = -1;
          } else {
            throw new Error(`unexpected character at index ${i}`);
          }
        } else if (paramName === undefined) {
          if (end === -1 && tokenChars[code] === 1) {
            if (start === -1) start = i;
          } else if (code === 0x20 || code === 0x09) {
            if (end === -1 && start !== -1) end = i;
          } else if (code === 0x3b || code === 0x2c) {
            if (start === -1) throw new Error(`unexpected character at index ${i}`);

            if (end === -1) end = i;
            push(params, header.slice(start, end), true);
            if (code === 0x2c) {
              push(offers, extensionName, params);
              params = {};
              extensionName = undefined;
            }

            start = end = -1;
          } else if (code === 0x3d/* '=' */&& start !== -1 && end === -1) {
            paramName = header.slice(start, i);
            start = end = -1;
          } else {
            throw new Error(`unexpected character at index ${i}`);
          }
        } else {
          //
          // The value of a quoted-string after unescaping must conform to the
          // token ABNF, so only token characters are valid.
          // Ref: https://tools.ietf.org/html/rfc6455#section-9.1
          //
          if (isEscaping) {
            if (tokenChars[code] !== 1) {
              throw new Error(`unexpected character at index ${i}`);
            }
            if (start === -1) start = i;
            else if (!mustUnescape) mustUnescape = true;
            isEscaping = false;
          } else if (inQuotes) {
            if (tokenChars[code] === 1) {
              if (start === -1) start = i;
            } else if (code === 0x22/* '"' */ && start !== -1) {
              inQuotes = false;
              end = i;
            } else if (code === 0x5c/* '\' */) {
              isEscaping = true;
            } else {
              throw new Error(`unexpected character at index ${i}`);
            }
          } else if (code === 0x22 && header.charCodeAt(i - 1) === 0x3d) {
            inQuotes = true;
          } else if (end === -1 && tokenChars[code] === 1) {
            if (start === -1) start = i;
          } else if (start !== -1 && (code === 0x20 || code === 0x09)) {
            if (end === -1) end = i;
          } else if (code === 0x3b || code === 0x2c) {
            if (start === -1) throw new Error(`unexpected character at index ${i}`);

            if (end === -1) end = i;
            var value = header.slice(start, end);
            if (mustUnescape) {
              value = value.replace(/\\/g, '');
              mustUnescape = false;
            }
            push(params, paramName, value);
            if (code === 0x2c) {
              push(offers, extensionName, params);
              params = {};
              extensionName = undefined;
            }

            paramName = undefined;
            start = end = -1;
          } else {
            throw new Error(`unexpected character at index ${i}`);
          }
        }
      }

      if (start === -1 || inQuotes) throw new Error('unexpected end of input');

      if (end === -1) end = i;
      const token = header.slice(start, end);
      if (extensionName === undefined) {
        push(offers, token, {});
      } else {
        if (paramName === undefined) {
          push(params, token, true);
        } else if (mustUnescape) {
          push(params, paramName, token.replace(/\\/g, ''));
        } else {
          push(params, paramName, token);
        }
        push(offers, extensionName, params);
      }

      return offers;
    }

    /**
     * Serializes a parsed `Sec-WebSocket-Extensions` header to a string.
     *
     * @param {Object} value The object to format
     * @return {String} A string representing the given value
     * @public
     */
    function format$2 (value) {
      return Object.keys(value).map((token) => {
        var paramsList = value[token];
        if (!Array.isArray(paramsList)) paramsList = [paramsList];
        return paramsList.map((params) => {
          return [token].concat(Object.keys(params).map((k) => {
            var p = params[k];
            if (!Array.isArray(p)) p = [p];
            return p.map((v) => v === true ? k : `${k}=${v}`).join('; ');
          })).join('; ');
        }).join(', ');
      }).join(', ');
    }

    var Extensions = { format: format$2, parse: parse$3 };

    const Buffer$a = safeBuffer$2.Buffer;

    var BINARY_TYPES = ['nodebuffer', 'arraybuffer', 'fragments'];
    var GUID = '258EAFA5-E914-47DA-95CA-C5AB0DC85B11';
    var EMPTY_BUFFER = Buffer$a.alloc(0);
    var NOOP = () => {};

    var Constants = {
    	BINARY_TYPES: BINARY_TYPES,
    	GUID: GUID,
    	EMPTY_BUFFER: EMPTY_BUFFER,
    	NOOP: NOOP
    };

    var Validation = createCommonjsModule(function (module) {

    try {
      const isValidUTF8 = utf8Validate;

      module.exports = typeof isValidUTF8 === 'object'
        ? isValidUTF8.Validation.isValidUTF8 // utf-8-validate@<3.0.0
        : isValidUTF8;
    } catch (e) /* istanbul ignore next */ {
      module.exports = () => true;
    }
    });

    /*!
     * ws: a node.js websocket client
     * Copyright(c) 2011 Einar Otto Stangvik <einaros@gmail.com>
     * MIT Licensed
     */

    var ErrorCodes = {
      isValidErrorCode: function (code) {
        return (code >= 1000 && code <= 1013 && code !== 1004 && code !== 1005 && code !== 1006) ||
          (code >= 3000 && code <= 4999);
      },
      1000: 'normal',
      1001: 'going away',
      1002: 'protocol error',
      1003: 'unsupported data',
      1004: 'reserved',
      1005: 'reserved for extensions',
      1006: 'reserved for extensions',
      1007: 'inconsistent or invalid data',
      1008: 'policy violation',
      1009: 'message too big',
      1010: 'extension handshake missing',
      1011: 'an unexpected condition prevented the request from being fulfilled',
      1012: 'service restart',
      1013: 'try again later'
    };

    const Buffer$b = safeBuffer$2.Buffer;

    const GET_INFO = 0;
    const GET_PAYLOAD_LENGTH_16 = 1;
    const GET_PAYLOAD_LENGTH_64 = 2;
    const GET_MASK = 3;
    const GET_DATA = 4;
    const INFLATING = 5;

    /**
     * HyBi Receiver implementation.
     */
    class Receiver {
      /**
       * Creates a Receiver instance.
       *
       * @param {Object} extensions An object containing the negotiated extensions
       * @param {Number} maxPayload The maximum allowed message length
       * @param {String} binaryType The type for binary data
       */
      constructor (extensions, maxPayload, binaryType) {
        this._binaryType = binaryType || Constants.BINARY_TYPES[0];
        this._extensions = extensions || {};
        this._maxPayload = maxPayload | 0;

        this._bufferedBytes = 0;
        this._buffers = [];

        this._compressed = false;
        this._payloadLength = 0;
        this._fragmented = 0;
        this._masked = false;
        this._fin = false;
        this._mask = null;
        this._opcode = 0;

        this._totalPayloadLength = 0;
        this._messageLength = 0;
        this._fragments = [];

        this._cleanupCallback = null;
        this._hadError = false;
        this._dead = false;
        this._loop = false;

        this.onmessage = null;
        this.onclose = null;
        this.onerror = null;
        this.onping = null;
        this.onpong = null;

        this._state = GET_INFO;
      }

      /**
       * Consumes bytes from the available buffered data.
       *
       * @param {Number} bytes The number of bytes to consume
       * @return {Buffer} Consumed bytes
       * @private
       */
      readBuffer (bytes) {
        var offset = 0;
        var dst;
        var l;

        this._bufferedBytes -= bytes;

        if (bytes === this._buffers[0].length) return this._buffers.shift();

        if (bytes < this._buffers[0].length) {
          dst = this._buffers[0].slice(0, bytes);
          this._buffers[0] = this._buffers[0].slice(bytes);
          return dst;
        }

        dst = Buffer$b.allocUnsafe(bytes);

        while (bytes > 0) {
          l = this._buffers[0].length;

          if (bytes >= l) {
            this._buffers[0].copy(dst, offset);
            offset += l;
            this._buffers.shift();
          } else {
            this._buffers[0].copy(dst, offset, 0, bytes);
            this._buffers[0] = this._buffers[0].slice(bytes);
          }

          bytes -= l;
        }

        return dst;
      }

      /**
       * Checks if the number of buffered bytes is bigger or equal than `n` and
       * calls `cleanup` if necessary.
       *
       * @param {Number} n The number of bytes to check against
       * @return {Boolean} `true` if `bufferedBytes >= n`, else `false`
       * @private
       */
      hasBufferedBytes (n) {
        if (this._bufferedBytes >= n) return true;

        this._loop = false;
        if (this._dead) this.cleanup(this._cleanupCallback);
        return false;
      }

      /**
       * Adds new data to the parser.
       *
       * @public
       */
      add (data) {
        if (this._dead) return;

        this._bufferedBytes += data.length;
        this._buffers.push(data);
        this.startLoop();
      }

      /**
       * Starts the parsing loop.
       *
       * @private
       */
      startLoop () {
        this._loop = true;

        while (this._loop) {
          switch (this._state) {
            case GET_INFO:
              this.getInfo();
              break;
            case GET_PAYLOAD_LENGTH_16:
              this.getPayloadLength16();
              break;
            case GET_PAYLOAD_LENGTH_64:
              this.getPayloadLength64();
              break;
            case GET_MASK:
              this.getMask();
              break;
            case GET_DATA:
              this.getData();
              break;
            default: // `INFLATING`
              this._loop = false;
          }
        }
      }

      /**
       * Reads the first two bytes of a frame.
       *
       * @private
       */
      getInfo () {
        if (!this.hasBufferedBytes(2)) return;

        const buf = this.readBuffer(2);

        if ((buf[0] & 0x30) !== 0x00) {
          this.error(new Error('RSV2 and RSV3 must be clear'), 1002);
          return;
        }

        const compressed = (buf[0] & 0x40) === 0x40;

        if (compressed && !this._extensions[PerMessageDeflate_1.extensionName]) {
          this.error(new Error('RSV1 must be clear'), 1002);
          return;
        }

        this._fin = (buf[0] & 0x80) === 0x80;
        this._opcode = buf[0] & 0x0f;
        this._payloadLength = buf[1] & 0x7f;

        if (this._opcode === 0x00) {
          if (compressed) {
            this.error(new Error('RSV1 must be clear'), 1002);
            return;
          }

          if (!this._fragmented) {
            this.error(new Error(`invalid opcode: ${this._opcode}`), 1002);
            return;
          } else {
            this._opcode = this._fragmented;
          }
        } else if (this._opcode === 0x01 || this._opcode === 0x02) {
          if (this._fragmented) {
            this.error(new Error(`invalid opcode: ${this._opcode}`), 1002);
            return;
          }

          this._compressed = compressed;
        } else if (this._opcode > 0x07 && this._opcode < 0x0b) {
          if (!this._fin) {
            this.error(new Error('FIN must be set'), 1002);
            return;
          }

          if (compressed) {
            this.error(new Error('RSV1 must be clear'), 1002);
            return;
          }

          if (this._payloadLength > 0x7d) {
            this.error(new Error('invalid payload length'), 1002);
            return;
          }
        } else {
          this.error(new Error(`invalid opcode: ${this._opcode}`), 1002);
          return;
        }

        if (!this._fin && !this._fragmented) this._fragmented = this._opcode;

        this._masked = (buf[1] & 0x80) === 0x80;

        if (this._payloadLength === 126) this._state = GET_PAYLOAD_LENGTH_16;
        else if (this._payloadLength === 127) this._state = GET_PAYLOAD_LENGTH_64;
        else this.haveLength();
      }

      /**
       * Gets extended payload length (7+16).
       *
       * @private
       */
      getPayloadLength16 () {
        if (!this.hasBufferedBytes(2)) return;

        this._payloadLength = this.readBuffer(2).readUInt16BE(0, true);
        this.haveLength();
      }

      /**
       * Gets extended payload length (7+64).
       *
       * @private
       */
      getPayloadLength64 () {
        if (!this.hasBufferedBytes(8)) return;

        const buf = this.readBuffer(8);
        const num = buf.readUInt32BE(0, true);

        //
        // The maximum safe integer in JavaScript is 2^53 - 1. An error is returned
        // if payload length is greater than this number.
        //
        if (num > Math.pow(2, 53 - 32) - 1) {
          this.error(new Error('max payload size exceeded'), 1009);
          return;
        }

        this._payloadLength = (num * Math.pow(2, 32)) + buf.readUInt32BE(4, true);
        this.haveLength();
      }

      /**
       * Payload length has been read.
       *
       * @private
       */
      haveLength () {
        if (this._opcode < 0x08 && this.maxPayloadExceeded(this._payloadLength)) {
          return;
        }

        if (this._masked) this._state = GET_MASK;
        else this._state = GET_DATA;
      }

      /**
       * Reads mask bytes.
       *
       * @private
       */
      getMask () {
        if (!this.hasBufferedBytes(4)) return;

        this._mask = this.readBuffer(4);
        this._state = GET_DATA;
      }

      /**
       * Reads data bytes.
       *
       * @private
       */
      getData () {
        var data = Constants.EMPTY_BUFFER;

        if (this._payloadLength) {
          if (!this.hasBufferedBytes(this._payloadLength)) return;

          data = this.readBuffer(this._payloadLength);
          if (this._masked) BufferUtil.unmask(data, this._mask);
        }

        if (this._opcode > 0x07) {
          this.controlMessage(data);
        } else if (this._compressed) {
          this._state = INFLATING;
          this.decompress(data);
        } else if (this.pushFragment(data)) {
          this.dataMessage();
        }
      }

      /**
       * Decompresses data.
       *
       * @param {Buffer} data Compressed data
       * @private
       */
      decompress (data) {
        const perMessageDeflate = this._extensions[PerMessageDeflate_1.extensionName];

        perMessageDeflate.decompress(data, this._fin, (err, buf) => {
          if (err) {
            this.error(err, err.closeCode === 1009 ? 1009 : 1007);
            return;
          }

          if (this.pushFragment(buf)) this.dataMessage();
          this.startLoop();
        });
      }

      /**
       * Handles a data message.
       *
       * @private
       */
      dataMessage () {
        if (this._fin) {
          const messageLength = this._messageLength;
          const fragments = this._fragments;

          this._totalPayloadLength = 0;
          this._messageLength = 0;
          this._fragmented = 0;
          this._fragments = [];

          if (this._opcode === 2) {
            var data;

            if (this._binaryType === 'nodebuffer') {
              data = toBuffer(fragments, messageLength);
            } else if (this._binaryType === 'arraybuffer') {
              data = toArrayBuffer$1(toBuffer(fragments, messageLength));
            } else {
              data = fragments;
            }

            this.onmessage(data);
          } else {
            const buf = toBuffer(fragments, messageLength);

            if (!Validation(buf)) {
              this.error(new Error('invalid utf8 sequence'), 1007);
              return;
            }

            this.onmessage(buf.toString());
          }
        }

        this._state = GET_INFO;
      }

      /**
       * Handles a control message.
       *
       * @param {Buffer} data Data to handle
       * @private
       */
      controlMessage (data) {
        if (this._opcode === 0x08) {
          if (data.length === 0) {
            this.onclose(1000, '');
            this._loop = false;
            this.cleanup(this._cleanupCallback);
          } else if (data.length === 1) {
            this.error(new Error('invalid payload length'), 1002);
          } else {
            const code = data.readUInt16BE(0, true);

            if (!ErrorCodes.isValidErrorCode(code)) {
              this.error(new Error(`invalid status code: ${code}`), 1002);
              return;
            }

            const buf = data.slice(2);

            if (!Validation(buf)) {
              this.error(new Error('invalid utf8 sequence'), 1007);
              return;
            }

            this.onclose(code, buf.toString());
            this._loop = false;
            this.cleanup(this._cleanupCallback);
          }

          return;
        }

        if (this._opcode === 0x09) this.onping(data);
        else this.onpong(data);

        this._state = GET_INFO;
      }

      /**
       * Handles an error.
       *
       * @param {Error} err The error
       * @param {Number} code Close code
       * @private
       */
      error (err, code) {
        this.onerror(err, code);
        this._hadError = true;
        this._loop = false;
        this.cleanup(this._cleanupCallback);
      }

      /**
       * Checks payload size, disconnects socket when it exceeds `maxPayload`.
       *
       * @param {Number} length Payload length
       * @private
       */
      maxPayloadExceeded (length) {
        if (length === 0 || this._maxPayload < 1) return false;

        const fullLength = this._totalPayloadLength + length;

        if (fullLength <= this._maxPayload) {
          this._totalPayloadLength = fullLength;
          return false;
        }

        this.error(new Error('max payload size exceeded'), 1009);
        return true;
      }

      /**
       * Appends a fragment in the fragments array after checking that the sum of
       * fragment lengths does not exceed `maxPayload`.
       *
       * @param {Buffer} fragment The fragment to add
       * @return {Boolean} `true` if `maxPayload` is not exceeded, else `false`
       * @private
       */
      pushFragment (fragment) {
        if (fragment.length === 0) return true;

        const totalLength = this._messageLength + fragment.length;

        if (this._maxPayload < 1 || totalLength <= this._maxPayload) {
          this._messageLength = totalLength;
          this._fragments.push(fragment);
          return true;
        }

        this.error(new Error('max payload size exceeded'), 1009);
        return false;
      }

      /**
       * Releases resources used by the receiver.
       *
       * @param {Function} cb Callback
       * @public
       */
      cleanup (cb) {
        this._dead = true;

        if (!this._hadError && (this._loop || this._state === INFLATING)) {
          this._cleanupCallback = cb;
        } else {
          this._extensions = null;
          this._fragments = null;
          this._buffers = null;
          this._mask = null;

          this._cleanupCallback = null;
          this.onmessage = null;
          this.onclose = null;
          this.onerror = null;
          this.onping = null;
          this.onpong = null;

          if (cb) cb();
        }
      }
    }

    var Receiver_1 = Receiver;

    /**
     * Makes a buffer from a list of fragments.
     *
     * @param {Buffer[]} fragments The list of fragments composing the message
     * @param {Number} messageLength The length of the message
     * @return {Buffer}
     * @private
     */
    function toBuffer (fragments, messageLength) {
      if (fragments.length === 1) return fragments[0];
      if (fragments.length > 1) return BufferUtil.concat(fragments, messageLength);
      return Constants.EMPTY_BUFFER;
    }

    /**
     * Converts a buffer to an `ArrayBuffer`.
     *
     * @param {Buffer} The buffer to convert
     * @return {ArrayBuffer} Converted buffer
     */
    function toArrayBuffer$1 (buf) {
      if (buf.byteOffset === 0 && buf.byteLength === buf.buffer.byteLength) {
        return buf.buffer;
      }

      return buf.buffer.slice(buf.byteOffset, buf.byteOffset + buf.byteLength);
    }

    const Buffer$c = safeBuffer$2.Buffer;

    /**
     * HyBi Sender implementation.
     */
    class Sender {
      /**
       * Creates a Sender instance.
       *
       * @param {net.Socket} socket The connection socket
       * @param {Object} extensions An object containing the negotiated extensions
       */
      constructor (socket, extensions) {
        this._extensions = extensions || {};
        this._socket = socket;

        this._firstFragment = true;
        this._compress = false;

        this._bufferedBytes = 0;
        this._deflating = false;
        this._queue = [];
      }

      /**
       * Frames a piece of data according to the HyBi WebSocket protocol.
       *
       * @param {Buffer} data The data to frame
       * @param {Object} options Options object
       * @param {Number} options.opcode The opcode
       * @param {Boolean} options.readOnly Specifies whether `data` can be modified
       * @param {Boolean} options.fin Specifies whether or not to set the FIN bit
       * @param {Boolean} options.mask Specifies whether or not to mask `data`
       * @param {Boolean} options.rsv1 Specifies whether or not to set the RSV1 bit
       * @return {Buffer[]} The framed data as a list of `Buffer` instances
       * @public
       */
      static frame (data, options) {
        const merge = data.length < 1024 || (options.mask && options.readOnly);
        var offset = options.mask ? 6 : 2;
        var payloadLength = data.length;

        if (data.length >= 65536) {
          offset += 8;
          payloadLength = 127;
        } else if (data.length > 125) {
          offset += 2;
          payloadLength = 126;
        }

        const target = Buffer$c.allocUnsafe(merge ? data.length + offset : offset);

        target[0] = options.fin ? options.opcode | 0x80 : options.opcode;
        if (options.rsv1) target[0] |= 0x40;

        if (payloadLength === 126) {
          target.writeUInt16BE(data.length, 2, true);
        } else if (payloadLength === 127) {
          target.writeUInt32BE(0, 2, true);
          target.writeUInt32BE(data.length, 6, true);
        }

        if (!options.mask) {
          target[1] = payloadLength;
          if (merge) {
            data.copy(target, offset);
            return [target];
          }

          return [target, data];
        }

        const mask = fs.randomBytes(4);

        target[1] = payloadLength | 0x80;
        target[offset - 4] = mask[0];
        target[offset - 3] = mask[1];
        target[offset - 2] = mask[2];
        target[offset - 1] = mask[3];

        if (merge) {
          BufferUtil.mask(data, mask, target, offset, data.length);
          return [target];
        }

        BufferUtil.mask(data, mask, data, 0, data.length);
        return [target, data];
      }

      /**
       * Sends a close message to the other peer.
       *
       * @param {(Number|undefined)} code The status code component of the body
       * @param {String} data The message component of the body
       * @param {Boolean} mask Specifies whether or not to mask the message
       * @param {Function} cb Callback
       * @public
       */
      close (code, data, mask, cb) {
        var buf;

        if (code === undefined) {
          code = 1000;
        } else if (typeof code !== 'number' || !ErrorCodes.isValidErrorCode(code)) {
          throw new Error('first argument must be a valid error code number');
        }

        if (data === undefined || data === '') {
          if (code === 1000) {
            buf = Constants.EMPTY_BUFFER;
          } else {
            buf = Buffer$c.allocUnsafe(2);
            buf.writeUInt16BE(code, 0, true);
          }
        } else {
          buf = Buffer$c.allocUnsafe(2 + Buffer$c.byteLength(data));
          buf.writeUInt16BE(code, 0, true);
          buf.write(data, 2);
        }

        if (this._deflating) {
          this.enqueue([this.doClose, buf, mask, cb]);
        } else {
          this.doClose(buf, mask, cb);
        }
      }

      /**
       * Frames and sends a close message.
       *
       * @param {Buffer} data The message to send
       * @param {Boolean} mask Specifies whether or not to mask `data`
       * @param {Function} cb Callback
       * @private
       */
      doClose (data, mask, cb) {
        this.sendFrame(Sender.frame(data, {
          fin: true,
          rsv1: false,
          opcode: 0x08,
          mask,
          readOnly: false
        }), cb);
      }

      /**
       * Sends a ping message to the other peer.
       *
       * @param {*} data The message to send
       * @param {Boolean} mask Specifies whether or not to mask `data`
       * @public
       */
      ping (data, mask) {
        var readOnly = true;

        if (!Buffer$c.isBuffer(data)) {
          if (data instanceof ArrayBuffer) {
            data = Buffer$c.from(data);
          } else if (ArrayBuffer.isView(data)) {
            data = viewToBuffer(data);
          } else {
            data = Buffer$c.from(data);
            readOnly = false;
          }
        }

        if (this._deflating) {
          this.enqueue([this.doPing, data, mask, readOnly]);
        } else {
          this.doPing(data, mask, readOnly);
        }
      }

      /**
       * Frames and sends a ping message.
       *
       * @param {*} data The message to send
       * @param {Boolean} mask Specifies whether or not to mask `data`
       * @param {Boolean} readOnly Specifies whether `data` can be modified
       * @private
       */
      doPing (data, mask, readOnly) {
        this.sendFrame(Sender.frame(data, {
          fin: true,
          rsv1: false,
          opcode: 0x09,
          mask,
          readOnly
        }));
      }

      /**
       * Sends a pong message to the other peer.
       *
       * @param {*} data The message to send
       * @param {Boolean} mask Specifies whether or not to mask `data`
       * @public
       */
      pong (data, mask) {
        var readOnly = true;

        if (!Buffer$c.isBuffer(data)) {
          if (data instanceof ArrayBuffer) {
            data = Buffer$c.from(data);
          } else if (ArrayBuffer.isView(data)) {
            data = viewToBuffer(data);
          } else {
            data = Buffer$c.from(data);
            readOnly = false;
          }
        }

        if (this._deflating) {
          this.enqueue([this.doPong, data, mask, readOnly]);
        } else {
          this.doPong(data, mask, readOnly);
        }
      }

      /**
       * Frames and sends a pong message.
       *
       * @param {*} data The message to send
       * @param {Boolean} mask Specifies whether or not to mask `data`
       * @param {Boolean} readOnly Specifies whether `data` can be modified
       * @private
       */
      doPong (data, mask, readOnly) {
        this.sendFrame(Sender.frame(data, {
          fin: true,
          rsv1: false,
          opcode: 0x0a,
          mask,
          readOnly
        }));
      }

      /**
       * Sends a data message to the other peer.
       *
       * @param {*} data The message to send
       * @param {Object} options Options object
       * @param {Boolean} options.compress Specifies whether or not to compress `data`
       * @param {Boolean} options.binary Specifies whether `data` is binary or text
       * @param {Boolean} options.fin Specifies whether the fragment is the last one
       * @param {Boolean} options.mask Specifies whether or not to mask `data`
       * @param {Function} cb Callback
       * @public
       */
      send (data, options, cb) {
        var opcode = options.binary ? 2 : 1;
        var rsv1 = options.compress;
        var readOnly = true;

        if (!Buffer$c.isBuffer(data)) {
          if (data instanceof ArrayBuffer) {
            data = Buffer$c.from(data);
          } else if (ArrayBuffer.isView(data)) {
            data = viewToBuffer(data);
          } else {
            data = Buffer$c.from(data);
            readOnly = false;
          }
        }

        const perMessageDeflate = this._extensions[PerMessageDeflate_1.extensionName];

        if (this._firstFragment) {
          this._firstFragment = false;
          if (rsv1 && perMessageDeflate) {
            rsv1 = data.length >= perMessageDeflate._threshold;
          }
          this._compress = rsv1;
        } else {
          rsv1 = false;
          opcode = 0;
        }

        if (options.fin) this._firstFragment = true;

        if (perMessageDeflate) {
          const opts = {
            fin: options.fin,
            rsv1,
            opcode,
            mask: options.mask,
            readOnly
          };

          if (this._deflating) {
            this.enqueue([this.dispatch, data, this._compress, opts, cb]);
          } else {
            this.dispatch(data, this._compress, opts, cb);
          }
        } else {
          this.sendFrame(Sender.frame(data, {
            fin: options.fin,
            rsv1: false,
            opcode,
            mask: options.mask,
            readOnly
          }), cb);
        }
      }

      /**
       * Dispatches a data message.
       *
       * @param {Buffer} data The message to send
       * @param {Boolean} compress Specifies whether or not to compress `data`
       * @param {Object} options Options object
       * @param {Number} options.opcode The opcode
       * @param {Boolean} options.readOnly Specifies whether `data` can be modified
       * @param {Boolean} options.fin Specifies whether or not to set the FIN bit
       * @param {Boolean} options.mask Specifies whether or not to mask `data`
       * @param {Boolean} options.rsv1 Specifies whether or not to set the RSV1 bit
       * @param {Function} cb Callback
       * @private
       */
      dispatch (data, compress, options, cb) {
        if (!compress) {
          this.sendFrame(Sender.frame(data, options), cb);
          return;
        }

        const perMessageDeflate = this._extensions[PerMessageDeflate_1.extensionName];

        this._deflating = true;
        perMessageDeflate.compress(data, options.fin, (_, buf) => {
          options.readOnly = false;
          this.sendFrame(Sender.frame(buf, options), cb);
          this._deflating = false;
          this.dequeue();
        });
      }

      /**
       * Executes queued send operations.
       *
       * @private
       */
      dequeue () {
        while (!this._deflating && this._queue.length) {
          const params = this._queue.shift();

          this._bufferedBytes -= params[1].length;
          params[0].apply(this, params.slice(1));
        }
      }

      /**
       * Enqueues a send operation.
       *
       * @param {Array} params Send operation parameters.
       * @private
       */
      enqueue (params) {
        this._bufferedBytes += params[1].length;
        this._queue.push(params);
      }

      /**
       * Sends a frame.
       *
       * @param {Buffer[]} list The frame to send
       * @param {Function} cb Callback
       * @private
       */
      sendFrame (list, cb) {
        if (list.length === 2) {
          this._socket.write(list[0]);
          this._socket.write(list[1], cb);
        } else {
          this._socket.write(list[0], cb);
        }
      }
    }

    var Sender_1 = Sender;

    /**
     * Converts an `ArrayBuffer` view into a buffer.
     *
     * @param {(DataView|TypedArray)} view The view to convert
     * @return {Buffer} Converted view
     * @private
     */
    function viewToBuffer (view) {
      const buf = Buffer$c.from(view.buffer);

      if (view.byteLength !== view.buffer.byteLength) {
        return buf.slice(view.byteOffset, view.byteOffset + view.byteLength);
      }

      return buf;
    }

    const protocolVersions = [8, 13];
    const closeTimeout = 30 * 1000; // Allow 30 seconds to terminate the connection cleanly.

    /**
     * Class representing a WebSocket.
     *
     * @extends EventEmitter
     */
    class WebSocket extends EventEmitter {
      /**
       * Create a new `WebSocket`.
       *
       * @param {String} address The URL to which to connect
       * @param {(String|String[])} protocols The subprotocols
       * @param {Object} options Connection options
       */
      constructor (address, protocols, options) {
        super();

        if (!protocols) {
          protocols = [];
        } else if (typeof protocols === 'string') {
          protocols = [protocols];
        } else if (!Array.isArray(protocols)) {
          options = protocols;
          protocols = [];
        }

        this.readyState = WebSocket.CONNECTING;
        this.bytesReceived = 0;
        this.extensions = {};
        this.protocol = '';

        this._binaryType = Constants.BINARY_TYPES[0];
        this._finalize = this.finalize.bind(this);
        this._closeFrameReceived = false;
        this._closeFrameSent = false;
        this._closeMessage = '';
        this._closeTimer = null;
        this._finalized = false;
        this._closeCode = 1006;
        this._receiver = null;
        this._sender = null;
        this._socket = null;
        this._ultron = null;

        if (Array.isArray(address)) {
          initAsServerClient.call(this, address[0], address[1], options);
        } else {
          initAsClient.call(this, address, protocols, options);
        }
      }

      get CONNECTING () { return WebSocket.CONNECTING; }
      get CLOSING () { return WebSocket.CLOSING; }
      get CLOSED () { return WebSocket.CLOSED; }
      get OPEN () { return WebSocket.OPEN; }

      /**
       * @type {Number}
       */
      get bufferedAmount () {
        var amount = 0;

        if (this._socket) {
          amount = this._socket.bufferSize + this._sender._bufferedBytes;
        }
        return amount;
      }

      /**
       * This deviates from the WHATWG interface since ws doesn't support the required
       * default "blob" type (instead we define a custom "nodebuffer" type).
       *
       * @type {String}
       */
      get binaryType () {
        return this._binaryType;
      }

      set binaryType (type) {
        if (Constants.BINARY_TYPES.indexOf(type) < 0) return;

        this._binaryType = type;

        //
        // Allow to change `binaryType` on the fly.
        //
        if (this._receiver) this._receiver._binaryType = type;
      }

      /**
       * Set up the socket and the internal resources.
       *
       * @param {net.Socket} socket The network socket between the server and client
       * @param {Buffer} head The first packet of the upgraded stream
       * @private
       */
      setSocket (socket, head) {
        socket.setTimeout(0);
        socket.setNoDelay();

        this._receiver = new Receiver_1(this.extensions, this._maxPayload, this.binaryType);
        this._sender = new Sender_1(socket, this.extensions);
        this._ultron = new ultron(socket);
        this._socket = socket;

        this._ultron.on('close', this._finalize);
        this._ultron.on('error', this._finalize);
        this._ultron.on('end', this._finalize);

        if (head.length > 0) socket.unshift(head);

        this._ultron.on('data', (data) => {
          this.bytesReceived += data.length;
          this._receiver.add(data);
        });

        this._receiver.onmessage = (data) => this.emit('message', data);
        this._receiver.onping = (data) => {
          this.pong(data, !this._isServer, true);
          this.emit('ping', data);
        };
        this._receiver.onpong = (data) => this.emit('pong', data);
        this._receiver.onclose = (code, reason) => {
          this._closeFrameReceived = true;
          this._closeMessage = reason;
          this._closeCode = code;
          if (!this._finalized) this.close(code, reason);
        };
        this._receiver.onerror = (error, code) => {
          this._closeMessage = '';
          this._closeCode = code;

          //
          // Ensure that the error is emitted even if `WebSocket#finalize()` has
          // already been called.
          //
          this.readyState = WebSocket.CLOSING;
          this.emit('error', error);
          this.finalize(true);
        };

        this.readyState = WebSocket.OPEN;
        this.emit('open');
      }

      /**
       * Clean up and release internal resources.
       *
       * @param {(Boolean|Error)} error Indicates whether or not an error occurred
       * @private
       */
      finalize (error) {
        if (this._finalized) return;

        this.readyState = WebSocket.CLOSING;
        this._finalized = true;

        if (typeof error === 'object') this.emit('error', error);
        if (!this._socket) return this.emitClose();

        clearTimeout(this._closeTimer);
        this._closeTimer = null;

        this._ultron.destroy();
        this._ultron = null;

        this._socket.on('error', Constants.NOOP);

        if (!error) this._socket.end();
        else this._socket.destroy();

        this._socket = null;
        this._sender = null;

        this._receiver.cleanup(() => this.emitClose());
        this._receiver = null;
      }

      /**
       * Emit the `close` event.
       *
       * @private
       */
      emitClose () {
        this.readyState = WebSocket.CLOSED;

        this.emit('close', this._closeCode, this._closeMessage);

        if (this.extensions[PerMessageDeflate_1.extensionName]) {
          this.extensions[PerMessageDeflate_1.extensionName].cleanup();
        }

        this.extensions = null;

        this.removeAllListeners();
      }

      /**
       * Pause the socket stream.
       *
       * @public
       */
      pause () {
        if (this.readyState !== WebSocket.OPEN) throw new Error('not opened');

        this._socket.pause();
      }

      /**
       * Resume the socket stream
       *
       * @public
       */
      resume () {
        if (this.readyState !== WebSocket.OPEN) throw new Error('not opened');

        this._socket.resume();
      }

      /**
       * Start a closing handshake.
       *
       *            +----------+     +-----------+   +----------+
       *     + - - -|ws.close()|---->|close frame|-->|ws.close()|- - - -
       *            +----------+     +-----------+   +----------+       |
       *     |      +----------+     +-----------+         |
       *            |ws.close()|<----|close frame|<--------+            |
       *            +----------+     +-----------+         |
       *  CLOSING         |              +---+             |         CLOSING
       *                  |          +---|fin|<------------+
       *     |            |          |   +---+                          |
       *                  |          |   +---+      +-------------+
       *     |            +----------+-->|fin|----->|ws.finalize()| - - +
       *                             |   +---+      +-------------+
       *     |     +-------------+   |
       *      - - -|ws.finalize()|<--+
       *           +-------------+
       *
       * @param {Number} code Status code explaining why the connection is closing
       * @param {String} data A string explaining why the connection is closing
       * @public
       */
      close (code, data) {
        if (this.readyState === WebSocket.CLOSED) return;
        if (this.readyState === WebSocket.CONNECTING) {
          this._req.abort();
          this.finalize(new Error('closed before the connection is established'));
          return;
        }

        if (this.readyState === WebSocket.CLOSING) {
          if (this._closeFrameSent && this._closeFrameReceived) this._socket.end();
          return;
        }

        this.readyState = WebSocket.CLOSING;
        this._sender.close(code, data, !this._isServer, (err) => {
          //
          // This error is handled by the `'error'` listener on the socket. We only
          // want to know if the close frame has been sent here.
          //
          if (err) return;

          this._closeFrameSent = true;

          if (!this._finalized) {
            if (this._closeFrameReceived) this._socket.end();

            //
            // Ensure that the connection is cleaned up even when the closing
            // handshake fails.
            //
            this._closeTimer = setTimeout(this._finalize, closeTimeout, true);
          }
        });
      }

      /**
       * Send a ping message.
       *
       * @param {*} data The message to send
       * @param {Boolean} mask Indicates whether or not to mask `data`
       * @param {Boolean} failSilently Indicates whether or not to throw if `readyState` isn't `OPEN`
       * @public
       */
      ping (data, mask, failSilently) {
        if (this.readyState !== WebSocket.OPEN) {
          if (failSilently) return;
          throw new Error('not opened');
        }

        if (typeof data === 'number') data = data.toString();
        if (mask === undefined) mask = !this._isServer;
        this._sender.ping(data || Constants.EMPTY_BUFFER, mask);
      }

      /**
       * Send a pong message.
       *
       * @param {*} data The message to send
       * @param {Boolean} mask Indicates whether or not to mask `data`
       * @param {Boolean} failSilently Indicates whether or not to throw if `readyState` isn't `OPEN`
       * @public
       */
      pong (data, mask, failSilently) {
        if (this.readyState !== WebSocket.OPEN) {
          if (failSilently) return;
          throw new Error('not opened');
        }

        if (typeof data === 'number') data = data.toString();
        if (mask === undefined) mask = !this._isServer;
        this._sender.pong(data || Constants.EMPTY_BUFFER, mask);
      }

      /**
       * Send a data message.
       *
       * @param {*} data The message to send
       * @param {Object} options Options object
       * @param {Boolean} options.compress Specifies whether or not to compress `data`
       * @param {Boolean} options.binary Specifies whether `data` is binary or text
       * @param {Boolean} options.fin Specifies whether the fragment is the last one
       * @param {Boolean} options.mask Specifies whether or not to mask `data`
       * @param {Function} cb Callback which is executed when data is written out
       * @public
       */
      send (data, options, cb) {
        if (typeof options === 'function') {
          cb = options;
          options = {};
        }

        if (this.readyState !== WebSocket.OPEN) {
          if (cb) cb(new Error('not opened'));
          else throw new Error('not opened');
          return;
        }

        if (typeof data === 'number') data = data.toString();

        const opts = Object.assign({
          binary: typeof data !== 'string',
          mask: !this._isServer,
          compress: true,
          fin: true
        }, options);

        if (!this.extensions[PerMessageDeflate_1.extensionName]) {
          opts.compress = false;
        }

        this._sender.send(data || Constants.EMPTY_BUFFER, opts, cb);
      }

      /**
       * Forcibly close the connection.
       *
       * @public
       */
      terminate () {
        if (this.readyState === WebSocket.CLOSED) return;
        if (this.readyState === WebSocket.CONNECTING) {
          this._req.abort();
          this.finalize(new Error('closed before the connection is established'));
          return;
        }

        this.finalize(true);
      }
    }

    WebSocket.CONNECTING = 0;
    WebSocket.OPEN = 1;
    WebSocket.CLOSING = 2;
    WebSocket.CLOSED = 3;

    //
    // Add the `onopen`, `onerror`, `onclose`, and `onmessage` attributes.
    // See https://html.spec.whatwg.org/multipage/comms.html#the-websocket-interface
    //
    ['open', 'error', 'close', 'message'].forEach((method) => {
      Object.defineProperty(WebSocket.prototype, `on${method}`, {
        /**
         * Return the listener of the event.
         *
         * @return {(Function|undefined)} The event listener or `undefined`
         * @public
         */
        get () {
          const listeners = this.listeners(method);
          for (var i = 0; i < listeners.length; i++) {
            if (listeners[i]._listener) return listeners[i]._listener;
          }
        },
        /**
         * Add a listener for the event.
         *
         * @param {Function} listener The listener to add
         * @public
         */
        set (listener) {
          const listeners = this.listeners(method);
          for (var i = 0; i < listeners.length; i++) {
            //
            // Remove only the listeners added via `addEventListener`.
            //
            if (listeners[i]._listener) this.removeListener(method, listeners[i]);
          }
          this.addEventListener(method, listener);
        }
      });
    });

    WebSocket.prototype.addEventListener = EventTarget_1.addEventListener;
    WebSocket.prototype.removeEventListener = EventTarget_1.removeEventListener;

    var WebSocket_1 = WebSocket;

    /**
     * Initialize a WebSocket server client.
     *
     * @param {http.IncomingMessage} req The request object
     * @param {net.Socket} socket The network socket between the server and client
     * @param {Buffer} head The first packet of the upgraded stream
     * @param {Object} options WebSocket attributes
     * @param {Number} options.protocolVersion The WebSocket protocol version
     * @param {Object} options.extensions The negotiated extensions
     * @param {Number} options.maxPayload The maximum allowed message size
     * @param {String} options.protocol The chosen subprotocol
     * @private
     */
    function initAsServerClient (socket, head, options) {
      this.protocolVersion = options.protocolVersion;
      this._maxPayload = options.maxPayload;
      this.extensions = options.extensions;
      this.protocol = options.protocol;

      this._isServer = true;

      this.setSocket(socket, head);
    }

    /**
     * Initialize a WebSocket client.
     *
     * @param {String} address The URL to which to connect
     * @param {String[]} protocols The list of subprotocols
     * @param {Object} options Connection options
     * @param {String} options.protocol Value of the `Sec-WebSocket-Protocol` header
     * @param {(Boolean|Object)} options.perMessageDeflate Enable/disable permessage-deflate
     * @param {Number} options.handshakeTimeout Timeout in milliseconds for the handshake request
     * @param {String} options.localAddress Local interface to bind for network connections
     * @param {Number} options.protocolVersion Value of the `Sec-WebSocket-Version` header
     * @param {Object} options.headers An object containing request headers
     * @param {String} options.origin Value of the `Origin` or `Sec-WebSocket-Origin` header
     * @param {http.Agent} options.agent Use the specified Agent
     * @param {String} options.host Value of the `Host` header
     * @param {Number} options.family IP address family to use during hostname lookup (4 or 6).
     * @param {Function} options.checkServerIdentity A function to validate the server hostname
     * @param {Boolean} options.rejectUnauthorized Verify or not the server certificate
     * @param {String} options.passphrase The passphrase for the private key or pfx
     * @param {String} options.ciphers The ciphers to use or exclude
     * @param {String} options.ecdhCurve The curves for ECDH key agreement to use or exclude
     * @param {(String|String[]|Buffer|Buffer[])} options.cert The certificate key
     * @param {(String|String[]|Buffer|Buffer[])} options.key The private key
     * @param {(String|Buffer)} options.pfx The private key, certificate, and CA certs
     * @param {(String|String[]|Buffer|Buffer[])} options.ca Trusted certificates
     * @private
     */
    function initAsClient (address, protocols, options) {
      options = Object.assign({
        protocolVersion: protocolVersions[1],
        protocol: protocols.join(','),
        perMessageDeflate: true,
        handshakeTimeout: null,
        localAddress: null,
        headers: null,
        family: null,
        origin: null,
        agent: null,
        host: null,

        //
        // SSL options.
        //
        checkServerIdentity: null,
        rejectUnauthorized: null,
        passphrase: null,
        ciphers: null,
        ecdhCurve: null,
        cert: null,
        key: null,
        pfx: null,
        ca: null
      }, options);

      if (protocolVersions.indexOf(options.protocolVersion) === -1) {
        throw new Error(
          `unsupported protocol version: ${options.protocolVersion} ` +
          `(supported versions: ${protocolVersions.join(', ')})`
        );
      }

      this.protocolVersion = options.protocolVersion;
      this._isServer = false;
      this.url = address;

      const serverUrl = url.parse(address);
      const isUnixSocket = serverUrl.protocol === 'ws+unix:';

      if (!serverUrl.host && (!isUnixSocket || !serverUrl.path)) {
        throw new Error('invalid url');
      }

      const isSecure = serverUrl.protocol === 'wss:' || serverUrl.protocol === 'https:';
      const key = fs.randomBytes(16).toString('base64');
      const httpObj = isSecure ? http : http;
      var perMessageDeflate;

      const requestOptions = {
        port: serverUrl.port || (isSecure ? 443 : 80),
        host: serverUrl.hostname,
        path: '/',
        headers: {
          'Sec-WebSocket-Version': options.protocolVersion,
          'Sec-WebSocket-Key': key,
          'Connection': 'Upgrade',
          'Upgrade': 'websocket'
        }
      };

      if (options.headers) Object.assign(requestOptions.headers, options.headers);
      if (options.perMessageDeflate) {
        perMessageDeflate = new PerMessageDeflate_1(
          options.perMessageDeflate !== true ? options.perMessageDeflate : {},
          false
        );
        requestOptions.headers['Sec-WebSocket-Extensions'] = Extensions.format({
          [PerMessageDeflate_1.extensionName]: perMessageDeflate.offer()
        });
      }
      if (options.protocol) {
        requestOptions.headers['Sec-WebSocket-Protocol'] = options.protocol;
      }
      if (options.origin) {
        if (options.protocolVersion < 13) {
          requestOptions.headers['Sec-WebSocket-Origin'] = options.origin;
        } else {
          requestOptions.headers.Origin = options.origin;
        }
      }
      if (options.host) requestOptions.headers.Host = options.host;
      if (serverUrl.auth) requestOptions.auth = serverUrl.auth;

      if (options.localAddress) requestOptions.localAddress = options.localAddress;
      if (options.family) requestOptions.family = options.family;

      if (isUnixSocket) {
        const parts = serverUrl.path.split(':');

        requestOptions.socketPath = parts[0];
        requestOptions.path = parts[1];
      } else if (serverUrl.path) {
        //
        // Make sure that path starts with `/`.
        //
        if (serverUrl.path.charAt(0) !== '/') {
          requestOptions.path = `/${serverUrl.path}`;
        } else {
          requestOptions.path = serverUrl.path;
        }
      }

      var agent = options.agent;

      //
      // A custom agent is required for these options.
      //
      if (
        options.rejectUnauthorized != null ||
        options.checkServerIdentity ||
        options.passphrase ||
        options.ciphers ||
        options.ecdhCurve ||
        options.cert ||
        options.key ||
        options.pfx ||
        options.ca
      ) {
        if (options.passphrase) requestOptions.passphrase = options.passphrase;
        if (options.ciphers) requestOptions.ciphers = options.ciphers;
        if (options.ecdhCurve) requestOptions.ecdhCurve = options.ecdhCurve;
        if (options.cert) requestOptions.cert = options.cert;
        if (options.key) requestOptions.key = options.key;
        if (options.pfx) requestOptions.pfx = options.pfx;
        if (options.ca) requestOptions.ca = options.ca;
        if (options.checkServerIdentity) {
          requestOptions.checkServerIdentity = options.checkServerIdentity;
        }
        if (options.rejectUnauthorized != null) {
          requestOptions.rejectUnauthorized = options.rejectUnauthorized;
        }

        if (!agent) agent = new httpObj.Agent(requestOptions);
      }

      if (agent) requestOptions.agent = agent;

      this._req = httpObj.get(requestOptions);

      if (options.handshakeTimeout) {
        this._req.setTimeout(options.handshakeTimeout, () => {
          this._req.abort();
          this.finalize(new Error('opening handshake has timed out'));
        });
      }

      this._req.on('error', (error) => {
        if (this._req.aborted) return;

        this._req = null;
        this.finalize(error);
      });

      this._req.on('response', (res) => {
        if (!this.emit('unexpected-response', this._req, res)) {
          this._req.abort();
          this.finalize(new Error(`unexpected server response (${res.statusCode})`));
        }
      });

      this._req.on('upgrade', (res, socket, head) => {
        this.emit('headers', res.headers, res);

        //
        // The user may have closed the connection from a listener of the `headers`
        // event.
        //
        if (this.readyState !== WebSocket.CONNECTING) return;

        this._req = null;

        const digest = fs.createHash('sha1')
          .update(key + Constants.GUID, 'binary')
          .digest('base64');

        if (res.headers['sec-websocket-accept'] !== digest) {
          socket.destroy();
          return this.finalize(new Error('invalid server key'));
        }

        const serverProt = res.headers['sec-websocket-protocol'];
        const protList = (options.protocol || '').split(/, */);
        var protError;

        if (!options.protocol && serverProt) {
          protError = 'server sent a subprotocol even though none requested';
        } else if (options.protocol && !serverProt) {
          protError = 'server sent no subprotocol even though requested';
        } else if (serverProt && protList.indexOf(serverProt) === -1) {
          protError = 'server responded with an invalid protocol';
        }

        if (protError) {
          socket.destroy();
          return this.finalize(new Error(protError));
        }

        if (serverProt) this.protocol = serverProt;

        if (perMessageDeflate) {
          try {
            const serverExtensions = Extensions.parse(
              res.headers['sec-websocket-extensions']
            );

            if (serverExtensions[PerMessageDeflate_1.extensionName]) {
              perMessageDeflate.accept(
                serverExtensions[PerMessageDeflate_1.extensionName]
              );
              this.extensions[PerMessageDeflate_1.extensionName] = perMessageDeflate;
            }
          } catch (err) {
            socket.destroy();
            this.finalize(new Error('invalid Sec-WebSocket-Extensions header'));
            return;
          }
        }

        this.setSocket(socket, head);
      });
    }

    const Buffer$d = safeBuffer$2.Buffer;

    /**
     * Class representing a WebSocket server.
     *
     * @extends EventEmitter
     */
    class WebSocketServer extends EventEmitter {
      /**
       * Create a `WebSocketServer` instance.
       *
       * @param {Object} options Configuration options
       * @param {String} options.host The hostname where to bind the server
       * @param {Number} options.port The port where to bind the server
       * @param {http.Server} options.server A pre-created HTTP/S server to use
       * @param {Function} options.verifyClient An hook to reject connections
       * @param {Function} options.handleProtocols An hook to handle protocols
       * @param {String} options.path Accept only connections matching this path
       * @param {Boolean} options.noServer Enable no server mode
       * @param {Boolean} options.clientTracking Specifies whether or not to track clients
       * @param {(Boolean|Object)} options.perMessageDeflate Enable/disable permessage-deflate
       * @param {Number} options.maxPayload The maximum allowed message size
       * @param {Function} callback A listener for the `listening` event
       */
      constructor (options, callback) {
        super();

        options = Object.assign({
          maxPayload: 100 * 1024 * 1024,
          perMessageDeflate: false,
          handleProtocols: null,
          clientTracking: true,
          verifyClient: null,
          noServer: false,
          backlog: null, // use default (511 as implemented in net.js)
          server: null,
          host: null,
          path: null,
          port: null
        }, options);

        if (options.port == null && !options.server && !options.noServer) {
          throw new TypeError('missing or invalid options');
        }

        if (options.port != null) {
          this._server = http.createServer((req, res) => {
            const body = http.STATUS_CODES[426];

            res.writeHead(426, {
              'Content-Length': body.length,
              'Content-Type': 'text/plain'
            });
            res.end(body);
          });
          this._server.listen(options.port, options.host, options.backlog, callback);
        } else if (options.server) {
          this._server = options.server;
        }

        if (this._server) {
          this._ultron = new ultron(this._server);
          this._ultron.on('listening', () => this.emit('listening'));
          this._ultron.on('error', (err) => this.emit('error', err));
          this._ultron.on('upgrade', (req, socket, head) => {
            this.handleUpgrade(req, socket, head, (client) => {
              this.emit('connection', client, req);
            });
          });
        }

        if (options.perMessageDeflate === true) options.perMessageDeflate = {};
        if (options.clientTracking) this.clients = new Set();
        this.options = options;
      }

      /**
       * Close the server.
       *
       * @param {Function} cb Callback
       * @public
       */
      close (cb) {
        //
        // Terminate all associated clients.
        //
        if (this.clients) {
          for (const client of this.clients) client.terminate();
        }

        const server = this._server;

        if (server) {
          this._ultron.destroy();
          this._ultron = this._server = null;

          //
          // Close the http server if it was internally created.
          //
          if (this.options.port != null) return server.close(cb);
        }

        if (cb) cb();
      }

      /**
       * See if a given request should be handled by this server instance.
       *
       * @param {http.IncomingMessage} req Request object to inspect
       * @return {Boolean} `true` if the request is valid, else `false`
       * @public
       */
      shouldHandle (req) {
        if (this.options.path && url.parse(req.url).pathname !== this.options.path) {
          return false;
        }

        return true;
      }

      /**
       * Handle a HTTP Upgrade request.
       *
       * @param {http.IncomingMessage} req The request object
       * @param {net.Socket} socket The network socket between the server and client
       * @param {Buffer} head The first packet of the upgraded stream
       * @param {Function} cb Callback
       * @public
       */
      handleUpgrade (req, socket, head, cb) {
        socket.on('error', socketError);

        const version = +req.headers['sec-websocket-version'];
        const extensions = {};

        if (
          req.method !== 'GET' || req.headers.upgrade.toLowerCase() !== 'websocket' ||
          !req.headers['sec-websocket-key'] || (version !== 8 && version !== 13) ||
          !this.shouldHandle(req)
        ) {
          return abortConnection(socket, 400);
        }

        if (this.options.perMessageDeflate) {
          const perMessageDeflate = new PerMessageDeflate_1(
            this.options.perMessageDeflate,
            true,
            this.options.maxPayload
          );

          try {
            const offers = Extensions.parse(
              req.headers['sec-websocket-extensions']
            );

            if (offers[PerMessageDeflate_1.extensionName]) {
              perMessageDeflate.accept(offers[PerMessageDeflate_1.extensionName]);
              extensions[PerMessageDeflate_1.extensionName] = perMessageDeflate;
            }
          } catch (err) {
            return abortConnection(socket, 400);
          }
        }

        var protocol = (req.headers['sec-websocket-protocol'] || '').split(/, */);

        //
        // Optionally call external protocol selection handler.
        //
        if (this.options.handleProtocols) {
          protocol = this.options.handleProtocols(protocol, req);
          if (protocol === false) return abortConnection(socket, 401);
        } else {
          protocol = protocol[0];
        }

        //
        // Optionally call external client verification handler.
        //
        if (this.options.verifyClient) {
          const info = {
            origin: req.headers[`${version === 8 ? 'sec-websocket-origin' : 'origin'}`],
            secure: !!(req.connection.authorized || req.connection.encrypted),
            req
          };

          if (this.options.verifyClient.length === 2) {
            this.options.verifyClient(info, (verified, code, message) => {
              if (!verified) return abortConnection(socket, code || 401, message);

              this.completeUpgrade(
                protocol,
                extensions,
                version,
                req,
                socket,
                head,
                cb
              );
            });
            return;
          }

          if (!this.options.verifyClient(info)) return abortConnection(socket, 401);
        }

        this.completeUpgrade(protocol, extensions, version, req, socket, head, cb);
      }

      /**
       * Upgrade the connection to WebSocket.
       *
       * @param {String} protocol The chosen subprotocol
       * @param {Object} extensions The accepted extensions
       * @param {Number} version The WebSocket protocol version
       * @param {http.IncomingMessage} req The request object
       * @param {net.Socket} socket The network socket between the server and client
       * @param {Buffer} head The first packet of the upgraded stream
       * @param {Function} cb Callback
       * @private
       */
      completeUpgrade (protocol, extensions, version, req, socket, head, cb) {
        //
        // Destroy the socket if the client has already sent a FIN packet.
        //
        if (!socket.readable || !socket.writable) return socket.destroy();

        const key = fs.createHash('sha1')
          .update(req.headers['sec-websocket-key'] + Constants.GUID, 'binary')
          .digest('base64');

        const headers = [
          'HTTP/1.1 101 Switching Protocols',
          'Upgrade: websocket',
          'Connection: Upgrade',
          `Sec-WebSocket-Accept: ${key}`
        ];

        if (protocol) headers.push(`Sec-WebSocket-Protocol: ${protocol}`);
        if (extensions[PerMessageDeflate_1.extensionName]) {
          const params = extensions[PerMessageDeflate_1.extensionName].params;
          const value = Extensions.format({
            [PerMessageDeflate_1.extensionName]: [params]
          });
          headers.push(`Sec-WebSocket-Extensions: ${value}`);
        }

        //
        // Allow external modification/inspection of handshake headers.
        //
        this.emit('headers', headers, req);

        socket.write(headers.concat('\r\n').join('\r\n'));

        const client = new WebSocket_1([socket, head], null, {
          maxPayload: this.options.maxPayload,
          protocolVersion: version,
          extensions,
          protocol
        });

        if (this.clients) {
          this.clients.add(client);
          client.on('close', () => this.clients.delete(client));
        }

        socket.removeListener('error', socketError);
        cb(client);
      }
    }

    var WebSocketServer_1 = WebSocketServer;

    /**
     * Handle premature socket errors.
     *
     * @private
     */
    function socketError () {
      this.destroy();
    }

    /**
     * Close the connection when preconditions are not fulfilled.
     *
     * @param {net.Socket} socket The socket of the upgrade request
     * @param {Number} code The HTTP response status code
     * @param {String} [message] The HTTP response body
     * @private
     */
    function abortConnection (socket, code, message) {
      if (socket.writable) {
        message = message || http.STATUS_CODES[code];
        socket.write(
          `HTTP/1.1 ${code} ${http.STATUS_CODES[code]}\r\n` +
          'Connection: close\r\n' +
          'Content-type: text/html\r\n' +
          `Content-Length: ${Buffer$d.byteLength(message)}\r\n` +
          '\r\n' +
          message
        );
      }

      socket.removeListener('error', socketError);
      socket.destroy();
    }

    WebSocket_1.Server = WebSocketServer_1;
    WebSocket_1.Receiver = Receiver_1;
    WebSocket_1.Sender = Sender_1;

    var ws = WebSocket_1;

    var Transform$4 = readable.Transform;


    var Buffer$e = safeBuffer$1.Buffer;

    var stream$3 = WebSocketStream;

    function buildProxy$2 (options, socketWrite, socketEnd) {
      var proxy = new Transform$4({
        objectMode: options.objectMode
      });

      proxy._write = socketWrite;
      proxy._flush = socketEnd;

      return proxy
    }

    function WebSocketStream(target, protocols, options) {
      var stream, socket;

      var isBrowser = process.title === 'browser';
      var isNative = !!commonjsGlobal.WebSocket;
      var socketWrite = isBrowser ? socketWriteBrowser : socketWriteNode;

      if (protocols && !Array.isArray(protocols) && 'object' === typeof protocols) {
        // accept the "options" Object as the 2nd argument
        options = protocols;
        protocols = null;

        if (typeof options.protocol === 'string' || Array.isArray(options.protocol)) {
          protocols = options.protocol;
        }
      }

      if (!options) options = {};

      if (options.objectMode === undefined) {
        options.objectMode = !(options.binary === true || options.binary === undefined);
      }

      var proxy = buildProxy$2(options, socketWrite, socketEnd);

      if (!options.objectMode) {
        proxy._writev = writev;
      }

      // browser only: sets the maximum socket buffer size before throttling
      var bufferSize = options.browserBufferSize || 1024 * 512;

      // browser only: how long to wait when throttling
      var bufferTimeout = options.browserBufferTimeout || 1000;

      // use existing WebSocket object that was passed in
      if (typeof target === 'object') {
        socket = target;
      // otherwise make a new one
      } else {
        // special constructor treatment for native websockets in browsers, see
        // https://github.com/maxogden/websocket-stream/issues/82
        if (isNative && isBrowser) {
          socket = new ws(target, protocols);
        } else {
          socket = new ws(target, protocols, options);
        }

        socket.binaryType = 'arraybuffer';
      }

      // was already open when passed in
      if (socket.readyState === socket.OPEN) {
        stream = proxy;
      } else {
        stream = stream = duplexify(undefined, undefined, options);
        if (!options.objectMode) {
          stream._writev = writev;
        }
        socket.onopen = onopen;
      }

      stream.socket = socket;

      socket.onclose = onclose;
      socket.onerror = onerror;
      socket.onmessage = onmessage;

      proxy.on('close', destroy);

      var coerceToBuffer = !options.objectMode;

      function socketWriteNode(chunk, enc, next) {
        // avoid errors, this never happens unless
        // destroy() is called
        if (socket.readyState !== socket.OPEN) {
          next();
          return
        }

        if (coerceToBuffer && typeof chunk === 'string') {
          chunk = Buffer$e.from(chunk, 'utf8');
        }
        socket.send(chunk, next);
      }

      function socketWriteBrowser(chunk, enc, next) {
        if (socket.bufferedAmount > bufferSize) {
          setTimeout(socketWriteBrowser, bufferTimeout, chunk, enc, next);
          return
        }

        if (coerceToBuffer && typeof chunk === 'string') {
          chunk = Buffer$e.from(chunk, 'utf8');
        }

        try {
          socket.send(chunk);
        } catch(err) {
          return next(err)
        }

        next();
      }

      function socketEnd(done) {
        socket.close();
        done();
      }

      function onopen() {
        stream.setReadable(proxy);
        stream.setWritable(proxy);
        stream.emit('connect');
      }

      function onclose() {
        stream.end();
        stream.destroy();
      }

      function onerror(err) {
        stream.destroy(err);
      }

      function onmessage(event) {
        var data = event.data;
        if (data instanceof ArrayBuffer) data = Buffer$e.from(data);
        else data = Buffer$e.from(data, 'utf8');
        proxy.push(data);
      }

      function destroy() {
        socket.close();
      }

      // this is to be enabled only if objectMode is false
      function writev (chunks, cb) {
        var buffers = new Array(chunks.length);
        for (var i = 0; i < chunks.length; i++) {
          if (typeof chunks[i].chunk === 'string') {
            buffers[i] = Buffer$e.from(chunks[i], 'utf8');
          } else {
            buffers[i] = chunks[i].chunk;
          }
        }

        this._write(Buffer$e.concat(buffers), 'binary', cb);
      }

      return stream
    }

    var WebSocketServer$1 = ws.Server;


    class Server extends WebSocketServer$1{
      constructor(opts, cb) {
        super(opts);

        var proxied = false;
        this.on('newListener', function(event) {
          if (!proxied && event === 'stream') {
            proxied = true;
            this.on('connection', function(conn, req) {
              this.emit('stream', stream$3(conn, opts), req);
            });
          }
        });

        if (cb) {
          this.on('stream', cb);
        }
      }
    }

    var Server_1 = Server;
    var createServer = function(opts, cb) {
      return new Server(opts, cb)
    };

    var server = {
    	Server: Server_1,
    	createServer: createServer
    };

    var websocketStream = stream$3;
    var Server$1 = server.Server;
    var createServer$1 = server.createServer;
    websocketStream.Server = Server$1;
    websocketStream.createServer = createServer$1;

    var ws$1 = createCommonjsModule(function (module) {



    var WSS_OPTIONS = [
      'rejectUnauthorized',
      'ca',
      'cert',
      'key',
      'pfx',
      'passphrase'
    ];
    var IS_BROWSER = process.title === 'browser';

    function buildUrl (opts, client) {
      var url = opts.protocol + '://' + opts.hostname + ':' + opts.port + opts.path;
      if (typeof (opts.transformWsUrl) === 'function') {
        url = opts.transformWsUrl(url, opts, client);
      }
      return url
    }

    function setDefaultOpts (opts) {
      if (!opts.hostname) {
        opts.hostname = 'localhost';
      }
      if (!opts.port) {
        if (opts.protocol === 'wss') {
          opts.port = 443;
        } else {
          opts.port = 80;
        }
      }
      if (!opts.path) {
        opts.path = '/';
      }

      if (!opts.wsOptions) {
        opts.wsOptions = {};
      }
      if (!IS_BROWSER && opts.protocol === 'wss') {
        // Add cert/key/ca etc options
        WSS_OPTIONS.forEach(function (prop) {
          if (opts.hasOwnProperty(prop) && !opts.wsOptions.hasOwnProperty(prop)) {
            opts.wsOptions[prop] = opts[prop];
          }
        });
      }
    }

    function createWebSocket (client, opts) {
      var websocketSubProtocol =
        (opts.protocolId === 'MQIsdp') && (opts.protocolVersion === 3)
          ? 'mqttv3.1'
          : 'mqtt';

      setDefaultOpts(opts);
      var url = buildUrl(opts, client);
      return websocketStream(url, [websocketSubProtocol], opts.wsOptions)
    }

    function buildBuilder (client, opts) {
      return createWebSocket(client, opts)
    }

    function buildBuilderBrowser (client, opts) {
      if (!opts.hostname) {
        opts.hostname = opts.host;
      }

      if (!opts.hostname) {
        // Throwing an error in a Web Worker if no `hostname` is given, because we
        // can not determine the `hostname` automatically.  If connecting to
        // localhost, please supply the `hostname` as an argument.
        if (typeof (document) === 'undefined') {
          throw new Error('Could not determine host. Specify host manually.')
        }
        var parsed = url.parse(document.URL);
        opts.hostname = parsed.hostname;

        if (!opts.port) {
          opts.port = parsed.port;
        }
      }
      return createWebSocket(client, opts)
    }

    if (IS_BROWSER) {
      module.exports = buildBuilderBrowser;
    } else {
      module.exports = buildBuilder;
    }
    });

    var protocols = {};

    if (process.title !== 'browser') {
      protocols.mqtt = tcp;
      protocols.tcp = tcp;
      protocols.ssl = tls_1;
      protocols.tls = tls_1;
      protocols.mqtts = tls_1;
    } else {
      protocols.wx = wx_1;
      protocols.wxs = wx_1;

      protocols.ali = ali;
      protocols.alis = ali;
    }

    protocols.ws = ws$1;
    protocols.wss = ws$1;

    /**
     * Parse the auth attribute and merge username and password in the options object.
     *
     * @param {Object} [opts] option object
     */
    function parseAuthOptions (opts) {
      var matches;
      if (opts.auth) {
        matches = opts.auth.match(/^(.+):(.+)$/);
        if (matches) {
          opts.username = matches[1];
          opts.password = matches[2];
        } else {
          opts.username = opts.auth;
        }
      }
    }

    /**
     * connect - connect to an MQTT broker.
     *
     * @param {String} [brokerUrl] - url of the broker, optional
     * @param {Object} opts - see MqttClient#constructor
     */
    function connect$1 (brokerUrl, opts) {
      if ((typeof brokerUrl === 'object') && !opts) {
        opts = brokerUrl;
        brokerUrl = null;
      }

      opts = opts || {};

      if (brokerUrl) {
        var parsed = url.parse(brokerUrl, true);
        if (parsed.port != null) {
          parsed.port = Number(parsed.port);
        }

        opts = immutable(parsed, opts);

        if (opts.protocol === null) {
          throw new Error('Missing protocol')
        }
        opts.protocol = opts.protocol.replace(/:$/, '');
      }

      // merge in the auth options if supplied
      parseAuthOptions(opts);

      // support clientId passed in the query string of the url
      if (opts.query && typeof opts.query.clientId === 'string') {
        opts.clientId = opts.query.clientId;
      }

      if (opts.cert && opts.key) {
        if (opts.protocol) {
          if (['mqtts', 'wss', 'wxs', 'alis'].indexOf(opts.protocol) === -1) {
            switch (opts.protocol) {
              case 'mqtt':
                opts.protocol = 'mqtts';
                break
              case 'ws':
                opts.protocol = 'wss';
                break
              case 'wx':
                opts.protocol = 'wxs';
                break
              case 'ali':
                opts.protocol = 'alis';
                break
              default:
                throw new Error('Unknown protocol for secure connection: "' + opts.protocol + '"!')
            }
          }
        } else {
          // don't know what protocol he want to use, mqtts or wss
          throw new Error('Missing secure protocol key')
        }
      }

      if (!protocols[opts.protocol]) {
        var isSecure = ['mqtts', 'wss'].indexOf(opts.protocol) !== -1;
        opts.protocol = [
          'mqtt',
          'mqtts',
          'ws',
          'wss',
          'wx',
          'wxs',
          'ali',
          'alis'
        ].filter(function (key, index) {
          if (isSecure && index % 2 === 0) {
            // Skip insecure protocols when requesting a secure one.
            return false
          }
          return (typeof protocols[key] === 'function')
        })[0];
      }

      if (opts.clean === false && !opts.clientId) {
        throw new Error('Missing clientId for unclean clients')
      }

      if (opts.protocol) {
        opts.defaultProtocol = opts.protocol;
      }

      function wrapper (client) {
        if (opts.servers) {
          if (!client._reconnectCount || client._reconnectCount === opts.servers.length) {
            client._reconnectCount = 0;
          }

          opts.host = opts.servers[client._reconnectCount].host;
          opts.port = opts.servers[client._reconnectCount].port;
          opts.protocol = (!opts.servers[client._reconnectCount].protocol ? opts.defaultProtocol : opts.servers[client._reconnectCount].protocol);
          opts.hostname = opts.host;

          client._reconnectCount++;
        }

        return protocols[opts.protocol](client, opts)
      }

      return new client(wrapper, opts)
    }

    var connect_1 = connect$1;
    var connect_2 = connect$1;
    var MqttClient_1 = client;
    var Store_1 = store;
    connect_1.connect = connect_2;
    connect_1.MqttClient = MqttClient_1;
    connect_1.Store = Store_1;

    /* eslint-disable no-nested-ternary */
    var arr = [];
    var charCodeCache = [];

    var leven = function (a, b) {
    	if (a === b) {
    		return 0;
    	}

    	var swap = a;

    	// Swapping the strings if `a` is longer than `b` so we know which one is the
    	// shortest & which one is the longest
    	if (a.length > b.length) {
    		a = b;
    		b = swap;
    	}

    	var aLen = a.length;
    	var bLen = b.length;

    	if (aLen === 0) {
    		return bLen;
    	}

    	if (bLen === 0) {
    		return aLen;
    	}

    	// Performing suffix trimming:
    	// We can linearly drop suffix common to both strings since they
    	// don't increase distance at all
    	// Note: `~-` is the bitwise way to perform a `- 1` operation
    	while (aLen > 0 && (a.charCodeAt(~-aLen) === b.charCodeAt(~-bLen))) {
    		aLen--;
    		bLen--;
    	}

    	if (aLen === 0) {
    		return bLen;
    	}

    	// Performing prefix trimming
    	// We can linearly drop prefix common to both strings since they
    	// don't increase distance at all
    	var start = 0;

    	while (start < aLen && (a.charCodeAt(start) === b.charCodeAt(start))) {
    		start++;
    	}

    	aLen -= start;
    	bLen -= start;

    	if (aLen === 0) {
    		return bLen;
    	}

    	var bCharCode;
    	var ret;
    	var tmp;
    	var tmp2;
    	var i = 0;
    	var j = 0;

    	while (i < aLen) {
    		charCodeCache[start + i] = a.charCodeAt(start + i);
    		arr[i] = ++i;
    	}

    	while (j < bLen) {
    		bCharCode = b.charCodeAt(start + j);
    		tmp = j++;
    		ret = j;

    		for (i = 0; i < aLen; i++) {
    			tmp2 = bCharCode === charCodeCache[start + i] ? tmp : tmp + 1;
    			tmp = arr[i];
    			ret = arr[i] = tmp > ret ? tmp2 > ret ? ret + 1 : tmp2 : tmp2 > tmp ? tmp + 1 : tmp2;
    		}
    	}

    	return ret;
    };

    function commist () {
      var commands = [];

      function lookup (array) {
        if (typeof array === 'string') { array = array.split(' '); }

        return commands.map(function (cmd) {
          return cmd.match(array)
        }).filter(function (match) {
          return match.partsNotMatched === 0
        }).sort(function (a, b) {
          if (a.inputNotMatched > b.inputNotMatched) { return 1 }

          if (a.inputNotMatched === b.inputNotMatched && a.totalDistance > b.totalDistance) { return 1 }

          return -1
        }).map(function (match) {
          return match.cmd
        })
      }

      function parse (args) {
        var matching = lookup(args);

        if (matching.length > 0) {
          matching[0].call(args);

          // return null if there is nothing left to do
          return null
        }

        return args
      }

      function register (inputCommand, func) {
        var commandOptions = {
          command: inputCommand,
          strict: false,
          func: func
        };

        if (typeof inputCommand === 'object') {
          commandOptions = Object.assign(commandOptions, inputCommand);
        }

        var matching = lookup(commandOptions.command);

        matching.forEach(function (match) {
          if (match.string === commandOptions.command) { throw new Error('command already registered: ' + commandOptions.command) }
        });

        commands.push(new Command(commandOptions));

        return this
      }

      return {
        register: register,
        parse: parse,
        lookup: lookup
      }
    }

    function Command (options) {
      this.string = options.command;
      this.strict = options.strict;
      this.parts = this.string.split(' ');
      this.length = this.parts.length;
      this.func = options.func;

      this.parts.forEach(function (part) {
        if (part.length < 3) { throw new Error('command words must be at least 3 chars: ' + options.command) }
      });
    }

    Command.prototype.call = function call (argv) {
      this.func(argv.slice(this.length));
    };

    Command.prototype.match = function match (string) {
      return new CommandMatch(this, string)
    };

    function CommandMatch (cmd, array) {
      this.cmd = cmd;
      this.distances = cmd.parts.map(function (elem, i) {
        if (array[i] !== undefined) {
          if (cmd.strict) {
            return elem === array[i] ? 0 : undefined
          } else {
            return leven(elem, array[i])
          }
        } else { return undefined }
      }).filter(function (distance, i) {
        return distance !== undefined && distance < cmd.parts[i].length - 2
      });

      this.partsNotMatched = cmd.length - this.distances.length;
      this.inputNotMatched = array.length - this.distances.length;
      this.totalDistance = this.distances.reduce(function (acc, i) { return acc + i }, 0);
    }

    var commist_1 = commist;

    // Copyright Joyent, Inc. and other Node contributors.
    //
    // Permission is hereby granted, free of charge, to any person obtaining a
    // copy of this software and associated documentation files (the
    // "Software"), to deal in the Software without restriction, including
    // without limitation the rights to use, copy, modify, merge, publish,
    // distribute, sublicense, and/or sell copies of the Software, and to permit
    // persons to whom the Software is furnished to do so, subject to the
    // following conditions:
    //
    // The above copyright notice and this permission notice shall be included
    // in all copies or substantial portions of the Software.
    //
    // THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
    // OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
    // MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN
    // NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
    // DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
    // OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
    // USE OR OTHER DEALINGS IN THE SOFTWARE.

    // resolves . and .. elements in a path array with directory names there
    // must be no slashes, empty elements, or device names (c:\) in the array
    // (so also no leading and trailing slashes - it does not distinguish
    // relative and absolute paths)
    function normalizeArray(parts, allowAboveRoot) {
      // if the path tries to go above the root, `up` ends up > 0
      var up = 0;
      for (var i = parts.length - 1; i >= 0; i--) {
        var last = parts[i];
        if (last === '.') {
          parts.splice(i, 1);
        } else if (last === '..') {
          parts.splice(i, 1);
          up++;
        } else if (up) {
          parts.splice(i, 1);
          up--;
        }
      }

      // if the path is allowed to go above the root, restore leading ..s
      if (allowAboveRoot) {
        for (; up--; up) {
          parts.unshift('..');
        }
      }

      return parts;
    }

    // Split a filename into [root, dir, basename, ext], unix version
    // 'root' is just a slash, or nothing.
    var splitPathRe =
        /^(\/?|)([\s\S]*?)((?:\.{1,2}|[^\/]+?|)(\.[^.\/]*|))(?:[\/]*)$/;
    var splitPath = function(filename) {
      return splitPathRe.exec(filename).slice(1);
    };

    // path.resolve([from ...], to)
    // posix version
    function resolve() {
      var resolvedPath = '',
          resolvedAbsolute = false;

      for (var i = arguments.length - 1; i >= -1 && !resolvedAbsolute; i--) {
        var path = (i >= 0) ? arguments[i] : '/';

        // Skip empty and invalid entries
        if (typeof path !== 'string') {
          throw new TypeError('Arguments to path.resolve must be strings');
        } else if (!path) {
          continue;
        }

        resolvedPath = path + '/' + resolvedPath;
        resolvedAbsolute = path.charAt(0) === '/';
      }

      // At this point the path should be resolved to a full absolute path, but
      // handle relative paths to be safe (might happen when process.cwd() fails)

      // Normalize the path
      resolvedPath = normalizeArray(filter$1(resolvedPath.split('/'), function(p) {
        return !!p;
      }), !resolvedAbsolute).join('/');

      return ((resolvedAbsolute ? '/' : '') + resolvedPath) || '.';
    }
    // path.normalize(path)
    // posix version
    function normalize(path) {
      var isPathAbsolute = isAbsolute(path),
          trailingSlash = substr(path, -1) === '/';

      // Normalize the path
      path = normalizeArray(filter$1(path.split('/'), function(p) {
        return !!p;
      }), !isPathAbsolute).join('/');

      if (!path && !isPathAbsolute) {
        path = '.';
      }
      if (path && trailingSlash) {
        path += '/';
      }

      return (isPathAbsolute ? '/' : '') + path;
    }
    // posix version
    function isAbsolute(path) {
      return path.charAt(0) === '/';
    }

    // posix version
    function join() {
      var paths = Array.prototype.slice.call(arguments, 0);
      return normalize(filter$1(paths, function(p, index) {
        if (typeof p !== 'string') {
          throw new TypeError('Arguments to path.join must be strings');
        }
        return p;
      }).join('/'));
    }


    // path.relative(from, to)
    // posix version
    function relative(from, to) {
      from = resolve(from).substr(1);
      to = resolve(to).substr(1);

      function trim(arr) {
        var start = 0;
        for (; start < arr.length; start++) {
          if (arr[start] !== '') break;
        }

        var end = arr.length - 1;
        for (; end >= 0; end--) {
          if (arr[end] !== '') break;
        }

        if (start > end) return [];
        return arr.slice(start, end - start + 1);
      }

      var fromParts = trim(from.split('/'));
      var toParts = trim(to.split('/'));

      var length = Math.min(fromParts.length, toParts.length);
      var samePartsLength = length;
      for (var i = 0; i < length; i++) {
        if (fromParts[i] !== toParts[i]) {
          samePartsLength = i;
          break;
        }
      }

      var outputParts = [];
      for (var i = samePartsLength; i < fromParts.length; i++) {
        outputParts.push('..');
      }

      outputParts = outputParts.concat(toParts.slice(samePartsLength));

      return outputParts.join('/');
    }

    var sep = '/';
    var delimiter$1 = ':';

    function dirname(path) {
      var result = splitPath(path),
          root = result[0],
          dir = result[1];

      if (!root && !dir) {
        // No dirname whatsoever
        return '.';
      }

      if (dir) {
        // It has a dirname, strip trailing slash
        dir = dir.substr(0, dir.length - 1);
      }

      return root + dir;
    }

    function basename(path, ext) {
      var f = splitPath(path)[2];
      // TODO: make this comparison case-insensitive on windows?
      if (ext && f.substr(-1 * ext.length) === ext) {
        f = f.substr(0, f.length - ext.length);
      }
      return f;
    }


    function extname(path) {
      return splitPath(path)[3];
    }
    var path = {
      extname: extname,
      basename: basename,
      dirname: dirname,
      sep: sep,
      delimiter: delimiter$1,
      relative: relative,
      join: join,
      isAbsolute: isAbsolute,
      normalize: normalize,
      resolve: resolve
    };
    function filter$1 (xs, f) {
        if (xs.filter) return xs.filter(f);
        var res = [];
        for (var i = 0; i < xs.length; i++) {
            if (f(xs[i], i, xs)) res.push(xs[i]);
        }
        return res;
    }

    // String.prototype.substr - negative index don't work in IE8
    var substr = 'ab'.substr(-1) === 'b' ?
        function (str, start, len) { return str.substr(start, len) } :
        function (str, start, len) {
            if (start < 0) start = str.length + start;
            return str.substr(start, len);
        }
    ;

    var Transform$5 = readable.Transform
      , inherits$3  = debugUtil.inherits;

    function DestroyableTransform(opts) {
      Transform$5.call(this, opts);
      this._destroyed = false;
    }

    inherits$3(DestroyableTransform, Transform$5);

    DestroyableTransform.prototype.destroy = function(err) {
      if (this._destroyed) return
      this._destroyed = true;
      
      var self = this;
      process.nextTick(function() {
        if (err)
          self.emit('error', err);
        self.emit('close');
      });
    };

    // a noop _transform function
    function noop$3 (chunk, enc, callback) {
      callback(null, chunk);
    }


    // create a new export function, used by both the main export and
    // the .ctor export, contains common logic for dealing with arguments
    function through2 (construct) {
      return function (options, transform, flush) {
        if (typeof options == 'function') {
          flush     = transform;
          transform = options;
          options   = {};
        }

        if (typeof transform != 'function')
          transform = noop$3;

        if (typeof flush != 'function')
          flush = null;

        return construct(options, transform, flush)
      }
    }


    // main export, just make me a transform stream!
    var through2_1 = through2(function (options, transform, flush) {
      var t2 = new DestroyableTransform(options);

      t2._transform = transform;

      if (flush)
        t2._flush = flush;

      return t2
    });


    // make me a reusable prototype that I can `new`, or implicitly `new`
    // with a constructor call
    var ctor = through2(function (options, transform, flush) {
      function Through2 (override) {
        if (!(this instanceof Through2))
          return new Through2(override)

        this.options = immutable(options, override);

        DestroyableTransform.call(this, this.options);
      }

      inherits$3(Through2, DestroyableTransform);

      Through2.prototype._transform = transform;

      if (flush)
        Through2.prototype._flush = flush;

      return Through2
    });


    var obj = through2(function (options, transform, flush) {
      var t2 = new DestroyableTransform(immutable({ objectMode: true, highWaterMark: 16 }, options));

      t2._transform = transform;

      if (flush)
        t2._flush = flush;

      return t2
    });
    through2_1.ctor = ctor;
    through2_1.obj = obj;

    function isReadable(stream) {
      if (typeof stream.pipe !== 'function') {
        return false;
      }

      if (!stream.readable) {
        return false;
      }

      if (typeof stream._read !== 'function') {
        return false;
      }

      if (!stream._readableState) {
        return false;
      }

      return true;
    }

    function addStream (streams, stream) {
      if (!isReadable(stream)) {
        throw new Error('All input streams must be readable');
      }

      var self = this;

      stream._buffer = [];

      stream.on('readable', function () {
        var chunk = stream.read();
        while (chunk) {
          if (this === streams[0]) {
            self.push(chunk);
          } else {
            this._buffer.push(chunk);
          }
          chunk = stream.read();
        }
      });

      stream.on('end', function () {
        for (var stream = streams[0];
          stream && stream._readableState.ended;
          stream = streams[0]) {
          while (stream._buffer.length) {
            self.push(stream._buffer.shift());
          }

          streams.shift();
        }

        if (!streams.length) {
          self.push(null);
        }
      });

      stream.on('error', this.emit.bind(this, 'error'));

      streams.push(stream);
    }

    function OrderedStreams (streams, options) {
      if (!(this instanceof(OrderedStreams))) {
        return new OrderedStreams(streams, options);
      }

      streams = streams || [];
      options = options || {};

      options.objectMode = true;

      readable.call(this, options);

      if (!Array.isArray(streams)) {
        streams = [streams];
      }
      if (!streams.length) {
        return this.push(null);  // no streams, close
      }

      var addStreamBinded = addStream.bind(this, []);

      streams.forEach(function (item) {
        if (Array.isArray(item)) {
          item.forEach(addStreamBinded);
        } else {
          addStreamBinded(item);
        }
      });
    }
    debugUtil.inherits(OrderedStreams, readable);

    OrderedStreams.prototype._read = function () {};

    var orderedReadStreams = OrderedStreams;

    var through2Filter = make;
    var ctor_1 = ctor$1;
    var objCtor_1 = objCtor;
    var obj_1 = obj$1;




    function ctor$1(options, fn) {
      if (typeof options == "function") {
        fn = options;
        options = {};
      }

      var Filter = through2_1.ctor(options, function (chunk, encoding, callback) {
        if (this.options.wantStrings) chunk = chunk.toString();
        try {
          if (fn.call(this, chunk, this._index++)) this.push(chunk);
          return callback()
        } catch (e) {
          return callback(e)
        }
      });
      Filter.prototype._index = 0;
      return Filter
    }

    function objCtor(options, fn) {
      if (typeof options === "function") {
        fn = options;
        options = {};
      }
      options = immutable({objectMode: true, highWaterMark: 16}, options);
      return ctor$1(options, fn)
    }

    function make(options, fn) {
      return ctor$1(options, fn)()
    }

    function obj$1(options, fn) {
      if (typeof options === "function") {
        fn = options;
        options = {};
      }
      options = immutable({objectMode: true, highWaterMark: 16}, options);
      return make(options, fn)
    }
    through2Filter.ctor = ctor_1;
    through2Filter.objCtor = objCtor_1;
    through2Filter.obj = obj_1;

    var jsonStableStringifyWithoutJsonify = function (obj, opts) {
        if (!opts) opts = {};
        if (typeof opts === 'function') opts = { cmp: opts };
        var space = opts.space || '';
        if (typeof space === 'number') space = Array(space+1).join(' ');
        var cycles = (typeof opts.cycles === 'boolean') ? opts.cycles : false;
        var replacer = opts.replacer || function(key, value) { return value; };

        var cmp = opts.cmp && (function (f) {
            return function (node) {
                return function (a, b) {
                    var aobj = { key: a, value: node[a] };
                    var bobj = { key: b, value: node[b] };
                    return f(aobj, bobj);
                };
            };
        })(opts.cmp);

        var seen = [];
        return (function stringify (parent, key, node, level) {
            var indent = space ? ('\n' + new Array(level + 1).join(space)) : '';
            var colonSeparator = space ? ': ' : ':';

            if (node && node.toJSON && typeof node.toJSON === 'function') {
                node = node.toJSON();
            }

            node = replacer.call(parent, key, node);

            if (node === undefined) {
                return;
            }
            if (typeof node !== 'object' || node === null) {
                return JSON.stringify(node);
            }
            if (isArray$9(node)) {
                var out = [];
                for (var i = 0; i < node.length; i++) {
                    var item = stringify(node, i, node[i], level+1) || JSON.stringify(null);
                    out.push(indent + space + item);
                }
                return '[' + out.join(',') + indent + ']';
            }
            else {
                if (seen.indexOf(node) !== -1) {
                    if (cycles) return JSON.stringify('__cycle__');
                    throw new TypeError('Converting circular structure to JSON');
                }
                else seen.push(node);

                var keys = objectKeys$2(node).sort(cmp && cmp(node));
                var out = [];
                for (var i = 0; i < keys.length; i++) {
                    var key = keys[i];
                    var value = stringify(node, key, node[key], level+1);

                    if(!value) continue;

                    var keyValue = JSON.stringify(key)
                        + colonSeparator
                        + value;
                    out.push(indent + space + keyValue);
                }
                seen.splice(seen.indexOf(node), 1);
                return '{' + out.join(',') + indent + '}';
            }
        })({ '': obj }, '', obj, 0);
    };

    var isArray$9 = Array.isArray || function (x) {
        return {}.toString.call(x) === '[object Array]';
    };

    var objectKeys$2 = Object.keys || function (obj) {
        var has = Object.prototype.hasOwnProperty || function () { return true };
        var keys = [];
        for (var key in obj) {
            if (has.call(obj, key)) keys.push(key);
        }
        return keys;
    };

    var filter$2 = through2Filter.obj;


    var ES6Set;
    if (typeof commonjsGlobal.Set === 'function') {
      ES6Set = commonjsGlobal.Set;
    } else {
      ES6Set = function() {
        this.keys = [];
        this.has = function(val) {
          return this.keys.indexOf(val) !== -1;
        },
        this.add = function(val) {
          this.keys.push(val);
        };
      };
    }

    function prop(propName) {
      return function (data) {
        return data[propName];
      };
    }

    var uniqueStream = unique;
    function unique(propName, keyStore) {
      keyStore = keyStore || new ES6Set();

      var keyfn = jsonStableStringifyWithoutJsonify;
      if (typeof propName === 'string') {
        keyfn = prop(propName);
      } else if (typeof propName === 'function') {
        keyfn = propName;
      }

      return filter$2(function (data) {
        var key = keyfn(data);

        if (keyStore.has(key)) {
          return false;
        }

        keyStore.add(key);
        return true;
      });
    }

    // we only need fs to get the ReadStream and WriteStream prototypes

    var noop$4 = function () {};
    var ancient = /^v?\.0/.test(process.version);

    var isFn = function (fn) {
      return typeof fn === 'function'
    };

    var isFS = function (stream) {
      if (!ancient) return false // newer node version do not need to care about fs is a special way
      if (!fs) return false // browser
      return (stream instanceof (fs.ReadStream || noop$4) || stream instanceof (fs.WriteStream || noop$4)) && isFn(stream.close)
    };

    var isRequest$1 = function (stream) {
      return stream.setHeader && isFn(stream.abort)
    };

    var destroyer$1 = function (stream, reading, writing, callback) {
      callback = once_1(callback);

      var closed = false;
      stream.on('close', function () {
        closed = true;
      });

      endOfStream(stream, {readable: reading, writable: writing}, function (err) {
        if (err) return callback(err)
        closed = true;
        callback();
      });

      var destroyed = false;
      return function (err) {
        if (closed) return
        if (destroyed) return
        destroyed = true;

        if (isFS(stream)) return stream.close(noop$4) // use close for fs streams to avoid fd leaks
        if (isRequest$1(stream)) return stream.abort() // request.destroy just do .end - .abort is what we want

        if (isFn(stream.destroy)) return stream.destroy()

        callback(err || new Error('stream was destroyed'));
      }
    };

    var call$5 = function (fn) {
      fn();
    };

    var pipe = function (from, to) {
      return from.pipe(to)
    };

    var pump = function () {
      var streams = Array.prototype.slice.call(arguments);
      var callback = isFn(streams[streams.length - 1] || noop$4) && streams.pop() || noop$4;

      if (Array.isArray(streams[0])) streams = streams[0];
      if (streams.length < 2) throw new Error('pump requires two streams per minimum')

      var error;
      var destroys = streams.map(function (stream, i) {
        var reading = i < streams.length - 1;
        var writing = i > 0;
        return destroyer$1(stream, reading, writing, function (err) {
          if (!error) error = err;
          if (err) destroys.forEach(call$5);
          if (reading) return
          destroys.forEach(call$5);
          callback(error);
        })
      });

      streams.reduce(pipe);
    };

    var pump_1 = pump;

    var toArray = function(args) {
      if (!args.length) return []
      return Array.isArray(args[0]) ? args[0] : Array.prototype.slice.call(args)
    };

    var define$1 = function(opts) {
      var Pumpify = function() {
        var streams = toArray(arguments);
        if (!(this instanceof Pumpify)) return new Pumpify(streams)
        duplexify.call(this, null, null, opts);
        if (streams.length) this.setPipeline(streams);
      };

      inherits$2(Pumpify, duplexify);

      Pumpify.prototype.setPipeline = function() {
        var streams = toArray(arguments);
        var self = this;
        var ended = false;
        var w = streams[0];
        var r = streams[streams.length-1];

        r = r.readable ? r : null;
        w = w.writable ? w : null;

        var onclose = function() {
          streams[0].emit('error', new Error('stream was destroyed'));
        };

        this.on('close', onclose);
        this.on('prefinish', function() {
          if (!ended) self.cork();
        });

        pump_1(streams, function(err) {
          self.removeListener('close', onclose);
          if (err) return self.destroy(err.message === 'premature close' ? null : err)
          ended = true;
          // pump ends after the last stream is not writable *but*
          // pumpify still forwards the readable part so we need to catch errors
          // still, so reenable autoDestroy in this case
          if (self._autoDestroy === false) self._autoDestroy = true;
          self.uncork();
        });

        if (this.destroyed) return onclose()
        this.setWritable(w);
        this.setReadable(r);
      };

      return Pumpify
    };

    var pumpify = define$1({autoDestroy:false, destroy:false});
    var obj$2 = define$1({autoDestroy: false, destroy:false, objectMode:true, highWaterMark:16});
    var ctor$2 = define$1;
    pumpify.obj = obj$2;
    pumpify.ctor = ctor$2;

    var isNegatedGlob = function(pattern) {
      if (typeof pattern !== 'string') {
        throw new TypeError('expected a string');
      }

      var glob = { negated: false, pattern: pattern, original: pattern };
      if (pattern.charAt(0) === '!' && pattern.charAt(1) !== '(') {
        glob.negated = true;
        glob.pattern = pattern.slice(1);
      }

      return glob;
    };

    var hasOwn = Object.prototype.hasOwnProperty;
    var toStr = Object.prototype.toString;
    var defineProperty$6 = Object.defineProperty;
    var gOPD = Object.getOwnPropertyDescriptor;

    var isArray$a = function isArray(arr) {
    	if (typeof Array.isArray === 'function') {
    		return Array.isArray(arr);
    	}

    	return toStr.call(arr) === '[object Array]';
    };

    var isPlainObject = function isPlainObject(obj) {
    	if (!obj || toStr.call(obj) !== '[object Object]') {
    		return false;
    	}

    	var hasOwnConstructor = hasOwn.call(obj, 'constructor');
    	var hasIsPrototypeOf = obj.constructor && obj.constructor.prototype && hasOwn.call(obj.constructor.prototype, 'isPrototypeOf');
    	// Not own constructor property must be Object
    	if (obj.constructor && !hasOwnConstructor && !hasIsPrototypeOf) {
    		return false;
    	}

    	// Own properties are enumerated firstly, so to speed up,
    	// if last one is own, then all properties are own.
    	var key;
    	for (key in obj) { /**/ }

    	return typeof key === 'undefined' || hasOwn.call(obj, key);
    };

    // If name is '__proto__', and Object.defineProperty is available, define __proto__ as an own property on target
    var setProperty = function setProperty(target, options) {
    	if (defineProperty$6 && options.name === '__proto__') {
    		defineProperty$6(target, options.name, {
    			enumerable: true,
    			configurable: true,
    			value: options.newValue,
    			writable: true
    		});
    	} else {
    		target[options.name] = options.newValue;
    	}
    };

    // Return undefined instead of __proto__ if '__proto__' is not an own property
    var getProperty = function getProperty(obj, name) {
    	if (name === '__proto__') {
    		if (!hasOwn.call(obj, name)) {
    			return void 0;
    		} else if (gOPD) {
    			// In early versions of node, obj['__proto__'] is buggy when obj has
    			// __proto__ as an own property. Object.getOwnPropertyDescriptor() works.
    			return gOPD(obj, name).value;
    		}
    	}

    	return obj[name];
    };

    var extend$1 = function extend() {
    	var options, name, src, copy, copyIsArray, clone;
    	var target = arguments[0];
    	var i = 1;
    	var length = arguments.length;
    	var deep = false;

    	// Handle a deep copy situation
    	if (typeof target === 'boolean') {
    		deep = target;
    		target = arguments[1] || {};
    		// skip the boolean and the target
    		i = 2;
    	}
    	if (target == null || (typeof target !== 'object' && typeof target !== 'function')) {
    		target = {};
    	}

    	for (; i < length; ++i) {
    		options = arguments[i];
    		// Only deal with non-null/undefined values
    		if (options != null) {
    			// Extend the base object
    			for (name in options) {
    				src = getProperty(target, name);
    				copy = getProperty(options, name);

    				// Prevent never-ending loop
    				if (target !== copy) {
    					// Recurse if we're merging plain objects or arrays
    					if (deep && copy && (isPlainObject(copy) || (copyIsArray = isArray$a(copy)))) {
    						if (copyIsArray) {
    							copyIsArray = false;
    							clone = src && isArray$a(src) ? src : [];
    						} else {
    							clone = src && isPlainObject(src) ? src : {};
    						}

    						// Never move original objects, clone them
    						setProperty(target, { name: name, newValue: extend(deep, clone, copy) });

    					// Don't bring in undefined values
    					} else if (typeof copy !== 'undefined') {
    						setProperty(target, { name: name, newValue: copy });
    					}
    				}
    			}
    		}
    	}

    	// Return the modified object
    	return target;
    };

    // Copyright Joyent, Inc. and other Node contributors.
    //
    // Permission is hereby granted, free of charge, to any person obtaining a
    // copy of this software and associated documentation files (the
    // "Software"), to deal in the Software without restriction, including
    // without limitation the rights to use, copy, modify, merge, publish,
    // distribute, sublicense, and/or sell copies of the Software, and to permit
    // persons to whom the Software is furnished to do so, subject to the
    // following conditions:
    //
    // The above copyright notice and this permission notice shall be included
    // in all copies or substantial portions of the Software.
    //
    // THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
    // OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
    // MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN
    // NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
    // DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
    // OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
    // USE OR OTHER DEALINGS IN THE SOFTWARE.


    var isWindows = process.platform === 'win32';


    // JavaScript implementation of realpath, ported from node pre-v6

    var DEBUG = process.env.NODE_DEBUG && /fs/.test(process.env.NODE_DEBUG);

    function rethrow() {
      // Only enable in debug mode. A backtrace uses ~1000 bytes of heap space and
      // is fairly slow to generate.
      var callback;
      if (DEBUG) {
        var backtrace = new Error;
        callback = debugCallback;
      } else
        callback = missingCallback;

      return callback;

      function debugCallback(err) {
        if (err) {
          backtrace.message = err.message;
          err = backtrace;
          missingCallback(err);
        }
      }

      function missingCallback(err) {
        if (err) {
          if (process.throwDeprecation)
            throw err;  // Forgot a callback but don't know where? Use NODE_DEBUG=fs
          else if (!process.noDeprecation) {
            var msg = 'fs: missing callback ' + (err.stack || err.message);
            if (process.traceDeprecation)
              console.trace(msg);
            else
              console.error(msg);
          }
        }
      }
    }

    function maybeCallback(cb) {
      return typeof cb === 'function' ? cb : rethrow();
    }

    // Regexp that finds the next partion of a (partial) path
    // result is [base_with_slash, base], e.g. ['somedir/', 'somedir']
    if (isWindows) {
      var nextPartRe = /(.*?)(?:[\/\\]+|$)/g;
    } else {
      var nextPartRe = /(.*?)(?:[\/]+|$)/g;
    }

    // Regex to find the device root, including trailing slash. E.g. 'c:\\'.
    if (isWindows) {
      var splitRootRe = /^(?:[a-zA-Z]:|[\\\/]{2}[^\\\/]+[\\\/][^\\\/]+)?[\\\/]*/;
    } else {
      var splitRootRe = /^[\/]*/;
    }

    var realpathSync = function realpathSync(p, cache) {
      // make p is absolute
      p = path.resolve(p);

      if (cache && Object.prototype.hasOwnProperty.call(cache, p)) {
        return cache[p];
      }

      var original = p,
          seenLinks = {},
          knownHard = {};

      // current character position in p
      var pos;
      // the partial path so far, including a trailing slash if any
      var current;
      // the partial path without a trailing slash (except when pointing at a root)
      var base;
      // the partial path scanned in the previous round, with slash
      var previous;

      start();

      function start() {
        // Skip over roots
        var m = splitRootRe.exec(p);
        pos = m[0].length;
        current = m[0];
        base = m[0];
        previous = '';

        // On windows, check that the root exists. On unix there is no need.
        if (isWindows && !knownHard[base]) {
          fs.lstatSync(base);
          knownHard[base] = true;
        }
      }

      // walk down the path, swapping out linked pathparts for their real
      // values
      // NB: p.length changes.
      while (pos < p.length) {
        // find the next part
        nextPartRe.lastIndex = pos;
        var result = nextPartRe.exec(p);
        previous = current;
        current += result[0];
        base = previous + result[1];
        pos = nextPartRe.lastIndex;

        // continue if not a symlink
        if (knownHard[base] || (cache && cache[base] === base)) {
          continue;
        }

        var resolvedLink;
        if (cache && Object.prototype.hasOwnProperty.call(cache, base)) {
          // some known symbolic link.  no need to stat again.
          resolvedLink = cache[base];
        } else {
          var stat = fs.lstatSync(base);
          if (!stat.isSymbolicLink()) {
            knownHard[base] = true;
            if (cache) cache[base] = base;
            continue;
          }

          // read the link if it wasn't read before
          // dev/ino always return 0 on windows, so skip the check.
          var linkTarget = null;
          if (!isWindows) {
            var id = stat.dev.toString(32) + ':' + stat.ino.toString(32);
            if (seenLinks.hasOwnProperty(id)) {
              linkTarget = seenLinks[id];
            }
          }
          if (linkTarget === null) {
            fs.statSync(base);
            linkTarget = fs.readlinkSync(base);
          }
          resolvedLink = path.resolve(previous, linkTarget);
          // track this, if given a cache.
          if (cache) cache[base] = resolvedLink;
          if (!isWindows) seenLinks[id] = linkTarget;
        }

        // resolve the link, then start over
        p = path.resolve(resolvedLink, p.slice(pos));
        start();
      }

      if (cache) cache[original] = p;

      return p;
    };


    var realpath = function realpath(p, cache, cb) {
      if (typeof cb !== 'function') {
        cb = maybeCallback(cache);
        cache = null;
      }

      // make p is absolute
      p = path.resolve(p);

      if (cache && Object.prototype.hasOwnProperty.call(cache, p)) {
        return process.nextTick(cb.bind(null, null, cache[p]));
      }

      var original = p,
          seenLinks = {},
          knownHard = {};

      // current character position in p
      var pos;
      // the partial path so far, including a trailing slash if any
      var current;
      // the partial path without a trailing slash (except when pointing at a root)
      var base;
      // the partial path scanned in the previous round, with slash
      var previous;

      start();

      function start() {
        // Skip over roots
        var m = splitRootRe.exec(p);
        pos = m[0].length;
        current = m[0];
        base = m[0];
        previous = '';

        // On windows, check that the root exists. On unix there is no need.
        if (isWindows && !knownHard[base]) {
          fs.lstat(base, function(err) {
            if (err) return cb(err);
            knownHard[base] = true;
            LOOP();
          });
        } else {
          process.nextTick(LOOP);
        }
      }

      // walk down the path, swapping out linked pathparts for their real
      // values
      function LOOP() {
        // stop if scanned past end of path
        if (pos >= p.length) {
          if (cache) cache[original] = p;
          return cb(null, p);
        }

        // find the next part
        nextPartRe.lastIndex = pos;
        var result = nextPartRe.exec(p);
        previous = current;
        current += result[0];
        base = previous + result[1];
        pos = nextPartRe.lastIndex;

        // continue if not a symlink
        if (knownHard[base] || (cache && cache[base] === base)) {
          return process.nextTick(LOOP);
        }

        if (cache && Object.prototype.hasOwnProperty.call(cache, base)) {
          // known symbolic link.  no need to stat again.
          return gotResolvedLink(cache[base]);
        }

        return fs.lstat(base, gotStat);
      }

      function gotStat(err, stat) {
        if (err) return cb(err);

        // if not a symlink, skip to the next path part
        if (!stat.isSymbolicLink()) {
          knownHard[base] = true;
          if (cache) cache[base] = base;
          return process.nextTick(LOOP);
        }

        // stat & read the link if not read before
        // call gotTarget as soon as the link target is known
        // dev/ino always return 0 on windows, so skip the check.
        if (!isWindows) {
          var id = stat.dev.toString(32) + ':' + stat.ino.toString(32);
          if (seenLinks.hasOwnProperty(id)) {
            return gotTarget(null, seenLinks[id], base);
          }
        }
        fs.stat(base, function(err) {
          if (err) return cb(err);

          fs.readlink(base, function(err, target) {
            if (!isWindows) seenLinks[id] = target;
            gotTarget(err, target);
          });
        });
      }

      function gotTarget(err, target, base) {
        if (err) return cb(err);

        var resolvedLink = path.resolve(previous, target);
        if (cache) cache[base] = resolvedLink;
        gotResolvedLink(resolvedLink);
      }

      function gotResolvedLink(resolvedLink) {
        // resolve the link, then start over
        p = path.resolve(resolvedLink, p.slice(pos));
        start();
      }
    };

    var old = {
    	realpathSync: realpathSync,
    	realpath: realpath
    };

    var fs_realpath = realpath$1;
    realpath$1.realpath = realpath$1;
    realpath$1.sync = realpathSync$1;
    realpath$1.realpathSync = realpathSync$1;
    realpath$1.monkeypatch = monkeypatch;
    realpath$1.unmonkeypatch = unmonkeypatch;


    var origRealpath = fs.realpath;
    var origRealpathSync = fs.realpathSync;

    var version = process.version;
    var ok = /^v[0-5]\./.test(version);


    function newError (er) {
      return er && er.syscall === 'realpath' && (
        er.code === 'ELOOP' ||
        er.code === 'ENOMEM' ||
        er.code === 'ENAMETOOLONG'
      )
    }

    function realpath$1 (p, cache, cb) {
      if (ok) {
        return origRealpath(p, cache, cb)
      }

      if (typeof cache === 'function') {
        cb = cache;
        cache = null;
      }
      origRealpath(p, cache, function (er, result) {
        if (newError(er)) {
          old.realpath(p, cache, cb);
        } else {
          cb(er, result);
        }
      });
    }

    function realpathSync$1 (p, cache) {
      if (ok) {
        return origRealpathSync(p, cache)
      }

      try {
        return origRealpathSync(p, cache)
      } catch (er) {
        if (newError(er)) {
          return old.realpathSync(p, cache)
        } else {
          throw er
        }
      }
    }

    function monkeypatch () {
      fs.realpath = realpath$1;
      fs.realpathSync = realpathSync$1;
    }

    function unmonkeypatch () {
      fs.realpath = origRealpath;
      fs.realpathSync = origRealpathSync;
    }

    var concatMap = function (xs, fn) {
        var res = [];
        for (var i = 0; i < xs.length; i++) {
            var x = fn(xs[i], i);
            if (isArray$b(x)) res.push.apply(res, x);
            else res.push(x);
        }
        return res;
    };

    var isArray$b = Array.isArray || function (xs) {
        return Object.prototype.toString.call(xs) === '[object Array]';
    };

    var balancedMatch = balanced;
    function balanced(a, b, str) {
      if (a instanceof RegExp) a = maybeMatch(a, str);
      if (b instanceof RegExp) b = maybeMatch(b, str);

      var r = range(a, b, str);

      return r && {
        start: r[0],
        end: r[1],
        pre: str.slice(0, r[0]),
        body: str.slice(r[0] + a.length, r[1]),
        post: str.slice(r[1] + b.length)
      };
    }

    function maybeMatch(reg, str) {
      var m = str.match(reg);
      return m ? m[0] : null;
    }

    balanced.range = range;
    function range(a, b, str) {
      var begs, beg, left, right, result;
      var ai = str.indexOf(a);
      var bi = str.indexOf(b, ai + 1);
      var i = ai;

      if (ai >= 0 && bi > 0) {
        begs = [];
        left = str.length;

        while (i >= 0 && !result) {
          if (i == ai) {
            begs.push(i);
            ai = str.indexOf(a, i + 1);
          } else if (begs.length == 1) {
            result = [ begs.pop(), bi ];
          } else {
            beg = begs.pop();
            if (beg < left) {
              left = beg;
              right = bi;
            }

            bi = str.indexOf(b, i + 1);
          }

          i = ai < bi && ai >= 0 ? ai : bi;
        }

        if (begs.length) {
          result = [ left, right ];
        }
      }

      return result;
    }

    var braceExpansion = expandTop;

    var escSlash = '\0SLASH'+Math.random()+'\0';
    var escOpen = '\0OPEN'+Math.random()+'\0';
    var escClose = '\0CLOSE'+Math.random()+'\0';
    var escComma = '\0COMMA'+Math.random()+'\0';
    var escPeriod = '\0PERIOD'+Math.random()+'\0';

    function numeric(str) {
      return parseInt(str, 10) == str
        ? parseInt(str, 10)
        : str.charCodeAt(0);
    }

    function escapeBraces(str) {
      return str.split('\\\\').join(escSlash)
                .split('\\{').join(escOpen)
                .split('\\}').join(escClose)
                .split('\\,').join(escComma)
                .split('\\.').join(escPeriod);
    }

    function unescapeBraces(str) {
      return str.split(escSlash).join('\\')
                .split(escOpen).join('{')
                .split(escClose).join('}')
                .split(escComma).join(',')
                .split(escPeriod).join('.');
    }


    // Basically just str.split(","), but handling cases
    // where we have nested braced sections, which should be
    // treated as individual members, like {a,{b,c},d}
    function parseCommaParts(str) {
      if (!str)
        return [''];

      var parts = [];
      var m = balancedMatch('{', '}', str);

      if (!m)
        return str.split(',');

      var pre = m.pre;
      var body = m.body;
      var post = m.post;
      var p = pre.split(',');

      p[p.length-1] += '{' + body + '}';
      var postParts = parseCommaParts(post);
      if (post.length) {
        p[p.length-1] += postParts.shift();
        p.push.apply(p, postParts);
      }

      parts.push.apply(parts, p);

      return parts;
    }

    function expandTop(str) {
      if (!str)
        return [];

      // I don't know why Bash 4.3 does this, but it does.
      // Anything starting with {} will have the first two bytes preserved
      // but *only* at the top level, so {},a}b will not expand to anything,
      // but a{},b}c will be expanded to [a}c,abc].
      // One could argue that this is a bug in Bash, but since the goal of
      // this module is to match Bash's rules, we escape a leading {}
      if (str.substr(0, 2) === '{}') {
        str = '\\{\\}' + str.substr(2);
      }

      return expand(escapeBraces(str), true).map(unescapeBraces);
    }

    function embrace(str) {
      return '{' + str + '}';
    }
    function isPadded(el) {
      return /^-?0\d/.test(el);
    }

    function lte(i, y) {
      return i <= y;
    }
    function gte(i, y) {
      return i >= y;
    }

    function expand(str, isTop) {
      var expansions = [];

      var m = balancedMatch('{', '}', str);
      if (!m || /\$$/.test(m.pre)) return [str];

      var isNumericSequence = /^-?\d+\.\.-?\d+(?:\.\.-?\d+)?$/.test(m.body);
      var isAlphaSequence = /^[a-zA-Z]\.\.[a-zA-Z](?:\.\.-?\d+)?$/.test(m.body);
      var isSequence = isNumericSequence || isAlphaSequence;
      var isOptions = m.body.indexOf(',') >= 0;
      if (!isSequence && !isOptions) {
        // {a},b}
        if (m.post.match(/,.*\}/)) {
          str = m.pre + '{' + m.body + escClose + m.post;
          return expand(str);
        }
        return [str];
      }

      var n;
      if (isSequence) {
        n = m.body.split(/\.\./);
      } else {
        n = parseCommaParts(m.body);
        if (n.length === 1) {
          // x{{a,b}}y ==> x{a}y x{b}y
          n = expand(n[0], false).map(embrace);
          if (n.length === 1) {
            var post = m.post.length
              ? expand(m.post, false)
              : [''];
            return post.map(function(p) {
              return m.pre + n[0] + p;
            });
          }
        }
      }

      // at this point, n is the parts, and we know it's not a comma set
      // with a single entry.

      // no need to expand pre, since it is guaranteed to be free of brace-sets
      var pre = m.pre;
      var post = m.post.length
        ? expand(m.post, false)
        : [''];

      var N;

      if (isSequence) {
        var x = numeric(n[0]);
        var y = numeric(n[1]);
        var width = Math.max(n[0].length, n[1].length);
        var incr = n.length == 3
          ? Math.abs(numeric(n[2]))
          : 1;
        var test = lte;
        var reverse = y < x;
        if (reverse) {
          incr *= -1;
          test = gte;
        }
        var pad = n.some(isPadded);

        N = [];

        for (var i = x; test(i, y); i += incr) {
          var c;
          if (isAlphaSequence) {
            c = String.fromCharCode(i);
            if (c === '\\')
              c = '';
          } else {
            c = String(i);
            if (pad) {
              var need = width - c.length;
              if (need > 0) {
                var z = new Array(need + 1).join('0');
                if (i < 0)
                  c = '-' + z + c.slice(1);
                else
                  c = z + c;
              }
            }
          }
          N.push(c);
        }
      } else {
        N = concatMap(n, function(el) { return expand(el, false) });
      }

      for (var j = 0; j < N.length; j++) {
        for (var k = 0; k < post.length; k++) {
          var expansion = pre + N[j] + post[k];
          if (!isTop || isSequence || expansion)
            expansions.push(expansion);
        }
      }

      return expansions;
    }

    var minimatch_1 = minimatch;
    minimatch.Minimatch = Minimatch;

    var path$1 = { sep: '/' };
    try {
      path$1 = path;
    } catch (er) {}

    var GLOBSTAR = minimatch.GLOBSTAR = Minimatch.GLOBSTAR = {};


    var plTypes = {
      '!': { open: '(?:(?!(?:', close: '))[^/]*?)'},
      '?': { open: '(?:', close: ')?' },
      '+': { open: '(?:', close: ')+' },
      '*': { open: '(?:', close: ')*' },
      '@': { open: '(?:', close: ')' }
    };

    // any single thing other than /
    // don't need to escape / when using new RegExp()
    var qmark = '[^/]';

    // * => any number of characters
    var star = qmark + '*?';

    // ** when dots are allowed.  Anything goes, except .. and .
    // not (^ or / followed by one or two dots followed by $ or /),
    // followed by anything, any number of times.
    var twoStarDot = '(?:(?!(?:\\\/|^)(?:\\.{1,2})($|\\\/)).)*?';

    // not a ^ or / followed by a dot,
    // followed by anything, any number of times.
    var twoStarNoDot = '(?:(?!(?:\\\/|^)\\.).)*?';

    // characters that need to be escaped in RegExp.
    var reSpecials = charSet('().*{}+?[]^$\\!');

    // "abc" -> { a:true, b:true, c:true }
    function charSet (s) {
      return s.split('').reduce(function (set, c) {
        set[c] = true;
        return set
      }, {})
    }

    // normalizes slashes.
    var slashSplit = /\/+/;

    minimatch.filter = filter$3;
    function filter$3 (pattern, options) {
      options = options || {};
      return function (p, i, list) {
        return minimatch(p, pattern, options)
      }
    }

    function ext (a, b) {
      a = a || {};
      b = b || {};
      var t = {};
      Object.keys(b).forEach(function (k) {
        t[k] = b[k];
      });
      Object.keys(a).forEach(function (k) {
        t[k] = a[k];
      });
      return t
    }

    minimatch.defaults = function (def) {
      if (!def || !Object.keys(def).length) return minimatch

      var orig = minimatch;

      var m = function minimatch (p, pattern, options) {
        return orig.minimatch(p, pattern, ext(def, options))
      };

      m.Minimatch = function Minimatch (pattern, options) {
        return new orig.Minimatch(pattern, ext(def, options))
      };

      return m
    };

    Minimatch.defaults = function (def) {
      if (!def || !Object.keys(def).length) return Minimatch
      return minimatch.defaults(def).Minimatch
    };

    function minimatch (p, pattern, options) {
      if (typeof pattern !== 'string') {
        throw new TypeError('glob pattern string required')
      }

      if (!options) options = {};

      // shortcut: comments match nothing.
      if (!options.nocomment && pattern.charAt(0) === '#') {
        return false
      }

      // "" only matches ""
      if (pattern.trim() === '') return p === ''

      return new Minimatch(pattern, options).match(p)
    }

    function Minimatch (pattern, options) {
      if (!(this instanceof Minimatch)) {
        return new Minimatch(pattern, options)
      }

      if (typeof pattern !== 'string') {
        throw new TypeError('glob pattern string required')
      }

      if (!options) options = {};
      pattern = pattern.trim();

      // windows support: need to use /, not \
      if (path$1.sep !== '/') {
        pattern = pattern.split(path$1.sep).join('/');
      }

      this.options = options;
      this.set = [];
      this.pattern = pattern;
      this.regexp = null;
      this.negate = false;
      this.comment = false;
      this.empty = false;

      // make the set of regexps etc.
      this.make();
    }

    Minimatch.prototype.debug = function () {};

    Minimatch.prototype.make = make$1;
    function make$1 () {
      // don't do it more than once.
      if (this._made) return

      var pattern = this.pattern;
      var options = this.options;

      // empty patterns and comments match nothing.
      if (!options.nocomment && pattern.charAt(0) === '#') {
        this.comment = true;
        return
      }
      if (!pattern) {
        this.empty = true;
        return
      }

      // step 1: figure out negation, etc.
      this.parseNegate();

      // step 2: expand braces
      var set = this.globSet = this.braceExpand();

      if (options.debug) this.debug = console.error;

      this.debug(this.pattern, set);

      // step 3: now we have a set, so turn each one into a series of path-portion
      // matching patterns.
      // These will be regexps, except in the case of "**", which is
      // set to the GLOBSTAR object for globstar behavior,
      // and will not contain any / characters
      set = this.globParts = set.map(function (s) {
        return s.split(slashSplit)
      });

      this.debug(this.pattern, set);

      // glob --> regexps
      set = set.map(function (s, si, set) {
        return s.map(this.parse, this)
      }, this);

      this.debug(this.pattern, set);

      // filter out everything that didn't compile properly.
      set = set.filter(function (s) {
        return s.indexOf(false) === -1
      });

      this.debug(this.pattern, set);

      this.set = set;
    }

    Minimatch.prototype.parseNegate = parseNegate;
    function parseNegate () {
      var pattern = this.pattern;
      var negate = false;
      var options = this.options;
      var negateOffset = 0;

      if (options.nonegate) return

      for (var i = 0, l = pattern.length
        ; i < l && pattern.charAt(i) === '!'
        ; i++) {
        negate = !negate;
        negateOffset++;
      }

      if (negateOffset) this.pattern = pattern.substr(negateOffset);
      this.negate = negate;
    }

    // Brace expansion:
    // a{b,c}d -> abd acd
    // a{b,}c -> abc ac
    // a{0..3}d -> a0d a1d a2d a3d
    // a{b,c{d,e}f}g -> abg acdfg acefg
    // a{b,c}d{e,f}g -> abdeg acdeg abdeg abdfg
    //
    // Invalid sets are not expanded.
    // a{2..}b -> a{2..}b
    // a{b}c -> a{b}c
    minimatch.braceExpand = function (pattern, options) {
      return braceExpand(pattern, options)
    };

    Minimatch.prototype.braceExpand = braceExpand;

    function braceExpand (pattern, options) {
      if (!options) {
        if (this instanceof Minimatch) {
          options = this.options;
        } else {
          options = {};
        }
      }

      pattern = typeof pattern === 'undefined'
        ? this.pattern : pattern;

      if (typeof pattern === 'undefined') {
        throw new TypeError('undefined pattern')
      }

      if (options.nobrace ||
        !pattern.match(/\{.*\}/)) {
        // shortcut. no need to expand.
        return [pattern]
      }

      return braceExpansion(pattern)
    }

    // parse a component of the expanded set.
    // At this point, no pattern may contain "/" in it
    // so we're going to return a 2d array, where each entry is the full
    // pattern, split on '/', and then turned into a regular expression.
    // A regexp is made at the end which joins each array with an
    // escaped /, and another full one which joins each regexp with |.
    //
    // Following the lead of Bash 4.1, note that "**" only has special meaning
    // when it is the *only* thing in a path portion.  Otherwise, any series
    // of * is equivalent to a single *.  Globstar behavior is enabled by
    // defau