/// <reference types="node" />
import { AnonymousSubject } from 'rxjs/internal/Subject';
import { Subscriber, Observable, Subscription, Operator, Observer, NextObserver } from 'rxjs';
import { IClientOptions as MQTTClientOptions } from 'mqtt';
interface MQTTMessage<T> {
    topic: string;
    message: T;
    qos?: 0 | 1 | 2;
    retain?: boolean;
}
export interface MQTTSubjectConfig<T> {
    /** The url of the MQTT server to connect to */
    url: string;
    /** Options to be sent to the mqtt library */
    options?: MQTTClientOptions;
    /**
     * A serializer used to create messages from passed values before the
     * messages are sent to the server. Defaults to JSON.stringify.
     */
    serializer?: (value: T) => Buffer;
    /**
     * A deserializer used for messages arriving on the socket from the
     * server. Defaults to JSON.parse.
     */
    deserializer?: (message: Buffer) => T;
    /**
     * An Observer that watches when open events occur on the underlying connection
     */
    connectObserver?: NextObserver<Event>;
    /**
     * An Observer than watches when close events occur on the underlying connection
     */
    disconnectObserver?: NextObserver<CloseEvent | Error>;
    /**
     * An Observer that watches when a close is about to occur
     */
    disconnectingObserver?: NextObserver<void>;
    [key: string]: any;
}
export declare class MQTTSubject<T> extends AnonymousSubject<MQTTMessage<T>> {
    private _config;
    /** @deprecated This is an internal implementation detail, do not use. */
    private _output;
    private _connection?;
    constructor(urlOrConfig: string | MQTTSubjectConfig<T>, destination?: Observer<MQTTMessage<T>>);
    lift<R>(operator: Operator<MQTTMessage<T>, R>): Observable<R>;
    private _resetState;
    topic(topic: string): MQTTTopicSubject<T>;
    private _connectBroker;
    publish(topic: string, message: T): void;
    /** @deprecated This is an internal implementation detail, do not use. */
    _subscribe(subscriber: Subscriber<MQTTMessage<T>>): Subscription;
}
export declare class MQTTTopicSubject<T> extends AnonymousSubject<MQTTMessage<T>> {
    private _topic;
    source: MQTTSubject<T>;
    constructor(source: MQTTSubject<T>, _topic: string);
    publish(message: T): void;
    _subscribe(subscriber: Subscriber<MQTTMessage<T>>): Subscription;
}
export declare const connect: <T>(urlOrConfig: string | MQTTSubjectConfig<T>) => MQTTSubject<T>;
export {};
