(function () {
  'use strict';

  mutationObserverHasBuggyRemovedNodes(function (result) {
    if (result) patchInnerHTMLToRemoveChildNodes();
  });

  function mutationObserverHasBuggyRemovedNodes(callback) {
    if (!window.MutationObserver) {
      callback(false);
      return;
    }

    var element = document.createElement("div");
    element.innerHTML = "<div><div></div></div>";

    var observer = new MutationObserver(function (mutations) {
      observer.disconnect();
      var mutation = mutations[0];
      if (mutation && mutation.type == "childList") {
        var removedNode = mutation.removedNodes[0];
        var isBuggy = removedNode.childNodes.length == 0;
        callback(isBuggy);
      }
    });

    observer.observe(element, { childList: true, subtree: true });
    element.innerHTML = "";
  }

  function patchInnerHTMLToRemoveChildNodes() {
    var _HTMLElement = HTMLElement,
        prototype = _HTMLElement.prototype;

    var descriptor = Object.getOwnPropertyDescriptor(prototype, "innerHTML");
    if (!descriptor) return;
    var _set = descriptor.set;

    if (!_set) return;

    Object.defineProperty(prototype, "innerHTML", {
      set: function set(value) {
        while (this.lastChild) {
          this.removeChild(this.lastChild);
        }
        _set.call(this, value);
      }
    });
  }

}());
