import { MutantResult, FileResult, Thresholds } from 'mutation-testing-report-schema';
export declare class TableRow {
    name: string;
    shouldLink: boolean;
    killed: number;
    timeout: number;
    survived: number;
    noCoverage: number;
    runtimeErrors: number;
    compileErrors: number;
    totalDetected: number;
    totalUndetected: number;
    totalCovered: number;
    totalValid: number;
    totalInvalid: number;
    totalMutants: number;
    mutationScore: number;
    mutationScoreBasedOnCoveredCode: number;
    constructor(name: string, results: MutantResult[], shouldLink: boolean);
}
export declare class ResultTable {
    rows: TableRow[];
    thresholds: Thresholds;
    constructor(rows: TableRow[], thresholds: Thresholds);
    static forFile(name: string, result: FileResult, thresholds: Thresholds): ResultTable;
}
