"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : new P(function (resolve) { resolve(result.value); }).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const lit_element_1 = require("lit-element");
const helpers_1 = require("../helpers");
const style_1 = require("../style");
let MutationTestReportAppComponent = class MutationTestReportAppComponent extends lit_element_1.LitElement {
    constructor() {
        super(...arguments);
        this.updatePath = (event) => {
            this.path = event.detail;
            this.updateContext();
        };
    }
    get title() {
        if (this.titlePostfix) {
            return `${this.titlePrefix} - ${this.titlePostfix}`;
        }
        else {
            return this.titlePrefix;
        }
    }
    get titlePrefix() {
        if (this.context && this.path) {
            return this.path;
        }
        else {
            return helpers_1.ROOT_NAME;
        }
    }
    connectedCallback() {
        super.connectedCallback();
        if (this.src) {
            this.loadData(this.src)
                .catch(error => this.errorMessage = error.toString());
        }
    }
    loadData(src) {
        return __awaiter(this, void 0, void 0, function* () {
            const res = yield fetch(src);
            this.report = yield res.json();
        });
    }
    updated(changedProperties) {
        if (changedProperties.has('report') && this.report) {
            this.updateModel(this.report);
            this.updateContext();
        }
    }
    updateModel(report) {
        this.model = helpers_1.normalizeFileNames(report);
    }
    updateContext() {
        if (this.model) {
            if (this.path) {
                this.context = this.model.files[this.path];
                if (!this.context) {
                    this.errorMessage = `404 - ${this.path} not found`;
                }
                else {
                    this.errorMessage = undefined;
                }
            }
            else {
                this.context = undefined;
            }
        }
    }
    render() {
        return lit_element_1.html `
    <mutation-test-report-title .title="${this.title}"></mutation-test-report-title>
    <mutation-test-report-router @path-changed="${this.updatePath}"></mutation-test-report-router>
    ${this.renderContent()}
    `;
    }
    renderTitle() {
        if (this.model) {
            return lit_element_1.html `<h1 class="display-4">${this.title}</h1>`;
        }
        else {
            return undefined;
        }
    }
    renderContent() {
        if (this.model) {
            return lit_element_1.html `<div class="container">
  <div class="row">
    <div class="col-md-12">
      ${this.renderTitle()}
      <mutation-test-report-breadcrumb .path="${this.path}"></mutation-test-report-breadcrumb>
      ${this.renderErrorMessage()}
      ${this.renderMutationTestReport()}
    </div>
  </div>
</div>`;
        }
        else {
            return undefined;
        }
    }
    renderErrorMessage() {
        if (this.errorMessage) {
            return lit_element_1.html `
      <div class="alert alert-danger" role="alert">
        ${this.errorMessage}
      </div>
        `;
        }
        else {
            return lit_element_1.html ``;
        }
    }
    renderMutationTestReport() {
        if (this.context && this.model) {
            return lit_element_1.html `<mutation-test-report-file .name="${this.title}" .thresholds="${this.model.thresholds}" .model="${this.context}"></mutation-test-report-file>`;
        }
        else if (this.model) {
            return lit_element_1.html `<mutation-test-report-result .model="${this.model}"></mutation-test-report-result>`;
        }
        else {
            return '';
        }
    }
};
MutationTestReportAppComponent.styles = [
    style_1.bootstrap,
    lit_element_1.css `
    :host {
      line-height: 1.15;
      margin: 0;
      font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, "Helvetica Neue", Arial, "Noto Sans", sans-serif, "Apple Color Emoji", "Segoe UI Emoji", "Segoe UI Symbol", "Noto Color Emoji";
      font-size: 1rem;
      font-weight: 400;
      line-height: 1.5;
      color: #212529;
      text-align: left;
      background-color: #fff;
    }
    `
];
__decorate([
    lit_element_1.property({ attribute: false })
], MutationTestReportAppComponent.prototype, "report", void 0);
__decorate([
    lit_element_1.property({ attribute: false })
], MutationTestReportAppComponent.prototype, "model", void 0);
__decorate([
    lit_element_1.property()
], MutationTestReportAppComponent.prototype, "src", void 0);
__decorate([
    lit_element_1.property()
], MutationTestReportAppComponent.prototype, "errorMessage", void 0);
__decorate([
    lit_element_1.property({ attribute: false })
], MutationTestReportAppComponent.prototype, "context", void 0);
__decorate([
    lit_element_1.property()
], MutationTestReportAppComponent.prototype, "path", void 0);
__decorate([
    lit_element_1.property({ attribute: 'title-postfix' })
], MutationTestReportAppComponent.prototype, "titlePostfix", void 0);
__decorate([
    lit_element_1.property()
], MutationTestReportAppComponent.prototype, "title", null);
MutationTestReportAppComponent = __decorate([
    lit_element_1.customElement('mutation-test-report-app')
], MutationTestReportAppComponent);
exports.MutationTestReportAppComponent = MutationTestReportAppComponent;
//# sourceMappingURL=mutation-test-report-app.js.map