"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
const lit_element_1 = require("lit-element");
const style_1 = require("../style");
let MutationTestReportFileLegendComponent = class MutationTestReportFileLegendComponent extends lit_element_1.LitElement {
    constructor() {
        super(...arguments);
        this.collapsed = true;
        this.filters = [];
        this.toggleOpenAll = () => {
            this.collapsed = !this.collapsed;
            if (this.collapsed) {
                this.dispatchEvent(new CustomEvent('collapse-all'));
            }
            else {
                this.dispatchEvent(new CustomEvent('open-all'));
            }
        };
    }
    get collapseButtonText() {
        if (this.collapsed) {
            return 'Expand all';
        }
        else {
            return 'Collapse all';
        }
    }
    updated(changedProperties) {
        if (changedProperties.has('mutants')) {
            this.updateModel();
        }
    }
    updateModel() {
        this.filters = ["Killed" /* Killed */, "Survived" /* Survived */, "NoCoverage" /* NoCoverage */, "Timeout" /* Timeout */, "CompileError" /* CompileError */, "RuntimeError" /* RuntimeError */]
            .filter(status => this.mutants.some(mutant => mutant.status === status))
            .map(status => ({
            enabled: ["Survived" /* Survived */, "NoCoverage" /* NoCoverage */, "Timeout" /* Timeout */].some(s => s === status),
            numberOfMutants: this.mutants.filter(m => m.status === status).length,
            status
        }));
        this.dispatchFiltersChangedEvent();
    }
    checkboxClicked(filter) {
        filter.enabled = !filter.enabled;
        this.dispatchFiltersChangedEvent();
    }
    dispatchFiltersChangedEvent() {
        this.dispatchEvent(new CustomEvent('filters-changed', { detail: this.filters }));
    }
    render() {
        return lit_element_1.html `
      <div class='row legend'>
        <form class='col-md-12' novalidate='novalidate'>
          ${this.filters.map(filter => lit_element_1.html `
          <div class="form-check form-check-inline">
            <label class="form-check-label">
              <input class="form-check-input" type="checkbox" ?checked="${filter.enabled}" value="${filter.status}" @input="${() => this.checkboxClicked(filter)}">
              ${filter.status} (${filter.numberOfMutants})
            </label>
          </div>
          `)}
          <button @click="${this.toggleOpenAll}" class="btn btn-sm btn-secondary" type="button">${this.collapseButtonText}</button>
        </form>
      </div>
    `;
    }
};
MutationTestReportFileLegendComponent.styles = [
    lit_element_1.css `
      .legend{
        position: sticky;
        top: 0;
        background: #FFF;
      }
  `, style_1.bootstrap
];
__decorate([
    lit_element_1.property()
], MutationTestReportFileLegendComponent.prototype, "mutants", void 0);
__decorate([
    lit_element_1.property()
], MutationTestReportFileLegendComponent.prototype, "collapseButtonText", null);
__decorate([
    lit_element_1.property()
], MutationTestReportFileLegendComponent.prototype, "collapsed", void 0);
__decorate([
    lit_element_1.property()
], MutationTestReportFileLegendComponent.prototype, "filters", void 0);
MutationTestReportFileLegendComponent = __decorate([
    lit_element_1.customElement('mutation-test-report-file-legend')
], MutationTestReportFileLegendComponent);
exports.MutationTestReportFileLegendComponent = MutationTestReportFileLegendComponent;
//# sourceMappingURL=mutation-test-report-file-legend.js.map