"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const lit_element_1 = require("lit-element");
const unsafe_html_1 = require("lit-html/directives/unsafe-html");
const highlight_1 = __importDefault(require("highlight.js/lib/highlight"));
const javascript_1 = __importDefault(require("highlight.js/lib/languages/javascript"));
const scala_1 = __importDefault(require("highlight.js/lib/languages/scala"));
const java_1 = __importDefault(require("highlight.js/lib/languages/java"));
const cs_1 = __importDefault(require("highlight.js/lib/languages/cs"));
const typescript_1 = __importDefault(require("highlight.js/lib/languages/typescript"));
const helpers_1 = require("../helpers");
const mutation_test_report_mutant_1 = require("./mutation-test-report-mutant");
const style_1 = require("../style");
const ResultTable_1 = require("../model/ResultTable");
highlight_1.default.registerLanguage('javascript', javascript_1.default);
highlight_1.default.registerLanguage('typescript', typescript_1.default);
highlight_1.default.registerLanguage('cs', cs_1.default);
highlight_1.default.registerLanguage('java', java_1.default);
highlight_1.default.registerLanguage('scala', scala_1.default);
let MutationTestReportFileComponent = class MutationTestReportFileComponent extends lit_element_1.LitElement {
    constructor() {
        super(...arguments);
        this.enabledMutantStates = [];
        this.openAll = () => {
            this.forEachMutantComponent(mutantComponent => mutantComponent.expand = true);
        };
        this.collapseAll = () => {
            this.forEachMutantComponent(mutantComponent => mutantComponent.expand = false);
        };
        this.filtersChanged = (event) => {
            this.enabledMutantStates = event.detail
                .filter(mutantFilter => mutantFilter.enabled)
                .map(mutantFilter => mutantFilter.status);
            this.updateShownMutants();
        };
    }
    forEachMutantComponent(action, host = this.root) {
        for (const mutantComponent of host.querySelectorAll('mutation-test-report-mutant')) {
            if (mutantComponent instanceof mutation_test_report_mutant_1.MutationTestReportMutantComponent) {
                action(mutantComponent);
            }
        }
    }
    updateShownMutants() {
        this.forEachMutantComponent(mutantComponent => {
            mutantComponent.show = this.enabledMutantStates.some(state => mutantComponent.mutant !== undefined && mutantComponent.mutant.status === state);
        });
    }
    render() {
        return lit_element_1.html `
        <div class="row">
          <div class="totals col-sm-11">
            <mutation-test-report-totals .model="${ResultTable_1.ResultTable.forFile(this.name, this.model, this.thresholds)}"></mutation-test-report-totals>
          </div>
        </div>
        <div class="row">
          <div class="col-md-12">
            <mutation-test-report-file-legend @filters-changed="${this.filtersChanged}" @open-all="${this.openAll}"
              @collapse-all="${this.collapseAll}" .mutants="${this.model.mutants}"></mutation-test-report-file-legend>
            <pre><code class="lang-${this.model.language} hljs">${unsafe_html_1.unsafeHTML(this.renderCode())}</code></pre>
          </div>
        </div>
        `;
    }
    firstUpdated(_changedProperties) {
        super.firstUpdated(_changedProperties);
        const code = this.root.querySelector('code');
        if (code) {
            highlight_1.default.highlightBlock(code);
            this.forEachMutantComponent(mutantComponent => {
                mutantComponent.mutant = this.model.mutants.find(mutant => mutant.id.toString() === mutantComponent.getAttribute('mutant-id'));
            }, code);
        }
    }
    get root() {
        return this.shadowRoot || this;
    }
    /**
     * Walks over the code in this.model.source and adds the
     * `<mutation-test-report-mutant>` elements.
     * It also adds the background color using
     * `<span class="bg-danger-light">` and friends.
     */
    renderCode() {
        const backgroundState = new BackgroundColorCalculator();
        const startedMutants = [];
        const walker = (char, pos) => {
            const currentMutants = this.model.mutants.filter(m => eq(m.location.start, pos));
            const mutantsEnding = startedMutants.filter(m => gte(pos, m.location.end));
            mutantsEnding.forEach(mutant => startedMutants.splice(startedMutants.indexOf(mutant), 1));
            startedMutants.push(...currentMutants);
            const builder = [];
            if (currentMutants.length || mutantsEnding.length) {
                currentMutants.forEach(backgroundState.markMutantStart);
                mutantsEnding.forEach(backgroundState.markMutantEnd);
                // End previous color span
                builder.push('</span>');
                // End mutants
                mutantsEnding.forEach(() => builder.push('</mutation-test-report-mutant>'));
                // Start mutants
                currentMutants.forEach(mutant => builder.push(`<mutation-test-report-mutant mutant-id="${mutant.id}">`));
                // Start new color span
                builder.push(`<span class="bg-${backgroundState.determineBackground()}">`);
            }
            // Append the code character
            builder.push(helpers_1.escapeHtml(char));
            return builder.join('');
        };
        return `<span>${walkString(this.model.source, walker)}</span>`;
    }
};
MutationTestReportFileComponent.styles = [
    style_1.highlightJS,
    style_1.bootstrap,
    lit_element_1.css `
    .bg-danger-light {
      background-color: #f2dede;
    }
    .bg-success-light {
        background-color: #dff0d8;
    }
    .bg-warning-light {
        background-color: #fcf8e3;
    }
    `
];
__decorate([
    lit_element_1.property()
], MutationTestReportFileComponent.prototype, "model", void 0);
__decorate([
    lit_element_1.property()
], MutationTestReportFileComponent.prototype, "name", void 0);
__decorate([
    lit_element_1.property()
], MutationTestReportFileComponent.prototype, "thresholds", void 0);
MutationTestReportFileComponent = __decorate([
    lit_element_1.customElement('mutation-test-report-file')
], MutationTestReportFileComponent);
exports.MutationTestReportFileComponent = MutationTestReportFileComponent;
/**
 * Walks a string. Executes a function on each character of the string (except for new lines and carriage returns)
 * @param source the string to walk
 * @param fn The function to execute on each character of the string
 */
function walkString(source, fn) {
    let column = helpers_1.COLUMN_START_INDEX;
    let line = helpers_1.LINE_START_INDEX;
    const builder = [];
    for (const currentChar of source) {
        if (column === helpers_1.COLUMN_START_INDEX && currentChar === helpers_1.CARRIAGE_RETURN) {
            continue;
        }
        if (currentChar === helpers_1.NEW_LINE) {
            line++;
            column = helpers_1.COLUMN_START_INDEX;
            builder.push(helpers_1.NEW_LINE);
            continue;
        }
        builder.push(fn(currentChar, { line, column: column++ }));
    }
    return builder.join('');
}
/**
 * Class to keep track of the states of the
 * mutants that are active at the cursor while walking the code.
 */
class BackgroundColorCalculator {
    constructor() {
        this.killed = 0;
        this.noCoverage = 0;
        this.survived = 0;
        this.timeout = 0;
        this.markMutantStart = (mutant) => {
            this.countMutant(1, mutant.status);
        };
        this.markMutantEnd = (mutant) => {
            this.countMutant(-1, mutant.status);
        };
        this.determineBackground = () => {
            if (this.survived > 0) {
                return helpers_1.getContextClassForStatus("Survived" /* Survived */) + '-light';
            }
            else if (this.noCoverage > 0) {
                return helpers_1.getContextClassForStatus("NoCoverage" /* NoCoverage */) + '-light';
            }
            else if (this.timeout > 0) {
                return helpers_1.getContextClassForStatus("Timeout" /* Timeout */) + '-light';
            }
            else if (this.killed > 0) {
                return helpers_1.getContextClassForStatus("Killed" /* Killed */) + '-light';
            }
            return null;
        };
    }
    countMutant(valueToAdd, status) {
        switch (status) {
            case "Killed" /* Killed */:
                this.killed += valueToAdd;
                break;
            case "Survived" /* Survived */:
                this.survived += valueToAdd;
                break;
            case "Timeout" /* Timeout */:
                this.timeout += valueToAdd;
                break;
            case "NoCoverage" /* NoCoverage */:
                this.noCoverage += valueToAdd;
                break;
        }
    }
}
function gte(a, b) {
    return a.line > b.line || (a.line === b.line && a.column >= b.column);
}
function eq(a, b) {
    return a.line === b.line && a.column === b.column;
}
//# sourceMappingURL=mutation-test-report-file.js.map