"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
const lit_element_1 = require("lit-element");
const style_1 = require("../style");
let MutationTestReportTotalsComponent = class MutationTestReportTotalsComponent extends lit_element_1.LitElement {
    constructor() {
        super(...arguments);
        this.renderRow = (row) => {
            const mutationScoreRounded = row.mutationScore.toFixed(2);
            const coloringClass = this.determineColoringClass(row.mutationScore);
            const style = `width: ${mutationScoreRounded}%`;
            return lit_element_1.html `
    <tr>
      <td>${row.shouldLink ? lit_element_1.html `<a href="${this.link(row.name)}">${row.name}</a>` : lit_element_1.html `<span>${row.name}</span>`}</td>
      <td>
        <div class="progress">
          <div class="progress-bar bg-${coloringClass}" role="progressbar" aria-valuenow="${mutationScoreRounded}"
            aria-valuemin="0" aria-valuemax="100" .style="${style}">
            ${mutationScoreRounded}%
          </div>
        </div>
      </td>
      <th class="text-center text-${coloringClass}">${mutationScoreRounded}</th>
      <td class="text-center">${row.killed}</td>
      <td class="text-center">${row.survived}</td>
      <td class="text-center">${row.timeout}</td>
      <td class="text-center">${row.noCoverage}</td>
      <td class="text-center">${row.runtimeErrors}</td>
      <td class="text-center">${row.compileErrors}</td>
      <th class="text-center">${row.totalDetected}</th>
      <th class="text-center">${row.totalUndetected}</th>
      <th class="text-center">${row.totalMutants}</th>
    </tr>
    `;
        };
    }
    render() {
        return lit_element_1.html `
          <table class="table table-sm table-hover table-bordered table-no-top">
            ${this.renderHead()}
            ${this.renderBody()}
          </table>
      `;
    }
    renderHead() {
        return lit_element_1.html `<thead>
  <tr>
    <th style="width: 20%">
      <div><span>File / Directory</span></div>
    </th>
    <th colspan="2">
      <div><span>Mutation score</span></div>
    </th>
    <th class="rotate text-center" style="width: 50px">
      <div><span># Killed</span></div>
    </th>
    <th class="rotate text-center" style="width: 50px">
      <div><span># Survived</span></div>
    </th>
    <th class="rotate text-center" style="width: 50px">
      <div><span># Timeout</span></div>
    </th>
    <th class="rotate text-center" style="width: 50px">
      <div><span># No coverage</span></div>
    </th>
    <th class="rotate text-center" style="width: 50px">
      <div><span># Runtime errors</span></div>
    </th>
    <th class="rotate text-center" style="width: 50px">
      <div><span># Compile errors</span></div>
    </th>
    <th class="rotate rotate-width-70 text-center" style="width: 70px">
      <div><span>Total detected</span></div>
    </th>
    <th class="rotate rotate-width-70 text-center" style="width: 70px">
      <div><span>Total undetected</span></div>
    </th>
    <th class="rotate rotate-width-70 text-center" style="width: 70px">
      <div><span>Total mutants</span></div>
    </th>
  </tr>
</thead>`;
    }
    renderBody() {
        return lit_element_1.html `
    <tbody>
      ${this.model.rows.map(this.renderRow)}
    </tbody>`;
    }
    link(to) {
        return `#${to}`;
    }
    determineColoringClass(score) {
        if (score < this.model.thresholds.low) {
            return 'danger';
        }
        else if (score < this.model.thresholds.high) {
            return 'warning';
        }
        else {
            return 'success';
        }
    }
};
MutationTestReportTotalsComponent.styles = [style_1.bootstrap,
    lit_element_1.css `
    th.rotate {
      /* Something you can count on */
      height: 50px;
      white-space: nowrap;
      padding-bottom: 10px;
    }

    th.rotate > div {
      transform:
      translate(27px, 0px)
      rotate(325deg);
      width: 30px;
    }

    .table-no-top>thead>tr>th {
      border-width: 0;
    }

    .table-no-top {
      border-width: 0;
    }
  `];
__decorate([
    lit_element_1.property()
], MutationTestReportTotalsComponent.prototype, "model", void 0);
MutationTestReportTotalsComponent = __decorate([
    lit_element_1.customElement('mutation-test-report-totals')
], MutationTestReportTotalsComponent);
exports.MutationTestReportTotalsComponent = MutationTestReportTotalsComponent;
//# sourceMappingURL=mutation-test-report-totals.js.map