"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ROOT_NAME = 'All files';
const SEPARATOR = '/';
function getContextClassForStatus(status) {
    switch (status) {
        case "Killed" /* Killed */:
            return 'success';
        case "NoCoverage" /* NoCoverage */:
        case "Survived" /* Survived */:
            return 'danger';
        case "Timeout" /* Timeout */:
            return 'warning';
        case "RuntimeError" /* RuntimeError */:
        case "CompileError" /* CompileError */:
            return 'secondary';
    }
}
exports.getContextClassForStatus = getContextClassForStatus;
exports.COLUMN_START_INDEX = 1;
exports.LINE_START_INDEX = 1;
exports.NEW_LINE = '\n';
exports.CARRIAGE_RETURN = '\r';
function lines(content) {
    return content.split(exports.NEW_LINE).map(line => line.endsWith(exports.CARRIAGE_RETURN) ? line.substr(0, line.length - 1) : line);
}
exports.lines = lines;
function escapeHtml(unsafe) {
    return unsafe
        .replace(/&/g, '&amp;')
        .replace(/</g, '&lt;')
        .replace(/>/g, '&gt;')
        .replace(/"/g, '&quot;')
        .replace(/'/g, '&#039;');
}
exports.escapeHtml = escapeHtml;
function flatMap(source, fn) {
    const result = [];
    source.map(fn).forEach(items => result.push(...items));
    return result;
}
exports.flatMap = flatMap;
function normalizeFileNames(report) {
    const fileNames = Object.keys(report.files);
    const commonBasePath = determineCommonBasePath(fileNames);
    const result = {};
    fileNames.forEach(fileName => {
        result[normalize(fileName.substr(commonBasePath.length))] = report.files[fileName];
    });
    return {
        files: result,
        schemaVersion: report.schemaVersion,
        thresholds: report.thresholds
    };
}
exports.normalizeFileNames = normalizeFileNames;
function normalize(fileName) {
    return fileName.split(/\/|\\/)
        .filter(pathPart => pathPart)
        .join('/');
}
function determineCommonBasePath(fileNames) {
    const directories = fileNames.map(fileName => fileName.split(/\/|\\/).slice(0, -1));
    if (directories.length) {
        return directories.reduce(filterDirectories).join(SEPARATOR);
    }
    else {
        return '';
    }
}
function filterDirectories(previousDirectories, currentDirectories) {
    for (let i = 0; i < previousDirectories.length; i++) {
        if (previousDirectories[i] !== currentDirectories[i]) {
            return previousDirectories.splice(0, i);
        }
    }
    return previousDirectories;
}
//# sourceMappingURL=helpers.js.map