"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const DEFAULT_IF_NO_VALID_MUTANTS = 100;
class TableRow {
    constructor(name, results, shouldLink) {
        this.name = name;
        this.shouldLink = shouldLink;
        const count = (mutantResult) => results.filter(mutant => mutant.status === mutantResult).length;
        this.killed = count("Killed" /* Killed */);
        this.timeout = count("Timeout" /* Timeout */);
        this.survived = count("Survived" /* Survived */);
        this.noCoverage = count("NoCoverage" /* NoCoverage */);
        this.runtimeErrors = count("RuntimeError" /* RuntimeError */);
        this.compileErrors = count("CompileError" /* CompileError */);
        this.totalDetected = this.timeout + this.killed;
        this.totalUndetected = this.survived + this.noCoverage;
        this.totalCovered = this.totalDetected + this.survived;
        this.totalValid = this.totalUndetected + this.totalDetected;
        this.totalInvalid = this.runtimeErrors + this.compileErrors;
        this.totalMutants = this.totalValid + this.totalInvalid;
        this.mutationScore = this.totalValid > 0 ? this.totalDetected / this.totalValid * 100 : DEFAULT_IF_NO_VALID_MUTANTS;
        this.mutationScoreBasedOnCoveredCode = this.totalValid > 0 ? this.totalDetected / this.totalCovered * 100 || 0 : DEFAULT_IF_NO_VALID_MUTANTS;
    }
}
exports.TableRow = TableRow;
class ResultTable {
    constructor(rows, thresholds) {
        this.rows = rows;
        this.thresholds = thresholds;
    }
    static forFile(name, result, thresholds) {
        return new ResultTable([
            new TableRow(name, result.mutants, false)
        ], thresholds);
    }
}
exports.ResultTable = ResultTable;
//# sourceMappingURL=ResultTable.js.map