"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : new P(function (resolve) { resolve(result.value); }).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const lit_element_1 = require("lit-element");
const helpers_1 = require("../lib/helpers");
const style_1 = require("../style");
const model_1 = require("../model");
const router_1 = require("../lib/router");
let MutationTestReportAppComponent = class MutationTestReportAppComponent extends lit_element_1.LitElement {
    constructor() {
        super(...arguments);
        this.path = [];
        this.subscriptions = [];
    }
    get title() {
        if (this.context) {
            if (this.titlePostfix) {
                return `${this.context.name} - ${this.titlePostfix}`;
            }
            else {
                return this.context.name;
            }
        }
        else {
            return '';
        }
    }
    loadData() {
        return __awaiter(this, void 0, void 0, function* () {
            if (this.src) {
                try {
                    const res = yield fetch(this.src);
                    this.report = yield res.json();
                }
                catch (error) {
                    const e = error.toString();
                    this.errorMessage = e;
                }
            }
        });
    }
    updated(changedProperties) {
        if ((changedProperties.has('path') || changedProperties.has('report')) && this.report) {
            this.updateModel(this.report);
            this.updateContext();
        }
        if (changedProperties.has('src')) {
            this.loadData();
        }
    }
    updateModel(report) {
        this.rootModel = model_1.toDirectoryModel(helpers_1.normalizeFileNames(report.files));
    }
    updateContext() {
        if (this.rootModel) {
            this.context = this.rootModel.find(this.path.join('/'));
        }
    }
    connectedCallback() {
        super.connectedCallback();
        this.subscriptions.push(router_1.locationChange$.subscribe(path => this.path = path));
    }
    disconnectedCallback() {
        super.disconnectedCallback();
        this.subscriptions.forEach(subscription => subscription.unsubscribe());
    }
    render() {
        return lit_element_1.html `
    <mutation-test-report-title .title="${this.title}"></mutation-test-report-title>
    ${this.renderContent()}
    `;
    }
    renderTitle() {
        if (this.context) {
            return lit_element_1.html `<h1 class="display-4">${this.title}</h1>`;
        }
        else {
            return undefined;
        }
    }
    renderContent() {
        if (this.context || this.errorMessage) {
            return lit_element_1.html `<div class="container">
  <div class="row">
    <div class="col-md-12">
      ${this.renderReport()}
      ${this.renderErrorMessage()}
    </div>
  </div>
</div>`;
        }
        else {
            return undefined;
        }
    }
    renderErrorMessage() {
        if (this.errorMessage) {
            return lit_element_1.html `
      <div class="alert alert-danger" role="alert">
        ${this.errorMessage}
      </div>
        `;
        }
        else {
            return lit_element_1.html ``;
        }
    }
    renderReport() {
        if (this.context) {
            return lit_element_1.html `
      ${this.renderTitle()}
      <mutation-test-report-breadcrumb .path="${this.path}"></mutation-test-report-breadcrumb>
      ${this.renderTotals()}
      ${this.renderFileReport()}`;
        }
        else {
            return undefined;
        }
    }
    renderFileReport() {
        if (this.context && this.report && this.context.representsFile) {
            return lit_element_1.html `<mutation-test-report-file .model="${this.context}"></mutation-test-report-file>`;
        }
        else {
            return undefined;
        }
    }
    renderTotals() {
        if (this.report && this.context) {
            return lit_element_1.html `
    <div class='row'>
      <div class='totals col-sm-11'>
        <mutation-test-report-totals .thresholds="${this.report.thresholds}" .model="${this.context}"></mutation-test-report-totals>
      </div>
    </div>
    `;
        }
        else {
            return undefined;
        }
    }
};
MutationTestReportAppComponent.styles = [
    style_1.bootstrap,
    lit_element_1.css `
    :host {
      line-height: 1.15;
      margin: 0;
      font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, "Helvetica Neue", Arial, "Noto Sans", sans-serif, "Apple Color Emoji", "Segoe UI Emoji", "Segoe UI Symbol", "Noto Color Emoji";
      font-size: 1rem;
      font-weight: 400;
      line-height: 1.5;
      color: #212529;
      text-align: left;
      background-color: #fff;
    }
    `
];
__decorate([
    lit_element_1.property({ attribute: false })
], MutationTestReportAppComponent.prototype, "report", void 0);
__decorate([
    lit_element_1.property({ attribute: false })
], MutationTestReportAppComponent.prototype, "rootModel", void 0);
__decorate([
    lit_element_1.property()
], MutationTestReportAppComponent.prototype, "src", void 0);
__decorate([
    lit_element_1.property({ attribute: false })
], MutationTestReportAppComponent.prototype, "errorMessage", void 0);
__decorate([
    lit_element_1.property({ attribute: false })
], MutationTestReportAppComponent.prototype, "context", void 0);
__decorate([
    lit_element_1.property()
], MutationTestReportAppComponent.prototype, "path", void 0);
__decorate([
    lit_element_1.property({ attribute: 'title-postfix' })
], MutationTestReportAppComponent.prototype, "titlePostfix", void 0);
__decorate([
    lit_element_1.property()
], MutationTestReportAppComponent.prototype, "title", null);
MutationTestReportAppComponent = __decorate([
    lit_element_1.customElement('mutation-test-report-app')
], MutationTestReportAppComponent);
exports.MutationTestReportAppComponent = MutationTestReportAppComponent;
//# sourceMappingURL=mutation-test-report-app.js.map