"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
const lit_element_1 = require("lit-element");
const style_1 = require("../style");
const htmlHelpers_1 = require("../lib/htmlHelpers");
let MutationTestReportMutantComponent = class MutationTestReportMutantComponent extends lit_element_1.LitElement {
    constructor() {
        super(...arguments);
        this.show = true;
        this.expand = false;
    }
    render() {
        // This part is newline significant, as it is rendered in a <code> block.
        // No unnecessary new lines
        return lit_element_1.html `${this.renderButton()}${this.renderCode()}`;
    }
    renderButton() {
        if (this.show && this.mutant) {
            return lit_element_1.html `<span class="mutant-toggle badge badge-${this.expand ? 'info' : htmlHelpers_1.getContextClassForStatus(this.mutant.status)}" @click="${() => this.expand = !this.expand}"
  title="${this.mutant.mutatorName}">${this.mutant.id}</span>`;
        }
        return undefined;
    }
    renderCode() {
        return lit_element_1.html `${this.renderReplacement()}${this.renderActual()}`;
    }
    renderActual() {
        const actualCodeSlot = lit_element_1.html `<slot></slot>`;
        return lit_element_1.html `<span class="original-code ${this.expand && this.show ? 'disabled-code' : ''}">${actualCodeSlot}</span>`;
    }
    renderReplacement() {
        if (this.mutant) {
            return lit_element_1.html `<span class="replacement badge badge-info" ?hidden="${!this.expand || !this.show}">${this.mutant.replacement}</span>`;
        }
        return undefined;
    }
};
MutationTestReportMutantComponent.styles = [
    style_1.bootstrap,
    lit_element_1.css `
    .badge {
      cursor: pointer;
    }
    .disabled-code {
      text-decoration: line-through;
    }
  `
];
__decorate([
    lit_element_1.property()
], MutationTestReportMutantComponent.prototype, "mutant", void 0);
__decorate([
    lit_element_1.property()
], MutationTestReportMutantComponent.prototype, "show", void 0);
__decorate([
    lit_element_1.property()
], MutationTestReportMutantComponent.prototype, "expand", void 0);
MutationTestReportMutantComponent = __decorate([
    lit_element_1.customElement('mutation-test-report-mutant')
], MutationTestReportMutantComponent);
exports.MutationTestReportMutantComponent = MutationTestReportMutantComponent;
//# sourceMappingURL=mutation-test-report-mutant.js.map