"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const helpers_1 = require("../lib/helpers");
const TotalsModel_1 = require("./TotalsModel");
exports.TotalsModel = TotalsModel_1.TotalsModel;
const lodash_groupby_1 = __importDefault(require("lodash.groupby"));
const DirectoryResultModel_1 = require("./DirectoryResultModel");
exports.DirectoryResultModel = DirectoryResultModel_1.DirectoryResultModel;
const FileResultModel_1 = require("./FileResultModel");
exports.FileResultModel = FileResultModel_1.FileResultModel;
function toDirectoryModel(files, name = helpers_1.ROOT_NAME, path = '') {
    const totals = new TotalsModel_1.TotalsModel(helpers_1.flatMap(Object.values(files), file => file.mutants));
    const childResults = toChildModels(files, path);
    return new DirectoryResultModel_1.DirectoryResultModel(name, path, totals, childResults);
}
exports.toDirectoryModel = toDirectoryModel;
function toChildModels(files, parent) {
    const filesByDirectory = lodash_groupby_1.default(Object.entries(files), file => file[0].split('/')[0]);
    return Object.keys(filesByDirectory)
        .map(directoryName => {
        if (filesByDirectory[directoryName].length > 1 || filesByDirectory[directoryName][0][0] !== directoryName) {
            const directoryFiles = {};
            filesByDirectory[directoryName].forEach(file => directoryFiles[file[0].substr(directoryName.length + 1)] = file[1]);
            return toDirectoryModel(directoryFiles, directoryName, helpers_1.pathJoin(parent, directoryName));
        }
        else {
            const fileName = filesByDirectory[directoryName][0][0];
            const file = filesByDirectory[directoryName][0][1];
            return new FileResultModel_1.FileResultModel(fileName, helpers_1.pathJoin(parent, fileName), file);
        }
    })
        .sort(compareNames);
}
function compareNames(a, b) {
    const sortValue = (scoreResult) => {
        // Directories first
        if (scoreResult.representsFile) {
            return `1${scoreResult.name}`;
        }
        else {
            return `0${scoreResult.name}`;
        }
    };
    return sortValue(a).localeCompare(sortValue(b));
}
//# sourceMappingURL=index.js.map