"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
const lit_element_1 = require("lit-element");
const style_1 = require("../style");
const helpers_1 = require("../lib/helpers");
let MutationTestReportBreadcrumbComponent = class MutationTestReportBreadcrumbComponent extends lit_element_1.LitElement {
    render() {
        return lit_element_1.html `
        <ol class='breadcrumb'>
          ${this.renderRootItem()}
          ${this.renderBreadcrumbItems()}
        </ol>
    `;
    }
    renderRootItem() {
        if (this.path && this.path.length) {
            return this.renderLink(helpers_1.ROOT_NAME, '#');
        }
        else {
            return this.renderActiveItem(helpers_1.ROOT_NAME);
        }
    }
    renderBreadcrumbItems() {
        if (this.path) {
            const path = this.path;
            return path.map((item, index) => {
                if (index === path.length - 1) {
                    return this.renderActiveItem(item);
                }
                else {
                    return this.renderLink(item, `#${path.filter((_, i) => i <= index).join('/')}`);
                }
            });
        }
        return undefined;
    }
    renderActiveItem(title) {
        return lit_element_1.html `<li class="breadcrumb-item active" aria-current="page">${title}</li>`;
    }
    renderLink(title, url) {
        return lit_element_1.html `<li class="breadcrumb-item"><a href="${url}">${title}</a></li>`;
    }
};
MutationTestReportBreadcrumbComponent.styles = [style_1.bootstrap];
__decorate([
    lit_element_1.property()
], MutationTestReportBreadcrumbComponent.prototype, "path", void 0);
MutationTestReportBreadcrumbComponent = __decorate([
    lit_element_1.customElement('mutation-test-report-breadcrumb')
], MutationTestReportBreadcrumbComponent);
exports.MutationTestReportBreadcrumbComponent = MutationTestReportBreadcrumbComponent;
//# sourceMappingURL=mutation-test-report-breadcrumb.js.map