"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
const lit_element_1 = require("lit-element");
const style_1 = require("../../style");
let MutationTestReportPopupComponent = class MutationTestReportPopupComponent extends lit_element_1.LitElement {
    constructor() {
        super(...arguments);
        this.show = false;
    }
    firstUpdated() {
        if (this.getBoundingClientRect().left < 100) {
            const popover = this.shadowRoot.querySelector('.popover');
            popover.style.marginLeft = '0px';
        }
    }
    getContextClasses() {
        if (this.context) {
            return `bg-${this.context} text-white`;
        }
        else {
            return '';
        }
    }
    render() {
        return lit_element_1.html `<div class="popover ${this.show ? 'show' : 'hide'}">
  <h3 class="popover-header ${this.getContextClasses()}">${this.header}</h3>
  <div class="popover-body">
    <slot name="popover-body"></slot>
  </div>
</div>${slot()}`;
        function slot() {
            return lit_element_1.html `<slot></slot>`;
        }
    }
};
MutationTestReportPopupComponent.styles = [
    style_1.bootstrap,
    lit_element_1.unsafeCSS(require('./mutation-test-report-popup.scss'))
];
__decorate([
    lit_element_1.property()
], MutationTestReportPopupComponent.prototype, "header", void 0);
__decorate([
    lit_element_1.property()
], MutationTestReportPopupComponent.prototype, "content", void 0);
__decorate([
    lit_element_1.property({ converter: val => typeof val === 'string' })
], MutationTestReportPopupComponent.prototype, "show", void 0);
__decorate([
    lit_element_1.property()
], MutationTestReportPopupComponent.prototype, "context", void 0);
MutationTestReportPopupComponent = __decorate([
    lit_element_1.customElement('mutation-test-report-popup')
], MutationTestReportPopupComponent);
exports.MutationTestReportPopupComponent = MutationTestReportPopupComponent;
//# sourceMappingURL=mutation-test-report-popup.js.map