"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const htmlHelpers_1 = require("./htmlHelpers");
/**
 * Class to keep track of the states of the
 * mutants that are active at the cursor while walking the code.
 */
class BackgroundColorCalculator {
    constructor() {
        this.killed = 0;
        this.noCoverage = 0;
        this.survived = 0;
        this.timeout = 0;
        this.markMutantStart = (mutant) => {
            this.countMutant(1, mutant.status);
        };
        this.markMutantEnd = (mutant) => {
            this.countMutant(-1, mutant.status);
        };
        this.determineBackground = () => {
            if (this.survived > 0) {
                return htmlHelpers_1.getContextClassForStatus("Survived" /* Survived */) + '-light';
            }
            else if (this.noCoverage > 0) {
                return htmlHelpers_1.getContextClassForStatus("NoCoverage" /* NoCoverage */) + '-light';
            }
            else if (this.timeout > 0) {
                return htmlHelpers_1.getContextClassForStatus("Timeout" /* Timeout */) + '-light';
            }
            else if (this.killed > 0) {
                return htmlHelpers_1.getContextClassForStatus("Killed" /* Killed */) + '-light';
            }
            return null;
        };
    }
    countMutant(valueToAdd, status) {
        switch (status) {
            case "Killed" /* Killed */:
                this.killed += valueToAdd;
                break;
            case "Survived" /* Survived */:
                this.survived += valueToAdd;
                break;
            case "Timeout" /* Timeout */:
                this.timeout += valueToAdd;
                break;
            case "NoCoverage" /* NoCoverage */:
                this.noCoverage += valueToAdd;
                break;
        }
    }
}
exports.BackgroundColorCalculator = BackgroundColorCalculator;
//# sourceMappingURL=BackgroundColorCalculator.js.map