import { FileResultDictionary } from 'mutation-testing-report-schema';
import { FileResultModel } from '../model';
export declare const ROOT_NAME = "All files";
export declare function flatMap<T, R>(source: T[], fn: (input: T) => R[]): R[];
export declare function pathJoin(...parts: string[]): string;
export declare function normalizeFileNames(input: FileResultDictionary): FileResultDictionary;
export declare function determineCommonBasePath(fileNames: ReadonlyArray<string>): string;
/**
 * Walks over the code in this.model.source and adds the
 * `<mutation-test-report-mutant>` elements.
 * It also adds the background color using
 * `<span class="bg-danger-light">` and friends.
 */
export declare function renderCode(model: FileResultModel): string;
export declare const COLUMN_START_INDEX = 1;
export declare const LINE_START_INDEX = 1;
export declare const NEW_LINE = "\n";
export declare const CARRIAGE_RETURN = "\r";
export declare function lines(content: string): string[];
//# sourceMappingURL=helpers.d.ts.map